
local locale = GetLocale()

if (locale == "enUS" or locale == "enGB") then

    LibItemStatsPatterns = {
        setprefix = "Set:",
        ignore = {
            "^Use",
            "^Chance on hit",
            "Pet.-Attack Power",
        },
        multiple = {
            { key1 = "Healing", key2 = "SpellDamage", pattern = "%+(%d+)治療和%+(%d+)法術傷害(.*)" },
        },
        recursive = {
            "^(.-)/(.+)",
        },
        general = {
            { key = "Armor",     pattern = "Armor$" },
            { key = "Stamina",   pattern = "Stamina" },
            { key = "Agility",   pattern = "Agility" },
            { key = "Strength",  pattern = "Strength" },
            { key = "Intellect", pattern = "Intellect" },
            { key = "Spirit",    pattern = "Spirit" },
            { key = "hp",        pattern = "生命力$" },
            { key = "mp",        pattern = "法力$" },
            { key = "Resilience", pattern = "Resilience" },		
            { key = "Stamina|Agility|Strength|Intellect|Spirit", pattern = "All Stats" },
            { key = "ManaRestore", pattern = "Mana Regen" },
            { key = "ResistanceFrost",  pattern = "Frost Resistance" },
            { key = "ResistanceShadow", pattern = "Shadow Resistance" },
            { key = "ResistanceArcane", pattern = "Arcane Resistance" },
            { key = "ResistanceFire",   pattern = "Fire Resistance" },
            { key = "ResistanceNature", pattern = "Nature Resistance" },
            { key = "ResistanceHoly",   pattern = "Holy Resistance" },
            { key = "ResistanceFrost|ResistanceShadow|ResistanceArcane|ResistanceFire|ResistanceNature|ResistanceHoly", pattern = "所有抗性" },
            { key = "DamageFrost",  pattern = "冰霜傷害" },
            { key = "DamageShadow", pattern = "暗影傷害" },
            { key = "DamageArcane", pattern = "祕法傷害" },
            { key = "DamageFire",   pattern = "火焰傷害" },
            { key = "DamageNature", pattern = "自然傷害" },
            { key = "DamageHoly",   pattern = "神聖傷害" },
            { key = "SpellDamage",         pattern = "傷害法術" },
            { key = "SpellDamage|Healing", pattern = "法術傷害和治療" },
            { key = "SpellDamage|Healing", pattern = "法術治療和傷害" },
            { key = "SpellDamage|Healing", pattern = "法術能量" },
            { key = "SpellDamage|Healing", pattern = "法術傷害" },
            { key = "SpellStrike",         pattern = "法術穿透力" },
            { key = "SpellHitRating",      pattern = "法術命中等級" },
            { key = "SpellCrit",           pattern = "法術致命一擊等級" },
            { key = "Healing", pattern = "法術治療" },
            { key = "Healing", pattern = "治療法術" },
            { key = "Healing", pattern = "治療" },
            { key = "Dodge",   pattern = "閃躲等級" },
            { key = "Parry",   pattern = "招架等級" },
            { key = "Defense", pattern = "Defense" },
            { key = "HitRating", pattern = "命中等級" },
            { key = "RangedAttackPower", pattern = "ranged Attack Power" },		
            { key = "AttackCrit|RangedAttackCrit", pattern = "致命一擊等級" },		
            { key = "AttackPower|RangedAttackPower", pattern = "Attack Power" },
        },
        extra = {
            { key = "Armor", pattern = "(%d+) Armor$" },
            { key = "Block", pattern = "(%d+) Block$" },
            { key = "ManaRestore", pattern = "Restores (%d+) mana per 5 sec" },
            { key = "ManaRestore", pattern = "Restores (%d+) mana every 5 sec" },
            { key = "ManaRestore", pattern = "Mana Regen (%d+) per 5 sec" },
            { key = "ManaRestore", pattern = "Mana Regen (%d+) every 5 sec" },
            { key = "Resilience", pattern = "韌性等級提高(%d+)" },
            { key = "SpellHitRating", pattern = "Improves your chance to hit with spells by (%d+)" },
            { key = "HasteSpell", pattern = "提高法術加速等級(%d+)" },
            { key = "SpellCrit", pattern = "Improves your chance to get a critical strike with spells by (%d+)" },
            { key = "SpellStrike", pattern = "法術穿透力提高(%d+)" },		
            { key = "SpellDamage|Healing", pattern = "Increases damage and healing done by magical spells and effects by up to (%d+)" },
            { key = "Healing", pattern = "Increases healing done by spells and effects by up to (%d+)" },
            { key = "DamageFrost", pattern = "Increases damage done by Frost spells and effects by up to (%d+)" },
            { key = "DamageShadow", pattern = "Increases damage done by Shadow spells and effects by up to (%d+)" },
            { key = "DamageArcane", pattern = "Increases damage done by Arcane spells and effects by up to (%d+)" },
            { key = "DamageFire", pattern = "Increases damage done by Fire spells and effects by up to (%d+)" },
            { key = "DamageNature", pattern = "Increases damage done by Nature spells and effects by up to (%d+)" },
            { key = "DamageHoly", pattern = "Increases damage done by Holy spells and effects by up to (%d+)" },
            { key = "HasteMelee", pattern = "提高加速等級(%d+)" },
            { key = "RangedAttackPower", pattern = "提高遠程攻擊強度(%d+)" },		
            { key = "AttackCrit|RangedAttackCrit", pattern = "Improves your chance to get a critical strike by (%d+)" },		
            { key = "AttackPower|RangedAttackPower", pattern = "提高攻擊強度(%d+)" },
            { key = "HitRating", pattern = "提高命中等級(%d+)" },
            { key = "Parry", pattern = "Increases your chance to parry an attack by (%d+)" },
            { key = "Defense", pattern = "Increased Defense +(%d+)" },
            { key = "Dodge", pattern = "Increases your chance to dodge an attack by (%d+)" },
            { key = "Block", pattern = "Increases the block value of your shield by (%d+)" },
            { key = "ReduceResistance", pattern = "使你法術目標的魔法抗性降低(%d+)點。" },
            { key = "RangedAttackPower", pattern = "遠程攻擊強度提高(%d+)" },		
            { key = "HitRating", pattern = "Improves your chance to hit by (%d+)" },
        },
        percent = {
            { key = "SpellDamage", baseon = "Intellect", pattern = "法術所造成的傷害提高相當於你總智力的(%d+)%%" },
        },
        special = {
            { key = "DamageShadow|DamageFrost", value = 54, pattern = "靈魂冰霜$" },
            { key = "DamageFire|DamageArcane", value = 50, pattern = "烈日火焰$" },
            { key = "ResistanceComa", value = 5, pattern = "昏迷抗性" },
            { key = "ManaRestore|HealthRestore", value = 4, pattern = "活力$" },
            { key = "AttackPower|RangedAttackPower", value = 70, pattern = "野性$" },		
            { key = "MountSpeed", value = 4, pattern = "秘銀馬刺" },
            { key = "MountSpeed", value = 2, pattern = "坐騎移動速度略微提升" },
            { key = "MountSpeed", value = 10, pattern = "坐騎速度提高10%%" },
            { key = "MountSpeed", value = 3, pattern = "坐騎速度提高3%%" },
            { key = "RunSpeed", value = 8, pattern = "Run speed increased slightly" },
            { key = "SpellDamage|Healing", value = 42, pattern = "Brilliant Wizard Oil" },
            { key = "SpellDamage|Healing", value = 16, pattern = "Lesser Wizard Oil" },
            { key = "SpellDamage|Healing", value = 8, pattern = "Minor Wizard Oil" },
            { key = "SpellDamage|Healing", value = 24, pattern = "Wizard Oil" },
            { key = "ManaRestore", value = 14, pattern = "Lesser Mana Oil" },
            { key = "ManaRestore", value = 12, continue = true, pattern = "Brilliant Mana Oil" },
            { key = "Healing", value = 24, continue = true, pattern = "Brilliant Mana Oil" },
        },
        buff = {
            convert = {
                { from = " and ", to = "," },
            },
            { key = "Armor", pattern = "Increases armor by (%d+)"},
            { key = "Stamina", pattern = "Stamina by (%d+)"},
            { key = "Spirit", pattern = "Spirit by (%d+)"},
            { key = "ResistanceShadow", pattern = "暗影抗性提高(%d+)"},
            { key = "Intellect", pattern = "Agility by (%d+)"},
            { key = "ResistanceFrost", pattern = "冰霜抗性提高(%d+)"},
            { key = "Stamina|Agility|Strength|Intellect|Spirit", percent = true, pattern = "all attributes by (%d+)%%"},
            { key = "Stamina|Agility|Strength|Intellect|Spirit", pattern = "all attributes by (%d+)"},
            { key = "ResistanceFrost|ResistanceShadow|ResistanceArcane|ResistanceFire|ResistanceNature|ResistanceHoly", pattern = "all resistances by (%d+)", conflict = true },
            { key = "ManaRestore", pattern = "每5秒恢復(%d+)點法力"},
            { key = "HealthRestore", pattern = "每5秒恢復(%d+)點生命"},
            
            { key = "SpellCrit", percent = true, pattern = "法術造成致命一擊的機率提高(%d+)%%"},
            { key = "Dodge", percent = true, pattern = "閃躲機率提高(%d+)%%"},
            { key = "AttackPower", pattern = "近戰攻擊強度提高(%d+)"},
            { key = "hp", pattern = "生命力上限提高(%d+)"},
            { key = "hp", pattern = "生命力提高(%d+)點"},
            { key = "ResistanceFrost|ResistanceShadow|ResistanceArcane|ResistanceFire|ResistanceNature|ResistanceHoly", pattern = "對所有系別的魔法抗性提高(%d+)"},
            { key = "SpellDamage", pattern = "提高法術傷害加成(%d+)"},
            { key = "RangedAttackPower", pattern = "遠程攻擊強度提高(%d+)"},
            { key = "AttackPower|RangedAttackPower", pattern = "提高攻擊強度(%d+)"},
            { key = "ResistanceNature", pattern = "自然抗性提高(%d+)"},
            { key = "Stamina", pattern = "耐力%+(%d+)點"},
            { key = "Defense", pattern = "防禦等級提高(%d+)"},
            { key = "Healing", pattern = "治療效果提高(%d+)"},
            { key = "Healing", pattern = "治療法術效果提高最多(%d+)"},
            { key = "Agility", pattern = "敏捷提高(%d+)"},
            { key = "Strength", pattern = "力量提高(%d+)"},
            { key = "Spirit", pattern = "精神提高(%d+)"},
            { key = "Intellect|Spirit", pattern = "智力和精神提高(%d+)"},
            { key = "SpellDamage", pattern = "法術傷害和治療效果提高最多(%d+)"},
            { key = "SpellCrit", pattern = "法術致命一擊等級提高(%d+)"},		
            { key = "AttackCrit|RangedAttackCrit", pattern = "致命一擊提高(%d+)"},
            { key = "SpellDamage", pattern = "法術傷害提高(%d+)"},
            { key = "SpellDamage", pattern = "法術傷害提高最多(%d+)"},
            { key = "DamageShadow", baseon = "SpellDamage", percent = true, pattern = "造成的暗影傷害提高(%d+)%%"},
            { key = "ArmorReduce2", pattern = "受到物理攻擊時承受的傷害降低(%d+)%%"},	
        },
        
    }

end