---@type ns
local ns = select(2, ...)

local ENCOUNTER_BOSSES = {
    [709] = {
        name = '预言者斯克拉姆',
        bossId = 709,
        icon = 1385769,
        desc = '预言者斯克拉姆是安其拉神殿的一号BOSS，只有击杀他，才能打开安其拉神殿的大门。',
        summary = {
            children = {
                {
                    role = 'TANK',
                    desc = '1.3个坦克分别站在3个平台上，若BOSS或者分身传送到位置，则第一时间坦住。\n2.打断BOSS或者分身的奥爆技能。',
                }, {
                    role = 'HEALER',
                    desc = '分为2组站在BOSS平台的斜坡上，保持全团的血量。\n牧师、骑士优先驱散已恢复正常的玩家的变形术。\n',
                }, {role = 'MELEE', desc = '输出BOSS，优先打断奥爆技能。'},
                {
                    role = 'RANGE',
                    desc = '分散站位，输出BOSS。\n法师优先对被控制的玩家释放变形术。\n',
                },
            },
        },
        abilities = {
            children = {
                {
                    spell = 785,
                    desc = '随机控制玩家20秒，被控制玩家体型增大，攻击力、移动速度、各种抗性增强，不可驱散。',
                }, {spell = 26192, desc = '对范围15码内玩家造成1500左右奥术伤害。'}, {
                    spell = 26194,
                    desc = '当BOSS仇恨目标不在近战范围内时，会每秒对随机玩家释放震击，造成2500左右伤害。',
                }, {spell = 20449, desc = '随机传送至3个平台的固定位置上，并清空仇恨。'}, {
                    spell = 747,
                    desc = '当BOSS血量降至75%、50%、25%时，会召唤2个分身幻象，幻象具有本体一样的血量和技能。',
                },
            },
        },
    },
    [710] = {
        name = '安其拉三宝',
        bossId = 710,
        icon = 1390436,
        summary = {
            desc = '三个boss，需要4名坦克。优先击杀的BOSS拉离其他2个BOSS位置。',
            children = {
                {
                    role = 'TANK',
                    desc = '三个boss，需要4名坦克。优先击杀的BOSS拉离其他2个BOSS位置。',
                    children = {
                        {
                            title = '亚尔基公主',
                            expanded = true,
                            desc = '1.看时机切换狂暴姿态，确保大部分时间不被恐惧，打断公主的强效治疗术。\n2.公主死后群嘲出现的小怪。',
                        }, {
                            title = '维姆',
                            expanded = true,
                            desc = '维姆冲锋会清除仇恨，2个坦克一个拉住，一个远离，确保仇恨在2个坦克身上。',
                        }, {
                            title = '克里勋爵',
                            expanded = true,
                            desc = '将勋爵拉至远离大团处，若优先击杀其他两个BOSS，则在其他两个BOSS死后迅速拉住勋爵，将其拉回原位。',
                        },
                    },
                }, {
                    role = 'HEALER',
                    desc = '1.分配跟随坦克的治疗优先驱散毒箭。\n2.矮人牧师优先给予公主坦克反恐，期间CD一好就加；萨满插好战栗图腾。\n3.击杀勋爵后迅速远离勋爵尸体。',
                }, {
                    role = 'MELEE',
                    desc = '1.根据击杀顺序输出BOSS。\n2.若安排至公主处，优先打断公主强效治疗术。\n3.击杀勋爵后迅速远离勋爵尸体。',
                }, {
                    role = 'RANGE',
                    desc = '1.根据击杀顺序输出BOSS。2.击杀公主后优先击杀公主召唤出的小怪。3.击杀勋爵后迅速远离勋爵尸体。',
                },
            },
        },
        abilities = {
            desc = '安其拉三宝有三个BOSS：克里勋爵、亚尔基公主、维姆，不同击杀顺序掉落也会不同。',
            children = {
                {
                    title = '维姆',
                    noCollapse = true,
                    children = {
                        {spell = 18670, desc = '击退当前目标。'},
                        {spell = 22120, desc = '随机向一名玩家冲锋，并清除仇恨。'},
                    },
                }, {
                    title = '克里勋爵',
                    noCollapse = true,
                    children = {
                        {
                            spell = 25812,
                            desc = '释放群体毒箭，使40码范围内玩家中毒，每秒受到150自然伤害，可叠加。',
                        }, {spell = 27794, desc = '对当前目标造成3000左右伤害。'},
                        {
                            spell = 24319,
                            desc = '勋爵死后尸体会释放毒云，站在毒云内每秒受到2000点自然伤害。',
                        },
                        {
                            spell = 26068,
                            desc = '维姆死后，勋爵会进入狂暴状态，攻击力和攻击速度提高。',
                        },
                    },
                }, {
                    title = '亚尔基公主',
                    noCollapse = true,
                    children = {
                        {spell = 26580, desc = '恐惧30码内玩家并清空仇恨，持续8秒。'},
                        {spell = 9869, desc = '对当前目标造成3000左右伤害。'},
                        {spell = 25807, desc = '恢复目标25%生命值。'},
                        {
                            title = '召唤小怪',
                            desc = '公主死后会在尸体上召唤8只亚尔基的子嗣，每只15000左右血量。',
                        },
                        {
                            spell = 26068,
                            desc = '维姆死后，公主会进入狂暴状态，攻击力和攻击速度提高。',
                        },
                    },
                },
            },
        },
    },
    [711] = {
        name = '沙尔图拉',
        bossId = 711,
        icon = 1385720,
        desc = '沙尔图拉的战斗是一场运动战，需要躲开BOSS和小怪的旋风斩技能。',
        summary = {
            children = {
                {
                    role = 'TANK',
                    desc = '1.3个副T分别拉住守卫，优先击杀，击杀后辅助主T拉住BOSS仇恨。\n2.主T在BOSS旋风斩后，迅速拉住仇恨。\n3.使用震荡猛击等技能眩晕BOSS。',
                }, {
                    role = 'HEALER',
                    desc = '1.进入战斗后分散站位，远距离治疗。\n2.成为守卫或BOSS目标时往没人的地方跑，目标改变后继续远距离治疗。',
                }, {
                    role = 'MELEE',
                    desc = '1.先击杀守卫，再杀BOSS。\n2.优先使用技能眩晕守卫，释放旋风斩时分散躲开。',
                }, {
                    role = 'RANGE',
                    desc = '1.进入战斗后分散站位，最远距离输出，\n2.先击杀守卫，再杀BOSS。\n3.成为守卫或BOSS目标时往没人的地方跑，目标改变后继续最远距离输出。',
                },
            },
        },
        abilities = {
            children = {
                {title = '精英小怪', desc = 'BOSS身边带有3个守卫，守卫也会释放旋风斩。'},
                {
                    spell = 26084,
                    desc = '对范围10码内玩家造成3000左右伤害，无法打断，旋风斩后清空仇恨。',
                }, {spell = 25174, desc = '造成2000左右伤害，降低护甲效果。'},
                {spell = 19953, desc = 'BOSS血量降至20%进入狂怒状态，攻击力和攻击速度增加。'}, {
                    spell = 23537,
                    desc = '若在10分钟内将BOSS血量降到30%以下，那么在BOSS生命值为20%的时候将会触发狂暴，攻击力增强；若没有在10分钟内将BOSS血量降到30%以下，则BOSS会在20%血量时触发超级狂暴，攻击力是普通狂暴10倍以上。',
                },
            },
        },
    },
    [712] = {
        name = '顽强的范克瑞斯',
        bossId = 712,
        icon = 1385728,
        desc = '整场战斗BOSS会不断召唤大量甲虫和几个精英虫子，需要听从指挥击杀它们。',
        summary = {
            children = {
                {
                    role = 'TANK',
                    desc = '1.分配2个T拉BOSS，分别在BOSS的头和尾处，主T致命伤口叠加层数过多时，副T需要嘲讽，拉住BOSS仇恨。\n2.3T拉小甲虫，确保会不去攻击治疗，甲虫多了可群嘲后等待输出消灭甲虫。\n3.4T随时注意沙虫，刷新后第一时间拉住仇恨，沙虫狂暴后击晕沙虫。',
                }, {
                    role = 'HEALER',
                    desc = '1.和远程DPS站在一起治疗全团。\n2.分配1个治疗给被点名传送走的玩家刷血。\n圣骑士可以在沙虫出现后制裁沙虫。',
                }, {role = 'MELEE', desc = '1.站在BOSS身侧输出。\n2.出现沙虫优先击杀。'}, {
                    role = 'RANGE',
                    desc = '1.和治疗站在一起，输出BOSS。\n2.出现沙虫优先控制击杀。\n3.听指挥释放群攻击杀小甲虫。',
                },
            },
        },
        abilities = {
            children = {
                {
                    spell = 25646,
                    desc = '对BOSS前方攻击范围内的玩家释放，减少目标10%的治疗效果，可叠加。',
                }, {spell = 25832, desc = '战斗期间孵化出大量的甲虫。'}, {
                    spell = 1121,
                    desc = '随机点名一名玩家，将该玩家传送至BOSS周围的巢穴中缠住，无法移动，无法施法，持续8秒。',
                }, {
                    spell = 25831,
                    desc = '战斗期间刷新精英沙虫，沙虫不及时击杀会进入狂暴状态，造成大量伤害。',
                },
            },
        },
    },
    [713] = {
        name = '维希度斯',
        bossId = 713,
        icon = 1385771,
        summary = {
            children = {
                {
                    title = '特殊机制',
                    noCollapse = true,
                    desc = 'BOSS在承受大概200下寒冰箭之后会冻结，冻结状态持续15秒，冻结期间受到一定数量的近战攻击会被打碎，打碎后分裂成小水滴（小水滴数量取决于当前BOSS的生命值）。小水滴在场地的外围出现，不断向场地中心移动，直到聚拢形成BOSS。小水滴不可控制，可被击杀。重新形成的BOSS血量取决于聚拢的小水滴数量，当BOSS血量低于10%时，再被冻结击碎就会死亡。',
                }, {
                    role = 'TANK',
                    desc = '1.主T开场将BOSS拉在场地中间。\n2.BOSS被击碎重新形成时第一时间拉住BOSS仇恨。\n3.若脚下出现毒云，则将BOSS拉离毒云范围。',
                }, {
                    role = 'HEALER',
                    desc = '1.法师组和主T组治疗开场就进，分散站位治疗主T和法师们。\n2.优先驱散中毒。\n3.优先治疗法师和主T，兼顾其他团员。。',
                }, {
                    role = 'MELEE',
                    desc = '1.开场在BOSS门口外等待。\n2.BOSS即将被冻结就进场，等冻结就使用近战攻击击打BOSS。\n3.出小水滴的时候冲上前去，尽量击杀小水滴。\n4.在小水快要滴聚拢时在场地中间使用群攻技能，或者工程炸弹等。\n5.BOSS再度出现则出BOSS门口继续等待。\n6.注意远离毒云。\n7.不断重复以上步骤直至BOSS死亡。',
                }, {
                    role = 'RANGE',
                    children = {
                        {
                            title = '除法师外其他远程DPS',
                            desc = '1.开场在BOSS门口外等待。\n2.BOSS即将被冻结就进场，等冻结就使用近战攻击击打BOSS。\n3.出小水滴的时候尽量击杀小水滴。\n4.在小水滴快要聚拢时在场地中间使用群攻技能，或者工程炸弹等。\n5.BOSS再度出现则出BOSS门口继续等待。\n6.注意远离毒云。\n7.不断重复以上步骤直至BOSS死亡。',
                        }, {
                            title = '法师',
                            desc = '1.进场分散站位，对BOSS使用一级寒冰剑。\n2.BOSS冻结后使用近战攻击击打BOSS。\n3.出小水滴的时候尽量击杀小水滴。\n4.在小水滴快要聚拢时在场地中间使用群攻技能，或者工程炸弹等。\n5.BOSS再度出现则继续对BOSS使用一级寒冰剑。\n6.注意远离毒云。\n7.不断重复以上步骤直至BOSS死亡。',
                        },
                    },
                },
            },
        },
        abilities = {
            children = {
                {
                    title = '特殊机制',
                    noCollapse = true,
                    desc = 'BOSS在承受大概200下寒冰箭之后会冻结，冻结状态持续15秒，冻结期间受到一定数量的近战攻击会被打碎，打碎后分裂成小水滴（小水滴数量取决于当前BOSS的生命值）。小水滴在场地的外围出现，不断向场地中心移动，直到聚拢形成BOSS。小水滴不可控制，可被击杀。重新形成的BOSS血量取决于聚拢的小水滴数量，当BOSS血量低于10%时，再被冻结击碎就会死亡。',
                }, {
                    spell = 25991,
                    desc = '对100码范围内玩家释放群体毒箭，玩家会受到1500左右伤害并中毒，中毒后每秒持续掉血，可叠加。',
                }, {spell = 25993, desc = '对目标造成1500左右的伤害。'}, {
                    spell = 26575,
                    desc = '地面随机出现范围性毒云，站在毒云范围内会受到每秒1500的自然伤害。',
                },
            },
        },
    },
    [714] = {
        name = '哈霍兰公主',
        bossId = 714,
        icon = 1385761,
        desc = '哈霍兰公主需要近战拥有一定的自然抗装备来当沙包，确保BOSS狂暴后可以挡住毒箭不射向大团。',
        summary = {
            children = {
                {
                    role = 'TANK',
                    desc = '需要2个坦克。\n1.主T拉住BOSS，副T在主T叠加3层毒之后接手BOSS，直至主T消除debuff后接回去，如此循环。\n2.BOSS血量降至30%以下后，当前T注意开破斧、盾墙等保命技能。',
                }, {
                    role = 'HEALER',
                    desc = '以主T位置为中心点呈伞型散开，站在远程和近战中间，人与人之间保持一定距离。\n1.分配的德鲁伊注意全程驱散T的睡眠。\n2.BOSS血量30%之前刷好全团的血，不驱散。\n3.BOSS血量30%后注意全团血量，尤其是近战，需要牧师刷群体治疗术。',
                }, {
                    role = 'MELEE',
                    desc = '1.穿上自然抗装备，围着BOSS和主T站位输出。\n2.BOSS血量30%后注意喝自然抗药水保命，开爆发技能输出。',
                }, {
                    role = 'RANGE',
                    desc = '1.以主T位置为中心点呈伞型散开，人与人之间保持一定距离。\n2.站最外围，最远距离输出。\n3.BOSS血量30%后开爆发技能输出。\n4.LR开启自然抗光环，确保近战都能吃到，在BOSS激怒情况下使用宁神射击。',
                },
            },
        },
        abilities = {
            children = {
                {spell = 29653, desc = '对目标造成700点自然伤害，可叠加，最多4层。'},
                {
                    spell = 26180,
                    desc = '使目标陷入沉睡，如果睡眠被驱散，将受到4000点自然伤害。',
                }, {spell = 26051, desc = 'BOSS攻击间隔缩短，持续8秒。'},
                {
                    spell = 26053,
                    desc = '对目标方向释放，每2秒造成750点伤害，具有沉默效果，不可驱散。',
                }, {spell = 26050, desc = '使目标中毒，每2秒受到一次自然伤害，持续30秒。'},
                {spell = 26068, desc = '当BOSS血量降至30%，会不断朝最近的15个目标释放群体毒箭。'},
            },
        },

    },
    [715] = {
        name = '双子皇帝',
        bossId = 715,
        icon = 1390437,
        desc = '两个BOSS共享生命值，靠近60码内就会互相治疗，间隔大约30秒会互换位置。维克尼拉斯大帝免疫魔法伤害，维克洛尔大帝免疫物理伤害。',
        summary = {
            children = {
                {
                    role = 'TANK',
                    desc = '每个BOSS都需要一个战士T和一个高暗抗术士T。副T拉好维克尼拉斯大帝（剑皇）边上变大的甲虫。',
                    children = {
                        {
                            title = '开怪时',
                            expanded = true,
                            desc = '1.左边术士T开维克洛尔大帝（魔皇），将BOSS拉到指定位置后站在BOSS10码外使用技能拉住仇恨。\n2.右边战士T拉维克尼拉斯大帝（剑皇），拉到指定位置后靠墙站。',
                        }, {
                            title = '进入循环后',
                            expanded = true,
                            desc = '1.战士T接手传送过来的剑皇，拉到指定位置后靠墙站。\n2.术士T接手传送过来的魔皇，站在BOSS10码外使用技能拉住仇恨。\n3.传送后，在术士T没有拉到魔皇仇恨之前，战士T需要与魔皇保持10码距离。',
                        },
                    },
                }, {
                    role = 'HEALER',
                    desc = '1.按照指挥分配站好左右两边，最远距离加好坦克，呈伞形分散站位。\n2.维克洛尔大帝（剑皇）时，过量治疗好当前战士T。\n3.维克尼拉斯大帝（魔皇）时，确保战士T血量后，过量治疗好术士T。\n4.注意躲开爆炸虫和暴风雪。',
                }, {
                    role = 'MELEE',
                    desc = '1.BOSS全程战斗不使用任何的群攻技能。\n2.全程对着维克尼拉斯大帝（剑皇）输出，在两个BOSS传送前跑向对面，确保远离维克洛尔大帝（魔皇）。\n3.跑动过程中注意躲开爆炸虫和暴风雪。',
                }, {
                    role = 'RANGE',
                    desc = '1.BOSS全程战斗不使用任何的群攻技能。\n2.优先击杀维克洛尔大帝（剑皇）边上变大，并为主动攻击的甲虫。\n3.空余时间可最远距离对维克尼拉斯大帝（魔皇）输出，传送前停止攻击。\n4.跑动过程中注意躲开爆炸虫和暴风雪。\n5.若有玩家引到黄色小甲虫，需要远程帮助清理。',
                },
            },
        },
        abilities = {
            children = {
                {
                    title = '维克尼拉斯大帝（剑皇）',
                    noCollapse = true,
                    children = {
                        {spell = 26007, desc = '对目标造成3000左右伤害，并将其击退。'},
                        {
                            spell = 26613,
                            desc = '对当前目标释放，造成大量物理伤害并使其防御值降低，持续6秒。',
                        },
                        {
                            spell = 802,
                            desc = '随机将身边的甲虫变大，甲虫生命值和伤害提高，并变为主动攻击。',
                        },
                    },
                }, {
                    title = '维克洛尔大帝（魔皇）',
                    noCollapse = true,
                    children = {
                        {spell = 26006, desc = '对当前目标释放，造成3000左右暗影伤害。'}, {
                            spell = 568,
                            desc = '当有人近身时，对10码范围内所有玩家造成3000左右奥术伤害，击退并减速。',
                        },
                        {spell = 26607, desc = '随机对某一区域释放，减速并造成1300左右冰霜伤害。'},
                        {
                            spell = 804,
                            desc = '使身边的甲虫在3秒内爆炸，对甲虫周围的玩家造成大量伤害。',
                        },
                    },
                },
            },
        },
    },
    [716] = {
        name = '奥罗',
        bossId = 716,
        icon = 1385760,
        desc = '整场战斗BOSS在地面上时需要保持合适的距离，BOSS下地时则全团移动，确保不会被土堆追上。',
        summary = {
            children = {
                {
                    role = 'TANK',
                    desc = '1.主T和治疗、输出对角站位，副T站主T边上。\n2.BOSS开展后确保仇恨，被击退后迅速返回。\n3.沙尘爆裂前后退，释放完迅速跑回。\n4.BOSS下地后和队友一起整体跑动，确保BOSS出来后第一时间拉到BOSS。\n5.主T中沙尘爆裂后，副T速度跑至主T位置接手仇恨。\n6.出现小甲虫后，副T拉住甲虫。',
                }, {
                    role = 'HEALER',
                    desc = '1.分配T的治疗站T后面位置。\n2.大团治疗站在远程输出位置。\n3.BOSS下地后和队友一起整体跑动。\n4.BOSS出来站位好继续治疗。\n5.躲开土堆，出现小甲虫后跑向副T位置。',
                }, {
                    role = 'MELEE',
                    desc = '1.站主T对面输出。\n2.横扫前后退，释放完迅速跑回。\n3.BOSS下地后和队友一起整体跑动。\n4.BOSS出来站T对面继续输出。\n5.躲开土堆，出现小甲虫后优先击杀或控制小甲虫。 ',
                }, {
                    role = 'RANGE',
                    desc = '1.站主T对面最远距离输出。\n2.BOSS下地后和队友一起整体跑动。\n3.BOSS出来站T对面继续输出。\n4.躲开土堆，出现小甲虫后优先击杀或控制小甲虫。 ',
                },
            },
        },
        abilities = {
            children = {
                {spell = 26100, desc = '击退当前目标并造成大量伤害。'},
                {spell = 26103, desc = '对近战范围内所有玩家造成2500左右伤害并击退。'}, ---
                {
                    spell = 26102,
                    desc = '对仇恨最高玩家方向180度范围内释放，造成3000左右自然伤害，眩晕5秒并清除仇恨。',
                }, ---
                {
                    spell = 26058,
                    desc = '奥罗潜入地下，召唤奥罗土堆追击目标，接触到土堆玩家均会受到伤害，30秒后土堆释放出小甲虫。',
                }, {spell = 26615, desc = 'BOSS血量降至20%时进入狂暴状态，攻击速度提高150%。'},
            },
        },
    },
    [717] = {
        name = '克苏恩',
        bossId = 717,
        icon = 1385726,
        desc = '克苏恩全程战斗分为2个阶段，P1阶段只在外场，根据指挥分配8个队伍呈8个方向辐射分散站位（保持10码范围内无其他玩家）。击杀眼球之后出现克苏恩本体进入P2阶段。P2阶段分为内外两部分，将内场的两根血肉触须击杀之后，克苏恩进入虚弱阶段，才能在外场对克苏恩造成伤害。',
        summary = {
            children = {
                {
                    role = 'TANK',
                    children = {
                        {
                            title = 'P1阶段',
                            desc = '1.根据指挥分配，和主T保持10码距离进入战斗场地，并站好位置输出。\n2.输出时确保周围10码无其他玩家，实在近战人多，则可以和其他近战重合站位，不超过2人。\n3.当红光出现时，注意自身位置，躲好红光。移动时可帮忙击杀眼球触须和利爪触须，红光结束则返回原地。',
                        }, {
                            title = 'P2阶段',
                            desc = '1.根据指挥所说站位（集中站位或者站P1阶段的位置）。\n2.第一时间击杀巨眼触须、巨型利爪触须和附近的眼球触须。\n3.打断好巨眼触须和眼球触须的读条。\n4.若被吞噬进克苏恩内场，则迅速出来返回外场。\n5.BOSS虚弱时爆发输出。',
                        },
                    },
                }, {
                    role = 'HEALER',
                    children = {
                        {
                            title = 'P1阶段',
                            desc = '1.根据指挥分配，和主T保持10码距离进入战斗场地，并于本队近战身后呈伞形散开，和周围玩家保持10码距离站好位置治疗。\n2.当红光出现时，躲好红光，红光结束则返回原地。',
                        }, {
                            title = 'P2阶段',
                            desc = '1.根据指挥所说站位加血（集中站位或者站P1阶段的位置），优先治疗中精神鞭笞玩家。\n2.若被吞噬进克苏恩内场，给内场DPS加血，消化酸液叠加至5层就迅速出来返回外场。\n3.BOSS虚弱时辅助输出。',
                        },
                    },
                }, {
                    role = 'MELEE',
                    children = {
                        {
                            title = 'P1阶段',
                            desc = '1.根据指挥分配，和主T保持10码距离进入战斗场地，并站好位置输出。\n2.输出时确保周围10码无其他玩家，实在近战人多，则可以和其他近战重合站位，不超过2人。\n3.当红光出现时，注意自身位置，躲好红光。移动时可帮忙击杀眼球触须和利爪触须，红光结束则返回原地。\n',
                        }, {
                            title = 'P2阶段',
                            desc = '1.根据指挥所说站位（集中站位或者站P1阶段的位置）。\n2.第一时间击杀巨眼触须、巨型利爪触须和附近的眼球触须。\n3.打断好巨眼触须和眼球触须的读条。\n4.若被吞噬进克苏恩内场，则迅速出来返回外场。\n5.BOSS虚弱时爆发输出。',
                        },
                    },
                }, {
                    role = 'RANGE',
                    children = {
                        {
                            title = 'P1阶段',
                            desc = '1.根据指挥分配，和主T保持10码距离进入战斗场地，并于本队近战身后呈伞形散开，和周围玩家保持10码距离站好位置输出。\n2.输出时确保周围10码无其他玩家，第一时间击杀附近的眼球触须和利爪触须，注意打断眼球触须读条。\n3.当红光出现时，注意自身位置，躲好红光。移动时击杀眼球触须和利爪触须，红光结束则返回原地。',
                        }, {
                            title = 'P2阶段',
                            desc = '1.根据指挥所说站位（集中站位或者站P1阶段的位置）。\n2.第一时间打断眼球触须技能，并迅速击杀。\n3.远程输出巨眼触须和眼球触须。\n4.若被吞噬进克苏恩内场，站上平台攻击血肉触须，消化酸液叠加至5层就迅速出来返回外场。\n5.BOSS虚弱时爆发输出。',
                        },
                    },
                },
            },
        },
        abilities = {
            children = {
                {
                    title = 'P1克苏恩之眼阶段',
                    noCollapse = true,
                    children = {
                        {
                            spell = 26134,
                            desc = '随机对一名玩家造成大量自然伤害，若该玩家10码范围内有另一名玩家，则伤害跳转至另一名玩家并伤害翻倍，无限递增。',
                        }, {
                            spell = 26029,
                            desc = '每隔45秒BOSS会随机盯着一个方向，3秒后射出红色光线，并随机方向转动红光180度左右，持续40秒，期间触碰到红光的玩家会被秒杀。',
                        }, {
                            title = '眼球触须',
                            desc = '每隔45秒会在BOSS周围黑水边界上固定8个位置刷新眼球触须，眼球触须技能如下：',
                            children = {
                                {
                                    spell = 26478,
                                    desc = '触须刷新时，对附近玩家造成1500左右伤害并击飞。',
                                },
                                {
                                    spell = 18808,
                                    desc = '对随机玩家释放，每秒造成750点暗影伤害并降低移动速递，持续10秒。',
                                },
                            },
                        }, {
                            title = '利爪触须',
                            desc = '随机位置召唤，对附件玩家造成少量物理伤害，若近战范围内10秒没有玩家，则下地在其他玩家脚下重新刷新，触须技能如下：',
                            children = {
                                {
                                    spell = 26478,
                                    desc = '触须刷新时，对附近玩家造成1500左右伤害并击飞。',
                                }, {spell = 26141, desc = '降低玩家移动速度，持续10秒。'},
                            },
                        },
                    },
                }, {
                    title = 'P2克苏恩阶段',
                    desc = 'BOSS本体受到所有伤害降低99%。需击杀内场触须方可进入虚弱状态，虚弱阶段克苏恩将受到100%全额伤害。',
                    noCollapse = true,
                    children = {
                        {
                            title = '眼球触须',
                            desc = '每隔45秒会在BOSS周围黑水边界上固定8个位置刷新眼球触须，眼球触须技能如下：',
                            children = {
                                {
                                    spell = 26478,
                                    desc = '触须刷新时，对附近玩家造成1500左右伤害并击飞。',
                                },
                                {
                                    spell = 18808,
                                    desc = '对随机玩家释放，每秒造成750点暗影伤害并降低移动速递，持续10秒。',
                                },
                            },
                        }, {
                            title = '巨钩触须',
                            desc = '每隔60秒，会在随机玩家脚下刷新，造成高额伤害。技能如下：',
                            children = {
                                {
                                    spell = 26478,
                                    desc = '触须刷新时，对附近玩家造成1500左右伤害并击飞。',
                                }, {
                                    spell = 7201,
                                    desc = '若近战范围内没有玩家，则大触须潜入地下恢复全部生命值并在随机其他玩家脚下出现。',
                                }, {spell = 11607, desc = '攻击时可能造成额外一次攻击。'},
                                {spell = 6524, desc = '击倒附件所有玩家，并造成2秒昏迷效果。'},
                            },
                        }, {
                            title = '巨眼触须',
                            desc = '每隔60秒，会在随机玩家脚下刷新，刷新时造成击飞效果，并释放眼棱（26134）。',
                        }, {
                            title = '巨口触须',
                            desc = 'BOSS召唤巨口触须，将随机玩家吞噬进内场。内场技能如下：',
                            children = {
                                {
                                    spell = 26476,
                                    desc = '处于克苏恩体内时，每5秒受到一次自然伤害，可无限叠加。',
                                }, {
                                    title = '血肉触须',
                                    desc = '克苏恩体内有2根血肉触须，会对附近玩家造成物理伤害。当血肉触须均被击杀，则克苏恩进入虚弱阶段，持续45秒。',
                                }, {
                                    title = '注意',
                                    noCollapse = true,
                                    desc = '玩家站在两根触须中间的平台上，则会被呕吐出体内，回到外场。',
                                },
                            },
                        },
                    },
                },
            },
        },
    },
    -- naxx
    [1107] = {
        name = '阿努布雷坎',
        bossId = 1107,
        zone = 1,
        icon = 1378964,
        url = 'https://www.bilibili.com/video/BV1dr4y1w7gW',
        summary = {
            children = {
                {
                    role = 'TANK',
                    desc = '1.开战后，主T需要将BOSS拉在房间最里面的角落上。\n2.在BOSS释放虫群风暴时，主T需要沿着房间右边的水沟风筝BOSS，保持一定距离不受虫群伤害，又确保BOSS沿着水沟移动远离其他玩家，在虫群风暴结束后将BOSS拉至房间入口处。第二轮虫群风暴开始时沿原路风筝BOSS回到最里面的角落，一直循环即可。\n3.2名副T在战斗开始后拉住BOSS边上的地穴卫士，将精英怪拉至房间左边，靠近水沟处击杀，2只地穴卫士死亡位置尽量靠在一起。后续召唤的地穴卫士都需要副T拉住并击杀于同一位置。',
                }, {
                    role = 'HEALER',
                    desc = '1.战斗开始后在场地中间分散站位治疗。\n2.治疗好被穿刺的玩家，确保在掉落地面时不会被摔死。\n3.虫群风暴开始后往场地左边靠，确保不会吃到虫群风暴。随时注意主T的血量。',
                }, {
                    role = 'MELEE',
                    desc = '1.战斗开始后先击杀地穴卫士，击杀后去输出BOSS。\n2.虫群风暴期间远离BOSS，击杀召唤出来的虫群卫士。',
                }, {
                    role = 'RANGE',
                    desc = '1.战斗开始后先击杀地穴卫士，之后于场地左半部分散开，最远距离输出BOSS。\n2.虫群风暴期间远离BOSS，击杀召唤出来的虫群卫士。\n3.法师尽量靠近地穴卫士尸体分散站位，在甲虫被召唤出来之后第一时间控制击杀。\n4.安排接引主T的猎人，站在场地右边中间输出，一旦虫群风暴，立即开启豹群接应主T，确保主T移动速度不会吃到虫群风暴。',
                },
            },
        },
        abilities = {
            desc = 'BOSS会释放虫群风暴，期间会使范围内玩家受到大量伤害，但是BOSS移动速度会降低，需要主T在虫群风暴期间拉着BOSS跑，直到技能结束。',
            children = {
                {spell = 28783, desc = '随机朝一个方向释放穿刺，并击飞同一直线方向上的玩家。'},
                {
                    spell = 28785,
                    desc = '战斗开始后，每隔一段时间BOSS会释放出一簇虫群，使BOSS移动速度降低并对附近玩家造成伤害，且附近玩家无法攻击BOSS或者施法，持续20秒。',
                },
                {

                    title = '召唤地穴卫士',
                    desc = 'BOSS在释放虫群风暴同时会召唤一只地穴卫士（精英怪）。',
                },
                {

                    title = '召唤甲虫',
                    desc = 'BOSS会随机从地穴卫士尸体或玩家的尸体上召唤出甲虫。',
                },
            },
        },
    }, --
    [1110] = {
        name = '黑女巫法琳娜',
        bossId = 1110,
        zone = 1,
        icon = 1378980,
        url = 'https://www.bilibili.com/video/BV1dr4y1w7gW?p=2',
        summary = {
            children = {
                {
                    role = 'TANK',
                    desc = '1.开战后主T将BOSS拉在平台中间。\n2.其余6个小怪需要6个副T拉住，优先击杀追随者。\n3.拉住膜拜者的4个副T站在台子的左手边，需要牧师控制时，听指挥将一个膜拜者拉往台子边缘方便牧师控制。',
                }, {
                    role = 'HEALER',
                    desc = '1.战斗开始后分散站位，躲好火雨，治疗好中毒箭的玩家。\n2.控制膜拜者的牧师听从指挥，在BOSS狂乱前控制膜拜者靠近BOSS，狂乱时对BOSS使用技能即可（使用技能后膜拜者就会死亡）。',
                }, {role = 'MELEE', desc = '战斗开始后优先击杀2个追随者，随后输出BOSS。'}, {
                    role = 'RANGE',
                    desc = '1.战斗开始后优先击杀2个追随者，随后输出BOSS。\n2.分散站位，躲好火雨。',
                },
            },
        },
        abilities = {
            desc = '法琳娜身边有2个追随者和4个膜拜者，牧师控制膜拜者后，可以使用膜拜者技能解除BOSS的狂乱效果并使BOSS在30秒内无法使用自然法术（群体毒箭）。',
            children = {
                {
                    spell = 28796,
                    desc = '向玩家喷射毒液造成自然伤害，并在接下来的8秒内每2秒造成一次额外伤害，可驱散。',
                }, {spell = 28794, desc = '随机区域召唤火焰之雨，对范围内玩家造成火焰伤害。'},
                {
                    spell = 28798,
                    desc = 'BOSS攻击速度提高50%，对玩家造成的伤害提高。膜拜者解除BOSS狂乱技能为黑女巫的拥抱（28732）：阻止并移除目标的狂乱效果，使目标在30秒内无法释放自然法术，施法速度降低。',
                },
            },
        },
    }, --
    [1116] = {
        name = '迈克斯纳',
        bossId = 1116,
        zone = 1,
        icon = 1378994,
        url = 'https://www.bilibili.com/video/BV1dr4y1w7gW?p=3',
        summary = {
            children = {
                {
                    role = 'TANK',
                    desc = '1.进入战斗后，主T将BOSS拉在原位，使BOSS背对所有玩家即可。\n2.蛛网喷射（全团缠绕）前和BOSS狂暴时注意开保命技能。',
                }, {
                    role = 'HEALER',
                    desc = '1.分配治疗上墙玩家的治疗者，靠近墙边站位，在BOSS释放技能时速度给上墙玩家治疗。（需要在被蛛网包裹前上好治疗手段，蛛网包裹后无法治疗）\n2.蛛网喷射（全团缠绕）前给主T加好所有持续性治疗手段，套好盾，确保主T可以抗住4秒。\n注意：第一时间驱散主T身上的毒。',
                }, {
                    role = 'MELEE',
                    desc = '1.进入战斗后站在BOSS背后输出，若被弹上墙，下来后迅速返回输出BOSS。\n2.BOSS召唤小蜘蛛后迅速使用群攻技能击杀。',
                }, {
                    role = 'RANGE',
                    desc = '1.分配解救上墙玩家的远程按指挥分配站位，若有玩家上墙，迅速按tab键选取目标，第一时间击杀蛛网解救玩家。\n2.其余远程和近战一起站位输出BOSS，召唤出小蜘蛛优先击杀。',
                },
            },
        },
        abilities = {
            desc = '战斗期间会有随机3名玩家被BOSS弹射上墙，位置在靠近入口的墙面上，需要迅速解救。',
            children = {
                {

                    title = '蛛网束缚',
                    desc = 'BOSS随机将3名玩家弹至墙上并用蛛网包裹住，被上墙玩家会受到持续的自然伤害，蛛网有血条，可被打破。',
                }, {spell = 29484, desc = '使用蛛网缠绕所有玩家，使玩家昏迷，持续4秒。'},
                {title = '召唤蜘蛛', desc = 'BOSS会周期性的召唤出小蜘蛛（普通怪）。'},
                {title = '死灵毒药', desc = '使目标在30秒内治疗效果降低90%，可驱散。'},
                {title = '狂乱', desc = 'BOSS血量30%后会狂乱，使BOSS攻击速度提高50%，伤害提高。'},
            },
        },
    }, --
    [1117] = {
        name = '瘟疫使者诺斯',
        bossId = 1117,
        zone = 2,
        icon = 1379004,
        url = 'https://www.bilibili.com/video/BV1dr4y1w7gW?p=4',
        summary = {
            children = {
                {
                    role = 'TANK',
                    desc = 'BOSS战斗需要5个T，主T和副T拉BOSS，其余三个T需要分别站在3个骨堆边坦住召唤出的小怪。\n1.主T开怪，将BOSS拉在房间正中间，副T站在人群，等待BOSS闪现清仇恨后拉住BOSS，然后主T站在人群，等待BOSS下次闪现清仇恨后拉住，两个T一直循环。\n2.BOSS从平台下来之后会回到房间正中间，主T提早站位拉住BOSS，副T人群等待。\n3.3个小怪T分别面朝骨堆，出现小怪就拉住仇恨，BOSS上墙后出现的瘟疫勇士等怪拉在人群外围等待击杀。',
                }, {
                    role = 'HEALER',
                    desc = '1.根据指挥每个拉小怪的T都分配2个治疗，其他人则治疗主副T和人群。\n2.所有治疗尽量靠近人群站位，方便T在BOSS闪现后拉走BOSS。\n注意：德鲁伊第一时间驱散BOSS释放的群体诅咒。牧师可以在小怪多的时候锁住瘟疫战士。',
                }, {
                    role = 'MELEE',
                    desc = '1.进入战斗后对BOSS输出。BOSS闪现时停止输出，等T拉住仇恨之后再输出。\n2.BOSS上墙后帮助击杀小怪，第二次上墙后优先控制击杀瘟疫卫士（奥爆法系怪）。\n3.3个小怪T分别面朝骨堆，出现小怪就拉住仇恨，BOSS上墙后出现的瘟疫勇士等怪拉在人群外围等待击杀。',
                }, {
                    role = 'RANGE',
                    desc = '1.集中站位，优先帮助3个小怪T击杀召唤出的精英怪。\n2.小怪击杀完之后再输出BOSS，BOSS闪现时停止输出，等T拉住仇恨之后再输出。\n3.BOSS第二次上墙后优先控制击杀瘟疫卫士（奥爆法系怪），第三次上墙仍旧优先击杀瘟疫卫士，然后是构造体，再是瘟疫勇士。\n注意：法师第一时间驱散BOSS释放的群体诅咒。',
                },
            },
        },
        abilities = {
            desc = '诺斯在战斗过程中会一直召唤3个精英小怪，每隔15秒小怪刷新在房间骨堆上。每隔一段时间BOSS还会传送到墙上的平台召唤更多的精英小怪，期间无法被攻击。',
            children = {
                {
                    spell = 29213,
                    desc = '每隔45秒使BOSS身边的人受到诅咒，如果10秒内未被驱散，则周围的玩家都会遭受到一波暗影伤害。',
                }, ---
                {title = '闪现', desc = '每隔45秒BOSS随机闪现至一个方向，并清除仇恨。'}, ---
                {

                    title = '残废术',
                    desc = 'BOSS释放闪现时对近战范围内玩家释放，降低玩家移动速度和攻击速度，可驱散。',
                }, {

                    title = '召唤',
                    desc = '每隔15秒，BOSS会从房间3个骨堆上各召唤一个瘟疫战士（精英小怪）。',
                }, {

                    title = '上墙',
                    desc = '每隔一段时间BOSS会上到平台上，无法被攻击，期间会在骨堆上召唤更多的精英小怪，每一次上墙召唤的小怪都比上一次更多，小怪全部被击杀或者时间到达BOSS将会闪现回房间正中位置。第一次召唤4个瘟疫勇士（吃任何控制技能），第二次召唤4个瘟疫勇士+2个瘟疫卫士（会奥爆的法系，无法控制，可眩晕），第三次召唤4个瘟疫勇士+2个瘟疫卫士+2个构造体（会顺劈斩，免疫控制）。',
                },
            },
        },
    }, --
    [1112] = {
        name = '肮脏的希尔盖',
        bossId = 1112,
        zone = 2,
        icon = 1378984,
        url = 'https://www.bilibili.com/video/BV1dr4y1w7gW?p=5',
        summary = {
            children = {
                {
                    role = 'TANK',
                    desc = 'BOSS所站台子为扇柄，台子以下区域为扇叶，将扇叶均分为4块区域（从门口至里面分别编号为1-2-3-4号）。\nP1阶段：主T开战后将BOSS拉至门口1号区域，等待其他区域熔岩喷射后移动至2号区域，再下一次熔岩喷射后移动到3号，再下一次为4号，然后还是在熔岩喷射后回到3号位置，再是2号、1号、2号、3号。（总体跑动区域顺序为1-2-3-4-3-2-1-2-3）\nP2阶段：不需要拉BOSS，回到1区域站定，仍旧按照1-2-3-4-3-2-1-2-3的顺序在4个区域内跑动躲开熔岩喷射，直到P2阶段结束。\nP2结束重新进入P1阶段，开始循环。\n注意：2阶段熔岩喷射速度会加快，集中精神注意跑动。',
                }, {
                    role = 'HEALER',
                    desc = 'BOSS所站台子为扇柄，台子以下区域为扇叶，将扇叶均分为4块区域（从门口至里面分别编号为1-2-3-4号）。\nP1阶段：站在台子上最远距离治疗，优先驱散T和近战的疾病。被随机传送进隔壁通道时，靠右边墙，边走边击杀触须，朝通道远处的出口跑出去即可。（无需击杀小虫子）\nP2阶段：到门口的1区域站定，跟随主T，按照1-2-3-4-3-2-1-2-3的顺序在4个区域内跑动躲开熔岩喷射。直到P2阶段结束。\nP2结束重新进入P1阶段，开始循环。',
                }, {
                    role = 'MELEE',
                    desc = 'BOSS所站台子为扇柄，台子以下区域为扇叶，将扇叶均分为4块区域（从门口至里面分别编号为1-2-3-4号）。\nP1阶段：跟随主T按照1-2-3-4-3-2-1-2-3的顺序在4个区域内跑动躲开熔岩喷射。 跑动期间输出。被随机传送进隔壁通道时，靠右边墙，边走边击杀触须，朝通道远处的出口跑出去即可。（无需击杀小虫子）\nP2阶段：到门口的1区域站定，跟随主T，按照1-2-3-4-3-2-1-2-3的顺序在4个区域内跑动躲开熔岩喷射。直到P2阶段结束。\nP2结束重新进入P1阶段，开始循环。',
                }, {
                    role = 'RANGE',
                    desc = 'BOSS所站台子为扇柄，台子以下区域为扇叶，将扇叶均分为4块区域（从门口至里面分别编号为1-2-3-4号）。\nP1阶段：站在台子上最远距离输出。被随机传送进隔壁通道时，靠右边墙，边走边击杀触须，朝通道远处的出口跑出去即可。（无需击杀小虫子）\nP2阶段：到门口的1区域站定，跟随主T，按照1-2-3-4-3-2-1-2-3的顺序在4个区域内跑动躲开熔岩喷射。直到P2阶段结束。\nP2结束重新进入P1阶段，开始循环。',
                },
            },
        },
        abilities = {
            children = {
                {
                    title = 'P1阶段',
                    noCollapse = true,
                    children = {
                        {

                            title = '疾病',
                            desc = '对10码范围内近战释放疾病，疾病会降低血量上限的50%，并每3秒造成500伤害。',
                        }, ---
                        {

                            title = '法力燃烧',
                            desc = '对30码范围释放，吸收大量法力，并造成等量伤害。',
                        }, ---
                        {

                            title = '熔岩喷射',
                            desc = '每隔10秒地面以固定规律喷射熔岩，造成每下4000左右自然伤害。',
                        }, ---
                        {

                            title = '传送',
                            desc = '每隔一段时间随机传送3名玩家至隔壁通道。\n通道通道内存在眼球触须和蛆虫，BOSS进入P2时，通道会出现毒云，每3秒造成4000左右伤害。',
                        }, {
                            title = '通道',
                            desc = '通道内存在眼球触须和蛆虫，BOSS进入P2时，通道会出现毒云，每3秒造成4000左右伤害。',
                            children = {
                                {

                                    title = '眼球触须',
                                    desc = '会释放精神鞭笞，每秒造成750伤害，杀死后半分钟刷新。',
                                }, ---
                                {title = '蛆虫', desc = '移动速度慢，可脱离战斗。'},
                            },
                        },
                    },
                }, {
                    title = 'P2阶段',
                    desc = '进入战斗90秒后，BOSS回到平台，释放疾病之云。',
                    noCollapse = true,
                    children = {
                        {

                            title = '疾病',
                            desc = '给周围10码左右的玩家一个Debuff，每5秒造成4000伤害。',
                        }, ---
                        {

                            title = '疾病',
                            desc = '地面以固定规律喷射熔岩，造成每下4000左右自然伤害，P2阶段喷射时间间隔变短。',
                        },
                    },
                },
            },
        },
    }, --
    [1115] = {
        name = '洛欧塞布',
        bossId = 1115,
        zone = 2,
        icon = 1378991,
        url = 'https://www.bilibili.com/video/BV1dr4y1w7gW?p=6',
        summary = {
            children = {
                {
                    role = 'TANK',
                    desc = '战斗开始主T将BOSS拉在房间中间，拉住仇恨即可，不需要副T。',
                }, {
                    role = 'HEALER',
                    desc = '1.战斗开始前喝暗抗药水，战斗开始后所有治疗法术、驱散法术每分钟只能释放一次，听从指挥按照顺序给MT治疗。\n2.治疗冷却期间可以输出BOSS。若有需要，可以听指挥跟DPS一起去吃孢子。\n3.战斗全程期间不能治疗自己，每一次必然厄运结束后听指挥吃治疗石、补暗抗药水、或者是绑绷带等，确保自己血量足够。',
                }, {
                    role = 'MELEE',
                    desc = '1.战斗开始前喝暗抗药水，进战斗后输出BOSS。\n2.听指挥轮到自己队伍时去孢子刷新地点击杀孢子后返回全力输出BOSS。\n3.战斗全程期间不会受到任何治疗，每一次必然厄运结束后听指挥吃治疗石、补暗抗药水、或者是绑绷带等，确保自己血量足够。',
                }, {
                    role = 'RANGE',
                    desc = '1.战斗开始前喝暗抗药水，进战斗后输出BOSS。\n2.听指挥轮到自己队伍时去孢子刷新地点靠近孢子，等孢子被击杀后返回全力输出BOSS。\n3.战斗全程期间不会受到任何治疗，每一次必然厄运结束后听指挥吃治疗石、补暗抗药水、或者是绑绷带等，确保自己血量足够。\n注意：术士可以多制作治疗石分给全团。',
                },
            },
        },
        abilities = {
            desc = '洛欧塞布整场战斗所有治疗每分钟只能治疗一次，期间可以帮助输出BOSS。',
            children = {
                {
                    spell = 29204,
                    desc = '战斗开始2分钟后，BOSS会对所有玩家释放必然的厄运诅咒，10秒后受到大量暗影伤害，之后每隔30秒释放一次，五分钟后会15秒释放一次。',
                }, ---
                {
                    title = '腐化心灵',
                    desc = '战斗开始后，所有治疗法术、驱散法术每分钟只能释放一次。',
                }, ---
                {
                    spell = 29234,
                    desc = '战斗开始后BOSS背后墙边会刷新孢子，血量很少，打掉后会使附近最多5位玩家近战暴击提高50%、远程法术暴击提高60%，所有近战和法术技能都不会造成仇恨，持续1分30秒。',
                }, {
                    spell = 29865,
                    desc = '战斗开始后近战范围内玩家会受到该光环效果，每次发动受到自然伤害。',
                },
            },
        },
    }, --
    [1113] = {
        name = '教官拉苏维奥斯',
        bossId = 1113,
        zone = 3,
        icon = 1378988,
        url = 'https://www.bilibili.com/video/BV1dr4y1w7gW?p=11',
        summary = {
            children = {
                {
                    role = 'TANK',
                    desc = '1名牧师心灵控制学员开怪，使用学员的嘲讽技能将坦克拉至楼梯口位置。\n3名T将其余3个学员拉至楼梯上方，方便牧师控制，学员脱离控制后拉回楼梯上方。',
                }, {
                    role = 'HEALER',
                    desc = '1.集中站在BOSS边上的楼梯扶手内，卡视野位置加好学员和拉学员的T的血量，躲避BOSS瓦解怒吼技能。\n2.心灵控制牧师控制一个学员，使用学员的嘲讽技能开怪，开启学员的盾墙技能后将BOSS拉至楼梯口。学员盾墙快结束时，放弃控制，另一个牧师控制另外的学员使用盾墙和嘲讽技能顶上，两个牧师轮流直至BOSS倒下。',
                }, {role = 'MELEE', desc = '等学员拉住BOSS后输出即可。'}, {
                    role = 'RANGE',
                    desc = '1.集中站在离BOSS较远距离的楼梯扶手处，进入战斗后输出BOSS。\n2.听指挥躲进扶手后，卡视野躲避BOSS瓦解怒吼技能。',
                },
            },
        },
        abilities = {
            desc = '教官拉苏维奥斯物理攻击非常强力，玩家无法坦克，需要牧师控制BOSS边上的学员（学员拥有盾墙和嘲讽技能），让学员开盾墙去坦BOSS。',
            children = {
                {
                    title = '瓦解怒吼',
                    desc = '凶猛的尖叫，吸取附近玩家的蓝量，全部转化成伤害。',
                }, ---
                {
                    spell = 26613,
                    desc = '对当前目标释放，造成大量物理伤害并使其防御值降低，持续6秒。',
                }, ---
            },
        },
    }, --
    [1109] = {
        name = '收割者戈提克',
        bossId = 1109,
        zone = 3,
        icon = 1378979,
        url = 'https://www.bilibili.com/video/BV1dr4y1w7gW?p=12',
        summary = {
            children = {
                {
                    role = 'TANK',
                    desc = '左半场坦克：分配2个坦克在左边，开始先拉死亡骑士仇恨，在骑兵出来后拉住骑兵仇恨，死亡骑士由牧师锁住。\n左半场坦克：站在骨堆边上，出现怪就拉住，优先鬼灵骑士。\n注意：BOSS出来后会随机在2个房间内出现， T注意拉住BOSS。',
                }, {
                    role = 'HEALER',
                    desc = '按照分配站在左右两个房间内。\n左边房间：和远程站在一起，治疗好左边房间玩家。\n注意：每个牧师需要锁住（束缚亡灵）一个死亡骑士，随时注意锁住的怪的状态，补上技能。\n右边房间：远离骨堆，最远距离治疗右边房间玩家。',
                }, {
                    role = 'MELEE',
                    desc = '远程DPS基本会被分配至右边房间，站在骨堆周围，出现小怪就击杀，鬼灵学徒可控制，小怪击杀优先顺序为死亡骑士-骑兵-学徒。\n注意：BOSS出来先集中击杀BOSS。',
                }, {
                    role = 'RANGE',
                    desc = '远程DPS基本会被分配至左边房间，集中站在3个台子前面，出现小怪就击杀，先集中击杀骑兵或者死亡骑士，牧师锁住的怪不要去打。\n注意：BOSS出来先击杀BOSS。',
                },
            },
        },
        abilities = {
            desc = 'BOSS自身难度不大，这场战斗主要是需要处理好BOSS下楼前的小怪。\nBOSS房间被分割为两部分，战斗开始中间门会关闭，变成2个独立的区域，在左边房间被击杀的小怪会在右边房间复活，且魔法免疫。',
            children = {
                {
                    title = '左侧房间',
                    desc = '左边房间小怪只会刷新在3个平台上',
                    children = {
                        {
                            title = '冷酷的学徒',
                            desc = '每次刷新3个，每个台子上刷新一个。',
                            expanded = true,
                            children = {
                                {spell = 5164, desc = '将附件所有玩家击倒。'}, ---
                                {
                                    title = '死亡疫病',
                                    desc = '对当前玩家释放，持续造成自然伤害，可叠加。',
                                }, ---
                            },
                        }, {
                            title = '冷酷的死亡骑士',
                            desc = '每次刷新2个，会在1号和3号台子上刷新。',
                            expanded = true,
                            children = {
                                {spell = 19983, desc = '对目标和他周围玩家造成大量物理伤害。'}, ---
                            },
                        }, {
                            title = '冷酷的骑兵',
                            desc = '每次刷新1个，刷新在中间台子上。',
                            expanded = true,
                            children = {
                                {spell = 27831, desc = '对周围玩家释放多支暗影箭，造成暗影伤害。'}, ---
                                {title = '邪恶光环', desc = '每3秒对所有附近玩家造成暗影伤害。'}, ---
                            },
                        },
                    },
                }, {
                    title = '右侧房间',
                    desc = '右边房间会在随机骨堆上复活三种小怪的灵魂形态，所有鬼灵均为魔法免疫状态。',
                    children = {
                        {
                            title = '鬼灵学徒',
                            desc = '由冷酷的学徒复活而来。',
                            expanded = true,
                            children = {
                                {title = '魔爆术', desc = '对附近玩家造成奥术伤害。'}, ---
                                {spell = 27990, desc = '恐惧范围内的玩家，持续4秒。'}, ---
                            },
                        }, {
                            title = '鬼灵骑士',
                            desc = '由冷酷的死亡骑士复活而来。',
                            expanded = true,
                            children = {
                                {title = '法力燃烧', desc = '对周围玩家造成伤害且吸收法力值。'}, ---
                                {title = '生命吸取', desc = '吸取玩家的生命值转化为自身生命值。'}, ---
                            },
                        }, {
                            title = '鬼灵骑兵',
                            desc = '由冷酷的骑兵复活而来，会形成鬼灵骑兵和鬼灵战马2种怪。',
                            expanded = true,
                            children = {
                                {
                                    title = '鬼灵骑兵',
                                    expanded = true,
                                    children = {
                                        {
                                            title = '法力燃烧',
                                            desc = '对周围玩家造成伤害且吸收法力值。',
                                        }, ---
                                        {
                                            title = '生命吸取',
                                            desc = '吸取玩家的生命值转化为自身生命值。',
                                        }, ---
                                    },
                                }, {
                                    title = '鬼灵战马',
                                    expanded = true,
                                    children = {
                                        {
                                            title = '践踏',
                                            desc = '对周围玩家造成物理伤害且降低移动速度。',
                                        }, ---
                                    },
                                },
                            },
                        },
                    },
                }, {
                    title = 'BOSS',
                    desc = '战斗持续4分30秒后，BOSS会下楼。',
                    children = {
                        {spell = 29317, desc = '对当前目标释放，造成大量暗影伤害。'}, ---
                        {
                            spell = 28679,
                            desc = '对所有玩家释放，使得属性降低10%，持续60秒，每20秒释放一次，可叠加。',
                        }, ---
                        {title = '传送', desc = 'BOSS每隔30秒会在左右两个房间内传送。'}, ---
                    },
                },
            },
        },
    }, --
    [1121] = {
        name = '天启四骑士',
        bossId = 1121,
        zone = 3,
        icon = 1385732,
        url = 'https://www.bilibili.com/video/BV1dr4y1w7gW?p=13',
        summary = {
            children = {
                {
                    role = 'TANK',
                    desc = '整个战斗需要8个T，每个队伍一个T，整个战斗场地分为南北场作战，进门区域为南场，BOSS身后为北场。1234队T在南场，5678队T在北场。每次换T一定确保接替的T已经接到BOSS再走。拉大领主莫格莱尼的T注意将BOSS背对大团，拉女公爵布劳缪克丝拉的T注意随机躲避脚下的黑水。\n战斗开始，4个T分散在4个角落。',
                    children = {
                        {
                            title = '南场',
                            expanded = true,
                            desc = '1T站在门右边的角落拉大领主莫格莱尼\n2T站在门左边角落拉库尔塔兹领主\n34队T在安全点等待。\n印记叠加3层后，3T接替1T，4T接替2T，12队T返回安全点等待。',
                        }, {
                            title = '北场',
                            expanded = true,
                            desc = '5T将女公爵布劳缪克丝拉至左上角\n6T将瑟里耶克爵士拉至右上角\n78队T在安全点等待。\n印记叠加3层后， 7T接替5T，8T接替6T，56队T返回安全点等待。',
                        }, {
                            title = '注意',
                            expanded = true,
                            desc = '之后印记每叠加3层时，南北场安全点的T注意身上印记，哪个BOSS印记消失，就去接替哪个BOSS（只接替自己半场的T）。\n注意：若南场BOSS已击杀，多余T可根据身上印记情况去北场支援。BOSS印记消失后方可去接手该BOSS。',
                        },
                    },
                }, {
                    role = 'HEALER',
                    desc = '1.跟随分配到的T，T去接手哪个BOSS就去跟随去治疗。\n2.治疗库尔塔兹领主时和T站在一起，治疗瑟里耶克爵时最远距离加血，治疗女公爵布劳缪克丝拉时注意随机躲避脚下的黑水。\n注意：身上印记叠加至3层就回安全点。BOSS印记消失后方可跟随T去治疗该BOSS。',
                }, {
                    role = 'MELEE',
                    desc = '1.跟随分配到的T，T去接手哪个BOSS就去输出哪个BOSS。\n2.输出大领主莫格莱尼时注意站在BOSS背后，输出女公爵布劳缪克丝拉时注意随机躲避脚下的黑水。\n3.大领主莫格莱尼和库尔塔兹领主击杀后再去输出女公爵布劳缪克丝拉，不去输出瑟里耶克爵士。\n注意：身上印记叠加至3层就回安全点。BOSS印记消失后方可跟随T去输出该BOSS。',
                }, {
                    role = 'RANGE',
                    desc = '1.跟随分配到的T，T去接手哪个BOSS就去输出哪个BOSS。\n2.输出库尔塔兹领主时和T站在一起，输出瑟里耶克爵士时最远距离输出，输出女公爵布劳缪克丝拉时注意随机躲避脚下的黑水。\n3.先击杀大领主莫格莱尼和库尔塔兹领主，这2个击杀之后再去输出女公爵布劳缪克丝拉和瑟里耶克爵士。\n注意：身上印记叠加至3层就回安全点。BOSS印记消失后方可跟随T去输出该BOSS。',
                },
            },
        },
        abilities = {
            desc = '天启四骑士有4个BOSS，分别是库尔塔兹领主、瑟里耶克爵士、女公爵布劳缪克丝、大领主莫格莱尼，4个BOSS都有各自的光环印记和独特技能，相同光环印记可叠加，层数越高受到的伤害越多，每个BOSS的印记互不干涉。4个BOSS被拉到房间的4个角落后，整个房间只有BOSS所在台阶前面位置为安全点，不会吃到所有印记。',
            children = {
                {
                    title = '库尔塔兹领主',
                    children = {
                        {
                            title = '流星',
                            expanded = true,
                            desc = '范围伤害，由陨石冲击点周围8码内所有玩家共同分担。',
                        }, ---
                        {
                            spell = 28832,
                            expanded = true,
                            desc = '对光环内玩家造成伤害并留下印记，叠加的印记层数越多所受伤害越大。',
                        }, ---
                    },
                }, {
                    title = '瑟里耶克爵士',
                    children = {
                        {
                            title = '神圣愤怒',
                            expanded = true,
                            desc = '对周围玩家射出神圣箭矢，对目标和其身旁玩家造成神圣伤害，每次跳跃提高50%伤害。',
                        }, ---
                        {
                            title = '神圣之箭',
                            expanded = true,
                            desc = '对离BOSS最近玩家造成大量神圣伤害。',
                        }, ---
                        {
                            spell = 28835,
                            expanded = true,
                            desc = '对光环内玩家造成伤害并留下印记，叠加的印记层数越多所受伤害越大。',
                        }, ---
                    },
                }, {
                    title = '女公爵布劳缪克丝',
                    children = {
                        {
                            title = '暗影箭',
                            expanded = true,
                            desc = '对目标射出魔法箭，造成大量暗影伤害。',
                        }, ---
                        {
                            spell = 28863,
                            expanded = true,
                            desc = '随机范围内玩家脚下召唤一个虚空领域，对站在范围内的所有玩家造成暗影伤害。',
                        }, ---
                        {
                            spell = 28833,
                            expanded = true,
                            desc = '对光环内玩家造成伤害并留下印记，叠加的印记层数越多所受伤害越大。',
                        }, ---
                    },
                }, {
                    title = '大领主莫格莱尼',
                    desc = '注意：BOSS在血量50%、20%时会开启盾墙（29061），持续20秒。',
                    children = {
                        {title = '正义之火', expanded = true, desc = '对BOSS前方造成大量范围伤害。'}, ---
                        {
                            spell = 28834,
                            expanded = true,
                            desc = '对光环内玩家造成伤害并留下印记，叠加的印记层数越多所受伤害越大。',
                        }, ---
                    },
                },
            },
        },
    }, --
    [1118] = {
        name = '帕奇维克',
        bossId = 1118,
        zone = 4,
        icon = 1379005,
        url = 'https://www.bilibili.com/video/BV1dr4y1w7gW?p=7',
        summary = {
            children = {
                {
                    role = 'TANK',
                    desc = '主T：开怪，确保第一个进入BOSS仇恨列表。\n副T：确保血量高于其他团员（均高于主T），血量最高为2T，第二为3T，第三为4T。全程保持石盾药水、盾牌格挡、破甲、挫志怒吼。',
                }, {
                    role = 'HEALER',
                    desc = '主T治疗：开打后全程不间断的读大治疗术，大蓝和符文一到时间就喝。\n2T治疗：开打后全程不间断的读大治疗术，大蓝和符文一到时间就喝。\n3T治疗：2T掉血就读大治疗术，2T满血就打断读条，大蓝和符文一到时间就喝。\n4T治疗：2T和3T都掉血就读大治疗术，2T和3T有一个满血的就打断读条等待。\n注意：为了省蓝，主T治疗可以选择加1800左右血量的治疗法术，副T治疗可以选择加2500左右血量的治疗法术。',
                }, {role = 'MELEE', desc = '注意仇恨，全力输出。'},
                {role = 'RANGE', desc = '注意仇恨，全力输出。'},
            },
        },
        abilities = {
            desc = '7分钟后BOSS狂暴，狂暴后秒杀任何职业。',
            children = {
                {title = '普通物理攻击', desc = '对主T造成2000伤害。'}, ---
                {title = '仇恨打击', desc = '对近战范围内血量最高的人造成5500-8000的伤害。'}, ---
            },
        },
    }, --
    [1111] = {
        name = '格罗布鲁斯',
        bossId = 1111,
        zone = 4,
        icon = 1378981,
        url = 'https://www.bilibili.com/video/BV1dr4y1w7gW?p=8',
        summary = {
            children = {
                {
                    role = 'TANK',
                    desc = '主T开怪后将BOSS拉至墙边，一旦BOSS脚下生成毒云就沿着墙后退，确保不会接触到毒云。',
                }, {
                    role = 'HEALER',
                    desc = '1.在场地中间集中站位，按照分配治疗T或者DPS，最远距离治疗。\n2.若被注射毒素（变异注射），速度跑到最后的毒云边上，等待解除疾病。\n3.指定解疾病的治疗随时注意被注射玩家，一旦位置站好立即驱散该玩家疾病。',
                }, {
                    role = 'MELEE',
                    desc = '1.主T拉住后，站在主T的侧后方，面对着墙面攻击BOSS。\n2.不要站在主T前面，预防被BOSS喷射到。\n3.若被注射毒素（毒性注射），速度跑到最后的毒云边上，等待治疗解除疾病。\n4.出现小软泥怪优先击杀。\n注意：全程战斗注意毒云位置，边打边走，不要接触到毒云。',
                }, {
                    role = 'RANGE',
                    desc = '1.在场地中间集中站位，最远距离输出BOSS。\n2.若被注射毒素（变异注射），速度跑到最后的毒云边上，等待治疗解除疾病。\n3.优先输出BOSS。',
                },
            },
        },
        abilities = {
            children = {
                {
                    spell = 28157,
                    desc = '对主T方向释放一个范围性喷射，造成大量自然伤害，并且每个被击中的玩家都将召唤出一个小软泥怪。',
                }, ---
                {
                    spell = 28240,
                    desc = 'BOSS脚下出现一片毒云，不会移动，但会随时间缓慢扩散开来，直到直径20码之后缓慢消失。接触到毒云会每秒掉血。',
                }, ---
                {
                    spell = 28169,
                    desc = '随机对一名玩家注射毒素，毒素为疾病，可驱散，持续10秒或者被驱散后会在该玩家脚下出现一片毒云。',
                }, ---
                {
                    spell = 28280,
                    desc = '投掷一个小软泥轰炸地面，小软泥拥有软泥溅射（28137）对附近所有敌人造成伤害。',
                }, ---
                {title = '狂暴', desc = '进入战斗12分钟后BOSS会狂暴。'}, ---
            },
        },
    }, --
    [1108] = {
        name = '格拉斯',
        bossId = 1108,
        zone = 4,
        icon = 1378977,
        url = 'https://www.bilibili.com/video/BV1dr4y1w7gW?p=9',
        summary = {
            children = {
                {
                    role = 'TANK',
                    desc = '1.主T将BOSS拉至门口位置，副T一起制造仇恨。主T身上重伤叠加层数过高时副T接手，期间注意防恐惧。\n2.拉小僵尸的T在残杀前风筝好小僵尸，残杀结束后继续拉住其他小僵尸仇恨，远离BOSS。',
                }, {
                    role = 'HEALER',
                    desc = '1.和远程一起集中站位治疗。\n2.BOSS残杀后第一时间刷好T的血量。\n注意：矮牧给拉BOSS坦克刷好反恐惧结界。',
                }, {
                    role = 'MELEE',
                    desc = '1.进入战斗后靠近主T位置输出。被恐惧后第一时间回到BOSS边上继续输出。\n2.残杀后优先击杀小僵尸，阻止僵尸靠近BOSS。',
                }, {
                    role = 'RANGE',
                    desc = '1.进入战斗后集中站位，最远距离输出BOSS。\n2.LR打好宁神。\n3.残杀后优先控制击杀小僵尸。\n4.分配好的远程辅助副T风筝小僵尸，例如猎人冰霜陷阱等。',
                },
            },
        },
        abilities = {
            desc = 'BOSS战斗开始后，房间内3个窗口位置会不断刷新小僵尸，小僵尸吃一切控制技能。',
            children = {
                {title = '重伤', desc = '对主T释放，受到治疗效果减少10%，可叠加。'}, ---
                {title = '激怒', desc = '攻击间隔缩短25%，持续8秒。'}, ---
                {
                    title = '残杀',
                    desc = '每隔一段时间，会把BOSS房间内任何玩家或小怪的血量都降低至5%。此时小僵尸会无视仇恨走向BOSS。',
                }, ---
                {
                    title = '召唤僵尸',
                    desc = '战斗开始后，房间井口附近会不断刷新僵尸，BOSS会吞噬靠近自己的僵尸，每吞噬一只恢复BOSS 5%的血量。',
                }, ---
                {title = '群体恐惧', desc = '每隔20秒将会恐惧所有20码范围内玩家。'}, ---
            },
        },
    }, --
    [1120] = {
        name = '塔迪乌斯',
        bossId = 1120,
        zone = 4,
        icon = 1379019,
        url = 'https://www.bilibili.com/video/BV1dr4y1w7gW?p=10',
        summary = {
            children = {
                {
                    title = '小BOSS阶段',
                    children = {
                        {
                            role = 'TANK',
                            desc = '1.每个平台一个T，拉好当前小BOSS仇恨。\n2.被抛至另一平台后迅速拉好当前BOSS，循环直至小BOSS被同时击杀。',
                        }, {
                            role = 'HEALER',
                            desc = '1.按照分配前往2个小BOSS平台，最远距离治疗。\n2.若T被交换位置，则BOSS的当前T。\n3.注意：电荷变换时打断读条，第一时间换位。',
                        }, {
                            role = 'MELEE',
                            desc = '1.前往右边费尔根平台，输出费尔根。\n2.注意费尔根血量，确保和斯塔拉格同时死亡。',
                        }, {
                            role = 'RANGE',
                            desc = '1.前往左边斯塔拉格平台，最远距离输出斯塔拉格。\n2.注意斯塔拉格血量，确保和费尔根同时死亡。',
                        },
                    },
                }, {
                    title = '塔迪乌斯阶段',
                    children = {
                        {
                            role = 'TANK',
                            desc = '1.跳上BOSS所在平台后，主T站在BOSS一侧等待BOSS激活。\n2.BOSS激活后拉住仇恨。\n3.BOSS释放电荷时第一时间查看身上电荷标记，若为正能量电荷（加号）则原地不动，若为负能量电荷（减号），需跑动至BOSS另一边，和其他负电荷玩家一起集中站位。每一次电荷变换均要注意，电荷仍旧为正极或者负极就原地不动，若正极变为负极，或者负极变为正极，就跑至BOSS对面，确保和所有同样电荷玩家站在一起。循环直至BOSS倒下。',
                        }, {
                            role = 'HEALER',
                            desc = '1.跳上BOSS所在平台后，和主T站在一起等待BOSS激活。\n2.根据指挥分配看好T和自身队伍血量。\n3.BOSS释放电荷时第一时间查看身上电荷标记，若为正能量电荷（加号）则原地不动，若为负能量电荷（减号），需跑动至BOSS另一边，和其他负电荷玩家一起集中站位。每一次电荷变换均要注意，电荷仍旧为正极或者负极就原地不动，若正极变为负极，或者负极变为正极，就跑至BOSS对面，确保和所有同样电荷玩家站在一起。循环直至BOSS倒下。\n注意：电荷变换时打断读条，第一时间换位。',
                        }, {
                            role = 'MELEE',
                            desc = '1.跳上BOSS所在平台后，和主T站在一起等待BOSS激活，激活后输出BOSS。\n2.BOSS释放电荷时第一时间查看身上电荷标记，若为正能量电荷（加号）则原地不动，若为负能量电荷（减号），需跑动至BOSS另一边，和其他负电荷玩家一起集中站位。每一次电荷变换均要注意，电荷仍旧为正极或者负极就原地不动，若正极变为负极，或者负极变为正极，就跑至BOSS对面，确保和所有同样电荷玩家站在一起。循环直至BOSS倒下。',
                        }, {
                            role = 'RANGE',
                            desc = '1.跳上BOSS所在平台后，和主T站在一起等待BOSS激活，激活后输出BOSS。\n2.BOSS释放电荷时第一时间查看身上电荷标记，若为正能量电荷（加号）则原地不动，若为负能量电荷（减号），需跑动至BOSS另一边，和其他负电荷玩家一起集中站位。每一次电荷变换均要注意，电荷仍旧为正极或者负极就原地不动，若正极变为负极，或者负极变为正极，就跑至BOSS对面，确保和所有同样电荷玩家站在一起。循环直至BOSS倒下。\n3.注意：电荷变换时打断读条，第一时间换位。',
                        },
                    },
                },
            },
        },
        abilities = {
            desc = '塔迪乌斯战斗分为2个阶段，第一阶段需要先同时击杀两边小平台的小boss斯塔拉格和费尔根，然后在15秒后BOSS激活，所有人需要跳至BOSS所在平台才能参与战斗。',
            children = {
                {
                    title = '斯塔拉格',
                    children = {
                        {title = '能量激流', expanded = true, desc = 'BOSS攻击速度提高，持续10秒。'}, ---
                        {
                            title = '电磁牵引',
                            expanded = true,
                            desc = '每隔一段时间，斯塔拉格和费尔根同时使用电磁牵引，将对方的第一仇恨目标拖至自己面前，并将仇恨值交换。',
                        }, ---
                    },
                }, {
                    title = '费尔根',
                    children = {
                        {
                            title = '静电领域',
                            expanded = true,
                            desc = '每秒对自身平台上玩家造成自然伤害并吸收法力值。',
                        }, ---
                        {
                            title = '电磁牵引',
                            expanded = true,
                            desc = '每隔一段时间，费尔根和斯塔拉格同时使用电磁牵引，将对方的第一仇恨目标拖至自己面前，并将仇恨值交换。',
                        }, ---
                    },
                }, {
                    title = '塔迪乌斯',
                    children = {
                        {
                            title = '极性转化',
                            expanded = true,
                            desc = '随机对所有玩家释放正能量电荷或者负能量电荷，相同电荷玩家互相靠近时，每次攻击所造成的伤害会提高。不同电荷玩家相互靠近时，会对附件所有玩家造成伤害。',
                        }, ---
                        {
                            title = '闪电链',
                            expanded = true,
                            desc = '对当前目标释放，击中后继续攻击附近玩家，最多攻击5个目标。',
                        }, ---
                        {title = '狂暴', expanded = true, desc = '5分钟内没有击杀则BOSS狂暴。'}, ---
                    },
                },
            },
        },
    }, --
    [1119] = {
        name = '萨菲隆',
        bossId = 1119,
        zone = 5,
        icon = 1379010,
        url = 'https://www.bilibili.com/video/BV1dr4y1w7gW?p=14',
        summary = {
            children = {
                {
                    role = 'TANK',
                    desc = '1.萨菲隆只需要主T，开打后将BOSS拉在原地，且BOSS背对入口。\n2.躲避好暴风雪。\n3.BOSS上天后分散站位，冰霜吐息时第一时间到冰块后躲避。',
                }, {
                    role = 'HEALER',
                    desc = '1.根据指挥分配站位，在BOSS两侧分散治疗。\n2.躲好暴风雪。\n3.BOSS上天后分散站位，冰霜吐息时第一时间到冰块后躲避。\n注意：德鲁伊第一时间驱散好诅咒。',
                }, {
                    role = 'MELEE',
                    desc = '1.根据指挥分配站位，在BOSS两侧输出BOSS。\n2.躲好暴风雪。\n3.BOSS上天后分散站位，冰霜吐息时第一时间到冰块后躲避。',
                }, {
                    role = 'RANGE',
                    desc = '1.根据指挥分配站位，在BOSS两侧分散输出BOSS。\n2.躲好暴风雪。\n3.BOSS上天后分散站位继续输出BOSS，冰霜吐息时第一时间到冰块后躲避。\n注意：法师第一时间驱散好诅咒。',
                },
            },
        },
        abilities = {
            desc = '由于萨菲隆具有冰霜光环，会持续的造成冰霜伤害，因此需要穿上冰霜抗性装备，降低伤害数值。而每隔60秒，BOSS会上天，在空中持续30秒。空中阶段时，每隔5秒会将随机一名玩家冻成冰块，且对冰块周围玩家造成大量的冰霜伤害。冰冻5名玩家后，会对场地正中间释放冰霜吐息，需要在冰块后躲避伤害，否则会被秒杀，吐息结束后冰龙回到地面。',
            children = {
                {spell = 28531, desc = '每秒造成600冰霜伤害。'}, ---
                {
                    spell = 28522,
                    desc = '将随机目标禁锢在寒冰之中，使其陷入昏迷且对目标周围玩家造成大量冰霜伤害。',
                }, ---
                {
                    spell = 28524,
                    desc = '对玩家造成2W多冰霜伤害，未躲避在冰块后的会被直接秒杀。',
                }, ---
                {title = '扫尾', desc = '对位于BOSS身后锥形范围内玩家造成物理伤害，并击退。'}, ---
                {
                    spell = 28542,
                    desc = '对随机玩家释放，每3秒造成大量暗影伤害且回复BOSS血量，可驱散。',
                }, ---
                {spell = 19983, desc = '对目标和他周围玩家造成大量物理伤害。'}, ---
                {
                    spell = 28560,
                    desc = '随机释放，且会小范围的移动，暴风雪范围内玩家会每2秒受到大量冰霜伤害且降低移动速度。',
                }, ---
            },
        },
    }, --
    [1114] = {
        name = '克尔苏加德',
        bossId = 1114,
        zone = 5,
        icon = 1378989,
        url = 'https://www.bilibili.com/video/BV1dr4y1w7gW?p=15',
        summary = {
            children = {
                {
                    title = 'P1',
                    children = {
                        {role = 'TANK', desc = '拉住憎恶仇恨，远离女妖和骷髅。'}, {
                            role = 'HEALER',
                            desc = '场地中间集中站位，治疗全团，主看T。\n注意：牧师需要锁住P1阶段靠近大团的骷髅，P3阶段需要锁住寒冰皇冠卫士（大甲虫）。',
                        }, {role = 'MELEE', desc = '击杀憎恶，远离女妖和骷髅。'}, {
                            role = 'RANGE',
                            desc = '场地中间集中站位，优先击杀骷髅和女妖。\n注意：猎人P1阶段不要多重引到未出来小怪。',
                        },
                    },
                }, {
                    title = 'P2',
                    children = {
                        {
                            role = 'TANK',
                            desc = '主T在场地中间拉住BOSS，其他T分散在BOSS四周，打断单体寒冰箭，躲开暗影裂隙。',
                        },
                        {
                            role = 'HEALER',
                            desc = '全场10码距离分散站位，治疗中技能玩家，躲开暗影裂隙。',
                        }, {
                            role = 'MELEE',
                            desc = '清理完所有场上小怪后输出BOSS，释放冰霜冲击时往后分散站位，结束返回原位输出，打断单体寒冰箭，躲开暗影裂隙。',
                        }, {
                            role = 'RANGE',
                            desc = '全场10码距离分散站位，清理完所有场上小怪后最远距离输出BOSS，躲开暗影裂隙。',
                        },
                    },
                }, {
                    title = 'P3',
                    children = {
                        {
                            role = 'TANK',
                            desc = '其余T拉住未被锁住的寒冰皇冠卫士（大甲虫），使用减速技能尽量控制住它们。',
                        }, {role = 'HEALER', desc = '全场10码距离分散站位治疗。'},
                        {role = 'MELEE', desc = '开所有技能输出BOSS。'},
                        {role = 'RANGE', desc = '开所有技能输出BOSS。'},
                    },
                },

            },
        },
        abilities = {
            desc = '克尔苏加德整场战斗分为三个阶段，P1期间BOSS不参与战斗，不断召唤小怪。5分钟后进入P2，小怪不再刷新，开始输出BOSS，在BOSS血量降至40%时进入P3阶段，该阶段会召唤5个寒冰皇冠卫士。',
            children = {
                {
                    title = 'P1',
                    desc = 'P1不断召唤3种小怪',
                    children = {
                        {
                            title = '骷髅',
                            expanded = true,
                            desc = '靠近人群会自爆释放暗影冲击，造成大量暗影伤害。',
                        }, ---
                        {
                            title = '女妖',
                            expanded = true,
                            desc = '靠近目标会造成大量暗影伤害，且具有击退效果。',
                        }, ---
                        {
                            title = '憎恶',
                            expanded = true,
                            desc = '对近战释放仇恨打击，对目标释放重伤，降低10%治疗效果，可叠加。',
                        }, ---
                    },
                }, {
                    title = 'P2',
                    desc = 'P2开始输出BOSS，克尔苏加德技能如下',
                    children = {
                        {
                            title = '单体寒冰箭',
                            expanded = true,
                            desc = '对当前目标释放，造成大量冰霜伤害且减速，可打断。',
                        }, ---
                        {
                            title = '群体寒冰箭',
                            expanded = true,
                            desc = '对所有玩家释放，造成大量冰霜伤害。',
                        }, ---
                        {
                            spell = 27810,
                            expanded = true,
                            desc = '随机在一名玩家脚下释放，5秒后对还在范围内玩家造成大量暗影伤害。',
                        }, ---
                        {
                            spell = 27808,
                            expanded = true,
                            desc = '对随机玩家释放，使目标冻结进入昏迷状态，每秒造成大量冰霜伤害。',
                        }, ---
                        {
                            spell = 27819,
                            expanded = true,
                            desc = '对随机一名有法力值的玩家释放，吸取该玩家部分法力值，且对周围玩家造成伤害。',
                        }, ---
                        {
                            spell = 28410,
                            expanded = true,
                            desc = '随机控制五名玩家，被控制玩家体型变大，伤害和治疗能力增加。',
                        }, ---
                    },
                }, {
                    title = 'P3',
                    desc = '克尔苏加德血量降低至40%后进入P3，会刷新寒冰皇冠卫士（类似蜘蛛区老一）。\n寒冰皇冠卫士血量很高，每次切换目标都会叠加一个BUFF：活力分流。',
                    children = {
                        {spell = 28470, expanded = true, desc = '造成伤害提高15%。'}, ---
                    },
                },
            },
        },
    },
    [650] = {
        name = '格鲁尔',
        bossId = 650,
        icon = 1378982,
        summary = {
            desc = "屠龙者格鲁尔是格鲁尔的巢穴的最终BOSS，每过30秒格鲁尔都会增加伤害，体型变大，随着时间的增加战斗会越来越困难，越快结束战斗越轻松。",
            children = {
                {
                    role = 'TANK',
                    desc = '主T将BOSS拉在场地中间，被击退后将BOSS拉回原位。二T保持第二仇恨，被击退后立即返回。躲避好洞穴震颤技能，逃离掉落岩石碎片范围。石化碎裂时和周围玩家保持距离。',
                }, {
                    role = 'HEALER',
                    desc = '在BOSS场地外围分散治疗，躲避好洞穴震颤技能，逃离掉落岩石碎片范围。石化碎裂时和周围玩家保持距离。',
                }, {
                    role = 'MELEE',
                    desc = '最远距离攻击BOSS，被击退后返回原位。躲避好洞穴震颤技能，逃离掉落岩石碎片范围。石化碎裂时和周围玩家保持距离。',
                }, {
                    role = 'RANGE',
                    desc = '在BOSS场地外围分散站立输出BOSS。躲避好洞穴震颤技能，逃离掉落岩石碎片范围。石化碎裂时和周围玩家保持距离。',
                },
            },
        },
        abilities = {
            desc = '屠龙者格鲁尔会随着时间增加而逐渐变强，越快结束战斗越轻松。',
            children = {
                {spell = 36300, desc = '每30秒伤害提高15%，体型增大。'},
                {
                    spell = 33525,
                    desc = '击退所有玩家，产生戈隆领主之握技能，5秒内减速并石化。',
                }, {
                    spell = 33654,
                    desc = '粉碎所有石化的玩家，并对周围玩家产生伤害，距离越近受到伤害越大。',
                },
                {
                    spell = 36240,
                    desc = '随机目标区域掉落岩石碎片，对范围内玩家造成伤害并减速。',
                },
                {spell = 33813, desc = '每隔一段时间对第二仇恨玩家释放，造成大量物理伤害。'},
            },
        },
    },
    [649] = {
        name = '莫加尔大王',
        bossId = 649,
        icon = 1378985,
        summary = {
            desc = "莫加尔大王是格鲁尔的巢穴一号BOSS，BOSS战需要面对莫加尔大王和他的四个小弟，整场战斗需要一个法师去拉住克洛什·火拳，两个猎人拉住疯狂的基戈尔，术士需要控制召唤者沃尔姆召唤出的地狱犬，让地狱犬保持召唤者沃尔姆的第二仇恨，击杀掉四个小BOSS就进入P2阶段，莫加尔大王进入狂怒状态，击杀之后整场战斗结束。",
            children = {
                {
                    role = 'TANK',
                    children = {
                        {
                            title = 'P1阶段',
                            desc = '克洛什·火拳需要法师来坦住，拉在小BOSS原位即可，法师T需要每隔30秒偷取克洛什·火拳的法术护盾，确保受到的法术伤害降低。\n疯狂的基戈尔需要两个猎人来坦克，将小BOSS拉至房间左上角。\n盲眼坦克将小BOSS拉至房间左下角，注意打断加血技能。\n召唤者沃尔姆坦克将小BOSS拉至房间右上角，术士需要第一时间奴役小BOSS召唤的地狱犬，让地狱犬保持第二仇恨，确保T被死亡缠绕后，地狱犬可以坦住小BOSS。\n主T拉住莫加尔大王，将BOSS拉在通道入口处，背靠墙壁，避免被击退。',
                        }, {title = 'P2阶段', desc = '在BOSS冲锋之后，坦克需要将BOSS拉回原位。'},
                    },
                }, {
                    role = 'HEALER',
                    children = {
                        {
                            title = 'P1阶段',
                            desc = '按照指挥分配治疗好各个坦住BOSS的T，负责给拉疯狂的基戈尔的猎人加血的治疗要最远距离加血，避免被羊。',
                        }, {
                            title = 'P2阶段',
                            desc = '牧师给主T加好反恐惧结界，萨满祭司插好战栗图腾，注意主T的血量即可。',
                        },
                    },
                }, {
                    role = 'MELEE',

                    children = {
                        {
                            title = 'P1阶段',
                            desc = '按照顺序击杀，第一个先击杀盲眼先知，BOSS盾破之后注意打断治疗。第二个是召唤者沃尔姆。第三个疯狂的基戈尔，尽量背靠墙最远距离输出，避免被击飞。第四个是克洛什·火拳。最后去输出莫加尔大王，输出时躲好大王的旋风斩。',
                        }, {title = 'P2阶段', desc = '输出莫加尔大王，恐惧后继续返回输出即可。'},
                    },
                }, {
                    role = 'RANGE',
                    children = {
                        {
                            title = 'P1阶段',
                            desc = '按照顺序击杀，第一个先击杀盲眼先知。第二个是召唤者沃尔姆，术士注意第一时间奴役或者放逐召唤出的地狱犬。第三个疯狂的基戈尔。第四个是克洛什·火拳。最后去输出莫加尔大王。',
                        }, {title = 'P2阶段', desc = '输出莫加尔大王即可。'},
                    },
                },
            },
        },
        abilities = {
            desc = '莫加尔大王带着4个小BOSS，分别是克洛什·火拳、召唤者沃尔姆、盲眼先知和疯狂的基戈尔。BOSS战分为2阶段，P1需要先依次击杀4个小BOSS，然后输出莫加尔大王。在莫加尔血量到50%时进入P2，P2的莫加尔会狂暴，并且多出2个技能：恐惧和冲锋。',
        	children = {
                {
                    title = '盲眼先知',
                    noCollapse = true,
                    children = {
                        {spell = 33144, desc = '恢复自身血量。'},
                        {spell = 33152, desc = '恢复自身及其他同伴血量，可打断。'},
                        {spell = 11974, desc = '治疗祷言前释放盾，盾可吸收伤害并免疫控制技能。'},
                    },
                }, {
                    title = '召唤者沃尔姆',
                    noCollapse = true,
                    children = {
                        {spell = 33131, desc = '召唤一只地狱犬，可被术士奴役和放逐。'},
                        {spell = 27223, desc = '对当前仇恨目标释放，造成大量暗影伤害并恐惧4秒。'},
                        {
                            spell = 33129,
                            desc = '对当前仇恨目标释放，造成持续暗影伤害，无法驱散，但可被召唤的地狱犬吞噬。',
                        },
                    },
                }, {
                    title = '疯狂的基戈尔',
                    noCollapse = true,
                    children = {
                        {spell = 851, desc = '将范围内随机玩家变羊，不可驱散。'},
                        {spell = 8246, desc = '对当前仇恨目标释放，造成大量自然伤害。'},
                        {spell = 33175, desc = '打断范围内随机玩家施法，持续5秒。'},
                        {spell = 33860, desc = '对周围玩家造成自然伤害并击飞。'},
                    },
                }, {
                    title = '克洛什·火拳',
                    noCollapse = true,
                    children = {
                        {
                            spell = 33061,
                            desc = '放出一道火焰冲击波，所有被冲击波触及的玩家都会受到火焰伤害并降低移动速度。',
                        }, {spell = 33051, desc = '对一名玩家造成大量火焰伤害。'},
                        {spell = 33054, desc = '降低受到的魔法伤害75%，持续30秒，法师可以偷取。'},
                    },
                }, {
                    title = '莫加尔大王',
                    noCollapse = true,
                    children = {
                        {
                            spell = 33238,
                            desc = '对周围所有玩家造成物理伤害，持续15秒。期间BOSS可移动，但移动速度降低。',
                        }, {spell = 845, desc = '对前方范围内玩家造成物理伤害。'},
                        {spell = 33230, desc = '对当前仇恨目标释放，造成物理伤害并击退。'},
                        {title = '狂怒', desc = '50%血量后进入狂怒状态。'},
                    },
                }, {
                    title = '狂怒后增加2个新技能',
                    noCollapse = true,
                    children = {
                        {spell = 16508, desc = '发出咆哮，恐惧周围10码范围内玩家，恐惧持续10秒。'},
                        {spell = 32323, desc = '随机冲锋10码范围外玩家。'},
                    },
                },
            },
        },
    },
    [651] = {
        name = '玛瑟里顿的巢穴',
        bossId = 651,
        icon = 1378996,
        summary = {
            role = 'HEALER',
            desc = "玛瑟里顿的巢穴只有玛瑟里顿一个BOSS，玛瑟里顿处于房间中央，一开始是处于被五个地狱火导魔者监禁的状态，战斗开始就需要先击杀完5个导魔者，但是在战斗开始的2分钟后玛瑟里顿就会被激活，这时就需要优先击杀剩余的导魔者之后再去输出玛瑟里顿。玛瑟里顿最主要的技能是火焰新星，是一个全屏的火焰伤害，需要提前安排好五个人，在技能释放前到魔导者站的位置处点击方盒，五个方盒同时被激活即可打断技能。",
            children = {
                {
                    role = 'TANK',
                    children = {
                        {
                            title = 'P1阶段',
                            desc = '按照指挥分配坦住5个地狱火导魔者，每个地狱火导魔者保持距离，打断暗影箭雨和黑暗治疗。',
                        }, {
                            title = 'P2阶段',
                            desc = '主T将BOSS拉至靠墙，其余坦克继续拉好地狱火导魔者并打断，直至全部击杀完毕。',
                        }, {
                            title = 'P3阶段',
                            desc = '主T拉住BOSS，其余坦克输出，期间注意躲避地面燃烧及天上掉落碎片。\n注意：BOSS释放火焰新星前，指挥分配好的玩家提前站位，技能释放时点击方盒打断BOSS技能。',
                        },
                    },
                }, {
                    role = 'HEALER',
                    children = {
                        {title = 'P1阶段', desc = '按指挥分配治疗好坦克，期间注意躲避地狱火。\n注意：BOSS释放火焰新星前，指挥分配好的玩家提前站位，技能释放时点击方盒打断BOSS技能。'},
                        {
                            title = 'P2阶段',
                            desc = '治疗坦克，躲避地狱火和地面燃烧，敲击期间注意坦克血量，火焰新星期间治疗好点击方盒玩家。\n注意：BOSS释放火焰新星前，指挥分配好的玩家提前站位，技能释放时点击方盒打断BOSS技能。',
                        }, {
                            title = 'P3阶段',
                            desc = '优先治疗坦克，然后再恢复其他队友血量，期间躲避地面燃烧和天上掉落碎片，敲击期间注意坦克血量，火焰新星期间治疗好点击方盒玩家。\n注意：BOSS释放火焰新星前，指挥分配好的玩家提前站位，技能释放时点击方盒打断BOSS技能。',
                        },
                    },
                }, {
                    role = 'MELEE',

                    children = {
                        {
                            title = 'P1阶段',
                            desc = '按顺序击杀地狱火导魔者，打断暗影箭雨和黑暗治疗。\n注意：BOSS释放火焰新星前，指挥分配好的玩家提前站位，技能释放时点击方盒打断BOSS技能。',
                        }, {
                            title = 'P2阶段',
                            desc = '优先击杀地狱火导魔者，期间注意打断，然后输出BOSS，注意躲避地面燃烧。\n注意：BOSS释放火焰新星前，指挥分配好的玩家提前站位，技能释放时点击方盒打断BOSS技能。',
                        }, {
                            title = 'P3阶段',
                            desc = '输出BOSS，期间注意躲避地面燃烧及天上掉落碎片。\n注意：BOSS释放火焰新星前，指挥分配好的玩家提前站位，技能释放时点击方盒打断BOSS技能。',
                        },
                    },
                }, {
                    role = 'RANGE',
                    children = {
                        {
                            title = 'P1阶段',
                            desc = '按顺序击杀地狱火导魔者，打断暗影箭雨和黑暗治疗。\n注意：术士需要给每个地狱火导魔者上好语言诅咒，优先放逐或者恐惧地狱火。法师在敲击技能期间注意打断。BOSS释放火焰新星前，指挥分配好的玩家提前站位，技能释放时点击方盒打断BOSS技能。',
                        }, {
                            title = 'P2阶段',
                            desc = '优先击杀地狱火导魔者，注意打断，然后分散站位输出BOSS，注意躲避地面燃烧。\n注意：术士需要给每个地狱火导魔者上好语言诅咒，优先放逐或者恐惧地狱火。法师在敲击技能期间注意打断。BOSS释放火焰新星前，指挥分配好的玩家提前站位，技能释放时点击方盒打断BOSS技能。',
                        }, {
                            title = 'P3阶段',
                            desc = '输出BOSS，期间注意躲避地面燃烧及天上掉落碎片。 \n注意：术士需要给每个地狱火导魔者上好语言诅咒，优先放逐或者恐惧地狱火。法师在敲击技能期间注意打断。BOSS释放火焰新星前，指挥分配好的玩家提前站位，技能释放时点击方盒打断BOSS技能。',
                        },
                    },
                },
            },
        },
        abilities = {
            desc = 'BOSS战分为三个阶段：P1阶段只持续2分钟，期间玛瑟里顿不参与战斗，需要先击杀房间内的5个地狱火导魔者。2分钟后进入P2，玛瑟里顿重获自由加入战斗。玛瑟里顿血量到30%时进入P3，房间墙壁将碎裂，对所有玩家造成大量物理伤害，P3期间玛瑟里顿拥有所有P2时期的技能，且天花板也会不时掉落碎片，需要躲避。',
            children = {
                {
                    title = '地狱火导魔者',
                    noCollapse = true,
                    children = {
                        {spell = 25586, desc = '向附近玩家射出多支暗影箭，造成暗影伤害。'},
                        {spell = 30528, desc = '使用黑暗魔法为一名盟友恢复生命值。'}, {
                            spell = 23426,
                            desc = '周期性在玩家身边召唤地狱火，地狱火坠落时对周围玩家造成火焰伤害，地狱火会对目标释放火焰冲击造成火焰伤害。每个导魔者同一时间最多拥有2个地狱火，每个地狱火召唤后会存在1分钟。',
                        },
                    },
                }, {
                    title = '玛瑟里顿',
                    noCollapse = true,
                    children = {
                        {spell = 845, desc = '对前方范围内玩家造成物理伤害。'}, {
                            spell = 16805,
                            desc = '房间内随机地点释放火球，造成地面火焰效果，被火焰烧到玩家将受到火焰伤害并进入恐慌状态，持续时间内会周期性灼烧周围队友。',
                        }, {spell = 30658, desc = '每秒将房间内所有玩家震退一次，持续5秒。'}, {
                            spell = 30616,
                            desc = '引导型法术，每2秒对房间内所有玩家造成大量火焰伤害，持续10秒。5个玩家同时点击五个方位上的方盒，使得玛瑟里顿身上出现5条控制线，即可打断技能。点击方盒后会有持续3分钟的心灵疲惫debuff，期间无法再点击方盒。',
                        },
                    },
                },
            },
        },
    },
    [658] = {
        name = '埃兰之影',
        bossId = 658,
        icon = 1379012,
        summary = {
            desc = "埃兰之影是个纯法系的BOSS，精通三系天赋，除了单体攻击之外，还会释放暴风雪、烈焰花环、魔爆术，暴风雪需要赶紧离开，烈焰花环则不能移动，全体被拉至BOSS身边释放魔爆术时，则需要赶紧逃离BOSS，往房间四处的墙壁跑。而在BOSS血量降至40%时还会召唤4个水元素，优先击杀水元素之后再输出BOSS即可。",
            children = {
                {
                    role = 'TANK',
                    desc = '本场战斗埃兰法系技能目标随机，T站房间中间和近战一起分散输出，出水元素的时候T拉住水元素仇恨。战斗期间尽量打断BOSS的常规读条技能，烈焰花环的时候不要移动，魔爆术时迅速跑到房间最边缘躲避奥爆。',
                }, {
                    role = 'HEALER',
                    desc = '房间外围分散站位治疗，远离BOSS，烈焰花环的时候不要移动，魔爆术时迅速跑到房间最边缘躲避奥爆。\n注意：牧师、骑士优先驱散魔法，尤其是在奥爆时要尽量驱散玩家身上的减速效果。',
                }, {
                    role = 'MELEE',
                    desc = '分散站位输出BOSS，战斗期间尽量打断BOSS的常规读条技能，优先打断火系技能，烈焰花环的时候不要移动，魔爆术时迅速跑到房间最边缘躲避奥爆。出水元素的时候优先击杀水元素。',
                }, {
                    role = 'RANGE',
                    desc = '房间外围分散站位，远离BOSS，烈焰花环的时候不要移动，魔爆术时迅速跑到房间最边缘躲避奥爆。出水元素的时候优先击杀水元素。\n注意：出现水元素时，术士优先放逐水元素。',
                },
            },
        },
        abilities = {
            desc = '埃兰是个法系BOSS，精通三系天赋，无仇恨，攻击目标随机。埃兰常规技能可以打断，特殊技能无法打断。15分钟后未结束战斗会团灭。',
            children = {
                {
                    title = '常规',
                    noCollapse = true,
                    children = {
                        {
                            title = '冰系法术',
                            children = {
                                {spell = 29954, desc = '对玩家造成冰霜伤害并减速。'},
                                {
                                    spell = 29991,
                                    desc = '在玩家周围形成冰链，将目标定在原地，持续10秒。',
                                },
                            },
                        }, {
                            title = '火系法术',
                            children = {
                                {spell = 29953, desc = '对玩家造成火焰伤害。'},
                                {
                                    spell = 35250,
                                    desc = '对面前锥形范围内玩家造成火焰伤害，并陷入混乱状态。',
                                },
                            },
                        }, {
                            title = '奥系法术',
                            children = {
                                {spell = 33419, desc = '对玩家射出魔法箭，造成奥术伤害。'},
                                {spell = 29990, desc = '使玩家攻击速度和移动速度降低，持续10秒。'},
                            },
                        }, {spell = 31596, desc = '打断10码内玩家施法。'},

                    },
                }, {
                    title = '特殊',
                    noCollapse = true,
                    children = {
                        {
                            spell = 29969,
                            desc = '房间随机范围下暴风雪，造成冰霜伤害并减速，暴风雪会绕场缓慢移动。',
                        }, {
                            spell = 29946,
                            desc = '随机玩家脚下出现火圈，任何出入火圈的移动都会造成爆炸效果，击飞当前玩家，全团受到大量火焰伤害。',
                        }, {
                            spell = 29973,
                            desc = 'BOSS使用磁力牵引将所有玩家传送至场地中间，同时释放群体减速，之后会开始读条释放奥爆，10秒后对所有30码范围内玩家造成过量奥术伤害。',
                        },
                        {
                            spell = 29962,
                            desc = 'BOSS血量降至40%时会在房间周围召唤出4个精英水元素。',
                        }, {
                            spell = 29848,
                            desc = 'BOSS法力值降低至20%时，会将所有玩家变羊，期间回复法力值，10秒后释放群体火球，对所有玩家造成大量火焰伤害。',
                        },

                    },
                },

            },
        },
    },
    [655] = {
        name = '歌剧院之罗密欧与朱丽叶',
        bossId = 655,
        icon = 1385758,
        summary = {
            desc = "歌剧院有三种BOSS组合，分别为绿野仙踪、小红帽、罗密欧和朱丽叶，每次随机选择一组。罗密欧和朱丽叶开场时只有朱丽叶在场，击杀之后罗密欧会出现，击杀了罗密欧两个BOSS会一起复活，需要同时击杀两个BOSS才能结束战斗。",
            children = {
                {
                    role = 'TANK',
                    children = {
                        {
                            title = 'P1阶段',
                            desc = '主T将朱丽叶拉至到房间右边，注意打断朱丽叶技能。',
                        }, {
                            title = 'P2阶段',
                            desc = '罗密欧出现时主T将其拉至房间左边，使BOSS背靠墙壁，避免近战被击飞太远。',
                        }, {
                            title = 'P3阶段',
                            desc = '主副T在BOSS起来前就需要站在BOSS倒下的位置，BOSS起来后第一时间拉住仇恨。',
                        },
                    },
                }, {role = 'HEALER', desc = '注意坦克血量，德鲁伊和圣骑士第一时间驱散毒。'}, {
                    role = 'MELEE',
                    children = {
                        {title = 'P1阶段', desc = '全力输出 ，打断朱丽叶技能，尤其是加血技能。'},
                        {title = 'P2阶段', desc = '背靠墙壁输出罗密欧。'}, {
                            title = 'P3阶段',
                            desc = '按照指挥分配输出朱丽叶或者罗密欧，仍旧要注意打断朱丽叶技能。注意2个BOSS血量，需要同时击杀两个BOSS。',
                        },
                    },
                }, {
                    role = 'RANGE',
                    children = {
                        {
                            title = 'P1阶段',
                            desc = '全力输出 ，注意偷取或者驱散朱丽叶buff。术士可以召唤地狱犬去吞噬BOSS的buff。',
                        },
                        {title = 'P2阶段', desc = '全力输出罗密欧，注意偷取或者驱散罗密欧buff。'},
                        {
                            title = 'P3阶段',
                            desc = '按照指挥分配输出朱丽叶或者罗密欧，仍旧要注意偷取或者驱散朱丽叶和罗密欧的buff。注意2个BOSS血量，需要同时击杀两个BOSS。',
                        },
                    },
                },
            },
        },
        abilities = {
            desc = '歌剧院有三种BOSS组合，分别为绿野仙踪、小红帽、罗密欧和朱丽叶，每次随机选择一组。\n罗密欧与朱丽叶整场战斗分为三个阶段，P1只有朱丽叶，P2只有罗密欧，P3同时存在朱丽叶和罗密欧，需要同时击杀才能结束战斗。',
            children = {
                {
                    title = '朱丽叶',
                    noCollapse = true,
                    children = {
                        {
                            spell = 30890,
                            desc = '对一名玩家造成神圣伤害，并且附带持续性伤害效果。',
                        }, {spell = 30887, desc = '提高施法者伤害及攻击速度。'},
                        {spell = 30889, desc = '使目标陷入昏迷，持续6秒。'},
                        {spell = 30878, desc = '治疗盟友，可打断。'},

                    },
                }, {
                    title = '罗密欧',
                    noCollapse = true,
                    children = {
                        {spell = 30815, desc = '攻击BOSS身后一名玩家，造成物理伤害并击飞。'},
                        {
                            spell = 30822,
                            desc = '对玩家造成武器伤害，并使目标属性降低，持续1分钟。',
                        }, {spell = 30841, desc = '提高施法者物理伤害和攻击速度。'},
                        {spell = 30817, desc = '对BOSS前方范围敌人造成武器伤害。'},
                    },
                },

            },
        },
    },
    ['655-1'] = {
        name = '歌剧院之绿野仙踪',
        bossId = '655-1',
        icon = 1385758,
        summary = {
            desc = "歌剧院有三种BOSS组合，分别为绿野仙踪、小红帽、罗密欧和朱丽叶，每次随机选择一组。绿野仙踪开战时会有4个BOSS，战斗期间多萝茜还会召唤托托，其中多萝茜和托托需要坦克分别拉好，胆小的狮子可以选择术士全程恐惧，稻草人可以让法师全程使用灼烧攻击，令稻草人全程处于迷惑状态，而铁皮人速度会越来越慢，可以风筝他。全部击杀完毕之后进入P2阶段，出现巫婆，注意躲避龙卷风即可。",
            children = {
                {
                    role = 'TANK',
                    children = {
                        {
                            title = 'P1阶段',
                            desc = '主T拉住多萝西，远离人群。副T拉住铁皮人，当铁皮人生锈减速后可以风筝铁皮人，出现托托时拉住仇恨。',
                        }, {title = 'P2阶段', desc = '主T拉住巫婆，注意躲避龙卷风。'},
                    },
                }, {
                    role = 'HEALER',
                    children = {
                        {title = 'P1阶段', desc = '治疗全团，注意被多萝西攻击的玩家血量。'},
                        {title = 'P2阶段', desc = '治疗全团，注意躲避龙卷风。'},
                    },
                }, {
                    role = 'MELEE',
                    children = {
                        {
                            title = 'P1阶段',
                            desc = '听从指挥按顺序击杀所有BOSS，推荐击杀顺序为：多萝西>托托>狮子>稻草人>铁皮人。期间注意打断多萝西施法。',
                        }, {title = 'P2阶段', desc = '全力输出巫婆，注意躲避龙卷风。'},
                    },
                }, {
                    role = 'RANGE',
                    children = {
                        {
                            title = 'P1阶段',
                            desc = '听从指挥按顺序击杀所有BOSS，推荐击杀顺序为：多萝西>托托>狮子>稻草人>铁皮人。\n注意：控制稻草人法师需要全程对稻草人使用灼烧技能，确保其一直处于燃烧状态下。控制胆小的狮子的术士可以全程恐惧狮子。',
                        }, {
                            title = 'P2阶段',
                            desc = '全力输出巫婆，注意躲避龙卷风。',
                        },
                    },
                },
            },
        },
        abilities = {
            desc = '歌剧院有三种BOSS组合，分别为绿野仙踪、小红帽、罗密欧和朱丽叶，每次随机选择一组。\n绿野仙踪战斗分为两个阶段，P1开场会有四个BOSS，分别是多萝茜、胆小的狮子、稻草人和铁皮人，战斗期间多萝茜会召唤托托，全部击杀完毕之后进入P2，P2只有一个BOSS巫婆，击杀就结束了战斗。',
            children = {
                {
                    title = '多萝茜',
                    noCollapse = true,
                    children = {
                        {spell = 31012, desc = '对目标造成大量冰伤害。'},
                        {spell = 31013, desc = '范围恐惧玩家。'},
                        {spell = 31014, desc = '召唤野兽托托。'},

                    },
                },
                {
                    title = '胆小的狮子',
                    noCollapse = true,
                    children = {{spell = 31042, desc = '降低目标的护甲值。'}},
                }, {
                    title = '稻草人',
                    noCollapse = true,
                    children = {
                        {spell = 31046, desc = '猛击目标，使其陷入昏迷。'},
                        {spell = 31075, desc = '使施法者在被火焰法术击中时陷入困惑。'},
                        {spell = 31069, desc = '沉默一名玩家，持续4秒。'},
                    },
                }, {
                    title = '铁皮人',
                    noCollapse = true,
                    children = {
                        {spell = 31043, desc = '对目标及周围多个玩家造成物理伤害。'},
                        {spell = 31086, desc = '使铁皮人生锈，移动速度降低。'},
                    },
                }, {
                    title = '巫婆',
                    noCollapse = true,
                    children = {
                        {
                            spell = 32337,
                            desc = '向目标射出一支闪电箭，闪电箭在命中目标后会弹跳至附近目标身上，最多可攻击5个目标，对击中的玩家造成递增的自然伤害。',
                        }, {spell = 32334, desc = '造成伤害并将目标卷上空中，打断目标施法。'},
                    },
                },

            },
        },
    },
    ['655-2'] = {
        name = '歌剧院之小红帽',
        bossId = '655-2',
        icon = 1385758,
        summary = {
            desc = "歌剧院有三种BOSS组合，分别为绿野仙踪、小红帽、罗密欧和朱丽叶，每次随机选择一组。整场战斗只有大灰狼一个BOSS，最主要技能就是会随机将一个玩家变为小红帽，这时大灰狼就会无视仇恨追逐小红帽，被变成小红帽的玩家需要绕着房间外围逃跑避免被大灰狼追到，变化时间到了坦克再去拉住大灰狼仇恨，如此反复即可击杀BOSS。",
            children = {
                {
                    role = 'TANK',
                    desc = '主T将大灰狼拉至房间角落，小红帽变形结束后注意拉住BOSS仇恨。',
                }, {
                    role = 'HEALER',
                    desc = '站在场地中间治疗，注意被变形为小红帽玩家的血量。若被变形为小红帽则需要在房间外围绕圈跑，尽量远离大灰狼。',
                }, {
                    role = 'MELEE',
                    desc = '全力输出BOSS，若被变形为小红帽则需要在房间外围绕圈跑，尽量远离大灰狼。',
                }, {
                    role = 'RANGE',
                    desc = '站在场地中间输出BOSS。若被变形为小红帽则需要在房间外围绕圈跑，尽量远离大灰狼。',
                },
            },
        },
        abilities = {
            desc = '歌剧院有三种BOSS组合，分别为绿野仙踪、小红帽、罗密欧和朱丽叶，每次随机选择一组。\n小红帽组只有一个BOSS：大灰狼，战斗期间会随机将一名玩家变为小红帽，BOSS会无视仇恨只追击小红帽。',
            children = {
                {
                    title = '大灰狼',
                    noCollapse = true,
                    children = {
                        {spell = 30752, desc = '恐惧附近玩家。'}, {
                            spell = 30753,
                            desc = '将随机玩家标记为小红帽，持续10秒，大灰狼会无视仇恨只攻击小红帽。',
                        }, {spell = 30761, desc = '对前方范围内玩家造成伤害并击晕。'},

                    },
                },

            },
        },
    },
    [656] = {
        name = '馆长',
        bossId = 656,
        icon = 1379020,
        summary = {
            desc = "馆长拥有高血量和强大的物理攻击，并且免疫奥系法术。战斗开始馆长身上会有减伤的BUFF，期间会消耗法力值召唤闪电球，在法力值消耗完毕之后就会停止攻击进入唤醒状态，在此状态下攻击BOSS会获得伤害加成，在法力值全满之后又进入P1阶段，如此循环直至BOSS倒下。",
            children = {
                {
                    role = 'TANK',
                    desc = '主T将BOSS拉在角落，副T在BOSS边上，确保自己为第二仇恨。P2时副T也需要全力DPS。',
                },
                {
                    role = 'HEALER',
                    desc = '分散站位，确保T和近战的血量。P2有蓝的治疗可以适当输出BOSS。',
                }, {
                    role = 'MELEE',
                    children = {
                        {
                            title = 'P1阶段',
                            desc = '优先击杀闪电球，不要过于靠近远程和治疗队伍。',
                        }, {title = 'P2阶段', desc = '全力输出BOSS。'},
                    },
                }, {
                    role = 'RANGE',
                    children = {
                        {title = 'P1阶段', desc = '分散站位，优先击杀闪电球。'},
                        {title = 'P2阶段', desc = '全力输出BOSS。'},
                    },
                },
            },
        },
        abilities = {
            desc = '馆长的战斗基本分为两阶段，P1馆长身上会有减伤的buff，因此DPS们需要优先击杀馆长放出的闪电球。馆长蓝量消耗完之后会进入P2开始唤醒，唤醒期间会有易伤，此时需要全力输出，唤醒结束继续回到P1阶段，如此循环直至BOSS倒下。12分钟后战斗未结束馆长会秒杀所有玩家。',
            children = {
                {spell = 30403, desc = '对近战攻击命中的玩家造成额外的奥术伤害。'},
                {spell = 30383, desc = '对第二仇恨玩家造成大量奥术伤害。'}, {
                    spell = 30235,
                    desc = '消耗自身法力值召唤闪电球，闪电球会释放闪电链，对目标造成奥术伤害，并弹跳至其他玩家身上造成伤害。',
                }, {
                    spell = 30254,
                    desc = '法力值消耗完毕后进入唤醒回复法力值阶段，回复期间受到伤害提高200%。',
                },
                {
                    spell = 8599,
                    desc = 'BOSS血量降低至15%左右会进入激怒状态，伤害和攻击速度提高。',
                },

            },
        },
    },
    [660] = {
        name = '国际象棋',
        bossId = 660,
        icon = 1385725,
        summary = {
            desc = "国际象棋是一场非常特殊的战斗，整场战斗不需要使用角色技能，全靠控制棋子后，移动并使用棋子的技能击杀对立阵营领袖即可获得胜利。战斗开始后需要先移开前排中间的士兵，然后移动国王/酋长、人类祭司/兽人通灵师、人类法师/兽人术士。集中火力攻击对方阵营的治疗者，然后再攻击对方领袖，注意自己的领袖不要过于深入，人类祭司/兽人通灵师需要跟随好己方领袖并治疗即可。",
            children = {
                {title = '人类步兵/兽人士兵', desc = '向前，让开通道便于其他棋子出来。'},
                {title = '召唤的水元素/被召唤的恶魔', desc = '移动上前，吸引敌方棋子。'},
                {title = '人类骑兵/兽人座狼', desc = '移动上前，吸引敌方棋子。'}, {
                    title = '人类召唤师/兽人术士',
                    desc = '优先消灭敌方的兽人通灵师/人类祭司。治疗死后就可以直接攻击敌方领袖。',
                }, {
                    title = '国王/酋长',
                    desc = '给己方棋子加BUFF，移动至己方棋子身后参与攻击，不要直接受到敌方棋子攻击。',
                }, {
                    title = '人类祭司/兽人通灵师',
                    desc = '1. 跟随在国王/酋长身后给己方领袖治疗。\n2. 集中攻击敌方领袖。',
                },
            },
        },
        abilities = {
            desc = '国际象棋是一场非常特殊的战斗，整场战斗不需要玩家角色技能，全靠控制棋子后，移动并使用棋子的技能。双方阵营各有16颗棋子，6种类型，与所属阵营的国王/酋长对话即可开启战斗，控制棋子清空对立阵营领袖血量，战斗即为胜利。\n注意：每个棋子都有技能冷却时间，若想要更换棋子，只需点击取消角色右上角的debuff即可。',
            children = {
                {
                    title = '国王/酋长',
                    desc = '1. 对身前范围内敌方棋子造成伤害。\n2. 提高周围己方棋子伤害，持续10秒。',
                }, {
                    title = '人类法师/兽人术士',
                    desc = '1. 对敌方棋子造成单体伤害。\n2. 对任意敌方棋子及其周围棋子造成持续伤害。',
                }, {
                    title = '人类祭司/兽人通灵师',
                    desc = '1. 恢复目标血量。\n2. 对敌方阵营棋子造成单体伤害。',
                }, {
                    title = '人类骑兵/兽人座狼',
                    desc = '1. 对正面敌方棋子造成单体伤害。\n2. 降低周围敌方棋子的物理伤害。',
                }, {
                    title = '召唤的水元素/被召唤的恶魔',
                    desc = '1. 对附近敌方棋子造成伤害。\n2. 使自身受到的伤害降低。',
                },
                {
                    title = '人类步兵/兽人士兵',
                    desc = '1. 对正面敌方棋子造成伤害。\n2. 吸收伤害技能。',
                },
            },
        },
    },
    [652] = {
        name = '猎手阿图门',
        bossId = 652,
        icon = 1378965, --
        summary = {
            desc = "卡拉赞一号BOSS是猎手阿图门，战斗开始时只有午夜单独存在，午夜血量降低至95%阿图门才会出现，午夜血量降至25%的时候，战斗进入P2阶段，阿图门会骑上午夜，并且血量全满，这时击杀了阿图门战斗即可结束。",
            children = {
                {
                    role = 'TANK',
                    children = {
                        {
                            title = 'P1阶段',
                            desc = '副T拉住午夜，阿图门出现时主T第一时间拉住，让BOSS背对大团，可以缴械BOSS。',
                        }, {title = 'P2阶段', desc = '阿图门上马后主T拉住，让BOSS背对大团。'},
                    },
                }, {role = 'HEALER', desc = '注意主T血量，BOSS上马后靠近阿图门，在BOSS背面治疗。'},
                {
                    role = 'MELEE',
                    desc = '优先输出午夜，BOSS上马后输出阿图门，全程躲开阿图门正面。',
                }, {
                    role = 'RANGE',
                    desc = '优先输出午夜，BOSS上马后靠近阿图门，在BOSS背面输出，法师注意解诅咒。',
                },
            },
        },
        abilities = {
            desc = '猎手阿图门整场战斗分为2个阶段，P1一开始只有午夜在场，午夜血量降低至95%时阿图门会出现，需要主副T及时拉住两个BOSS仇恨。在午夜血量降低至25%时进入P2阶段，阿图门会骑上午夜并且血量全满。',
            children = {
                {
                    title = '午夜',
                    noCollapse = true,
                    children = {{spell = 29711, desc = '对当前目标造成大量伤害并将其击倒，持续3秒'}},
                }, {
                    title = '阿图门',
                    noCollapse = true,
                    children = {
                        {
                            title = 'P1阶段',
                            children = {
                                {spell = 29832, desc = '对目标和周围玩家造成大量暗影伤害。'}, {
                                    spell = 29833,
                                    desc = '群体诅咒，每隔一段时间对一定范围内玩家释放，使玩家法术和近战攻击命中下降。',
                                },
                            },
                        }, {
                            title = 'P2阶段',
                            children = {
                                {
                                    spell = 26561,
                                    desc = '随机对一名远程目标进行冲锋并造成大量伤害。',
                                }, {spell = 29832, desc = '对目标和周围玩家造成大量暗影伤害。'}, {
                                    spell = 29833,
                                    desc = '群体诅咒，每隔一段时间对一定范围内玩家释放，使玩家法术和近战攻击命中下降。',
                                },
                            },
                        },

                    },
                },
            },
        },
    },
    [661] = {
        name = '玛克扎尔王子',
        bossId = 661,
        icon = 1379006, --
        summary = {
            desc = "玛克扎尔王子是卡拉赞的最终BOSS，王子血量很高，整场战斗治疗的压力会比较大。战斗分为三个阶段，P1阶段BOSS会随机点名5位玩家将其血量降低为1点，并使受到的治疗效果降低100%，所以治疗无法加血，因此被点名的玩家需要及时躲避范围伤害，不然会被秒杀。BOSS血量60%的时候进入P2阶段，王子停止点名玩家，但增加了强力的物理攻击，需要保障好坦克血量。BOSS血量30%时进入P3阶段，王子会使用飞斧攻击随机目标，需要治疗多注意被飞斧攻击的玩家血量，同时他又开始随机点名玩家血量降至1点，被点名玩家注意躲避伤害。",
            children = {
                {role = 'TANK', desc = '主T全程拉住BOSS仇恨即可。'}, {
                    role = 'HEALER',
                    desc = '最远距离治疗，中了能量衰弱后注意躲开地狱火的范围伤害，牧师注意驱散痛。进入P2注意T的血量，进入P3注意T和被飞斧攻击的玩家血量。',
                }, {
                    role = 'MELEE',
                    desc = '输出BOSS，中了能量衰弱后立即离开BOSS身边，等血量恢复之后再返回输出，注意躲开地狱火的范围伤害。',
                },
                {
                    role = 'RANGE',
                    desc = '最远距离输出BOSS，中了能量衰弱后注意躲开地狱火的范围伤害。',
                },
            },
        },
        abilities = {
            desc = '玛克扎尔王子是卡拉赞的终极BOSS，整场战斗分为3个阶段。BOSS血量到60%的时候进入P2，停止释放暗言术痛和地狱火，增加了强力的物理攻击技能，血量30%时进入P3，停止释放能量衰弱，增加了伤害增效技能，并使用飞斧攻击随机目标。',
            children = {
                {
                    title = 'P1阶段',
                    noCollapse = true,
                    children = {
                        {spell = 30898, desc = '每3秒造成一次暗影伤害，持续18秒。'}, {
                            spell = 30843,
                            desc = '对随机5名玩家释放，使其生命值降为1点，且受到的治疗效果和恢复生命值速度降低100%。',
                        }, {
                            spell = 30852,
                            desc = '释放能量衰弱后会释放暗影新星，对30码内所有玩家造成暗影伤害并击退。',
                        }, {
                            spell = 12740,
                            desc = '战斗开始45秒后会召唤一个地狱火，地狱火3秒后会开始释放地狱烈焰，使范围内所有玩家受到火焰伤害，同时最多存在4个地狱火，持续3分钟。',
                        },
                    },
                }, {
                    title = 'P2阶段',
                    noCollapse = true,
                    children = {
                        {spell = 3391, desc = '施法者获得两次额外的攻击机会。'},
                        {
                            spell = 30901,
                            desc = '每次破甲可以使目标护甲值降低，可叠加5次，持续20秒。',
                        },
                    },
                }, {
                    title = 'P3阶段',
                    noCollapse = true,
                    children = {
                        {spell = 39095, desc = '使目标承受的所有伤害提高100%，持续10秒。'},
                        {spell = 30891, desc = '召唤飞斧攻击随机目标。'},
                    },
                },
            },
        },
    },
    [653] = {
        name = '莫罗斯',
        bossId = 653,
        icon = 1378999,
        summary = {
            desc = "卡拉赞二号BOSS是莫罗斯，莫罗斯周围会带有4个随从，这4个随从是从6个固定的随从中随机刷新的。莫罗斯最主要技能时绞喉，随机目标持续五分钟，所以战斗越久队伍压力越大，莫罗斯和4个随从击杀顺序的安排就尤为重要。",
            children = {
                {
                    role = 'TANK',
                    desc = '主T将莫罗斯拉至台子下，副T保持莫罗斯的第二仇恨，在主T被致盲或者凿击之后拉住BOSS仇恨。被控制随从先不要去动，直到其他随从已被击杀再听从指挥拉住随从仇恨。\n注意：无论何种组合，随从击杀顺序推荐如下：卡翠欧娜·沃宁迪女伯爵>吉拉·拜瑞巴克女伯爵>杜萝希·米尔斯迪普女伯爵>罗宾·达尼斯伯爵>拉弗·德鲁格尔男爵>克里斯宾·费伦斯伯爵。',
                }, {
                    role = 'HEALER',
                    desc = '根据指挥分配治疗，注意被绞喉玩家血量。\n注意：牧师听从指挥优先使用束缚亡灵控制随从。',
                }, {
                    role = 'MELEE',
                    desc = '按照指挥所说顺序击杀随从和莫罗斯。\n注意：无论何种组合，随从击杀顺序推荐如下：卡翠欧娜·沃宁迪女伯爵>吉拉·拜瑞巴克女伯爵>杜萝希·米尔斯迪普女伯爵>罗宾·达尼斯伯爵>拉弗·德鲁格尔男爵>克里斯宾·费伦斯伯爵。',
                }, {
                    role = 'RANGE',
                    desc = '按照指挥所说顺序击杀随从和莫罗斯。法师和猎人可以辅助牧师控制随便，帮忙冰环或者冰冻陷阱。\n注意：无论何种组合，随从击杀顺序推荐如下：卡翠欧娜·沃宁迪女伯爵>吉拉·拜瑞巴克女伯爵>杜萝希·米尔斯迪普女伯爵>罗宾·达尼斯伯爵>拉弗·德鲁格尔男爵>克里斯宾·费伦斯伯爵。',
                },
            },
        },
        abilities = {
            desc = '莫罗斯身边会有四个随从，每次都是从六个随从内随机选取四个随从。可根据队伍配置选择先击杀的随从数量，剩余的可保持控制，BOSS击杀后再杀。\n各随从技能如下：',
            children = {
                {
                    title = '卡翠欧娜·沃宁迪女伯爵',
                    noCollapse = true,
                    children = {
                        {spell = 15090, desc = '驱散目标身上魔法效果。'},
                        {spell = 29408, desc = '为友方加上魔法护盾，吸收伤害。'},
                        {spell = 34119, desc = '治疗友方目标。'},
                    },
                }, {
                    title = '吉拉·拜瑞巴克女伯爵',
                    noCollapse = true,
                    children = {
                        {spell = 29381, desc = '使附近友方目标攻击强度增加。'},
                        {spell = 29562, desc = '治疗友方目标。'},
                    },
                }, {
                    title = '杜萝希·米尔斯迪普女伯爵',
                    noCollapse = true,
                    children = {
                        {
                            spell = 29406,
                            desc = '进入暗影形态，造成暗影伤害提高，受到近战伤害降低。',
                        }, {spell = 29405, desc = '抽取附近玩家法力值并使其受到伤害。'},
                    },
                }, {
                    title = '罗宾·达尼斯伯爵',
                    noCollapse = true,
                    children = {
                        {
                            spell = 29572,
                            desc = '对玩家造成大量物理伤害，并使任何对目标释放的治疗效果减弱，持续5秒。',
                        }, {spell = 9080, desc = '对玩家造成武器伤害，并使其移动速度降低。'},
                        {spell = 15589, desc = '对周围所有玩家造成物理伤害。'},
                    },
                }, {
                    title = '拉弗·德鲁格尔男爵',
                    noCollapse = true,
                    children = {
                        {spell = 13005, desc = '使目标昏迷，持续5秒。'},
                        {spell = 29386, desc = '审判玩家，造成神圣伤害。'},
                    },
                }, {
                    title = '克里斯宾·费伦斯伯爵',
                    noCollapse = true,
                    children = {
                        {spell = 11972, desc = '使用盾牌猛击敌人，打断并造成武器伤害。'},
                        {spell = 8379, desc = '使敌人无法使用武器作战，持续10秒。'},
                    },
                }, {
                    title = '莫罗斯',
                    noCollapse = true,
                    children = {
                        {spell = 29448, desc = 'BOSS进入潜行状态。'},
                        {
                            spell = 29425,
                            desc = '对玩家造成伤害并使其昏迷6秒，技能会在玩家面对BOSS的时候发动。',
                        }, {spell = 21060, desc = '使目标短暂失明并到处乱走。'},
                        {spell = 37066, desc = '随机绞喉一名玩家，使其受到持续伤害，持续5分钟。'},
                        {
                            spell = 8599,
                            desc = 'BOSS血量降低至30%进入激怒状态，伤害和攻击速度提高。',
                        },
                    },
                },
            },
        },
    },
    [657] = {
        name = '特雷斯坦·邪蹄',
        bossId = 657,
        icon = 1379017, --
        summary = {
            desc = "特雷斯坦·邪蹄身边跟随着一个精英的小鬼，小鬼在死后会给予BOSS一个易伤的buff，30秒后BOSS会重新召唤精英小鬼。BOSS房间内还会出现2个传送门，不断刷新出非精英的小鬼，需要术士对着BOSS释放腐蚀之种，爆炸会对周围的小鬼造成伤害并拉住小鬼仇恨。BOSS还会随机将一名玩家传送到房间绿圈内锁住，需要优先摧毁锁链救出队友，然后再输出BOSS。",
            children = {
                {
                    role = 'TANK',
                    desc = '主T将BOSS拉至绿圈附近，副T将精英小鬼拉在BOSS边上，精英小鬼再一次刷新出来时副T也要迅速拉住仇恨。\n指定术士T在传送门出现后不断的对BOSS上腐蚀之种，爆炸会对周围的小鬼造成伤害并拉住小鬼仇恨。',
                }, {
                    role = 'HEALER',
                    desc = '在绿圈附近治疗，尽量靠近远程输出，便于远程帮忙清理小鬼。期间有玩家被锁在绿圈就优先治疗被锁住的玩家，确保其在锁链被摧毁前存活。',
                }, {
                    role = 'MELEE',
                    desc = '在绿圈附近输出BOSS，期间有玩家被锁在绿圈就优先击杀锁链救人，精英小鬼死后立即全力输出BOSS。',
                }, {
                    role = 'RANGE',
                    desc = '在绿圈附近输出BOSS，期间有玩家被锁在绿圈就优先击杀锁链救人，精英小鬼死后立即全力输出BOSS。\n注意：传送门内小鬼出来的多了，需要法师配合术士清理掉一批之后再输出BOSS。',
                },
            },
        },
        abilities = {
            desc = '特雷斯坦·邪蹄带着一个精英小鬼，当这个小鬼被击杀之后BOSS会有易伤，30秒后易伤结束，精英小鬼也会重新刷新。整场战斗需要一个术士坦克，来拉住传送门内出来的小鬼仇恨。10分钟后未结束战斗，BOSS会释放群体暗影箭导致团灭。',
            children = {
                {
                    title = '特雷斯坦·邪蹄',
                    noCollapse = true,
                    children = {
                        {
                            spell = 30115,
                            desc = '随机将一名玩家传送至房间绿圈内，玩家会被锁链锁住，每秒受到暗影伤害并处于昏迷状态，所受伤害还会恢复邪蹄血量，锁链可以被摧毁。',
                        },
                        {
                            spell = 30171,
                            desc = '召唤一道传送门，门内会周期性的召唤出非精英的小鬼。',
                        }, {spell = 30066, desc = '召唤基尔里克为BOSS作战。'},
                    },
                }, {
                    title = '基尔里克（精英小鬼）',
                    noCollapse = true,
                    children = {
                        {spell = 30053, desc = '使玩家受到的火焰伤害提高500点，持续25秒。'}, {
                            spell = 30065,
                            desc = '基尔里克死亡，邪蹄受到伤害增加25%，持续30秒。时间结束邪蹄会重新召唤基尔里克。',
                        },
                    },
                },
            },
        },
    },
    [659] = {
        name = '虚空幽龙',
        bossId = 659,
        icon = 1379002, --
        summary = {
            desc = "虚空幽龙战斗基本分为两个阶段，P1为虚空门阶段，P2是放逐阶段。P1的时候BOSS房间三个角落会出现三个虚空门，释放不同颜色的光线，这些光线射到BOSS身上会增强BOSS，所以需要提前分配好队友挡住光线。P2放逐阶段BOSS无法移动，会固定在房间中央，随机选择目标释放范围性的吐息，P2阶段只持续30秒就又进入P1阶段，两个阶段不断交替直至BOSS倒下。",
            children = {
                {
                    role = 'TANK',
                    footDesc = "之后一直重复以上的阶段，主T和副T轮流挡住一个阶段的红光。阶段转换时仇恨会清空，第一时间拉住BOSS仇恨。",
                    children = {
                        {
                            title = 'P1阶段',
                            desc = '主T将BOSS拉至场地中间，红光出现时注意调整自身位置，让红光射到主T身上。红光叠加层数过高时，听指挥让其他人接替红光。',
                        }, {title = 'P2阶段', desc = 'T拉住BOSS仇恨即可。'}, {
                            title = '第二次P1',
                            desc = '副T将BOSS拉住，并挡住红色光线。红光叠加层数过高时，可听指挥让其他人接替红光。',
                        }, {
                            title = '第二次P2',
                            desc = 'T拉住BOSS仇恨即可。',
                        },
                    },
                }, {
                    role = 'HEALER',
                    footDesc = "两阶段循环直至BOSS倒下。",
                    children = {
                        {
                            title = 'P1阶段',
                            desc = '治疗全团，注意挡住蓝色光线的远程血量，躲避脚下黑圈。指挥分配的两名治疗提前站位，接替挡住绿色光线。',
                        }, {
                            title = 'P2阶段',
                            desc = '分散站位，治疗全团，确保全团血量在5000以上。',
                        },
                    },
                }, {
                    role = 'MELEE',
                    footDesc = "两阶段循环直至BOSS倒下，阶段转换的时候注意停手。",
                    children = {
                        {title = 'P1阶段', desc = '输出BOSS，注意躲避脚下黑圈。'}, {
                            title = 'P2阶段',
                            desc = '分散最远距离输出BOSS。确保自己血量在5000以上。',
                        },
                    },
                }, {
                    role = 'RANGE',
                    footDesc = "两阶段循环直至BOSS倒下，阶段转换的时候注意停手。",
                    children = {
                        {
                            title = 'P1阶段',
                            desc = '输出BOSS，注意躲避脚下黑圈。指挥分配的两名远程提前站位，接替挡住蓝色光线。',
                        }, {
                            title = 'P2阶段',
                            desc = '分散站位输出BOSS。不要超过治疗范围，确保自己血量在5000以上。',
                        },
                    },
                },
            },
        },
        abilities = {
            desc = '虚空幽龙整场战斗可以分成两个阶段，P1为虚空门发射光线阶段，持续60秒左右，就会进入下一个阶段，P2虚空幽龙会处于放逐状态，无法移动，持续30秒之后又会重新进入P1，两个阶段不断交替直至BOSS倒下。9分钟内未结束战斗，BOSS伤害会大幅度增加导致团灭。',
            children = {
                {
                    title = '虚空幽龙',
                    noCollapse = true,
                    children = {
                        {spell = 30522, desc = '每5秒对所有人造成一次暗影伤害。'}, {
                            spell = 28863,
                            desc = '随机玩家脚下召唤一个虚空领域，对站在范围内的所有玩家造成暗影伤害',
                        },
                    },
                }, {
                    title = 'P1阶段',
                    noCollapse = true,
                    desc = '三个虚空门会射出三种不同的光线，每种光线射在玩家身上均会产生一个20秒的buff，buff可叠加并有各自不同的效果，buff消失后会产生“虚空疲劳“，90秒内无法再获得加成的buff。',
                    children = {
                        {
                            spell = 30466,
                            desc = '硬化虚空幽龙的外壳，使其承受的伤害减少。玩家挡住光线会获得坚韧buff，减少生命值上限并成为BOSS仇恨目标，每次叠加玩家都会自动回满生命值。',
                        }, {
                            spell = 30467,
                            desc = '每秒为虚空幽龙恢复生命值。玩家挡住光线会获得平静buff，减少法力值上限和技能消耗，还会提升治疗效果。',
                        },
                        {
                            spell = 30468,
                            desc = '使虚空幽龙伤害提高。玩家挡住光线会获得统御buff，提升法术伤害。',
                        },
                    },
                }, {
                    title = 'P2阶段',
                    noCollapse = true,
                    children = {
                        {
                            spell = 38523,
                            desc = '对目标方向锥形范围喷吐，范围内玩家都会受到大量伤害并被击退。',
                        },
                    },
                },
            },
        },
    },
    [662] = {
        name = '夜之魇',
        bossId = 662,
        icon = 1379003,
        summary = {
            desc = "夜之魇是在卡拉赞露台召唤的骨龙，需要完成一系列前置任务才能召唤。整场战斗在两个阶段间循环，P1为地面阶段，会群体恐惧，并且需要注意躲开地面的灼烧效果。在BOSS血量达到75%、50%、25%时都会进入P2空中阶段，此时BOSS会飞上天，对地面喷吐技能并生成骷髅，注意躲避并击杀骷髅。在空中一段时间之后就会下地进入P1，如此循环直至BOSS倒下。",
            children = {
                {
                    role = 'TANK',
                    children = {
                        {
                            title = 'P1阶段',
                            desc = '主T将BOSS拉在场地中间，头朝外，避免其他玩家吃到吐息和扫尾。',
                        }, {
                            title = 'P2阶段',
                            desc = '夜之魇上天，期间和所有玩家一起躲避BOSS技能，骨雨落下时跑开，但不可出BOSS攻击范围，骨雨结束后拉住骷髅仇恨。\n等待BOSS下地第一时间拉住仇恨，两阶段循环直至BOSS倒下。',
                        },
                    },
                }, {
                    role = 'HEALER',
                    children = {
                        {
                            title = 'P1阶段',
                            desc = '站在BOSS两侧，最远距离加血，可以通过后退超出治疗主T的范围来躲避恐惧，注意躲避脚下灼烧范围。牧师给T加好反恐惧结界。\n注意：战斗期间骑士可以开火炕和虔诚光环。',
                        }, {
                            title = 'P2阶段',
                            desc = '夜之魇上天，骨雨落下时和所有玩家一起跑开，但不可出BOSS攻击范围，加好BOSS技能目标的血量，并及时驱散。\n注意：战斗期间骑士可以开火炕和虔诚光环。',
                        },
                    },
                }, {
                    role = 'MELEE',
                    children = {
                        {
                            title = 'P1阶段',
                            desc = '站在BOSS两侧输出，被恐惧后返回继续输出，注意躲避脚下灼烧范围。',
                        }, {
                            title = 'P2阶段',
                            desc = '夜之魇上天，骨雨落下时和所有玩家一起移动，但不可出BOSS攻击范围，骨雨结束后击杀骷髅。\n注意：BOSS下地时停止攻击等待主T拉好仇恨。',
                        },
                    },
                }, {
                    role = 'RANGE',
                    children = {
                        {
                            title = 'P1阶段',
                            desc = '站在BOSS两侧，最远距离输出，被恐惧后返回继续输出，注意躲避脚下灼烧范围。',
                        }, {
                            title = 'P2阶段',
                            desc = '夜之魇上天，骨雨落下时和所有玩家一起移动，但不可出BOSS攻击范围，骨雨结束后击杀骷髅。\n注意：BOSS下地时停止攻击等待主T拉好仇恨。',
                        },
                    },
                },
            },
        },
        abilities = {
            desc = '夜之魇是召唤出的BOSS，需要队伍内有玩家完成对应前置任务，才能在卡拉赞露台上召唤出夜之魇。整场战斗分为两个阶段，P1为地面阶段，P2为空中阶段。在BOSS血量达到75%、50%、25%时都会进入空中阶段，在空中一段时间之后就会下地，如此循环直至BOSS倒下。',
            children = {
                {
                    title = '地面阶段',
                    noCollapse = true,
                    children = {
                        {spell = 36922, desc = '释放龙吼，使得所有玩家因恐惧而逃跑。'},
                        {spell = 31043, desc = '对目标及周围多个玩家造成物理伤害。'},
                        {spell = 30210, desc = '对目标正前方的玩家造成大量暗影烈焰伤害。'},
                        {spell = 25653, desc = '对目标后方的玩家造成物理伤害并击退。'},
                        {
                            spell = 30129,
                            desc = '烧灼玩家脚下的地面，每秒对范围内玩家造成持续伤害。',
                        },
                    },
                }, {
                    title = '空中阶段',
                    noCollapse = true,
                    children = {
                        {spell = 37091, desc = '对地面喷吐，造成伤害并生成5个骷髅。'},
                        {
                            spell = 30127,
                            desc = '对仇恨最高玩家释放，造成大量物理伤害并附加一个持续伤害。',
                        }, {
                            spell = 29647,
                            desc = '夜之魇上天后，若有任何玩家在夜之魇攻击范围外，将释放此技能对所有玩家造成大量伤害，直到所有玩家进入攻击范围内。',
                        },
                    },
                },
            },
        },
    },
    [654] = {
        name = '贞节圣女',
        bossId = 654,
        icon = 1378997, --
        summary = {
            desc = "卡拉赞三号BOSS是贞节圣女，贞节圣女整场战斗最主要技能是忏悔，会昏迷所有玩家10秒，受到伤害即可解除昏迷状态，所以圣骑士可以提前给坦克加上牺牲祝福，坦克受到伤害的时候圣骑士也会解除昏迷确保坦克血量。其他玩家也可以在技能来临之前提前进入BOSS奉献区域内，靠BOSS释放奉献技能造成伤害中断昏迷效果。",
            children = {
                {
                    role = 'TANK',
                    desc = '本场战斗只需要一个坦克，主T将BOSS拉至场地中间。若没有牺牲祝福，T可以在忏悔期间将BOSS拉至治疗附近，以便于BOSS释放奉献时解除治疗的昏迷，解除完毕之后拉回原位。',
                }, {
                    role = 'HEALER',
                    desc = '分散在场地外围，和周围玩家保持距离，几个治疗间隔站位，确保可以驱散并治疗到所有玩家。优先驱散神圣之火。\n注意：若有圣骑士，给主T加好牺牲祝福，解除昏迷之后治疗主T。若没有圣骑士，治疗可以在忏悔之前进入BOSS奉献范围内，解除昏迷之后返回外围治疗。',
                }, {role = 'MELEE', desc = '最远距离输出BOSS，打断好神圣之火。'},
                {role = 'RANGE', desc = '分散在场地外围，和周围玩家保持10码距离输出BOSS。'},
            },
        },
        abilities = {
            desc = '贞节圣女会群体控制技能，建议圣骑士给主T加好牺牲祝福，忏悔期间圣骑士可以解除昏迷，确保主T的血量。',
            children = {
                {
                    spell = 32445,
                    desc = '对目标造成大量神圣伤害，会跳跃至范围内其他玩家，再链接至下一个范围内玩家，以此类推，每一次跳跃会造成更大的伤害，持续20秒。',
                }, {
                    spell = 29522,
                    desc = '随机对一名玩家释放，造成大量火焰伤害并附带持续伤害效果，可驱散。',
                },
                {
                    spell = 26573,
                    desc = '在BOSS半径12码范围内不断释放，对范围内玩家造成神圣伤害，并沉默。',
                }, {
                    spell = 29511,
                    desc = '对所有玩家造成大量神圣伤害，并使所有人昏迷10秒，受到任何伤害都可以解除昏迷状态。',
                },
            },
        },
    },
    --
}

local ENCOUNTER_INSTANCES = {
    [531] = {
        title = '安其拉',
        instanceId = 531,
        bosses = {
            ENCOUNTER_BOSSES[709], ENCOUNTER_BOSSES[710], ENCOUNTER_BOSSES[711], ENCOUNTER_BOSSES[712],
            ENCOUNTER_BOSSES[713], ENCOUNTER_BOSSES[714], ENCOUNTER_BOSSES[715], ENCOUNTER_BOSSES[716],
            ENCOUNTER_BOSSES[717],
        },
        zones = {},
    },
    [533] = {
        title = '纳克萨玛斯',
        instanceId = 533,
        bosses = {
            ENCOUNTER_BOSSES[1107], ENCOUNTER_BOSSES[1110], ENCOUNTER_BOSSES[1116], ENCOUNTER_BOSSES[1117],
            ENCOUNTER_BOSSES[1112], ENCOUNTER_BOSSES[1115], ENCOUNTER_BOSSES[1113], ENCOUNTER_BOSSES[1109],
            ENCOUNTER_BOSSES[1121], ENCOUNTER_BOSSES[1118], ENCOUNTER_BOSSES[1111], ENCOUNTER_BOSSES[1108],
            ENCOUNTER_BOSSES[1120], ENCOUNTER_BOSSES[1119], ENCOUNTER_BOSSES[1114],
        },
        zones = {
            {zone = 1, text = '蜘蛛区'}, --
            {zone = 2, text = '瘟疫区'}, --
            {zone = 3, text = '军事区'}, --
            {zone = 4, text = '构造区'}, --
            {zone = 5, text = '中心区'}, --
        },
    },
    --[[@bcc@
    [532] = {
        title = '卡拉赞',
        instanceId = 532,
        bosses = {
            ENCOUNTER_BOSSES[652], ENCOUNTER_BOSSES[653], ENCOUNTER_BOSSES[654], ENCOUNTER_BOSSES[655],
            ENCOUNTER_BOSSES['655-1'], ENCOUNTER_BOSSES['655-2'], ENCOUNTER_BOSSES[656], ENCOUNTER_BOSSES[658],
            ENCOUNTER_BOSSES[657], ENCOUNTER_BOSSES[659], ENCOUNTER_BOSSES[660], ENCOUNTER_BOSSES[661],
            ENCOUNTER_BOSSES[662],
        },
        zones = {},
    },
    [544] = {title = '玛瑟里顿的巢穴', instanceId = 544, bosses = {ENCOUNTER_BOSSES[651]}, zones = {}},
    [565] = {
        title = '格鲁尔的巢穴',
        instanceId = 565,
        bosses = {ENCOUNTER_BOSSES[649], ENCOUNTER_BOSSES[650]},
        zones = {},
    },
    --@end-bcc@]]
}

local ENCOUNTER_DATA = {
    --[[@bcc@
    ENCOUNTER_INSTANCES[532], --
    ENCOUNTER_INSTANCES[544], --
    ENCOUNTER_INSTANCES[565], --
    --@end-bcc@]]
    ENCOUNTER_INSTANCES[533], --
    ENCOUNTER_INSTANCES[531], --
}

ns.ENCOUNTER_BOSSES = ENCOUNTER_BOSSES
ns.ENCOUNTER_INSTANCES = ENCOUNTER_INSTANCES
ns.ENCOUNTER_DATA = ENCOUNTER_DATA
--[[@bcc@
ns.DEFAULT_ENCOUNTER_INSTANCE_ID = 532
--@end-bcc@]]
-- @classic@
ns.DEFAULT_ENCOUNTER_INSTANCE_ID = 533
-- @end-classic@

local QUEST_NAMES = {
    [1] = '关注|cff00ffff|Hqrcode:http://weixin.qq.com/q/02JtAwgez6cal10000M03f|h[暴雪游戏服务中心公众号]|h|r并绑定战网账号和手机号',
}

function ns.GetEncouterBossName(id)
    local data = ENCOUNTER_BOSSES[id]
    return data and data.name or UNKNOWN
end

function ns.GetEncounterRaidName(id)
    local data = ENCOUNTER_INSTANCES[id]
    return data and data.title or UNKNOWN
end

function ns.GetChallengeQuest(id)
    return QUEST_NAMES[id] or UNKNOWN
end
