﻿----------------------------------------------------------------------
-- 	Leatrix Maps Locale for Classic Era
----------------------------------------------------------------------

-- Create locale structure
local GameLocale = GetLocale()
local void, Leatrix_Maps = ...
local function localeFunc(L, key) return key end
local L = setmetatable({}, {__index = localeFunc})
Leatrix_Maps.L = L

if LeatrixGlobalDisableLocalisation then return end

-- Locale override (enUS, zhCN, zhTW, ruRU, koKR, deDE, esMX, frFR, itIT, ptBR)
-- GameLocale = "enUS"

-- zhCN: Simplified Chinese (People's Republic of China)
if GameLocale == "zhCN" then
L["(destination only)"] = "(仅目的地)"
L["(inside Caverns of Time)"] = "(时光之穴内部)"
L["/ltm help - Show this information."] = "/ltm help - 显示帮助信息"
L["/ltm reset - Reset the panel position."] = "/ltm reset - 重置面板位置"
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - 清空所有设置并重载插件"
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "出现了一个无关痛痒的报错，它并不会影响到你的体验，你可以点击重载按钮来解决这个问题。"
L["Abyssal Depths"] = "无底海渊"
L["Acherus: The Ebon Hold"] = "阿彻鲁斯：黑锋要塞"
L["Aerie Peak"] = "鹰巢山"
L["Agmar's Hammer"] = "阿格玛之锤"
L["Ahn'Qiraj"] = "安其拉"
L["Aldor"] = "奥尔多"
L["Algeth'ar Academy"] = "奥吉萨尔学院"
L["Allerian Stronghold"] = "奥蕾莉亚要塞"
L["Alliance Cities"] = "联盟城市"
L["Allow frame movement"] = "允许框体移动"
L["Alpha"] = "透明"
L["Altar of Sha'tar"] = "沙塔尔祭坛"
L["Alterac Mountains"] = "奥特兰克山脉"
L["Always"] = "总是"
L["Amber Lodge"] = "琥珀崖"
L["Amberpine Lodge"] = "琥珀松木营地"
L["Andorhal"] = "安多哈尔"
L["Antorus, the Burning Throne"] = "安托鲁斯，燃烧王座"
L["Apothecary Camp"] = "药剂师营地"
L["Appearance"] = "外观"
L["Arathi Highlands"] = "阿拉希高地"
L["Area 52"] = "52区"
L["Argent Tournament Grounds"] = "银色比武场"
L["Armory"] = "军械库"
L["Ashenvale"] = "灰谷"
L["Astranaar"] = "阿斯特兰纳"
L["Astravar Harbor"] = "阿斯塔瓦港"
L["Atal'Dazar"] = "阿塔达萨"
L["Auberdine"] = "奥伯丁"
L["Auchenai Crypts"] = "奥金尼地穴"
L["Auchindoun"] = "奥金顿"
L["Auto change zones"] = "自动切换区域"
L["available during zone attack"] = "区域进攻时有效"
L["Azeroth"] = "艾泽拉斯"
L["Azjol-Nerub"] = "艾卓-尼鲁布"
L["Azshara"] = "艾萨拉"
L["Azure Watch"] = "碧蓝岗哨"
L["Azuremyst Isle"] = "秘蓝岛"
L["Back to Main Menu"] = "返回主菜单"
L["Badlands"] = "荒芜之地"
L["Bambala"] = "邦巴拉"
L["Baradin Hold"] = "巴拉丁监狱"
L["Battle of Dazar'alor"] = "达萨罗之战"
L["Battlegrounds"] = "战场"
L["Bilgewater Harbor"] = "锈水港"
L["Black Morass"] = "幽暗沼泽"
L["Black Rook Hold"] = "黑鸦堡垒"
L["Black Temple"] = "黑暗神殿"
L["Blackfathom Camp"] = "黑渊营地"
L["Blackfathom Deeps"] = "黑暗深渊"
L["Blackrock Caverns"] = "黑石岩窟"
L["Blackrock Depths"] = "黑石深渊"
L["Blackrock Foundry"] = "黑石铸造厂"
L["Blackrock Mountain"] = "黑石山"
L["Blackrock Spire"] = "黑石塔"
L["Blackwing Descent"] = "黑翼血环"
L["Blackwing Lair"] = "黑翼之巢"
L["Blade Tooth Canyon"] = "剑齿峡谷"
L["Blade's Edge Mountains"] = "刀锋山"
L["Blades' Run"] = "熔铸刀刃"
L["Blasted Lands"] = "诅咒之地"
L["Blood Watch"] = "秘血岗哨"
L["Bloodgulch"] = "溅血谷地"
L["Bloodhoof Village"] = "血蹄村"
L["Bloodmaul Slag Mines"] = "血槌炉渣矿井"
L["Bloodmyst Isle"] = "秘血岛"
L["Bloodvenom Post"] = "血毒岗哨"
L["Bloodwatcher Point"] = "血望者营地"
L["Blue"] = "蓝色"
L["Boat to"] = "乘船前往"
L["Bogpaddle"] = "沼浆镇"
L["Bootlegger Outpost"] = "商旅哨站"
L["Booty Bay"] = "藏宝海湾"
L["Borean Tundra"] = "北风苔原"
L["Bor'gorok Outpost"] = "博古洛克前哨站"
L["Bouldercrag's Refuge"] = "布德克拉格庇护所"
L["Brackenhide Hollow"] = "蕨皮之穴"
L["Brackenwall Village"] = "蕨墙村"
L["Brill"] = "布瑞尔"
L["Burning Crusade Classic"] = "燃烧的远征-旧世经典"
L["Burning Steppes"] = "燃烧平原"
L["Camp Ataya"] = "阿塔亚营地"
L["Camp Everstill"] = "湖畔镇营地"
L["Camp Mojache"] = "莫沙彻营地"
L["Camp Oneqwah"] = "欧尼瓦营地"
L["Camp Taurajo"] = "陶拉祖营地"
L["Camp Tunka'lo"] = "唐卡洛营地"
L["Camp Winterhoof"] = "冬蹄营地"
L["Cannot be used with Use default map."] = "不能与[使用默认地图]同时应用。"
L["Cannot be used with Use default map.|n|nTo adjust map opacity, right-click the map frame title bar."] = "不能与[使用默认地图]一起应用。|n|n要调整地图不透明度，请右键单击地图标题栏。"
L["Castle Nathria"] = "纳希拉城堡"
L["Cathedral"] = "大教堂"
L["Cathedral of Eternal Night"] = "永夜大教堂"
L["Caverns of Time"] = "时光之穴"
L["Cenarion Hold"] = "塞纳里奥要塞"
L["Center map on player"] = "为玩家居中地图"
L["Central Mesa"] = "中部高台"
L["Chamber of Heart"] = "心之密室"
L["Chillwind Camp"] = "冰风岗"
L["Chiselgrip"] = "凿握据点"
L["Choose where the zone map should be shown."] = "选择区域地图显示地点"
L["Class colored icons"] = "职业颜色图标"
L["Classic"] = "经典旧世"
L["Click to configure the settings for this option."] = "点击可调整此选项的更多设置。"
L["Click to reset the position and scale of the map frame."] = "点击重置地图的尺寸和位置。"
L["Click to reset the settings on this page."] = "点击重置本页的设置。"
L["Click to return to the main menu."] = "点击返回主菜单。"
L["Cliffwalker Post"] = "峭壁行者哨站"
L["Coilfang Reservoir"] = "盘牙水库"
L["Coldarra"] = "考达拉"
L["Configuration Panel"] = "设置面板"
L["Conquest Hold"] = "征服堡"
L["Cosmic"] = "宇宙"
L["Cosmowrench"] = "扳钳镇"
L["Court of Stars"] = "群星庭院"
L["Crown Guard Tower"] = "皇冠哨塔"
L["Crucible of Storms"] = "风暴熔炉"
L["Crusaders' Pinnacle"] = "北伐军之峰"
L["Crushblow"] = "粉碎者据点"
L["Crystalsong Forest"] = "晶歌森林"
L["Culling of Stratholme"] = "净化斯坦索姆"
L["Cursor"] = "光标"
L["Dalaran"] = "达拉然"
L["Dalaran Crater"] = "达拉然巨坑"
L["Darkbreak Cove"] = "驱暗海窟"
L["Darkheart Thicket"] = "黑心林地"
L["Darkshire"] = "夜色镇"
L["Darkshore"] = "黑海岸"
L["Darnassus"] = "达纳苏斯"
L["Dawnrise Expedition"] = "晨光远征队营地"
L["De Other Side"] = "彼界"
L["Deadwind Pass"] = "逆风小径"
L["Death's Rise"] = "死亡高地"
L["Debug"] = "排错"
L["Deepholm"] = "地深之源"
L["Desolace"] = "凄凉之地"
L["Desolation Hold"] = "凄凉要塞"
L["Dire Maul (East)"] = "厄运之槌（东）"
L["Dire Maul (East) (side entrance)"] = "厄运之槌（东）（后门）"
L["Dire Maul (East): Warpwood Quarter"] = "厄运之槌（东门）：扭木广场"
L["Dire Maul (North)"] = "厄运之槌（北）"
L["Dire Maul (North): Gordok Commons"] = "厄运之槌（北门）：戈多克议会"
L["Dire Maul (West)"] = "厄运之槌（西）"
L["Dire Maul (West): Capital Gardens"] = "厄运之槌（西门）：中心花园"
L["Dire Maul: Capital Gardens"] = "厄运之槌：中心花园"
L["Dire Maul: Gordok Commons"] = "厄运之槌：戈多克议会"
L["Dire Maul: Warpwood Quarter"] = "厄运之槌：扭木广场"
L["Disable map fade"] = "禁用地图渐隐"
L["Disable reading emote"] = "禁用阅读表情"
L["Disable reading emote when opening the map"] = "禁用阅读地图时的表情动作"
L["disabled"] = "禁用"
L["Dolanaar"] = "多兰纳尔"
L["Drag"] = "拖拽"
L["Drag to set the amount of blue."] = "拖拽调整蓝色数值。"
L["Drag to set the amount of green."] = "拖拽调整绿色数值。"
L["Drag to set the amount of red."] = "拖拽调整红色数值。"
L["Drag to set the battlefield map opacity."] = "拖动以调整区域地图透明度。"
L["Drag to set the battlefield map size."] = "拖动以设置战场地图尺寸。"
L["Drag to set the battlefield map size.|n|nIf the map is unlocked, you can also resize the battlefield map by dragging the bottom-right corner."] = "拖动以设置战场地图尺寸。|n|n如果地图解锁了，你也可以点击它的右下角来改变尺寸。"
L["Drag to set the group icon size."] = "拖动以调整队友图标大小。"
L["Drag to set the map opacity for when your character is moving."] = "拖拽调整当你移动时，地图淡化的透明度。"
L["Drag to set the map opacity for when your character is stationary."] = "拖拽调整当你站定时，地图的透明度。"
L["Drag to set the maximum zoom level.|n|nOpen the battlefield map to see the maximum zoom level change as you drag the slider."] = "拖动以设置最大缩放等级。|n|n当你拖动滑块时，打开战场地图可以看到当前最大缩放等级。"
L["Drag to set the maximum zoom level.|n|nOpen the map to see the maximum zoom level change as you drag the slider."] = "拖动以设置最大缩放等级。|n|n当你拖动滑块时，打开地图可以看到当前最大缩放等级。"
L["Drag to set the opacity."] = "拖拽调整透明度。"
L["Drag to set the player arrow size."] = "拖动以设置玩家箭头尺寸。"
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "拖动以调整玩家箭头大小。|n|n怀旧服版本游戏默认尺寸是16。|n正式服版本游戏默认为27。"
L["Drag to set the scale for the maximised map."] = "拖动以设置最大化地图的比例。"
L["Drag to set the scale for the windowed map."] = "拖动以设置窗口地图的比例。"
L["Drag to set the world map scale.|n|nYou can also rescale the world map by dragging the bottom-right corner."] = "拖动以设置世界地图比例。|n|n你也可以通过拖动右下角来重新调整世界地图的比例。"
L["Dragon Soul"] = "巨龙之魂"
L["Dragonblight"] = "龙骨荒野"
L["Dragonmaw Port"] = "龙喉港"
L["Dragon's Mouth"] = "巨龙峡口"
L["Drak'Tharon Keep"] = "达克萨隆要塞"
L["Dreadmaul Hold"] = "巨槌要塞"
L["Dreamer's Rest"] = "梦游者栖地"
L["Druid only flight point to Darnassus"] = "至达纳苏斯（德鲁伊专属）"
L["Druid only flight point to Thunder Bluff"] = "至雷霆崖（德鲁伊专属）"
L["Dun Algaz"] = "丹奥加斯"
L["Dun Modr"] = "丹莫德"
L["Dun Morogh"] = "丹莫罗"
L["Dun Nifflelem"] = "丹尼芬雷"
L["Dungeon"] = "地下城"
L["Dungeon (requires Crescent Key)"] = "地下城（需要月牙钥匙）"
L["Durotar"] = "杜隆塔尔"
L["Duskwood"] = "暮色森林"
L["Dustwallow Marsh"] = "尘泥沼泽"
L["Dustwind Dig"] = "尘风挖掘场"
L["Dwarven District"] = "矮人区"
L["Eastern Earthshrine"] = "东部大地神殿"
L["Eastern Plaguelands"] = "东瘟疫之地"
L["Eastpoint Tower"] = "东点哨塔"
L["Eastvale Logging Camp"] = "东谷伐木场"
L["Eastwall Tower"] = "东墙哨塔"
L["Ebon Watch"] = "黑锋哨站"
L["Elements"] = "其他功能"
L["Elwynn Forest"] = "艾尔文森林"
L["Emerald Dream"] = "翡翠梦境"
L["Emerald Sanctuary"] = "翡翠圣地"
L["enabled"] = "启用"
L["End Time"] = "时光之末"
L["Enhance battlefield map"] = "增强战场地图"
L["Enhance dungeon icons"] = "增强地下城图标"
L["Enlarge player arrow"] = "放大玩家指针"
L["Enter"] = "输入"
L["Ethel Rethor"] = "艾瑟雷索"
L["Evergrove"] = "常青林"
L["Everlook"] = "永望镇"
L["Evermoon Terrace"] = "永月平台"
L["Eversong Woods"] = "永歌森林"
L["Exile's Hollow"] = "流亡者之穴"
L["Exodar"] = "埃索达"
L["Explorer's League Digsite"] = "探索者协会挖掘场"
L["Eye of Azshara"] = "艾萨拉之眼"
L["Fairbreeze Village"] = "晴风村"
L["Falanaar"] = "法兰纳尔"
L["Falcon Watch"] = "鹰隼岗哨"
L["Falconwing Square"] = "鹰翼广场"
L["Faldir's Cove"] = "法迪尔海湾"
L["Farwatcher's Glen"] = "远望角"
L["Feathermoon Stronghold"] = "羽月要塞"
L["Felsoul Hold"] = "邪魂堡垒"
L["Felwood"] = "费伍德森林"
L["Feralas"] = "菲拉斯"
L["Firebeard's Patrol"] = "焰须巡逻营"
L["Firelands"] = "火焰之地"
L["Fishing"] = "钓鱼"
L["Fizzcrank Airstrip"] = "菲兹兰克机场"
L["Fizzle & Pozzik's Speedbarge"] = "菲兹尔和普兹克的赛艇平台"
L["Flame Crest"] = "烈焰峰"
L["Flamestar Post"] = "焰星岗哨"
L["Flayedwing Transporter"] = "绽翼兽飞行点"
L["Follow the eastward path"] = "沿着东边的路走"
L["Follow the westward path"] = "沿着西边的路走"
L["Fordragon Hold"] = "弗塔根要塞"
L["Forest Song"] = "林歌神殿"
L["Forsaken High Command"] = "被遗忘者统帅部"
L["Forsaken Rear Guard"] = "被遗忘者后卫军"
L["Fort Livingston"] = "利文斯顿营地"
L["Fort Triumph"] = "凯旋壁垒"
L["Fort Wildervar"] = "维德瓦堡垒"
L["Freehold"] = "自由镇"
L["Freewind Post"] = "乱风岗"
L["Frosthold"] = "冰霜堡"
L["Fulbrow's Pumpkin Farm"] = "法布隆南瓜农场"
L["Furien's Post"] = "弗瑞恩的哨站"
L["Fuselight"] = "熔光镇"
L["Gadgetzan"] = "加基森"
L["Galen's Fall"] = "加林之陨"
L["Garadar"] = "加拉达尔"
L["Gate of the Setting Sun"] = "残阳关"
L["Gates of Sothann"] = "索萨恩之门"
L["Gates of Valor"] = "勇气之门"
L["Ghostlands"] = "幽魂之地"
L["Gnomeregan"] = "诺莫瑞根"
L["Gol'Bolar Quarry"] = "古博拉采掘场"
L["Goldshire"] = "Goldshire"
L["Graveyard"] = "墓地"
L["Green"] = "绿色"
L["Greenwarden's Grove"] = "绿色守卫者营地"
L["Grim Batol"] = "格瑞姆巴托"
L["Grimrail Depot"] = "恐轨车站"
L["Grizzly Hills"] = "灰熊丘陵"
L["Grom'arsh Crash Site"] = "格罗玛什坠毁点"
L["Grom'gol"] = "格罗姆高"
L["Grom'gol Base Camp"] = "格罗姆高营地"
L["Group Icons"] = "队友图标调整"
L["Grove of Aessina"] = "艾森娜林地"
L["Grove of the Ancients"] = "古树之林"
L["Gruul's Lair"] = "格鲁尔的巢穴"
L["Gundrak"] = "古达克"
L["Gundrak (rear entrance)"] = "古达克（后门）"
L["Gunstan's Dig"] = "古斯坦的岗哨"
L["Hall of Ancient Paths"] = "古道神殿"
L["Halls of Atonement"] = "赎罪大厅"
L["Halls of Infusion"] = "灌输之厅"
L["Halls of Lightning"] = "闪电大厅"
L["Halls of Origination"] = "起源大厅"
L["Halls of Stone"] = "岩石大厅"
L["Halls of Valor"] = "勇气大厅"
L["Hammerfall"] = "落锤镇"
L["Hardwrench Hideaway"] = "硬钳避世乐园"
L["Head down the mountain from here."] = "从这里下山。"
L["Head southeast from here and go up the mountain."] = "从这里向东南走，然后上山。"
L["Heart of Fear"] = "恐惧之心"
L["Hearthglen"] = "壁炉谷"
L["Hellfire Citadel"] = "地狱火堡垒"
L["Hellfire Peninsula"] = "地狱火半岛"
L["Hellfire Ramparts"] = "地狱火城墙"
L["Hellscream's Watch"] = "地狱咆哮岗哨"
L["Hide filter reset button"] = "隐藏过滤器重置按钮"
L["Hide town and city icons"] = "隐藏城镇图标"
L["Highbank"] = "滩头堡"
L["Highmaul"] = "悬槌堡"
L["Hillsbrad Foothills"] = "希尔斯布莱德丘陵"
L["Hiri'watha Research Station"] = "西利瓦萨研究站"
L["Honor Hold"] = "荣耀堡"
L["Honor's Stand"] = "荣耀岗哨"
L["Horde Cities"] = "部落城市"
L["Hour of Twilight"] = "暮光之刻"
L["Howling Fjord"] = "嚎风峡湾"
L["Hunter's Hill"] = " 猎手岭"
L["Hyjal"] = "海加尔山"
L["Hyjal Summit"] = "海加尔山"
L["Icecrown"] = "冰冠冰川"
L["Icecrown Citadel"] = "冰冠堡垒"
L["Icons"] = "图标"
L["If checked, additional icons (such as portals) will be shown."] = "如果选中，将显示其他图标（例如传送门）。"
L["If checked, archaeology digsites will be shown."] = "如果选中，将显示考古挖掘点。"
L["If checked, coordinates will be shown."] = "勾选后，会在地图上显示坐标。"
L["If checked, coordinates will have a dark background texture."] = "勾选后，坐标处添加一个黑色背景材质。"
L["If checked, coordinates will use a large font."] = "勾选后，坐标将使用大号字体。"
L["If checked, dungeons and raids will be shown."] = "勾选后，会在地图上标记显示地下城和团队副本入口。"
L["If checked, group icons will use a modern, class-colored design."] = "勾选后，地图上的队友图标会修改成职业颜色。"
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "勾选后，当你所处区域未发生变化时，打开地图会自动跳转最后一次的区域。"
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "勾选后，当你在移动中指向地图时，会停止地图的渐隐，并使用设置的站定透明度。"
L["If checked, points of interest will be shown."] = "勾选后，显示地图的标记点。"
L["If checked, quest objectives will be shown."] = "如果勾选，将显示任务目标。"
L["If checked, spirit healers will be shown."] = "勾选后，显示灵魂医者的位置。"
L["If checked, the battlefield map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "勾选后，当你不在副本中时，战场地图会始终以你当前位置为中心。|n|n你可以按住Shift键阻止本次居中设置。"
L["If checked, the default fullscreen map will be used for the maximised map.|n|nNote that enabling this option will lock out some of the other options."] = "如果选中，最大化地图将使用默认的全屏地图。|n|n请注意，启用此选项将锁定其他一些选项。"
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "勾选后，将启用默认的全屏地图。|n|n请注意，启用这个选项将锁定部分选项设置。"
L["If checked, the map border will be removed."] = "勾选后，移除地图的黑色边框。"
L["If checked, the map frame will remain open until you close it."] = "勾选后，世界地图将只能被你手动关闭。"
L["If checked, the map will not fade while your character is moving."] = "勾选后，当你移动时地图不再渐隐。"
L["If checked, the map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "勾选后，当你不在副本中时，地图会始终以你当前位置为中心。|n|n你可以按住Shift键阻止本次居中设置。"
L["If checked, the minimap button will be shown."] = "勾选后，会启用小地图图标。"
L["If checked, the minimum fishing skill levels will be shown."] = "勾选后，会显示所需要的最低钓鱼等级。"
L["If checked, the world map filter reset button will be hidden."] = "勾选后，世界地图过滤器重置按钮将被隐藏。"
L["If checked, town and city icons will not be shown on the continent maps."] = "勾选后，将隐藏大陆地图上的城镇图标。"
L["If checked, travel points for the opposing faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "勾选后，显示对立阵营的旅行点标记。|n|n这些包括了飞行点、船舶点、飞艇塔以及火车站等。"
L["If checked, travel points for the same faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "勾选后，显示你所处阵营的旅行点标记。|n|n这些包括了飞行点、船舶点、飞艇塔以及火车站等。"
L["If checked, unexplored areas of the map will be shown on the world map and the battlefield map."] = "勾选后，未探索区域的地图会显示在世界地图及战场地图。"
L["If checked, unexplored areas will be tinted."] = "勾选后，对未探索区域进行染色。"
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "勾选后，当你改变区域时，地图将自动切换至当前区域。"
L["If checked, you can move the battlefield map by dragging any of its borders."] = "如果选中，您可以通过拖动任何边缘来移动战场地图。"
L["If checked, you can move the battlefield map by dragging any of its borders.|n|nYou can resize the battlefield map by dragging the bottom-right corner."] = "勾选后，你可以拖动战场地图的任意边框来拖动它。|n|n你也可以点击右下角来改变尺寸。"
L["If checked, you will be able to customise the battlefield map."] = "勾选后，你可以自定义战场地图。"
L["If checked, you will be able to enlarge the player arrow."] = "勾选后，你可以增大玩家的箭头大小。"
L["If checked, you will be able to move the frame by dragging the border."] = "勾选后，你可以拖动边框来调整框体的位置。"
L["If checked, you will be able to move the map.|n|nThe map position will be saved separately for the maximised and windowed maps."] = "如果选中，您将能够移动地图。|n|n地图位置将分别保存为最大化和窗口地图。"
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges."] = "勾选后，你可以移动并缩放地图。|n|n缩放地图是通过右下角的角标操作。|n|n移动地图可以通过拖拽边框。"
L["If checked, you will be able to scale the map by dragging the scale handle in the bottom-right corner.|n|nYou will be able to move the map by dragging any border.|n|nYou can always drag the top border to move the map regardless of this setting."] = "如果勾选，您将能够通过拖动右下角的比例手柄来调整地图的大小。|n|n您可以通过拖动任何边框来移动地图。|n|n您始终可以拖动顶部边框来移动地图，而不受此设置的影响。"
L["If checked, you will be able to scale the map."] = "如果选中，您将能够缩放地图。"
L["If checked, you will be able to set the opacity of the map."] = "勾选后，你可以设置地图的透明度。"
L["If checked, you will be able to zoom further into the world map."] = "勾选后，你可以改变世界地图的最大缩放等级。"
L["If checked, your character will not perform the reading emote when you open the map."] = "勾选后，当你打开地图时，你的角色不再有一个阅读的表情动作。"
L["If checked, zone and continent dropdown menus will be shown in the map frame."] = "如果选中，地图框架中将显示区域和大陆的下拉菜单。"
L["If checked, zone and dungeon levels will be shown."] = "如果选中，将显示区域和地下城推荐等级。"
L["If checked, zone crossings will be shown.|n|nThese are clickable arrows that indicate the zone exit pathways."] = "勾选后，显示地图区域中转点。|n|n这些是可供点击的箭头，用于引导离开该区域的捷径。"
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "勾选后，会在地图上显示区域、副本和钓鱼的相关等级。"
L["Increase zoom level"] = "提高缩放等级"
L["Invalid command.  Enter /ltm help for help."] = "无效的命令。输入/ltm help来获取帮助信息。"
L["Invalid map ID."] = "无效地图ID"
L["Iron Docks"] = "钢铁码头"
L["Iron Summit"] = "铸铁峰"
L["Ironforge"] = "铁炉堡"
L["Irontree Clearing"] = "铁木工程营"
L["Isle of Quel'Danas"] = "奎尔丹纳斯岛"
L["Just follow the path west"] = "沿着小路往西走"
L["K3"] = "K3"
L["Kamagua"] = "卡玛古"
L["Karazhan"] = "卡拉赞"
L["Kargath"] = "卡加斯"
L["Karnum's Glade"] = "卡隆林地"
L["Kelp'thar Forest"] = "柯尔普萨之森 "
L["Kharanos"] = "卡拉诺斯 "
L["Kings' Rest"] = "诸王之眠"
L["Kirthaven"] = "库斯海文"
L["Kor'kron Vanguard"] = "库卡隆先锋营地"
L["Krom'gar Fortress"] = "克罗姆加壁垒"
L["Lake Elune'ara"] = "月神湖"
L["Lake Everstill"] = "止水湖营地"
L["Lakeshire"] = "湖畔镇"
L["Large Scarab Coffer"] = "大型圣甲虫箱"
L["Leads to Tirisfal Glades"] = "通往提瑞斯法林地"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "警告：你使用了错误的LeatrixMaps版本。"
L["Legion's Rest"] = "军团营地"
L["Library"] = "图书馆"
L["Light's Breach"] = "圣光据点"
L["Light's Hope Chapel"] = "圣光之愿礼拜堂"
L["Light's Shield Tower"] = "圣光之盾哨塔"
L["Lion's Watch"] = "雄狮岗哨"
L["Loch Modan"] = "洛克莫丹"
L["Lor'danel"] = "洛达内尔"
L["Lost City of the Tol'vir"] = "托维尔失落之城"
L["Lower Blackrock Spire"] = "黑石塔下层"
L["Lunastre Estate"] = "月郡庄园"
L["Magisters' Terrace"] = "魔导师平台"
L["Magtheridon's Lair"] = "玛瑟里顿的巢穴"
L["Malaka'jin"] = "玛拉卡金"
L["Mana-Tombs"] = "法力陵墓"
L["Map frame scale"] = "地图面板缩放"
L["Map Opacity"] = "地图透明度"
L["Map Scale"] = "地图比例"
L["Map Size"] = "地图尺寸"
L["Maraudon"] = "玛拉顿"
L["Maraudon: Earth Song Falls"] = "玛拉顿：毒水瀑布"
L["Maraudon: Foulspore Cavern"] = "玛拉顿：毒菇洞穴"
L["Maraudon: The Wicked Grotto"] = "玛拉顿：邪恶洞穴"
L["Marshal's Refuge"] = "马绍尔营地"
L["Marshal's Stand"] = "马绍尔哨站"
L["Marshtide Watch"] = "沼泽之潮哨站"
L["Maw of Souls"] = "噬魂之喉"
L["Max Zoom"] = "最大缩放"
L["Maximised"] = "全屏化"
L["Maximum"] = "最大"
L["Mechanics"] = "地图结构"
L["Memory Usage"] = "内存占用"
L["Menethil Harbor"] = "米奈希尔港"
L["Mirkfallon Post"] = "暗色哨站"
L["Miscellaneous"] = "杂项"
L["Mists of Tirna Scithe"] = "塞兹仙林的迷雾"
L["Moa'ki"] = "莫亚基"
L["Moa'ki Harbor"] = "莫亚基港口"
L["Mogu'shan Palace"] = "魔古山宫殿"
L["Mogu'shan Vaults"] = "魔古山宝库"
L["Mok'Nathal Village"] = "摩克纳萨尔村"
L["Molten Core"] = "熔火之心"
L["Moon Guard Stronghold"] = "护月堡垒"
L["Moonbrook"] = "月溪镇"
L["Moonglade"] = "月光林地"
L["More"] = "更多"
L["Morgan's Vigil"] = "摩根的岗哨"
L["Mossy Pile"] = "覆苔营地"
L["Mount Crafting"] = "坐骑合成"
L["Mount Hyjal"] = "海加尔山"
L["Mountain Pass (Horde Only)"] = "山口（仅部落）"
L["Moving"] = "移动"
L["Mudsprocket"] = "泥链镇"
L["Mulgore"] = "莫高雷"
L["Nagrand"] = "纳格兰"
L["Naxxramas"] = "纳克萨玛斯"
L["Nazjatar"] = "纳沙塔尔"
L["Neltharion's Lair"] = "奈萨里奥巢穴"
L["Neltharus"] = "奈塞拉斯"
L["Nesingwary Base Camp"] = "奈辛瓦里营地"
L["Nethergarde Keep"] = "守望堡"
L["Netherstorm"] = "虚空风暴"
L["Never"] = "从不"
L["New Agamand"] = "新阿加曼德"
L["New Kargath"] = "新卡加斯"
L["Nighthaven"] = "永夜港"
L["Nijel's Point"] = "尼耶尔前哨站"
L["Nordrassil"] = "诺达希尔"
L["North"] = "北方"
L["North Gate Pass"] = "北门小径"
L["Northern Rocketway"] = "北方火箭车换乘站"
L["Northpass Tower"] = "北地哨塔"
L["Northwatch Hold"] = "北方城堡"
L["Nozzlepot's Outpost"] = "诺兹波特的哨站"
L["Ny'alotha, The Waking City"] = "尼奥罗萨，唤醒之城"
L["Oasis of Vir'sar"] = "维尔萨尔绿洲"
L["Ohn'ahran Plains"] = "欧恩哈拉平原"
L["Old Hillsbrad"] = "旧希尔斯布莱德"
L["Old Hillsbrad Foothills"] = "旧希尔斯布莱德丘陵"
L["Onyxia's Lair"] = "奥妮克希亚的巢穴"
L["Opacity"] = "透明度"
L["Operation: Mechagon"] = "麦卡贡行动"
L["or click the minimap button to open Leatrix Maps."] = "或者点击小地图按钮打开LeatrixMaps。"
L["Orb of Translocation"] = "传送宝珠"
L["Orebor Harborage"] = "奥雷伯尔港"
L["Orgrimmar"] = "奥格瑞玛"
L["Oribos"] = "奥利波斯"
L["Pet Crafting"] = "宠物合成"
L["Plaguefall"] = "凋魂之殇"
L["Plaguewood Tower"] = "病木林哨塔"
L["Player"] = "玩家"
L["Player Arrow"] = "玩家箭头"
L["Portal"] = "传送门"
L["Portal from Zephyr"] = "从塞菲尔传送"
L["Portals"] = "传送门"
L["Preview"] = "预览"
L["Protoform Repository"] = "原型存储库"
L["Ragefire Chasm"] = "怒焰裂谷"
L["Raid"] = "团队副本"
L["Ramkahen"] = "拉穆卡恒"
L["Ratchet"] = "棘齿城"
L["Raven Hill"] = "乌鸦岭"
L["Ravenholdt Manor"] = "拉文霍德庄园"
L["Razor Hill"] = "剃刀岭"
L["Razorfen Downs"] = "剃刀高地"
L["Razorfen Kraul"] = "剃刀沼泽"
L["Razorthorn Trail"] = "刺棘蔓"
L["Rebel Camp"] = "反抗军营地"
L["Red"] = "红色"
L["Redridge Mountains"] = "赤脊山"
L["Refuge Pointe"] = "避难谷地"
L["Reload"] = "重载插件"
L["Remember zoom level"] = "保存缩放等级"
L["Remove map border"] = "移除地图边框"
L["req"] = "需要"
L["Requires Key to Searing Gorge"] = "需要钥匙前往灼热峡谷"
L["Requires UI reload."] = "需要重载插件。"
L["Reset"] = "重置"
L["Reset Map Layout"] = "重置地图设置"
L["Return to Karazhan"] = "重返卡拉赞"
L["Revantusk Village"] = "恶齿村"
L["River's Heart"] = "河流之心"
L["Ruby Life Pools"] = "红玉生命之池"
L["Ruins of Ahn'Qiraj"] = "安其拉废墟"
L["Ruins of Elune'eth"] = "艾露尼斯废墟"
L["Ruins of Southshore"] = "南海镇废墟"
L["Rut'Theran Village"] = "鲁瑟兰村"
L["Rut'theran Village"] = "鲁瑟兰村"
L["Sanctuary"] = "圣殿"
L["Sanctuary of Malorne"] = "玛洛恩庇护所"
L["Sanctum of Domination"] = "统御圣所"
L["Sanctum of Order"] = "秩序大殿"
L["Sanctum of the Sages"] = "贤者圣殿"
L["Sanctum of the Stars"] = "星光圣所"
L["Sandy Beach"] = "沙滩"
L["Sanguine Depths"] = "赤红深渊"
L["Scale"] = "缩放"
L["Scale the map"] = "调整地图比例"
L["Scarlet Halls"] = "血色大厅"
L["Scarlet Monastery"] = "血色修道院"
L["Schnottz's Landing"] = "斯克诺兹登陆点"
L["Scholomance"] = "通灵学院"
L["Searing Gorge"] = "灼热峡谷"
L["Seat of the Naaru"] = "纳鲁之座"
L["Seat of the Triumvirate"] = "执政团之座"
L["Sen'jin Village"] = "森金村"
L["Sentinel Hill"] = "哨兵岭"
L["Sepulcher of the First Ones"] = "初诞者圣墓"
L["Serpentshrine Cavern"] = "毒蛇神殿"
L["Set map opacity"] = "设置地图透明度"
L["Set map opacity while stationary and while moving."] = "设置当站定和移动时的地图透明度。"
L["Set the group icon size."] = "设置队友图标尺寸。"
L["Set the maximum zoom scale."] = "设置最大缩放等级。"
L["Set the player arrow size."] = "设置玩家箭头大小。"
L["Sethekk Halls"] = "塞泰克大厅"
L["Settings"] = "设置"
L["Sewers"] = "下水道"
L["Shadebough"] = "蔽日林"
L["Shado-Pan Monastery"] = "影踪修道院"
L["Shadow Labyrinth"] = "暗影迷宫"
L["Shadowfang Keep"] = "影牙城堡"
L["Shadowlands"] = "暗影之地"
L["Shadowmoon Burial Grounds"] = "影月墓地"
L["Shadowmoon Valley"] = "影月谷"
L["Shadowmoon Village"] = "影月村"
L["Shadowprey Village"] = "葬影村"
L["Shal'Aran"] = "沙尔艾兰"
L["Shalewind Canyon"] = "页岩峡谷"
L["Shatter Point"] = "破碎岗哨"
L["Shattered Sun Staging Area"] = "破碎残阳基地"
L["Shattrath"] = "沙塔斯"
L["Shattrath City"] = "沙塔斯城"
L["Shimmering Expanse"] = "烁光海床"
L["Sholazar Basin"] = "索拉查盆地"
L["Show additional icons"] = "显示更多图标"
L["Show background"] = "显示背景"
L["Show boats, zeppelins and trams"] = "显示港口/飞艇/地铁站"
L["Show coordinates"] = "显示坐标"
L["Show digsites"] = "显示挖掘点"
L["Show dungeons and raids"] = "标记副本入口"
L["Show minimap button"] = "显示小地图按钮"
L["Show minimum fishing skill levels"] = "显示最低钓鱼等级"
L["Show objectives"] = "显示目标"
L["Show points of interest"] = "启用地图的标记点"
L["Show scale handle"] = "允许缩放地图框体"
L["Show spirit healers"] = "显示灵魂医者"
L["Show travel points for opposing faction"] = "对立阵营旅行点"
L["Show travel points for same faction"] = "同阵营旅行点"
L["Show unexplored areas"] = "显示未探索区域"
L["Show zone crossings"] = "显示区域中转点"
L["Show zone levels"] = "显示区域等级"
L["Show zone menus"] = "显示区域菜单"
L["Shrine of Aviana"] = "艾维娜圣殿"
L["Shrine of the Storm"] = "风暴神殿"
L["Side entrance"] = "侧门"
L["Siege of Boralus"] = "围攻伯拉勒斯"
L["Siege of Niuzao Temple"] = "围攻砮皂寺"
L["Siege of Orgrimmar"] = "决战奥格瑞玛"
L["Silithus"] = "希利苏斯"
L["Silver Tide Hollow"] = "银潮谷"
L["Silvermoon"] = "银月城"
L["Silvermoon City"] = "银月城"
L["Silverpine Forest"] = "银松森林"
L["Silverwind Refuge"] = "银风避难所"
L["Skyreach"] = "通天峰"
L["Slabchisel's Survey"] = "硬凿勘测营"
L["Slave Pens"] = "奴隶围栏"
L["Sludgewerks"] = "油污潭"
L["Smuggler's Scar"] = "走私者洞穴"
L["South"] = "南方"
L["South Gate Pass"] = "南门小径"
L["Southern Barrens"] = "南贫瘠之地"
L["Southern Rocketway"] = "南部火箭车终点站"
L["Southfury River"] = "怒水河"
L["Southpoint Gate"] = "南点大门"
L["Southshore"] = "南海镇"
L["Spinebreaker Ridge"] = "断脊山"
L["Spires of Ascension"] = "晋升高塔"
L["Spirit Healer"] = "灵魂医者"
L["Splintertree Post"] = "碎木岗哨"
L["Stardust Spire"] = "星尘废墟"
L["Stars' Rest"] = "群星之墓"
L["Stationary"] = "站定"
L["Steamvault"] = "蒸汽地窟"
L["Sticky map frame"] = "世界地图锁定"
L["Stonard"] = "斯通纳德"
L["Stonebreaker Hold"] = "裂石堡"
L["Stonemaul Hold"] = "石槌要塞"
L["Stonetalon Mountains"] = "石爪山脉"
L["Stonetalon Peak"] = "石爪峰"
L["Stormfeather Outpost"] = "风暴之羽哨站"
L["Stormstout Brewery"] = "风暴酿酒厂"
L["Stormwind"] = "暴风城"
L["Stormwind City"] = "暴风城"
L["Strahnbrad"] = "斯坦恩布莱德"
L["Stranglethorn Vale"] = "荆棘谷"
L["Stratholme (Main Gate)"] = "斯坦索姆（主门）"
L["Stratholme (Service Gate)"] = "斯坦索姆（仆从入口）"
L["Stratholme: Crusader's Square"] = "斯坦索姆：十字军广场"
L["Stratholme: The Gauntlet"] = "斯坦索姆：后门"
L["Stygian Bounty"] = "冥河恩赐号"
L["sum"] = "召唤"
L["Sun Rock Retreat"] = "烈日石居"
L["Sunreaver's Command"] = "夺日者指挥站"
L["Sun's Reach Harbor"] = "阳湾港口"
L["Sunveil Excursion"] = "日纱考察营地"
L["Sunwell Plateau"] = "太阳之井高地"
L["Surwich"] = "瑟维奇"
L["Swamp of Sorrows"] = "悲伤沼泽"
L["Swamprat Post"] = "斯瓦姆普拉特营地"
L["Sylvanaar"] = "希尔瓦娜岗哨"
L["Synthesis Forge"] = "合成熔炉"
L["System"] = "系统"
L["Talonbranch Glade"] = "刺枝林地"
L["Talrendis Point"] = "塔伦迪斯营地"
L["Tanaris"] = "塔纳利斯"
L["Tarren Mill"] = "塔伦米尔"
L["Taunka'le Village"] = "牦牛村"
L["Taxi to Scholar's Den"] = "前往学者之家"
L["Taxi to Vault of Secrets"] = "前往绝密宝库"
L["Tazavesh, the Veiled Market"] = "塔扎维什，帷纱集市"
L["Telaar"] = "泰拉尔"
L["Tel'anor"] = "泰安诺"
L["Teldrassil"] = "泰达希尔"
L["Teleport Crystal"] = "传送水晶"
L["Telredor"] = "泰雷多尔"
L["Tempest Keep"] = "风暴要塞"
L["Temple of Ahn'Qiraj"] = "安其拉神殿"
L["Temple of Atal'Hakkar"] = "阿塔哈卡神庙"
L["Temple of Sethraliss"] = "塞塔里斯神庙"
L["Temple of Telhamat"] = "特尔哈曼神庙"
L["Temple of the Jade Serpent"] = "青龙寺"
L["Temple of the Moon"] = "月神殿"
L["Tenebrous Cavern"] = "阴暗洞穴"
L["Terokkar Forest"] = "泰罗卡森林"
L["Terrace of Endless Spring"] = "永春台"
L["Thalanaar"] = "萨兰纳尔"
L["Thal'darah Overlook"] = "萨达拉瞭望台"
L["Thandol Span"] = "萨多尔大桥"
L["Thargad's Camp"] = "萨加德营地"
L["The Arcatraz"] = "禁魔监狱"
L["The Arcway"] = "魔法回廊"
L["The Argent Stand"] = "银色前沿"
L["The Argent Vanguard"] = "银色前线基地"
L["The Azure Vault"] = "碧蓝宝库"
L["The Barrens"] = "贫瘠之地"
L["The Bastion of Twilight"] = "暮光堡垒"
L["The Black Morass"] = "黑色沼泽"
L["The Blood Furnace"] = "鲜血熔炉"
L["The Botanica"] = "生态船"
L["The Bulwark"] = "亡灵壁垒"
L["The Cape of Stranglethorn"] = "荆棘谷海角"
L["The Crossroads"] = "十字路口"
L["The Culling of Stratholme"] = "净化斯坦索姆"
L["The Dark Portal"] = "黑暗之门"
L["The Deadmines"] = "死亡矿井"
L["The Dragon Soul"] = "巨龙之魂"
L["The Emerald Nightmare"] = "翡翠梦魇"
L["The Everbloom"] = "永茂林地"
L["The Exodar"] = "埃索达"
L["The Eye"] = "风暴要塞"
L["The Eye of Eternity"] = "永恒之眼"
L["The Farstrider Lodge"] = "旅行者营地"
L["The Forge of Souls"] = "灵魂洪炉"
L["The Forgotten Coast"] = "被遗忘的海岸"
L["The Forsaken Front"] = "被遗忘者先锋军"
L["The Frozen Halls"] = "冰封大殿"
L["The Great Forge"] = "大锻炉"
L["The Great Lift"] = "升降梯"
L["The Gullet"] = "咽喉洞"
L["The Halls of Reflection"] = "映像大厅"
L["The Harborage"] = "避难营"
L["The Hinterlands"] = "辛特兰"
L["The Krazzworks"] = "卡拉兹工坊"
L["The Mechanar"] = "能源舰"
L["The Menders' Stead"] = "治愈者营地"
L["The Mor'shan Rampart"] = "莫尔杉壁垒"
L["The MOTHERLODE!!"] = "暴富矿区！"
L["The Necrotic Wake"] = "通灵战潮"
L["The Nexus"] = "魔枢"
L["The Nighthold"] = "暗夜要塞"
L["The Nokhud Offensive"] = "诺库德的进攻"
L["The Obsidian Sanctum"] = "黑曜石圣殿"
L["The Oculus"] = "魔环"
L["The Old Kingdom"] = "古代王国"
L["The Overlook Cliffs"] = "望海崖"
L["The Pit of Saron"] = "萨隆矿坑"
L["The Ruby Sanctum"] = "红玉圣殿"
L["The Sepulcher"] = "瑟伯切尔"
L["The Shadow Vault"] = "暗影拱顶"
L["The Shattered Halls"] = "破碎大厅"
L["The Stockade"] = "监狱"
L["The Stonecore"] = "巨石之核"
L["The Storm Peaks"] = "风暴峭壁"
L["The Stormspire"] = "风暴尖塔"
L["The Talondeep Path"] = "石爪小径"
L["The Underrot"] = "地渊孢林"
L["The Vault of Lights"] = "圣光大厅"
L["The Violet Hold"] = "紫罗兰监狱"
L["The Vortex Pinnacle"] = "旋云之巅"
L["The Waning Crescent"] = "残月酒馆"
L["The Zoram Strand"] = "佐拉姆海岸"
L["Theater of Pain"] = "伤逝剧场"
L["Thelsamar"] = "塞尔萨玛"
L["Theramore Isle"] = "塞拉摩岛"
L["Thondroril River"] = "索尔多里河"
L["Thorium Point"] = "瑟银哨塔"
L["Thousand Needles"] = "千针石林"
L["Thrallmar"] = "萨尔玛"
L["Throne of the Four Winds"] = "风神王座"
L["Throne of the Tides"] = "海潮王座"
L["Throne of Thunder"] = "雷电王座"
L["Thunder Bluff"] = "雷霆崖"
L["Thunderlord Stronghold"] = "雷霆王村"
L["Thundermar"] = "桑德玛尔"
L["Thunk's Abode"] = "桑克的住所"
L["Timbermaw Hold"] = "木喉要塞"
L["Tinker Town"] = "工匠区"
L["Tint unexplored areas"] = "未探索区域染色"
L["Tiragarde Sound"] = "提拉加德海峡"
L["Tirisfal Glades"] = "提瑞斯法林地"
L["Titan Translocator"] = "泰坦传送器"
L["Toggle panel"] = "开关插件面板"
L["Tol Barad"] = "托尔巴拉德"
L["Tomb of Sargeras"] = "萨格拉斯之墓"
L["Toshley's Station"] = "托斯雷工作站"
L["Tower of Estulan"] = "埃斯图兰之塔"
L["Trade District"] = "贸易区"
L["Trade Quarter"] = "贸易区"
L["Tram to"] = "乘地铁前往"
L["Tranquil Wash"] = "静谧海滩"
L["Tranquillien"] = "塔奎林"
L["Transitus Shield"] = "永生之盾"
L["Transparency"] = "透明度"
L["Trial of the Champion"] = "冠军的试炼"
L["Trial of the Crusader"] = "十字军的试炼"
L["Trial of Valor"] = "勇气试炼"
L["Twilight Highlands"] = "暮光高地"
L["Twilight Shore"] = "暮光海岸"
L["Twilight Vale"] = "暮光谷"
L["Twilight Vineyards"] = "暮光酒庄"
L["Uldaman"] = "奥达曼"
L["Uldaman (rear entrance)"] = "奥达曼（后门）"
L["Uldaman (side entrance)"] = "奥达曼（后门）"
L["Uldaman: Legacy of Tyr"] = "奥达曼：提尔的遗产"
L["Uldir"] = "奥迪尔"
L["Ulduar"] = "奥杜尔"
L["Uldum"] = "奥丹姆"
L["Underbog"] = "幽暗沼泽"
L["Undercity"] = "幽暗城"
L["Un'Goro Crater"] = "安戈洛环形山"
L["Unlock battlefield map"] = "解锁区域地图"
L["Unlock map frame"] = "解锁地图框体"
L["Unu'pe"] = "乌努比"
L["Upper Blackrock Spire"] = "黑石塔上层"
L["Use default map"] = "使用默认地图"
L["Use large font"] = "使用大号字体"
L["Use stationary opacity while pointing at map"] = "指向地图时取消渐隐"
L["Utgarde Keep"] = "乌特加德城堡"
L["Utgarde Pinnacle"] = "乌特加德之巅"
L["Valaar's Berth"] = "瓦拉尔港口"
L["Valdrakken Portals"] = "瓦德拉肯传送门"
L["Valgarde"] = "瓦加德"
L["Valgarde Port"] = "瓦加德"
L["Valiance Keep"] = "无畏要塞"
L["Valiance Landing Camp"] = "无畏港营地"
L["Valley of Strength"] = "力量谷"
L["Valormok"] = "瓦罗莫克"
L["Vashj'ir"] = "瓦丝琪尔"
L["Vault of Archavon"] = "阿尔卡冯的宝库"
L["Vault of the Incarnates"] = "化身之库"
L["Vault of the Wardens"] = "守望者地窟"
L["Vendetta Point"] = "世仇哨站"
L["Vengeance Landing"] = "复仇港"
L["Venomspite"] = "怨毒镇"
L["Vermillion Redoubt"] = "朱红庇护所"
L["Version"] = "版本"
L["Victor's Point"] = "胜利者岗哨"
L["Voldrin's Hold"] = "沃德林之拥号"
L["Vol'mar"] = "沃玛尔"
L["Wailing Caverns"] = "哀嚎洞穴"
L["Warsong Camp"] = "战歌营地"
L["Warsong Hold"] = "战歌要塞"
L["Waycrest Manor"] = "维克雷斯庄园"
L["Well of Eternity"] = "永恒之井"
L["Western Earthshrine"] = "西部大地神殿"
L["Western Plaguelands"] = "西瘟疫之地"
L["Westfall"] = "西部荒野"
L["Westfall Brigade"] = "月溪旅营地"
L["Westguard Keep"] = "西部卫戍要塞"
L["Westreach Summit"] = "西岸峰"
L["Wetlands"] = "湿地"
L["Whelgar's Retreat"] = "维尔加居所"
L["Whisperwind Grove"] = "刺枝林地"
L["Wildhammer Stronghold"] = "蛮锤要塞"
L["Wildheart Point"] = "野性之心哨站"
L["Windowed"] = "窗口模式"
L["Windrunner's Overlook"] = "风行者观察站"
L["Windshear Hold"] = "风剪要塞"
L["Wintergarde Keep"] = "暮冬要塞"
L["Wintergrasp"] = "冬拥湖"
L["Winterspring"] = "冬泉谷"
L["World of Warcraft Classic"] = "魔兽世界-旧世经典"
L["Wrath of the Lich King Classic"] = "巫妖王之怒旧世经典"
L["Wyrmrest Temple"] = "龙眠神殿"
L["You cannot do that in combat."] = "你无法在战斗中这么做。"
L["You will die!"] = "你会死的！"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "为了让部分功能生效，你的插件需要重新载入。|n|n你无需立即点击重载插件按钮。可以根据自己的情况或者设置完毕后，再进行重载插件的操作。"
L["Your UI needs to be reloaded."] = "插件需要重新载入。"
L["Zabra'jin"] = "萨布拉金"
L["Zangarmarsh"] = "赞加沼泽"
L["Zeb'Sora"] = "塞布索雷"
L["Zeppelin to"] = "乘飞艇前往"
L["Zim'Torga"] = "希姆托加"
L["Zone Map"] = "区域地图"
L["Zoom"] = "缩放"
L["Zoram'gar Outpost"] = "佐拉姆加前哨站"
L["Zul'Aman"] = "祖阿曼"
L["Zuldazar"] = "祖达萨"
L["Zul'Drak"] = "祖达克"
L["Zul'Farrak"] = "祖尔法拉克"
L["Zul'Gurub"] = "祖尔格拉布"

end

-- zhTW: Traditional Chinese (Taiwan)
if GameLocale == "zhTW" then
L["(destination only)"] = "（僅限目的地）"
L["(inside Caverns of Time)"] = "（時光之穴內）"
L["/ltm help - Show this information."] = "/ltm help - 顯示插件資訊。"
L["/ltm reset - Reset the panel position."] = "/ltm reset - 重設面板位置。"
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - 清除所有設定並重載。"
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "一個停止錯誤發生了，但無需擔心，三不五時會發生，請點擊重載按鈕來解決它。"
L["Acherus: The Ebon Hold"] = "亡靈壁壘：黑暗堡壘"
L["Aerie Peak"] = "應巢山"
L["Agmar's Hammer"] = "艾卡瑪之錘"
L["Ahn'Qiraj"] = "安其拉"
L["Aldor"] = "奧多爾"
L["Algeth'ar Academy"] = "阿爾蓋薩學院"
L["Allerian Stronghold"] = "艾蘭里堡壘"
L["Alliance Cities"] = "聯盟城市"
L["Allow frame movement"] = "允許移動框架"
L["Alpha"] = "透明"
L["Altar of Sha'tar"] = "薩塔祭壇"
L["Alterac Mountains"] = "奧特蘭山脈"
L["Always"] = "總是"
L["Amber Lodge"] = "琥珀小屋"
L["Amberpine Lodge"] = "琥珀松小屋"
L["Andorhal"] = "安多哈爾"
L["Antorus, the Burning Throne"] = "安托魯斯，燃燒的王座"
L["Apothecary Camp"] = "藥劑師營地"
L["Appearance"] = "外觀"
L["Arathi Highlands"] = "阿拉希高地"
L["Area 52"] = "52區"
L["Argent Tournament Grounds"] = "銀白錦標賽場地"
L["Armory"] = "軍械庫"
L["Ashenvale"] = "梣谷"
L["Astranaar"] = "阿斯特蘭納"
L["Astravar Harbor"] = "艾斯特瓦港"
L["Atal'Dazar"] = "阿塔達薩"
L["Auberdine"] = "奧伯丁"
L["Auchenai Crypts"] = "奧奇奈地穴"
L["Auchindoun"] = "奧齊頓"
L["Auto change zones"] = "自動變換區域"
L["available during zone attack"] = "在區域突擊時可用"
L["Azeroth"] = "艾澤拉斯"
L["Azjol-Nerub"] = "亞茲歐-奈幽"
L["Azshara"] = "艾薩拉"
L["Azuremyst Isle"] = "藍謎島"
L["Back to Main Menu"] = "回到主選單"
L["Badlands"] = "荒蕪之地"
L["Baradin Hold"] = "巴拉丁堡"
L["Battle of Dazar'alor"] = "達薩亞洛之戰"
L["Battlegrounds"] = "戰場"
L["Black Morass"] = "黑暗沼澤"
L["Black Rook Hold"] = "玄鴉堡"
L["Black Temple"] = "黑暗神廟"
L["Blackfathom Deeps"] = "黑澗深淵"
L["Blackrock Caverns"] = "黑石洞穴"
L["Blackrock Depths"] = "黑石深淵"
L["Blackrock Foundry"] = "黑石鑄造廠"
L["Blackrock Mountain"] = "黑石山"
L["Blackrock Spire"] = "黑石塔"
L["Blackwing Descent"] = "黑翼陷窟"
L["Blackwing Lair"] = "黑翼之巢"
L["Blade Tooth Canyon"] = "劍牙峽谷"
L["Blade's Edge Mountains"] = "劍刃山脈"
L["Blades' Run"] = "刃刀小道"
L["Blasted Lands"] = "詛咒之地"
L["Blood Watch"] = "血色守望"
L["Bloodmaul Slag Mines"] = "血槌熔渣礦場"
L["Bloodmyst Isle"] = "血謎島"
L["Bloodvenom Post"] = "血毒崗哨"
L["Blue"] = "藍色"
L["Boat to"] = "船到"
L["Booty Bay"] = "藏寶海灣"
L["Borean Tundra"] = "北風凍原"
L["Bor'gorok Outpost"] = "博古洛克前哨站"
L["Bouldercrag's Refuge"] = "礫石巨克的避難所"
L["Brackenhide Hollow"] = "蕨皮谷"
L["Brackenwall Village"] = "蕨牆村"
L["Burning Crusade Classic"] = "經典-燃燒的遠征"
L["Burning Steppes"] = "燃燒平原"
L["Camp Mojache"] = "莫沙澈營地"
L["Camp Oneqwah"] = "奧尼克瓦營地"
L["Camp Taurajo"] = "陶拉祖營地"
L["Camp Tunka'lo"] = "坦卡洛營地"
L["Camp Winterhoof"] = "冬蹄營地"
L["Cannot be used with Use default map."] = "不能與使用預設地圖一起使用。"
L["Cannot be used with Use default map.|n|nTo adjust map opacity, right-click the map frame title bar."] = "不能與使用預設地圖一起使用。|n|n若要調整地圖透明度，請以滑鼠右鍵按一下地圖視窗標題列。"
L["Castle Nathria"] = "納撒亞城"
L["Cathedral"] = "大教堂"
L["Cathedral of Eternal Night"] = "永夜大教堂"
L["Caverns of Time"] = "時光之穴"
L["Cenarion Hold"] = "賽納里奧要塞"
L["Center map on player"] = "將地圖居中於玩家"
L["Central Mesa"] = "中部高台"
L["Chamber of Heart"] = "心之室"
L["Chillwind Camp"] = "冰風崗哨"
L["Choose where the zone map should be shown."] = "選擇區域地圖的顯示位置"
L["Class colored icons"] = "職業著色圖示"
L["Classic"] = "經典"
L["Click to configure the settings for this option."] = "點擊來設置此選項的設定。"
L["Click to reset the position and scale of the map frame."] = "點擊來重設地圖框架的位置與大小。"
L["Click to reset the settings on this page."] = "點擊來重設此頁的設定。"
L["Click to return to the main menu."] = "點擊來重返主選單。"
L["Coilfang Reservoir"] = "盤牙水庫"
L["Coldarra"] = "寒冰之地"
L["Configuration Panel"] = "設置面板"
L["Conquest Hold"] = "征服堡"
L["Cosmic"] = "宇宙的"
L["Cosmowrench"] = "扭曲太空"
L["Court of Stars"] = "眾星之廷"
L["Crucible of Storms"] = "風暴邪淵"
L["Crusaders' Pinnacle"] = "十字軍之巔"
L["Crystalsong Forest"] = "晶歌森林"
L["Culling of Stratholme"] = "斯坦索姆的抉擇"
L["Cursor"] = "鼠標"
L["Dalaran"] = "達拉然"
L["Dalaran Crater"] = "達拉然陷坑"
L["Darkheart Thicket"] = "暗心灌木林"
L["Darkshire"] = "夜色鎮"
L["Darkshore"] = "黑海岸"
L["Darnassus"] = "達納蘇斯"
L["De Other Side"] = "彼界境地"
L["Deadwind Pass"] = "逆風小徑"
L["Death's Rise"] = "死亡高地"
L["Debug"] = "偵錯"
L["Deepholm"] = "地深之源"
L["Desolace"] = "淒涼之地"
L["Dire Maul (East)"] = "厄運之槌 (東)"
L["Dire Maul (East) (side entrance)"] = "厄運之槌（東）（側面入口）"
L["Dire Maul (North)"] = "厄運之槌 (北)"
L["Dire Maul (West)"] = "厄運之槌 (西)"
L["Dire Maul: Capital Gardens"] = "厄運之槌：中心花園"
L["Dire Maul: Gordok Commons"] = "厄運之槌：戈多克平民區"
L["Dire Maul: Warpwood Quarter"] = "厄運之槌：杻木廣場"
L["Disable map fade"] = "停用地圖淡出"
L["Disable reading emote"] = "停用閱讀表情"
L["Disable reading emote when opening the map"] = "當開啟地圖時取消閱讀表情"
L["disabled"] = "停用"
L["Dolanaar"] = "多蘭納爾"
L["Drag"] = "拖動"
L["Drag to set the amount of blue."] = "拖拉來設定藍色的數值。"
L["Drag to set the amount of green."] = "拖拉來設定綠色的數值。"
L["Drag to set the amount of red."] = "拖拉來設定紅色的數值。"
L["Drag to set the battlefield map opacity."] = "拖動以設定戰場地圖的透明度"
L["Drag to set the battlefield map size."] = "拖拉來設定戰場地圖大小。"
L["Drag to set the battlefield map size.|n|nIf the map is unlocked, you can also resize the battlefield map by dragging the bottom-right corner."] = "拖動以設定戰場地圖的大小。|n|n如果地圖已解鎖，還可以通過拖動右下角調整戰場地圖的大小"
L["Drag to set the group icon size."] = "拖拉來設定隊伍圖示大小。"
L["Drag to set the map opacity for when your character is moving."] = "拖拉來設定當您角色移動時地圖的透明度。"
L["Drag to set the map opacity for when your character is stationary."] = "拖拉來設定當您角色靜止時地圖的透明度。"
L["Drag to set the maximum zoom level.|n|nOpen the battlefield map to see the maximum zoom level change as you drag the slider."] = "拖動以設定最大縮放級別。|n|n打開戰場地圖，看到最大縮放級別在拖動滑塊時的變化"
L["Drag to set the maximum zoom level.|n|nOpen the map to see the maximum zoom level change as you drag the slider."] = "拖動以設定最大縮放級別。|n|n打開地圖，看到最大縮放級別在拖動滑塊時的變化"
L["Drag to set the opacity."] = "拖拉來設定透明度。"
L["Drag to set the player arrow size."] = "拖拉來設定玩家箭頭大小。"
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "拖拉以設置玩家箭頭大小。|n|n魔獸世界經典版預設為16。|n魔獸世界正式版預設為27。"
L["Drag to set the scale for the maximised map."] = "拖動以設置最大化地圖的縮放大小。"
L["Drag to set the scale for the windowed map."] = "拖動以設置視窗地圖的縮放大小。"
L["Drag to set the world map scale.|n|nYou can also rescale the world map by dragging the bottom-right corner."] = "拖動以設定世界地圖比例。|n|n還可以通過拖動右下角調整世界地圖的比例"
L["Dragon Soul"] = "巨龍之魂"
L["Dragonblight"] = "龍骨荒野"
L["Dragonmaw Port"] = "龍喉港"
L["Drak'Tharon Keep"] = "德拉克薩隆要塞"
L["Druid only flight point to Darnassus"] = "到達納蘇斯的德魯伊專用鳥點"
L["Druid only flight point to Thunder Bluff"] = "到雷霆崖的德魯伊專用鳥點"
L["Dun Algaz"] = "丹艾加茲"
L["Dun Morogh"] = "丹莫洛"
L["Dun Nifflelem"] = "丹尼弗雷倫"
L["Dungeon"] = "地下城"
L["Dungeon (requires Crescent Key)"] = "地城（需要新月鑰匙）"
L["Durotar"] = "杜洛塔"
L["Duskwood"] = "暮色森林"
L["Dustwallow Marsh"] = "塵泥沼澤"
L["Dwarven District"] = "矮人區"
L["Eastern Earthshrine"] = "東大地神殿"
L["Eastern Plaguelands"] = "東瘟疫之地"
L["Ebon Watch"] = "黑錶哨站"
L["Elements"] = "元素"
L["Elwynn Forest"] = "艾爾文森林"
L["Emerald Dream"] = "翡翠夢境"
L["Emerald Sanctuary"] = "翡翠聖地"
L["enabled"] = "啟用"
L["End Time"] = "終焉之刻"
L["Enhance battlefield map"] = "增強戰場地圖"
L["Enhance dungeon icons"] = "增強地下城圖示"
L["Enlarge player arrow"] = "放大玩家箭頭"
L["Enter"] = "輸入"
L["Evergrove"] = "永恆樹林"
L["Everlook"] = "永望鎮"
L["Evermoon Terrace"] = "永月露臺"
L["Eversong Woods"] = "永歌森林"
L["Exile's Hollow"] = "流放者洞穴"
L["Exodar"] = "艾克索達"
L["Eye of Azshara"] = "艾薩拉之眼"
L["Falanaar"] = "法拉納爾"
L["Falcon Watch"] = "獵鷹哨站"
L["Faldir's Cove"] = "法迪爾海灣"
L["Feathermoon Stronghold"] = "羽月要塞"
L["Felsoul Hold"] = "魔魂堡"
L["Felwood"] = "費伍德森林"
L["Feralas"] = "菲拉斯"
L["Firelands"] = "火源之界"
L["Fishing"] = "釣魚"
L["Fizzcrank Airstrip"] = "飛翎煙霧平臺"
L["Flame Crest"] = "烈焰峰"
L["Flayedwing Transporter"] = "殘翼運輸點"
L["Follow the eastward path"] = "沿著小路往東走"
L["Follow the westward path"] = "沿著小路往西走"
L["Fordragon Hold"] = "福德拉格之堡"
L["Forest Song"] = "森林之歌"
L["Fort Wildervar"] = "威德瓦堡壘"
L["Freehold"] = "自由港"
L["Freewind Post"] = "亂風崗"
L["Frosthold"] = "霜堡"
L["Gadgetzan"] = "加基森"
L["Garadar"] = "卡拉達爾"
L["Gate of the Setting Sun"] = "落陽關"
L["Gates of Valor"] = "英勇之門"
L["Ghostlands"] = "鬼魂之地"
L["Gnomeregan"] = "諾姆瑞根"
L["Graveyard"] = "墓地"
L["Green"] = "綠色"
L["Grim Batol"] = "格瑞姆巴托"
L["Grimrail Depot"] = "恐軌車站"
L["Grizzly Hills"] = "灰熊丘陵"
L["Grom'arsh Crash Site"] = "格羅瑪爾墜毀地"
L["Grom'gol Base Camp"] = "格羅姆高營地"
L["Group Icons"] = "隊伍圖示"
L["Gruul's Lair"] = "戈魯爾之巢"
L["Gundrak"] = "剛德拉克"
L["Gundrak (rear entrance)"] = "剛德拉克（後方入口）"
L["Hall of Ancient Paths"] = "古道神殿"
L["Halls of Atonement"] = "贖罪之殿"
L["Halls of Infusion"] = "灌注迴廊"
L["Halls of Lightning"] = "雷光大廳"
L["Halls of Origination"] = "起源大廳"
L["Halls of Stone"] = "石之大廳"
L["Halls of Valor"] = "英靈殿"
L["Hammerfall"] = "落錘鎮"
L["Head down the mountain from here."] = "從這裡下山。"
L["Head southeast from here and go up the mountain."] = "從這裡向東南走，然後上山。"
L["Heart of Fear"] = "恐懼之心"
L["Hellfire Citadel"] = "地獄火堡壘"
L["Hellfire Peninsula"] = "地獄火半島"
L["Hellfire Ramparts"] = "地獄火壁壘"
L["Hide filter reset button"] = "隱藏過濾器重置按鈕"
L["Hide town and city icons"] = "隱藏城鎮與都市圖示"
L["Highmaul"] = "天槌"
L["Hillsbrad Foothills"] = "希爾斯布萊德丘陵"
L["Honor Hold"] = "榮譽堡"
L["Horde Cities"] = "部落城市"
L["Hour of Twilight"] = "暮光之時"
L["Howling Fjord"] = "凜風峽灣"
L["Hyjal"] = "海加爾山"
L["Hyjal Summit"] = "海加爾山之戰"
L["Icecrown"] = "寒冰皇冠"
L["Icecrown Citadel"] = "冰冠城寨"
L["Icons"] = "圖示"
L["If checked, additional icons (such as portals) will be shown."] = "勾選後，將顯示額外圖示（例如傳送門）。"
L["If checked, archaeology digsites will be shown."] = "勾選後，將顯示考古挖掘地點。"
L["If checked, coordinates will be shown."] = "勾選後，將顯示座標。"
L["If checked, coordinates will have a dark background texture."] = "勾選後，座標將會有個黑色背景材質。"
L["If checked, coordinates will use a large font."] = "勾選後，座標會使用大字體。"
L["If checked, dungeons and raids will be shown."] = "勾選後，將顯示地下城與團隊副本。"
L["If checked, group icons will use a modern, class-colored design."] = "勾選後，隊伍圖示將使用更為摩登且職業著色的設計。"
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "勾選後，開啟地圖時會使用最後關閉地圖時的縮放等級，如果地圖區域並未改變。"
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "勾選後，當角色移動時指向地圖將會套用靜止的透明度設置。"
L["If checked, points of interest will be shown."] = "勾選後，將顯示關注點。"
L["If checked, quest objectives will be shown."] = "如果選中，將顯示任務目標。"
L["If checked, spirit healers will be shown."] = "如果選中，會顯示靈魂醫者"
L["If checked, the battlefield map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "如果選中，戰場地圖將保持在你的位置上居中，只要你不在地城中。|n|n在移動地圖時，按住Shift可以暫時阻止地圖居中"
L["If checked, the default fullscreen map will be used for the maximised map.|n|nNote that enabling this option will lock out some of the other options."] = "勾選後，預設全螢幕地圖將用於最大化地圖。|n|n請注意，啟用此選項將鎖定一些其他選項。"
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "勾選後，將使用預設的全屏地圖。|n|n請注意，啟用此選項將鎖定其他某些選項。"
L["If checked, the map border will be removed."] = "勾選後，將會移除地圖外框。"
L["If checked, the map frame will remain open until you close it."] = "勾選後，則地圖框將保持打開狀態，直到您將其關閉。"
L["If checked, the map will not fade while your character is moving."] = "勾選後，當您角色移動時不會淡出地圖。"
L["If checked, the map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "如果選中，地圖將保持在你的位置上居中，只要你不在地城中。|n|n在移動地圖時，按住Shift可以暫時阻止地圖居中"
L["If checked, the minimap button will be shown."] = "勾選後，會顯示小地圖按鈕。"
L["If checked, the minimum fishing skill levels will be shown."] = "勾選後，將顯示最低釣魚需求技能等級。"
L["If checked, the world map filter reset button will be hidden."] = "勾選後，世界地圖過濾器重置按鈕將被隱藏。"
L["If checked, town and city icons will not be shown on the continent maps."] = "勾選後，大陸地圖將不會顯示城鎮與都市圖示。"
L["If checked, travel points for the opposing faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "如果選中，將顯示敵對陣營的旅行點。|n|n包括飛行點、船塢、飛艇塔和有軌電車站"
L["If checked, travel points for the same faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "如果選中，將顯示相同陣營的旅行點。|n|n包括飛行點、船塢、飛艇塔和有軌電車站"
L["If checked, unexplored areas of the map will be shown on the world map and the battlefield map."] = "如果選中，將在世界地圖和戰場地圖上顯示未探索的區域。"
L["If checked, unexplored areas will be tinted."] = "勾選後，未探索區域將會著色。"
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "勾選後，當角色變換區域時，地圖將自動更改為新區域。"
L["If checked, you can move the battlefield map by dragging any of its borders."] = "勾選後，您可以透過拖曳戰場地圖的任何邊界來移動戰場地圖。"
L["If checked, you can move the battlefield map by dragging any of its borders.|n|nYou can resize the battlefield map by dragging the bottom-right corner."] = "如果選中，可以通過拖動任何邊界來移動戰場地圖。|n|n通過拖動右下角，還可以調整戰場地圖的大小"
L["If checked, you will be able to customise the battlefield map."] = "勾選後，您將可以自訂戰場地圖。"
L["If checked, you will be able to enlarge the player arrow."] = "勾選後，您將可以放大玩家箭頭。"
L["If checked, you will be able to move the frame by dragging the border."] = "勾選後，您將可以透由拖拉邊框來移動框架。"
L["If checked, you will be able to move the map.|n|nThe map position will be saved separately for the maximised and windowed maps."] = "勾選後，您將能夠移動地圖。|n|n地圖位置將分別保存為最大化和視窗化的地圖。"
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges."] = "勾選後，您將可以縮放與移動地圖。|n|n拖拉右下角的縮放把柄來縮放地圖。|n|n透由拖動外框與框架邊緣來移動地圖。"
L["If checked, you will be able to scale the map by dragging the scale handle in the bottom-right corner.|n|nYou will be able to move the map by dragging any border.|n|nYou can always drag the top border to move the map regardless of this setting."] = "如果選中，您將能夠通過拖動右下角的縮放手柄來調整地圖的比例。|n|n您可以通過拖動任何邊框來移動地圖。|n|n您始終可以拖動頂部邊框來移動地圖，而不受此設置的影響。"
L["If checked, you will be able to scale the map."] = "勾選後，您將能夠縮放地圖大小。"
L["If checked, you will be able to set the opacity of the map."] = "勾選後，您將可以設定地圖的透明度。"
L["If checked, you will be able to zoom further into the world map."] = "如果選中，你將能夠更進一步放大世界地圖"
L["If checked, your character will not perform the reading emote when you open the map."] = "勾選後，當您的角色開啟地圖時不會行使閱讀表情。"
L["If checked, zone and continent dropdown menus will be shown in the map frame."] = "如果選中，在地圖框架中將顯示區域和大陸下拉菜單"
L["If checked, zone and dungeon levels will be shown."] = "勾選後，將會顯示區域與地下城等級。"
L["If checked, zone crossings will be shown.|n|nThese are clickable arrows that indicate the zone exit pathways."] = "如果選中，將顯示區域交叉點。|n|n這些是指示區域出口路徑的可點擊箭頭"
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "勾選後，將顯示區域、地下城以及釣魚技能等級。"
L["Increase zoom level"] = "增加縮放級別"
L["Invalid command.  Enter /ltm help for help."] = "無效的指令。輸入 /ltm help 取得幫助。"
L["Invalid map ID."] = "無效地圖ID"
L["Iron Docks"] = "鋼鐵碼頭"
L["Ironforge"] = "鐵爐堡"
L["Isle of Quel'Danas"] = "奎爾達納斯之島"
L["Just follow the path west"] = "沿著小路往西走"
L["K3"] = "K3"
L["Kamagua"] = "卡瑪古阿"
L["Karazhan"] = "卡拉贊"
L["Kargath"] = "卡加斯"
L["Kings' Rest"] = "諸王之眠"
L["Kor'kron Vanguard"] = "科爾克隆先遣鏢局"
L["Lake Elune'ara"] = "月神湖"
L["Lake Everstill"] = "湖畔鎮"
L["Large Scarab Coffer"] = "大型聖甲蟲箱"
L["Leads to Tirisfal Glades"] = "通往提里斯法林地"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS: 安裝了錯誤的版本！"
L["Library"] = "圖書館"
L["Light's Breach"] = "聖光之斷"
L["Light's Hope Chapel"] = "聖光之願大教堂"
L["Lion's Watch"] = "雄獅堡"
L["Loch Modan"] = "洛克莫丹"
L["Lost City of the Tol'vir"] = "托維爾的失落之城"
L["Lower Blackrock Spire"] = "黑石塔下層"
L["Lunastre Estate"] = "路納斯特莊園"
L["Magisters' Terrace"] = "博學者殿堂"
L["Magtheridon's Lair"] = "馬瑟里頓的巢穴"
L["Mana-Tombs"] = "法力墓地"
L["Map frame scale"] = "地圖框架縮放"
L["Map Opacity"] = "地圖不透明度"
L["Map Scale"] = "地圖比例"
L["Map Size"] = "地圖大小"
L["Maraudon"] = "瑪拉頓"
L["Maraudon: Earth Song Falls"] = "瑪拉頓：毒水瀑布"
L["Maraudon: Foulspore Cavern"] = "瑪拉頓：毒菇洞穴"
L["Maraudon: The Wicked Grotto"] = "瑪拉頓：邪惡洞穴"
L["Marshal's Refuge"] = "馬紹爾營地"
L["Maw of Souls"] = "靈魂之喉"
L["Max Zoom"] = "最大縮放"
L["Maximised"] = "最大化"
L["Maximum"] = "最大的"
L["Mechanics"] = "地圖結構"
L["Memory Usage"] = "記憶體使用量"
L["Menethil Harbor"] = "米奈希爾港"
L["Miscellaneous"] = "雜項"
L["Mists of Tirna Scithe"] = "特那希迷霧"
L["Moa'ki"] = "莫亞基"
L["Moa'ki Harbor"] = "莫亞基港"
L["Mogu'shan Palace"] = "魔古山宮"
L["Mogu'shan Vaults"] = "魔古山寶庫"
L["Mok'Nathal Village"] = "摩克納薩爾村"
L["Molten Core"] = "熔火之心"
L["Moon Guard Stronghold"] = "月之守衛要塞"
L["Moonglade"] = "月光林地"
L["More"] = "更多"
L["Morgan's Vigil"] = "摩根的崗哨"
L["Mount Crafting"] = "坐騎製作"
L["Mount Hyjal"] = "海加爾山"
L["Mountain Pass (Horde Only)"] = "山口（僅部落）"
L["Moving"] = "移動"
L["Mudsprocket"] = "泥鏈營地"
L["Mulgore"] = "莫高雷"
L["Nagrand"] = "納葛蘭"
L["Naxxramas"] = "納克薩瑪斯"
L["Nazjatar"] = "納沙塔爾"
L["Neltharion's Lair"] = "奈薩里奧的巢穴"
L["Neltharus"] = "奈薩魯斯堡"
L["Nesingwary Base Camp"] = "奈辛瓦里營地"
L["Nethergarde Keep"] = "守望堡"
L["Netherstorm"] = "虛空風暴"
L["Never"] = "永不"
L["New Agamand"] = "新阿加曼德"
L["Nighthaven"] = "永夜港"
L["Nijel's Point"] = "尼耶爾前哨站"
L["Nordrassil"] = "諾達希爾"
L["North"] = "北方"
L["North Gate Pass"] = "北門小徑"
L["Ny'alotha, The Waking City"] = "奈奧羅薩，甦醒之城"
L["Ohn'ahran Plains"] = "雍亞拉平原"
L["Old Hillsbrad"] = "希爾斯布萊德舊世"
L["Old Hillsbrad Foothills"] = "希爾斯布萊德丘陵舊址"
L["Onyxia's Lair"] = "奧妮克希亞的巢穴"
L["Opacity"] = "透明度"
L["Operation: Mechagon"] = "機械岡行動"
L["or click the minimap button to open Leatrix Maps."] = "或是點擊小地圖按鈕來開啟Leatrix Maps。"
L["Orb of Translocation"] = "傳送水晶球"
L["Orebor Harborage"] = "奧雷伯爾港"
L["Orgrimmar"] = "奧格瑪"
L["Oribos"] = "奧睿博司"
L["Pet Crafting"] = "寵物製作"
L["Plaguefall"] = "瘟疫之臨"
L["Player"] = "玩家"
L["Player Arrow"] = "玩家箭頭"
L["Portal"] = "傳送門"
L["Portal from Zephyr"] = "西風之門"
L["Portals"] = "傳送門"
L["Preview"] = "預覽"
L["Protoform Repository"] = "原型儲藏庫"
L["Ragefire Chasm"] = "怒焰裂谷"
L["Raid"] = "團隊副本"
L["Ratchet"] = "棘齒城"
L["Ravenholdt Manor"] = "鴉堡莊園"
L["Razorfen Downs"] = "剃刀高地"
L["Razorfen Kraul"] = "剃刀沼澤"
L["Razorthorn Trail"] = "劍刺小徑"
L["Rebel Camp"] = "反抗軍營地"
L["Red"] = "紅色"
L["Redridge Mountains"] = "赤脊山"
L["Refuge Pointe"] = "避難谷地"
L["Reload"] = "重載"
L["Remember zoom level"] = "記憶縮放等級"
L["Remove map border"] = "移除地圖外框"
L["req"] = "需要"
L["Requires Key to Searing Gorge"] = "需要熔火峽鑰匙"
L["Requires UI reload."] = "需要介面重載。"
L["Reset"] = "重置"
L["Reset Map Layout"] = "重設地圖佈局"
L["Return to Karazhan"] = "重返卡拉贊"
L["Revantusk Village"] = "惡齒村"
L["River's Heart"] = "河流之心"
L["Ruby Life Pools"] = "晶紅生命之池"
L["Ruins of Ahn'Qiraj"] = "安琪拉廢墟"
L["Ruins of Elune'eth"] = "伊露恩斯遺址"
L["Rut'Theran Village"] = "魯瑟蘭村"
L["Rut'theran Village"] = "魯瑟蘭村"
L["Sanctuary"] = "聖殿"
L["Sanctum of Domination"] = "統御聖所"
L["Sanctum of Order"] = "秩序聖所"
L["Sanctum of the Sages"] = "賢者聖殿"
L["Sanctum of the Stars"] = "星光聖所"
L["Sanguine Depths"] = "血紅深淵"
L["Scale"] = "縮放比例"
L["Scale the map"] = "縮放地圖大小"
L["Scarlet Halls"] = "血色大廳"
L["Scarlet Monastery"] = "血色修道院"
L["Scholomance"] = "通靈學院"
L["Searing Gorge"] = "灼熱峽谷"
L["Seat of the Naaru"] = "納魯之座"
L["Seat of the Triumvirate"] = "三傑議會之座"
L["Sentinel Hill"] = "哨兵嶺"
L["Sepulcher of the First Ones"] = "首創者墓穴"
L["Serpentshrine Cavern"] = "毒蛇神殿洞穴"
L["Set map opacity"] = "設定地圖透明度"
L["Set map opacity while stationary and while moving."] = "設定當移動或靜止時地圖的透明度。"
L["Set the group icon size."] = "設定隊伍圖示大小。"
L["Set the maximum zoom scale."] = "設定最大縮放比例"
L["Set the player arrow size."] = "設置玩家箭頭大小。"
L["Sethekk Halls"] = "塞司克大廳"
L["Settings"] = "設置"
L["Sewers"] = "下水道"
L["Shado-Pan Monastery"] = "影潘僧院"
L["Shadow Labyrinth"] = "暗影迷宮"
L["Shadowfang Keep"] = "影牙城堡"
L["Shadowlands"] = "暗影之境"
L["Shadowmoon Burial Grounds"] = "影月墓地"
L["Shadowmoon Valley"] = "影月谷"
L["Shadowmoon Village"] = "影月村"
L["Shadowprey Village"] = "葬影村"
L["Shal'Aran"] = "沙亞蘭"
L["Shatter Point"] = "碎裂地點"
L["Shattrath"] = "撒塔斯"
L["Shattrath City"] = "撒塔斯城"
L["Sholazar Basin"] = "索拉查盆地"
L["Show additional icons"] = "顯示額外圖示"
L["Show background"] = "顯示背景"
L["Show boats, zeppelins and trams"] = "顯示船舶、飛艇以及地鐵"
L["Show coordinates"] = "顯示座標"
L["Show digsites"] = "顯示挖掘場"
L["Show dungeons and raids"] = "顯示地下城與團隊副本"
L["Show minimap button"] = "顯示小地圖按鈕"
L["Show minimum fishing skill levels"] = "顯示最低釣魚技能等級"
L["Show objectives"] = "顯示目標"
L["Show points of interest"] = "顯示關注站點"
L["Show scale handle"] = "顯示縮放控制"
L["Show spirit healers"] = "顯示靈魂醫者"
L["Show travel points for opposing faction"] = "顯示敵對陣營的旅行點"
L["Show travel points for same faction"] = "顯示相同陣營的旅行點"
L["Show unexplored areas"] = "顯露未探索區域"
L["Show zone crossings"] = "顯示區域交叉點"
L["Show zone levels"] = "顯示區域等級"
L["Show zone menus"] = "顯示區域菜單"
L["Shrine of Aviana"] = "艾維娜神殿"
L["Shrine of the Storm"] = "風暴聖壇"
L["Side entrance"] = "側門"
L["Siege of Boralus"] = "圍攻波拉勒斯"
L["Siege of Niuzao Temple"] = "圍攻怒兆寺"
L["Siege of Orgrimmar"] = "圍攻奧格瑪"
L["Silithus"] = "希利蘇斯"
L["Silvermoon"] = "銀月城"
L["Silvermoon City"] = "銀月城"
L["Silverpine Forest"] = "銀松森林"
L["Skyreach"] = "擎天峰"
L["Slave Pens"] = "奴隸監牢"
L["South"] = "南方"
L["South Gate Pass"] = "南門小徑"
L["Southfury River"] = "南怒之河"
L["Southshore"] = "南海鎮"
L["Spinebreaker Ridge"] = "斷脊山脈"
L["Spires of Ascension"] = "晉升之巔"
L["Spirit Healer"] = "靈魂醫者"
L["Splintertree Post"] = "碎木崗哨"
L["Stars' Rest"] = "星光之息"
L["Stationary"] = "靜止"
L["Steamvault"] = "蒸氣洞窟"
L["Sticky map frame"] = "黏附地圖框架"
L["Stonard"] = "斯通納德"
L["Stonebreaker Hold"] = "碎石堡"
L["Stonetalon Mountains"] = "石爪山脈"
L["Stonetalon Peak"] = "石爪峰"
L["Stormstout Brewery"] = "風暴烈酒酒坊"
L["Stormwind"] = "暴風城"
L["Stormwind City"] = "暴風城"
L["Stranglethorn Vale"] = "荊棘谷"
L["Stratholme (Main Gate)"] = "斯坦索姆（主門）"
L["Stratholme (Service Gate)"] = "斯坦索姆（僕從入口）"
L["Stratholme: Crusader's Square"] = "斯坦索姆：十字軍廣場"
L["Stratholme: The Gauntlet"] = "斯坦索姆：The Gauntlet"
L["sum"] = "召喚"
L["Sun Rock Retreat"] = "烈日石居"
L["Sunreaver's Command"] = "逐日者指揮部"
L["Sun's Reach Harbor"] = "日境港"
L["Sunwell Plateau"] = "太陽之井高地"
L["Swamp of Sorrows"] = "悲傷沼澤"
L["Swamprat Post"] = "斯溫派特崗哨"
L["Sylvanaar"] = "希爾瓦納"
L["Synthesis Forge"] = "合成熔爐"
L["System"] = "系統"
L["Talonbranch Glade"] = "刺枝林地"
L["Talrendis Point"] = "塔倫迪斯營地"
L["Tanaris"] = "塔納利斯"
L["Tarren Mill"] = "塔倫米爾"
L["Taunka'le Village"] = "唐卡雷村"
L["Taxi to Scholar's Den"] = "乘坐到學者居所"
L["Taxi to Vault of Secrets"] = "乘坐到玄秘寶庫"
L["Tazavesh, the Veiled Market"] = "『帷幕市集』塔札維許"
L["Telaar"] = "泰拉"
L["Tel'anor"] = "泰爾亞諾"
L["Teldrassil"] = "泰達希爾"
L["Teleport Crystal"] = "傳送水晶"
L["Telredor"] = "泰倫多爾"
L["Tempest Keep"] = "風暴要塞"
L["Temple of Ahn'Qiraj"] = "安琪拉神廟"
L["Temple of Atal'Hakkar"] = "阿塔哈卡神廟"
L["Temple of Sethraliss"] = "瑟沙利斯神廟"
L["Temple of Telhamat"] = "特爾哈曼神廟"
L["Temple of the Jade Serpent"] = "玉蛟寺"
L["Temple of the Moon"] = "月神殿"
L["Terokkar Forest"] = "泰洛卡森林"
L["Terrace of Endless Spring"] = "豐泉台"
L["Thalanaar"] = "薩蘭納爾"
L["Thandol Span"] = "薩多爾大橋"
L["The Arcatraz"] = "亞克崔茲"
L["The Arcway"] = "幽暗地道"
L["The Argent Stand"] = "銀白看臺"
L["The Argent Vanguard"] = "銀白先鋒"
L["The Azure Vault"] = "蒼藍密庫"
L["The Barrens"] = "貧瘠之地"
L["The Bastion of Twilight"] = "暮光堡壘"
L["The Black Morass"] = "黑色沼澤"
L["The Blood Furnace"] = "血熔爐"
L["The Botanica"] = "波塔尼卡"
L["The Bulwark"] = "亡靈壁壘"
L["The Crossroads"] = "十字路口"
L["The Culling of Stratholme"] = "斯坦索姆的抉擇"
L["The Dark Portal"] = "黑暗之門"
L["The Deadmines"] = "死亡礦坑"
L["The Dragon Soul"] = "巨龍之魂"
L["The Emerald Nightmare"] = "翡翠夢魘"
L["The Everbloom"] = "永茂林"
L["The Exodar"] = "艾克索達"
L["The Eye"] = "暴風之眼"
L["The Eye of Eternity"] = "永恆之眼"
L["The Forge of Souls"] = "靈魂熔爐"
L["The Forgotten Coast"] = "被遺忘的海岸"
L["The Frozen Halls"] = "冰凍大廳"
L["The Great Forge"] = "大鍛爐"
L["The Great Lift"] = "升降梯"
L["The Halls of Reflection"] = "倒映大廳"
L["The Hinterlands"] = "辛特蘭"
L["The Mechanar"] = "麥克納爾"
L["The MOTHERLODE!!"] = "晶喜鎮！"
L["The Necrotic Wake"] = "死靈戰地"
L["The Nexus"] = "魔枢"
L["The Nighthold"] = "暗夜堡"
L["The Nokhud Offensive"] = "諾庫德進攻地"
L["The Obsidian Sanctum"] = "黑曜聖所"
L["The Oculus"] = "奧核之眼"
L["The Old Kingdom"] = "古王國"
L["The Overlook Cliffs"] = "望海崖"
L["The Pit of Saron"] = "薩倫之淵"
L["The Ruby Sanctum"] = "晶紅聖所"
L["The Sepulcher"] = "瑟伯切爾"
L["The Shadow Vault"] = "影牢"
L["The Shattered Halls"] = "破碎大廳"
L["The Stockade"] = "監獄"
L["The Stonecore"] = "石岩之心"
L["The Storm Peaks"] = "風暴群山"
L["The Stormspire"] = "風暴之尖"
L["The Talondeep Path"] = "石爪小徑"
L["The Underrot"] = "幽腐深窟"
L["The Vault of Lights"] = "光之聖匣"
L["The Violet Hold"] = "紫羅蘭堡"
L["The Vortex Pinnacle"] = "漩渦尖塔"
L["The Waning Crescent"] = "弦月旅店"
L["The Zoram Strand"] = "佐拉姆海岸"
L["Theater of Pain"] = "苦痛劇場"
L["Thelsamar"] = "塞爾薩瑪"
L["Theramore Isle"] = "賽拉摩島"
L["Thorium Point"] = "瑟銀哨站"
L["Thousand Needles"] = "千針石林"
L["Thrallmar"] = "索爾瑪"
L["Throne of the Four Winds"] = "四風王座"
L["Throne of the Tides"] = "海潮王座"
L["Throne of Thunder"] = "雷霆王座"
L["Thunder Bluff"] = "雷霆崖"
L["Thunderlord Stronghold"] = "雷霆王要塞"
L["Timbermaw Hold"] = "木喉要塞"
L["Tinker Town"] = "地精區"
L["Tint unexplored areas"] = "未探索區域色調"
L["Tiragarde Sound"] = "提拉加德海灣"
L["Tirisfal Glades"] = "提瑞斯法林地"
L["Titan Translocator"] = "泰坦移位裝置"
L["Toggle panel"] = "切換面板"
L["Tol Barad"] = "托巴拉德"
L["Tomb of Sargeras"] = "薩格拉斯之墓"
L["Toshley's Station"] = "托斯利基地"
L["Trade District"] = "貿易區"
L["Trade Quarter"] = "貿易區"
L["Tram to"] = "地鐵到"
L["Tranquillien"] = "安寧地"
L["Transitus Shield"] = "轉移之盾"
L["Transparency"] = "透明度"
L["Trial of the Champion"] = "勇士試煉"
L["Trial of the Crusader"] = "十字軍的試煉"
L["Trial of Valor"] = "勇氣試煉"
L["Twilight Highlands"] = "暮光高地"
L["Twilight Shore"] = "暮光海岸"
L["Twilight Vale"] = "暮光谷"
L["Twilight Vineyards"] = "暮光葡萄園"
L["Uldaman"] = "奧達曼"
L["Uldaman (rear entrance)"] = "奧達曼（後門）"
L["Uldaman (side entrance)"] = "奧達曼（側面入口）"
L["Uldaman: Legacy of Tyr"] = "奧達曼：提爾的傳承"
L["Uldir"] = "奧迪爾"
L["Ulduar"] = "奧杜亞"
L["Uldum"] = "奧丹姆"
L["Underbog"] = "深幽泥沼"
L["Undercity"] = "幽暗城"
L["Un'Goro Crater"] = "安戈落環形山"
L["Unlock battlefield map"] = "解鎖戰場地圖"
L["Unlock map frame"] = "解鎖地圖框架"
L["Unu'pe"] = "烏努佩"
L["Upper Blackrock Spire"] = "黑石塔上層"
L["Use default map"] = "使用預設地圖"
L["Use large font"] = "使用大字體"
L["Use stationary opacity while pointing at map"] = "指向地圖時使用固定的透明度"
L["Utgarde Keep"] = "守望堡"
L["Utgarde Pinnacle"] = "守望堡尖塔"
L["Valaar's Berth"] = "瓦拉船台"
L["Valdrakken Portals"] = "沃卓肯傳送門"
L["Valgarde"] = "瓦加德"
L["Valgarde Port"] = "瓦加德港口"
L["Valiance Keep"] = "驍勇堡"
L["Valiance Landing Camp"] = "勇氣臨港營地"
L["Valley of Strength"] = "力量之谷"
L["Valormok"] = "菲歐莫克"
L["Vashj'ir"] = "瓦許伊爾"
L["Vault of Archavon"] = "亞夏梵穹殿"
L["Vault of the Incarnates"] = "洪荒化身密庫"
L["Vault of the Wardens"] = "看守者寶庫"
L["Vengeance Landing"] = "復仇臨港"
L["Venomspite"] = "毒害之地"
L["Version"] = "版本"
L["Vol'mar"] = "沃爾瑪"
L["Wailing Caverns"] = "哀嚎洞穴"
L["Warsong Camp"] = "戰歌營地"
L["Warsong Hold"] = "戰歌堡"
L["Waycrest Manor"] = "威奎斯特莊園"
L["Well of Eternity"] = "永恆之井"
L["Western Earthshrine"] = "西大地神殿"
L["Western Plaguelands"] = "西瘟疫之地"
L["Westfall"] = "西部荒野"
L["Westfall Brigade"] = "西荒兵團"
L["Westguard Keep"] = "西衛要塞"
L["Wetlands"] = "濕地"
L["Wildhammer Stronghold"] = "蠻錘要塞"
L["Windowed"] = "視窗化"
L["Windrunner's Overlook"] = "風行者的瞭望台"
L["Wintergarde Keep"] = "寒冰堡"
L["Wintergrasp"] = "冬之握"
L["Winterspring"] = "冬泉谷"
L["World of Warcraft Classic"] = "魔獸世界經典版"
L["Wrath of the Lich King Classic"] = "巫妖王之怒經典版"
L["Wyrmrest Temple"] = "龍眠神殿"
L["You cannot do that in combat."] = "你不能在戰鬥中這麼做。"
L["You will die!"] = "你將死亡！"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "您的UI需要重載以讓某些更動生效。|n|n您不用立刻點擊重載按鈕，但當您做了些更動並想要更動生效的話，需要馬上重載。"
L["Your UI needs to be reloaded."] = "您的UI需要重載。"
L["Zabra'jin"] = "薩布拉金"
L["Zangarmarsh"] = "贊格沼澤"
L["Zeb'Sora"] = "澤布索拉"
L["Zeppelin to"] = "飛船到"
L["Zim'Torga"] = "辛托爾加"
L["Zone Map"] = "區域地圖"
L["Zoom"] = "縮放"
L["Zoram'gar Outpost"] = "佐拉姆加前哨站"
L["Zul'Aman"] = "祖阿曼"
L["Zuldazar"] = "贊達拉"
L["Zul'Drak"] = "祖爾德拉克"
L["Zul'Farrak"] = "祖爾法拉克"
L["Zul'Gurub"] = "祖爾格拉布"

end

-- ruRU: Russian
if GameLocale == "ruRU" then
L["(destination only)"] = "(только пункт назначения)"
L["(inside Caverns of Time)"] = "(внутри Пещер Времени)"
L["/ltm help - Show this information."] = "/ltm help - Показать эту информацию."
L["/ltm reset - Reset the panel position."] = "/ltm reset - Сбросить положение панели."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - Удалить все настройки и перезагрузить."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "Возникла ошибка, но не беспокойтесь. Такое бывает время от времени. Перезагрузите интерфейс, чтобы исправить её."
L["Abyssal Depths"] = "Бездонные глубины"
L["Acherus: The Ebon Hold"] = "Акерус: Черный оплот"
L["Aerie Peak"] = "Заоблачный пик"
L["Agmar's Hammer"] = "Молот Агмара"
L["Ahn'Qiraj"] = "Ан'Кираж"
L["Aldor"] = "Алдоры"
L["Algeth'ar Academy"] = "Академия Алгет'ар"
L["Allerian Stronghold"] = "Бастион Аллерии"
L["Alliance Cities"] = "Города Альянса"
L["Allow frame movement"] = "Разрешить перемещение фрейма "
L["Alpha"] = "Альфа"
L["Altar of Sha'tar"] = "Алтарь Ша'тар"
L["Alterac Mountains"] = "Альтеракские горы"
L["Always"] = "Всегда"
L["Amber Lodge"] = "Янтарная гряда"
L["Amberpine Lodge"] = "Приют Янтарной Сосны"
L["Andorhal"] = "Андорал"
L["Antorus, the Burning Throne"] = "Анторус, Пылающий Трон"
L["Apothecary Camp"] = "Аптекарский поселок"
L["Appearance"] = "Внешний вид"
L["Arathi Highlands"] = "Нагорье Арати"
L["Area 52"] = "Зона 52"
L["Argent Tournament Grounds"] = "Ристалище Серебряного турнира"
L["Armory"] = "Оружейная"
L["Ashenvale"] = "Ясеневый лес"
L["Astranaar"] = "Астранаар"
L["Astravar Harbor"] = "Гавань Астравар"
L["Atal'Dazar"] = "Атал'Дазар"
L["Auberdine"] = "Аубердин"
L["Auchenai Crypts"] = "Аукенайские гробницы"
L["Auchindoun"] = "Аукиндон"
L["Auto change zones"] = "Авто-смена зоны"
L["available during zone attack"] = "доступно во время атаки на зону"
L["Azeroth"] = "Азерот"
L["Azjol-Nerub"] = "Азжол-Неруб"
L["Azshara"] = "Азшара"
L["Azure Watch"] = "Лазурная застава"
L["Azuremyst Isle"] = "Остров Лазурной Дымки"
L["Back to Main Menu"] = "В главное меню"
L["Badlands"] = "Бесплодные земли"
L["Bambala"] = "Бамбала"
L["Baradin Hold"] = "Крепость Барадин"
L["Battle of Dazar'alor"] = "Битва за Дазар'алор"
L["Battlegrounds"] = "Поля боя"
L["Bilgewater Harbor"] = "Гавань Трюмных Вод"
L["Black Morass"] = "Черные топи"
L["Black Rook Hold"] = "Крепость Черной Ладьи"
L["Black Temple"] = "Черный храм"
L["Blackfathom Camp"] = "Лагерь у Непроглядной Пучины"
L["Blackfathom Deeps"] = "Непроглядная Пучина"
L["Blackrock Caverns"] = "Пещеры Черной горы"
L["Blackrock Depths"] = "Глубины Черной горы"
L["Blackrock Foundry"] = "Литейная клана Черной горы"
L["Blackrock Mountain"] = "Черная гора"
L["Blackrock Spire"] = "Пик Черной горы"
L["Blackwing Descent"] = "Твердыня Крыла Тьмы"
L["Blackwing Lair"] = "Логово Крыла Тьмы"
L["Blade Tooth Canyon"] = "Каньон Острого Зуба"
L["Blade's Edge Mountains"] = "Острогорье"
L["Blades' Run"] = "Скалистая тропа"
L["Blasted Lands"] = "Выжженные земли"
L["Blood Watch"] = "Кровавая застава"
L["Bloodgulch"] = "Кровавое ущелье"
L["Bloodhoof Village"] = "Деревня Кровавого Копыта"
L["Bloodmaul Slag Mines"] = "Шлаковые шахты Кровавого Молота"
L["Bloodmyst Isle"] = "Остров Кровавой Дымки"
L["Bloodvenom Post"] = "Застава Отравленной Крови"
L["Bloodwatcher Point"] = "Лагерь Кровавого Взора"
L["Blue"] = "Синий"
L["Boat to"] = "Корабль в"
L["Bogpaddle"] = "Веслотопь"
L["Bootlegger Outpost"] = "Стоянка бутлегеров"
L["Booty Bay"] = "Пиратская Бухта"
L["Borean Tundra"] = "Борейская тундра"
L["Bor'gorok Outpost"] = "Застава Бор'горока"
L["Bouldercrag's Refuge"] = "Приют Глыбоскала"
L["Brackenhide Hollow"] = "Пещера Бурошкуров"
L["Brackenwall Village"] = "Деревня Гиблотопь"
L["Brill"] = "Брилл"
L["Burning Crusade Classic"] = "Burning Crusade Classic"
L["Burning Steppes"] = "Пылающие степи"
L["Camp Ataya"] = "Лагерь Атайа"
L["Camp Everstill"] = "Лагерь Безмолвия"
L["Camp Mojache"] = "Лагерь Мохаче"
L["Camp Oneqwah"] = "Лагерь Уанква"
L["Camp Taurajo"] = "Лагерь Таурахо"
L["Camp Tunka'lo"] = "Лагерь Тунка'ло"
L["Camp Winterhoof"] = "Лагерь Заиндевевшего Копыта"
L["Castle Nathria"] = "Замок Нафрия"
L["Cathedral"] = "Собор"
L["Cathedral of Eternal Night"] = "Собор Вечной Ночи"
L["Caverns of Time"] = "Пещеры Времени"
L["Cenarion Hold"] = "Крепость Кенария"
L["Center map on player"] = "Центрировать по игроку"
L["Central Mesa"] = "Центральная меза"
L["Chamber of Heart"] = "Зал Сердца"
L["Chillwind Camp"] = "Лагерь Промозглого Ветра"
L["Chiselgrip"] = "Узкоклинье"
L["Choose where the zone map should be shown."] = "Выберите, где должна отображаться карта зоны."
L["Class colored icons"] = "Классовые цветные значки"
L["Classic"] = "Классик"
L["Click to configure the settings for this option."] = "Нажмите, чтобы перейти к интерфейсу дополнительных параметров этой настройки."
L["Click to reset the position and scale of the map frame."] = "Нажмите, чтобы сбросить положение и масштаб окна карты."
L["Click to reset the settings on this page."] = "Нажмите, чтобы сбросить настройки на этой странице."
L["Click to return to the main menu."] = "Нажмите, чтобы вернуться в главное меню."
L["Coilfang Reservoir"] = "Резервуар Кривого Клыка"
L["Coldarra"] = "Хладарра"
L["Configuration Panel"] = "Панель настроек"
L["Conquest Hold"] = "Крепость Завоевателей"
L["Cosmic"] = "Космический"
L["Cosmowrench"] = "Космоворот"
L["Court of Stars"] = "Квартал Звезд"
L["Crown Guard Tower"] = "Башня Королевской Стражи"
L["Crucible of Storms"] = "Горнило Штормов"
L["Crusaders' Pinnacle"] = "Вершина Рыцарей"
L["Crushblow"] = "Тукмак"
L["Crystalsong Forest"] = "Лес Хрустальной Песни"
L["Culling of Stratholme"] = "Очищение Стратхольма"
L["Cursor"] = "Курсор"
L["Dalaran"] = "Даларан"
L["Dalaran Crater"] = "Даларанский кратер"
L["Darkheart Thicket"] = "Чаща Темного Сердца"
L["Darkshire"] = "Темнолесье"
L["Darkshore"] = "Темные берега"
L["Darnassus"] = "Дарнас"
L["De Other Side"] = "Та Сторона"
L["Deadwind Pass"] = "Перевал Мертвого Ветра"
L["Death's Rise"] = "Уступ Смерти"
L["Debug"] = "Режим отладки"
L["Deepholm"] = "Подземье"
L["Desolace"] = "Пустоши"
L["Dire Maul (East)"] = "Забытый Город (Восток)"
L["Dire Maul (East) (side entrance)"] = "Забытый Город (Восток) (боковой вход)"
L["Dire Maul (North)"] = "Забытый Город (Север)"
L["Dire Maul (West)"] = "Забытый Город (Запад)"
L["Dire Maul: Capital Gardens"] = "Забытый Город (Центральный сад)"
L["Dire Maul: Gordok Commons"] = "Забытый Город (Палаты Гордока)"
L["Dire Maul: Warpwood Quarter"] = "Забытый Город (Квартал Криводревов)"
L["Disable map fade"] = "Откл. затемнение карты"
L["Disable reading emote"] = "Откл. эмоцию чтения карты "
L["Disable reading emote when opening the map"] = "Отключить эмоцию открытия карты"
L["disabled"] = "Отключено"
L["Drag"] = "Переместить"
L["Drag to set the amount of blue."] = "Переместите ползунок влево или вправо, чтобы установить уровень синего цвета."
L["Drag to set the amount of green."] = "Переместите ползунок влево или вправо, чтобы установить уровень зеленого цвета."
L["Drag to set the amount of red."] = "Переместите ползунок влево или вправо, чтобы установить уровень красного цвета."
L["Drag to set the battlefield map opacity."] = "Переместите ползунок влево или вправо, чтобы установить прозрачность карты поля боя."
L["Drag to set the battlefield map size."] = "Переместите ползунок влево или вправо, чтобы установить размер карты поля боя"
L["Drag to set the battlefield map size.|n|nIf the map is unlocked, you can also resize the battlefield map by dragging the bottom-right corner."] = "Переместите ползунок влево или вправо, чтобы установить размер карты поля боя.|n|nЕсли карта разблокирована, вы также можете изменить размер карты, потянув за её правый нижний угол."
L["Drag to set the group icon size."] = "Переместите ползунок влево или вправо, чтобы установить размер значка."
L["Drag to set the map opacity for when your character is moving."] = "Переместите ползунок влево или вправо, чтобы установить прозрачность карты, когда ваш персонаж находится в движении."
L["Drag to set the map opacity for when your character is stationary."] = "Переместите ползунок влево или вправо, чтобы установить непрозрачность карты, когда ваш персонаж неподвижен."
L["Drag to set the maximum zoom level.|n|nOpen the battlefield map to see the maximum zoom level change as you drag the slider."] = "Переместите ползунок влево или вправо, чтобы установить максимальный уровень приближения (масштабирования) карты в процентах.|n|nОткройте карту поля боя, чтобы увидеть изменение в уровне максимального приближения при перемещении ползунка."
L["Drag to set the maximum zoom level.|n|nOpen the map to see the maximum zoom level change as you drag the slider."] = "Переместите ползунок влево или вправо, чтобы установить максимальный уровень приближения (масштабирования) карты в процентах.|n|nОткройте карту мира, чтобы увидеть изменение в уровне максимального приближения при перемещении ползунка."
L["Drag to set the opacity."] = "Переместите ползунок влево или вправо, чтобы установить уровень прозрачности."
L["Drag to set the player arrow size."] = "Переместите ползунок влево или вправо, чтобы установить размер стрелки игрока."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "Переместите ползунок влево или вправо, чтобы установить желаемый размер указателя вашего персонажа.|n|nClassic по умолчанию 16 .|nАктуальная версия по умолчанию - 27."
L["Drag to set the scale for the maximised map."] = "Перетащите, чтобы задать масштаб развернутой карты."
L["Drag to set the scale for the windowed map."] = "Перетащите, чтобы установить масштаб оконной карты."
L["Drag to set the world map scale.|n|nYou can also rescale the world map by dragging the bottom-right corner."] = "Тяни, чтобы установить масштаб карты мира.|n|nТы также можешь изменить масштаб карты мира, перетаскивая правый нижний угол."
L["Dragon Soul"] = "Душа Дракона"
L["Dragonblight"] = "Драконий Погост"
L["Dragonmaw Port"] = "Порт Драконьей Пасти"
L["Drak'Tharon Keep"] = "Крепость Драк'Тарон"
L["Dreadmaul Hold"] = "Форт Молота Ужаса"
L["Dreamer's Rest"] = "Покои Дремлющего"
L["Druid only flight point to Darnassus"] = "Пункт перелета в Дарнас (только для Друида)"
L["Druid only flight point to Thunder Bluff"] = "Пункт перелета в Громовой Утес (только для Друида)"
L["Dun Algaz"] = "Дун Альгаз"
L["Dun Modr"] = "Дун Модр"
L["Dun Morogh"] = "Дун Морог"
L["Dun Nifflelem"] = "Дун Ниффелем"
L["Dungeon"] = "Подземелье"
L["Dungeon (requires Crescent Key)"] = "Подземелье (требуется Серповидный ключ)"
L["Durotar"] = "Дуротар"
L["Duskwood"] = "Сумеречный лес"
L["Dustwallow Marsh"] = "Пылевые топи"
L["Dustwind Dig"] = "Раскопки Пыльного Ветра"
L["Dwarven District"] = "Подземный поезд"
L["Eastern Earthshrine"] = "Восточное Святилище Земли"
L["Eastern Plaguelands"] = "Восточные Чумные земли"
L["Eastpoint Tower"] = "Восточная башня"
L["Eastwall Tower"] = "Восточная башня"
L["Ebon Watch"] = "Черная застава"
L["Elements"] = "Элементы"
L["Elwynn Forest"] = "Элвиннский лес"
L["Emerald Dream"] = "Изумрудный Сон"
L["Emerald Sanctuary"] = "Изумрудное святилище"
L["enabled"] = "Включено"
L["End Time"] = "Конец Времен"
L["Enhance battlefield map"] = "Улучшить карту поля боя"
L["Enhance dungeon icons"] = "Улучшить значки подземелий"
L["Enlarge player arrow"] = "Размер указателя игрока"
L["Enter"] = "Введите"
L["Evergrove"] = "Вечная роща"
L["Everlook"] = "Круговзор"
L["Evermoon Terrace"] = "Терраса Вечной Луны"
L["Eversong Woods"] = "Леса Вечной Песни"
L["Exile's Hollow"] = "Низина Изгнанника"
L["Exodar"] = "Экзодар"
L["Eye of Azshara"] = "Око Азшары"
L["Fairbreeze Village"] = "Деревня Легкий Ветерок"
L["Falanaar"] = "Фаланаар"
L["Falcon Watch"] = "Соколиный Дозор"
L["Falconwing Square"] = "Площадь Соколиных Крылье"
L["Faldir's Cove"] = "Бухта Фальдира"
L["Feathermoon Stronghold"] = "Крепость Оперенной Луны"
L["Felsoul Hold"] = "Оплот Оскверненной Души"
L["Felwood"] = "Оскверненный лес"
L["Feralas"] = "Фералас"
L["Firebeard's Patrol"] = "Дозор Огнебородов"
L["Firelands"] = "Огненные Просторы"
L["Fishing"] = "Рыбалка"
L["Fizzcrank Airstrip"] = " Взлетная полоса Выкрутеня"
L["Flame Crest"] = "Пламенеющий Стяг"
L["Flamestar Post"] = "Лагерь Пламени Звезд"
L["Flayedwing Transporter"] = "Транспортный костекрыл"
L["Follow the eastward path"] = "Следуйте по пути на восток"
L["Follow the westward path"] = "Следуйте по пути на запад"
L["Fordragon Hold"] = "Крепость Фордрагона"
L["Forest Song"] = "Лесная Песнь"
L["Forsaken High Command"] = "Ставка Отрекшихся"
L["Forsaken Rear Guard"] = "Арьергард Отрекшихся"
L["Fort Livingston"] = "Форт Ливингстон"
L["Fort Wildervar"] = " Крепость Вилдервар"
L["Freehold"] = "Вольная Гавань"
L["Freewind Post"] = "Застава Вольного Ветра"
L["Frosthold"] = "Ледяная крепость"
L["Gadgetzan"] = "Прибамбасск"
L["Galen's Fall"] = "Удел Галена"
L["Garadar"] = "Гарадар"
L["Gate of the Setting Sun"] = "Врата Заходящего Солнца"
L["Gates of Sothann"] = "Врата Созанна"
L["Gates of Valor"] = "Врата Доблести"
L["Ghostlands"] = "Призрачные земли"
L["Gnomeregan"] = "Гномреган"
L["Gol'Bolar Quarry"] = "Карьер Гол'Болар"
L["Goldshire"] = "Златоземье"
L["Graveyard"] = "Кладбище"
L["Green"] = "Зеленый"
L["Greenwarden's Grove"] = "Роща Стража Природы"
L["Grim Batol"] = "Грим Батол"
L["Grimrail Depot"] = "Депо Мрачных Путей"
L["Grizzly Hills"] = "Седые холмы"
L["Grom'arsh Crash Site"] = "Место крушения Гром'арша"
L["Grom'gol"] = "Гром'гол"
L["Grom'gol Base Camp"] = "Гром'гол"
L["Group Icons"] = "Значки Группы"
L["Grove of Aessina"] = "Роща Эссины"
L["Gruul's Lair"] = "Логово Груула"
L["Gundrak"] = "Гундрак"
L["Gundrak (rear entrance)"] = "Гундрак (задний вход)"
L["Hall of Ancient Paths"] = "Зал Древних Путей"
L["Halls of Atonement"] = "Чертоги покаяния"
L["Halls of Infusion"] = "Чертоги Насыщения"
L["Halls of Lightning"] = "Чертоги Молний"
L["Halls of Origination"] = "Чертоги Созидания"
L["Halls of Stone"] = "Чертоги Камня"
L["Halls of Valor"] = "Чертоги Доблести"
L["Hammerfall"] = "Павший Молот"
L["Hardwrench Hideaway"] = "Укрытие Кофельнагель"
L["Head down the mountain from here."] = "Спуститесь с горы отсюда."
L["Head southeast from here and go up the mountain."] = "Направляйтесь отсюда на юго-восток и поднимитесь на гору."
L["Heart of Fear"] = "Сердце Страха"
L["Hearthglen"] = "Дольный Очаг"
L["Hellfire Citadel"] = "Цитадель Адского Пламени"
L["Hellfire Peninsula"] = "Полуостров Адского Пламени"
L["Hellfire Ramparts"] = "Бастионы Адского Пламени"
L["Hide filter reset button"] = "Скрыть кнопку сброса фильтра"
L["Hide town and city icons"] = "Скрыть значки городов"
L["Highbank"] = "Высокий берег"
L["Highmaul"] = "Земли клана Верховного Молота"
L["Hillsbrad Foothills"] = "Предгорья Хилсбрада"
L["Honor Hold"] = "Оплот Чести"
L["Horde Cities"] = "Города Орды"
L["Hour of Twilight"] = "Время Сумерек"
L["Howling Fjord"] = "Ревущий фьорд"
L["Hyjal"] = "Хиджал"
L["Hyjal Summit"] = "Вершина Хиджала"
L["Icecrown"] = "Ледяная Корона"
L["Icecrown Citadel"] = "Цитадель Ледяной Короны"
L["Icons"] = "Иконки"
L["If checked, additional icons (such as portals) will be shown."] = "Если флажок установлен, то будут показаны дополнительные значки (например, порталы)."
L["If checked, archaeology digsites will be shown."] = "Если флажок установлен, будут показаны места археологических раскопок."
L["If checked, coordinates will be shown."] = "Если установлен этот флажок, на карте будут отображаться координаты."
L["If checked, coordinates will have a dark background texture."] = "Если установлен этот флажок, координаты будут иметь фон из тёмных текстур."
L["If checked, coordinates will use a large font."] = "Если установлен этот флажок, координаты будут отображаться крупным шрифтом."
L["If checked, dungeons and raids will be shown."] = "Если установлен этот флажок, на карте будут отображаться входы в подземелья и рейдовые подземелья."
L["If checked, group icons will use a modern, class-colored design."] = "Если установлен этот флажок, то значки места нахождения участников вашей группы на карте - будут отображаться цветом класса этих персонажей."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "Если установлен этот флажок, то при открытии карты будет использоваться тот же уровень масштабирования, что и при последнем закрытии карты, если зона карты не изменилась."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "Если установлен этот флажок, то при наведении курсора мыши на карту во время движения вашего персонажа отменит установленный уровень прозрачности. Карта станет непрозрачной."
L["If checked, points of interest will be shown."] = "Если установлен этот флажок, на карте будут отображаться различные полезные достопримечательности."
L["If checked, quest objectives will be shown."] = "Если флажок установлен, то будут показаны цели квеста."
L["If checked, spirit healers will be shown."] = "Если флажок установлен, то будут отображаться духовные целители."
L["If checked, the battlefield map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Если флажок установлен, карта поля боя будет оставаться отцентрированной по вашему местоположению, пока вы не находитесь в подземелье.|n|nВы можете удерживать shift при панорамировании карты, чтобы временно предотвратить ее центрирование."
L["If checked, the default fullscreen map will be used for the maximised map.|n|nNote that enabling this option will lock out some of the other options."] = "Если флажок установлен, для развернутой карты будет использоваться полноэкранная карта по умолчанию.|n|nОбратите внимание, что включение этой опции заблокирует некоторые другие опции."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "Если установлен этот флажок, всегда будет использоваться по умолчанию карта открываемая на весь экран.|n|nПримечание: Включение данной настройки заблокирует некоторые другие."
L["If checked, the map border will be removed."] = "Если установлен этот флажок, граница окна карты будет удалена."
L["If checked, the map frame will remain open until you close it."] = "Если установлен этот флажок, окно карты будет всегда оставаться открытым до тех пор, пока вы сами не закроете его."
L["If checked, the map will not fade while your character is moving."] = "Если установлен этот флажок, то карта не затемняется, пока ваш персонаж находится в движении."
L["If checked, the map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Если флажок установлен, карта будет оставаться отцентрированной по вашему местоположению, пока вы не находитесь в подземелье.|n|nВы можете удерживать shift при панорамировании карты, чтобы временно предотвратить ее центрирование."
L["If checked, the minimap button will be shown."] = "Если установлен этот флажок, у мини-карты будет отображаться кнопка аддона."
L["If checked, the minimum fishing skill levels will be shown."] = "Если установлен этот флажок, будут показаны минимальные уровни навыка рыбной ловли."
L["If checked, the world map filter reset button will be hidden."] = "Если этот флажок установлен, кнопка сброса фильтра карты мира будет скрыта."
L["If checked, town and city icons will not be shown on the continent maps."] = "Если установлен этот флажок, на картах континентов не будут отображаться значки городов и поселков."
L["If checked, travel points for the opposing faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Если установлен этот флажок, то будут отображаться все путевые точки для персонажей противоположной фракции.|n|nСюда входят точки полета, лодочные гавани, башни дирижаблей и трамвайные остановки."
L["If checked, travel points for the same faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Если установлен этот флажок, то будут отображаться все путевые точки для персонажей вашей фракции.|n|nСюда входят точки полета, лодочные гавани, башни дирижаблей и трамвайные остановки."
L["If checked, unexplored areas of the map will be shown on the world map and the battlefield map."] = "Если установлен этот флажок, то неисследованные области на карте мира и на карте поля - будут открыты (будут отображаться без дымки)."
L["If checked, unexplored areas will be tinted."] = "Если установлен этот флажок, неисследованные области будут отображаться на карте, но будут отдельно затемнены."
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "Если установлен этот флажок, то когда ваш персонаж будет переходить из одной зоны в другую, карта будет автоматически меняться, чтобы показывать всегда актуальную местность нахождения вашего персонажа."
L["If checked, you can move the battlefield map by dragging any of its borders."] = "Если флажок установлен, то можно перемещать карту поля боя, перетаскивая любую из ее границ."
L["If checked, you can move the battlefield map by dragging any of its borders.|n|nYou can resize the battlefield map by dragging the bottom-right corner."] = "Если установлен этот флажок, вы можете перемещать карту поля боя путём перетаскивания за любую её кромку.|n|nВ том числе вы можете изменить размер карты поля боя потянув за её правый нижний угол."
L["If checked, you will be able to customise the battlefield map."] = "Если установлен этот флажок, вы сможете настраивать карту поля боя"
L["If checked, you will be able to enlarge the player arrow."] = "Если установлен этот флажок, вы сможете установить размер указателя (стрелки), которым обозначается расположение вашего персонажа на карте."
L["If checked, you will be able to move the frame by dragging the border."] = "Если установлен этот флажок, вы сможете перемещать фрейм, перетаскивая границу."
L["If checked, you will be able to move the map.|n|nThe map position will be saved separately for the maximised and windowed maps."] = "Если флажок установлен, вы сможете перемещать карту.|n|nПоложение карты будет сохранено отдельно для развернутой карты и карты в окне."
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges."] = "Если установлен этот флажок, у вас появится возможность изменять размер карты и её место расположения|n|nМасштабируйте карту, перетаскивая маркер масштаба в правом нижнем углу.|n|nПеремещайте карту, перетаскивая границу и края окна."
L["If checked, you will be able to scale the map by dragging the scale handle in the bottom-right corner.|n|nYou will be able to move the map by dragging any border.|n|nYou can always drag the top border to move the map regardless of this setting."] = "Если флажок установлен, вы сможете масштабировать карту, перетаскивая ручку масштаба в правом нижнем углу.|n|nВы сможете перемещать карту, перетаскивая любую границу.|n|nВы всегда можете перетащить верхнюю границу для перемещения карты независимо от этого параметра."
L["If checked, you will be able to scale the map."] = "Если флажок установлен, вы сможете масштабировать карту."
L["If checked, you will be able to set the opacity of the map."] = "Если установлен этот флажок, у вас появится возможность изменять прозрачность карты."
L["If checked, you will be able to zoom further into the world map."] = "Если установлен этот флажок, вы сможете сильнее масштабировать карту мира."
L["If checked, your character will not perform the reading emote when you open the map."] = "Если установлен этот флажок, ваш персонаж не будет выполнять эмоцию чтения, когда вы открываете карту."
L["If checked, zone and continent dropdown menus will be shown in the map frame."] = "Если отмечено, выпадающие меню для зоны и континента будут показаны в рамке карты."
L["If checked, zone and dungeon levels will be shown."] = "Если флажок установлен, будут показаны уровни зон и подземелий."
L["If checked, zone crossings will be shown.|n|nThese are clickable arrows that indicate the zone exit pathways."] = "Если флажок установлен, будут показаны пересечения зон.|n|nЭто стрелки, по которым можно выполнить щелчок мышью, указывают пути выхода из зоны."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "Если установлен этот флажок, на карте будут отображаться зоны, подземелья и минимальный необходимый уровень рыбной ловли."
L["Increase zoom level"] = "Уровень масштабирования"
L["Invalid command.  Enter /ltm help for help."] = "Неверная команда. Введите /ltm help для помощи."
L["Invalid map ID."] = "Неверный ID карты"
L["Iron Docks"] = "Железные доки"
L["Iron Summit"] = "Железная вершина"
L["Ironforge"] = "Стальгорн"
L["Isle of Quel'Danas"] = "Остров Кель'Данас"
L["Just follow the path west"] = "Следуйте по пути на запад"
L["K3"] = "K-3"
L["Kamagua"] = "Камагуа"
L["Karazhan"] = "Каражан"
L["Kargath"] = "Каргат"
L["Kharanos"] = "Каранос"
L["Kings' Rest"] = "Гробница королей"
L["Kirthaven"] = "Кирт"
L["Kor'kron Vanguard"] = "Авангард кор'крона"
L["Lake Elune'ara"] = "Озеро Элуне'ара"
L["Lake Everstill"] = "Озеро Безмолвия"
L["Lakeshire"] = "Приозерье"
L["Large Scarab Coffer"] = "Большой сундук Скарабея"
L["Leads to Tirisfal Glades"] = "Ведёт в Тирисфальские леса"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS: УСТАНОВЛЕНА НЕПРАВИЛЬНАЯ ВЕРСИЯ!"
L["Library"] = "Библиотека"
L["Light's Breach"] = "Разлом Света"
L["Light's Hope Chapel"] = "Часовня Последней Надежды"
L["Light's Shield Tower"] = "Башня Защиты Света"
L["Lion's Watch"] = "Львиный дозор"
L["Loch Modan"] = "Лок Модан"
L["Lor'danel"] = "Лор'данел"
L["Lost City of the Tol'vir"] = "Затерянный город Тол'вир"
L["Lower Blackrock Spire"] = "Нижняя часть пика Черной горы"
L["Lunastre Estate"] = "Поместья Лунархов"
L["Magisters' Terrace"] = "Терраса Магистров"
L["Magtheridon's Lair"] = "Логово Магтеридона"
L["Mana-Tombs"] = "Гробницы Маны"
L["Map frame scale"] = "Масштабирование карты"
L["Map Opacity"] = "Прозрачность карты"
L["Map Scale"] = "Масштаб карты"
L["Map Size"] = "Размер карты"
L["Maraudon"] = "Мародон"
L["Maraudon: Earth Song Falls"] = "Мародон (Поющие водопады)"
L["Maraudon: Foulspore Cavern"] = "Мародон (Зловонная пещера)"
L["Maraudon: The Wicked Grotto"] = "Мародон (Оскверненный грот)"
L["Marshal's Refuge"] = "Укрытие Маршалла"
L["Marshal's Stand"] = "Застава Маршалла"
L["Marshtide Watch"] = "Застава Болотной Воды"
L["Maw of Souls"] = "Утесы Адской Пасти"
L["Max Zoom"] = "Приближение"
L["Maximised"] = "Развернутый "
L["Maximum"] = "Максимум"
L["Mechanics"] = "Механика"
L["Memory Usage"] = "Использование памяти"
L["Menethil Harbor"] = "Гавань Менетилов"
L["Miscellaneous"] = "Прочее"
L["Mists of Tirna Scithe"] = "Туманы Тирна Скитта"
L["Moa'ki"] = "Моа'ки"
L["Moa'ki Harbor"] = "Гавань Моа'ки"
L["Mogu'shan Palace"] = "Дворец Могу'шан"
L["Mogu'shan Vaults"] = "Подземелья Могу'шан"
L["Mok'Nathal Village"] = "Деревня Мок'Натал"
L["Molten Core"] = "Огненные Недра"
L["Moon Guard Stronghold"] = "Лунных стражей"
L["Moonglade"] = "Лунная поляна"
L["More"] = "Больше"
L["Morgan's Vigil"] = "Дозор Морганы"
L["Mossy Pile"] = "Мшистая горка"
L["Mount Crafting"] = "Создание транспорта"
L["Mount Hyjal"] = "Гора Хиджал"
L["Mountain Pass (Horde Only)"] = "Горный перевал (только для Орды)"
L["Moving"] = "В движении"
L["Mudsprocket"] = "Шестермуть"
L["Mulgore"] = "Мулгор"
L["Nagrand"] = "Награнд"
L["Naxxramas"] = "Наксрамас"
L["Nazjatar"] = "Назжатар"
L["Neltharion's Lair"] = "Логово Нелтариона"
L["Neltharus"] = "Нелтарий"
L["Nesingwary Base Camp"] = "Лагерь Эрнестуэя"
L["Nethergarde Keep"] = "Крепость Стражей Пустоты"
L["Netherstorm"] = "Пустоверть"
L["Never"] = "Никогда"
L["New Agamand"] = "Новый Агамонд"
L["Nighthaven"] = "Ночная Гавань"
L["Nijel's Point"] = "Высота Найджела"
L["Nordrassil"] = "Нордрассил"
L["North"] = "Север"
L["North Gate Pass"] = "Северные врата"
L["Northpass Tower"] = "Башня Северного Перевала"
L["Ny'alotha, The Waking City"] = "Ни'алота, Пробуждающийся Город"
L["Ohn'ahran Plains"] = "Равнины Он'ары"
L["Old Hillsbrad"] = "Старый Хилсбрад"
L["Old Hillsbrad Foothills"] = "Старые предгорья Хилсбрада"
L["Onyxia's Lair"] = "Логово Ониксии"
L["Opacity"] = "Затемнение"
L["Operation: Mechagon"] = "Операция Мехагон"
L["or click the minimap button to open Leatrix Maps."] = "или нажмите на кнопку у миникарты для открытия окна Leatrix Maps."
L["Orb of Translocation"] = "Шар транслокации"
L["Orebor Harborage"] = "Прибежище Оребор"
L["Orgrimmar"] = "Оргриммар"
L["Oribos"] = "Орибос"
L["Pet Crafting"] = "Создание питомца"
L["Plaguefall"] = "Чумные каскады"
L["Plaguewood Tower"] = "Башня Чумного леса"
L["Player"] = "Персонаж"
L["Player Arrow"] = "Указатель"
L["Portal"] = "Портал"
L["Portal from Zephyr"] = "Портал от Зефир"
L["Portals"] = "Порталы"
L["Preview"] = "Превью"
L["Protoform Repository"] = "Репозиторий прототипов"
L["Ragefire Chasm"] = "Огненная Пропасть"
L["Raid"] = "Рейд"
L["Ramkahen"] = "Рамкахен"
L["Ratchet"] = "Кабестан"
L["Ravenholdt Manor"] = "поместье Черного Ворона"
L["Razorfen Downs"] = "Курганы Иглошкурых"
L["Razorfen Kraul"] = "Лабиринты Иглошкурых"
L["Razorthorn Trail"] = "Дорога Острого Шипа"
L["Rebel Camp"] = "Лагерь повстанцев"
L["Red"] = "Красный"
L["Redridge Mountains"] = "Красногорье"
L["Refuge Pointe"] = "Опорный пункт"
L["Reload"] = "Перезагрузка"
L["Remember zoom level"] = "Запоминать масштаб"
L["Remove map border"] = "Убрать границы карты"
L["req"] = "Требует"
L["Requires Key to Searing Gorge"] = "Требуется ключ к Тлеющему ущелью"
L["Requires UI reload."] = "Требуется перезагрузка UI"
L["Reset"] = "Сброс настроек"
L["Reset Map Layout"] = "Сброс настроек"
L["Return to Karazhan"] = "Возвращение в Каражан"
L["Revantusk Village"] = "Деревня Сломанного Клыка"
L["River's Heart"] = "Слияние рек"
L["Ruby Life Pools"] = "Рубиновые Омуты Жизни"
L["Ruins of Ahn'Qiraj"] = "Руины Ан'Киража"
L["Ruins of Elune'eth"] = "Руины Элун'ета"
L["Ruins of Southshore"] = "Руины Южнобережья"
L["Rut'Theran Village"] = "Деревня Рут'теран"
L["Rut'theran Village"] = "Деревня Рут'теран"
L["Sanctuary"] = "Святилище"
L["Sanctuary of Malorne"] = "Святилище Малорна"
L["Sanctum of Domination"] = "Святилище Господства"
L["Sanctum of Order"] = "Святилища Порядка"
L["Sanctum of the Sages"] = "Святилище жрецов"
L["Sanctum of the Stars"] = "Святилище звезд"
L["Sanguine Depths"] = "Кровавые катакомбы"
L["Scale"] = "Масштаб"
L["Scale the map"] = "Масштабировать карту"
L["Scarlet Halls"] = "Залы Алого ордена"
L["Scarlet Monastery"] = "Монастырь Алого ордена"
L["Schnottz's Landing"] = "Лагерь Шнотца"
L["Scholomance"] = "Некроситет"
L["Searing Gorge"] = "Тлеющее ущелье"
L["Seat of the Naaru"] = "Трон Наару"
L["Seat of the Triumvirate"] = "Престол Триумвирата"
L["Sentinel Hill"] = "Сторожевой холм"
L["Sepulcher of the First Ones"] = "Гробница Предвечных"
L["Serpentshrine Cavern"] = "Змеиное святилище"
L["Set map opacity"] = "Прозрачность карты"
L["Set map opacity while stationary and while moving."] = "Настройка прозрачности карты для двух различных состояний:|nкогда вы стоите и когда вы движетесь."
L["Set the group icon size."] = "Установите размер значка, которым следует отображать|nучастник вашей группы на карте."
L["Set the maximum zoom scale."] = "Установите максимально допустимый уровень приближения карты"
L["Set the player arrow size."] = "Установите желаемый размер указателя (стрелки), которым|nобозначается расположение вашего персонажа на карте."
L["Sethekk Halls"] = "Сетеккские залы"
L["Settings"] = "Настройки"
L["Sewers"] = "Канализация"
L["Shado-Pan Monastery"] = "Монастырь Шадо-Пан"
L["Shadow Labyrinth"] = "Темный лабиринт"
L["Shadowfang Keep"] = "Крепость Темного Клыка"
L["Shadowlands"] = "Shadowlands"
L["Shadowmoon Burial Grounds"] = "Некрополь Призрачной Луны"
L["Shadowmoon Valley"] = "Долина Призрачной Луны"
L["Shadowmoon Village"] = "Деревня Призрачной Луны"
L["Shadowprey Village"] = "Деревня Ночных Охотников"
L["Shal'Aran"] = "Шал'Аран"
L["Shalewind Canyon"] = "Каньон Глинистого Ветра"
L["Shatter Point"] = "Парящая застава"
L["Shattrath"] = "Шаттрат"
L["Shattrath City"] = "Шаттрат"
L["Sholazar Basin"] = "Низина Шолазар"
L["Show background"] = "Отображать фон"
L["Show boats, zeppelins and trams"] = "Отмечать на карте порты, башни дирижаблей и подземный поезд"
L["Show coordinates"] = "Показать координаты"
L["Show dungeons and raids"] = "Отмечать на карте входы в подземелья и рейдовые подземелья"
L["Show minimap button"] = "Кнопка у миникарты"
L["Show minimum fishing skill levels"] = "Показать минимальный уровень рыбной ловли"
L["Show objectives"] = "Показать задачи"
L["Show points of interest"] = "Показать достопримечательности"
L["Show scale handle"] = "Показать шкалу масштабирования"
L["Show spirit healers"] = "Показывать духовных целителей"
L["Show travel points for opposing faction"] = "Путевые точки противоположной фракции"
L["Show travel points for same faction"] = "Путевые точки вашей фракции"
L["Show unexplored areas"] = "Показать неисследованные области"
L["Show zone crossings"] = "Показывать переходы зон"
L["Show zone levels"] = "Показать уровни локаций"
L["Show zone menus"] = "Показать меню зоны"
L["Shrine of Aviana"] = "Святилище Авианы"
L["Shrine of the Storm"] = "Святилище Штормов"
L["Siege of Boralus"] = "Осада Боралуса"
L["Siege of Niuzao Temple"] = "Осада храма Нюцзао"
L["Siege of Orgrimmar"] = "Осада Оргриммара"
L["Silithus"] = "Силитус"
L["Silvermoon"] = "Луносвет"
L["Silvermoon City"] = "Луносвет"
L["Silverpine Forest"] = "Серебряный бор"
L["Skyreach"] = "Небесный Путь"
L["Slabchisel's Survey"] = "Привал Крепкой Стамески"
L["Slave Pens"] = "Узилище"
L["Smuggler's Scar"] = "Пещера контрабандистов"
L["South"] = "Юг"
L["South Gate Pass"] = "Южные врата"
L["Southfury River"] = "Река Строптивая"
L["Southpoint Gate"] = "Южные врата"
L["Southshore"] = "Южнобережье"
L["Spinebreaker Ridge"] = "Гребень Хребтолома"
L["Spires of Ascension"] = "Шпили Перерождения"
L["Spirit Healer"] = "Духовный целитель"
L["Splintertree Post"] = "Застава Расщепленного Дерева"
L["Stars' Rest"] = "Покой Звезд"
L["Stationary"] = "В покое"
L["Steamvault"] = "Паровое подземелье"
L["Sticky map frame"] = "Закрепить окно карты"
L["Stonard"] = "Каменор"
L["Stonebreaker Hold"] = "Форт Камнеломов"
L["Stonetalon Mountains"] = "Когтистые горы"
L["Stonetalon Peak"] = "Пик Каменного Когтя"
L["Stormfeather Outpost"] = "Лагерь Грозового Крыла"
L["Stormstout Brewery"] = "Хмелеварня Буйных Портеров"
L["Stormwind"] = "Штормград"
L["Stormwind City"] = "Штормград"
L["Strahnbrad"] = "Странбрад"
L["Stranglethorn Vale"] = "Тернистая долина"
L["Stratholme (Main Gate)"] = "Стратхольм (главные врата)"
L["Stratholme (Service Gate)"] = "Стратхольм (боковые врата)"
L["Stratholme: Crusader's Square"] = "Стратхольм: Площадь рыцарей"
L["Stratholme: The Gauntlet"] = "Стратхольм: Улица Испытаний"
L["sum"] = "вызывать"
L["Sun Rock Retreat"] = "Приют у Солнечного Камня"
L["Sunreaver's Command"] = "Лагерь Похитителя Солнца"
L["Sun's Reach Harbor"] = "Гавань Солнечного Края"
L["Sunveil Excursion"] = "Экспедиция Солнечного Паруса"
L["Sunwell Plateau"] = "Плато Солнечного Колодца"
L["Surwich"] = "Сурвич"
L["Swamp of Sorrows"] = "Болото Печали"
L["Swamprat Post"] = "Застава Болотной Крысы"
L["Sylvanaar"] = "Сильванаар"
L["Synthesis Forge"] = "Кузница Синтеза"
L["System"] = "Системное"
L["Talonbranch Glade"] = "Поляна Когтистых Ветвей"
L["Talrendis Point"] = "Застава Талрендис"
L["Tanaris"] = "Танарис"
L["Tarren Mill"] = "Мельница Таррен"
L["Taunka'le Village"] = "Деревня Таунка'ле"
L["Taxi to Scholar's Den"] = "Полёт в Обитель ученых"
L["Taxi to Vault of Secrets"] = "Полёт в Хранилище тайн"
L["Tazavesh, the Veiled Market"] = "Тайный рынок Тазавеш"
L["Telaar"] = "Телаар"
L["Tel'anor"] = "Тел'анор"
L["Teldrassil"] = "Тельдрассил"
L["Teleport Crystal"] = "Кристалл телепортации"
L["Telredor"] = "Телредор"
L["Tempest Keep"] = "Крепость Бурь"
L["Temple of Ahn'Qiraj"] = "Храм Ан'Кираж"
L["Temple of Atal'Hakkar"] = "Затонувший храм"
L["Temple of Sethraliss"] = "Храм Сетралисс"
L["Temple of Telhamat"] = "Храм Телхамата"
L["Temple of the Jade Serpent"] = "Храм Зин-Малор"
L["Temple of the Moon"] = "Храм Луны"
L["Terokkar Forest"] = "Лес Тероккар"
L["Terrace of Endless Spring"] = "Терраса Вечной Весны"
L["Thalanaar"] = "Таланаар"
L["Thandol Span"] = "Мост Тандола"
L["The Arcatraz"] = "Аркатрац"
L["The Arcway"] = "Катакомбы Сурамара"
L["The Argent Stand"] = "Серебряная застава"
L["The Argent Vanguard"] = "Оплот Серебряного Авангарда"
L["The Azure Vault"] = "Лазурное хранилище"
L["The Barrens"] = "Степи"
L["The Bastion of Twilight"] = "Сумеречный бастион"
L["The Black Morass"] = "Черные топи"
L["The Blood Furnace"] = "Кузня Крови"
L["The Botanica"] = "Ботаника"
L["The Bulwark"] = "Бастион"
L["The Cape of Stranglethorn"] = "Мыс Тернистой долины"
L["The Crossroads"] = "Перекресток"
L["The Culling of Stratholme"] = "Очищение Стратхольма"
L["The Dark Portal"] = "Темный портал"
L["The Deadmines"] = "Мертвые копи"
L["The Dragon Soul"] = "Душа Дракона"
L["The Emerald Nightmare"] = "Изумрудный Кошмар"
L["The Everbloom"] = "Вечное Цветение"
L["The Exodar"] = "Экзодар"
L["The Eye"] = "Око"
L["The Eye of Eternity"] = "Око Вечности"
L["The Farstrider Lodge"] = "Приют странников"
L["The Forge of Souls"] = "Кузня Душ"
L["The Forgotten Coast"] = "Забытый берег"
L["The Forsaken Front"] = "Передовая Отрекшихся"
L["The Frozen Halls"] = "Ледяные залы"
L["The Great Forge"] = "Великая Кузня"
L["The Great Lift"] = "Великий подъемник"
L["The Halls of Reflection"] = "Залы Отражений"
L["The Harborage"] = "Убежище"
L["The Hinterlands"] = "Внутренние земли"
L["The Krazzworks"] = "Психходельня"
L["The Mechanar"] = "Механар"
L["The Menders' Stead"] = "Участок Целителей Земли"
L["The MOTHERLODE!!"] = "ЗОЛОТАЯ ЖИЛА!!!"
L["The Necrotic Wake"] = "Смертельная тризна"
L["The Nexus"] = "Нексус"
L["The Nighthold"] = "Цитадель Ночи"
L["The Nokhud Offensive"] = "Наступление клана Нокхуд"
L["The Obsidian Sanctum"] = "Обсидиановое святилище"
L["The Oculus"] = "Окулус"
L["The Old Kingdom"] = "Старое Королевство"
L["The Overlook Cliffs"] = "Отвесные скалы"
L["The Pit of Saron"] = "Яма Сарона"
L["The Ruby Sanctum"] = "Рубиновое святилище"
L["The Sepulcher"] = "Гробница"
L["The Shadow Vault"] = "Мрачный Свод"
L["The Shattered Halls"] = "Разрушенные залы"
L["The Stockade"] = "Тюрьма"
L["The Stonecore"] = "Каменные Недра"
L["The Storm Peaks"] = "Грозовая Гряда"
L["The Stormspire"] = "Штормовая вершина"
L["The Talondeep Path"] = "Туннель Когтя"
L["The Underrot"] = "Подгнилье"
L["The Vault of Lights"] = "Чертог Света"
L["The Violet Hold"] = "Аметистовая крепость"
L["The Vortex Pinnacle"] = "Вершина Смерча"
L["The Waning Crescent"] = "Лунный полумрак"
L["The Zoram Strand"] = "Зорамское взморье"
L["Theater of Pain"] = "Театр Боли"
L["Thelsamar"] = "Телcамар"
L["Theramore Isle"] = "Остров Терамор"
L["Thondroril River"] = "Река Тондрорил"
L["Thorium Point"] = "Лагерь Братства Тория"
L["Thousand Needles"] = "Тысяча Игл"
L["Thrallmar"] = "Траллмар"
L["Throne of the Four Winds"] = "Трон Четырех Ветров"
L["Throne of the Tides"] = "Трон Приливов"
L["Throne of Thunder"] = "Престол Гроз"
L["Thunder Bluff"] = "Громовой Утес"
L["Thunderlord Stronghold"] = "Оплот громоборцев"
L["Thundermar"] = "Громтар"
L["Timbermaw Hold"] = "Крепость Древобрюхов"
L["Tinker Town"] = "Город механиков"
L["Tint unexplored areas"] = "Цвет неразведанных участков"
L["Tiragarde Sound"] = "Тирагардское поморье"
L["Tirisfal Glades"] = "Тирисфальские леса"
L["Titan Translocator"] = "Транслокатор титанов"
L["Toggle panel"] = "Переключить панель"
L["Tol Barad"] = "Тол Барад"
L["Tomb of Sargeras"] = "Гробница Саргераса"
L["Toshley's Station"] = "Станция Тошли"
L["Trade District"] = "Торговый квартал"
L["Trade Quarter"] = "Торговый квартал"
L["Tram to"] = "Поезд в"
L["Tranquillien"] = "Транквиллион"
L["Transitus Shield"] = "Маскировочный щит"
L["Transparency"] = "Прозрачность"
L["Trial of the Champion"] = "Испытание чемпиона"
L["Trial of the Crusader"] = "Испытание крестоносца"
L["Trial of Valor"] = "Испытание доблести"
L["Twilight Highlands"] = "Сумеречное нагорье"
L["Twilight Shore"] = "Сумеречная Излучина"
L["Twilight Vale"] = "Сумеречная долина"
L["Twilight Vineyards"] = "Сумеречные виноградники"
L["Uldaman"] = "Ульдаман"
L["Uldaman (rear entrance)"] = "Ульдаман (задний вход)"
L["Uldaman (side entrance)"] = "Ульдаман (боковой вход)"
L["Uldaman: Legacy of Tyr"] = "Ульдаман: наследие Тира"
L["Uldir"] = "Ульдир"
L["Ulduar"] = "Ульдуар"
L["Uldum"] = "Ульдум"
L["Underbog"] = "Нижетопь"
L["Undercity"] = "Подгород"
L["Un'Goro Crater"] = "Кратер Ун'Горо"
L["Unlock battlefield map"] = "Разблокировать карту поля боя"
L["Unlock map frame"] = "Открепить окно карты"
L["Unu'pe"] = "Уну'пе"
L["Upper Blackrock Spire"] = "Верхняя часть пика Черной горы"
L["Use default map"] = "Карта на весь экран"
L["Use large font"] = "Использовать большой шрифт"
L["Use stationary opacity while pointing at map"] = "Карта всегда непрозрачна если над ней курсор"
L["Utgarde Keep"] = "Крепость Утгард"
L["Utgarde Pinnacle"] = "Вершина Утгард"
L["Valaar's Berth"] = "Причал Валаара"
L["Valdrakken Portals"] = "Порталы Вальдраккена"
L["Valgarde"] = "Валгард"
L["Valgarde Port"] = "Валгардский порт"
L["Valiance Keep"] = "Крепость Отваг"
L["Valiance Landing Camp"] = "Лагерь Отваги"
L["Valley of Strength"] = "Аллея Силы"
L["Valormok"] = "Храбростан"
L["Vashj'ir"] = "Вайш'ир"
L["Vault of Archavon"] = "Склеп Аркавона"
L["Vault of the Incarnates"] = "Хранилище Воплощений"
L["Vault of the Wardens"] = "Казематы Стражей"
L["Vengeance Landing"] = "Лагерь Возмездия"
L["Venomspite"] = "Ядозлобь"
L["Vermillion Redoubt"] = "Гранатовый Редут"
L["Version"] = "Версия"
L["Victor's Point"] = "Лагерь Победителя"
L["Vol'mar"] = "Вол'мар"
L["Wailing Caverns"] = "Пещеры Стенаний"
L["Warsong Camp"] = "Лагерь Песни Войны"
L["Warsong Hold"] = "Крепость Песни Войны"
L["Waycrest Manor"] = "Усадьба Уэйкрестов"
L["Well of Eternity"] = "Источник Вечности"
L["Western Earthshrine"] = "Западное святилище Земли"
L["Western Plaguelands"] = "Западные Чумные земли"
L["Westfall"] = "Западный Край"
L["Westfall Brigade"] = "Дружина Западного Края"
L["Westguard Keep"] = "Крепость Западной Стражи"
L["Westreach Summit"] = "Вершина Западного Предела"
L["Wetlands"] = "Болотина"
L["Whelgar's Retreat"] = "Укрытие Вельгара"
L["Whisperwind Grove"] = "Роща Шелеста Ветра"
L["Wildhammer Stronghold"] = "Цитадель Громового Молота"
L["Wildheart Point"] = "Лагерь Дикого Сердца"
L["Windowed"] = "Оконный"
L["Windrunner's Overlook"] = "Дозор Ветрокрылой"
L["Windshear Hold"] = "Крепость Ветрорезов"
L["Wintergarde Keep"] = "Крепость Стражей Зимы"
L["Wintergrasp"] = "Озеро Ледяных Оков"
L["Winterspring"] = "Зимние Ключи"
L["World of Warcraft Classic"] = "World of Warcraft Classic"
L["Wrath of the Lich King Classic"] = "Wrath of the Lich King Classic"
L["Wyrmrest Temple"] = "Храм Драконьего Покоя"
L["You cannot do that in combat."] = "Вы не можете сделать это в бою."
L["You will die!"] = "Вы умрёте!"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Чтобы некоторые изменения вступили в силу, необходимо перезагрузить Ваш пользовательский интерфейс|n|nНе требуется нажимать кнопку перезагрузки интерфейса сразу после каждого изменения, но её потребуется нажать тогда, когда вы закончите вносить все изменения и захотите, чтобы они вступили в силу."
L["Your UI needs to be reloaded."] = "Вам необходимо перезагрузить UI."
L["Zabra'jin"] = "Забра'джин"
L["Zangarmarsh"] = "Зангартопь"
L["Zeb'Sora"] = "Зеб'Сора"
L["Zeppelin to"] = "Дирижабль в"
L["Zim'Torga"] = "Зим'Торга"
L["Zone Map"] = "Карта зоны"
L["Zoom"] = "Масштабирование"
L["Zoram'gar Outpost"] = "Застава Зорам'гар"
L["Zul'Aman"] = "Зул'Аман"
L["Zuldazar"] = "Зулдазар"
L["Zul'Drak"] = "Зул'Драк"
L["Zul'Farrak"] = "Зул'Фаррак"
L["Zul'Gurub"] = "Зул'Гуруб"

end

-- koKR: Korean
if GameLocale == "koKR" then
L["(destination only)"] = " (목적지만）"
L["(inside Caverns of Time)"] = "（시간의 동굴 내부）"
L["/ltm help - Show this information."] = "/ltm help - 정보 표시."
L["/ltm reset - Reset the panel position."] = "/ltm reset - 패널 위치 재설정."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - 모든 설정 지우고 리로드."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "정지 오류가 발생했지만 걱정할 필요가 없습니다. 때때로 발생할 수 있습니다. 문제를 해결하려면 리로드 버튼을 클릭하십시오."
L["Acherus: The Ebon Hold"] = "아케루스 : 칠흑의 요새"
L["Aerie Peak"] = "맹금의 봉우리"
L["Agmar's Hammer"] = "아그마르의 망치"
L["Ahn'Qiraj"] = "안퀴라즈"
L["Aldor"] = "알도르 마루"
L["Algeth'ar Academy"] = "알게타르 대학"
L["Allerian Stronghold"] = "알레리아 성채"
L["Alliance Cities"] = "얼라이언스 대도시"
L["Allow frame movement"] = "프레임 잠금 해제"
L["Alpha"] = "투명도"
L["Altar of Sha'tar"] = "샤타르 제단"
L["Alterac Mountains"] = "알터렉 산맥"
L["Always"] = "항상"
L["Amber Lodge"] = "호박석 절벽"
L["Amberpine Lodge"] = "호박빛소나무 오두막"
L["Antorus, the Burning Throne"] = "안토러스 - 불타는 왕좌"
L["Apothecary Camp"] = "연금술사 야영지"
L["Appearance"] = "외관"
L["Arathi Highlands"] = "아라시 고원"
L["Area 52"] = "52번 구역"
L["Argent Tournament Grounds"] = "은빛십자군 마상시합 광장"
L["Armory"] = "무기고"
L["Ashenvale"] = "잿빛 골짜기"
L["Astranaar"] = "아스트라나르"
L["Astravar Harbor"] = "아스트라바르 항구"
L["Atal'Dazar"] = "아탈다자르"
L["Auberdine"] = "아우버다인"
L["Auchenai Crypts"] = "아키나이 납골당"
L["Auchindoun"] = "아킨둔"
L["Auto change zones"] = "지역 변경 자동"
L["available during zone attack"] = "지역 공격 중 사용 가능"
L["Azeroth"] = "아제로스"
L["Azjol-Nerub"] = "아졸네룹"
L["Azshara"] = "아즈샤라"
L["Azuremyst Isle"] = "하늘안개 섬"
L["Back to Main Menu"] = "주 메뉴로 돌아가기"
L["Badlands"] = "황야의 땅"
L["Baradin Hold"] = "바라딘 요새"
L["Battle of Dazar'alor"] = "다자알로 전투"
L["Battlegrounds"] = "전장"
L["Black Morass"] = "검은늪"
L["Black Rook Hold"] = "검은 떼까마귀 요새"
L["Black Temple"] = "검은사원"
L["Blackfathom Deeps"] = "검은 심연 나락"
L["Blackrock Caverns"] = "검은바위 동굴"
L["Blackrock Depths"] = "검은바위 나락"
L["Blackrock Foundry"] = "검은바위 용광로"
L["Blackrock Mountain"] = "검은바위 산"
L["Blackrock Spire"] = "검은바위 첨탑"
L["Blackwing Descent"] = "검은날개 강림지"
L["Blackwing Lair"] = "검은날개 둥지"
L["Blade Tooth Canyon"] = "칼날이빨 대협곡"
L["Blade's Edge Mountains"] = "칼날산맥"
L["Blades' Run"] = "칼날 고개"
L["Blasted Lands"] = "저주받은 땅"
L["Blood Watch"] = "핏빛 감시초소"
L["Bloodmaul Slag Mines"] = "피망치 잿가루 광산"
L["Bloodmyst Isle"] = "핏빛안개 섬"
L["Bloodvenom Post"] = "피멍울초소"
L["Blue"] = "블루"
L["Boat to"] = "연결된 항구:"
L["Booty Bay"] = "무법항"
L["Borean Tundra"] = "북풍의 땅"
L["Bor'gorok Outpost"] = "보르고로크 전초기지"
L["Bouldercrag's Refuge"] = "볼더크랙의 은거처"
L["Brackenhide Hollow"] = "담쟁이가죽 골짜기"
L["Brackenwall Village"] = "담쟁이 마을"
L["Burning Crusade Classic"] = "불타는 성전 클래식"
L["Burning Steppes"] = "불타는 평원"
L["Camp Mojache"] = "모자케 야영지"
L["Camp Oneqwah"] = "원크와 야영지"
L["Camp Taurajo"] = "타우라조 야영지"
L["Camp Tunka'lo"] = "툰카로 야영지"
L["Camp Winterhoof"] = "겨울발굽 야영지"
L["Castle Nathria"] = "나스리아 성"
L["Cathedral"] = "예배당"
L["Cathedral of Eternal Night"] = "영원한 밤의 대성당"
L["Caverns of Time"] = "시간의 동굴"
L["Cenarion Hold"] = "세나리온 요새"
L["Center map on player"] = "지도를 플레이어 중앙에 위치시키기"
L["Central Mesa"] = "중앙 봉우리"
L["Chamber of Heart"] = "심장의 방"
L["Chillwind Camp"] = "서리바람 야영지"
L["Choose where the zone map should be shown."] = "지역 지도가 표시될 위치를 선택하세요."
L["Class colored icons"] = "직업색상 아이콘"
L["Classic"] = "클래식"
L["Click to configure the settings for this option."] = "이 옵션의 설정을 구성하려면 클릭하십시오."
L["Click to reset the position and scale of the map frame."] = "지도 프레임의 위치와 크기를 재설정하려면 클릭하십시오."
L["Click to reset the settings on this page."] = "이 페이지의 설정을 재설정하려면 클릭하십시오."
L["Click to return to the main menu."] = "클릭하면 주 메뉴로 돌아갑니다."
L["Coilfang Reservoir"] = "갈퀴송곳니 저수지"
L["Coldarra"] = "콜다라"
L["Configuration Panel"] = "설정창"
L["Conquest Hold"] = "정복의 요새"
L["Cosmic"] = "우주의"
L["Cosmowrench"] = "코스모렌치"
L["Court of Stars"] = "별의 궁정"
L["Crucible of Storms"] = "폭풍의 용광로"
L["Crusaders' Pinnacle"] = "십자군 봉우리"
L["Crystalsong Forest"] = "수정노래 숲"
L["Culling of Stratholme"] = "옛 스트라솔름"
L["Cursor"] = "커서"
L["Dalaran"] = "달라란"
L["Dalaran Crater"] = "달라란 구덩이"
L["Darkheart Thicket"] = "어둠심장 숲"
L["Darkshire"] = "어둠골"
L["Darkshore"] = "어둠해안"
L["Darnassus"] = "다르나서스"
L["De Other Side"] = "저편"
L["Deadwind Pass"] = "죽음의 고개"
L["Death's Rise"] = "죽음의 마루"
L["Debug"] = "디버그"
L["Deepholm"] = "심원의 영지"
L["Desolace"] = "잊혀진 땅"
L["Dire Maul (East)"] = "혈투의 전장(1동쪽)"
L["Dire Maul (East) (side entrance)"] = "혈투의 전장(동쪽-후문)"
L["Dire Maul (East): Warpwood Quarter"] = "혈투의 전장(1동쪽) : 굽이나무 지구"
L["Dire Maul (North)"] = "혈투의 전장(2북쪽)"
L["Dire Maul (North): Gordok Commons"] = "혈투의 전장(2북쪽) : 고르독 광장"
L["Dire Maul (West)"] = "혈투의 전장(3서쪽)"
L["Dire Maul (West): Capital Gardens"] = "혈투의 전장(3서쪽) : 수도 정원"
L["Dire Maul: Capital Gardens"] = "혈투의 전장 : 수도정원"
L["Dire Maul: Gordok Commons"] = "혈투의 전장 : 고르독 광장"
L["Dire Maul: Warpwood Quarter"] = "혈투의 전장 : 굽이나무 지구"
L["Disable map fade"] = "맵 사라짐 사용안함"
L["Disable reading emote"] = "지도 읽기 모션 사용안함"
L["Disable reading emote when opening the map"] = "지도 볼때 감정표현(모션) 사용안함"
L["disabled"] = "비활성"
L["Drag"] = "이동"
L["Drag to set the amount of blue."] = "블루 색상을 드레그 설정 하세요."
L["Drag to set the amount of green."] = "그린 색상을 드레그 설정 하세요."
L["Drag to set the amount of red."] = "레드 색상을 드레그 설정 하세요."
L["Drag to set the battlefield map opacity."] = "전장 지도 불투명도 설정을 드래그하세요."
L["Drag to set the battlefield map size."] = "전장지도 크기를 설정하려면 드래그하세요."
L["Drag to set the battlefield map size.|n|nIf the map is unlocked, you can also resize the battlefield map by dragging the bottom-right corner."] = "전장 지도 크기 설정을 드래그하세요.|n|n지도가 잠겨 있으면 오른쪽 아래 모서리를 드래그하여 전장 지도의 크기를 조절할 수도 있습니다."
L["Drag to set the group icon size."] = "그룹 아이콘 크기를 설정하려면 드래그하십시오."
L["Drag to set the map opacity for when your character is moving."] = "캐릭터가 움직일 때의 맵 불투명도를 드레그 설정하세요."
L["Drag to set the map opacity for when your character is stationary."] = "캐릭터가 정지되어있을 때의 맵 불투명도를 설정하십시오."
L["Drag to set the maximum zoom level.|n|nOpen the battlefield map to see the maximum zoom level change as you drag the slider."] = "최대 줌 레벨 설정을 드래그하세요.|n|n슬라이더를 드래그하면 최대 줌 레벨이 어떻게 변하는지 전장 지도를 열어 확인하세요."
L["Drag to set the maximum zoom level.|n|nOpen the map to see the maximum zoom level change as you drag the slider."] = "최대 줌 레벨 설정을 드래그하세요.|n|n슬라이더를 드래그하면 최대 줌 레벨이 어떻게 변하는지 지도를 열어 확인하세요."
L["Drag to set the opacity."] = "불투명도를 드레그 설정하세요."
L["Drag to set the player arrow size."] = "플레이어 화살표 크기를 설정하려면 드래그하십시오."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "드래그하여 플레이어 화살표 크기를 설정합니다. Wow Classic 기본값:16. Wow Retail 기본값: 27."
L["Drag to set the scale for the maximised map."] = "최대화된 지도의 크기를 설정하려면 드래그하세요."
L["Drag to set the scale for the windowed map."] = "윈도우 지도의 크기를 설정하려면 드래그하세요."
L["Drag to set the world map scale.|n|nYou can also rescale the world map by dragging the bottom-right corner."] = "세계지도 비율을 설정하려면 드래그하십시오.|n|n세계지도의 크기를 조절하려면 우측 하단을 드래그하십시오."
L["Dragon Soul"] = "용의 영혼"
L["Dragonblight"] = "용의 안식처"
L["Drak'Tharon Keep"] = "드락타론 성채"
L["Druid only flight point to Darnassus"] = "드루이드 전용 비행지점"
L["Druid only flight point to Thunder Bluff"] = "드루이드 전용 비행지점"
L["Dun Algaz"] = "던 알가즈"
L["Dun Morogh"] = "던 모르"
L["Dun Nifflelem"] = "던 니펠렘"
L["Dungeon"] = "던전"
L["Dungeon (requires Crescent Key)"] = "던전 진입 (초승달 열쇠 필요)"
L["Durotar"] = "듀로타"
L["Duskwood"] = "그늘숲"
L["Dustwallow Marsh"] = "먼지진흙 습지대"
L["Dwarven District"] = "드워프 지구"
L["Eastern Earthshrine"] = "동부 대지 제단"
L["Eastern Plaguelands"] = "동부 역병지대"
L["Ebon Watch"] = "칠흑의 감시초소"
L["Elements"] = "저거"
L["Elwynn Forest"] = "엘원 숲"
L["Emerald Sanctuary"] = "에메랄드 성소"
L["enabled"] = "사용"
L["End Time"] = "시간의 끝"
L["Enhance battlefield map"] = "전장지도 설정"
L["Enhance dungeon icons"] = "던전 아이콘 설정"
L["Enlarge player arrow"] = "플레이어 화살표 크게"
L["Enter"] = "Enter"
L["Evergrove"] = "영원의 숲"
L["Everlook"] = "눈망루 마을"
L["Evermoon Terrace"] = "영원달 정원"
L["Eversong Woods"] = "영원노래 숲"
L["Exile's Hollow"] = "믿음의 보금자리"
L["Exodar"] = "엑소다르"
L["Eye of Azshara"] = "아즈샤라의 눈"
L["Falanaar"] = "팔라나아르"
L["Falcon Watch"] = "매의 감시탑"
L["Faldir's Cove"] = "팔디르의 만"
L["Feathermoon Stronghold"] = "페더문 요새"
L["Felsoul Hold"] = "지옥영혼 요새"
L["Felwood"] = "악령의 숲"
L["Feralas"] = "페랄라스"
L["Firelands"] = "불의 땅"
L["Fishing"] = "낚시"
L["Fizzcrank Airstrip"] = "피즈크랭크 비행장"
L["Flame Crest"] = "화염 마루"
L["Flayedwing Transporter"] = "가죽뜯깃 수송자"
L["Follow the eastward path"] = "동쪽 길을 따라가세요"
L["Follow the westward path"] = "서쪽 길을 따라가세요"
L["Fordragon Hold"] = "폴드라곤 요새"
L["Forest Song"] = "숲의 노래"
L["Fort Wildervar"] = "빌더바르 요새"
L["Freehold"] = "자유지대"
L["Freewind Post"] = "늪새바람 봉우리"
L["Frosthold"] = "서리요새"
L["Gadgetzan"] = "가젯잔"
L["Garadar"] = "가라다르"
L["Gate of the Setting Sun"] = "석양문"
L["Gates of Valor"] = "용맹의 관문"
L["Ghostlands"] = "유령의 땅"
L["Gnomeregan"] = "놈리건"
L["Graveyard"] = "묘지"
L["Green"] = "그린"
L["Grim Batol"] = "그림 바톨"
L["Grimrail Depot"] = "파멸철로 정비소"
L["Grizzly Hills"] = "회색 구릉지"
L["Grom'arsh Crash Site"] = "그롬아쉬 추락 지점"
L["Grom'gol Base Camp"] = "그룸골 주둔지"
L["Group Icons"] = "그룹 아이콘"
L["Gruul's Lair"] = "그룰의 둥지"
L["Gundrak"] = "군드락"
L["Gundrak (rear entrance)"] = "군드락 (후문)"
L["Hall of Ancient Paths"] = "고대 길의 전당"
L["Halls of Atonement"] = "속죄의 전당"
L["Halls of Infusion"] = "주입의 전당"
L["Halls of Lightning"] = "번개의 전당"
L["Halls of Origination"] = "시초의 전당"
L["Halls of Stone"] = "돌의 전당"
L["Halls of Valor"] = "용맹의 전당"
L["Hammerfall"] = "해머폴"
L["Head down the mountain from here."] = "산 아래 방향으로 이동"
L["Head southeast from here and go up the mountain."] = "남동쪽 산을 통해 이동"
L["Heart of Fear"] = "공포의 심장"
L["Hellfire Citadel"] = "지옥불 성채"
L["Hellfire Peninsula"] = "지옥불 반도"
L["Hellfire Ramparts"] = "지옥불 성루"
L["Hide town and city icons"] = "도시와 타운 아이콘 숨김"
L["Highmaul"] = "높은 망치"
L["Hillsbrad Foothills"] = "힐스브래드 구릉지"
L["Honor Hold"] = "명예의 요새"
L["Horde Cities"] = "호드 대도시"
L["Hour of Twilight"] = "황혼의 시간"
L["Howling Fjord"] = "울부짖는 협만"
L["Hyjal"] = "하이잘"
L["Hyjal Summit"] = "하이잘 정상"
L["Icecrown"] = "얼음왕관"
L["Icecrown Citadel"] = "얼음왕관 성채"
L["Icons"] = "아이콘"
L["If checked, additional icons (such as portals) will be shown."] = "확인되면 추가 아이콘(포탈 등)이 표시됩니다."
L["If checked, coordinates will be shown."] = "좌표가 표시됩니다."
L["If checked, coordinates will have a dark background texture."] = "좌표 배경 어둡게 합니다."
L["If checked, coordinates will use a large font."] = "좌표 큰 폰트 사용합니다."
L["If checked, dungeons and raids will be shown."] = "던전과 공격대가 표시됩니다."
L["If checked, group icons will use a modern, class-colored design."] = "그룹 아이콘은 현대적인 직업색상 디자인을 사용합니다."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "지도를 열면 지도영역이 변경되지 않은 한 마지막으로 닫을 때와 동일한 확대 / 축소 수준이 사용됩니다."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "캐릭터가 움직이는 동안 지도를 가리키면 불투명 적용되지 않습니다."
L["If checked, points of interest will be shown."] = "주요지점이 표시됩니다."
L["If checked, quest objectives will be shown."] = "체크하면 퀘스트 목표가 표시됩니다."
L["If checked, spirit healers will be shown."] = "확인되면 영혼 치유사가 표시됩니다."
L["If checked, the battlefield map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "확인되면 던전에 있지 않은 한 전장 지도가 항상 당신의 위치를 중심으로 유지됩니다.|n|n지도를 이동하는 동안 Shift 키를 눌러 중앙에 유지되지 않게 할 수 있습니다."
L["If checked, the default fullscreen map will be used for the maximised map.|n|nNote that enabling this option will lock out some of the other options."] = "확인되면 최대화된 지도에 기본 전체 화면 지도가 사용됩니다.|n|n이 옵션을 활성화하면 다른 일부 옵션이 잠기게 됩니다."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "전체 화면 맵이 기본 사용됩니다. |n|n이 옵션을 활성화하면 다른 옵션 중 일부가 잠깁니다."
L["If checked, the map border will be removed."] = "지도 테두리가 제거됩니다."
L["If checked, the map frame will remain open until you close it."] = "맵 프레임은 닫을 때까지 열린 상태로 유지됩니다."
L["If checked, the map will not fade while your character is moving."] = "지도를 열고 캐릭터가 움직일때 지도 사라짐이 없습니다."
L["If checked, the map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "확인되면 던전에 있지 않은 한 지도가 항상 당신의 위치를 중심으로 유지됩니다.|n|n지도를 이동하는 동안 Shift 키를 눌러 중앙에 유지되지 않게 할 수 있습니다."
L["If checked, the minimap button will be shown."] = "미니 맵 버튼이 표시됩니다."
L["If checked, the minimum fishing skill levels will be shown."] = "최소 낚시 숙련도가 표시됩니다."
L["If checked, town and city icons will not be shown on the continent maps."] = "도시와 타운 아이콘은 대륙지도에 표시되지 않습니다."
L["If checked, travel points for the opposing faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "확인되면 상대 진영의 이동 지점이 표시됩니다.|n|n비행 지점, 보트 항구, 지펠린 탑, 트램 정류장이 포함됩니다."
L["If checked, travel points for the same faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "확인되면 동일한 진영의 이동 지점이 표시됩니다.|n|n비행 지점, 보트 항구, 지펠린 탑, 트램 정류장이 포함됩니다."
L["If checked, unexplored areas of the map will be shown on the world map and the battlefield map."] = "확인되면 지도의 미탐사 영역이 세계 지도와 전장 지도에 표시됩니다."
L["If checked, unexplored areas will be tinted."] = "미탐험 지역의 색상을 설정합니다."
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "캐릭터의 지역이 변경되면, 지도가 새 지역으로 자동 변경됩니다."
L["If checked, you can move the battlefield map by dragging any of its borders."] = "확인되면 전장 지도를 어떤 테두리든 드래그하여 이동할 수 있습니다."
L["If checked, you can move the battlefield map by dragging any of its borders.|n|nYou can resize the battlefield map by dragging the bottom-right corner."] = "확인되면 전장 지도를 어떤 테두리든 드래그하여 이동할 수 있습니다.|n|n오른쪽 아래 모서리를 드래그하여 전장 지도의 크기를 조절할 수도 있습니다."
L["If checked, you will be able to customise the battlefield map."] = "전장지도를 사용자 설정 할 수 있습니다."
L["If checked, you will be able to enlarge the player arrow."] = "플레이어 화살표를 확대 할 수 있습니다."
L["If checked, you will be able to move the frame by dragging the border."] = "테두리를 드래그하여 프레임을 이동할 수 있습니다."
L["If checked, you will be able to move the map.|n|nThe map position will be saved separately for the maximised and windowed maps."] = "확인되면 지도를 이동할 수 있습니다.|n|n지도 위치는 최대화된 지도와 윈도우 지도를 따로 저장합니다."
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges."] = "지도의 크기를 조정하고 이동할 수 있습니다. 오른쪽 하단 모서리에있는 배율 조정 핸들을 드래그하여 지도의 크기을 조정합니다. 테두리와 프레임 가장자리를 드래그하여 지도를 이동합니다."
L["If checked, you will be able to scale the map by dragging the scale handle in the bottom-right corner.|n|nYou will be able to move the map by dragging any border.|n|nYou can always drag the top border to move the map regardless of this setting."] = "체크하면 오른쪽 하단 모서리에 있는 크기 조절 핸들을 끌어서 지도 크기를 조절할 수 있습니다. |n|n모든 테두리를 드래그하여 지도를 이동할 수 있습니다. |n|n이 설정에 관계없이 지도를 이동하려면 항상 상단 테두리를 드래그할 수 있습니다."
L["If checked, you will be able to scale the map."] = "확인되면 지도 크기를 조절할 수 있습니다."
L["If checked, you will be able to set the opacity of the map."] = "지도의 불투명도를 설정할 수 있습니다."
L["If checked, you will be able to zoom further into the world map."] = "확인되면 세계 지도로 더 멀리 확대할 수 있습니다."
L["If checked, your character will not perform the reading emote when you open the map."] = "캐릭터가 지도를 볼때, 펼쳐 보는 감정 표현을 수행하지 않습니다."
L["If checked, zone and continent dropdown menus will be shown in the map frame."] = "확인되면, 지역 및 대륙 드롭다운 메뉴가 지도 프레임에 표시됩니다."
L["If checked, zone crossings will be shown.|n|nThese are clickable arrows that indicate the zone exit pathways."] = "확인되면 지역 이탈 지점이 표시됩니다.|n|n이것들은 지역 이탈 경로를 나타내는 클릭 가능한 화살표입니다."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "지역, 던전 및 낚시 레벨이 표시됩니다."
L["Increase zoom level"] = "줌 레벨 증가"
L["Invalid command.  Enter /ltm help for help."] = "잘못된 명령입니다.도움말을 확인하세요. /ltm help"
L["Invalid map ID."] = "잘못된 지도 ID입니다."
L["Iron Docks"] = "강철 선착장"
L["Ironforge"] = "아이언포지"
L["Isle of Quel'Danas"] = "쿠엘다나스 섬"
L["Just follow the path west"] = "서쪽 길을 따라가세요"
L["K3"] = "K3"
L["Kamagua"] = "카마구아"
L["Karazhan"] = "카라잔"
L["Kargath"] = "카르가스"
L["Kings' Rest"] = "왕들의 안식처"
L["Kor'kron Vanguard"] = "코르크론 선봉대"
L["Lake Elune'ara"] = "엘룬아라 호수"
L["Lake Everstill"] = "영원의 호수"
L["Large Scarab Coffer"] = "큰 스카라베 상자"
L["Leads to Tirisfal Glades"] = "티리스팔 숲 방향"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS : 잘못된 버전이 설치되었습니다!"
L["Library"] = "도서관"
L["Light's Breach"] = "빛의 틈"
L["Light's Hope Chapel"] = "희망의 빛 예배당"
L["Lion's Watch"] = "사자의 감시터"
L["Loch Modan"] = "모단 호수"
L["Lost City of the Tol'vir"] = "토비르의 잃어버린 도시"
L["Lower Blackrock Spire"] = "검은바위 첨탑 하층"
L["Lunastre Estate"] = "루나스트르 장원"
L["Magisters' Terrace"] = "마법학자의 정원"
L["Magtheridon's Lair"] = "마그테리돈의 둥지"
L["Mana-Tombs"] = "마나 무덤"
L["Map frame scale"] = "지도 크기 변경"
L["Map Opacity"] = "지도 불투명도"
L["Map Scale"] = "지도 비율"
L["Map Size"] = "지도 크기"
L["Maraudon"] = "마라우돈"
L["Maraudon: Earth Song Falls"] = "마라우돈 : 대지노래 폭포"
L["Maraudon: Foulspore Cavern"] = "마라우돈 : 썩은포자 동굴"
L["Maraudon: The Wicked Grotto"] = "마라우돈 : 악의 동굴"
L["Marshal's Refuge"] = "마샬 야영지"
L["Maw of Souls"] = "지옥어귀 벼랑"
L["Max Zoom"] = "최대 줌"
L["Maximised"] = "최대화"
L["Maximum"] = "최대"
L["Mechanics"] = "이거"
L["Memory Usage"] = "메모리 사용량"
L["Menethil Harbor"] = "메네실 항구"
L["Miscellaneous"] = "기타"
L["Mists of Tirna Scithe"] = "티르나 사이드의 안개"
L["Moa'ki"] = "모아키 항구"
L["Moa'ki Harbor"] = "모아키 항구"
L["Mogu'shan Palace"] = "모구샨 궁전"
L["Mogu'shan Vaults"] = "모구샨 금고"
L["Mok'Nathal Village"] = "모그나탈 마을"
L["Molten Core"] = "화산 심장부"
L["Moon Guard Stronghold"] = "달빛 수호자 성채"
L["Moonglade"] = "달의 숲"
L["More"] = "그거"
L["Morgan's Vigil"] = "모건의 망루"
L["Mount Crafting"] = "탈것 제작"
L["Mount Hyjal"] = "하이잘 산"
L["Mountain Pass (Horde Only)"] = "샛길(호드 전용)"
L["Moving"] = "이동할 때"
L["Mudsprocket"] = "진흙톱니 거점"
L["Mulgore"] = "멀고어"
L["Nagrand"] = "나그란드"
L["Naxxramas"] = "낙스라마스"
L["Nazjatar"] = "나즈자타"
L["Neltharion's Lair"] = "넬타리온의 둥지"
L["Neltharus"] = "넬타루스"
L["Nesingwary Base Camp"] = "네싱워리 주둔지"
L["Nethergarde Keep"] = "네더가드 요새"
L["Netherstorm"] = "황천의 폭풍"
L["Never"] = "절대 안 함"
L["New Agamand"] = "신 아가만드"
L["Nighthaven"] = "나이트헤이븐"
L["Nijel's Point"] = "나이젤의 야영지"
L["North"] = "북쪽 (Bukjjok)"
L["North Gate Pass"] = "북부 관문 통행로"
L["Ny'alotha, The Waking City"] = "깨어난 도시 나이알로사"
L["Old Hillsbrad"] = "옛 힐스브래드 구릉지"
L["Old Hillsbrad Foothills"] = "옛 언덕마루 구릉지"
L["Onyxia's Lair"] = "오닉시아의 둥지"
L["Opacity"] = "불투명"
L["Operation: Mechagon"] = "작전명 : 메카곤"
L["or click the minimap button to open Leatrix Maps."] = "미니맵 버튼을 클릭하여 Leatrix Maps를 엽니다."
L["Orb of Translocation"] = "순간이동의 보주"
L["Orebor Harborage"] = "오레보르 피난처"
L["Orgrimmar"] = "오그리마"
L["Oribos"] = "오리보스"
L["Pet Crafting"] = "애완동물 제작"
L["Plaguefall"] = "역병 몰락지"
L["Player"] = "플레이어"
L["Player Arrow"] = "플레이어 화살표"
L["Portal"] = "차원문"
L["Portal from Zephyr"] = "제피르와 대화를 통해 이동 (시간의 수호자 평판 매우호 필요)"
L["Portals"] = "차원문"
L["Preview"] = "미리보기"
L["Protoform Repository"] = "원생형태 보관소"
L["Ragefire Chasm"] = "성난불길 협곡"
L["Raid"] = "공격대"
L["Ratchet"] = "톱니항"
L["Ravenholdt Manor"] = "라벤홀트 장원"
L["Razorfen Downs"] = "가시덩굴 구릉"
L["Razorfen Kraul"] = "가시덩굴 우리"
L["Razorthorn Trail"] = "서슬가시 고개"
L["Rebel Camp"] = "반란군 야영지"
L["Red"] = "레드"
L["Redridge Mountains"] = "붉은마루 산맥"
L["Refuge Pointe"] = "임시주둔지"
L["Reload"] = "리로드"
L["Remember zoom level"] = "확대/축소 기억"
L["Remove map border"] = "지도 테두리 제거"
L["req"] = "입장가능 레벨"
L["Requires Key to Searing Gorge"] = "불타는 협곡 열쇠 필요"
L["Requires UI reload."] = "UI를 리로드 해야합니다."
L["Reset"] = "리셋"
L["Reset Map Layout"] = "지도 레이아웃 초기화"
L["Return to Karazhan"] = "다시 찾은 카라잔"
L["Revantusk Village"] = "레반터스크 마을"
L["River's Heart"] = "강의 심장부"
L["Ruby Life Pools"] = "루비 생명의 웅덩이"
L["Ruins of Ahn'Qiraj"] = "안퀴라즈 폐허"
L["Ruins of Elune'eth"] = "엘룬에스의 페허"
L["Rut'Theran Village"] = "루테란 마을"
L["Rut'theran Village"] = "루테란 마을"
L["Sanctuary"] = "성역"
L["Sanctum of Domination"] = "지배의 성소"
L["Sanctum of Order"] = "질서의 성소"
L["Sanctum of the Sages"] = "현자의 성소"
L["Sanctum of the Stars"] = "별의 성소"
L["Sanguine Depths"] = "핏빛 심연"
L["Scale"] = "크기"
L["Scale the map"] = "지도 크기 조절"
L["Scarlet Halls"] = "붉은십자군 전당"
L["Scarlet Monastery"] = "붉은십자군 수도원"
L["Scholomance"] = "스칼로맨스"
L["Searing Gorge"] = "이글거리는 협곡"
L["Seat of the Naaru"] = "나루의 보좌"
L["Seat of the Triumvirate"] = "삼두정의 권좌"
L["Sentinel Hill"] = "감시의 언덕"
L["Sepulcher of the First Ones"] = "태초의 존재의 매장터"
L["Serpentshrine Cavern"] = "불뱀 제단"
L["Set map opacity"] = "지도 불투명도 설정"
L["Set map opacity while stationary and while moving."] = "플레이어가 맵을 열고 이동할때와 고정일때의 맵 불투명도를 설정합니다."
L["Set the group icon size."] = "그룹아이콘 크기 설정"
L["Set the maximum zoom scale."] = "최대 줌 스케일을 설정하세요."
L["Set the player arrow size."] = "플레이어 화살표 크기를 설정하십시오."
L["Sethekk Halls"] = "세데크 전당"
L["Settings"] = "설정"
L["Sewers"] = "하수구"
L["Shado-Pan Monastery"] = "음영파 수도원"
L["Shadow Labyrinth"] = "어둠의 미궁"
L["Shadowfang Keep"] = "그림자송곳니 성채"
L["Shadowlands"] = "어둠땅"
L["Shadowmoon Burial Grounds"] = "어둠달 지하묘지"
L["Shadowmoon Valley"] = "어둠달 골짜기"
L["Shadowmoon Village"] = "어둠달 마을"
L["Shadowprey Village"] = "그늘수렵 마을"
L["Shal'Aran"] = "샬아란"
L["Shatter Point"] = "징검다리 거점"
L["Shattrath"] = "샤트라스"
L["Shattrath City"] = "샤트라스"
L["Sholazar Basin"] = "숄라자르 분지"
L["Show background"] = "배경 표시"
L["Show boats, zeppelins and trams"] = "여객선,비행선,지하철 표시"
L["Show coordinates"] = "좌표 표시"
L["Show dungeons and raids"] = "던전 및 공격대 표시"
L["Show minimap button"] = "미니맵 버튼 표시"
L["Show minimum fishing skill levels"] = "최소 낚시 숙련도 표시"
L["Show objectives"] = "목표 표시"
L["Show points of interest"] = "주요 지점 표시"
L["Show scale handle"] = "크기 설정 표시"
L["Show spirit healers"] = "영혼 치유사 표시"
L["Show travel points for opposing faction"] = "상대 진영의 이동 지점 표시"
L["Show travel points for same faction"] = "동일한 진영의 이동 지점 표시"
L["Show unexplored areas"] = "미탐험 지역 표시"
L["Show zone crossings"] = "지역 이탈 지점 표시"
L["Show zone levels"] = "지역 레벨 표시"
L["Show zone menus"] = "지역 메뉴 표시"
L["Shrine of the Storm"] = "폭풍의 사원"
L["Siege of Boralus"] = "보랄러스 공성전"
L["Siege of Niuzao Temple"] = "니우짜오 사원 공성전투"
L["Siege of Orgrimmar"] = "오그리마 공성전"
L["Silithus"] = "실리더스"
L["Silvermoon"] = "실버문"
L["Silvermoon City"] = "실버문"
L["Silverpine Forest"] = "은빛소나무 숲"
L["Skyreach"] = "하늘탑"
L["Slave Pens"] = "강제 노역소"
L["South"] = "남쪽"
L["South Gate Pass"] = "남부 관문 통행로"
L["Southfury River"] = "분노의 강"
L["Southshore"] = "사우스쇼어"
L["Spinebreaker Ridge"] = "지옥절단기 함락지"
L["Spires of Ascension"] = "승천의 첨탑"
L["Spirit Healer"] = "영혼의 치유사"
L["Splintertree Post"] = "토막나무 주둔지"
L["Stars' Rest"] = "별의 쉼터"
L["Stationary"] = "움직이지 않을 때"
L["Steamvault"] = "증기 저장고"
L["Sticky map frame"] = "지도 프레임 지속됨."
L["Stonard"] = "스토나드"
L["Stonebreaker Hold"] = "돌망치 요새"
L["Stonetalon Mountains"] = "돌발톱 산맥"
L["Stonetalon Peak"] = "돌발톱 봉우리"
L["Stormstout Brewery"] = "스톰스타우트 양조장"
L["Stormwind"] = "스톰윈드"
L["Stormwind City"] = "스톰윈드"
L["Stranglethorn Vale"] = "가시덤불 골짜기"
L["Stratholme (Main Gate)"] = "스트라솔름(정문)"
L["Stratholme (Service Gate)"] = "스트라솔름(정비용 입구)"
L["Stratholme: Crusader's Square"] = "스트라솔름 : 십자군 광장"
L["Stratholme: The Gauntlet"] = "스트라솔름 : 투쟁의 거리"
L["sum"] = "만남의 돌"
L["Sun Rock Retreat"] = "해바위 야영지"
L["Sunreaver's Command"] = "선리버 지휘초소"
L["Sun's Reach Harbor"] = "태양너울 항구"
L["Sunwell Plateau"] = "태양샘 고원"
L["Swamp of Sorrows"] = "슬픔의 늪"
L["Swamprat Post"] = "늪쥐 감시초소"
L["Sylvanaar"] = "실바나르"
L["Synthesis Forge"] = "합성 제련소"
L["System"] = "시스템"
L["Talonbranch Glade"] = "바람속삭임 숲"
L["Talrendis Point"] = "탈렌디스 초소"
L["Tanaris"] = "타나리스"
L["Tarren Mill"] = "타렌 밀농장"
L["Taunka'le Village"] = "타운카르 마을"
L["Taxi to Scholar's Den"] = "학자의 은신처로 비행"
L["Taxi to Vault of Secrets"] = "비밀의 금고로 비행"
L["Tazavesh, the Veiled Market"] = "테자베쉬, 잿빛 시장"
L["Telaar"] = "텔라아르"
L["Tel'anor"] = "텔아노르"
L["Teldrassil"] = "텔드랏실"
L["Teleport Crystal"] = "순간이동 크리스털"
L["Telredor"] = "텔레도르"
L["Tempest Keep"] = "폭풍우 요새"
L["Temple of Ahn'Qiraj"] = "안퀴라즈"
L["Temple of Atal'Hakkar"] = "아탈학카르 신전"
L["Temple of Sethraliss"] = "세스랄리스 사원"
L["Temple of Telhamat"] = "텔하마트 사원"
L["Temple of the Jade Serpent"] = "옥룡사"
L["Temple of the Moon"] = "달의 신전"
L["Terokkar Forest"] = "테로카르 숲"
L["Terrace of Endless Spring"] = "영원한 봄의 정원"
L["Thalanaar"] = "탈라나르"
L["Thandol Span"] = "탄돌 교각"
L["The Arcatraz"] = "알카트라즈"
L["The Arcway"] = "비전로"
L["The Argent Stand"] = "은빛십자군 격전지"
L["The Argent Vanguard"] = "은빛십자군 선봉기지"
L["The Azure Vault"] = "하늘빛 보관소"
L["The Barrens"] = "불모의 땅"
L["The Bastion of Twilight"] = "황혼의 요새"
L["The Black Morass"] = "검은늪"
L["The Blood Furnace"] = "피의 용광로"
L["The Botanica"] = "신록의 정원"
L["The Bulwark"] = "보루"
L["The Crossroads"] = "크로스로드"
L["The Culling of Stratholme"] = "옛 스트라솔름"
L["The Dark Portal"] = "어둠의 문"
L["The Deadmines"] = "죽음의 폐광"
L["The Dragon Soul"] = "용의 영혼"
L["The Emerald Nightmare"] = "에메랄드의 악몽"
L["The Everbloom"] = "상록숲"
L["The Exodar"] = "엑소다르"
L["The Eye"] = "폭풍우 요새"
L["The Eye of Eternity"] = "영원의 눈"
L["The Forge of Souls"] = "영혼의 제련소"
L["The Forgotten Coast"] = "잊혀진 해안"
L["The Frozen Halls"] = "얼어붙은 전당"
L["The Great Forge"] = "대용광로"
L["The Great Lift"] = "구름 승강장"
L["The Halls of Reflection"] = "투영의 전당"
L["The Hinterlands"] = "동부내륙지"
L["The Mechanar"] = "메카나르"
L["The MOTHERLODE!!"] = "왕노다지 광산!!"
L["The Necrotic Wake"] = "죽음의 각성"
L["The Nexus"] = "마력의 탑"
L["The Nighthold"] = "밤의 요새"
L["The Nokhud Offensive"] = "노쿠드 공격대"
L["The Obsidian Sanctum"] = "흑요석 성소"
L["The Oculus"] = "마력의 눈"
L["The Old Kingdom"] = "안카헤트: 고대왕국"
L["The Overlook Cliffs"] = "전망대 절벽"
L["The Pit of Saron"] = "사론의 구덩이"
L["The Ruby Sanctum"] = "루비 성소"
L["The Sepulcher"] = "공동묘지"
L["The Shadow Vault"] = "어둠의 무기고"
L["The Shattered Halls"] = "으스러진 손의 전당"
L["The Stockade"] = "지하감옥"
L["The Stonecore"] = "바위심장부"
L["The Storm Peaks"] = "폭풍우 봉우리"
L["The Stormspire"] = "폭풍 첨탑"
L["The Talondeep Path"] = "돌발톱 토굴길"
L["The Underrot"] = "썩은굴"
L["The Vault of Lights"] = "빛의 전당"
L["The Violet Hold"] = "보라빛 요새"
L["The Vortex Pinnacle"] = "소용돌이 누각"
L["The Waning Crescent"] = "기우는 초승달"
L["The Zoram Strand"] = "조람 해안"
L["Theater of Pain"] = "고통의 투기장"
L["Thelsamar"] = "텔사마"
L["Theramore Isle"] = "테라모어"
L["Thorium Point"] = "토륨거점"
L["Thousand Needles"] = "버섯구름 봉우리"
L["Thrallmar"] = "스랄마"
L["Throne of the Four Winds"] = "네 바람의 왕좌"
L["Throne of the Tides"] = "파도의 왕좌"
L["Throne of Thunder"] = "천둥의 왕좌"
L["Thunder Bluff"] = "썬더 블러프"
L["Thunderlord Stronghold"] = "천둥군주 요새"
L["Timbermaw Hold"] = "나무구렁 요새"
L["Tinker Town"] = "땜장이 마을"
L["Tint unexplored areas"] = "미탐험지역 색상"
L["Tiragarde Sound"] = "티라가드 해협"
L["Tirisfal Glades"] = "티리스팔 숲"
L["Titan Translocator"] = "티탄 위치변환기"
L["Toggle panel"] = "패널 전환"
L["Tol Barad"] = "톨 바라드"
L["Tomb of Sargeras"] = "살게라스의 무덤"
L["Toshley's Station"] = "토쉴리의 연구기지"
L["Trade District"] = "상업지구"
L["Trade Quarter"] = "상업지구"
L["Tram to"] = "지하철(다음역) "
L["Tranquillien"] = "트랜퀼리엔"
L["Transitus Shield"] = "변위의 보호막"
L["Transparency"] = "투명도"
L["Trial of the Champion"] = "용사의 시험장"
L["Trial of the Crusader"] = "십자군의 시험장"
L["Trial of Valor"] = "용맹의 시험"
L["Twilight Highlands"] = "황혼의 고원"
L["Twilight Shore"] = "황혼의 해안"
L["Twilight Vale"] = "황혼의 계곡"
L["Twilight Vineyards"] = "황혼의 포도원"
L["Uldaman"] = "울다만"
L["Uldaman (side entrance)"] = "울다만 (후문)"
L["Uldaman: Legacy of Tyr"] = "울다만 : 티르의 유산"
L["Uldir"] = "울디르"
L["Ulduar"] = "울두아르"
L["Uldum"] = "울둠"
L["Underbog"] = "지하수렁"
L["Undercity"] = "언더시티"
L["Un'Goro Crater"] = "운고로 분화구"
L["Unlock battlefield map"] = "전장 지도 잠금 해제"
L["Unlock map frame"] = "세계지도 잠금해제"
L["Unu'pe"] = "우누페"
L["Upper Blackrock Spire"] = "검은바위 첨탑 상층"
L["Use default map"] = "기본 지도 사용"
L["Use large font"] = "큰 폰트 사용"
L["Use stationary opacity while pointing at map"] = "지도를 가리키는 동안 불투명도 사용 안함"
L["Utgarde Keep"] = "우트가드 성채"
L["Utgarde Pinnacle"] = "우트가드 첨탑"
L["Valaar's Berth"] = "발라르의 나루"
L["Valgarde"] = "발가드"
L["Valgarde Port"] = "발가드"
L["Valiance Keep"] = "용맹의 성채"
L["Valiance Landing Camp"] = "용맹의 주둔지"
L["Valley of Strength"] = "힘의 골짜기"
L["Valormok"] = "발로르모크"
L["Vashj'ir"] = "바쉬르"
L["Vault of Archavon"] = "아카본 석실"
L["Vault of the Incarnates"] = "현신의 금고"
L["Vault of the Wardens"] = "감시관의 금고"
L["Vengeance Landing"] = "복수의 상륙지"
L["Venomspite"] = "원한의 초소"
L["Version"] = "버전"
L["Vol'mar"] = "볼마르"
L["Wailing Caverns"] = "통곡의 동굴"
L["Warsong Camp"] = "전쟁노래 야영지"
L["Warsong Hold"] = "전쟁노래 요새"
L["Waycrest Manor"] = "웨이크레스트 저택"
L["Well of Eternity"] = "영원의 샘"
L["Western Earthshrine"] = "서부 대지 제단"
L["Western Plaguelands"] = "서부 역병지대"
L["Westfall"] = "서부 몰락지대"
L["Westfall Brigade"] = "서부 몰락지대"
L["Westguard Keep"] = "서부 몰락지대 여단 야영지"
L["Wetlands"] = "저습지"
L["Wildhammer Stronghold"] = "와일드해머 성채"
L["Windowed"] = "축소 된 지도"
L["Windrunner's Overlook"] = "윈드러너 전망대"
L["Wintergarde Keep"] = "윈터가드 성채"
L["Wintergrasp"] = "겨울손아귀"
L["Winterspring"] = "여명의 설원"
L["World of Warcraft Classic"] = "World of Warcraft Classic"
L["Wrath of the Lich King Classic"] = "리치 왕의 분노 클래식"
L["Wyrmrest Temple"] = "고룡쉼터 사원"
L["You cannot do that in combat."] = "전투중 할수 없습니다."
L["You will die!"] = "당신은 죽을 것이다!"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "일부 변경 사항을(*) 적용하려면 UI를 리로드 해야합니다."
L["Your UI needs to be reloaded."] = "UI를 리로드 해야 합니다."
L["Zabra'jin"] = "자브라진"
L["Zangarmarsh"] = "장가르 습지대"
L["Zeb'Sora"] = "제브소라"
L["Zeppelin to"] = "연결된 비행선 지점:"
L["Zim'Torga"] = "짐토르가"
L["Zone Map"] = "지역 지도"
L["Zoom"] = "줌"
L["Zoram'gar Outpost"] = "조람가르 전초기지"
L["Zul'Aman"] = "줄아만"
L["Zuldazar"] = "줄다자르"
L["Zul'Drak"] = "줄드락"
L["Zul'Farrak"] = "줄파락"
L["Zul'Gurub"] = "줄구룹"

end

-- deDE: German
if GameLocale == "deDE" then
	L["(destination only)"] = "(nur Ziel)"
L["(inside Caverns of Time)"] = "(in den Höhlen der Zeit)"
L["/ltm help - Show this information."] = "/ltm help - Informationen anzeigen."
L["/ltm reset - Reset the panel position."] = "/ltm reset - Panelposition Zurücksetzen."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - ALLE Einstellungen zurücksetzen und Interface neu laden."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "Ein Stopp-Fehler ist aufgetreten aber keine Sorge.  Das kann von Zeit zu Zeit passieren.  Klicke auf den Reload Button und das Problem sollte behoben sein."
L["Acherus: The Ebon Hold"] = "Acherus: Die Ebonfaust"
L["Aerie Peak"] = "Aerie Peak"
L["Agmar's Hammer"] = "Agmars Hammer"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Aldor"] = "Aldor"
L["Algeth'ar Academy"] = "Akademie von Algeth'ar"
L["Allerian Stronghold"] = "Allerias Feste"
L["Alliance Cities"] = "Allianz Städte"
L["Allow frame movement"] = "Erlaube Fenster Positionierung"
L["Alpha"] = "Alpha"
L["Altar of Sha'tar"] = "Altar der Sha'tar"
L["Alterac Mountains"] = "Alteracgebirge"
L["Always"] = "Immer"
L["Amber Lodge"] = "Bernsteinlager"
L["Amberpine Lodge"] = "Bernsteinfichtenlager"
L["Antorus, the Burning Throne"] = "Antorus, der Brennende Thron"
L["Apothecary Camp"] = "Apothekerlager"
L["Appearance"] = "Erscheinungsbild"
L["Arathi Highlands"] = "Arathihochland"
L["Area 52"] = "Area 52"
L["Argent Tournament Grounds"] = "Argentumturniergelände"
L["Armory"] = "Waffenkammer"
L["Ashenvale"] = "Eschental"
L["Astranaar"] = "Astranaar"
L["Astravar Harbor"] = "Hafen der Astravar"
L["Atal'Dazar"] = "Atal'Dazar"
L["Auberdine"] = "Auberdine"
L["Auchenai Crypts"] = "Auchenaikrypta"
L["Auchindoun"] = "Auchindoun"
L["Auto change zones"] = "Automatische Zonenwechsel"
L["available during zone attack"] = "verfügbar während Gebietsattacke"
L["Azeroth"] = "Azeroth"
L["Azjol-Nerub"] = "Azjol-Nerub"
L["Azshara"] = "Azshara"
L["Azuremyst Isle"] = "Azurmythosinsel"
L["Back to Main Menu"] = "Zurück zum Hauptmenü"
L["Badlands"] = "Ödland"
L["Battle of Dazar'alor"] = "Die Schlacht von Dazar'alor"
L["Battlegrounds"] = "Schlachtfelder"
L["Black Morass"] = "Schwarze Morast"
L["Black Rook Hold"] = "Die Rabenwehr"
L["Black Temple"] = "Der Schwarze Tempel"
L["Blackfathom Deeps"] = "Blackfathom-Tiefe"
L["Blackrock Caverns"] = "Schwarzfelshöhlen"
L["Blackrock Depths"] = "Blackrocktiefen"
L["Blackrock Foundry"] = "Schwarzfelsgießerei"
L["Blackrock Mountain"] = "Der Blackrock"
L["Blackrock Spire"] = "Blackrockspitze"
L["Blackwing Descent"] = "Pechschwingenabstieg"
L["Blackwing Lair"] = "Pechschwingenhort"
L["Blade Tooth Canyon"] = "Klingenzahnschlucht"
L["Blade's Edge Mountains"] = "Schergrat"
L["Blades' Run"] = "Klingenjagd"
L["Blasted Lands"] = "Verwüstete Lande"
L["Blood Watch"] = "Blutwacht"
L["Bloodmaul Slag Mines"] = "Blutschlägermine"
L["Bloodmyst Isle"] = "Blutmythosinsel"
L["Bloodvenom Post"] = "Blutgiftposten"
L["Blue"] = "Blau"
L["Boat to"] = "Boot nach"
L["Booty Bay"] = "Beutebucht"
L["Borean Tundra"] = "Boreanische Tundra"
L["Bor'gorok Outpost"] = "Außenposten Bor'gorok"
L["Bouldercrag's Refuge"] = "Felskluft Zuflucht"
L["Brackenhide Hollow"] = "Brackenfellhöhle"
L["Brackenwall Village"] = "Brackenwall"
L["Burning Crusade Classic"] = "Burning Crusade Classic"
L["Burning Steppes"] = "Brennende Steppe"
L["Camp Mojache"] = "Camp Mojache"
L["Camp Oneqwah"] = "Lager Oneqwah"
L["Camp Taurajo"] = "Camp Taurajo"
L["Camp Tunka'lo"] = "Lager Tunka'lo"
L["Camp Winterhoof"] = "Lager Winterhuf"
L["Castle Nathria"] = "Schloss Nathria"
L["Cathedral"] = "Kathedrale"
L["Cathedral of Eternal Night"] = "Die Kathedrale der Ewigen Nacht"
L["Caverns of Time"] = "Höhlen der Zeit"
L["Cenarion Hold"] = "Burg Cenarius"
L["Center map on player"] = "Karte auf Spieler zentrieren"
L["Central Mesa"] = "Die große Anhöhe"
L["Chamber of Heart"] = "Die Herzkammer"
L["Chillwind Camp"] = "Chillwind-Lager"
L["Choose where the zone map should be shown."] = "Wähle aus, wo die Zonenkarte angezeigt werden soll."
L["Class colored icons"] = "Symbole in Klassenfarbe"
L["Classic"] = "Classic"
L["Click to configure the settings for this option."] = "Klicken um die Einstellung dieser Option zu verändern."
L["Click to reset the position and scale of the map frame."] = "Klicken zum zurücksetzen der Position und Größe des Weltkartenfensters."
L["Click to reset the settings on this page."] = "Klicken zum zurücksetzen der Einstellungen dieses Fensters."
L["Click to return to the main menu."] = "Klicken um zurück ins Hauptmenü zu gelangen."
L["Coilfang Reservoir"] = "Der Echsenkessel"
L["Coldarra"] = "Kaltarra"
L["Configuration Panel"] = "Einstellungsfenster"
L["Conquest Hold"] = "Eroberungsfeste"
L["Cosmic"] = "Kosmisch"
L["Cosmowrench"] = "Kosmozang"
L["Court of Stars"] = "Der Hof der Sterne"
L["Crucible of Storms"] = "Der Tiegel der Stürme"
L["Crusaders' Pinnacle"] = "Scharlachrotes Scharnier"
L["Crystalsong Forest"] = "Kristallsangwald"
L["Culling of Stratholme"] = "Säuberung von Stratholme"
L["Cursor"] = "Cursor"
L["Dalaran"] = "Dalaran"
L["Dalaran Crater"] = "Dalarankrater"
L["Darkheart Thicket"] = "Das Finsterherzdickicht"
L["Darkshire"] = "Dunkelhain"
L["Darkshore"] = "Dunkelküste"
L["Darnassus"] = "Darnassus"
L["De Other Side"] = "Die Andre Seite"
L["Deadwind Pass"] = "Gebirgspass der Totenwinde"
L["Death's Rise"] = "Anstieg des Todes"
L["Debug"] = "Debug"
L["Deepholm"] = "Tiefenheim"
L["Desolace"] = "Desolace"
L["Dire Maul (East)"] = "Düsterbruch (Ost)"
L["Dire Maul (East) (side entrance)"] = "Düsterbruch (Ost) (Seiteneingang)"
L["Dire Maul (North)"] = "Düsterbruch (Nord)"
L["Dire Maul (West)"] = "Düsterbruch (West)"
L["Dire Maul: Capital Gardens"] = "Düsterbruch: Hauptstadtgärten"
L["Dire Maul: Gordok Commons"] = "Düsterbruch: Gordokhallen"
L["Dire Maul: Warpwood Quarter"] = "Düsterbruch: Wucherborkenviertel"
L["Disable map fade"] = "Karten verblassen deaktivieren"
L["Disable reading emote"] = "Kartenlesen Emote deaktivieren"
L["Disable reading emote when opening the map"] = "Deaktiviert die Leseanimation wenn die Weltkarte geöffnet wird"
L["disabled"] = "deaktiviert"
L["Drag"] = "Verschieben"
L["Drag to set the amount of blue."] = "Verschiebe den Regler für die Menge an blau."
L["Drag to set the amount of green."] = "Verschiebe den Regler für die Menge an grün."
L["Drag to set the amount of red."] = "Verschiebe den Regler für die Menge an rot."
L["Drag to set the battlefield map opacity."] = "Ziehen Sie, um die transparenz der Schlachtfeldkarte festzulegen."
L["Drag to set the battlefield map size."] = "Ziehen Sie, um die Größe der Schlachtfeldkarte festzulegen."
L["Drag to set the battlefield map size.|n|nIf the map is unlocked, you can also resize the battlefield map by dragging the bottom-right corner."] = "Ziehen, um die Größe der Schlachtfeldkarte festzulegen.|n|nWenn die Karte entsperrt ist, kannst du die Größe auch ändern, indem du die untere rechte Ecke ziehst."
L["Drag to set the group icon size."] = "Ziehen zum ändern der Gruppenicongröße"
L["Drag to set the map opacity for when your character is moving."] = "Verschiebe den Regler für die Transparenz der Weltkarte wenn sich dein Charakter bewegt."
L["Drag to set the map opacity for when your character is stationary."] = "Verschiebe den Regler für die Transparenz der Weltkarte wenn dein Charakter steht."
L["Drag to set the maximum zoom level.|n|nOpen the battlefield map to see the maximum zoom level change as you drag the slider."] = "Ziehen, um das maximale Zoom-Level festzulegen.|n|nÖffne die Schlachtfeldkarte, um zu sehen, wie sich das maximale Zoom-Level ändert, während du den Schieberegler ziehst."
L["Drag to set the maximum zoom level.|n|nOpen the map to see the maximum zoom level change as you drag the slider."] = "Ziehen, um das maximale Zoom-Level festzulegen.|n|nÖffne die Karte, um zu sehen, wie sich das maximale Zoom-Level ändert, während du den Schieberegler ziehst."
L["Drag to set the opacity."] = "Verschiebe den Regler für die Transparenz."
L["Drag to set the player arrow size."] = "Ziehen Sie, um die Pfeilgröße des Spielers festzulegen"
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "Verschieben um die Größe des Spielerpfeils einzustellen.|n|nWoW Classic größe ist 16.|nWoW Live größe ist 27."
L["Drag to set the scale for the maximised map."] = "Ziehen, um die Skalierung für die maximale Karte einzustellen."
L["Drag to set the scale for the windowed map."] = "Ziehen, um die Skalierung für die fensterbasierte Karte einzustellen."
L["Drag to set the world map scale.|n|nYou can also rescale the world map by dragging the bottom-right corner."] = "Ziehen, um die Skalierung der Weltkarte festzulegen.|n|nDu kannst auch die Weltkarte neu skalieren, indem du die untere rechte Ecke ziehst."
L["Dragon Soul"] = "Drachenseele"
L["Dragonblight"] = "Drachenöde"
L["Drak'Tharon Keep"] = "Feste Drak'Tharon"
L["Druid only flight point to Darnassus"] = "Flugpunkt nach Darnassus, nur für Druiden"
L["Druid only flight point to Thunder Bluff"] = "Flugpunkt nach Donnerfels, nur für Druiden"
L["Dun Algaz"] = "Dun Algaz"
L["Dun Morogh"] = "Dun Morogh"
L["Dun Nifflelem"] = "Dun Nifflelem"
L["Dungeon"] = "Instanz"
L["Dungeon (requires Crescent Key)"] = "Dungeon (benötigt Halbmond-Schlüssel)"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Dämmerwald"
L["Dustwallow Marsh"] = "Marschen von Dustwallow"
L["Dwarven District"] = "Der Zwergendistrikt"
L["Eastern Earthshrine"] = "Der östliche Erdschrein"
L["Eastern Plaguelands"] = "Östliche Pestländer"
L["Ebon Watch"] = "Ebonwacht"
L["Elements"] = "Elemente"
L["Elwynn Forest"] = "Wald von Elwynn"
L["Emerald Sanctuary"] = "Das Smaragdrefugium"
L["enabled"] = "aktiviert"
L["End Time"] = "Die Endzeit"
L["Enhance battlefield map"] = "Verbessere die Schlachtfeldkarte"
L["Enhance dungeon icons"] = "Verbesserte Dungeon Icons"
L["Enlarge player arrow"] = "Vergrößerter spielerpfeil"
L["Enter"] = "Eingeben"
L["Evergrove"] = "Der Ewige Hain"
L["Everlook"] = "Ewige Warte"
L["Evermoon Terrace"] = "Die Immermondterrasse"
L["Eversong Woods"] = "Immersangwald"
L["Exile's Hollow"] = "Höhle des Verbannten"
L["Exodar"] = "Die Exodar"
L["Eye of Azshara"] = "Das Auge Azsharas"
L["Falanaar"] = "Falanaar"
L["Falcon Watch"] = "Falkenwacht"
L["Faldir's Cove"] = "Die Faldirbucht"
L["Feathermoon Stronghold"] = "Festung Feathermoon"
L["Felsoul Hold"] = "Teufelsseelenbastion"
L["Felwood"] = "Teufelswald"
L["Feralas"] = "Feralas"
L["Firelands"] = "Die Feuerlande"
L["Fishing"] = "Fischen"
L["Fizzcrank Airstrip"] = "Spritzkühlnordpiste"
L["Flame Crest"] = "Flammenkamm"
L["Flayedwing Transporter"] = "Fledderflügeltransporter"
L["Follow the eastward path"] = "Folge dem Weg nach Osten"
L["Follow the westward path"] = "Folge dem Weg nach Westen"
L["Fordragon Hold"] = "Festung Fordragon"
L["Forest Song"] = "Waldeslied"
L["Fort Wildervar"] = "Festung Wildervar"
L["Freehold"] = "Freihafen"
L["Freewind Post"] = "Freiwindposten"
L["Frosthold"] = "Frostfeste"
L["Gadgetzan"] = "Gadgetzan"
L["Garadar"] = "Garadar"
L["Gate of the Setting Sun"] = "Das Tor der Untergehenden Sonne"
L["Gates of Valor"] = "Die Pforte der Tapferkeit"
L["Ghostlands"] = "Geisterlande"
L["Gnomeregan"] = "Gnomeregan"
L["Graveyard"] = "Friedhof"
L["Green"] = "Grün"
L["Grim Batol"] = "Grim Batol"
L["Grimrail Depot"] = "Grimmgleisdepot"
L["Grizzly Hills"] = "Grizzlyhügel"
L["Grom'arsh Crash Site"] = "Absturzstelle von Grom'arsh"
L["Grom'gol Base Camp"] = "Das Basislager von Grom'gol"
L["Group Icons"] = "Gruppenicons"
L["Gruul's Lair"] = "Gruuls Unterschlupf"
L["Gundrak"] = "Gundrak"
L["Gundrak (rear entrance)"] = "Gundrak (Hintereingang)"
L["Hall of Ancient Paths"] = "Halle der Uralten Pfade"
L["Halls of Atonement"] = "Hallen der Sühne"
L["Halls of Infusion"] = "Hallen der Infusion"
L["Halls of Lightning"] = "Hall der Blitze"
L["Halls of Origination"] = "Hallen des Ursprungs"
L["Halls of Stone"] = "Hallen des Steins"
L["Halls of Valor"] = "Die Hallen der Tapferkeit"
L["Hammerfall"] = "Hammerfall"
L["Head down the mountain from here."] = "Gehe von hier aus den Berg hinunter."
L["Head southeast from here and go up the mountain."] = "Gehe von hier aus nach Südosten und gehe den Berg hinauf."
L["Heart of Fear"] = "Das Herz der Angst"
L["Hellfire Citadel"] = "Höllenfeuerzitadelle"
L["Hellfire Peninsula"] = "Höllenfeuerhalbinsel"
L["Hellfire Ramparts"] = "Höllenfeuerbollwerk"
L["Hide town and city icons"] = "Verstecke Stadticons"
L["Highmaul"] = "Hochfels"
L["Hillsbrad Foothills"] = "Vorgebirge von Hillsbrad"
L["Honor Hold"] = "Ehrenfeste"
L["Horde Cities"] = "Horde Städte"
L["Hour of Twilight"] = "Stunde des Zwielichts"
L["Howling Fjord"] = "Heulender Fjord"
L["Hyjal"] = "Hyjal"
L["Hyjal Summit"] = "Hyjalgipfel"
L["Icecrown"] = "Eiskrone"
L["Icecrown Citadel"] = "Eiskronenzitadelle"
L["Icons"] = "Symbole"
L["If checked, additional icons (such as portals) will be shown."] = "Wenn ausgewählt, werden zusätzliche Symbole (wie Portale) angezeigt."
L["If checked, coordinates will be shown."] = "Zeigt die Koordinaten an wenn aktiviert."
L["If checked, coordinates will have a dark background texture."] = "Wenn ausgewählt, werden Koordinaten mit dunklem Hintergrund dargestellt."
L["If checked, coordinates will use a large font."] = "Wenn ausgewählt, werden Koordinaten mit großer Schrift dargestellt."
L["If checked, dungeons and raids will be shown."] = "Zeigt Instanz- und Schlachtzugseingänge an wenn aktiviert."
L["If checked, group icons will use a modern, class-colored design."] = "Gruppensymbole nutzen das moderne und, nach Klassenfarben, eingefärbte Aussehen wenn aktiviert."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "Wenn aktiviert, öffnet sich die Weltkarte mit der selben Zoomstufe mit der Du sie zuletzt verlassen hast. Funktioniert nur solange Du nicht die Zone wechselst."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "Nutzt die Transparenzeinstellung aus der 'Stehend' voreinstellung sobald sich euer Mauszeiger auf der Weltkarte befindet wenn aktiviert."
L["If checked, points of interest will be shown."] = "POI - interessante Punkte werden auf der Weltkarte mit Symbolen dargestellt wenn aktiviert."
L["If checked, quest objectives will be shown."] = "Wenn ausgewählt, werden Questziele angezeigt."
L["If checked, spirit healers will be shown."] = "Geistheiler werden angezeigt wenn aktiviert"
L["If checked, the battlefield map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Wenn ausgewählt, bleibt die Schlachtfeldkarte zentriert auf deinem Standort, solange du nicht in einem Dungeon bist.|n|nDu kannst die Umschalttaste gedrückt halten, während du die Karte verschiebst, um zu verhindern, dass sie sich vorübergehend zentriert."
L["If checked, the default fullscreen map will be used for the maximised map.|n|nNote that enabling this option will lock out some of the other options."] = "Wenn ausgewählt, wird die standardmäßige Vollbildkarte für die maximale Karte verwendet.|n|nBeachten Sie, dass durch Aktivieren dieser Option einige andere Optionen gesperrt werden."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "Wenn aktiviert, wird die standard Vollbild-Karte genutzt.|n|n Hinweis - Das aktivieren dieser Option sperrt einige andere Funktionen."
L["If checked, the map border will be removed."] = "Der Fensterrand der Weltkarte wird entfernt wenn aktiviert."
L["If checked, the map frame will remain open until you close it."] = "Das Kartenfenster bleibt offen bis es manuell geschlossen wird, wenn aktiviert."
L["If checked, the map will not fade while your character is moving."] = "Wenn ausgewählt, wird die Karte nicht verblassen wenn sich dein Charakter bewegt."
L["If checked, the map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Wenn ausgewählt, bleibt die Karte zentriert auf deinem Standort, solange du nicht in einem Dungeon bist.|n|nDu kannst die Umschalttaste gedrückt halten, während du die Karte verschiebst, um zu verhindern, dass sie sich vorübergehend zentriert."
L["If checked, the minimap button will be shown."] = "Zeigt den Button an der Minikarte wenn aktiviert."
L["If checked, the minimum fishing skill levels will be shown."] = "Zeigt die benötigte Angelfertigkeit des Gebietes an wenn aktiviert."
L["If checked, town and city icons will not be shown on the continent maps."] = " Stadtsymbole werden nicht gezeigt wenn aktiviert."
L["If checked, travel points for the opposing faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Wenn ausgewählt, werden Reisepunkte für die gegnerische Fraktion angezeigt.|n|nDies beinhaltet Flugpunkte, Bootshäfen, Zeppelintürme und Straßenbahnstationen."
L["If checked, travel points for the same faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Wenn ausgewählt, werden Reisepunkte für die gleiche Fraktion angezeigt.|n|nDies beinhaltet Flugpunkte, Bootshäfen, Zeppelintürme und Straßenbahnstationen."
L["If checked, unexplored areas of the map will be shown on the world map and the battlefield map."] = "Wenn ausgewählt, werden unerforschte Gebiete der Karte auf der Weltkarte und der Schlachtfeldkarte angezeigt."
L["If checked, unexplored areas will be tinted."] = "Färbt die unentdeckten Gebiete auf der Weltkarte ein wenn aktiviert"
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "Wenn aktiviert, wechselt die Karte automatisch die Zone sobald der Charakter die neue Zone betritt."
L["If checked, you can move the battlefield map by dragging any of its borders."] = "Wenn ausgewählt, können Sie die Schlachtfeldkarte verschieben, indem Sie einen ihrer Ränder ziehen."
L["If checked, you can move the battlefield map by dragging any of its borders.|n|nYou can resize the battlefield map by dragging the bottom-right corner."] = "Wenn ausgewählt, kannst du die Schlachtfeldkarte verschieben, indem du einen ihrer Ränder ziehst.|n|nDu kannst die Größe der Schlachtfeldkarte ändern, indem du die untere rechte Ecke ziehst."
L["If checked, you will be able to customise the battlefield map."] = "Wenn diese Option aktiviert ist, können Sie die Schlachtfeldkarte anpassen."
L["If checked, you will be able to enlarge the player arrow."] = "Ermöglicht die Anpassug der Größe des Spielerpfeils wenn aktiviert."
L["If checked, you will be able to move the frame by dragging the border."] = "Wenn ausgewählt, kannst du das Fenster verschieben indem du es Rand ziehst."
L["If checked, you will be able to move the map.|n|nThe map position will be saved separately for the maximised and windowed maps."] = "Wenn ausgewählt, können Sie die Karte verschieben.|n|nDie Position der Karte wird separat für die maximale und die fensterbasierte Karte gespeichert."
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges."] = "Ermöglicht das Verschieben und die Anpassung der Größe der Weltkarte wenn aktiviert.|n|nÄndere die Größe der Weltkarte indem Du den Anker in der rechten unteren Ecke, mit gedrückter Maustaste, ziehst.|n|nBewege die Weltkarte indem Du sie an den Rändern, mit gedrückter Maustaste, ziehst."
L["If checked, you will be able to scale the map by dragging the scale handle in the bottom-right corner.|n|nYou will be able to move the map by dragging any border.|n|nYou can always drag the top border to move the map regardless of this setting."] = "Wenn ausgewählt, kannst du die Karte vergrößern, indem du den Skalenhandgriff in der unteren rechten Ecke ziehst.|n|nDu kannst die Karte verschieben, indem du einen beliebigen Rand ziehst.|n|nDu kannst immer den oberen Rand ziehen, um die Karte zu verschieben, unabhängig von dieser Einstellung."
L["If checked, you will be able to scale the map."] = "Wenn ausgewählt, können Sie die Karte skalieren."
L["If checked, you will be able to set the opacity of the map."] = "Ermöglicht die Transparenz der Weltkarte einzustellen wenn aktiviert."
L["If checked, you will be able to zoom further into the world map."] = "Wenn ausgewählt, kannst du weiter in die Weltkarte hineinzoomen."
L["If checked, your character will not perform the reading emote when you open the map."] = "Wenn ausgewählt, wird dein Charakter kein Kartenlesen Emote ausführen wenn du die Karte öffnest."
L["If checked, zone and continent dropdown menus will be shown in the map frame."] = "Wenn ausgewählt, werden Dropdown-Menüs für Zone und Kontinent im Kartenfenster angezeigt."
L["If checked, zone crossings will be shown.|n|nThese are clickable arrows that indicate the zone exit pathways."] = "Wenn ausgewählt, werden Zoneübergänge angezeigt.|n|nDiese sind anklickbare Pfeile, die die Ausgangswege der Zone anzeigen."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "Zeigt den Levelbereich für Zonen, Instanzen und Angelfertigkeiten an wenn aktiviert."
L["Increase zoom level"] = "Zoom-Level erhöhen"
L["Invalid command.  Enter /ltm help for help."] = "Unbekannter Befehl.  Schreibe  /ltm help  für weitere Befehle und hilfe."
L["Invalid map ID."] = "Unbekannter Weltkarten-ID."
L["Iron Docks"] = "Eisendocks"
L["Ironforge"] = "Eisenschmiede"
L["Isle of Quel'Danas"] = "Insel von Quel'Danas"
L["Just follow the path west"] = "Folge dem Weg nach Westen"
L["K3"] = "K3"
L["Kamagua"] = "Kamagua"
L["Karazhan"] = "Karazhan"
L["Kargath"] = "Kargath"
L["Kings' Rest"] = "Die Königsruh"
L["Kor'kron Vanguard"] = "Kor'kron Vorhut"
L["Lake Elune'ara"] = "Der Elune'ara See"
L["Lake Everstill"] = "Der Immerruhsee"
L["Large Scarab Coffer"] = "Großer Skarabäuskasten"
L["Leads to Tirisfal Glades"] = "Führt zu Tirisfal"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS: FALSCHE VERSION INSTALLIERT!"
L["Library"] = "Bibliothek"
L["Light's Breach"] = "Lichtes Brachland"
L["Light's Hope Chapel"] = "Kapelle des hoffnungsvollen Lichts"
L["Lion's Watch"] = "Löwenwacht"
L["Loch Modan"] = "Loch Modan"
L["Lost City of the Tol'vir"] = "Die Verlorene Stadt der Tol'vir"
L["Lower Blackrock Spire"] = "Untere Blackrockspitze"
L["Lunastre Estate"] = "Anwesens der Lunastres"
L["Magisters' Terrace"] = "Terrasse der Magister"
L["Magtheridon's Lair"] = "Magtheridons Kammer"
L["Mana-Tombs"] = "Managruft"
L["Map frame scale"] = "Kartenrandgröße"
L["Map Opacity"] = "Kartentransparenz"
L["Map Scale"] = "Kartenmaßstab"
L["Map Size"] = "Kartengröße"
L["Maraudon"] = "Maraudon"
L["Maraudon: Earth Song Falls"] = "Maraudon: Fälle des Irdenen Gesangs"
L["Maraudon: Foulspore Cavern"] = "Maraudon: Faulsporenhöhle"
L["Maraudon: The Wicked Grotto"] = "Maraudon: Die Tückische Grotte"
L["Marshal's Refuge"] = "Marshals Zuflucht"
L["Maw of Souls"] = "Die Helmaulklippen"
L["Max Zoom"] = "Maximales Zoomen"
L["Maximised"] = "Maximiert"
L["Maximum"] = "Maximum"
L["Mechanics"] = "Funktionen"
L["Memory Usage"] = "Speicherauslastung"
L["Menethil Harbor"] = "Der Hafen von Menethil"
L["Miscellaneous"] = "Sonstiger"
L["Mists of Tirna Scithe"] = "Die Nebel von Tirna Scithe"
L["Moa'ki"] = "Moa'ki"
L["Moa'ki Harbor"] = "Hafen von Moa'ki"
L["Mogu'shan Palace"] = "Mogu'shanpalast"
L["Mogu'shan Vaults"] = "Mogu'shangewölbe"
L["Mok'Nathal Village"] = "Dorf der Mok'Nathal"
L["Molten Core"] = "Geschmolzener Kern"
L["Moon Guard Stronghold"] = "Die Mondwachenfestung"
L["Moonglade"] = "Moonglade"
L["More"] = "Mehr"
L["Morgan's Vigil"] = "Morgans Wacht"
L["Mount Crafting"] = "Monturherstellung"
L["Mount Hyjal"] = "Hyjal"
L["Mountain Pass (Horde Only)"] = "Gebirgspass (nur Horde)"
L["Moving"] = "In Bewegung"
L["Mudsprocket"] = "Morastwinkel"
L["Mulgore"] = "Mulgore"
L["Nagrand"] = "Nagrand"
L["Naxxramas"] = "Naxxramas"
L["Nazjatar"] = "Nazjatar"
L["Neltharion's Lair"] = "Neltharions Hort"
L["Neltharus"] = "Neltharus"
L["Nesingwary Base Camp"] = "Nesingwary-Basislager"
L["Nethergarde Keep"] = "Burg Nethergarde"
L["Netherstorm"] = "Nethersturm"
L["Never"] = "Nie"
L["New Agamand"] = "Neu-Agamand"
L["Nighthaven"] = "Nighthaven"
L["Nijel's Point"] = "Die Nijelspitze"
L["North"] = "Norden"
L["North Gate Pass"] = "Nordtorpass"
L["Ny'alotha, The Waking City"] = "Ny'alotha, die Erwachte Stadt"
L["Old Hillsbrad"] = "Alt-Hügelbrad"
L["Old Hillsbrad Foothills"] = "Vorgebirge des Alten Hügellands"
L["Onyxia's Lair"] = "Onyxias Hort"
L["Opacity"] = "Transparenz"
L["Operation: Mechagon"] = "Operation: Mechagon"
L["or click the minimap button to open Leatrix Maps."] = "oder klicke auf den Button an der Minikarte."
L["Orb of Translocation"] = "Orb der Translokation"
L["Orebor Harborage"] = "Oreborzuflucht"
L["Orgrimmar"] = "Orgrimmar"
L["Oribos"] = "Oribos"
L["Pet Crafting"] = "Tiergefährtenherstellung"
L["Plaguefall"] = "Seuchensturz"
L["Player"] = "Spieler"
L["Player Arrow"] = "Spielerpfeil"
L["Portal"] = "Portal"
L["Portal from Zephyr"] = "Portal von Zephyr"
L["Portals"] = "Portale"
L["Preview"] = "Vorschau"
L["Protoform Repository"] = "Protomorphe Repository"
L["Ragefire Chasm"] = "Ragefireabgrund"
L["Raid"] = "Schlachtzug"
L["Ratchet"] = "Ratschet"
L["Ravenholdt Manor"] = "Rabenholdtanwesen"
L["Razor Hill"] = ""
L["Razorfen Downs"] = "Die Hügel von Razorfen"
L["Razorfen Kraul"] = "Der Kral von Razorfen"
L["Razorthorn Trail"] = "Dornenschlucht-Pfad"
L["Rebel Camp"] = "Rebellenlager"
L["Red"] = "Rot"
L["Redridge Mountains"] = "Rotkammgebirge"
L["Refuge Pointe"] = "Die Zuflucht"
L["Reload"] = "Neu laden (UI)"
L["Remember zoom level"] = "Zoomstufe merken"
L["Remove map border"] = "Kartenrand entfernen"
L["req"] = "Erfordert"
L["Requires Key to Searing Gorge"] = "Benötigt Schlüssel für Brennende Schlucht"
L["Requires UI reload."] = "Benötigt UI-Neuladen"
L["Reset"] = "Zurücksetzen"
L["Reset Map Layout"] = "Karte Zurücksetzen"
L["Return to Karazhan"] = "Rückkehr nach Karazhan"
L["Revantusk Village"] = "Revantusk"
L["River's Heart"] = "Herz des Flusses"
L["Ruby Life Pools"] = "Rubinlebensbecken"
L["Ruins of Ahn'Qiraj"] = "Ruinen von Ahn'Qiraj"
L["Ruins of Elune'eth"] = "Ruinen von Elune'eth"
L["Rut'Theran Village"] = "Dorf Rut'theran"
L["Rut'theran Village"] = "Rut'theran"
L["Sanctuary"] = "Heiligtum"
L["Sanctum of Domination"] = "Sanktum der Herrschaft"
L["Sanctum of Order"] = "Sanktum der Ordnung"
L["Sanctum of the Sages"] = "Das Sanktum der Weisen"
L["Sanctum of the Stars"] = "Sanktum der Sterne"
L["Sanguine Depths"] = "Die Blutigen Tiefen"
L["Scale"] = "Größe"
L["Scale the map"] = "Karte skalieren"
L["Scarlet Halls"] = "Scharlachrote Hallen"
L["Scarlet Monastery"] = "Das scharlachrote Kloster"
L["Scholomance"] = "Scholomance"
L["Searing Gorge"] = "Sengende Schlucht"
L["Seat of the Naaru"] = "Sitz der Naaru"
L["Seat of the Triumvirate"] = "Der Sitz des Triumvirats"
L["Sentinel Hill"] = "Späherkuppe"
L["Sepulcher of the First Ones"] = "Mausoleum der Ersten"
L["Serpentshrine Cavern"] = "Höhle des Schlangenschreins"
L["Set map opacity"] = "Kartentransparenz"
L["Set map opacity while stationary and while moving."] = "Einstellung für die Transparenz der Weltkarte beim stehen und bewegen."
L["Set the group icon size."] = "Setzt die Gruppenicongröße"
L["Set the maximum zoom scale."] = "Setze den maximalen Zoom-Maßstab."
L["Set the player arrow size."] = "Stellt die Größe des Spielerpfeils ein."
L["Sethekk Halls"] = "Sethekkhallen"
L["Settings"] = "Einstellungen"
L["Sewers"] = "Kanäle"
L["Shado-Pan Monastery"] = "Shado-Pan-Kloster"
L["Shadow Labyrinth"] = "Schattenlabyrinth"
L["Shadowfang Keep"] = "Burg Shadowfang"
L["Shadowlands"] = "Schattenlande"
L["Shadowmoon Burial Grounds"] = "Schattenmondgrabstätte"
L["Shadowmoon Valley"] = "Schattenmondtal"
L["Shadowmoon Village"] = "Schattenmond"
L["Shadowprey Village"] = "Shadowprey"
L["Shal'Aran"] = "Shal'Aran"
L["Shatter Point"] = "Bruchpunkt"
L["Shattrath"] = "Shattrath"
L["Shattrath City"] = "Shattrath Stadt"
L["Sholazar Basin"] = "Sholazarbecken"
L["Show background"] = "Zeige Hintergrund"
L["Show boats, zeppelins and trams"] = "Boot, Zeppeline und Bahnen"
L["Show coordinates"] = "Zeige Koordinaten"
L["Show dungeons and raids"] = "Instanzen und Schlachtzüge"
L["Show minimap button"] = "Zeige minikarten button"
L["Show minimum fishing skill levels"] = "Zeige Angelfertigkeiten"
L["Show objectives"] = "Ziele anzeigen"
L["Show points of interest"] = "Zeige POI"
L["Show scale handle"] = "Zeige Größenregler"
L["Show spirit healers"] = "Zeige Geistheiler"
L["Show travel points for opposing faction"] = "Reisepunkte für die gegnerische Fraktion anzeigen"
L["Show travel points for same faction"] = "Reiseziele für dieselbe Fraktion anzeigen"
L["Show unexplored areas"] = "Zeige unentdeckte Gebiete"
L["Show zone crossings"] = "Zoneübergänge anzeigen"
L["Show zone levels"] = "Zeige Gebietsstufe"
L["Show zone menus"] = "Zone-Menüs anzeigen"
L["Shrine of the Storm"] = "Der Schrein des Sturms"
L["Siege of Boralus"] = "Die Belagerung von Boralus"
L["Siege of Niuzao Temple"] = "Die Belagerung des Niuzaotempels"
L["Siege of Orgrimmar"] = "Schlacht um Orgrimmar"
L["Silithus"] = "Silithus"
L["Silvermoon"] = "Silbermond"
L["Silvermoon City"] = "Silbermond"
L["Silverpine Forest"] = "Silberwald"
L["Skyreach"] = "Himmelsnadel"
L["Slave Pens"] = "Sklavenunterkünfte"
L["South"] = "Süden"
L["South Gate Pass"] = "Südtorpass"
L["Southfury River"] = "Südstrom"
L["Southshore"] = "Southshore"
L["Spinebreaker Ridge"] = "Rückenbrechergrat"
L["Spires of Ascension"] = "Spitzen des Aufstiegs"
L["Spirit Healer"] = "Geistheiler"
L["Splintertree Post"] = "Splintertreeposten"
L["Stars' Rest"] = "Sternenruh"
L["Stationary"] = "Stehend"
L["Steamvault"] = "Dampfkammer"
L["Sticky map frame"] = "Angeheftete Karte"
L["Stonard"] = "Stonard"
L["Stonebreaker Hold"] = "Steinbrecherfeste"
L["Stonetalon Mountains"] = "Steinkrallengebirge"
L["Stonetalon Peak"] = "Der Steinkrallengipfel"
L["Stormstout Brewery"] = "Brauerei Sturmbräu"
L["Stormwind"] = "Sturmwind"
L["Stormwind City"] = "Sturmwind"
L["Stranglethorn Vale"] = "Schlingendorntal"
L["Stratholme (Main Gate)"] = "Stratholme (Haupttor)"
L["Stratholme (Service Gate)"] = "Stratholme (Dienstbotentor)"
L["Stratholme: Crusader's Square"] = "Stratholme: Kreuzzüglerplatz"
L["Stratholme: The Gauntlet"] = "Stratholme: Der Spiessrutenlauf"
L["sum"] = "Beschwörung"
L["Sun Rock Retreat"] = "Sonnenfels"
L["Sunreaver's Command"] = "Befehl der Sonnenhäscher"
L["Sun's Reach Harbor"] = "Hafen der Sonnenweiten"
L["Sunwell Plateau"] = "Sonnenbrunnenplateau"
L["Swamp of Sorrows"] = "Sümpfe des Elends"
L["Swamprat Post"] = "Sumpfrattenposten"
L["Sylvanaar"] = "Sylvanaar"
L["Synthesis Forge"] = "Syntheseschmiede"
L["System"] = "System"
L["Talonbranch Glade"] = "Nachtlaublichtung"
L["Talrendis Point"] = "Talrendisspitze"
L["Tanaris"] = "Tanaris"
L["Tarren Mill"] = "Tarrens Mühle"
L["Taunka'le Village"] = "Taunka'le-Dorf"
L["Taxi to Scholar's Den"] = "Teleporter nach Höhle des Gelehrten"
L["Taxi to Vault of Secrets"] = "Teleporter nach Archiv der Geheimnisse"
L["Tazavesh, the Veiled Market"] = "Tazavesh, der Verhüllte Markt"
L["Telaar"] = "Telaar"
L["Tel'anor"] = "Tel'anor"
L["Teldrassil"] = "Teldrassil"
L["Teleport Crystal"] = "Teleportkristall"
L["Telredor"] = "Telredor"
L["Tempest Keep"] = "Die Festung der Stürme"
L["Temple of Ahn'Qiraj"] = "Tempel von Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Tempel von Atal'Hakkar"
L["Temple of Sethraliss"] = "Der Tempel von Sethraliss"
L["Temple of Telhamat"] = "Tempel von Telhamat"
L["Temple of the Jade Serpent"] = "Tempel der Jadeschlange"
L["Temple of the Moon"] = "Der Tempel des Mondes"
L["Terokkar Forest"] = "Wälder von Terokkar"
L["Terrace of Endless Spring"] = "Terrasse des Endlosen Frühlings"
L["Thalanaar"] = "Thalanaar"
L["Thandol Span"] = "Thandolübergang"
L["The Arcatraz"] = "Die Arkatraz"
L["The Arcway"] = "Der Arkus"
L["The Argent Stand"] = "Der Silberne Wachturm"
L["The Argent Vanguard"] = "Die Silberne Vorhut"
L["The Azure Vault"] = "Das Azurblaue Gewölbe"
L["The Barrens"] = "Das Brachland"
L["The Bastion of Twilight"] = "Die Bastion des Zwielichts"
L["The Black Morass"] = "Der Schwarze Morast"
L["The Blood Furnace"] = "Der Blutkessel"
L["The Botanica"] = "Die Botanika"
L["The Bulwark"] = "Das Bollwerk"
L["The Crossroads"] = "Crossroads"
L["The Culling of Stratholme"] = "Das Ausmerzen von Stratholme"
L["The Dark Portal"] = "Das Dunkle Portal"
L["The Deadmines"] = "Die Todesminen"
L["The Dragon Soul"] = "Drachenseele"
L["The Emerald Nightmare"] = "Der Smaragdgrüne Alptraum"
L["The Everbloom"] = "Der Immergrüne Flor"
L["The Exodar"] = "Die Exodar"
L["The Eye"] = "Festung der Stürme"
L["The Eye of Eternity"] = "Das Auge der Ewigkeit"
L["The Forge of Souls"] = "Die Schmiede der Seelen"
L["The Forgotten Coast"] = "Die vergessene Küste"
L["The Frozen Halls"] = "Die Eiskronenzitadelle"
L["The Great Forge"] = "Die große Schmiede"
L["The Great Lift"] = "Der Große Aufzug"
L["The Halls of Reflection"] = "Die Hallen der Reflexion"
L["The Hinterlands"] = "Hinterland"
L["The Mechanar"] = "Die Mechanar"
L["The MOTHERLODE!!"] = "Das RIESENFLÖZ!!"
L["The Necrotic Wake"] = "Die Nekrotische Schneise"
L["The Nexus"] = "Der Nexus"
L["The Nighthold"] = "Die Nachtfestung"
L["The Nokhud Offensive"] = "Der Angriff der Nokhud"
L["The Obsidian Sanctum"] = "Das Obsidiansanktum"
L["The Oculus"] = "Das Oculus"
L["The Old Kingdom"] = "Das Alte Königreich"
L["The Overlook Cliffs"] = "Die Aussichtsklippen"
L["The Pit of Saron"] = "Die Grube von Saron"
L["The Ruby Sanctum"] = "Das Rubinheiligtum"
L["The Sepulcher"] = "Das Grabmal"
L["The Shadow Vault"] = "Das Schattengewölbe"
L["The Shattered Halls"] = "Die Zerschmetterten Hallen"
L["The Stockade"] = "Das Verlies"
L["The Stonecore"] = "Der Steinerne Kern"
L["The Storm Peaks"] = "Die Sturmgipfel"
L["The Stormspire"] = "Die Sturmsäule"
L["The Talondeep Path"] = "Der Steinkrallenpfad"
L["The Underrot"] = "Der Tiefenpfuhl"
L["The Vault of Lights"] = "Der Lichterschrein"
L["The Violet Hold"] = "Die Violette Festung"
L["The Vortex Pinnacle"] = "Der Vortexgipfel"
L["The Waning Crescent"] = "Das Mondsichelforum"
L["The Zoram Strand"] = "Der Zoramstrand"
L["Theater of Pain"] = "Theater der Schmerzen"
L["Thelsamar"] = "Thelsamar"
L["Theramore Isle"] = "Die Insel Theramore"
L["Thorium Point"] = "Thoriumspitze"
L["Thousand Needles"] = "Tausend Nadeln"
L["Thrallmar"] = "Thrallmar"
L["Throne of the Four Winds"] = "Thron der Vier Winde"
L["Throne of the Tides"] = "Thron der Gezeiten"
L["Throne of Thunder"] = "Der Thron des Donners"
L["Thunder Bluff"] = "Donnerfels"
L["Thunderlord Stronghold"] = "Donnerfeste"
L["Timbermaw Hold"] = "Holzschlundfeste"
L["Tinker Town"] = "Tüftlerstadt"
L["Tint unexplored areas"] = "Färbung unentdeckter Gebiete"
L["Tiragarde Sound"] = "Der Tiragardesund"
L["Tirisfal Glades"] = "Tirisfal"
L["Titan Translocator"] = "Titanentranslokator"
L["Toggle panel"] = "Panel umschalten"
L["Tol Barad"] = "Tol Barad"
L["Tomb of Sargeras"] = "Das Grabmal des Sargeras"
L["Toshley's Station"] = "Toshleys Station"
L["Trade District"] = "Der Handelsdistrikt"
L["Trade Quarter"] = "Das Handelsviertel"
L["Tram to"] = "Bahn nach"
L["Tranquillien"] = "Tristessa"
L["Transitus Shield"] = "Transitus-Schild"
L["Transparency"] = "Transparenz"
L["Trial of the Champion"] = "Prüfung des Champions"
L["Trial of the Crusader"] = "Prüfung des Kreuzfahrers"
L["Trial of Valor"] = "Die Prüfung der Tapferkeit"
L["Twilight Highlands"] = "Schattenhochland"
L["Twilight Shore"] = "Zwielichtufer"
L["Twilight Vale"] = "Zwielichttal"
L["Twilight Vineyards"] = "Die Zwielichtrebgärten"
L["Uldaman"] = "Uldaman"
L["Uldaman (side entrance)"] = "Uldaman (Seiteneingang)"
L["Uldaman: Legacy of Tyr"] = "Uldaman: Vermächtnis von Tyr"
L["Uldir"] = "Uldir"
L["Ulduar"] = "Ulduar"
L["Uldum"] = "Uldum"
L["Underbog"] = "Tiefensumpf"
L["Undercity"] = "Unterstadt"
L["Un'Goro Crater"] = "Un'Goro-Krater"
L["Unlock battlefield map"] = "Schlachtfeldkarte entsperren"
L["Unlock map frame"] = "Löst den Kartenrand"
L["Unu'pe"] = "Unu'pe"
L["Upper Blackrock Spire"] = "Obere Blackrockspitze"
L["Use default map"] = "Benutzt die standard karte"
L["Use large font"] = "Große Schrift verwenden"
L["Use stationary opacity while pointing at map"] = "Nutzt die 'Stehend'-Transparenz wenn euer Mauszeiger auf der Weltkarte ist."
L["Utgarde Keep"] = "Burg Utgarde"
L["Utgarde Pinnacle"] = "Spitze von Utgarde"
L["Valaar's Berth"] = "Valaars Steg"
L["Valgarde"] = "Valgarde"
L["Valgarde Port"] = "Hafen von Valgarde"
L["Valiance Keep"] = "Valianzfeste"
L["Valiance Landing Camp"] = "Valianzlandelager"
L["Valley of Strength"] = "Tal der Stärke"
L["Valormok"] = "Valormok"
L["Vashj'ir"] = "Vashj'ir"
L["Vault of Archavon"] = "Archavons Kammer"
L["Vault of the Incarnates"] = "Gewölbe der Inkarnierten"
L["Vault of the Wardens"] = "Archavons Kammer"
L["Vengeance Landing"] = "Vengeance-Landung"
L["Venomspite"] = "Gallgrimm"
L["Version"] = "Version"
L["Vol'mar"] = "Vol'mar"
L["Wailing Caverns"] = "Die Höhlen des Wehklagens"
L["Warsong Camp"] = "Warsonglager"
L["Warsong Hold"] = "Warsongfeste"
L["Waycrest Manor"] = "Das Kronsteiganwesen"
L["Well of Eternity"] = "Brunnen der Ewigkeit"
L["Western Earthshrine"] = "Der Westliche Erdschrein"
L["Western Plaguelands"] = "Westliche Pestländer"
L["Westfall"] = "Westfall"
L["Westfall Brigade"] = "Westfallbrigade"
L["Westguard Keep"] = "Westwacht"
L["Wetlands"] = "Sumpfland"
L["Wildhammer Stronghold"] = "Wildhammerfeste"
L["Windowed"] = "Verkleinert"
L["Windrunner's Overlook"] = "Windläuferaussichtspunkt"
L["Wintergarde Keep"] = "Wintergarde"
L["Wintergrasp"] = "Wintergrasp"
L["Winterspring"] = "Winterspring"
L["World of Warcraft Classic"] = "World of Warcraft Classic"
L["Wrath of the Lich King Classic"] = "Der Zorn des Lichkönigs Klassik"
L["Wyrmrest Temple"] = "Tempel des Wyrmruh"
L["You cannot do that in combat."] = "Das kannst du nicht während einem Kampf machen."
L["You will die!"] = "Du wirst sterben!"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Deine Benutzeroberfläche (UI) muss neu gestartet werden damit einige Einstellung in kraft treten.|n|nDu musst nicht sofort auf 'Neu laden (UI)' klicken aber am ende deiner Einstellungen solltest Du auf 'Neu laden (UI)' klicken damit alle Einstellungen auch wirksam werden."
L["Your UI needs to be reloaded."] = "UI neu laden."
L["Zabra'jin"] = "Zabra'jin"
L["Zangarmarsh"] = "Zangarmarschen"
L["Zeb'Sora"] = "Zeb'Sora"
L["Zeppelin to"] = "Zeppelin nach"
L["Zim'Torga"] = "Zim'Torga"
L["Zone Map"] = "Zonenkarte"
L["Zoom"] = "Zoom"
L["Zoram'gar Outpost"] = "Zoram'gar-Außenposten"
L["Zul'Aman"] = "Zul'Aman"
L["Zuldazar"] = "Zuldazar"
L["Zul'Drak"] = "Zul'Drak"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"

end

-- esMX: Spanish (Mexico)
if GameLocale == "esMX" then
L["(destination only)"] = "(solo destino)"
L["(inside Caverns of Time)"] = "(dentro de Cavernas de Tiempo)"
L["/ltm help - Show this information."] = "/ltm help - Mostrar información."
L["/ltm reset - Reset the panel position."] = "/ltm reset - Restablecer la posición del panel."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - Borrar la configuración y recargar."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "Se ha producido un error de detención, pero no hay que preocuparse. Puede suceder de vez en cuando. Haz clic en el botón de recarga para resolverlo."
L["Abyssal Depths"] = "Profundidades Abisales"
L["Acherus: The Ebon Hold"] = "Acherus: El Bastión de Ébano"
L["Aerie Peak"] = "Pico Nidal"
L["Agmar's Hammer"] = "El Martillo de Agmar"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Aldor"] = "Aldor"
L["Algeth'ar Academy"] = "Academia Algeth'ar"
L["Allerian Stronghold"] = "Bastión Allerian"
L["Alliance Cities"] = "Ciudades de la Alianza"
L["Allow frame movement"] = "Permitir movimiento del marco"
L["Alpha"] = "Alfa"
L["Altar of Sha'tar"] = "Altar de Sha'tar"
L["Alterac Mountains"] = "Montañas de Alterac"
L["Always"] = "Siempre"
L["Amber Lodge"] = "Refugio Ámbar"
L["Amberpine Lodge"] = "Refugio Pino Ámbar"
L["Andorhal"] = "Andorhal"
L["Antorus, the Burning Throne"] = "Antorus, el Trono Ardiente"
L["Apothecary Camp"] = "Campamento de los Alquimistas"
L["Appearance"] = "Apariencia"
L["Arathi Highlands"] = "Tierras Altas de Arathi"
L["Area 52"] = "Área 52"
L["Argent Tournament Grounds"] = "Campos de Torneo Argenta"
L["Armory"] = "Arsenal"
L["Ashenvale"] = "Vallefresno"
L["Astranaar"] = "Astranaar"
L["Astravar Harbor"] = "Puerto de Astravar"
L["Atal'Dazar"] = "Atal'Dazar"
L["Auberdine"] = "Auberdine"
L["Auchenai Crypts"] = "Criptas Auchenai"
L["Auchindoun"] = "Auchindoun"
L["Auto change zones"] = "Cambiar zonas"
L["available during zone attack"] = "disponible durante el ataque de la zona"
L["Azeroth"] = "Azeroth"
L["Azjol-Nerub"] = "Azjol-Nerub"
L["Azshara"] = "Azshara"
L["Azure Watch"] = "Avanzada Azur"
L["Azuremyst Isle"] = "Isla Bruma Azur"
L["Back to Main Menu"] = "Volver a menú principal"
L["Badlands"] = "Tierras Inhóspitas"
L["Bambala"] = " Bambala"
L["Baradin Hold"] = "Bastión de Baradin"
L["Battle of Dazar'alor"] = "Batalla de Dazar'alor"
L["Battlegrounds"] = "Campos de batalla"
L["Bilgewater Harbor"] = "Muelle Pantoque"
L["Black Morass"] = "La Ciénaga Negra"
L["Black Rook Hold"] = "Bastión Nocturno"
L["Black Temple"] = "Templo Oscuro"
L["Blackfathom Deeps"] = "Cavernas de Brazanegra"
L["Blackrock Caverns"] = "Cavernas Roca Negra"
L["Blackrock Depths"] = "Profundidades de Roca Negra"
L["Blackrock Foundry"] = "Fragua Roca Negra"
L["Blackrock Mountain"] = "Montaña Roca Negra"
L["Blackrock Spire"] = "Cumbre de Roca Negra"
L["Blackwing Descent"] = "Descenso de Alanegra"
L["Blackwing Lair"] = "Guarida de Alanegra"
L["Blade Tooth Canyon"] = "Cañón Colmillo Cortante"
L["Blade's Edge Mountains"] = "Montañas Filospada"
L["Blades' Run"] = "Carrera de las Cuchillas"
L["Blasted Lands"] = "Las Tierras Devastadas"
L["Blood Watch"] = "Avanzada de Sangre"
L["Bloodhoof Village"] = "Poblado Pezuña de Sangre"
L["Bloodmaul Slag Mines"] = "Minas de Escoria Machacasangre"
L["Bloodmyst Isle"] = "Isla Bruma de Sangre"
L["Bloodvenom Post"] = "Puesto del Veneno"
L["Bloodwatcher Point"] = "Paso de Mirasangre"
L["Blue"] = "Azul"
L["Boat to"] = "Barco a"
L["Bogpaddle"] = "Chapaleos"
L["Bootlegger Outpost"] = "Avanzada del Contrabandista"
L["Booty Bay"] = "Bahía del Botín"
L["Borean Tundra"] = "Tundra Boreal"
L["Bor'gorok Outpost"] = "Avanzada Bor'gorok"
L["Bouldercrag's Refuge"] = "Refugio de Peñapedriza"
L["Brackenhide Hollow"] = "Ocaso Teñidoférreo"
L["Brackenwall Village"] = "Poblado Murohelecho"
L["Brill"] = "Rémol"
L["Burning Crusade Classic"] = "Burning Crusade Clásico"
L["Burning Steppes"] = "Las Estepas Ardientes"
L["Camp Ataya"] = "Campamento Ataya"
L["Camp Everstill"] = "Campamento Sempiterno"
L["Camp Mojache"] = "Campamento Mojache"
L["Camp Oneqwah"] = "Campamento Oneqwah"
L["Camp Taurajo"] = "Campamento Taurajo"
L["Camp Tunka'lo"] = "Campamento Tunka'lo"
L["Camp Winterhoof"] = "Campamento Pezuña Invernal"
L["Cannot be used with Use default map."] = "No se puede usar con el mapa predeterminado."
L["Cannot be used with Use default map.|n|nTo adjust map opacity, right-click the map frame title bar."] = "No se puede usar con el mapa predeterminado.|n|nPara ajustar la opacidad del mapa, haz clic derecho en la barra de título del marco del mapa."
L["Castle Nathria"] = "Castillo de Nathria"
L["Cathedral"] = "Catedral"
L["Cathedral of Eternal Night"] = "Catedral de la Noche Eterna"
L["Caverns of Time"] = "Cavernas del Tiempo"
L["Cenarion Hold"] = "Fuerte Cenarion"
L["Center map on player"] = "Centrar en jugador"
L["Central Mesa"] = "Meseta Central"
L["Chamber of Heart"] = "Cámara del Corazón"
L["Chillwind Camp"] = "Campamento del Orvallo"
L["Chiselgrip"] = "Cincelada"
L["Choose where the zone map should be shown."] = "Elija dónde se debe mostrar el mapa de zonas."
L["Class colored icons"] = "Iconos coloreados"
L["Classic"] = "Clásico"
L["Click to configure the settings for this option."] = "Haz clic para configurar esta opción."
L["Click to reset the position and scale of the map frame."] = "Haz clic para restablecer la posición y la escala del marco del mapa."
L["Click to reset the settings on this page."] = "Haz clic para restablecer la configuración en esta página."
L["Click to return to the main menu."] = "Haz clic para volver al menú principal."
L["Cliffwalker Post"] = "Puesto Caminarrisco"
L["Coilfang Reservoir"] = "Reserva Colmillo Torcido"
L["Coldarra"] = "Frondavil"
L["Configuration Panel"] = "Panel de Configuración"
L["Conquest Hold"] = "Bastión de la Conquista"
L["Cosmic"] = "Cósmico"
L["Cosmowrench"] = "Cosmotirón"
L["Court of Stars"] = "Corte de las Estrellas"
L["Crucible of Storms"] = "Crisol de Tormentas"
L["Crusaders' Pinnacle"] = "Pináculo de los Cruzados"
L["Crushblow"] = "Machacolpe"
L["Crystalsong Forest"] = "Bosque Canto de Cristal"
L["Culling of Stratholme"] = "Matanza de Stratholme"
L["Cursor"] = "Cursor"
L["Dalaran"] = "Dalaran"
L["Dalaran Crater"] = "Cráter de Dalaran"
L["Darkbreak Cove"] = "Cala Brechaoscura"
L["Darkheart Thicket"] = "Sotobosque Corazón Oscuro"
L["Darkshire"] = "Villa Oscura"
L["Darkshore"] = "Costa Oscura"
L["Darnassus"] = "Darnassus"
L["De Other Side"] = "El Otro Lado"
L["Deadwind Pass"] = "Paso de la Muerte"
L["Death's Rise"] = "Alto de la Muerte"
L["Debug"] = "Depuración"
L["Deepholm"] = "Infralar"
L["Desolace"] = "Desolace"
L["Desolation Hold"] = "Bastión de la Desolación"
L["Dire Maul (East)"] = "La Masacre (Este)"
L["Dire Maul (East) (side entrance)"] = "La Masacre (Este) (entrada lateral)"
L["Dire Maul (East): Warpwood Quarter"] = "La Masacre (Este): Barrio Alabeo"
L["Dire Maul (North)"] = "La Masacre (Norte)"
L["Dire Maul (North): Gordok Commons"] = "Hache-Tripes (Nord) : Communs gordok"
L["Dire Maul (West)"] = "La Masacre (Oeste)"
L["Dire Maul (West): Capital Gardens"] = "La Masacre (Oeste): Jardines de la Capital"
L["Dire Maul: Capital Gardens"] = "La Masacre: Jardines Capitales"
L["Dire Maul: Gordok Commons"] = "La Masacre: Comunes Gordok"
L["Dire Maul: Warpwood Quarter"] = "La Masacre: Distrito Maderahelecho"
L["Disable map fade"] = "Desactivar desvanecimiento del mapa"
L["Disable reading emote"] = "Desactivar lectura de emoticonos"
L["Disable reading emote when opening the map"] = "Deshabilita la lectura de emoticones al abrir el mapa"
L["disabled"] = "deshabilitado"
L["Dolanaar"] = "Dolanaar"
L["Drag"] = "Arrastrar"
L["Drag to set the amount of blue."] = "Arrastra para establecer la cantidad de azul."
L["Drag to set the amount of green."] = "Arrastra para establecer la cantidad de verde."
L["Drag to set the amount of red."] = "Arrastra para establecer la cantidad de rojo."
L["Drag to set the battlefield map opacity."] = "Arrastra para establecer la opacidad del mapa de campo de batalla."
L["Drag to set the battlefield map size."] = "Arrastra para establecer el tamaño del mapa del campo de batalla."
L["Drag to set the battlefield map size.|n|nIf the map is unlocked, you can also resize the battlefield map by dragging the bottom-right corner."] = "Arrastra para establecer el tamaño del mapa del campo de batalla.|n|nSi el mapa está desbloqueado, también puedes cambiar el tamaño del mapa del campo de batalla arrastrando la esquina inferior derecha."
L["Drag to set the group icon size."] = "Arrastra para establecer el tamaño del icono de grupo."
L["Drag to set the map opacity for when your character is moving."] = "Arrastra para establecer la opacidad del mapa para cuando su personaje se esté moviendo."
L["Drag to set the map opacity for when your character is stationary."] = "Arrastra para establecer la opacidad del mapa para cuando su personaje esté estacionario."
L["Drag to set the maximum zoom level.|n|nOpen the battlefield map to see the maximum zoom level change as you drag the slider."] = "Arrastra para establecer el nivel de zoom máximo.|n|nAbre el mapa del campo de batalla para ver cómo cambia el nivel de zoom máximo a medida que arrastras el control deslizante."
L["Drag to set the maximum zoom level.|n|nOpen the map to see the maximum zoom level change as you drag the slider."] = "Arrastra para establecer el nivel de zoom máximo.|n|nAbra el mapa para ver cómo cambia el nivel de zoom máximo a medida que arrastra el control deslizante."
L["Drag to set the opacity."] = "Arrastra para establecer la opacidad."
L["Drag to set the player arrow size."] = "Arrastra para establecer el tamaño de la flecha del jugador."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "Arrastra para establecer el tamaño de la flecha del jugador.|n|nEl valor predeterminado de WoW Classic es 16.|nEl valor predeterminado de WoW Retail es 27."
L["Drag to set the scale for the maximised map."] = "Arrastra para ajustar la escala del mapa maximizado."
L["Drag to set the scale for the windowed map."] = "Arrastra para ajustar la escala del mapa en ventana."
L["Drag to set the world map scale.|n|nYou can also rescale the world map by dragging the bottom-right corner."] = "Arrastra para establecer la escala del mapa mundial.|n|nTambién puedes cambiar la escala del mapa mundial arrastrando la esquina inferior derecha."
L["Dragon Soul"] = "Alma de Dragón"
L["Dragonblight"] = "Cementerio de Dragones"
L["Dragonmaw Port"] = "Puerto Faucedraco"
L["Dragon's Mouth"] = "Boca del Dragón"
L["Drak'Tharon Keep"] = "Fortaleza de Drak'Tharon"
L["Dreadmaul Hold"] = "Bastión Machacamiedo"
L["Dreamer's Rest"] = "Reposo de la Soñadora"
L["Druid only flight point to Darnassus"] = "Punto de vuelo a Darnassus sólo para druidas"
L["Druid only flight point to Thunder Bluff"] = "Punto de vuelo a Cima del Trueno sólo para druidas"
L["Dun Algaz"] = "Dun Algaz"
L["Dun Modr"] = "Dun Modr"
L["Dun Morogh"] = "Dun Morogh"
L["Dun Nifflelem"] = "Dun Niffelem"
L["Dungeon"] = "Calabozo"
L["Dungeon (requires Crescent Key)"] = "Calabozo (requiere Llave creciente)"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Bosque del Ocaso"
L["Dustwallow Marsh"] = "Marjal Revolcafango"
L["Dustwind Dig"] = "Excavación Viento Seco"
L["Dwarven District"] = "Distrito de los Enanos"
L["Eastern Earthshrine"] = "Santuario Oriental de la Tierra"
L["Eastern Plaguelands"] = "Tierras de la Peste del Este"
L["Eastpoint Tower"] = "Torre Oriental"
L["Eastvale Logging Camp"] = "Aserradero de la Vega del Este"
L["Ebon Watch"] = "Vigía Ébano"
L["Elements"] = "Visibilidad"
L["Elwynn Forest"] = "Bosque de Elwynn"
L["Emerald Dream"] = "Sueño Esmeralda"
L["Emerald Sanctuary"] = "Santuario Esmeralda"
L["enabled"] = "habilitado"
L["End Time"] = "Fin de los Tiempos"
L["Enhance battlefield map"] = "Mapa de campo de batalla"
L["Enhance dungeon icons"] = "Mejorar iconos de calabozo"
L["Enlarge player arrow"] = "Flecha de jugador"
L["Enter"] = "Escribe"
L["Ethel Rethor"] = "Ethel Rethor"
L["Evergrove"] = "Soto Eterno"
L["Everlook"] = "Vista Eterna"
L["Evermoon Terrace"] = "Terraza Siemprehelada"
L["Eversong Woods"] = "Bosque Canción Eterna"
L["Exile's Hollow"] = "Escondrijo del Exiliado"
L["Exodar"] = "El Exodar"
L["Explorer's League Digsite"] = "Excavación de la Liga de Expedicionarios"
L["Eye of Azshara"] = "Ojo de Azshara"
L["Fairbreeze Village"] = "Aldea Brisa Pura"
L["Falanaar"] = "Falanaar"
L["Falcon Watch"] = "Avanzada del Halcón"
L["Falconwing Square"] = "Plaza Alalcón"
L["Faldir's Cove"] = "Cala de Faldir"
L["Feathermoon Stronghold"] = "Bastión Plumaluna"
L["Felsoul Hold"] = "Bastión Alma Vil"
L["Felwood"] = "Frondavil"
L["Feralas"] = "Feralas"
L["Firebeard's Patrol"] = "Patrulla de Barbafuego"
L["Firelands"] = "Tierras de Fuego"
L["Fishing"] = "Pesca"
L["Fizzcrank Airstrip"] = "Aeródromo Trinquete"
L["Fizzle & Pozzik's Speedbarge"] = "Barcódromo de Fizzle y Pozzik"
L["Flame Crest"] = "Peñasco Llamarada"
L["Flamestar Post"] = "Puesto Llamaestrella"
L["Flayedwing Transporter"] = "Transportador Ala Desgarrada"
L["Follow the eastward path"] = "Sigue el camino hacia el este"
L["Follow the westward path"] = "Sigue el camino hacia el oeste"
L["Fordragon Hold"] = "Fortaleza Fordragón"
L["Forest Song"] = "Canción del Bosque"
L["Fort Livingston"] = "Fuerte Livingston"
L["Fort Wildervar"] = "Fortaleza Varabarba"
L["Freehold"] = "Fuerte Libre"
L["Freewind Post"] = "Poblado Viento Libre"
L["Frosthold"] = "Bastión de Escarcha"
L["Fuselight"] = "El Diodo"
L["Gadgetzan"] = "Gadgetzan"
L["Garadar"] = "Garadar"
L["Gate of the Setting Sun"] = "Puerta del Sol Poniente"
L["Gates of Valor"] = "Puertas del Valor"
L["Ghostlands"] = "Tierras Fantasma"
L["Gnomeregan"] = "Gnomeregan"
L["Gol'Bolar Quarry"] = "Cantera de Gol'Bolar"
L["Goldshire"] = "Villadorada"
L["Graveyard"] = "Cementerio"
L["Green"] = "Verde"
L["Grim Batol"] = "Grim Batol"
L["Grimrail Depot"] = "Depósito de Vías Férreas Sombrías"
L["Grizzly Hills"] = "Colinas Pardas"
L["Grom'arsh Crash Site"] = "Lugar del Accidente de Grom'arsh"
L["Grom'gol"] = "Grom'gol"
L["Grom'gol Base Camp"] = "Campamento Grom'gol"
L["Group Icons"] = "Iconos de grupo"
L["Grove of Aessina"] = "Arboleda de Aessina"
L["Grove of the Ancients"] = "Páramo de los Ancianos"
L["Gruul's Lair"] = "Guarida de Gruul"
L["Gundrak"] = "Gundrak"
L["Gundrak (rear entrance)"] = "Gundrak (entrada trasera)"
L["Hall of Ancient Paths"] = "Sala de los Caminos Ancestrales"
L["Halls of Atonement"] = "Salones de la Expiación"
L["Halls of Infusion"] = "Salones de la Infusión"
L["Halls of Lightning"] = "Salones Relámpago"
L["Halls of Origination"] = "Salones de la Creación"
L["Halls of Stone"] = "Salones de Piedra"
L["Halls of Valor"] = "Salones del Valor"
L["Hammerfall"] = "Sentencia"
L["Hardwrench Hideaway"] = "Escondrijo Malallave"
L["Head down the mountain from here."] = "Dirígete hacia abajo desde la montaña aquí."
L["Head southeast from here and go up the mountain."] = "Dirígete al sureste desde aquí y sube la montaña."
L["Heart of Fear"] = "Corazón del Miedo"
L["Hearthglen"] = "Vega del Amparo"
L["Hellfire Citadel"] = "Ciudadela del Fuego Infernal"
L["Hellfire Peninsula"] = "Península del Fuego Infernal"
L["Hellfire Ramparts"] = "Murallas del Fuego Infernal"
L["Hellscream's Watch"] = "Avanzada Grito Infernal"
L["Hide filter reset button"] = "Ocultar botón de restablecimiento del filtro"
L["Hide town and city icons"] = "Pueblos y ciudades"
L["Highbank"] = "Bancalto"
L["Highmaul"] = "Alto de Marea"
L["Hillsbrad Foothills"] = "Laderas de Trabalomas"
L["Honor Hold"] = "Bastión del Honor"
L["Honor's Stand"] = "El Alto del Honor"
L["Horde Cities"] = "Ciudades de la Horda"
L["Hour of Twilight"] = "Hora del Crepúsculo"
L["Howling Fjord"] = "Fiordo Aquilonal"
L["Hunter's Hill"] = "Cerro del Cazador"
L["Hyjal"] = "Hyjal"
L["Hyjal Summit"] = "La Cima Hyjal"
L["Icecrown"] = "Corona de Hielo"
L["Icecrown Citadel"] = "Ciudadela de la Corona de Hielo"
L["Icons"] = "Iconos"
L["If checked, additional icons (such as portals) will be shown."] = "Si está seleccionado, se mostrarán iconos adicionales (como portales)."
L["If checked, archaeology digsites will be shown."] = "Si está seleccionado, se mostrarán los sitios de excavación arqueológica."
L["If checked, coordinates will be shown."] = "Si está seleccionado, se mostrarán las coordenadas."
L["If checked, coordinates will have a dark background texture."] = "Si está seleccionado, las coordenadas tendrán un fondo oscuro."
L["If checked, coordinates will use a large font."] = "Si está seleccionado, las coordenadas usarán una fuente grande."
L["If checked, dungeons and raids will be shown."] = "Si está seleccionado, se mostrarán calabozos y bandas."
L["If checked, group icons will use a modern, class-colored design."] = "Si está seleccionado, los iconos de grupo usarán un diseño moderno, de color de clase."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "Si está seleccionado, al abrir el mapa se usará el mismo nivel de zoom desde la última vez que lo cerró, siempre que la zona del mapa no haya cambiado."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "Si está seleccionado, apuntar al mapa mientras tu personaje se mueve hará que se aplique la configuración de opacidad estacionaria."
L["If checked, points of interest will be shown."] = "Si está seleccionado, se mostrarán puntos de interés."
L["If checked, quest objectives will be shown."] = "Si está seleccionado, se mostrarán los objetivos de misión."
L["If checked, spirit healers will be shown."] = "Si está seleccionado, se mostrarán los Ángeles de la Resurrección."
L["If checked, the battlefield map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Si está seleccionado, el mapa del campo de batalla permanecerá centrado en tu ubicación siempre que no estés en un calabozo.|n|nPuedes mantener presionada la tecla mayús mientras desplazas el mapa para evitar que se centre temporalmente."
L["If checked, the default fullscreen map will be used for the maximised map.|n|nNote that enabling this option will lock out some of the other options."] = "Si está seleccionado, se usará el mapa predeterminado a pantalla completa para el mapa maximizado.|n|nTen en cuenta que activar esta opción bloqueará algunas de las otras opciones."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "Si está seleccionado, se usará el mapa predeterminado de pantalla completa.|n|nTenga en cuenta que habilitar esta opción bloqueará algunas de las otras opciones."
L["If checked, the map border will be removed."] = "Si está seleccionado, se eliminará el borde del mapa."
L["If checked, the map frame will remain open until you close it."] = "Si está seleccionado, el marco del mapa permanecerá abierto hasta que lo cierres."
L["If checked, the map will not fade while your character is moving."] = "Si está seleccionado, el mapa no se desvanecerá mientras tu personaje esté en movimiento."
L["If checked, the map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Si está seleccionado, el mapa permanecerá centrado en tu ubicación siempre que no estés en un calabozo.|n|nPuedes mantener presionada la tecla mayús mientras desplazas el mapa para evitar que se centre temporalmente."
L["If checked, the minimap button will be shown."] = "Si está seleccionado, se mostrará el botón del minimapa."
L["If checked, the minimum fishing skill levels will be shown."] = "Si está seleccionado, se mostrarán los niveles mínimos de habilidad de pesca."
L["If checked, the world map filter reset button will be hidden."] = "Si está seleccionado, el botón de restablecer filtro del mapa del mundo se ocultará."
L["If checked, town and city icons will not be shown on the continent maps."] = "Si está seleccionado, los iconos de pueblos y ciudades no se mostrarán en los mapas de continentes."
L["If checked, travel points for the opposing faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Si está seleccionado, se mostrarán los puntos de viaje de la facción contraria.|n|nEsto incluye puntos de vuelo, puertos para barcos, torres de zepelín y estaciones de tranvía."
L["If checked, travel points for the same faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Si está seleccionado, se mostrarán los puntos de viaje para la misma facción.|n|nEsto incluye puntos de vuelo, puertos para barcos, torres de zepelín y estaciones de tranvía."
L["If checked, unexplored areas of the map will be shown on the world map and the battlefield map."] = "Si está seleccionado, las áreas inexploradas del mapa se mostrarán en el mapa del mundo y en el mapa del campo de batalla."
L["If checked, unexplored areas will be tinted."] = "Si está seleccionado, las áreas inexploradas se teñirán."
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "Si está seleccionado, cuando tu personaje cambia de zona, el mapa cambiará automáticamente a la nueva zona."
L["If checked, you can move the battlefield map by dragging any of its borders."] = "Si está seleccionado, puedes mover el mapa del campo de batalla arrastrando cualquiera de sus bordes."
L["If checked, you can move the battlefield map by dragging any of its borders.|n|nYou can resize the battlefield map by dragging the bottom-right corner."] = "Si está seleccionado, puedes mover el mapa del campo de batalla arrastrando cualquiera de sus bordes.|n|nPuedes cambiar el tamaño del mapa del campo de batalla arrastrando la esquina inferior derecha."
L["If checked, you will be able to customise the battlefield map."] = "Si está seleccionado, se podrá personalizar el mapa del campo de batalla."
L["If checked, you will be able to enlarge the player arrow."] = "Si está seleccionado, se podrá ampliar la flecha del jugador."
L["If checked, you will be able to move the frame by dragging the border."] = "Si está seleccionado, podrás mover el marco arrastrando el borde."
L["If checked, you will be able to move the map.|n|nThe map position will be saved separately for the maximised and windowed maps."] = "Si está seleccionado, podrás mover el mapa.|n|nLa posición del mapa se guardará por separado para los mapas maximizados y en ventana."
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges."] = "Si está seleccionado, se podrá escalar y mover el mapa.|n|nEscala el mapa arrastrando el controlador de escala en la esquina inferior derecha.|n|nMueve el mapa arrastrando el borde y los bordes del marco."
L["If checked, you will be able to scale the map by dragging the scale handle in the bottom-right corner.|n|nYou will be able to move the map by dragging any border.|n|nYou can always drag the top border to move the map regardless of this setting."] = "Si está seleccionado, podrás cambiar la escala del mapa arrastrando la manija de escala en la esquina inferior derecha.|n|nPuedes mover el mapa arrastrando cualquier borde.|n|nSiempre puedes arrastrar el borde superior para mover el mapa independientemente de esta configuración."
L["If checked, you will be able to scale the map."] = "Si está seleccionado, podrás escalar el mapa."
L["If checked, you will be able to set the opacity of the map."] = "Si está seleccionado, se podrá establecer la opacidad del mapa."
L["If checked, you will be able to zoom further into the world map."] = "Si está seleccionado, se podrá hacer zoom más en el mapa del mundo."
L["If checked, your character will not perform the reading emote when you open the map."] = "Si está seleccionado, tu personaje no realizará la emoción de lectura al abrir el mapa."
L["If checked, zone and continent dropdown menus will be shown in the map frame."] = "Si está seleccionado, se mostrarán los menús desplegables de zona y continente en el marco del mapa."
L["If checked, zone and dungeon levels will be shown."] = "Si está seleccionado, se mostrarán los niveles de zona y calabozos."
L["If checked, zone crossings will be shown.|n|nThese are clickable arrows that indicate the zone exit pathways."] = "Si está seleccionado, se mostrarán los cruces de zona.|n|nEstas son flechas en las que se puede hacer clic que indican las vías de salida de la zona."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "Si está seleccionado, se mostrarán los niveles de zona, calabozo y habilidad de pesca."
L["Increase zoom level"] = "Aumentar nivel de zoom"
L["Invalid command.  Enter /ltm help for help."] = "Comando inválido. Escribe /ltm help para obtener ayuda."
L["Invalid map ID."] = "ID de mapa inválido."
L["Iron Docks"] = "Darsena de Hierro"
L["Iron Summit"] = "Cima de Hierro"
L["Ironforge"] = "Forjaz"
L["Isle of Quel'Danas"] = "Isla de Quel'Danas"
L["Just follow the path west"] = "Sigue el camino hacia el oeste"
L["K3"] = "K3"
L["Kamagua"] = "Kamagua"
L["Karazhan"] = "Karazhan"
L["Kargath"] = "Kargath"
L["Kelp'thar Forest"] = "Bosque Kelp'thar"
L["Kharanos"] = "Kharanos"
L["Kings' Rest"] = "Reposo de los Reyes"
L["Kirthaven"] = "Kirthaven"
L["Kor'kron Vanguard"] = "Vanguardia Kor'kron"
L["Krom'gar Fortress"] = "Fortaleza Krom'gar"
L["Lake Elune'ara"] = "Lago Elune'ara"
L["Lake Everstill"] = "Lago Sempiterno"
L["Lakeshire"] = "Villa del Lago"
L["Large Scarab Coffer"] = "Arca del escarabajo grande"
L["Leads to Tirisfal Glades"] = "Conduce a Claros de Tirisfal"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS: ¡VERSIÓN INCORRECTA INSTALADA!"
L["Library"] = "Biblioteca"
L["Light's Breach"] = "Brecha de la Luz"
L["Light's Hope Chapel"] = "Capilla de la Esperanza de la Luz"
L["Lion's Watch"] = "Vigilia del León"
L["Loch Modan"] = "Loch Modan"
L["Lor'danel"] = "Lor'danel"
L["Lost City of the Tol'vir"] = "Ciudad Perdida de los Tol'vir"
L["Lower Blackrock Spire"] = "Cumbre de Roca Negra Inferior"
L["Lunastre Estate"] = "Hacienda Lunastre"
L["Magisters' Terrace"] = "Bancal del Magister"
L["Magtheridon's Lair"] = "Guarida de Magtheridon"
L["Malaka'jin"] = "Malaka'jin"
L["Mana-Tombs"] = "Tumbas de Maná"
L["Map frame scale"] = "Escala del marco del mapa"
L["Map Opacity"] = "Opacidad de mapa"
L["Map Scale"] = "Escala del mapa"
L["Map Size"] = "Tamaño de mapa"
L["Maraudon"] = "Maraudon"
L["Maraudon: Earth Song Falls"] = "Maraudon: Cascadas Canto de la Tierra"
L["Maraudon: Foulspore Cavern"] = "Maraudon: Caverna Espora Vil"
L["Maraudon: The Wicked Grotto"] = "Maraudon: La Gruta Perversa"
L["Marshal's Refuge"] = "Refugio de Marshal"
L["Marshtide Watch"] = "Avanzada Marea Pantanosa"
L["Maw of Souls"] = "Fauce de Almas"
L["Max Zoom"] = "Zoom máximo"
L["Maximised"] = "Maximizado"
L["Maximum"] = "Máximo"
L["Mechanics"] = "Mecánicas"
L["Memory Usage"] = "Uso de memoria"
L["Menethil Harbor"] = "Puerto de Menethil"
L["Mirkfallon Post"] = "Puesto Mirkfallon"
L["Miscellaneous"] = "Miscelánea"
L["Mists of Tirna Scithe"] = "Nieblas de Tirna Scithe"
L["Moa'ki"] = "Moa'ki"
L["Moa'ki Harbor"] = "Puerto de Moa'ki"
L["Mogu'shan Palace"] = "Palacio Mogu'shan"
L["Mogu'shan Vaults"] = "Cámaras Mogu'shan"
L["Mok'Nathal Village"] = "Aldea Mok'Nathal"
L["Molten Core"] = "Núcleo de Magma"
L["Moon Guard Stronghold"] = "Bastión Guardia Lunar"
L["Moonbrook"] = "Arroyo de la Luna"
L["Moonglade"] = "Claro de la Luna"
L["More"] = "Otro"
L["Morgan's Vigil"] = "Vigilia de Morgan"
L["Mossy Pile"] = "Pilote Musgoso"
L["Mount Crafting"] = "Creación de Monturas"
L["Mount Hyjal"] = "Monte Hyjal"
L["Mountain Pass (Horde Only)"] = "Paso de Montaña (Solo Horda)"
L["Moving"] = "Movimiento"
L["Mudsprocket"] = "Piñón de Barro"
L["Mulgore"] = "Mulgore"
L["Nagrand"] = "Nagrand"
L["Naxxramas"] = "Naxxramas"
L["Nazjatar"] = "Nazjatar"
L["Neltharion's Lair"] = "Guarida de Neltharion"
L["Neltharus"] = "Neltharus"
L["Nesingwary Base Camp"] = "Campamento Base de Nesingwary"
L["Nethergarde Keep"] = "Castillo de Nethergarde"
L["Netherstorm"] = "Tormenta Abisal"
L["Never"] = "Nunca"
L["New Agamand"] = "Nuevo Agamand"
L["New Kargath"] = "Nuevo Kargath"
L["Nighthaven"] = "Amparo de la Noche"
L["Nijel's Point"] = "Punta de Nijel"
L["Nordrassil"] = "Nordrassil"
L["North"] = "Norte"
L["North Gate Pass"] = "Paso de la Puerta Norte"
L["Northwatch Hold"] = "Fuerte del Norte"
L["Ny'alotha, The Waking City"] = "Ny'alotha, La Ciudad Despierta"
L["Oasis of Vir'sar"] = "Oasis de Vir'sar"
L["Ohn'ahran Plains"] = "Llanuras de Ohn'ahra"
L["Old Hillsbrad"] = "Antiguo Hillsbrad"
L["Old Hillsbrad Foothills"] = "Antiguas Laderas de Trabalomas"
L["Onyxia's Lair"] = "Guarida de Onyxia"
L["Opacity"] = "Opacidad"
L["Operation: Mechagon"] = "Operación: Mecagon"
L["or click the minimap button to open Leatrix Maps."] = "o haz clic en el botón del minimapa para abrir Leatrix Maps."
L["Orb of Translocation"] = "Orbe de Translocación"
L["Orebor Harborage"] = "Puerto Orebor"
L["Orgrimmar"] = "Orgrimmar"
L["Oribos"] = "Oribos"
L["Pet Crafting"] = "Creación de Mascotas"
L["Plaguefall"] = "Mazmorra Pestescaída"
L["Plaguewood Tower"] = "Torre del Bosque de la Peste"
L["Player"] = "Jugador"
L["Player Arrow"] = "Flecha de jugador"
L["Portal"] = "Portal"
L["Portal from Zephyr"] = "Portal de Céfiro"
L["Portals"] = "Portales"
L["Preview"] = "Prevista"
L["Protoform Repository"] = "Repositorio Protoforma"
L["Ragefire Chasm"] = "Sima Ígnea"
L["Raid"] = "Banda"
L["Ramkahen"] = "Ramkahen"
L["Ratchet"] = "Trinquete"
L["Raven Hill"] = "Cerro del Cuervo"
L["Ravenholdt Manor"] = "Mansión Ravenholdt"
L["Razor Hill"] = "Cerrotajo"
L["Razorfen Downs"] = "Zahúrda Rajacieno"
L["Razorfen Kraul"] = "Horado Rajacieno"
L["Razorthorn Trail"] = "Senda Espina Afilada"
L["Rebel Camp"] = "Asentamiento Rebelde"
L["Red"] = "Rojo"
L["Redridge Mountains"] = "Montañas Crestagrana"
L["Refuge Pointe"] = "Refugio de la Zaga"
L["Reload"] = "Recargar"
L["Remember zoom level"] = "Recordar nivel de zoom"
L["Remove map border"] = "Borde del mapa"
L["req"] = "req"
L["Requires Key to Searing Gorge"] = "Requiere Llave de la Garganta de Fuego"
L["Requires UI reload."] = "Requiere recargar la IU"
L["Reset"] = "Restablecer"
L["Reset Map Layout"] = "Restablecer diseño del mapa"
L["Return to Karazhan"] = "Volver a Karazhan"
L["Revantusk Village"] = "Poblado Sañadiente"
L["River's Heart"] = "Corazón del Río"
L["Ruby Life Pools"] = "Charcos de Vida Rubí"
L["Ruins of Ahn'Qiraj"] = "Ruinas de Ahn'Qiraj"
L["Ruins of Elune'eth"] = "Ruinas de Elune'eth"
L["Rut'Theran Village"] = "Poblado Rut'theran"
L["Rut'theran Village"] = "Aldea Rut'theran"
L["Sanctuary"] = "Santuario"
L["Sanctuary of Malorne"] = "Santuario de Malorne"
L["Sanctum of Domination"] = "Sacrario de la Dominación"
L["Sanctum of Order"] = "Sacrario del Orden"
L["Sanctum of the Sages"] = "Sacrario de los Sabios"
L["Sanctum of the Stars"] = "Sagrario de las Estrellas"
L["Sanguine Depths"] = "Profundidades Sanguinas"
L["Scale"] = "Escala"
L["Scale the map"] = "Escalar el mapa"
L["Scarlet Halls"] = "Salas Escarlata"
L["Scarlet Monastery"] = "Monasterio Escarlata"
L["Schnottz's Landing"] = "Embarcadero de Schnottz"
L["Scholomance"] = "Scholomance"
L["Searing Gorge"] = "La Garganta de Fuego"
L["Seat of the Naaru"] = "Asiento de los Naaru"
L["Seat of the Triumvirate"] = "Asiento del Triunvirato"
L["Sen'jin Village"] = "Poblado Sen'jin"
L["Sentinel Hill"] = "Colina del Centinela"
L["Sepulcher of the First Ones"] = "Sepulcro de los Primogénitos"
L["Serpentshrine Cavern"] = "Caverna Santuario Serpiente"
L["Set map opacity"] = "Opacidad del mapa"
L["Set map opacity while stationary and while moving."] = "Establece la opacidad del mapa mientras está parado y en movimiento."
L["Set the group icon size."] = "Establece el tamaño del icono de grupo."
L["Set the maximum zoom scale."] = "Establece la escala de zoom máxima."
L["Set the player arrow size."] = "Establece el tamaño de la flecha del jugador."
L["Sethekk Halls"] = "Salas Sethekk"
L["Settings"] = "Configuración"
L["Sewers"] = "Cloacas"
L["Shadebough"] = "Ramasombría"
L["Shado-Pan Monastery"] = "Monasterio del Shadopan"
L["Shadow Labyrinth"] = "Laberinto de las Sombras"
L["Shadowfang Keep"] = "Castillo de Colmillo Oscuro"
L["Shadowlands"] = "Tierras de las Sombras"
L["Shadowmoon Burial Grounds"] = "Cementerio Sombraluna"
L["Shadowmoon Valley"] = "Valle Sombraluna"
L["Shadowmoon Village"] = "Aldea Sombraluna"
L["Shadowprey Village"] = "Aldea Cazasombras"
L["Shal'Aran"] = "Shal'Aran"
L["Shalewind Canyon"] = "Cañón del Viento Calizo"
L["Shatter Point"] = "Punto de Ruptura"
L["Shattrath"] = "Shattrath"
L["Shattrath City"] = "Ciudad de Shattrath"
L["Shimmering Expanse"] = "Extensión Bruñida"
L["Sholazar Basin"] = "Cuenca de Sholazar"
L["Show additional icons"] = "Mostrar iconos adicionales"
L["Show background"] = "Mostrar fondo"
L["Show boats, zeppelins and trams"] = "Mostrar barcos, zepelines y tranvías"
L["Show coordinates"] = "Coordenadas"
L["Show digsites"] = "Mostrar sitios de excavación arqueológica"
L["Show dungeons and raids"] = "Mostrar calabozos y bandas"
L["Show minimap button"] = "Botón del minimapa"
L["Show minimum fishing skill levels"] = "Mostrar nivel mínimo de habilidad de pesca"
L["Show objectives"] = "Mostrar objetivos"
L["Show points of interest"] = "Puntos de interés"
L["Show scale handle"] = "Mostrar asa de escala"
L["Show spirit healers"] = "Mostrar Ángel de la Resurrección"
L["Show travel points for opposing faction"] = "Mostrar puntos de viaje para la facción contraria"
L["Show travel points for same faction"] = "Mostrar puntos de viaje para la misma facción"
L["Show unexplored areas"] = "Áreas inexploradas"
L["Show zone crossings"] = "Mostrar cruces de zona"
L["Show zone levels"] = "Nivel de zona"
L["Show zone menus"] = "Mostrar menús de zona"
L["Shrine of Aviana"] = "Santuario de Aviana"
L["Shrine of the Storm"] = "Santuario de la Tormenta"
L["Side entrance"] = "Entrada lateral"
L["Siege of Boralus"] = "Asedio de Boralus"
L["Siege of Niuzao Temple"] = "Asedio del Templo de Niuzao"
L["Siege of Orgrimmar"] = "Asedio de Orgrimmar"
L["Silithus"] = "Silithus"
L["Silver Tide Hollow"] = "Cuenca de Marea Argenta"
L["Silvermoon"] = "Entrañas"
L["Silvermoon City"] = "Ciudad de Lunargenta"
L["Silverpine Forest"] = "Bosque de Argénteos"
L["Silverwind Refuge"] = "Refugio Brisa de Plata"
L["Skyreach"] = "Cumbre Celestial"
L["Slave Pens"] = "Recinto de los Esclavos"
L["Sludgewerks"] = "Los Fangados"
L["South"] = "Sur"
L["South Gate Pass"] = "Paso de la Puerta Sur"
L["Southern Barrens"] = "Los Baldíos del Sur"
L["Southfury River"] = "Río Furia del Sur"
L["Southshore"] = "Costasur"
L["Spinebreaker Ridge"] = "Cresta Rompeloma"
L["Spires of Ascension"] = "Agujas de Ascensión"
L["Spirit Healer"] = "Ángel de la Resurrección"
L["Splintertree Post"] = "Puesto del Hachazo"
L["Stardust Spire"] = "Aguja del Polvo Estelar"
L["Stars' Rest"] = "Reposo de las Estrellas"
L["Stationary"] = "Estacionario"
L["Steamvault"] = "La Cámara de Vapor"
L["Sticky map frame"] = "Mapa pegajoso"
L["Stonard"] = "Rocal"
L["Stonebreaker Hold"] = "Bastión Rompepedras"
L["Stonemaul Hold"] = "Bastión Quebrantarrocas"
L["Stonetalon Mountains"] = "Sierra Espolón"
L["Stonetalon Peak"] = "Cima del Espolón"
L["Stormstout Brewery"] = "Cervecería del Trueno"
L["Stormwind"] = "Ventormenta"
L["Stormwind City"] = "Ciudad de Ventormenta"
L["Strahnbrad"] = "Strahnbrad"
L["Stranglethorn Vale"] = "Vega de Tuercespina"
L["Stratholme (Main Gate)"] = "Stratholme (Entrada Principal)"
L["Stratholme (Service Gate)"] = "Stratholme (Entrada de Servicio)"
L["Stratholme: Crusader's Square"] = "Stratholme: Plaza del Cruzado"
L["Stratholme: The Gauntlet"] = "Stratholme: La Prueba"
L["Stygian Bounty"] = "Recompensa Estigia"
L["sum"] = "invo"
L["Sun Rock Retreat"] = "Refugio Roca del Sol"
L["Sunreaver's Command"] = "Mando de los Atracasol"
L["Sun's Reach Harbor"] = "Puerto Alcance del Sol"
L["Sunveil Excursion"] = "Excursión Velosolar"
L["Sunwell Plateau"] = "Meseta de La Fuente del Sol"
L["Surwich"] = "Mechasur"
L["Swamp of Sorrows"] = "Pantanos de las Penas"
L["Swamprat Post"] = "Avanzada Rata del Pantano"
L["Sylvanaar"] = "Sylvanaar"
L["Synthesis Forge"] = "Forja de Síntesis"
L["System"] = "Sistema"
L["Talonbranch Glade"] = "Claro Ramaespolón"
L["Talrendis Point"] = "Punta Talrendis"
L["Tanaris"] = "Tanaris"
L["Tarren Mill"] = "Molino Tarren"
L["Taunka'le Village"] = "Poblado Taunka'le"
L["Taxi to Scholar's Den"] = "Taxi a El Rincón del Erudito"
L["Taxi to Vault of Secrets"] = "Taxi a La Bóveda de los Secretos"
L["Tazavesh, the Veiled Market"] = "Tazavesh, el Mercado Velado"
L["Telaar"] = "Telaar"
L["Tel'anor"] = "Tel'anor"
L["Teldrassil"] = "Teldrassil"
L["Teleport Crystal"] = "Cristal de Teletransporte"
L["Telredor"] = "Telredor"
L["Tempest Keep"] = "El Castillo de la Tempestad"
L["Temple of Ahn'Qiraj"] = "Templo de Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Templo de Atal'Hakkar"
L["Temple of Sethraliss"] = "Templo de Sethraliss"
L["Temple of Telhamat"] = "Templo de Telhamat"
L["Temple of the Jade Serpent"] = "Templo de la Serpiente de Jade"
L["Temple of the Moon"] = "Templo de la Luna"
L["Tenebrous Cavern"] = "Caverna Tenebrosa"
L["Terokkar Forest"] = "Bosque de Terokkar"
L["Terrace of Endless Spring"] = "Terraza de la Primavera Eterna"
L["Thalanaar"] = "Thalanaar"
L["Thandol Span"] = "Puente Thandol"
L["Thargad's Camp"] = "Campo de Thargad"
L["The Arcatraz"] = "El Arcatraz"
L["The Arcway"] = "El Arcatraz"
L["The Argent Stand"] = "El Bastión Argenta"
L["The Argent Vanguard"] = "La Vanguardia Argenta"
L["The Azure Vault"] = "La Bóveda Azur"
L["The Barrens"] = "Los Baldíos"
L["The Bastion of Twilight"] = "El Bastión del Crepúsculo"
L["The Black Morass"] = "La Ciénaga Negra"
L["The Blood Furnace"] = "El Horno de Sangre"
L["The Botanica"] = "El Invernáculo"
L["The Bulwark"] = "El Baluarte"
L["The Cape of Stranglethorn"] = "El Cabo de Tuercespina"
L["The Crossroads"] = "El Cruce"
L["The Culling of Stratholme"] = "La Matanza de Stratholme"
L["The Dark Portal"] = "El Portal Oscuro"
L["The Deadmines"] = "Las Minas de la Muerte"
L["The Dragon Soul"] = "El Alma del Dragón"
L["The Emerald Nightmare"] = "La Pesadilla Esmeralda"
L["The Everbloom"] = "La Florescencia Eterna"
L["The Exodar"] = "El Exodar"
L["The Eye"] = "El Ojo"
L["The Eye of Eternity"] = "El Ojo de la Eternidad"
L["The Forge of Souls"] = "La Forja de Almas"
L["The Forgotten Coast"] = "La Costa Olvidada"
L["The Frozen Halls"] = "Las Cámaras Heladas"
L["The Great Forge"] = "La Gran Fundición"
L["The Great Lift"] = "El Gran Elevador"
L["The Halls of Reflection"] = "Las Cámaras de Reflexión"
L["The Harborage"] = "El Puerto"
L["The Hinterlands"] = "Tierras del Interior"
L["The Krazzworks"] = "La Krazzería"
L["The Mechanar"] = "El Mechanar"
L["The Menders' Stead"] = "La Finca de los Ensalmadores"
L["The Mor'shan Rampart"] = "La Empalizada Mor'shan"
L["The MOTHERLODE!!"] = "LA MADRELODE"
L["The Necrotic Wake"] = "La Espiral Nigromántica"
L["The Nexus"] = "El Nexo"
L["The Nighthold"] = "Bastión Nocturno"
L["The Nokhud Offensive"] = "La Ofensiva Nokhud"
L["The Obsidian Sanctum"] = "El Sagrario Obsidiana"
L["The Oculus"] = "El Oculus"
L["The Old Kingdom"] = "El Reino Viejo"
L["The Overlook Cliffs"] = "Los Acantilados Dominantes"
L["The Pit of Saron"] = "El Foso de Saron"
L["The Ruby Sanctum"] = "El Sagrario Rubí"
L["The Sepulcher"] = "El Sepulcro"
L["The Shadow Vault"] = "La Bóveda de las Sombras"
L["The Shattered Halls"] = "Las Salas Arrasadas"
L["The Stockade"] = "Las Mazmorras"
L["The Stonecore"] = "El Núcleo Pétreo"
L["The Storm Peaks"] = "Las Cumbres Tormentosas"
L["The Stormspire"] = "Flecha de la Tormenta"
L["The Talondeep Path"] = "El Paso del Espolón"
L["The Underrot"] = "El Vientre Putrefacto"
L["The Vault of Lights"] = "La Bóveda de las Luces"
L["The Violet Hold"] = "El Bastión Violeta"
L["The Vortex Pinnacle"] = "La Cumbre del Vórtice"
L["The Waning Crescent"] = "La Media Luna Descendente"
L["The Zoram Strand"] = "La Ensenada de Zoram"
L["Theater of Pain"] = "Teatro del Dolor"
L["Thelsamar"] = "Thelsamar"
L["Theramore Isle"] = "Isla Theramore"
L["Thondroril River"] = "Río Thondroril"
L["Thorium Point"] = "Puesto del Torio"
L["Thousand Needles"] = "Las Mil Agujas"
L["Thrallmar"] = "Thrallmar"
L["Throne of the Four Winds"] = "Trono de los Cuatro Vientos"
L["Throne of the Tides"] = "Trono de las Mareas"
L["Throne of Thunder"] = "Trono del Trueno"
L["Thunder Bluff"] = "Cima del Trueno"
L["Thunderlord Stronghold"] = "Bastión Señor del Trueno"
L["Thundermar"] = "Bramal"
L["Timbermaw Hold"] = "Bastión Fauces de Madera"
L["Tinker Town"] = "Ciudad Manitas"
L["Tint unexplored areas"] = "Teñir áreas inexploradas"
L["Tiragarde Sound"] = "Estrecho de Tiragarde"
L["Tirisfal Glades"] = "Claros de Tirisfal"
L["Titan Translocator"] = "Translocador Titán"
L["Toggle panel"] = "Alternar panel"
L["Tol Barad"] = "Tol Barad"
L["Tomb of Sargeras"] = "Tumba de Sargeras"
L["Toshley's Station"] = "Estación de Toshley"
L["Trade District"] = "Distrito de Mercaderes"
L["Trade Quarter"] = "Barrio del Comercio"
L["Tram to"] = "Tranvía a"
L["Tranquillien"] = "Tranquillien"
L["Transitus Shield"] = "Escudo de Transitus"
L["Transparency"] = "Transparencia"
L["Trial of the Champion"] = "Prueba del Campeón"
L["Trial of the Crusader"] = "Prueba del Cruzado"
L["Trial of Valor"] = "Prueba del Valor"
L["Twilight Highlands"] = "Tierras Altas Crepusculares"
L["Twilight Shore"] = "Orilla Crepuscular"
L["Twilight Vale"] = "Valle Crepuscular"
L["Twilight Vineyards"] = "Viñedos Crepusculares"
L["Uldaman"] = "Uldaman"
L["Uldaman (rear entrance)"] = "Uldaman (entrada trasera)"
L["Uldaman (side entrance)"] = "Uldaman (entrada lateral)"
L["Uldaman: Legacy of Tyr"] = "Uldaman: Legado de Tyr"
L["Uldir"] = "Uldir"
L["Ulduar"] = "Ulduar"
L["Uldum"] = "Uldum"
L["Underbog"] = "La Sotiénaga"
L["Undercity"] = "Entrañas"
L["Un'Goro Crater"] = "Cráter de Un'Goro"
L["Unlock battlefield map"] = "Desbloquear mapa de campo de batalla"
L["Unlock map frame"] = "Desbloquear mapa"
L["Unu'pe"] = "Unu'pe"
L["Upper Blackrock Spire"] = "Cumbre de Roca Negra Superior"
L["Use default map"] = "Mapa predeterminado"
L["Use large font"] = "Usar fuente grande"
L["Use stationary opacity while pointing at map"] = "Usa opacidad estacionaria mientras apunta al mapa"
L["Utgarde Keep"] = "Fortaleza Utgarde"
L["Utgarde Pinnacle"] = "Pináculo de Utgarde"
L["Valaar's Berth"] = "Atracadero de Valaar"
L["Valdrakken Portals"] = "Portales de Valdrakken"
L["Valgarde"] = "Valgarde"
L["Valgarde Port"] = "Puerto Valgarde"
L["Valiance Keep"] = "Fortaleza de Valiance"
L["Valiance Landing Camp"] = "Campamento de Aterrizaje de Valiance"
L["Valley of Strength"] = "El Valle de la Fuerza"
L["Valormok"] = "Valormok"
L["Vashj'ir"] = "Vashj'ir"
L["Vault of Archavon"] = "La Cámara de Archavon"
L["Vault of the Incarnates"] = "La Cámara de los Encarnados"
L["Vault of the Wardens"] = "La Cámara de las Celadoras"
L["Vengeance Landing"] = "Desembarco de la Venganza"
L["Venomspite"] = "Peste Venenosa"
L["Vermillion Redoubt"] = "Reducto Bermellón"
L["Version"] = "Versión"
L["Victor's Point"] = "Paso del Invicto"
L["Voldrin's Hold"] = "Bastión de Voldrin"
L["Vol'mar"] = "Vol'mar"
L["Wailing Caverns"] = "Cuevas de los Lamentos"
L["Warsong Camp"] = "Campamento Grito de Guerra"
L["Warsong Hold"] = "Bastión Grito de Guerra"
L["Waycrest Manor"] = "Mansión Crestavía"
L["Well of Eternity"] = "Pozo de la Eternidad"
L["Western Earthshrine"] = "Santuario de la Tierra Occidental"
L["Western Plaguelands"] = "Tierras de la Peste del Oeste"
L["Westfall"] = "Páramos de Poniente"
L["Westfall Brigade"] = "Brigada Trabaloma"
L["Westguard Keep"] = "Fortaleza de la Guardia Oeste"
L["Wetlands"] = "Los Humedales"
L["Whelgar's Retreat"] = "Retiro de Whelgar"
L["Whisperwind Grove"] = "Arboleda Susurravientos"
L["Wildhammer Stronghold"] = "Bastión Martillo Salvaje"
L["Wildheart Point"] = "Alto de Corazón Salvaje"
L["Windowed"] = "En ventana"
L["Windrunner's Overlook"] = "Mirador de Brisaveloz"
L["Windshear Hold"] = "Bastión Cortaviento"
L["Wintergarde Keep"] = "Fortaleza de Invierno"
L["Wintergrasp"] = "Cuenca de Invierno"
L["Winterspring"] = "Cuna del Invierno"
L["World of Warcraft Classic"] = "World of Warcraft Clásico"
L["Wrath of the Lich King Classic"] = "Clásico: Ira del Rey Exánime"
L["Wyrmrest Temple"] = "Templo del Reposo del Dragón"
L["You cannot do that in combat."] = "No puedes hacer eso en combate."
L["You will die!"] = "¡Morirás!"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Tu interfaz de usuario necesita recargarse para que algunos de los cambios surtan efecto.|n|nNo es necesario hacer clic en el botón de recarga de inmediato, pero sí debes hacerlo cuando hayas terminado de realizar cambios y quieras que estos surtan efecto."
L["Your UI needs to be reloaded."] = "La IU necesita ser recargada."
L["Zabra'jin"] = "Zabra'jin"
L["Zangarmarsh"] = "Marisma de Zangar"
L["Zeb'Sora"] = "Zeb'Sora"
L["Zeppelin to"] = "Zepelín a"
L["Zim'Torga"] = "Zim'Torga"
L["Zone Map"] = "Mapa de zona"
L["Zoom"] = "Zoom"
L["Zoram'gar Outpost"] = "Avanzada de Zoram'gar"
L["Zul'Aman"] = "Zul'Aman"
L["Zuldazar"] = "Zuldazar"
L["Zul'Drak"] = "Zul'Drak"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"

end

-- esES: Spanish (Spain)
if GameLocale == "esES" then
L["(destination only)"] = "(solo destino)"
L["(inside Caverns of Time)"] = "(dentro de Cavernas de Tiempo)"
L["/ltm help - Show this information."] = "/ltm help - Mostrar información."
L["/ltm reset - Reset the panel position."] = "/ltm reset - Restablecer la posición del panel."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - Borrar la configuración y recargar."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "Se ha producido un error de detención, pero no hay que preocuparse. Puede suceder de vez en cuando. Haz clic en el botón de recarga para resolverlo."
L["Abyssal Depths"] = "Profundidades Abisales"
L["Acherus: The Ebon Hold"] = "Acherus: El Bastión de Ébano"
L["Aerie Peak"] = "Pico Nidal"
L["Agmar's Hammer"] = "Martillo de Agmar"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Aldor"] = "Aldor"
L["Algeth'ar Academy"] = "Academia Algeth'ar"
L["Allerian Stronghold"] = "Bastión Allerian"
L["Alliance Cities"] = "Ciudades de la Alianza"
L["Allow frame movement"] = "Permitir movimiento del marco"
L["Alpha"] = "Alfa"
L["Altar of Sha'tar"] = "Altar de Sha'tar"
L["Alterac Mountains"] = "Montañas de Alterac"
L["Always"] = "Siempre"
L["Amber Lodge"] = "Refugio Ámbar"
L["Amberpine Lodge"] = "Refugio Pino Ámbar"
L["Andorhal"] = "Andorhal"
L["Antorus, the Burning Throne"] = "Antorus, el Trono Ardiente"
L["Apothecary Camp"] = "Campamento del Apotecario"
L["Appearance"] = "Apariencia"
L["Arathi Highlands"] = "Tierras Altas de Arathi"
L["Area 52"] = "Área 52"
L["Argent Tournament Grounds"] = "Campos del Torneo Argenta"
L["Armory"] = "Arsenal"
L["Ashenvale"] = "Vallefresno"
L["Astranaar"] = "Astranaar"
L["Astravar Harbor"] = "Puerto Astravar"
L["Atal'Dazar"] = "Atal'Dazar"
L["Auberdine"] = "Auberdine"
L["Auchenai Crypts"] = "Criptas Auchenai"
L["Auchindoun"] = "Auchindoun"
L["Auto change zones"] = "Cambiar zonas"
L["available during zone attack"] = "disponible durante el ataque a la zona"
L["Azeroth"] = "Azeroth"
L["Azjol-Nerub"] = "Azjol-Nerub"
L["Azshara"] = "Azshara"
L["Azure Watch"] = "Avanzada Azur"
L["Azuremyst Isle"] = "Isla Bruma Azur"
L["Back to Main Menu"] = "Volver a menú principal"
L["Badlands"] = "Tierras Inhóspitas"
L["Bambala"] = " Bambala"
L["Baradin Hold"] = "Bastión de Baradin"
L["Battle of Dazar'alor"] = "Batalla de Dazar'alor"
L["Battlegrounds"] = "Campos de batalla"
L["Bilgewater Harbor"] = "Muelle Pantoque"
L["Black Morass"] = "La Ciénaga Negra"
L["Black Rook Hold"] = "Bastión de Cuervo Negro"
L["Black Temple"] = "Templo Oscuro"
L["Blackfathom Deeps"] = "Cavernas de Brazanegra"
L["Blackrock Caverns"] = "Cavernas Roca Negra"
L["Blackrock Depths"] = "Profundidades de Roca Negra"
L["Blackrock Foundry"] = "Forja Negra"
L["Blackrock Mountain"] = "Montaña Roca Negra"
L["Blackrock Spire"] = "Pico Roca Negra"
L["Blackwing Descent"] = "Descenso de Alanegra"
L["Blackwing Lair"] = "Guarida de Alanegra"
L["Blade Tooth Canyon"] = "Cañón Colmillo Afilado"
L["Blade's Edge Mountains"] = "Montañas Filospada"
L["Blades' Run"] = "Tramo de las Hojas"
L["Blasted Lands"] = "Las Tierras Devastadas"
L["Blood Watch"] = "Avanzada de Sangre"
L["Bloodhoof Village"] = "Poblado Pezuña de Sangre"
L["Bloodmaul Slag Mines"] = "Minas de Escoria Machacasangre"
L["Bloodmyst Isle"] = "Isla Bruma de Sangre"
L["Bloodvenom Post"] = "Puesto del Veneno"
L["Bloodwatcher Point"] = "Paso de Mirasangre"
L["Blue"] = "Azul"
L["Boat to"] = "Barco a"
L["Bogpaddle"] = "Chapaleos"
L["Bootlegger Outpost"] = "Avanzada del Contrabandista"
L["Booty Bay"] = "Bahía del Botín"
L["Borean Tundra"] = "Tundra Boreal"
L["Bor'gorok Outpost"] = "Avanzada Bor'gorok"
L["Bouldercrag's Refuge"] = "Refugio Rocañón"
L["Brackenhide Hollow"] = "Otero Piel de Helecho"
L["Brackenwall Village"] = "Poblado Murohelecho"
L["Brill"] = "Rémol"
L["Burning Crusade Classic"] = "Burning Crusade Clásico"
L["Burning Steppes"] = "Las Estepas Ardientes"
L["Camp Ataya"] = "Campamento Ataya"
L["Camp Everstill"] = "Campamento Sempiterno"
L["Camp Mojache"] = "Campamento Mojache"
L["Camp Oneqwah"] = "Campamento Oneqwah"
L["Camp Taurajo"] = "Campamento Taurajo"
L["Camp Tunka'lo"] = "Campamento Tunka'lo"
L["Camp Winterhoof"] = "Campamento Pezuña Invernal"
L["Cannot be used with Use default map."] = "No se puede usar con el mapa predeterminado."
L["Cannot be used with Use default map.|n|nTo adjust map opacity, right-click the map frame title bar."] = "No se puede usar con el mapa predeterminado.|n|nPara ajustar la opacidad del mapa, haz clic derecho en la barra de título del marco del mapa."
L["Castle Nathria"] = "Castillo de Nathria"
L["Cathedral"] = "Catedral"
L["Cathedral of Eternal Night"] = "Catedral de la Noche Eterna"
L["Caverns of Time"] = "Cavernas del Tiempo"
L["Cenarion Hold"] = "Fuerte Cenarion"
L["Center map on player"] = "Centrar en jugador"
L["Central Mesa"] = "Meseta Central"
L["Chamber of Heart"] = "Cámara del Corazón"
L["Chillwind Camp"] = "Campamento del Orvallo"
L["Chiselgrip"] = "Cincelada"
L["Choose where the zone map should be shown."] = "Elija dónde se debe mostrar el mapa de zonas."
L["Class colored icons"] = "Iconos coloreados"
L["Classic"] = "Clásico"
L["Click to configure the settings for this option."] = "Haz clic para configurar esta opción."
L["Click to reset the position and scale of the map frame."] = "Haz clic para restablecer la posición y la escala del marco del mapa."
L["Click to reset the settings on this page."] = "Haz clic para restablecer la configuración en esta página."
L["Click to return to the main menu."] = "Haz clic para volver al menú principal."
L["Cliffwalker Post"] = "Puesto Caminarrisco"
L["Coilfang Reservoir"] = "Reserva Colmillo Torcido"
L["Coldarra"] = "Gelidar"
L["Configuration Panel"] = "Panel de Configuración"
L["Conquest Hold"] = "Fortaleza Conquista"
L["Cosmic"] = "Cósmico"
L["Cosmowrench"] = "Cosmotirón"
L["Court of Stars"] = "Corte de las Estrellas"
L["Crucible of Storms"] = "Crisol de Tormentas"
L["Crusaders' Pinnacle"] = "Cima de los Cruzados"
L["Crushblow"] = "Machacolpe"
L["Crystalsong Forest"] = "Bosque Canto Cristalino"
L["Culling of Stratholme"] = "El Asedio de Stratholme"
L["Cursor"] = "Cursor"
L["Dalaran"] = "Dalaran"
L["Dalaran Crater"] = "Cráter de Dalaran"
L["Darkbreak Cove"] = "Cala Brechaoscura"
L["Darkheart Thicket"] = "Sotobosque Corazón Oscuro"
L["Darkshire"] = "Villa Oscura"
L["Darkshore"] = "Costa Oscura"
L["Darnassus"] = "Darnassus"
L["De Other Side"] = "El Otro Lado"
L["Deadwind Pass"] = "Paso de la Muerte"
L["Death's Rise"] = "Ascenso de la Muerte"
L["Debug"] = "Depuración"
L["Deepholm"] = "Infralar"
L["Desolace"] = "Desolace"
L["Desolation Hold"] = "Bastión de la Desolación"
L["Dire Maul (East)"] = "La Masacre (Este)"
L["Dire Maul (East) (side entrance)"] = "La Masacre (Este) (entrada lateral)"
L["Dire Maul (East): Warpwood Quarter"] = "La Masacre (Este): Barrio Alabeo"
L["Dire Maul (North)"] = "La Masacre (Norte)"
L["Dire Maul (North): Gordok Commons"] = "La Masacre (Norte): Ágora de Gordok"
L["Dire Maul (West)"] = "La Masacre (Oeste)"
L["Dire Maul (West): Capital Gardens"] = "La Masacre (Oeste): Jardines de la Capital"
L["Dire Maul: Capital Gardens"] = "La Masacre: Jardines Capitales"
L["Dire Maul: Gordok Commons"] = "La Masacre: Barrios Gordok"
L["Dire Maul: Warpwood Quarter"] = "La Masacre: Distrito Madera de la Enredadera"
L["Disable map fade"] = "Desactivar desvanecimiento del mapa"
L["Disable reading emote"] = "Desactivar lectura de emoción"
L["Disable reading emote when opening the map"] = "Deshabilita la lectura de emoticones al abrir el mapa"
L["disabled"] = "desactivado"
L["Dolanaar"] = "Dolanaar"
L["Drag"] = "Arrastrar"
L["Drag to set the amount of blue."] = "Arrastra para establecer la cantidad de azul."
L["Drag to set the amount of green."] = "Arrastra para establecer la cantidad de verde."
L["Drag to set the amount of red."] = "Arrastra para establecer la cantidad de rojo."
L["Drag to set the battlefield map opacity."] = "Arrastra para establecer la opacidad del mapa de campo de batalla."
L["Drag to set the battlefield map size."] = "Arrastra para establecer el tamaño del mapa del campo de batalla."
L["Drag to set the battlefield map size.|n|nIf the map is unlocked, you can also resize the battlefield map by dragging the bottom-right corner."] = "Arrastra para establecer el tamaño del mapa del campo de batalla.|n|nSi el mapa está desbloqueado, también puedes cambiar el tamaño del mapa del campo de batalla arrastrando la esquina inferior derecha."
L["Drag to set the group icon size."] = "Arrastra para establecer el tamaño del icono de grupo."
L["Drag to set the map opacity for when your character is moving."] = "Arrastra para establecer la opacidad del mapa para cuando su personaje se esté moviendo."
L["Drag to set the map opacity for when your character is stationary."] = "Arrastra para establecer la opacidad del mapa para cuando su personaje esté estacionario."
L["Drag to set the maximum zoom level.|n|nOpen the battlefield map to see the maximum zoom level change as you drag the slider."] = "Arrastra para establecer el nivel de zoom máximo.|n|nAbre el mapa del campo de batalla para ver cómo cambia el nivel de zoom máximo a medida que arrastras el control deslizante."
L["Drag to set the maximum zoom level.|n|nOpen the map to see the maximum zoom level change as you drag the slider."] = "Arrastra para establecer el nivel de zoom máximo.|n|nAbra el mapa para ver cómo cambia el nivel de zoom máximo a medida que arrastra el control deslizante."
L["Drag to set the opacity."] = "Arrastra para establecer la opacidad."
L["Drag to set the player arrow size."] = "Arrastra para establecer el tamaño de la flecha del jugador."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "Arrastra para establecer el tamaño de la flecha del jugador.|n|nEl valor predeterminado de WoW Classic es 16.|nEl valor predeterminado de WoW Retail es 27."
L["Drag to set the scale for the maximised map."] = "Arrastra para establecer la escala para el mapa maximizado."
L["Drag to set the scale for the windowed map."] = "Arrastra para establecer la escala para el mapa en ventana."
L["Drag to set the world map scale.|n|nYou can also rescale the world map by dragging the bottom-right corner."] = "Arrastra para establecer la escala del mapa mundial.|n|nTambién puedes cambiar la escala del mapa mundial arrastrando la esquina inferior derecha."
L["Dragon Soul"] = "Alma de Dragón"
L["Dragonblight"] = "Cementerio de Dragones"
L["Dragonmaw Port"] = "Puerto Faucedraco"
L["Dragon's Mouth"] = "Boca del Dragón"
L["Drak'Tharon Keep"] = "Fortaleza de Drak'Tharon"
L["Dreadmaul Hold"] = "Bastión Machacamiedo"
L["Dreamer's Rest"] = "Reposo de la Soñadora"
L["Druid only flight point to Darnassus"] = "Punto de vuelo a Darnassus sólo para druidas"
L["Druid only flight point to Thunder Bluff"] = "Punto de vuelo a Cima del Trueno sólo para druidas"
L["Dun Algaz"] = "Dun Algaz"
L["Dun Modr"] = "Dun Modr"
L["Dun Morogh"] = "Dun Morogh"
L["Dun Nifflelem"] = "Dun Nifflelem"
L["Dungeon"] = "Mazmorra"
L["Dungeon (requires Crescent Key)"] = "Mazmorra (requiere Llave de la Cosecha)"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Bosque del Ocaso"
L["Dustwallow Marsh"] = "Marjal Revolcafango"
L["Dustwind Dig"] = "Excavación Viento Seco"
L["Dwarven District"] = "Distrito de los Enanos"
L["Eastern Earthshrine"] = "Santuario Oriental"
L["Eastern Plaguelands"] = "Tierras de la Peste del Este"
L["Eastpoint Tower"] = "Torre Oriental"
L["Eastvale Logging Camp"] = "Aserradero de la Vega del Este"
L["Ebon Watch"] = "Vigía Ébano"
L["Elements"] = "Visibilidad"
L["Elwynn Forest"] = "Bosque de Elwynn"
L["Emerald Dream"] = "Sueño Esmeralda"
L["Emerald Sanctuary"] = "Santuario Esmeralda"
L["enabled"] = "activado"
L["End Time"] = "Fin de los Tiempos"
L["Enhance battlefield map"] = "Mapa de campo de batalla"
L["Enhance dungeon icons"] = "Mejorar iconos de mazmorra"
L["Enlarge player arrow"] = "Flecha de jugador"
L["Enter"] = "Escribe"
L["Ethel Rethor"] = "Ethel Rethor"
L["Evergrove"] = "Soto Eterno"
L["Everlook"] = "Vista Eterna"
L["Evermoon Terrace"] = "Terraza Lunaroja"
L["Eversong Woods"] = "Bosque Canción Eterna"
L["Exile's Hollow"] = "Cuenca del Exiliado"
L["Exodar"] = "El Exodar"
L["Explorer's League Digsite"] = "Excavación de la Liga de Expedicionarios"
L["Eye of Azshara"] = "Ojo de Azshara"
L["Fairbreeze Village"] = "Aldea Brisa Pura"
L["Falanaar"] = "Falanaar"
L["Falcon Watch"] = "Avanzada del Halcón"
L["Falconwing Square"] = "Plaza Alalcón"
L["Faldir's Cove"] = "Cala de Faldir"
L["Feathermoon Stronghold"] = "Bastión Plumaluna"
L["Felsoul Hold"] = "Bastión Alma Vil"
L["Felwood"] = "Frondavil"
L["Feralas"] = "Feralas"
L["Firebeard's Patrol"] = "Patrulla de Barbafuego"
L["Firelands"] = "Tierras de Fuego"
L["Fishing"] = "Pesca"
L["Fizzcrank Airstrip"] = "Aeropuerto Fizzcrank"
L["Fizzle & Pozzik's Speedbarge"] = "Barcódromo de Fizzle y Pozzik"
L["Flame Crest"] = "Peñasco Llamarada"
L["Flamestar Post"] = "Puesto Llamaestrella"
L["Flayedwing Transporter"] = "Transportador Alapeste"
L["Follow the eastward path"] = "Sigue el camino hacia el este"
L["Follow the westward path"] = "Sigue el camino hacia el oeste"
L["Fordragon Hold"] = "Fortaleza Fordragón"
L["Forest Song"] = "Canción del Bosque"
L["Fort Livingston"] = "Fuerte Livingston"
L["Fort Wildervar"] = "Fuerte Frondavara"
L["Freehold"] = "Dominio de los Sin Ley"
L["Freewind Post"] = "Poblado Viento Libre"
L["Frosthold"] = "Fuerte Escarcha"
L["Fuselight"] = "El Diodo"
L["Gadgetzan"] = "Gadgetzan"
L["Garadar"] = "Garadar"
L["Gate of the Setting Sun"] = "Puerta del Sol Poniente"
L["Gates of Valor"] = "Puertas del Valor"
L["Ghostlands"] = "Tierras Fantasma"
L["Gnomeregan"] = "Gnomeregan"
L["Gol'Bolar Quarry"] = "Cantera de Gol'Bolar"
L["Goldshire"] = "Villadorada"
L["Graveyard"] = "Cementerio"
L["Green"] = "Verde"
L["Grim Batol"] = "Grim Batol"
L["Grimrail Depot"] = "Depósito de Hierro Negro"
L["Grizzly Hills"] = "Colinas Pardas"
L["Grom'arsh Crash Site"] = "Lugar del Accidente de Grom'arsh"
L["Grom'gol"] = "Grom'gol"
L["Grom'gol Base Camp"] = "Campamento Grom'gol"
L["Group Icons"] = "Iconos de grupo"
L["Grove of Aessina"] = "Arboleda de Aessina"
L["Grove of the Ancients"] = "Páramo de los Ancianos"
L["Gruul's Lair"] = "Guarida de Gruul"
L["Gundrak"] = "Gundrak"
L["Gundrak (rear entrance)"] = "Gundrak (entrada trasera)"
L["Hall of Ancient Paths"] = "Sala de los Caminos Ancestrales"
L["Halls of Atonement"] = "Salas de la Expiación"
L["Halls of Infusion"] = "Salas de la Infusión"
L["Halls of Lightning"] = "Cámaras de Relámpagos"
L["Halls of Origination"] = "Salas de la Creación"
L["Halls of Stone"] = "Cámaras de Piedra"
L["Halls of Valor"] = "Salones del Valor"
L["Hammerfall"] = "Sentencia"
L["Hardwrench Hideaway"] = "Escondrijo Malallave"
L["Head down the mountain from here."] = "Baja de la montaña desde aquí."
L["Head southeast from here and go up the mountain."] = "Ve al sureste desde aquí y sube la montaña."
L["Heart of Fear"] = "Corazón del Miedo"
L["Hearthglen"] = "Vega del Amparo"
L["Hellfire Citadel"] = "Ciudadela del Fuego Infernal"
L["Hellfire Peninsula"] = "Península del Fuego Infernal"
L["Hellfire Ramparts"] = "Murallas del Fuego Infernal"
L["Hellscream's Watch"] = "Avanzada Grito Infernal"
L["Hide filter reset button"] = "Ocultar botón de restablecimiento del filtro"
L["Hide town and city icons"] = "Pueblos y ciudades"
L["Highbank"] = "Bancalto"
L["Highmaul"] = "Alto Maul"
L["Hillsbrad Foothills"] = "Laderas de Trabalomas"
L["Honor Hold"] = "Bastión del Honor"
L["Honor's Stand"] = "El Alto del Honor"
L["Horde Cities"] = "Ciudades de la Horda"
L["Hour of Twilight"] = "Hora del Crepúsculo"
L["Howling Fjord"] = "Fiordo Aquilonal"
L["Hunter's Hill"] = "Cerro del Cazador"
L["Hyjal"] = "Hyjal"
L["Hyjal Summit"] = "La Cima Hyjal"
L["Icecrown"] = "Corona de Hielo"
L["Icecrown Citadel"] = "Ciudadela de la Corona de Hielo"
L["Icons"] = "Iconos"
L["If checked, additional icons (such as portals) will be shown."] = "Si está seleccionado, se mostrarán iconos adicionales (como portales)."
L["If checked, archaeology digsites will be shown."] = "Si está seleccionado, se mostrarán los sitios de excavación arqueológica."
L["If checked, coordinates will be shown."] = "Si está seleccionado, se mostrarán las coordenadas."
L["If checked, coordinates will have a dark background texture."] = "Si está seleccionado, las coordenadas tendrán una textura de fondo oscura."
L["If checked, coordinates will use a large font."] = "Si está seleccionado, las coordenadas usarán una fuente grande."
L["If checked, dungeons and raids will be shown."] = "Si está seleccionado, se mostrarán mazmorras y bandas."
L["If checked, group icons will use a modern, class-colored design."] = "Si está seleccionado, los iconos de grupo usarán un diseño moderno, de color de clase."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "Si está seleccionado, al abrir el mapa se usará el mismo nivel de zoom desde la última vez que lo cerró, siempre que la zona del mapa no haya cambiado."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "Si está seleccionado, apuntar al mapa mientras tu personaje se mueve hará que se aplique la configuración de opacidad estacionaria."
L["If checked, points of interest will be shown."] = "Si está seleccionado, se mostrarán puntos de interés."
L["If checked, quest objectives will be shown."] = "Si está seleccionado, se mostrarán los objetivos de las misiones."
L["If checked, spirit healers will be shown."] = "Si está seleccionado, se mostrarán los Ángeles de la Resurrección."
L["If checked, the battlefield map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Si está seleccionado, el mapa del campo de batalla permanecerá centrado en tu ubicación siempre que no estés en una mazmorra.|n|nPuedes mantener presionada la tecla mayús mientras desplazas el mapa para evitar que se centre temporalmente."
L["If checked, the default fullscreen map will be used for the maximised map.|n|nNote that enabling this option will lock out some of the other options."] = "Si está seleccionado, se usará el mapa predeterminado de pantalla completa para el mapa maximizado.|n|nTen en cuenta que habilitar esta opción bloqueará algunas de las otras opciones."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "Si está seleccionado, se usará el mapa predeterminado de pantalla completa.|n|nTenga en cuenta que habilitar esta opción bloqueará algunas de las otras opciones."
L["If checked, the map border will be removed."] = "Si está seleccionado, se eliminará el borde del mapa."
L["If checked, the map frame will remain open until you close it."] = "Si está seleccionado, el marco del mapa permanecerá abierto hasta que lo cierres."
L["If checked, the map will not fade while your character is moving."] = "Si está seleccionado, el mapa no se desvanecerá mientras tu personaje se esté moviendo."
L["If checked, the map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Si está seleccionado, el mapa permanecerá centrado en tu ubicación siempre que no estés en una mazmorra.|n|nPuedes mantener presionada la tecla mayús mientras desplazas el mapa para evitar que se centre temporalmente."
L["If checked, the minimap button will be shown."] = "Si está seleccionado, se mostrará el botón del minimapa."
L["If checked, the minimum fishing skill levels will be shown."] = "Si está seleccionado, se mostrarán los niveles mínimos de habilidad de pesca."
L["If checked, the world map filter reset button will be hidden."] = "Si está seleccionado, el botón de restablecimiento del filtro del mapa del mundo se ocultará."
L["If checked, town and city icons will not be shown on the continent maps."] = "Si está seleccionado, los iconos de pueblos y ciudades no se mostrarán en los mapas de continentes."
L["If checked, travel points for the opposing faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Si está seleccionado, se mostrarán los puntos de viaje de la facción contraria.|n|nEsto incluye puntos de vuelo, puertos para barcos, torres de zepelín y estaciones de tranvía."
L["If checked, travel points for the same faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Si está seleccionado, se mostrarán los puntos de viaje para la misma facción.|n|nEsto incluye puntos de vuelo, puertos para barcos, torres de zepelín y estaciones de tranvía."
L["If checked, unexplored areas of the map will be shown on the world map and the battlefield map."] = "Si está seleccionado, las áreas inexploradas del mapa se mostrarán en el mapa del mundo y en el mapa del campo de batalla."
L["If checked, unexplored areas will be tinted."] = "Si está seleccionado, las áreas inexploradas se teñirán."
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "Si está seleccionado, cuando tu personaje cambia de zona, el mapa cambiará automáticamente a la nueva zona."
L["If checked, you can move the battlefield map by dragging any of its borders."] = "Si está seleccionado, puedes mover el mapa del campo de batalla arrastrando cualquiera de sus bordes."
L["If checked, you can move the battlefield map by dragging any of its borders.|n|nYou can resize the battlefield map by dragging the bottom-right corner."] = "Si está seleccionado, puedes mover el mapa del campo de batalla arrastrando cualquiera de sus bordes.|n|nPuedes cambiar el tamaño del mapa del campo de batalla arrastrando la esquina inferior derecha."
L["If checked, you will be able to customise the battlefield map."] = "Si está seleccionado, se podrá personalizar el mapa del campo de batalla."
L["If checked, you will be able to enlarge the player arrow."] = "Si está seleccionado, se podrá ampliar la flecha del jugador."
L["If checked, you will be able to move the frame by dragging the border."] = "Si está seleccionado, podrás mover el marco arrastrando el borde."
L["If checked, you will be able to move the map.|n|nThe map position will be saved separately for the maximised and windowed maps."] = "Si está seleccionado, podrás mover el mapa.|n|nLa posición del mapa se guardará por separado para los mapas maximizados y en ventana."
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges."] = "Si está seleccionado, se podrá escalar y mover el mapa.|n|nEscala el mapa arrastrando el controlador de escala en la esquina inferior derecha.|n|nMueve el mapa arrastrando el borde y los bordes del marco."
L["If checked, you will be able to scale the map by dragging the scale handle in the bottom-right corner.|n|nYou will be able to move the map by dragging any border.|n|nYou can always drag the top border to move the map regardless of this setting."] = "Si está seleccionado, podrás cambiar la escala del mapa arrastrando el control de escala en la esquina inferior derecha.|n|nPodrás mover el mapa arrastrando cualquier borde.|n|nPuedes arrastrar siempre el borde superior para mover el mapa, independientemente de esta configuración."
L["If checked, you will be able to scale the map."] = "Si está seleccionado, podrás escalar el mapa."
L["If checked, you will be able to set the opacity of the map."] = "Si está seleccionado, se podrá establecer la opacidad del mapa."
L["If checked, you will be able to zoom further into the world map."] = "Si está seleccionado, se podrá hacer zoom más en el mapa del mundo."
L["If checked, your character will not perform the reading emote when you open the map."] = "Si está seleccionado, tu personaje no realizará la emoción de lectura al abrir el mapa."
L["If checked, zone and continent dropdown menus will be shown in the map frame."] = "Si está seleccionado, se mostrarán los menús desplegables de zona y continente en el marco del mapa."
L["If checked, zone and dungeon levels will be shown."] = "Si está seleccionado, se mostrarán los niveles de zona y mazmorras."
L["If checked, zone crossings will be shown.|n|nThese are clickable arrows that indicate the zone exit pathways."] = "Si está seleccionado, se mostrarán los cruces de zona.|n|nEstas son flechas en las que se puede hacer clic que indican las vías de salida de la zona."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "Si está seleccionado, se mostrarán los niveles de zona, mazmorra y habilidad de pesca."
L["Increase zoom level"] = "Aumentar nivel de zoom"
L["Invalid command.  Enter /ltm help for help."] = "Comando inválido. Escribe /ltm help para obtener ayuda."
L["Invalid map ID."] = "ID de mapa inválido."
L["Iron Docks"] = "Muelles de Hierro"
L["Iron Summit"] = "Cima de Hierro"
L["Ironforge"] = "Forjaz"
L["Isle of Quel'Danas"] = "Isla de Quel'Danas"
L["Just follow the path west"] = "Sigue el camino hacia el oeste"
L["K3"] = "K3"
L["Kamagua"] = "Kamagua"
L["Karazhan"] = "Karazhan"
L["Kargath"] = "Kargath"
L["Kelp'thar Forest"] = "Bosque Kelp'thar"
L["Kharanos"] = "Kharanos"
L["Kings' Rest"] = "Reposo de los Reyes"
L["Kirthaven"] = "Kirthaven"
L["Kor'kron Vanguard"] = "Vanguardia Kor'kron"
L["Krom'gar Fortress"] = "Fortaleza Krom'gar"
L["Lake Elune'ara"] = "Lago Elune'ara"
L["Lake Everstill"] = "Lago Sempiterno"
L["Lakeshire"] = "Villa del Lago"
L["Large Scarab Coffer"] = "Arca del escarabajo grande"
L["Leads to Tirisfal Glades"] = "Conduce a Claros de Tirisfal"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS: ¡VERSIÓN INCORRECTA INSTALADA!"
L["Library"] = "Biblioteca"
L["Light's Breach"] = "Brecha de la Luz"
L["Light's Hope Chapel"] = "Capilla de la Esperanza de la Luz"
L["Lion's Watch"] = "Vigilia del León"
L["Loch Modan"] = "Loch Modan"
L["Lor'danel"] = "Lor'danel"
L["Lost City of the Tol'vir"] = "Ciudad Perdida de los Tol'vir"
L["Lower Blackrock Spire"] = "Cumbre de Roca Negra Inferior"
L["Lunastre Estate"] = "Propiedad Lunastre"
L["Magisters' Terrace"] = "Bancal del Magister"
L["Magtheridon's Lair"] = "Guarida de Magtheridon"
L["Malaka'jin"] = "Malaka'jin"
L["Mana-Tombs"] = "Tumbas de Maná"
L["Map frame scale"] = "Escala del marco del mapa"
L["Map Opacity"] = "Opacidad de mapa"
L["Map Scale"] = "Escala del mapa"
L["Map Size"] = "Tamaño de mapa"
L["Maraudon"] = "Maraudon"
L["Maraudon: Earth Song Falls"] = "Maraudon: Cascadas Canto de la Tierra"
L["Maraudon: Foulspore Cavern"] = "Maraudon: Caverna Espora Fétida"
L["Maraudon: The Wicked Grotto"] = "Maraudon: Gruta Perversa"
L["Marshal's Refuge"] = "Refugio de Marshal"
L["Marshtide Watch"] = "Avanzada Marea Pantanosa"
L["Maw of Souls"] = "Fauce de Almas"
L["Max Zoom"] = "Zoom máximo"
L["Maximised"] = "Maximizado"
L["Maximum"] = "Máximo"
L["Mechanics"] = "Mecánicas"
L["Memory Usage"] = "Uso de memoria"
L["Menethil Harbor"] = "Puerto de Menethil"
L["Mirkfallon Post"] = "Puesto de Mirkfallon"
L["Miscellaneous"] = "Miscelánea"
L["Mists of Tirna Scithe"] = "Nieblas de Tirna Scithe"
L["Moa'ki"] = "Moa'ki"
L["Moa'ki Harbor"] = "Puerto Moa'ki"
L["Mogu'shan Palace"] = "Palacio Mogu'shan"
L["Mogu'shan Vaults"] = "Cámaras Mogu'shan"
L["Mok'Nathal Village"] = "Aldea Mok'Nathal"
L["Molten Core"] = "Núcleo de Magma"
L["Moon Guard Stronghold"] = "Bastión Guardia Lunar"
L["Moonbrook"] = "Arroyo de la Luna"
L["Moonglade"] = "Claro de la Luna"
L["More"] = "Otro"
L["Morgan's Vigil"] = "Vigilia de Morgan"
L["Mossy Pile"] = "Pilote Musgoso"
L["Mount Crafting"] = "Creación de monturas"
L["Mount Hyjal"] = "Monte Hyjal"
L["Mountain Pass (Horde Only)"] = "Paso de Montaña (Solo Horda)"
L["Moving"] = "Movimiento"
L["Mudsprocket"] = "Piñón de Barro"
L["Mulgore"] = "Mulgore"
L["Nagrand"] = "Nagrand"
L["Naxxramas"] = "Naxxramas"
L["Nazjatar"] = "Nazjatar"
L["Neltharion's Lair"] = "Guarida de Neltharion"
L["Neltharus"] = "Neltharus"
L["Nesingwary Base Camp"] = "Campamento Base de Nesingwary"
L["Nethergarde Keep"] = "Castillo de Nethergarde"
L["Netherstorm"] = "Tormenta Abisal"
L["Never"] = "Nunca"
L["New Agamand"] = "Nuevo Agamand"
L["New Kargath"] = "Nuevo Kargath"
L["Nighthaven"] = "Amparo de la Noche"
L["Nijel's Point"] = "Punta de Nijel"
L["Nordrassil"] = "Nordrassil"
L["North"] = "Norte"
L["North Gate Pass"] = "Paso de la Puerta Norte"
L["Northwatch Hold"] = "Fuerte del Norte"
L["Ny'alotha, The Waking City"] = "Ny'alotha, la Ciudad Despierta"
L["Oasis of Vir'sar"] = "Oasis de Vir'sar"
L["Ohn'ahran Plains"] = "Llanuras de Ohn'ahra"
L["Old Hillsbrad"] = "Antiguas Colinasbrad"
L["Old Hillsbrad Foothills"] = "Antiguas Laderas de Trabalomas"
L["Onyxia's Lair"] = "Guarida de Onyxia"
L["Opacity"] = "Opacidad"
L["Operation: Mechagon"] = "Operación: Mecagon"
L["or click the minimap button to open Leatrix Maps."] = "o haz clic en el botón del minimapa para abrir Leatrix Maps."
L["Orb of Translocation"] = "Orbe de Translocación"
L["Orebor Harborage"] = "Puerto Orebor"
L["Orgrimmar"] = "Orgrimmar"
L["Oribos"] = "Oribos"
L["Pet Crafting"] = "Creación de mascotas"
L["Plaguefall"] = "Bajapeste"
L["Plaguewood Tower"] = "Torre del Bosque de la Peste"
L["Player"] = "Jugador"
L["Player Arrow"] = "Flecha de jugador"
L["Portal"] = "Portal"
L["Portal from Zephyr"] = "Portal desde Zephyr"
L["Portals"] = "Portales"
L["Preview"] = "Prevista"
L["Protoform Repository"] = "Repositorio Protoforma"
L["Ragefire Chasm"] = "Sima Ígnea"
L["Raid"] = "Banda"
L["Ramkahen"] = "Ramkahen"
L["Ratchet"] = "Trinquete"
L["Raven Hill"] = "Cerro del Cuervo"
L["Ravenholdt Manor"] = "Mansión Ravenholdt"
L["Razor Hill"] = "Cerrotajo"
L["Razorfen Downs"] = "Zahúrda Rajacieno"
L["Razorfen Kraul"] = "Horado Rajacieno"
L["Razorthorn Trail"] = "Senda de Espinaguda"
L["Rebel Camp"] = "Asentamiento Rebelde"
L["Red"] = "Rojo"
L["Redridge Mountains"] = "Montañas Crestagrana"
L["Refuge Pointe"] = "Refugio de la Zaga"
L["Reload"] = "Recargar"
L["Remember zoom level"] = "Recordar nivel de zoom"
L["Remove map border"] = "Borde del mapa"
L["req"] = "req"
L["Requires Key to Searing Gorge"] = "Requiere Llave de la Garganta de Fuego"
L["Requires UI reload."] = "Requiere recargar la IU"
L["Reset"] = "Restablecer"
L["Reset Map Layout"] = "Restablecer diseño del mapa"
L["Return to Karazhan"] = "Regreso a Karazhan"
L["Revantusk Village"] = "Poblado Sañadiente"
L["River's Heart"] = "Corazón del Río"
L["Ruby Life Pools"] = "Pozas Vida Rubí"
L["Ruins of Ahn'Qiraj"] = "Ruinas de Ahn'Qiraj"
L["Ruins of Elune'eth"] = "Ruinas de Elune'eth"
L["Rut'Theran Village"] = "Aldea Rut'Theran"
L["Rut'theran Village"] = "Aldea Rut'theran"
L["Sanctuary"] = "Santuario"
L["Sanctuary of Malorne"] = "Santuario de Malorne"
L["Sanctum of Domination"] = "Sagrario de la Dominación"
L["Sanctum of Order"] = "Sagrario del Orden"
L["Sanctum of the Sages"] = "Sagrario de los Sabios"
L["Sanctum of the Stars"] = "Sagrario de las Estrellas"
L["Sanguine Depths"] = "Fosos Sanguinos"
L["Scale"] = "Escala"
L["Scale the map"] = "Escalar el mapa"
L["Scarlet Halls"] = "Salas Escarlata"
L["Scarlet Monastery"] = "Monasterio Escarlata"
L["Schnottz's Landing"] = "Embarcadero de Schnottz"
L["Scholomance"] = "Scholomance"
L["Searing Gorge"] = "La Garganta de Fuego"
L["Seat of the Naaru"] = "Asiento de los Naaru"
L["Seat of the Triumvirate"] = "Asiento del Triunvirato"
L["Sen'jin Village"] = "Poblado Sen'jin"
L["Sentinel Hill"] = "Colina del Centinela"
L["Sepulcher of the First Ones"] = "Sepulcro de los Primeros"
L["Serpentshrine Cavern"] = "Caverna Santuario Serpiente"
L["Set map opacity"] = "Opacidad del mapa"
L["Set map opacity while stationary and while moving."] = "Establece la opacidad del mapa mientras está parado y en movimiento."
L["Set the group icon size."] = "Establece el tamaño del icono de grupo."
L["Set the maximum zoom scale."] = "Establece la escala de zoom máxima."
L["Set the player arrow size."] = "Establece el tamaño de la flecha del jugador."
L["Sethekk Halls"] = "Salas Sethekk"
L["Settings"] = "Configuración"
L["Sewers"] = "Cloacas"
L["Shadebough"] = "Ramasombría"
L["Shado-Pan Monastery"] = "Monasterio del Shadopan"
L["Shadow Labyrinth"] = "Laberinto de las Sombras"
L["Shadowfang Keep"] = "Castillo de Colmillo Oscuro"
L["Shadowlands"] = "Tierras de las Sombras"
L["Shadowmoon Burial Grounds"] = "Cementerio de Luna Negra"
L["Shadowmoon Valley"] = "Valle Sombraluna"
L["Shadowmoon Village"] = "Aldea Sombraluna"
L["Shadowprey Village"] = "Aldea Cazasombras"
L["Shal'Aran"] = "Shal'Aran"
L["Shalewind Canyon"] = "Cañón del Viento Calizo"
L["Shatter Point"] = "Punto de Fragmentación"
L["Shattrath"] = "Shattrath"
L["Shattrath City"] = "Ciudad de Shattrath"
L["Shimmering Expanse"] = "Extensión Bruñida"
L["Sholazar Basin"] = "Cuenca de Sholazar"
L["Show additional icons"] = "Mostrar iconos adicionales"
L["Show background"] = "Mostrar fondo"
L["Show boats, zeppelins and trams"] = "Mostrar barcos, zepelines y tranvías"
L["Show coordinates"] = "Coordenadas"
L["Show digsites"] = "Mostrar sitios de excavación arqueológica"
L["Show dungeons and raids"] = "Mostrar mazmorras y bandas"
L["Show minimap button"] = "Botón del minimapa"
L["Show minimum fishing skill levels"] = "Mostrar nivel mínimo de habilidad de pesca"
L["Show objectives"] = "Mostrar objetivos"
L["Show points of interest"] = "Puntos de interés"
L["Show scale handle"] = "Mostrar asa de escala"
L["Show spirit healers"] = "Mostrar Ángel de la Resurrección"
L["Show travel points for opposing faction"] = "Mostrar puntos de viaje para la facción contraria"
L["Show travel points for same faction"] = "Mostrar puntos de viaje para la misma facción"
L["Show unexplored areas"] = "Áreas inexploradas"
L["Show zone crossings"] = "Mostrar cruces de zona"
L["Show zone levels"] = "Nivel de zona"
L["Show zone menus"] = "Mostrar menús de zona"
L["Shrine of Aviana"] = "Santuario de Aviana"
L["Shrine of the Storm"] = "Santuario de la Tormenta"
L["Side entrance"] = "Entrada lateral"
L["Siege of Boralus"] = "Asedio de Boralus"
L["Siege of Niuzao Temple"] = "Asedio del Templo de Niuzao"
L["Siege of Orgrimmar"] = "Asedio de Orgrimmar"
L["Silithus"] = "Silithus"
L["Silver Tide Hollow"] = "Cuenca de Marea Argenta"
L["Silvermoon"] = "Entrañas"
L["Silvermoon City"] = "Ciudad de Lunargenta"
L["Silverpine Forest"] = "Bosque de Argénteos"
L["Silverwind Refuge"] = "Refugio Brisa de Plata"
L["Skyreach"] = "Cielo Pujante"
L["Slave Pens"] = "Recinto de los Esclavos"
L["Sludgewerks"] = "Los Fangados"
L["South"] = "Sur"
L["South Gate Pass"] = "Paso de la Puerta Sur"
L["Southern Barrens"] = "Los Baldíos del Sur"
L["Southfury River"] = "Río Furia del Sur"
L["Southshore"] = "Costasur"
L["Spinebreaker Ridge"] = "Cresta Rompeloma"
L["Spires of Ascension"] = "Agujas de Ascensión"
L["Spirit Healer"] = "Ángel de la Resurrección"
L["Splintertree Post"] = "Puesto del Hachazo"
L["Stardust Spire"] = "Aguja del Polvo Estelar"
L["Stars' Rest"] = "Reposo Estelar"
L["Stationary"] = "Estacionario"
L["Steamvault"] = "La Cámara de Vapor"
L["Sticky map frame"] = "Mapa pegajoso"
L["Stonard"] = "Rocal"
L["Stonebreaker Hold"] = "Bastión Rompepedras"
L["Stonemaul Hold"] = "Bastión Quebrantarrocas"
L["Stonetalon Mountains"] = "Sierra Espolón"
L["Stonetalon Peak"] = "Cima del Espolón"
L["Stormstout Brewery"] = "Cervecería del Trueno"
L["Stormwind"] = "Ventormenta"
L["Stormwind City"] = "Ciudad de Ventormenta"
L["Strahnbrad"] = "Strahnbrad"
L["Stranglethorn Vale"] = "Vega de Tuercespina"
L["Stratholme (Main Gate)"] = "Stratholme (entrada principal)"
L["Stratholme (Service Gate)"] = "Stratholme (puerta de servicio)"
L["Stratholme: Crusader's Square"] = "Stratholme: Plaza del Cruzado"
L["Stratholme: The Gauntlet"] = "Stratholme: El Reto"
L["Stygian Bounty"] = "Recompensa Estigia"
L["sum"] = "invo"
L["Sun Rock Retreat"] = "Refugio Roca del Sol"
L["Sunreaver's Command"] = "Mando de los Atracasol"
L["Sun's Reach Harbor"] = "Puerto Alcance del Sol"
L["Sunveil Excursion"] = "Excursión Velosolar"
L["Sunwell Plateau"] = "Meseta de La Fuente del Sol"
L["Surwich"] = "Mechasur"
L["Swamp of Sorrows"] = "Pantanos de las Penas"
L["Swamprat Post"] = "Avanzada Rata del Pantano"
L["Sylvanaar"] = "Sylvanaar"
L["Synthesis Forge"] = "Forja de Síntesis"
L["System"] = "Sistema"
L["Talonbranch Glade"] = "Claro Ramaespolón"
L["Talrendis Point"] = "Punta Talrendis"
L["Tanaris"] = "Tanaris"
L["Tarren Mill"] = "Molino Tarren"
L["Taunka'le Village"] = "Aldea Taunka'le"
L["Taxi to Scholar's Den"] = "Taxi a Guarida del Erudito"
L["Taxi to Vault of Secrets"] = "Taxi a Cámara de los Secretos"
L["Tazavesh, the Veiled Market"] = "Tazavesh, el Mercado Velado"
L["Telaar"] = "Telaar"
L["Tel'anor"] = "Tel'anor"
L["Teldrassil"] = "Teldrassil"
L["Teleport Crystal"] = "Cristal de Teleportación"
L["Telredor"] = "Telredor"
L["Tempest Keep"] = "El Castillo de la Tempestad"
L["Temple of Ahn'Qiraj"] = "Templo de Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Templo de Atal'Hakkar"
L["Temple of Sethraliss"] = "Templo de Sethraliss"
L["Temple of Telhamat"] = "Templo de Telhamat"
L["Temple of the Jade Serpent"] = "Templo de la Serpiente de Jade"
L["Temple of the Moon"] = "Templo de la Luna"
L["Tenebrous Cavern"] = "Caverna Tenebrosa"
L["Terokkar Forest"] = "Bosque de Terokkar"
L["Terrace of Endless Spring"] = "Terraza de la Primavera Eterna"
L["Thalanaar"] = "Thalanaar"
L["Thandol Span"] = "Puente Thandol"
L["Thargad's Camp"] = "Campo de Thargad"
L["The Arcatraz"] = "El Arcatraz"
L["The Arcway"] = "El Arcódromo"
L["The Argent Stand"] = "El Bastión Argenta"
L["The Argent Vanguard"] = "La Vanguardia Argenta"
L["The Azure Vault"] = "La Cámara Azur"
L["The Barrens"] = "Los Baldíos"
L["The Bastion of Twilight"] = "El Bastión del Crepúsculo"
L["The Black Morass"] = "La Ciénaga Negra"
L["The Blood Furnace"] = "El Horno de Sangre"
L["The Botanica"] = "El Invernáculo"
L["The Bulwark"] = "El Baluarte"
L["The Cape of Stranglethorn"] = "El Cabo de Tuercespina"
L["The Crossroads"] = "El Cruce"
L["The Culling of Stratholme"] = "La Matanza de Stratholme"
L["The Dark Portal"] = "El Portal Oscuro"
L["The Deadmines"] = "Las Minas de la Muerte"
L["The Dragon Soul"] = "El Alma de Dragón"
L["The Emerald Nightmare"] = "La Pesadilla Esmeralda"
L["The Everbloom"] = "El Vergel Eterno"
L["The Exodar"] = "El Exodar"
L["The Eye"] = "El Ojo"
L["The Eye of Eternity"] = "El Ojo de la Eternidad"
L["The Forge of Souls"] = "Forja de Almas"
L["The Forgotten Coast"] = "La Costa Olvidada"
L["The Frozen Halls"] = "Las Salas Heladas"
L["The Great Forge"] = "La Gran Fundición"
L["The Great Lift"] = "El Gran Elevador"
L["The Halls of Reflection"] = "Las Salas de la Reflexión"
L["The Harborage"] = "El Puerto"
L["The Hinterlands"] = "Tierras del Interior"
L["The Krazzworks"] = "La Krazzería"
L["The Mechanar"] = "El Mechanar"
L["The Menders' Stead"] = "La Finca de los Ensalmadores"
L["The Mor'shan Rampart"] = "La Empalizada Mor'shan"
L["The MOTHERLODE!!"] = "¡¡La MEGAEXCAVADORA!!"
L["The Necrotic Wake"] = "La Vigilia Necrótica"
L["The Nexus"] = "El Nexo"
L["The Nighthold"] = "Bastión Nocturno"
L["The Nokhud Offensive"] = "La Ofensiva Nokhud"
L["The Obsidian Sanctum"] = "El Sagrario Obsidiana"
L["The Oculus"] = "El Oculus"
L["The Old Kingdom"] = "El Antiguo Reino"
L["The Overlook Cliffs"] = "Los Acantilados Dominantes"
L["The Pit of Saron"] = "La Fosa de Saron"
L["The Ruby Sanctum"] = "El Sagrario Rubí"
L["The Sepulcher"] = "El Sepulcro"
L["The Shadow Vault"] = "La Bóveda de las Sombras"
L["The Shattered Halls"] = "Las Salas Arrasadas"
L["The Stockade"] = "Las Mazmorras"
L["The Stonecore"] = "El Núcleo Pétreo"
L["The Storm Peaks"] = "Las Cumbres Tormentosas"
L["The Stormspire"] = "Flecha de la Tormenta"
L["The Talondeep Path"] = "El Paso del Espolón"
L["The Underrot"] = "El Vértice Abisal"
L["The Vault of Lights"] = "La Bóveda de las Luces"
L["The Violet Hold"] = "El Bastión Violeta"
L["The Vortex Pinnacle"] = "La Cima del Vórtice"
L["The Waning Crescent"] = "La Cuna Creciente"
L["The Zoram Strand"] = "La Ensenada de Zoram"
L["Theater of Pain"] = "Teatro del Dolor"
L["Thelsamar"] = "Thelsamar"
L["Theramore Isle"] = "Isla Theramore"
L["Thondroril River"] = "Río Thondroril"
L["Thorium Point"] = "Puesto del Torio"
L["Thousand Needles"] = "Las Mil Agujas"
L["Thrallmar"] = "Thrallmar"
L["Throne of the Four Winds"] = "Trono de los Cuatro Vientos"
L["Throne of the Tides"] = "Trono de las Mareas"
L["Throne of Thunder"] = "Trono del Trueno"
L["Thunder Bluff"] = "Cima del Trueno"
L["Thunderlord Stronghold"] = "Bastión Señor del Trueno"
L["Thundermar"] = "Bramal"
L["Timbermaw Hold"] = "Bastión de los Fauces de Madera"
L["Tinker Town"] = "Ciudad Manitas"
L["Tint unexplored areas"] = "Teñir áreas inexploradas"
L["Tiragarde Sound"] = "Estrecho de Tiragarde"
L["Tirisfal Glades"] = "Claros de Tirisfal"
L["Titan Translocator"] = "Translocador Titánico"
L["Toggle panel"] = "Alternar panel"
L["Tol Barad"] = "Tol Barad"
L["Tomb of Sargeras"] = "Tumba de Sargeras"
L["Toshley's Station"] = "Estación de Toshley"
L["Trade District"] = "Distrito de Mercaderes"
L["Trade Quarter"] = "Barrio del Comercio"
L["Tram to"] = "Tranvía a"
L["Tranquillien"] = "Tranquillien"
L["Transitus Shield"] = "Escudo de Transitus"
L["Transparency"] = "Transparencia"
L["Trial of the Champion"] = "Prueba del Campeón"
L["Trial of the Crusader"] = "Prueba del Cruzado"
L["Trial of Valor"] = "Prueba del Valor"
L["Twilight Highlands"] = "Tierras Altas Crepusculares"
L["Twilight Shore"] = "Orilla Crepuscular"
L["Twilight Vale"] = "Valle Crepuscular"
L["Twilight Vineyards"] = "Viñedos Crepusculares"
L["Uldaman"] = "Uldaman"
L["Uldaman (rear entrance)"] = "Uldaman (entrada trasera)"
L["Uldaman (side entrance)"] = "Uldaman (entrada lateral)"
L["Uldaman: Legacy of Tyr"] = "Uldaman: Legado de Tyr"
L["Uldir"] = "Uldir"
L["Ulduar"] = "Ulduar"
L["Uldum"] = "Uldum"
L["Underbog"] = "La Sotiénaga"
L["Undercity"] = "Entrañas"
L["Un'Goro Crater"] = "Cráter de Un'Goro"
L["Unlock battlefield map"] = "Desbloquear mapa de campo de batalla"
L["Unlock map frame"] = "Desbloquear mapa"
L["Unu'pe"] = "Unu'pe"
L["Upper Blackrock Spire"] = "Cumbre de Roca Negra Superior"
L["Use default map"] = "Mapa predeterminado"
L["Use large font"] = "Usar fuente grande"
L["Use stationary opacity while pointing at map"] = "Usa opacidad estacionaria mientras apunta al mapa"
L["Utgarde Keep"] = "Fortaleza de Utgarde"
L["Utgarde Pinnacle"] = "Pico de Utgarde"
L["Valaar's Berth"] = "Atracadero de Valaar"
L["Valdrakken Portals"] = "Portales de Valdrakken"
L["Valgarde"] = "Valgarde"
L["Valgarde Port"] = "Puerto Valgarde"
L["Valiance Keep"] = "Fortaleza de la Valentía"
L["Valiance Landing Camp"] = "Campamento de Aterrizaje de la Valentía"
L["Valley of Strength"] = "El Valle de la Fuerza"
L["Valormok"] = "Valormok"
L["Vashj'ir"] = "Vashj'ir"
L["Vault of Archavon"] = "La Cámara de Archavon"
L["Vault of the Incarnates"] = "La Cámara de los Encarnados"
L["Vault of the Wardens"] = "La Cámara de las Celadoras"
L["Vengeance Landing"] = "Desembarco de la Venganza"
L["Venomspite"] = "Veneno Filspanto"
L["Version"] = "Versión"
L["Vol'mar"] = "Vol'mar"
L["Wailing Caverns"] = "Cuevas de los Lamentos"
L["Warsong Camp"] = "Campamento Grito de Guerra"
L["Warsong Hold"] = "Bastión Grito de Guerra"
L["Waycrest Manor"] = "Mansión Crestavía"
L["Well of Eternity"] = "Pozo de la Eternidad"
L["Western Earthshrine"] = "Santuario Tierras del Oeste"
L["Western Plaguelands"] = "Tierras de la Peste del Oeste"
L["Westfall"] = "Páramos de Poniente"
L["Westfall Brigade"] = "Brigada de los Páramos de Poniente"
L["Westguard Keep"] = "Fortaleza de la Guardia Oeste"
L["Wetlands"] = "Los Humedales"
L["Wildhammer Stronghold"] = "Bastión Martillo Salvaje"
L["Windowed"] = "Ventana"
L["Windrunner's Overlook"] = "Mirador de Brisaveloz"
L["Wintergarde Keep"] = "Fortaleza de Guardia Invernal"
L["Wintergrasp"] = "Cuenca de Sholazar"
L["Winterspring"] = "Cuna del Invierno"
L["World of Warcraft Classic"] = "World of Warcraft Clásico"
L["Wrath of the Lich King Classic"] = "Ira del Rey Exánime Clásica"
L["Wyrmrest Temple"] = "Templo del Reposo del Dragón"
L["You cannot do that in combat."] = "No puedes hacer eso en combate."
L["You will die!"] = "¡Morirás!"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Tu interfaz de usuario necesita recargarse para que algunos de los cambios surtan efecto.|n|nNo es necesario hacer clic en el botón de recarga de inmediato, pero sí debes hacerlo cuando hayas terminado de realizar cambios y quieras que estos surtan efecto."
L["Your UI needs to be reloaded."] = "La IU necesita ser recargada."
L["Zabra'jin"] = "Zabra'jin"
L["Zangarmarsh"] = "Marisma de Zangar"
L["Zeb'Sora"] = "Zeb'Sora"
L["Zeppelin to"] = "Zepelín a"
L["Zim'Torga"] = "Zim'Torga"
L["Zone Map"] = "Mapa de zona"
L["Zoom"] = "Zoom"
L["Zoram'gar Outpost"] = "Avanzada de Zoram'gar"
L["Zul'Aman"] = "Zul'Aman"
L["Zuldazar"] = "Zuldazar"
L["Zul'Drak"] = "Zul'Drak"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"

end

-- frFR: French
if GameLocale == "frFR" then
L["(destination only)"] = "(destination seulement)"
L["(inside Caverns of Time)"] = "(à l'intérieur de la Grotte du Temps)"
L["/ltm help - Show this information."] = "/ltm help - Affiche ces informations."
L["/ltm reset - Reset the panel position."] = "/ltm reset - Réinitialise la position du panneau."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - Effacez tous les paramètres et rechargez."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "Une erreur d'arrêt s'est produite mais ne vous inquiétez pas. Cela peut arriver de temps en temps. Cliquez sur le bouton de rechargement pour le résoudre."
L["Acherus: The Ebon Hold"] = "Achérus : le fort d'Ébène"
L["Aerie Peak"] = "Nid-de-l'Aigle"
L["Agmar's Hammer"] = "Marteau d'Agmar"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Aldor"] = "Aldor"
L["Algeth'ar Academy"] = "Académie d'Algeth'ar"
L["Allerian Stronghold"] = "Bastion allérien"
L["Alliance Cities"] = "Villes de l'Alliance"
L["Allow frame movement"] = "Autoriser le mouvement de la fenêtre"
L["Alpha"] = "Alpha"
L["Altar of Sha'tar"] = "Autel de Sha'tar"
L["Alterac Mountains"] = "Montagnes d'Alterac"
L["Always"] = "Toujours"
L["Amber Lodge"] = "Pavillon d'Ambre"
L["Amberpine Lodge"] = "Pavillon de Pinambre"
L["Andorhal"] = "Andorhal"
L["Antorus, the Burning Throne"] = "Antorus, le Trône ardent"
L["Apothecary Camp"] = "Camp d'Apothicaire"
L["Appearance"] = "Apparence"
L["Arathi Highlands"] = "Hautes-terres d'Arathi"
L["Area 52"] = "Zone 52"
L["Argent Tournament Grounds"] = "Enceinte du tournoi d'Argent"
L["Armory"] = "Armurerie"
L["Ashenvale"] = "Orneval"
L["Astranaar"] = "Astranaar"
L["Astravar Harbor"] = "Port d'Astravar"
L["Atal'Dazar"] = "Atal'Dazar"
L["Auberdine"] = "Auberdine"
L["Auchenai Crypts"] = "Cryptes Auchenaï"
L["Auchindoun"] = "Auchindoun"
L["Auto change zones"] = "Changer les zones"
L["available during zone attack"] = "disponible pendant l'attaque de la zone"
L["Azeroth"] = "Azeroth"
L["Azjol-Nerub"] = "Azjol-Nérub"
L["Azshara"] = "Azshara"
L["Azuremyst Isle"] = "Île de Brume-Azur"
L["Back to Main Menu"] = "Retour au menu principal"
L["Badlands"] = "Terres ingrates"
L["Baradin Hold"] = "Bastion de Baradin"
L["Battle of Dazar'alor"] = "Bataille de Dazar’alor"
L["Battlegrounds"] = "Champs de bataille"
L["Black Morass"] = "Le Noir marécage"
L["Black Rook Hold"] = "Bastion du Freux"
L["Black Temple"] = "Le Temple noir"
L["Blackfathom Deeps"] = "Profondeurs de Brassenoire"
L["Blackrock Caverns"] = "Cavernes de Rochenoire"
L["Blackrock Depths"] = "Profondeurs de Rochenoire"
L["Blackrock Foundry"] = "Fonderie des Rochenoires"
L["Blackrock Mountain"] = "Mont Rochenoire"
L["Blackrock Spire"] = "Pic Rochenoire"
L["Blackwing Descent"] = "Descente de l’Aile noire"
L["Blackwing Lair"] = "Repaire de l'Aile noire"
L["Blade Tooth Canyon"] = "Canyon Croc-Lame"
L["Blade's Edge Mountains"] = "Les Tranchantes"
L["Blades' Run"] = "Piste des Lames"
L["Blasted Lands"] = "Terres foudroyées"
L["Blood Watch"] = "Guet du sang"
L["Bloodmaul Slag Mines"] = "Mine de la Masse-Sanglante"
L["Bloodmyst Isle"] = "Île de Brume-Sang"
L["Bloodvenom Post"] = "Poste de la Vénéneuse"
L["Blue"] = "Bleu"
L["Boat to"] = "Bateau à"
L["Booty Bay"] = "Baie-du-Butin"
L["Borean Tundra"] = "Toundra Boréenne"
L["Bor'gorok Outpost"] = "Avant-poste Bor'gorok"
L["Bouldercrag's Refuge"] = "Refuge de Rochéchine"
L["Brackenhide Hollow"] = "Creux des Fougerobes"
L["Brackenwall Village"] = "Mur-de-Fougères"
L["Burning Crusade Classic"] = "Burning Crusade Classic"
L["Burning Steppes"] = "Steppes ardentes"
L["Camp Mojache"] = "Camp Mojache"
L["Camp Oneqwah"] = "Camp Oneqwah"
L["Camp Taurajo"] = "Camp Taurajo"
L["Camp Tunka'lo"] = "Camp Tunka'lo"
L["Camp Winterhoof"] = "Camp Sabot-d'Hiver"
L["Cannot be used with Use default map."] = "Ne peut pas être utilisé avec la carte par défaut."
L["Cannot be used with Use default map.|n|nTo adjust map opacity, right-click the map frame title bar."] = "Ne peut pas être utilisé avec la carte par défaut.|n|nPour ajuster l’opacité de la carte, cliquez avec le bouton droit sur la barre de titre du cadre de la carte."
L["Castle Nathria"] = "Château Nathria"
L["Cathedral"] = "Cathédrale"
L["Cathedral of Eternal Night"] = "Cathédrale de la Nuit éternelle"
L["Caverns of Time"] = "Grottes du temps"
L["Cenarion Hold"] = "Fort Cénarien"
L["Center map on player"] = "Centrer sur le joueur"
L["Central Mesa"] = "Mesa centrale"
L["Chamber of Heart"] = "Chambre du Cœur"
L["Chillwind Camp"] = "Camp du Noroît"
L["Choose where the zone map should be shown."] = "Choisissez où la carte de zone doit être affichée."
L["Class colored icons"] = "Icônes colorées"
L["Classic"] = "Classique"
L["Click to configure the settings for this option."] = "Cliquez pour configurer les paramètres de cette option."
L["Click to reset the position and scale of the map frame."] = "Cliquez pour réinitialiser la position et l'échelle du cadre de la carte."
L["Click to reset the settings on this page."] = "Cliquez pour réinitialiser les paramètres de cette page."
L["Click to return to the main menu."] = "Cliquez pour revenir au menu principal."
L["Coilfang Reservoir"] = "Réservoir de Glissecroc"
L["Coldarra"] = "Gelarra"
L["Configuration Panel"] = "Panneau de configuration"
L["Conquest Hold"] = "Bastion de la Conquête"
L["Cosmic"] = "Cosmique"
L["Cosmowrench"] = "Cosmovrille"
L["Court of Stars"] = "Cour des Étoiles"
L["Crucible of Storms"] = "Creuset des Tempêtes"
L["Crusaders' Pinnacle"] = "Pinacle des Croisés"
L["Crystalsong Forest"] = "Forêt du Chant de cristal"
L["Culling of Stratholme"] = "Le Purge d'Stratholme"
L["Cursor"] = "Curseur"
L["Dalaran"] = "Dalaran"
L["Dalaran Crater"] = "Cratère de Dalaran"
L["Darkheart Thicket"] = "Fourré Sombrecœur"
L["Darkshire"] = "Darkshire"
L["Darkshore"] = "Sombrivage"
L["Darnassus"] = "Darnassus"
L["De Other Side"] = "L’Autre côté"
L["Deadwind Pass"] = "Défilé de Deuillevent"
L["Death's Rise"] = "Ascension de la Mort"
L["Debug"] = "Debug"
L["Deepholm"] = "Le Tréfonds"
L["Desolace"] = "Désolace"
L["Dire Maul (East)"] = "Hache-Tripes (Est)"
L["Dire Maul (East) (side entrance)"] = "Hache-Tripes (Est) (entrée latérale)"
L["Dire Maul (East): Warpwood Quarter"] = "Hache-Tripes (Est) : Quartier de Crochebois"
L["Dire Maul (North)"] = "Hache-Tripes (Nord)"
L["Dire Maul (North): Gordok Commons"] = "Hache-Tripes (Nord) : Grands jardins"
L["Dire Maul (West)"] = "Hache-tripes (Ouest)"
L["Dire Maul (West): Capital Gardens"] = "Hache-Tripes (Nord) : Grands jardins"
L["Dire Maul: Capital Gardens"] = "Hache-Tripes: Grands Jardins"
L["Dire Maul: Gordok Commons"] = "Hache-Tripes: Communs Gordok"
L["Dire Maul: Warpwood Quarter"] = "Hache-Tripes: Quartier de Crochebois"
L["Disable map fade"] = "Désactiver la transparence de la map"
L["Disable reading emote"] = "Désactiver l'emote lecture"
L["Disable reading emote when opening the map"] = "Désactiver l'emote lors de l'ouverture de la carte"
L["disabled"] = "désactivé"
L["Drag"] = "Faites glisser"
L["Drag to set the amount of blue."] = "Faites glisser pour définir la quantité de bleu."
L["Drag to set the amount of green."] = "Faites glisser pour définir la quantité de vert."
L["Drag to set the amount of red."] = "Faites glisser pour définir la quantité de rouge."
L["Drag to set the battlefield map opacity."] = "Faites glisser pour définir l'opacité de la carte du champ de bataille."
L["Drag to set the battlefield map size."] = "Faites glisser pour définir la taille de la carte du champ de bataille."
L["Drag to set the battlefield map size.|n|nIf the map is unlocked, you can also resize the battlefield map by dragging the bottom-right corner."] = "Faites glisser pour définir la taille de la carte du champ de bataille.|n|nSi la carte est déverrouillée, vous pouvez également redimensionner la carte du champ de bataille en faisant glisser le coin inférieur droit."
L["Drag to set the group icon size."] = "Faites glisser pour définir la taille de l'icône du groupe."
L["Drag to set the map opacity for when your character is moving."] = "Faites glisser pour définir l'opacité de la carte lorsque votre personnage se déplace."
L["Drag to set the map opacity for when your character is stationary."] = "Faites glisser pour définir l'opacité de la carte lorsque votre personnage est à l'arrêt."
L["Drag to set the maximum zoom level.|n|nOpen the battlefield map to see the maximum zoom level change as you drag the slider."] = "Faites glisser pour définir le niveau de zoom maximum.|n|nOuvrez la carte du champ de bataille pour voir le changement de niveau de zoom maximum lorsque vous faites glisser le curseur."
L["Drag to set the maximum zoom level.|n|nOpen the map to see the maximum zoom level change as you drag the slider."] = "Faites glisser pour définir le niveau de zoom maximal.|n|nOuvrez la carte pour voir le changement de niveau de zoom maximal lorsque vous faites glisser le curseur."
L["Drag to set the opacity."] = "Faites glisser pour définir l'opacité."
L["Drag to set the player arrow size."] = "Faites glisser pour définir la taille de la flèche du lecteur."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "Faites glisser pour définir la taille de la flèche du lecteur.|n|nLa valeur par défaut de Wow Classic est 16.|nLa valeur par défaut de Wow Retail est 27."
L["Drag to set the scale for the maximised map."] = "Glisser pour définir l'échelle de la carte plein écran."
L["Drag to set the scale for the windowed map."] = "Glisser pour définir l'échelle de la carte fenêtrée."
L["Drag to set the world map scale.|n|nYou can also rescale the world map by dragging the bottom-right corner."] = "Faites glisser pour définir l'échelle de la carte du monde.|n|nVous pouvez également redimensionner la carte du monde en faisant glisser le coin inférieur droit."
L["Dragon Soul"] = "L’Âme des dragons"
L["Dragonblight"] = "Désolation des dragons"
L["Drak'Tharon Keep"] = "Donjon de Drak'Tharon"
L["Druid only flight point to Darnassus"] = "Point de vol réservé aux druides vers Darnassus"
L["Druid only flight point to Thunder Bluff"] = "Point de vol réservé aux druides vers Les Pitons-du-Tonnerre"
L["Dun Algaz"] = "Dun Algaz"
L["Dun Morogh"] = "Dun Morogh"
L["Dun Nifflelem"] = "Dun Niffelem"
L["Dungeon"] = "Donjon"
L["Dungeon (requires Crescent Key)"] = "Donjon (nécessite la Clé du croissant)"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Bois de la Pénombre"
L["Dustwallow Marsh"] = "Marécage d'Âprefange"
L["Dwarven District"] = "Quartier des Nains"
L["Eastern Earthshrine"] = "Sanctuaire Terrestre de l'Est"
L["Eastern Plaguelands"] = "Maleterres de l'est"
L["Ebon Watch"] = "Guette-ébène"
L["Elements"] = "Visibilité"
L["Elwynn Forest"] = "Forêt d'Elwynn"
L["Emerald Dream"] = "Rêve d’émeraude"
L["Emerald Sanctuary"] = "Sanctuaire d'émeraude"
L["enabled"] = "activé"
L["End Time"] = "La Fin des temps"
L["Enhance battlefield map"] = "Carte du champ de bataille"
L["Enhance dungeon icons"] = "Améliore les icönes de donjon"
L["Enlarge player arrow"] = "Flèche du joueur"
L["Enter"] = "Entrer"
L["Evergrove"] = "Bosquet éternel"
L["Everlook"] = "Long-Guet"
L["Evermoon Terrace"] = "Terrasse de Sempiterlune"
L["Eversong Woods"] = "Bois des Chants éternels"
L["Exile's Hollow"] = "Creux de l'Exile"
L["Exodar"] = "L'Exodar"
L["Eye of Azshara"] = "L’Œil d’Azshara"
L["Falanaar"] = "Falanaar"
L["Falcon Watch"] = "Guet de l'épervier"
L["Faldir's Cove"] = "La Crique de Faldir"
L["Feathermoon Stronghold"] = "Bastion de Feathermoon"
L["Felsoul Hold"] = "Bastion Gangrâme"
L["Felwood"] = "Gangrebois"
L["Feralas"] = "Féralas"
L["Firelands"] = "Terres de Feu"
L["Fishing"] = "Pêche"
L["Fizzcrank Airstrip"] = "Piste de la Foudreflèche"
L["Flame Crest"] = "Corniche des Flammes"
L["Flayedwing Transporter"] = "Transporteur aile-écorchée"
L["Follow the eastward path"] = "Suis le chemin vers l'est"
L["Follow the westward path"] = "Suis le chemin vers l'ouest"
L["Fordragon Hold"] = "Fort-de-Dragon"
L["Forest Song"] = "Chant de la forêt"
L["Fort Wildervar"] = "Fort-Viridien"
L["Freehold"] = "Port-Liberté"
L["Freewind Post"] = "Poste de Librevent"
L["Frosthold"] = "Halte d'Angrathar"
L["Gadgetzan"] = "Gadgetzan"
L["Garadar"] = "Garadar"
L["Gate of the Setting Sun"] = "Porte du Soleil couchant"
L["Gates of Valor"] = "Portes des Valeureux"
L["Ghostlands"] = "Les terres Fantômes"
L["Gnomeregan"] = "Gnomeregan"
L["Graveyard"] = "Cimetière"
L["Green"] = "Vert"
L["Grim Batol"] = "Grim Batol"
L["Grimrail Depot"] = "Dépôt de Tristerail"
L["Grizzly Hills"] = "Les Grisonnes"
L["Grom'arsh Crash Site"] = "Site du crash de Grom'arsh"
L["Grom'gol Base Camp"] = "Campement Grom'Gol"
L["Group Icons"] = "Icônes de groupe"
L["Gruul's Lair"] = "Repaire de Gruul"
L["Gundrak"] = "Gundrak"
L["Gundrak (rear entrance)"] = "Gundrak (entrée arrière)"
L["Hall of Ancient Paths"] = "Hall des Voies antiques"
L["Halls of Atonement"] = "Salles de l’Expiation"
L["Halls of Infusion"] = "Salles de l’Imprégnation"
L["Halls of Lightning"] = "Salles de Foudre"
L["Halls of Origination"] = "Salles de l’Origine"
L["Halls of Stone"] = "Salles de Pierre"
L["Halls of Valor"] = "Salles des Valeureux"
L["Hammerfall"] = "Trépas-d'Orgrim"
L["Head down the mountain from here."] = "Descendez la montagne à partir d'ici."
L["Head southeast from here and go up the mountain."] = "Dirigez-vous vers le sud-est à partir d'ici et montez la montagne."
L["Heart of Fear"] = "Cœur de la peur"
L["Hellfire Citadel"] = "Citadelle des Flammes infernales"
L["Hellfire Peninsula"] = "Péninsule des Flammes infernales"
L["Hellfire Ramparts"] = "Remparts des Flammes infernales"
L["Hide filter reset button"] = "Cacher le bouton de réinitialisation du filtre"
L["Hide town and city icons"] = "Villes et cités"
L["Highmaul"] = "Cognefort"
L["Hillsbrad Foothills"] = "Contreforts d'Hillsbrad"
L["Honor Hold"] = "Bastion de l'Honneur"
L["Horde Cities"] = "Villes de la Horde"
L["Hour of Twilight"] = "L’Heure du Crépuscule"
L["Howling Fjord"] = "Fjord Hurlant"
L["Hyjal"] = "Hyjal"
L["Hyjal Summit"] = "Sommet d’Hyjal"
L["Icecrown"] = "Couronne de glace"
L["Icecrown Citadel"] = "Citadelle de la Couronne de glace"
L["Icons"] = "Icônes"
L["If checked, additional icons (such as portals) will be shown."] = "Si cette option est cochée, des icônes supplémentaires (comme les portails) seront affichées."
L["If checked, archaeology digsites will be shown."] = "Si cette option est cochée, les sites de fouilles archéologiques seront affichés."
L["If checked, coordinates will be shown."] = "Si cette option est cochée, les coordonnées seront affichées."
L["If checked, coordinates will have a dark background texture."] = "Si cette option est cochée, les coordonnées auront une texture de fond noir."
L["If checked, coordinates will use a large font."] = "Si cette option est cochée, les coordonnées utiliseront une grande police."
L["If checked, dungeons and raids will be shown."] = "Si cette option est cochée, les donjons et les raids seront affichés."
L["If checked, group icons will use a modern, class-colored design."] = "Si cette option est cochée, les icônes de groupe utiliseront un design moderne de couleur de classe."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "Si cette option est cochée, l'ouverture de la carte utilisera le même niveau de zoom que lors de sa dernière fermeture tant que la zone de la carte n'a pas changé."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "Si cette option est cochée, le fait de pointer la carte pendant le déplacement de votre personnage entraînera l'application du paramètre d'opacité stationnaire."
L["If checked, points of interest will be shown."] = "Si cette option est cochée, les points d'intérêt seront affichés."
L["If checked, quest objectives will be shown."] = "Si cette option est cochée, les objectifs de quête seront affichés."
L["If checked, spirit healers will be shown."] = "Si cette option est cochée, les Gardien des âmes seront affichés."
L["If checked, the battlefield map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Si cette option est cochée, la carte du champ de bataille restera centrée sur votre emplacement tant que vous n'êtes pas dans un donjon.|n|nVous pouvez maintenir la touche Maj enfoncée tout en déplaçant la carte pour l'empêcher temporairement de se centrer."
L["If checked, the default fullscreen map will be used for the maximised map.|n|nNote that enabling this option will lock out some of the other options."] = "Si cette option est cochée, la carte plein écran par défaut sera utilisée pour la carte agrandie.|n|nNotez que l'activation de cette option verrouillera certaines des autres options."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "Si cette option est cochée, la carte plein écran par défaut sera utilisée.|n|nNotez que l'activation de cette option bloquera certaines des autres options."
L["If checked, the map border will be removed."] = "Si cette option est cochée, la bordure de la carte sera supprimée."
L["If checked, the map frame will remain open until you close it."] = "Si cette option est cochée, le cadre de la carte restera ouvert jusqu'à ce que vous le fermiez."
L["If checked, the map will not fade while your character is moving."] = "Si cette option est cochée, la carte ne s'estompera pas pendant que votre personnage se déplace."
L["If checked, the map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Si cette option est cochée, la carte restera centrée sur votre emplacement tant que vous n'êtes pas dans un donjon.|n|nVous pouvez maintenir la touche Maj enfoncée tout en déplaçant la carte pour l'empêcher temporairement de se centrer."
L["If checked, the minimap button will be shown."] = "Si cette option est cochée, le bouton de la minicarte sera affiché."
L["If checked, the minimum fishing skill levels will be shown."] = "Si cette option est cochée, les niveaux de compétence de pêche minimum seront affichés."
L["If checked, the world map filter reset button will be hidden."] = "Si cette option est cochée, le bouton de réinitialisation du filtre de la carte du monde sera caché."
L["If checked, town and city icons will not be shown on the continent maps."] = "Si cette option est cochée, les icônes de ville et de cité ne seront pas affichées sur les cartes du continent."
L["If checked, travel points for the opposing faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Si cette option est cochée, les points de voyage de la faction adverse seront affichés.|n|nCela inclut les points de vol, les ports de bateaux, les tours de zeppelin et les stations de tram."
L["If checked, travel points for the same faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Si cette option est cochée, les points de voyage pour la même faction seront affichés.|n|nCela inclut les points de vol, les ports de bateaux, les tours de zeppelin et les stations de tram."
L["If checked, unexplored areas of the map will be shown on the world map and the battlefield map."] = "Si cette option est cochée, les zones inexplorées de la carte seront affichées sur la carte du monde et la carte du champ de bataille."
L["If checked, unexplored areas will be tinted."] = "Si cette option est cochée, les zones inexplorées seront teintées."
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "Si cette option est cochée, lorsque votre personnage change de zone, la carte passe automatiquement à la nouvelle zone."
L["If checked, you can move the battlefield map by dragging any of its borders."] = "Si cette option est cochée, vous pouvez déplacer la carte du champ de bataille en faisant glisser n'importe lequel de ses bords."
L["If checked, you can move the battlefield map by dragging any of its borders.|n|nYou can resize the battlefield map by dragging the bottom-right corner."] = "Si cette option est cochée, vous pouvez déplacer la carte du champ de bataille en faisant glisser n'importe laquelle de ses bordures.|n|nVous pouvez redimensionner la carte du champ de bataille en faisant glisser le coin inférieur droit."
L["If checked, you will be able to customise the battlefield map."] = "Si cette option est cochée, vous pourrez personnaliser la carte du champ de bataille."
L["If checked, you will be able to enlarge the player arrow."] = "Si cette option est cochée, vous pourrez agrandir la flèche du joueur."
L["If checked, you will be able to move the frame by dragging the border."] = "Si cette option est cochée, vous pourrez déplacer le cadre en faisant glisser la bordure."
L["If checked, you will be able to move the map.|n|nThe map position will be saved separately for the maximised and windowed maps."] = "Si cette option est cochée, vous pourrez déplacer la carte.|n|nLa position de la carte sera enregistrée séparément pour les cartes agrandies et fenêtrées."
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges."] = "Si cette option est cochée, vous pourrez redimensionner et déplacer la carte.|n|nMettez la carte à l'échelle en traîner la poignée d'échelle dans le coin inférieur droit.|n|nDéplacez la carte en traîner la bordure et les bords du cadre."
L["If checked, you will be able to scale the map by dragging the scale handle in the bottom-right corner.|n|nYou will be able to move the map by dragging any border.|n|nYou can always drag the top border to move the map regardless of this setting."] = "Si cette option est cochée, vous pourrez mettre à l'échelle la carte en faisant glisser la poignée d'échelle dans le coin inférieur droit. |n|nVous pourrez déplacer la carte en faisant glisser n'importe quel bord. |n|nVous pouvez toujours faire glisser le bord supérieur pour déplacer la carte indépendamment de ce paramètre."
L["If checked, you will be able to scale the map."] = "Si cette option est cochée, vous pourrez changer l'échelle de la carte."
L["If checked, you will be able to set the opacity of the map."] = "Si cette option est cochée, vous pourrez définir l'opacité de la carte."
L["If checked, you will be able to zoom further into the world map."] = "Si cette option est cochée, vous pourrez zoomer davantage sur la carte du monde."
L["If checked, your character will not perform the reading emote when you open the map."] = "Si cette option est cochée, votre personnage n'exécutera pas l'emote de lecture lorsque vous ouvrirez la carte."
L["If checked, zone and continent dropdown menus will be shown in the map frame."] = "Si cette option est cochée, les menus déroulants de la zone et du continent s'afficheront dans le cadre de la carte."
L["If checked, zone and dungeon levels will be shown."] = "Si cette option est cochée, les niveaux des zones et des donjons seront affichés."
L["If checked, zone crossings will be shown.|n|nThese are clickable arrows that indicate the zone exit pathways."] = "Si cette option est cochée, les traversées de zone seront affichées.|n|nIl s'agit de flèches cliquables qui indiquent les voies de sortie de zone."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "Si cette option est cochée, les niveaux de compétence de zone, de donjon et de pêche seront affichés."
L["Increase zoom level"] = "Augmenter zoom"
L["Invalid command.  Enter /ltm help for help."] = "Commande non valide. Entrez /ltm help pour obtenir de l'aide."
L["Invalid map ID."] = "ID de carte non valide."
L["Iron Docks"] = "Quais de Fer"
L["Ironforge"] = "Forgefer"
L["Isle of Quel'Danas"] = "Île de Quel'Danas"
L["Just follow the path west"] = "Suis le chemin vers l'ouest"
L["K3"] = "K3"
L["Kamagua"] = "Kamagua"
L["Karazhan"] = "Karazhan"
L["Kargath"] = "Kargath"
L["Kings' Rest"] = "Repos des rois"
L["Kor'kron Vanguard"] = "Vanguard Kor'kron"
L["Lake Elune'ara"] = "Lac Elune'ara"
L["Lake Everstill"] = "Lac Placide"
L["Large Scarab Coffer"] = "Grand coffre de scarabées"
L["Leads to Tirisfal Glades"] = "Mène à Clairières de Tirisfal"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS : UNE VERSION INCORRECTE EST INSTALLÉE !"
L["Library"] = "Bibliothèque"
L["Light's Breach"] = "Brèche de la Lumière"
L["Light's Hope Chapel"] = "Chapelle de l'Espoir de Lumière"
L["Lion's Watch"] = "Guet du Lion"
L["Loch Modan"] = "Loch Modan"
L["Lost City of the Tol'vir"] = "Cité perdue des Tol’vir"
L["Lower Blackrock Spire"] = "Bas du pic Rochenoire"
L["Lunastre Estate"] = "Domaine Lunastre"
L["Magisters' Terrace"] = "Terrasse des Magistères"
L["Magtheridon's Lair"] = "Le repaire de Magtheridon"
L["Mana-Tombs"] = "Tombes-mana"
L["Map frame scale"] = "Échelle du cadre de la carte"
L["Map Opacity"] = "Opacité de la carte"
L["Map Scale"] = "Échelle de la carte"
L["Map Size"] = "Taille de la carte"
L["Maraudon"] = "Maraudon"
L["Maraudon: Earth Song Falls"] = "Maraudon: Chutes de Chanteterre"
L["Maraudon: Foulspore Cavern"] = "Maraudon: Caverne Vilespore"
L["Maraudon: The Wicked Grotto"] = "Maraudon: Grotte Maudite"
L["Marshal's Refuge"] = "Refuge des Marshal"
L["Maw of Souls"] = "Gueule des Âmes"
L["Max Zoom"] = "Zoom maximal"
L["Maximised"] = "Maximisé"
L["Maximum"] = "Maximum"
L["Mechanics"] = "Mécanique"
L["Memory Usage"] = "Utilisation de la mémoire"
L["Menethil Harbor"] = "Port de Menethil"
L["Miscellaneous"] = "Divers"
L["Mists of Tirna Scithe"] = "Brumes de Tirna Scithe"
L["Moa'ki"] = "Moa'ki"
L["Moa'ki Harbor"] = "Port Moa'ki"
L["Mogu'shan Palace"] = "Palais Mogu’shan"
L["Mogu'shan Vaults"] = "Caveaux Mogu’shan"
L["Mok'Nathal Village"] = "Mok'Nathal"
L["Molten Core"] = "Cœur du Magma"
L["Moon Guard Stronghold"] = "Bastion de la garde de la Lune"
L["Moonglade"] = "Reflet-de-Lune"
L["More"] = "Plus"
L["Morgan's Vigil"] = "Veille de Morgan"
L["Mount Crafting"] = "Fabrication de montures"
L["Mount Hyjal"] = "Mont Hyjal"
L["Mountain Pass (Horde Only)"] = "Défilé de Montagne (Horde uniquement)"
L["Moving"] = "En mouvement"
L["Mudsprocket"] = "Bourbe-à-Brac"
L["Mulgore"] = "Mulgore"
L["Nagrand"] = "Nagrand"
L["Naxxramas"] = "Naxxramas"
L["Nazjatar"] = "Nazjatar"
L["Neltharion's Lair"] = "Repaire de Neltharion"
L["Neltharus"] = "Neltharus"
L["Nesingwary Base Camp"] = "Camp de base de Nesingwary"
L["Nethergarde Keep"] = "Rempart-du-Néant"
L["Netherstorm"] = "Raz-de-Néant"
L["Never"] = "Jamais"
L["New Agamand"] = "Nouvelle-Agamand"
L["Nighthaven"] = "Havrenuit"
L["Nijel's Point"] = "Combe de Nijel"
L["North"] = "Nord"
L["North Gate Pass"] = "Passage de la porte Nord"
L["Ny'alotha, The Waking City"] = "Ny’alotha, la cité en éveil"
L["Ohn'ahran Plains"] = "Plaines d’Ohn’ahra"
L["Old Hillsbrad"] = "Vieil Hillsbrad"
L["Old Hillsbrad Foothills"] = "Contreforts de Hautebrande d’antan"
L["Onyxia's Lair"] = "Repaire d'Onyxia"
L["Opacity"] = "Opacité"
L["Operation: Mechagon"] = "Opération Mécagone"
L["or click the minimap button to open Leatrix Maps."] = "ou cliquez sur le bouton de la minicarte pour ouvrir Leatrix Maps."
L["Orb of Translocation"] = "Orbe de translocation"
L["Orebor Harborage"] = "Havre d'Orebor"
L["Orgrimmar"] = "Orgrimmar"
L["Oribos"] = "Oribos"
L["Pet Crafting"] = "Fabrication de mascottes"
L["Plaguefall"] = "Malepeste"
L["Player"] = "Joueur"
L["Player Arrow"] = "Flèche du joueur"
L["Portal"] = "Portail"
L["Portal from Zephyr"] = "Portail de Zephyr"
L["Portals"] = "Portails"
L["Preview"] = "Voir en avant-première"
L["Protoform Repository"] = "Dépôt des Protoformes"
L["Ragefire Chasm"] = "Gouffre de Ragefeu"
L["Raid"] = "Raid"
L["Ratchet"] = "Cabestan"
L["Ravenholdt Manor"] = "Manoir de Ravenholdt"
L["Razorfen Downs"] = "Souilles de Tranchebauge"
L["Razorfen Kraul"] = "Kraal de Tranchebauge"
L["Razorthorn Trail"] = "Sentier de Rasoir"
L["Rebel Camp"] = "Camp rebelle"
L["Red"] = "Rouge"
L["Redridge Mountains"] = "Les Carmines"
L["Refuge Pointe"] = "Refuge de l'Ornière"
L["Reload"] = "Recharger"
L["Remember zoom level"] = "Niveau de zoom"
L["Remove map border"] = "Bordure de la carte"
L["req"] = "exige"
L["Requires Key to Searing Gorge"] = "Nécessite Clé de la gorge des Vents brûlants"
L["Requires UI reload."] = "Nécessite le rechargement de l'interface utilisateur."
L["Reset"] = "Réinitialiser"
L["Reset Map Layout"] = "Réinitialiser la disposition de la carte"
L["Return to Karazhan"] = "Retour à Karazhan"
L["Revantusk Village"] = "Village des Revantusk"
L["River's Heart"] = "Cœur de la Rivière"
L["Ruby Life Pools"] = "Bassins de l’Essence rubis"
L["Ruins of Ahn'Qiraj"] = "Ruines d'Ahn'Qiraj"
L["Ruins of Elune'eth"] = "Ruines d’Elune’eth"
L["Rut'Theran Village"] = "Village de Rut'Theran"
L["Rut'theran Village"] = "Village de Rut'theran"
L["Sanctuary"] = "Sanctuaire"
L["Sanctum of Domination"] = "Sanctum de Domination"
L["Sanctum of Order"] = "Sanctum de l’Ordre"
L["Sanctum of the Sages"] = "Sanctum des Sages"
L["Sanctum of the Stars"] = "Sanctum des étoiles"
L["Sanguine Depths"] = "Profondeurs Sanguines"
L["Scale"] = "Échelle"
L["Scale the map"] = "Mettre la carte à l'échelle"
L["Scarlet Halls"] = "Salles Écarlates"
L["Scarlet Monastery"] = "Monastère écarlate"
L["Scholomance"] = "Scholomance"
L["Searing Gorge"] = "Gorge des Vents brûlants"
L["Seat of the Naaru"] = "Siège des Naaru"
L["Seat of the Triumvirate"] = "Siège du triumvirat"
L["Sentinel Hill"] = "Colline des Sentinelles"
L["Sepulcher of the First Ones"] = "Sépulcre des Fondateurs"
L["Serpentshrine Cavern"] = "Caverne du sanctuaire du Serpent"
L["Set map opacity"] = "Opacité de la carte"
L["Set map opacity while stationary and while moving."] = "Définissez l'opacité de la carte à l'arrêt et en mouvement."
L["Set the group icon size."] = "Définissez la taille de l'icône du groupe."
L["Set the maximum zoom scale."] = "Définissez l'échelle de zoom maximale."
L["Set the player arrow size."] = "Définissez la taille de la flèche du lecteur."
L["Sethekk Halls"] = "Les salles des Sethekk"
L["Settings"] = "Paramètres"
L["Sewers"] = "Égouts"
L["Shado-Pan Monastery"] = "Monastère des Pandashan"
L["Shadow Labyrinth"] = "Labyrinthe des Ombres"
L["Shadowfang Keep"] = "Donjon d'Ombrecroc"
L["Shadowlands"] = "Ombreterre"
L["Shadowmoon Burial Grounds"] = "Terres sacrées d’Ombrelune"
L["Shadowmoon Valley"] = "Vallée d’Ombrelune"
L["Shadowmoon Village"] = "Village d'Ombrelune"
L["Shadowprey Village"] = "Proie-de-l'Ombre"
L["Shal'Aran"] = "Shal'Aran"
L["Shatter Point"] = "Point de Rupture"
L["Shattrath"] = "Shattrath"
L["Shattrath City"] = "Cité de Shattrath"
L["Sholazar Basin"] = "Bassin de Sholazar"
L["Show background"] = "Afficher l'arrière-plan"
L["Show boats, zeppelins and trams"] = "Afficher les bateaux, les zeppelins et les trams"
L["Show coordinates"] = "Coordonnées"
L["Show digsites"] = "Afficher les sites de fouilles archéologiques"
L["Show dungeons and raids"] = "Afficher les donjons et les raids"
L["Show minimap button"] = "Bouton de la minicarte"
L["Show minimum fishing skill levels"] = "Afficher les niveaux de compétence de pêche minimum"
L["Show objectives"] = "Afficher les objectifs"
L["Show points of interest"] = "Points d'intérêt"
L["Show scale handle"] = "Afficher la poignée de l'échelle"
L["Show spirit healers"] = "Afficher les Gardiens des âmes"
L["Show travel points for opposing faction"] = "Afficher les points de déplacement pour la faction adverse"
L["Show travel points for same faction"] = "Afficher les points de voyage pour la même faction"
L["Show unexplored areas"] = "Zones inexplorées"
L["Show zone crossings"] = "Afficher les traversées de zone"
L["Show zone levels"] = "Niveaux de zone"
L["Show zone menus"] = "Menus de zone"
L["Shrine of the Storm"] = "Sanctuaire des Tempêtes"
L["Siege of Boralus"] = "Siège de Boralus"
L["Siege of Niuzao Temple"] = "Siège du temple de Niuzao"
L["Siege of Orgrimmar"] = "Siège d’Orgrimmar"
L["Silithus"] = "Silithus"
L["Silvermoon"] = "Lune-d'Argent"
L["Silvermoon City"] = "Lune-d’Argent"
L["Silverpine Forest"] = "Forêt des Pins argentés"
L["Skyreach"] = "Orée-du-Ciel"
L["Slave Pens"] = "Les enclos aux esclaves"
L["South"] = "Sud"
L["South Gate Pass"] = "Passage de la porte Sud"
L["Southfury River"] = "Rivière Furie-du-Sud"
L["Southshore"] = "Southshore"
L["Spinebreaker Ridge"] = "Crête Brise-échine"
L["Spires of Ascension"] = "Flèches de l’Ascension"
L["Spirit Healer"] = "Gardien des âmes"
L["Splintertree Post"] = "Poste de Bois-brisé"
L["Stars' Rest"] = "Repos des Étoiles"
L["Stationary"] = "Stationnaire"
L["Steamvault"] = "Le caveau de la Vapeur"
L["Sticky map frame"] = "Carte collante"
L["Stonard"] = "Stonard"
L["Stonebreaker Hold"] = "Fort des Brise-Pierres"
L["Stonetalon Mountains"] = "Les Serres-Rocheuses"
L["Stonetalon Peak"] = "Pic des Serres-Rocheuses"
L["Stormstout Brewery"] = "Brasserie Brune d’Orage"
L["Stormwind"] = "Hurlevent"
L["Stormwind City"] = "Hurlevent"
L["Stranglethorn Vale"] = "Vallée de Strangleronce"
L["Stratholme (Main Gate)"] = "Stratholme (porte principale)"
L["Stratholme (Service Gate)"] = "Stratholme (porte de service)"
L["Stratholme: Crusader's Square"] = "Stratholme: Place des Croisés"
L["Stratholme: The Gauntlet"] = "Stratholme: Le Défi"
L["sum"] = "convoquer"
L["Sun Rock Retreat"] = "Retraite de Roche-Soleil"
L["Sunreaver's Command"] = "Commandement de la Saccage-soleil"
L["Sun's Reach Harbor"] = "Port du Brasier solaire"
L["Sunwell Plateau"] = "Plateau du Puits de soleil"
L["Swamp of Sorrows"] = "Marais des Chagrins"
L["Swamprat Post"] = "Poste du Rat des marais"
L["Sylvanaar"] = "Sylvanaar"
L["Synthesis Forge"] = "Forge de synthèse"
L["System"] = "Système"
L["Talonbranch Glade"] = "Clairière de Griffebranche"
L["Talrendis Point"] = "Halte de Talrendis"
L["Tanaris"] = "Tanaris"
L["Tarren Mill"] = "Moulin-de-Tarren"
L["Taunka'le Village"] = "Village de Taunka'le"
L["Taxi to Scholar's Den"] = "Trajet pour Le refuge de l'Érudit"
L["Taxi to Vault of Secrets"] = "Trajet pour Le caveau des Secrets"
L["Tazavesh, the Veiled Market"] = "Tazavesh, le marché dissimulé"
L["Telaar"] = "Telaar"
L["Tel'anor"] = "Tel'anor"
L["Teldrassil"] = "Teldrassil"
L["Teleport Crystal"] = "Cristal de téléportation"
L["Telredor"] = "Telredor"
L["Tempest Keep"] = "Donjon de la Tempête"
L["Temple of Ahn'Qiraj"] = "Temple d'Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Le temple d'Atal'Hakkar"
L["Temple of Sethraliss"] = "Temple de Sephraliss"
L["Temple of Telhamat"] = "Temple de Telhamat"
L["Temple of the Jade Serpent"] = "Temple du Serpent de jade"
L["Temple of the Moon"] = "Le Temple de la Lune"
L["Terokkar Forest"] = "Forêt de Terokkar"
L["Terrace of Endless Spring"] = "Terrasse Printanière"
L["Thalanaar"] = "Thalanaar"
L["Thandol Span"] = "Viaduc de Thandol"
L["The Arcatraz"] = "L’Arcatraz"
L["The Arcway"] = "L’Arcavia"
L["The Argent Stand"] = "Le Séjour d'Argent"
L["The Argent Vanguard"] = "L'Avant-garde d'Argent"
L["The Azure Vault"] = "Caveau d’Azur"
L["The Barrens"] = "Les Tarides"
L["The Bastion of Twilight"] = "Le bastion du Crépuscule"
L["The Black Morass"] = "Le Noir Marécage"
L["The Blood Furnace"] = "La Fournaise du sang"
L["The Botanica"] = "La Botanica"
L["The Bulwark"] = "La Barricade"
L["The Crossroads"] = "La Croisée"
L["The Culling of Stratholme"] = "L'Épuration de Stratholme"
L["The Dark Portal"] = "Porte des ténèbres"
L["The Deadmines"] = "Les Mortemines"
L["The Dragon Soul"] = "L’Âme des dragons"
L["The Emerald Nightmare"] = "Le Cauchemar d’émeraude"
L["The Everbloom"] = "La Flore éternelle"
L["The Exodar"] = "L'Exodar"
L["The Eye"] = "L'Œil"
L["The Eye of Eternity"] = "L'Œil de l'Éternité"
L["The Forge of Souls"] = "La Forge des Âmes"
L["The Forgotten Coast"] = "La Côte oubliée"
L["The Frozen Halls"] = "Les Halls Gelés"
L["The Great Forge"] = "La Grande Forge"
L["The Great Lift"] = "Grande élévation"
L["The Halls of Reflection"] = "Les Salles des Reflets"
L["The Hinterlands"] = "Les Hinterlands"
L["The Mechanar"] = "Le Méchanar"
L["The MOTHERLODE!!"] = "Le Filon"
L["The Necrotic Wake"] = "Sillage nécrotique"
L["The Nexus"] = "Le Nexus"
L["The Nighthold"] = "Palais Sacrenuit"
L["The Nokhud Offensive"] = "L’Offensive Nokhud"
L["The Obsidian Sanctum"] = "Le Sanctum Obsidien"
L["The Oculus"] = "L'Oculus"
L["The Old Kingdom"] = "L'Ancien royaume"
L["The Overlook Cliffs"] = "Les Hauts-Surplombs"
L["The Pit of Saron"] = "La Fosse de Saron"
L["The Ruby Sanctum"] = "Le Sanctum Rubis"
L["The Sepulcher"] = "Le Sépulcre"
L["The Shadow Vault"] = "La Voûte de l'Ombre"
L["The Shattered Halls"] = "Les salles Brisées"
L["The Stockade"] = "La Prison"
L["The Stonecore"] = "Le Cœur-de-Pierre"
L["The Storm Peaks"] = "Les pics Foudroyés"
L["The Stormspire"] = "La Foudreflèche"
L["The Talondeep Path"] = "La Perce des Serres"
L["The Underrot"] = "Tréfonds Putrides"
L["The Vault of Lights"] = "Le Caveau des Lumières"
L["The Violet Hold"] = "L'Étage Violet"
L["The Vortex Pinnacle"] = "La cime du Vortex"
L["The Waning Crescent"] = "La Lune descendante"
L["The Zoram Strand"] = "La grève de Zoram"
L["Theater of Pain"] = "Théâtre de la Souffrance"
L["Thelsamar"] = "Thelsamar"
L["Theramore Isle"] = "Île de Theramore"
L["Thorium Point"] = "Halte du Thorium"
L["Thousand Needles"] = "Mille pointes"
L["Thrallmar"] = "Thrallmar"
L["Throne of the Four Winds"] = "Trône des quatre vents"
L["Throne of the Tides"] = "Trône des marées"
L["Throne of Thunder"] = "Trône du tonnerre"
L["Thunder Bluff"] = "Les Pitons-du-Tonnerre"
L["Thunderlord Stronghold"] = "Bastion des Sire-tonnerre"
L["Timbermaw Hold"] = "Repaire des Grumegueules"
L["Tinker Town"] = "Brikabrok"
L["Tint unexplored areas"] = "Teinter des zones inexplorées"
L["Tiragarde Sound"] = "Rade de Tiragarde"
L["Tirisfal Glades"] = "Clairières de Tirisfal"
L["Titan Translocator"] = "Transposeur des Titans"
L["Toggle panel"] = "Basculer le panneau"
L["Tol Barad"] = "Tol Barad"
L["Tomb of Sargeras"] = "Tombe de Sargeras"
L["Toshley's Station"] = "Poste de Toshley"
L["Trade District"] = "Quartier Commercant"
L["Trade Quarter"] = "Quartier des Marchands"
L["Tram to"] = "Tram à"
L["Tranquillien"] = "Tranquillien"
L["Transitus Shield"] = "Bouclier de Transitus"
L["Transparency"] = "Transparence"
L["Trial of the Champion"] = "L'Épreuve du Champion"
L["Trial of the Crusader"] = "L'Épreuve du Croisé"
L["Trial of Valor"] = "Le Jugement des Valeureux"
L["Twilight Highlands"] = "Hautes-terres du Crépuscule"
L["Twilight Shore"] = "Rivage du crépuscule"
L["Twilight Vale"] = "Vallée du Crépuscule"
L["Twilight Vineyards"] = "Vignobles du Crépuscule"
L["Uldaman"] = "Uldaman"
L["Uldaman (side entrance)"] = "Uldaman (entrée latérale)"
L["Uldaman: Legacy of Tyr"] = "Uldaman : l'héritage de Tyr"
L["Uldir"] = "Uldir"
L["Ulduar"] = "Ulduar"
L["Uldum"] = "Uldum"
L["Underbog"] = "La Basse-tourbière"
L["Undercity"] = "Fossoyeuse"
L["Un'Goro Crater"] = "Cratère d'Un'Goro"
L["Unlock battlefield map"] = "Déverrouiller la carte du champ de bataille"
L["Unlock map frame"] = "Déverrouiller la carte"
L["Unu'pe"] = "Unu'pe"
L["Upper Blackrock Spire"] = "Sommet du pic Rochenoire"
L["Use default map"] = "Carte par défaut"
L["Use large font"] = "Utiliser une grande police"
L["Use stationary opacity while pointing at map"] = "Utilisez l'opacité stationnaire tout en pointant sur la carte"
L["Utgarde Keep"] = "Donjon d'Utgarde"
L["Utgarde Pinnacle"] = "Cime d'Utgarde"
L["Valaar's Berth"] = "Amarrage de Valaar"
L["Valdrakken Portals"] = "Portails de Valdrakken"
L["Valgarde"] = "Valgarde"
L["Valgarde Port"] = "Port de Valgarde"
L["Valiance Keep"] = "Donjon de la Vaillance"
L["Valiance Landing Camp"] = "Camp d'atterrissage de la Vaillance"
L["Valley of Strength"] = "Vallée de la Force"
L["Valormok"] = "Valormok"
L["Vashj'ir"] = "Vashj'ir"
L["Vault of Archavon"] = "Caveau d'Archavon"
L["Vault of the Incarnates"] = "Caveau des Incarnations"
L["Vault of the Wardens"] = "Caveau des Gardiennes"
L["Vengeance Landing"] = "Halte de la Vengeance"
L["Venomspite"] = "Venimspire"
L["Version"] = "Version"
L["Vol'mar"] = "Vol'mar"
L["Wailing Caverns"] = "Cavernes des lamentations"
L["Warsong Camp"] = "Camp Chanteguerre"
L["Warsong Hold"] = "Bastion Chanteguerre"
L["Waycrest Manor"] = "Manoir Malvoie"
L["Well of Eternity"] = "Puits d’éternité"
L["Western Earthshrine"] = "Sanctuaire Terrestre de l'Ouest"
L["Western Plaguelands"] = "Maleterres de l'ouest"
L["Westfall"] = "Marche de l'Ouest"
L["Westfall Brigade"] = "Brigade de la marche de l'Ouest"
L["Westguard Keep"] = "Donjon de la Garde de l'Ouest"
L["Wetlands"] = "Les Paluns"
L["Wildhammer Stronghold"] = "Bastion Marteau-Hardi"
L["Windowed"] = "Fenêtré"
L["Windrunner's Overlook"] = "Surplomb de Coursevent"
L["Wintergarde Keep"] = "Donjon de Garde-hiver"
L["Wintergrasp"] = "Joug-d'hiver"
L["Winterspring"] = "Berceau-de-l'Hiver"
L["World of Warcraft Classic"] = "World of Warcraft Classique"
L["Wrath of the Lich King Classic"] = "Classique : Wrath of the Lich King"
L["Wyrmrest Temple"] = "Temple du Repos du Ver"
L["You cannot do that in combat."] = "Vous ne pouvez pas faire ça en combat."
L["You will die!"] = "Vous allez mourir !"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Votre interface utilisateur doit être rechargée pour que certaines des modifications prennent effet.|n|nVous n'avez pas besoin de cliquer immédiatement sur le bouton de rechargement, mais vous devez le cliquer lorsque vous avez terminé d'apporter des modifications et que vous souhaitez que les modifications prennent effet."
L["Your UI needs to be reloaded."] = "Votre interface utilisateur doit être rechargée."
L["Zabra'jin"] = "Zabra'jin"
L["Zangarmarsh"] = "Marécage de Zangar"
L["Zeb'Sora"] = "Zeb'Sora"
L["Zeppelin to"] = "Zeppelin à"
L["Zim'Torga"] = "Zim'Torga"
L["Zone Map"] = "Carte des zones"
L["Zoom"] = "Zoom"
L["Zoram'gar Outpost"] = "L’Avant-poste de Zoram'gar"
L["Zul'Aman"] = "Zul'Aman"
L["Zuldazar"] = "Zuldazar"
L["Zul'Drak"] = "Zul'Drak"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"

end

-- itIT: Italian
if GameLocale == "itIT" then
L["/ltm help - Show this information."] = "/ltm help - Mostra queste informazioni."
L["/ltm reset - Reset the panel position."] = "/ltm reset - Reimposta la posizione del pannello."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - Cancella tutte le impostazioni e ricarica."
L["Algeth'ar Academy"] = "Accademia di Algeth'ar"
L["Allow frame movement"] = "Consentire il movimento del frame"
L["Antorus, the Burning Throne"] = "Antorus, il Trono Infuocato"
L["Appearance"] = "Aspetto"
L["Astravar Harbor"] = "Porto di Astravar"
L["Auchenai Crypts"] = "Cripte degli Auchanei"
L["available during zone attack"] = "disponibile durante l'attacco di zona"
L["Back to Main Menu"] = "Indietro al menu principale"
L["Baradin Hold"] = "Forte di Baradin"
L["Battle of Dazar'alor"] = "Battaglia di Dazar'alor"
L["Black Morass"] = "Palude Nera"
L["Black Rook Hold"] = "Forte Corvonero"
L["Black Temple"] = "Tempio Nero"
L["Blackfathom Deeps"] = "Abissi di Fondocupo"
L["Blackrock Caverns"] = "Caverne di Roccianera"
L["Blackrock Depths"] = "Sotterranei di Roccianera"
L["Blackrock Foundry"] = "Fonderia dei Roccianera"
L["Blackrock Mountain"] = "Massiccio Roccianera"
L["Blackrock Spire"] = "Bastioni di Roccianera"
L["Blackwing Descent"] = "Sotterranei dell'Ala Nera"
L["Blackwing Lair"] = "Fortezza dell'Ala Nera"
L["Bloodmaul Slag Mines"] = "Miniere dei Magliorosso"
L["Blue"] = "Blu"
L["Brackenhide Hollow"] = "Conca dei Felcepelle"
L["Castle Nathria"] = "Castello di Nathria"
L["Cathedral of Eternal Night"] = "Cattedrale della Notte Eterna"
L["Caverns of Time"] = "Caverne del Tempo"
L["Center map on player"] = "Centra la mappa sul giocatore"
L["Chamber of Heart"] = "Sala del Cuore"
L["Click to configure the settings for this option."] = "Fare clic per configurare le impostazioni per questa opzione."
L["Click to reset the settings on this page."] = "Fare clic per ripristinare le impostazioni in questa pagina."
L["Click to return to the main menu."] = "Fare clic per tornare al menu principale."
L["Coilfang Reservoir"] = "Bacino degli Spiraguzza"
L["Configuration Panel"] = "Pannello di Configurazione"
L["Court of Stars"] = "Corte delle Stelle"
L["Crucible of Storms"] = "Crogiolo delle Tempeste"
L["Culling of Stratholme"] = "Epurazione di Stratholme "
L["Cursor"] = "Cursore"
L["Darkheart Thicket"] = "Boschetto Cuortetro"
L["De Other Side"] = "Aldilà"
L["Deepholm"] = "Rocciafonda"
L["Dire Maul: Capital Gardens"] = "Maglio Infausto: Giardini della Capitale "
L["Dire Maul: Gordok Commons"] = "Maglio Infausto: Sale di Gordock"
L["Dire Maul: Warpwood Quarter"] = "Maglio Infausto: Quartiere di Legnotorto"
L["Disable map fade"] = "Disattiva la dissolvenza della mappa"
L["Disable reading emote"] = "Disattiva l'emoticon di lettura"
L["disabled"] = "disabilitato"
L["Drag to set the amount of blue."] = "Trascina per impostare la quantità di blu."
L["Drag to set the amount of green."] = "Trascina per impostare la quantità di verde."
L["Drag to set the amount of red."] = "Trascina per impostare la quantità di rosso."
L["Drag to set the battlefield map opacity."] = "Trascina per impostare l'opacità della mappa del campo di battaglia."
L["Drag to set the battlefield map size.|n|nIf the map is unlocked, you can also resize the battlefield map by dragging the bottom-right corner."] = "Trascina per impostare le dimensioni della mappa del campo di battaglia.|n|nSe la mappa è sbloccata, puoi anche ridimensionarla trascinando l'angolo in basso a destra."
L["Drag to set the group icon size."] = "Trascina per impostare la dimensione dell'icona del gruppo."
L["Drag to set the maximum zoom level.|n|nOpen the battlefield map to see the maximum zoom level change as you drag the slider."] = "Trascina per impostare il livello di zoom massimo.|n|nApri la mappa del campo di battaglia per vedere la variazione del livello di zoom massimo mentre trascini il cursore."
L["Drag to set the maximum zoom level.|n|nOpen the map to see the maximum zoom level change as you drag the slider."] = "Trascina per impostare il livello di zoom massimo.|n|nApri la mappa per vedere la variazione del livello di zoom massimo mentre trascini il cursore."
L["Drag to set the opacity."] = "Trascina per impostare l'opacità."
L["Drag to set the player arrow size."] = "Trascina per impostare la dimensione della freccia del giocatore."
L["Drag to set the scale for the maximised map."] = "Trascina per impostare la scala della mappa ingrandita."
L["Drag to set the scale for the windowed map."] = "Trascina per impostare la scala della mappa in finestra."
L["Dragon Soul"] = "Anima del Drago"
L["Drak'Tharon Keep"] = "Forte di Drak'Tharon"
L["Dungeon"] = "Spedizione "
L["Eastern Earthshrine"] = "Santuario Orientale della Terra"
L["Elements"] = "Elementi"
L["Emerald Dream"] = "Sogno di Smeraldo"
L["enabled"] = "abilitato"
L["End Time"] = "Fine dei Tempi"
L["Enhance battlefield map"] = "Migliora la mappa del campo di battaglia"
L["Enhance dungeon icons"] = "Migliora le icone delle spedizioni "
L["Enter"] = "Accedere"
L["Evermoon Terrace"] = "Terrazza di Lunavespro"
L["Exile's Hollow"] = "Antro dell'Esule"
L["Eye of Azshara"] = "Occhi di Azshara"
L["Felsoul Hold"] = "Forte Vilanima"
L["Firelands"] = "Terre del Fuoco"
L["Flayedwing Transporter"] = "Trasportatore Alacucita"
L["Freehold"] = "Covo della Libertà "
L["Gate of the Setting Sun"] = "Porta del Sole Calante"
L["Gates of Valor"] = "Porte del Valore"
L["Green"] = "Verde"
L["Grimrail Depot"] = "Treno Frecciacupa"
L["Group Icons"] = "Icone del Gruppo"
L["Gruul's Lair"] = "Antro di Gruul's"
L["Gundrak (rear entrance)"] = "Gundrak (ingresso posteriore)"
L["Hall of Ancient Paths"] = "Sentieri degli Orrori Antichi "
L["Halls of Atonement"] = "Sale dell'Espiazione"
L["Halls of Infusion"] = "Sale dell'Infusione"
L["Halls of Lightning"] = "Sale del Fulmine"
L["Halls of Origination"] = "Sale dell'Origine"
L["Halls of Stone"] = "Sale della Pietra"
L["Halls of Valor"] = "Sale del Valore"
L["Heart of Fear"] = "Cuore della Paura"
L["Hellfire Citadel"] = "Cittadella del Fuoco Infernale"
L["Hellfire Peninsula"] = "Penisola del Fuoco Infernale"
L["Hellfire Ramparts"] = "Bastioni del Fuoco Infernale"
L["Hide filter reset button"] = "Nascondi il pulsante di reimpostazione del filtro"
L["Hide town and city icons"] = "Nascondi le icone delle città"
L["Highmaul"] = "Altomaglio"
L["Hour of Twilight"] = "Ora del Crepuscolo "
L["Howling Fjord"] = "Fiordo Echeggiante"
L["Hyjal Summit"] = "Sommità di Hyjal"
L["Icecrown"] = "Corona di Ghiaccio"
L["Icecrown Citadel"] = "Cittadella della Corona di Ghiaccio"
L["If checked, additional icons (such as portals) will be shown."] = "Se selezionato, verranno visualizzate icone aggiuntive (come i portali)."
L["If checked, coordinates will be shown."] = "Se selezionato, verranno mostrate le coordinate."
L["If checked, coordinates will have a dark background texture."] = "Se selezionata, le coordinate avranno una texture di sfondo scura."
L["If checked, coordinates will use a large font."] = "Se selezionato, le coordinate utilizzeranno un carattere grande."
L["If checked, dungeons and raids will be shown."] = "Se selezionato, verranno mostrate le spedizioni e incursioni."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "Se selezionato, l'apertura della mappa utilizzerà lo stesso livello di zoom dell'ultima volta che l'hai chiusa purché la zona della mappa non sia cambiata."
L["If checked, the battlefield map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Se selezionato, la mappa del campo di battaglia rimarrà centrata sulla tua posizione finché non ti trovi in ​​una spedizione.|n|nPuoi tenere premuto Maiusc mentre esegui la panoramica della mappa per impedirne temporaneamente il centraggio."
L["If checked, the default fullscreen map will be used for the maximised map.|n|nNote that enabling this option will lock out some of the other options."] = "Se selezionato, per la mappa ingrandita verrà utilizzata la mappa a schermo intero predefinita.|n|nNota che l'attivazione di questa opzione bloccherà alcune delle altre opzioni."
L["If checked, the map border will be removed."] = "Se selezionato, il bordo della mappa verrà rimosso."
L["If checked, the map frame will remain open until you close it."] = "Se selezionato, il frame della mappa rimarrà aperto finché non lo chiuderai."
L["If checked, the map will not fade while your character is moving."] = "Se selezionato, la mappa non svanirà mentre il tuo personaggio si muove."
L["If checked, the map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Se selezionato, la mappa rimarrà centrata sulla tua posizione finché non ti trovi in ​​una spedizione.|n|nPuoi tenere premuto Maiusc mentre esegui la panoramica della mappa per impedirne temporaneamente la centratura."
L["If checked, the minimap button will be shown."] = "Se selezionato, verrà mostrato il pulsante della minimappa."
L["If checked, town and city icons will not be shown on the continent maps."] = "Se selezionato, le icone dei paesi e delle città non verranno visualizzate sulle mappe dei continenti."
L["If checked, unexplored areas of the map will be shown on the world map and the battlefield map."] = "Se selezionato, le aree inesplorate della mappa verranno mostrate sulla mappa del mondo e sulla mappa del campo di battaglia."
L["If checked, unexplored areas will be tinted."] = "Se selezionato, le aree inesplorate verranno colorate."
L["If checked, you can move the battlefield map by dragging any of its borders."] = "Se selezionato, puoi spostare la mappa del campo di battaglia trascinando uno qualsiasi dei suoi bordi."
L["If checked, you will be able to customise the battlefield map."] = "Se selezionato, sarai in grado di personalizzare la mappa del campo di battaglia."
L["If checked, you will be able to move the frame by dragging the border."] = "Se selezionato, sarai in grado di spostare il frame trascinando il bordo."
L["If checked, you will be able to move the map.|n|nThe map position will be saved separately for the maximised and windowed maps."] = "Se selezionato, sarai in grado di spostare la mappa.|n|nLa posizione della mappa verrà salvata separatamente per le mappe ingrandite e in finestra."
L["If checked, you will be able to scale the map."] = "Se selezionato, sarai in grado di ridimensionare la mappa."
L["If checked, you will be able to zoom further into the world map."] = "Se selezionato, sarai in grado di ingrandire ulteriormente la mappa del mondo."
L["If checked, your character will not perform the reading emote when you open the map."] = "Se selezionato, il tuo personaggio non eseguirà l'emote di lettura quando apri la mappa."
L["Increase zoom level"] = "Aumenta il livello di zoom"
L["Invalid command.  Enter /ltm help for help."] = "Comando non valido. Inserisci /ltm help per ricevere aiuto."
L["Invalid map ID."] = "ID mappa non valido."
L["Iron Docks"] = "Darsena di Ferro"
L["Ironforge"] = "Forgiardente "
L["Isle of Quel'Danas"] = "Isola di Quel'Danas"
L["Kings' Rest"] = "Requie dei Re"
L["Large Scarab Coffer"] = "Grande Forziere dello Scarabeo"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS: INSTALLATA VERSIONE ERRATA!"
L["Lion's Watch"] = "Presidio del Leone"
L["Lost City of the Tol'vir"] = "Città Perduta dei Tol'vir"
L["Lower Blackrock Spire"] = "Bastioni di Roccianera Inferiori"
L["Lunastre Estate"] = "Tenuta dei Lunastra"
L["Magisters' Terrace"] = "Terrazza dei Magisteri"
L["Magtheridon's Lair"] = "Antro di Magtheridon"
L["Mana-Tombs"] = "Tombe del Mana"
L["Map Opacity"] = "Opacità della Mappa"
L["Map Size"] = "Dimensioni della Mappa"
L["Maraudon: Earth Song Falls"] = "Maraudon: Cascate Cantaterra"
L["Maraudon: Foulspore Cavern"] = "Maraudon: Caverna Spora Funesta"
L["Maraudon: The Wicked Grotto"] = "Maraudon: Grotta Perversa"
L["Maw of Souls"] = "Fauci delle Anime"
L["Max Zoom"] = "Zoom Massimo"
L["Maximised"] = "Massimizzato"
L["Mechanics"] = "Meccaniche"
L["Memory Usage"] = "Utilizzo della Memoria"
L["Mists of Tirna Scithe"] = "Nebbie di Tirna Falcis"
L["Moa'ki Harbor"] = "Porto di Moa'ki"
L["Mogu'shan Palace"] = "Palazzo Mogu'shan"
L["Mogu'shan Vaults"] = "Segrete Mogu'shan"
L["Molten Core"] = "Nucleo Ardente"
L["Moon Guard Stronghold"] = "Forte delle Guardie della Luna"
L["More"] = "Di più"
L["Mount Crafting"] = "Creazione di Cavalcature"
L["Mount Hyjal"] = "Monte Hyjal"
L["Neltharion's Lair"] = "Antro di Neltharion"
L["Ny'alotha, The Waking City"] = "Ny'alotha, La Città Risvegliata"
L["Ohn'ahran Plains"] = "Pianure di Ohn'ahran"
L["Old Hillsbrad Foothills"] = "Passato di Colletorto"
L["Onyxia's Lair"] = "Antro di Onyxia"
L["Opacity"] = "Opacità"
L["Operation: Mechagon"] = "Operazione: Meccagon"
L["or click the minimap button to open Leatrix Maps."] = "oppure fai clic sul pulsante della minimappa per aprire Leatrix Maps."
L["Orb of Translocation"] = "Sfera della Traslocazione"
L["Pet Crafting"] = "Creazione di Animali Domestici"
L["Plaguefall"] = "Piagafunesta"
L["Player"] = "Giocatore "
L["Player Arrow"] = "Freccia del Giocatore"
L["Portal"] = "Portale"
L["Portal from Zephyr"] = "Zephyr è un NPC."
L["Preview"] = "Anteprima"
L["Protoform Repository"] = "Deposito della Protoforma"
L["Ragefire Chasm"] = "Baratro di Fiamma Furente"
L["Raid"] = "Incursione"
L["Razorfen Downs"] = "Sotterranei di Lamaspina"
L["Razorfen Kraul"] = "Gallerie di Lamaspina"
L["Red"] = "Rosso"
L["Reload"] = "Ricaricare"
L["Remember zoom level"] = "Ricorda il livello di zoom"
L["Remove map border"] = "Rimuovi il bordo della mappa"
L["Requires UI reload."] = "Richiede il ricaricamento dell'interfaccia utente."
L["Reset"] = "Ripristina"
L["Reset Map Layout"] = "Reimposta il layout della mappa"
L["Return to Karazhan"] = "Ritorno a Karazhan"
L["Ruby Life Pools"] = "Pozze della Vita di Rubino "
L["Ruins of Ahn'Qiraj"] = "Rovine di Ahn'Qiraj"
L["Ruins of Elune'eth"] = "Rovine di Elune'eth"
L["Sanctuary"] = "Santuario"
L["Sanctum of Domination"] = "Sanctum del Dominio"
L["Sanctum of Order"] = "Sanctum dell'Ordine"
L["Sanctum of the Sages"] = "Sanctum dei Saggi"
L["Sanguine Depths"] = "Profondità Sanguigne"
L["Scale the map"] = "Ridimensiona la mappa"
L["Scarlet Halls"] = "Sale Scarlatte"
L["Scarlet Monastery"] = "Monastero Scarlatto"
L["Seat of the Triumvirate"] = "Seggio del Triumvirato"
L["Sepulcher of the First Ones"] = "Sepolcro dei Primi"
L["Serpentshrine Cavern"] = "Caverna di Sacrespire"
L["Set the maximum zoom scale."] = "Imposta la scala di zoom massima."
L["Sethekk Halls"] = "Sale dei Sethekk"
L["Settings"] = "Impostazioni "
L["Shado-Pan Monastery"] = "Monastero degli Shandaren"
L["Shadow Labyrinth"] = "Labirinto delle Ombre"
L["Shadowfang Keep"] = "Forte di Zannascura"
L["Shadowlands"] = "Terretetre"
L["Shadowmoon Burial Grounds"] = "Necropoli dei Torvaluna"
L["Show background"] = "Mostra lo sfondo"
L["Show coordinates"] = "Mostra le coordinate"
L["Show dungeons and raids"] = "Mostra spedizioni e incursioni"
L["Show minimap button"] = "Mostra pulsante minimappa"
L["Show unexplored areas"] = "Mostra aree inesplorate"
L["Shrine of the Storm"] = "Santuario della Tempesta"
L["Siege of Boralus"] = "Assedio di Boralus"
L["Siege of Niuzao Temple"] = "Assedio del Tempio di Niuzao"
L["Siege of Orgrimmar"] = "Assedio di Orgrimmar"
L["Silvermoon City"] = "Città di Lunargenta"
L["Skyreach"] = "Vetta dei Cieli"
L["Slave Pens"] = "Fosse degli Schiavi"
L["Spires of Ascension"] = "Guglie dell'Ascensione"
L["Steamvault"] = "Antro dei Vapori"
L["Sticky map frame"] = "Frame della mappa adesiva"
L["Stormstout Brewery"] = "Birrificio Triplo Malto"
L["Stormwind"] = "Roccavento"
L["Stranglethorn Vale"] = "Valle di Rovotorto"
L["Stratholme: Crusader's Square"] = "Stratholme: Piazza dei Crociati"
L["Stratholme: The Gauntlet"] = "Stratholme: Piazza della Sfida"
L["Sunwell Plateau"] = "Cittadella del Pozzo Solare"
L["Synthesis Forge"] = "Forgia della Sintasi"
L["System"] = "Sistema"
L["Taxi to Scholar's Den"] = "Taxi per l'Antro dello Studioso"
L["Taxi to Vault of Secrets"] = "Taxi per gli Archivi dei Segreti"
L["Tazavesh, the Veiled Market"] = "Tazavesh, il Bazar Celato"
L["Tempest Keep"] = "Forte Tempesta"
L["Temple of Ahn'Qiraj"] = "Tempio di Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Tempio di Atal'Hakkar"
L["Temple of Sethraliss"] = "Tempio di Sethraliss"
L["Temple of the Jade Serpent"] = "Tempio della Serpe di Giada"
L["Temple of the Moon"] = "Tempio della Luna"
L["Terrace of Endless Spring"] = "Terrazza dell'Eterna Primavera"
L["The Arcatraz"] = "Arcatraz"
L["The Arcway"] = "Arcavia"
L["The Azure Vault"] = "Cripta Azzurra"
L["The Bastion of Twilight"] = "Bastione del Crepuscolo"
L["The Black Morass"] = "Palude Nera"
L["The Blood Furnace"] = "Forgia del Sangue"
L["The Botanica"] = "Botanica"
L["The Culling of Stratholme"] = "Epurazione di Stratholme"
L["The Deadmines"] = "Miniere della Morte"
L["The Dragon Soul"] = "Anima del Drago"
L["The Emerald Nightmare"] = "Incubo di Smeraldo"
L["The Everbloom"] = "Verdeterno"
L["The Eye"] = "Occhio"
L["The Eye of Eternity"] = "Occhio dell'Eternità"
L["The Forge of Souls"] = "Forgia delle Anime"
L["The Frozen Halls"] = "Sale Ghiacciate"
L["The Halls of Reflection"] = "Sale dei Riflessi"
L["The Mechanar"] = "Mecanar"
L["The MOTHERLODE!!"] = "La VENA MADRE!!"
L["The Necrotic Wake"] = "Scia Necrotica"
L["The Nexus"] = "Nexus"
L["The Nighthold"] = "Rocca della Notte"
L["The Nokhud Offensive"] = "Offensiva dei Nokhud"
L["The Obsidian Sanctum"] = "Santuario di Ossidiana"
L["The Oculus"] = "Oculus"
L["The Old Kingdom"] = "Il Regno Antico"
L["The Pit of Saron"] = "Fossa di Saron"
L["The Ruby Sanctum"] = "Santuario di Rubino"
L["The Shattered Halls"] = "Sale della Devastazione "
L["The Stockade"] = "Segrete di Roccavento"
L["The Stonecore"] = "Nucleo di Pietra"
L["The Underrot"] = "Grottamarcia"
L["The Violet Hold"] = "Fortezza Violacea"
L["The Vortex Pinnacle"] = "Pinnacolo del Vortice"
L["The Waning Crescent"] = "Mezzaluna Crescente"
L["Theater of Pain"] = "Teatro del Dolore"
L["Throne of the Four Winds"] = "Trono dei Quattro Venti"
L["Throne of the Tides"] = "Trono delle Maree"
L["Throne of Thunder"] = "Regno del Tuono"
L["Thunder Bluff"] = "Picco del Tuono"
L["Tint unexplored areas"] = "Colora aree inesplorate"
L["Tiragarde Sound"] = "Baia di Tiragarde"
L["Titan Translocator"] = "Traslocatore dei Titani"
L["Toggle panel"] = "Attiva/disattiva il pannello"
L["Tomb of Sargeras"] = "Tomba di Sargeras"
L["Transparency"] = "Trasparenza"
L["Trial of the Champion"] = "Ordalia dei Campioni"
L["Trial of the Crusader"] = "Ordalia dei Crociati"
L["Trial of Valor"] = "Prova del Valore"
L["Twilight Highlands"] = "Alture del Crepuscolo"
L["Twilight Vineyards"] = "Vigne del Crepuscolo"
L["Uldaman: Legacy of Tyr"] = "Uldaman: Eredità di Tyr"
L["Underbog"] = "Torbiera Sotterranea"
L["Undercity"] = "Sepulcra"
L["Unlock battlefield map"] = "Sblocca la mappa del campo di battaglia"
L["Unlock map frame"] = "Sblocca il frame della mappa"
L["Upper Blackrock Spire"] = "Bastioni di Roccianera Superiori"
L["Use default map"] = "Utilizza la mappa predefinita"
L["Use large font"] = "Utilizza caratteri grandi"
L["Utgarde Keep"] = "Forte Utgarde"
L["Utgarde Pinnacle"] = "Pinnacolo di Utgarde"
L["Valdrakken Portals"] = "Portali di Valdrakken"
L["Vault of Archavon"] = "Volta di Archavon"
L["Vault of the Incarnates"] = "Segrete delle Incarnazioni "
L["Vault of the Wardens"] = "Segrete delle Custodi"
L["Version"] = "Versione"
L["Wailing Caverns"] = "Caverna dei Lamenti"
L["Waycrest Manor"] = "Maniero dei Crestabianca"
L["Well of Eternity"] = "Pozzo dell'Eternità "
L["Western Earthshrine"] = "Santuario Occidentale della Terra"
L["Windowed"] = "Finestrato"
L["Wyrmrest Temple"] = "Tempio della Lega dei Draghi"
L["You cannot do that in combat."] = "Non puoi farlo in combattimento."
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "È necessario ricaricare l'interfaccia utente affinché alcune modifiche abbiano effetto.|n|nNon è necessario fare clic immediatamente sul pulsante di ricarica, ma è necessario fare clic su di esso quando hai finito di apportare modifiche e desideri che le modifiche abbiano effetto  ."
L["Your UI needs to be reloaded."] = "La tua interfaccia utente deve essere ricaricata."
L["Zeppelin to"] = "Zeppelin a"

end

-- ptBR: Portugese (Brazil)
if GameLocale == "ptBR" then
L["(destination only)"] = "(apenas destino)"
L["(inside Caverns of Time)"] = "(dentro de Cavernas do Tempo)"
L["/ltm help - Show this information."] = "/ltm help - Exibe essas informações."
L["/ltm reset - Reset the panel position."] = "/ltm reset - Redefine a posição do painel."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - Limpe todas as configurações e recarregue."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "Ocorreu um erro de parada, mas não precisa se preocupar. Isso pode acontecer de tempos em tempos. Clique no botão recarregar para resolvê-lo."
L["Acherus: The Ebon Hold"] = "Acherus: O Forte Ébano"
L["Aerie Peak"] = "Ninho da Águia"
L["Agmar's Hammer"] = "Martelo de Agmar"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Aldor"] = "Aldor"
L["Algeth'ar Academy"] = "Academia Algeth'ar"
L["Allerian Stronghold"] = "Fortaleza Alleriana"
L["Alliance Cities"] = "Cidades da Aliança"
L["Allow frame movement"] = "Permitir movimentação do quadro"
L["Alpha"] = "Alfa"
L["Altar of Sha'tar"] = "Altar de Sha'tar"
L["Alterac Mountains"] = "Montanhas de Alterac"
L["Always"] = "Sempre"
L["Amber Lodge"] = "Lodgmento Âmbar"
L["Amberpine Lodge"] = "Lodgmento Pinhoâmbar"
L["Antorus, the Burning Throne"] = "Antorus, o Trono Ardente"
L["Apothecary Camp"] = "Acampamento de Alquimistas"
L["Appearance"] = "Aparência"
L["Arathi Highlands"] = "Planalto Arathi"
L["Area 52"] = "Área 52"
L["Argent Tournament Grounds"] = "Campo de Torneio Argênteo"
L["Armory"] = "Armaria"
L["Ashenvale"] = "Vale Gris"
L["Astranaar"] = "Astranaar"
L["Astravar Harbor"] = "Porto Astravar"
L["Atal'Dazar"] = "Atal'Dazar"
L["Auberdine"] = "Auberdine"
L["Auchenai Crypts"] = "Catacumbas Auchenai"
L["Auchindoun"] = "Auchindoun"
L["Auto change zones"] = "Alterar zonas"
L["available during zone attack"] = "disponível durante o ataque à zona"
L["Azeroth"] = "Azeroth"
L["Azjol-Nerub"] = "Azjol-Nerub"
L["Azshara"] = "Azshara"
L["Azuremyst Isle"] = "Ilha Névoa Lazúli"
L["Back to Main Menu"] = "Voltar ao menu principal"
L["Badlands"] = "Ermos"
L["Baradin Hold"] = "Bastilha de Baradin"
L["Battle of Dazar'alor"] = "Batalha de Dazar'alor"
L["Battlegrounds"] = "Campos de batalha"
L["Black Morass"] = "Lamaçal Negro"
L["Black Rook Hold"] = "Castelo Corvo Negro"
L["Black Temple"] = "Templo Negro"
L["Blackfathom Deeps"] = "Profundezas Negras"
L["Blackrock Caverns"] = "Cavernas Rocha Negra"
L["Blackrock Depths"] = "Abismo Rocha Negra"
L["Blackrock Foundry"] = "Forja Negra"
L["Blackrock Mountain"] = "Montanha Rocha Negra"
L["Blackrock Spire"] = "Pico da Rocha Negra"
L["Blackwing Descent"] = "Descenso do Asa Negra"
L["Blackwing Lair"] = "Covil Asa Negra"
L["Blade Tooth Canyon"] = "Cânion Presadentada"
L["Blade's Edge Mountains"] = "Montanhas da Lâmina Afiada"
L["Blades' Run"] = "Trilha das Lâminas"
L["Blasted Lands"] = "Barreira do Inferno"
L["Blood Watch"] = "Entreposto Rubro"
L["Bloodmaul Slag Mines"] = "Minas de Escória do Malho Sangrento"
L["Bloodmyst Isle"] = "Ilha Névoa Rubra"
L["Bloodvenom Post"] = "Posto Peçonha"
L["Blue"] = "Azul"
L["Boat to"] = "Barco para"
L["Booty Bay"] = "Angra do Butim"
L["Borean Tundra"] = "Tundra Boreana"
L["Bor'gorok Outpost"] = "Posto Avançado Bor'gorok"
L["Bouldercrag's Refuge"] = "Refúgio de Rochapedra"
L["Brackenhide Hollow"] = "Vale Esconderijo de Samambaia"
L["Brackenwall Village"] = "Aldeia Muralha Verde"
L["Burning Crusade Classic"] = "Burning Crusade Classic"
L["Burning Steppes"] = "Estepes Ardentes"
L["Camp Mojache"] = "Aldeia Mojache"
L["Camp Oneqwah"] = "Acampamento Ôniqwah"
L["Camp Taurajo"] = "Acampamento Taurajo"
L["Camp Tunka'lo"] = "Acampamento Tunka'lo"
L["Camp Winterhoof"] = "Acampamento Cascogelado"
L["Cannot be used with Use default map."] = "Não pode ser usado com o mapa padrão.|n|nPara ajustar a opacidade do mapa, clique com o botão direito na barra de título da moldura do mapa."
L["Cannot be used with Use default map.|n|nTo adjust map opacity, right-click the map frame title bar."] = "Não pode ser usado com o mapa padrão.|n|nPara ajustar a opacidade do mapa, clique com o botão direito na barra de título da moldura do mapa."
L["Castle Nathria"] = "Castelo de Nathria"
L["Cathedral"] = "Catedral"
L["Cathedral of Eternal Night"] = "Catedral da Noite Eterna"
L["Caverns of Time"] = "Cavernas do Tempo"
L["Cenarion Hold"] = "Forte Cenariano"
L["Center map on player"] = "Centralizar mapa no jogador"
L["Central Mesa"] = "Mesa Central"
L["Chamber of Heart"] = "Câmara do Coração"
L["Chillwind Camp"] = "Acampamento Ventogelante"
L["Choose where the zone map should be shown."] = "Escolha onde o mapa de zona deve ser mostrado."
L["Class colored icons"] = "Ícones coloridos"
L["Classic"] = "Clássico"
L["Click to configure the settings for this option."] = "Clique para definir as configurações para esta opção."
L["Click to reset the position and scale of the map frame."] = "Clique para redefinir a posição e a escala do quadro do mapa."
L["Click to reset the settings on this page."] = "Clique para redefinir as configurações nesta página."
L["Click to return to the main menu."] = "Clique para retornar ao menu principal."
L["Coilfang Reservoir"] = "Reservatório Presacurva"
L["Coldarra"] = "Ferra Fria"
L["Configuration Panel"] = "Painel de Configuração"
L["Conquest Hold"] = "Fortaleza Conquista"
L["Cosmic"] = "Cósmico"
L["Cosmowrench"] = "Chave do Cosmos"
L["Court of Stars"] = "Corte das Estrelas"
L["Crucible of Storms"] = "Caldeirão das Tempestades"
L["Crusaders' Pinnacle"] = "Pináculo dos Cruzados"
L["Crystalsong Forest"] = "Floresta Canção Cristalina"
L["Culling of Stratholme"] = "Purificação de Stratholme"
L["Cursor"] = "Cursor"
L["Dalaran"] = "Dalaran"
L["Dalaran Crater"] = "Cratera de Dalaran"
L["Darkheart Thicket"] = "Clareira Negra"
L["Darkshire"] = "Vila Sombria"
L["Darkshore"] = "Costa Negra"
L["Darnassus"] = "Darnassus"
L["De Other Side"] = "Do Outro Lado"
L["Deadwind Pass"] = "Trilha do Vento Morto"
L["Death's Rise"] = "Elevação da Morte"
L["Debug"] = "Depurar"
L["Deepholm"] = "Alto Monte"
L["Desolace"] = "Desolação"
L["Dire Maul (East)"] = "Gládio Cruel (Leste)"
L["Dire Maul (East) (side entrance)"] = "Gládio Cruel (Leste) (entrada lateral)"
L["Dire Maul (East): Warpwood Quarter"] = "Gládio Cruel (Leste): Distrito Lenhatorta"
L["Dire Maul (North)"] = "Gládio Cruel (Norte)"
L["Dire Maul (North): Gordok Commons"] = "Gládio Cruel (Norte): Pátio Gordok"
L["Dire Maul (West)"] = "Gládio Cruel (Oeste)"
L["Dire Maul (West): Capital Gardens"] = "Gládio Cruel (Oeste): Jardins Capitais"
L["Dire Maul: Capital Gardens"] = "Gládio Cruel: Jardins Capitais"
L["Dire Maul: Gordok Commons"] = "Gládio Cruel: Comuns Gordok"
L["Dire Maul: Warpwood Quarter"] = "Gládio Cruel: Bairro das Madeiras Retorcidas"
L["Disable map fade"] = "Desativar desvanecimento do mapa"
L["Disable reading emote"] = "Desativar leitura de emote"
L["Disable reading emote when opening the map"] = "Desabilitar a leitura de emote ao abrir o mapa"
L["disabled"] = "desativado"
L["Drag"] = "Arrastrar"
L["Drag to set the amount of blue."] = "Arraste para definir a quantidade de azul."
L["Drag to set the amount of green."] = "Arraste para definir a quantidade de verde."
L["Drag to set the amount of red."] = "Arraste para definir a quantidade de vermelho."
L["Drag to set the battlefield map opacity."] = "Arraste para definir a opacidade do mapa do campo de batalha."
L["Drag to set the battlefield map size."] = "Arraste para definir o tamanho do mapa do campo de batalha."
L["Drag to set the battlefield map size.|n|nIf the map is unlocked, you can also resize the battlefield map by dragging the bottom-right corner."] = "Arraste para definir o tamanho do mapa do campo de batalha.|n|nSe o mapa estiver desbloqueado, você também pode redimensionar o mapa do campo de batalha arrastando o canto inferior direito."
L["Drag to set the group icon size."] = "Arraste para definir o tamanho do ícone do grupo."
L["Drag to set the map opacity for when your character is moving."] = "Arraste para definir a opacidade do mapa para quando seu personagem estiver em movimento."
L["Drag to set the map opacity for when your character is stationary."] = "Arraste para definir a opacidade do mapa quando seu personagem estiver parado."
L["Drag to set the maximum zoom level.|n|nOpen the battlefield map to see the maximum zoom level change as you drag the slider."] = "Arraste para definir o nível máximo de zoom.|n|nAbra o mapa do campo de batalha para ver a alteração do nível máximo de zoom conforme você arrasta o controle deslizante."
L["Drag to set the maximum zoom level.|n|nOpen the map to see the maximum zoom level change as you drag the slider."] = "Arraste para definir o nível máximo de zoom.|n|nAbra o mapa para ver a alteração do nível máximo de zoom conforme você arrasta o controle deslizante."
L["Drag to set the opacity."] = "Arraste para definir a opacidade."
L["Drag to set the player arrow size."] = "Arrasta para definir o tamanho da seta do jogador."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "Arraste para definir o tamanho da seta do jogador.|n|nO WoW clássico do Wow é 16.|nO WoW Retail é 27."
L["Drag to set the scale for the maximised map."] = "Arraste para definir a escala para o mapa maximizado."
L["Drag to set the scale for the windowed map."] = "Arraste para definir a escala para o mapa em janela."
L["Drag to set the world map scale.|n|nYou can also rescale the world map by dragging the bottom-right corner."] = "Arraste para definir a escala do mapa mundial.|n|nVocê também pode redimensionar o mapa mundial arrastando o canto inferior direito."
L["Dragon Soul"] = "Alma Dragônica"
L["Dragonblight"] = "Ermo das Serpes"
L["Drak'Tharon Keep"] = "Forte Drak'Tharon"
L["Druid only flight point to Darnassus"] = "Druida apenas ponto de voo para Darnassus"
L["Druid only flight point to Thunder Bluff"] = "Druida apenas ponto de voo para Penhasco do Trovão"
L["Dun Algaz"] = "Dun Algaz"
L["Dun Morogh"] = "Dun Morogh"
L["Dun Nifflelem"] = "Dun Nifflelem"
L["Dungeon"] = "Masmorra"
L["Dungeon (requires Crescent Key)"] = "Masmorra (requer Chave Crescente)"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Floresta do Crepúsculo"
L["Dustwallow Marsh"] = "Pântano Vadeoso"
L["Dwarven District"] = "Distrito dos Anões"
L["Eastern Earthshrine"] = "Altar Terreno Leste"
L["Eastern Plaguelands"] = "Terras Pestilentas Orientais"
L["Ebon Watch"] = "Vigília Ébano"
L["Elements"] = "Visibilidade"
L["Elwynn Forest"] = "Floresta de Elwynn"
L["Emerald Dream"] = "Sonho Esmeralda"
L["Emerald Sanctuary"] = "Santuário Esmeralda"
L["enabled"] = "ativado"
L["End Time"] = "Fim dos Tempos"
L["Enhance battlefield map"] = "Melhorar o mapa do campo de batalha"
L["Enhance dungeon icons"] = "Melhorar ícones de masmorra"
L["Enlarge player arrow"] = "Seta do jogador"
L["Enter"] = "Entrar"
L["Evergrove"] = "Arvoredo Eterno"
L["Everlook"] = "Visteterna"
L["Evermoon Terrace"] = "Terraço Lua Eterna"
L["Eversong Woods"] = "Floresta do Canto Eterno"
L["Exile's Hollow"] = "Concavidade do Exílio"
L["Exodar"] = "Exodar"
L["Eye of Azshara"] = "Olho de Azshara"
L["Falanaar"] = "Falanaar"
L["Falcon Watch"] = "Vigília do Falcão"
L["Faldir's Cove"] = "Enseada de Faldir"
L["Feathermoon Stronghold"] = "Domínio de Plumaluna"
L["Felsoul Hold"] = "Fortaleza Vilanima"
L["Felwood"] = "Selva Maleva"
L["Feralas"] = "Feralas"
L["Firelands"] = "Terras do Fogo"
L["Fishing"] = "Pesca"
L["Fizzcrank Airstrip"] = "Pista de Pouso Aeronauta"
L["Flame Crest"] = "Monte Candente"
L["Flayedwing Transporter"] = "Transportador Asamalho"
L["Follow the eastward path"] = "Siga o caminho para o leste"
L["Follow the westward path"] = "Siga o caminho para o oeste"
L["Fordragon Hold"] = "Fortaleza Fordragon"
L["Forest Song"] = "Canto da Floresta"
L["Fort Wildervar"] = "Fortaleza Gelo Selvagem"
L["Freehold"] = "Angra do Facão"
L["Freewind Post"] = "Aldeia Vento Livre"
L["Frosthold"] = "Vigília Glacial"
L["Gadgetzan"] = "Geringontzan"
L["Garadar"] = "Garadar"
L["Gate of the Setting Sun"] = "Portão do Sol Poente"
L["Gates of Valor"] = "Portões da Bravura"
L["Ghostlands"] = "Terra Fantasma"
L["Gnomeregan"] = "Gnomeregan"
L["Green"] = "Verde"
L["Grim Batol"] = "Grim Batol"
L["Grimrail Depot"] = "Depósito de Tremedal"
L["Grizzly Hills"] = "Serra Gris"
L["Grom'arsh Crash Site"] = "Local da Queda de Grom'arsh"
L["Grom'gol Base Camp"] = "Acampamento Grom'gol"
L["Group Icons"] = "Ícones de grupo"
L["Gruul's Lair"] = "Covil de Gruul"
L["Gundrak"] = "Gundrak"
L["Gundrak (rear entrance)"] = "Gundrak (entrada traseira)"
L["Hall of Ancient Paths"] = "Sala dos Caminhos Antigos"
L["Halls of Atonement"] = "Salões da Expiação"
L["Halls of Infusion"] = "Salões da Infusão"
L["Halls of Lightning"] = "Salões Relampejantes"
L["Halls of Origination"] = "Salões da Originação"
L["Halls of Stone"] = "Salões de Pedra"
L["Halls of Valor"] = "Salões da Bravura"
L["Hammerfall"] = "Ruína do Martelo"
L["Head down the mountain from here."] = "Desça a montanha daqui."
L["Head southeast from here and go up the mountain."] = "Siga sudeste daqui e suba a montanha."
L["Heart of Fear"] = "Coração do Medo"
L["Hellfire Citadel"] = "Cidadela Fogo do Inferno"
L["Hellfire Peninsula"] = "Península Fogo do Inferno"
L["Hellfire Ramparts"] = "Muralha Fogo do Inferno"
L["Hide filter reset button"] = "Ocultar botão de redefinição do filtro"
L["Hide town and city icons"] = "Vilas e cidades"
L["Highmaul"] = "Altaforja"
L["Hillsbrad Foothills"] = "Contraforte de Eira dos Montes"
L["Honor Hold"] = "Fortaleza da Honra"
L["Horde Cities"] = "Cidades da Horda"
L["Hour of Twilight"] = "Hora do Crepúsculo"
L["Howling Fjord"] = "Fiorde Uivante"
L["Hyjal"] = "Hyjal"
L["Hyjal Summit"] = "Pico Hyjal"
L["Icecrown"] = "Coroa de Gelo"
L["Icecrown Citadel"] = "Cidadela da Coroa de Gelo"
L["Icons"] = "Ícones"
L["If checked, additional icons (such as portals) will be shown."] = "Se marcado, ícones adicionais (como portais) serão exibidos."
L["If checked, archaeology digsites will be shown."] = "Se marcado, os sítios arqueológicos serão exibidos."
L["If checked, coordinates will be shown."] = "Se marcado, as coordenadas serão exibidas."
L["If checked, coordinates will have a dark background texture."] = "Se marcado, as coordenadas terão uma textura de fundo escura."
L["If checked, coordinates will use a large font."] = "Se marcado, as coordenadas usarão uma fonte grande."
L["If checked, dungeons and raids will be shown."] = "Se marcado, masmorras e raides serão exibidos."
L["If checked, group icons will use a modern, class-colored design."] = "Se marcado, os ícones de grupo usarão um design moderno e colorido em classe."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "Se marcado, a abertura do mapa usará o mesmo nível de zoom desde a última vez que você o fechou, desde que a zona do mapa não tenha sido alterada."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "Se marcado, apontar para o mapa enquanto seu personagem estiver em movimento fará com que a configuração de opacidade estacionária seja aplicada."
L["If checked, points of interest will be shown."] = "Se marcado, os pontos de interesse serão exibidos."
L["If checked, quest objectives will be shown."] = "Se marcado, os objetivos da missão serão exibidos."
L["If checked, spirit healers will be shown."] = "Se marcada, os Anjos da Cura serão exibidos."
L["If checked, the battlefield map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Se marcado, o mapa do campo de batalha permanecerá centralizado em sua localização, desde que você não esteja em uma masmorra.|n|nVocê pode segurar a tecla shift enquanto movimenta o mapa para impedir temporariamente que ele centralize."
L["If checked, the default fullscreen map will be used for the maximised map.|n|nNote that enabling this option will lock out some of the other options."] = "Se marcado, o mapa em tela cheia padrão será usado para o mapa maximizado.|n|nObserve que ativar esta opção bloqueará algumas das outras opções."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "Se marcado, o mapa padrão em tela cheia será usado.|n|nObserve que ativar essa opção bloqueará algumas das outras opções."
L["If checked, the map border will be removed."] = "Se marcado, a borda do mapa será removida."
L["If checked, the map frame will remain open until you close it."] = "Se marcado, o quadro do mapa permanecerá aberto até você fechá-lo."
L["If checked, the map will not fade while your character is moving."] = "Se marcado, o mapa não ficará transparente enquanto seu personagem estiver se movendo."
L["If checked, the map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Se marcado, o mapa permanecerá centralizado em sua localização, desde que você não esteja em uma masmorra.|n|nVocê pode segurar Shift enquanto movimenta o mapa para evitar temporariamente que ele centralize."
L["If checked, the minimap button will be shown."] = "Se marcado, o botão do minimapa será exibido."
L["If checked, the minimum fishing skill levels will be shown."] = "Se marcado, os níveis mínimos de habilidade de pesca serão exibidos."
L["If checked, the world map filter reset button will be hidden."] = "Se marcado, o botão de redefinição do filtro do mapa-múndi será ocultado"
L["If checked, town and city icons will not be shown on the continent maps."] = "Se marcado, os ícones de vila e cidade não serão exibidos nos mapas do continente."
L["If checked, travel points for the opposing faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Se marcado, os pontos de viagem para a facção adversária serão exibidos.|n|nIsso inclui pontos de voo, portos de barco, torres de zepelim e estações de metrô."
L["If checked, travel points for the same faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Se marcado, os pontos de viagem para a mesma facção serão exibidos.|n|nIsso inclui pontos de voo, portos de barco, torres de zepelim e estações de metrô."
L["If checked, unexplored areas of the map will be shown on the world map and the battlefield map."] = "Se marcado, as áreas inexploradas do mapa serão exibidas no mapa-múndi e no mapa do campo de batalha."
L["If checked, unexplored areas will be tinted."] = "Se marcada, áreas inexploradas serão matizadas."
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "Se marcado, quando seu personagem muda de zona, o mapa muda automaticamente para a nova zona."
L["If checked, you can move the battlefield map by dragging any of its borders."] = "Se marcado, você pode mover o mapa de batalha arrastando qualquer uma de suas bordas."
L["If checked, you can move the battlefield map by dragging any of its borders.|n|nYou can resize the battlefield map by dragging the bottom-right corner."] = "Se marcado, você pode mover o mapa do campo de batalha arrastando qualquer uma de suas bordas.|n|nVocê pode redimensionar o mapa do campo de batalha arrastando o canto inferior direito."
L["If checked, you will be able to customise the battlefield map."] = "Se marcado, você poderá personalizar o mapa do campo de batalha."
L["If checked, you will be able to enlarge the player arrow."] = "Se marcado, você poderá ampliar a seta do jogador."
L["If checked, you will be able to move the frame by dragging the border."] = "Se marcado, você poderá mover o quadro arrastando a borda."
L["If checked, you will be able to move the map.|n|nThe map position will be saved separately for the maximised and windowed maps."] = "Se marcado, você poderá mover o mapa.|n|nA posição do mapa será salva separadamente para os mapas maximizados e em janela."
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges."] = "Se marcado, você poderá dimensionar e mover o mapa.|n|nDimensione o mapa arrastando a alça da escala no canto inferior direito.|n|nMova o mapa arrastando as bordas da borda e do quadro."
L["If checked, you will be able to scale the map by dragging the scale handle in the bottom-right corner.|n|nYou will be able to move the map by dragging any border.|n|nYou can always drag the top border to move the map regardless of this setting."] = "Se marcado, você poderá dimensionar o mapa arrastando a alça de escala no canto inferior direito.|n|nVocê poderá mover o mapa arrastando qualquer borda.|n|nVocê sempre pode arrastar a borda superior para mover o mapa, independentemente dessa configuração."
L["If checked, you will be able to scale the map."] = "Se marcado, você poderá dimensionar o mapa."
L["If checked, you will be able to set the opacity of the map."] = "Se marcado, você poderá definir a opacidade do mapa."
L["If checked, you will be able to zoom further into the world map."] = "Se marcado, você poderá ampliar ainda mais o mapa-múndi."
L["If checked, your character will not perform the reading emote when you open the map."] = "Se marcado, seu personagem não realizará a animação de leitura ao abrir o mapa."
L["If checked, zone and continent dropdown menus will be shown in the map frame."] = "Se marcado, os menus suspensos de zona e continente serão exibidos no quadro do mapa."
L["If checked, zone and dungeon levels will be shown."] = "Se marcado, os níveis de zonas e masmorras serão exibidos."
L["If checked, zone crossings will be shown.|n|nThese are clickable arrows that indicate the zone exit pathways."] = "Se marcada, as passagens de zona serão exibidas.|n|nEstas são setas clicáveis que indicam os caminhos de saída da zona."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "Se marcado, os níveis de zona, masmorra e habilidade de pesca serão exibidos."
L["Increase zoom level"] = "Aumentar o nível de zoom"
L["Invalid command.  Enter /ltm help for help."] = "Comando inválido. Digite /ltm help para obter ajuda."
L["Invalid map ID."] = "ID de mapa inválido."
L["Iron Docks"] = "Docas de Ferro"
L["Ironforge"] = "Altaforja"
L["Isle of Quel'Danas"] = "Ilha de Quel'Danas"
L["Just follow the path west"] = "Siga o caminho para o oeste"
L["K3"] = "K3"
L["Kamagua"] = "Kamagua"
L["Karazhan"] = "Karazhan"
L["Kargath"] = "Karrath"
L["Kings' Rest"] = "Repouso dos Reis"
L["Kor'kron Vanguard"] = "Vanguarda Kor'kron"
L["Lake Elune'ara"] = "Lago Eluna'ara"
L["Lake Everstill"] = "Lago Plácido"
L["Large Scarab Coffer"] = "Grande Arca do Escaravelho"
L["Leads to Tirisfal Glades"] = "Leva para Clareiras de Tirisfal"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS: VERSÃO ERRADA INSTALADA!"
L["Library"] = "Biblioteca"
L["Light's Breach"] = "Brecha da Luz"
L["Light's Hope Chapel"] = "Capela Esperança da Luz"
L["Lion's Watch"] = "Vigia do Leão"
L["Loch Modan"] = "Loch Modan"
L["Lost City of the Tol'vir"] = "Cidade Perdida dos Tol'vir"
L["Lower Blackrock Spire"] = "Pico da Rocha Negra Inferior"
L["Lunastre Estate"] = "Propriedade Lunastre"
L["Magisters' Terrace"] = "Terraço dos Magísteres"
L["Magtheridon's Lair"] = "Covil de Magtheridon"
L["Mana-Tombs"] = "Tumbas de Mana"
L["Map frame scale"] = "Escala de quadro do mapa"
L["Map Opacity"] = "Opacidade do mapa"
L["Map Scale"] = "Escala do Mapa"
L["Map Size"] = "Tamanho do mapa"
L["Maraudon"] = "Maraudon"
L["Maraudon: Earth Song Falls"] = "Maraudon: Cascata da Canção da Terra"
L["Maraudon: Foulspore Cavern"] = "Maraudon: Caverna da Esporânea"
L["Maraudon: The Wicked Grotto"] = "Maraudon: A Gruta Malévola"
L["Marshal's Refuge"] = "Refúgio do Marshal"
L["Maw of Souls"] = "Fauce das Almas"
L["Max Zoom"] = "Zoom máximo"
L["Maximised"] = "Maximizado"
L["Maximum"] = "Máximo"
L["Mechanics"] = "Mecânico"
L["Memory Usage"] = "Uso de memória"
L["Menethil Harbor"] = "Porto de Menethil"
L["Miscellaneous"] = "Diversos"
L["Mists of Tirna Scithe"] = "Mares de Tirna Scithe"
L["Moa'ki"] = "Moa'ki"
L["Moa'ki Harbor"] = "Porto Moa'ki"
L["Mogu'shan Palace"] = "Palácio de Mogu'shan"
L["Mogu'shan Vaults"] = "Câmaras de Mogu'shan"
L["Mok'Nathal Village"] = "Vila de Mok'Nathal"
L["Molten Core"] = "Núcleo Derretido"
L["Moon Guard Stronghold"] = "Fortaleza da Guarda Lunar"
L["Moonglade"] = "Clareira da Lua"
L["More"] = "Mais"
L["Morgan's Vigil"] = "Vigia de Morgan"
L["Mount Crafting"] = "Fabricação de Montarias"
L["Mount Hyjal"] = "Monte Hyjal"
L["Mountain Pass (Horde Only)"] = "Trilha de Montanha (Apenas Horda)"
L["Moving"] = "Movendo"
L["Mudsprocket"] = "Coroa de Barro"
L["Mulgore"] = "Mulgore"
L["Nagrand"] = "Nagrand"
L["Naxxramas"] = "Naxxramas"
L["Nazjatar"] = "Nazjatar"
L["Neltharion's Lair"] = "Covil de Neltharion"
L["Neltharus"] = "Neltharus"
L["Nesingwary Base Camp"] = "Acampamento Base de Nesingwary"
L["Nethergarde Keep"] = "Bastilha de Etergarde"
L["Netherstorm"] = "Eternévoa"
L["Never"] = "Nunca"
L["New Agamand"] = "Novo Agamand"
L["Nighthaven"] = "Refúgio Noturno"
L["Nijel's Point"] = "Posto do Nijel"
L["North"] = "Norte"
L["North Gate Pass"] = "Desfiladeiro do Portão Norte"
L["Ny'alotha, The Waking City"] = "Ny'alotha, A Cidade Desperta"
L["Ohn'ahran Plains"] = "Chapada Ohn'ahrana"
L["Old Hillsbrad"] = "Antiga Colina do Sílio"
L["Old Hillsbrad Foothills"] = "Antigo Contraforte de Eira dos Montes"
L["Onyxia's Lair"] = "Covil da Onyxia"
L["Opacity"] = "Opacidade"
L["Operation: Mechagon"] = "Operação: Mecagônia"
L["or click the minimap button to open Leatrix Maps."] = "ou clique no botão do minimapa para abrir Leatrix Maps."
L["Orb of Translocation"] = "Orbe de Translocação"
L["Orebor Harborage"] = "Porto Orebor"
L["Orgrimmar"] = "Orgrimmar"
L["Oribos"] = "Oribos"
L["Pet Crafting"] = "Fabricação de Mascotes"
L["Plaguefall"] = "Pestália"
L["Player"] = "Jogador"
L["Player Arrow"] = "Seta do jogador"
L["Portal"] = "Portal"
L["Portal from Zephyr"] = "Portal de Zéfiro"
L["Portals"] = "Portais"
L["Preview"] = "Pré-visualização"
L["Protoform Repository"] = "Repositório de Protoformas"
L["Ragefire Chasm"] = "Cavernas Ígneas"
L["Raid"] = "Raide"
L["Ratchet"] = "Vila Catraca"
L["Ravenholdt Manor"] = "Mansão de Corvoforte"
L["Razorfen Downs"] = "Urzal dos Mortos"
L["Razorfen Kraul"] = "Urzal dos Tuscos"
L["Razorthorn Trail"] = "Trilha Espinho Cortante"
L["Rebel Camp"] = "Acampamento dos Rebeldes"
L["Red"] = "Vermelho"
L["Redridge Mountains"] = "Montanhas Cristarrubra"
L["Refuge Pointe"] = "Ponta do Refúgio"
L["Reload"] = "Recarregar"
L["Remember zoom level"] = "Nível de zoom"
L["Remove map border"] = "Borda do mapa"
L["req"] = "requer"
L["Requires Key to Searing Gorge"] = "Requer Chave da Garganta Abrasadora"
L["Requires UI reload."] = "Requer atualização da interface do usuário."
L["Reset"] = "Redefinir"
L["Reset Map Layout"] = "Redefinir leiaute do mapa"
L["Return to Karazhan"] = "Retorno a Karazhan"
L["Revantusk Village"] = "Aldeia Revatusco"
L["River's Heart"] = "Coração do Rio"
L["Ruby Life Pools"] = "Poços de Vida Rubi"
L["Ruins of Ahn'Qiraj"] = "Ruínas de Ahn'Qiraj"
L["Ruins of Elune'eth"] = "Ruínas de Elune'eth"
L["Rut'Theran Village"] = "Vila Rut'theran"
L["Rut'theran Village"] = "Vila de Rut'theran"
L["Sanctuary"] = "Santuário"
L["Sanctum of Domination"] = "Sacrário da Dominação"
L["Sanctum of Order"] = "Sacrário da Ordem"
L["Sanctum of the Sages"] = "Sacrário dos Sábios"
L["Sanctum of the Stars"] = "Sacrário Estelar"
L["Sanguine Depths"] = "Profundezas Sanguíneas"
L["Scale"] = "Escala"
L["Scale the map"] = "Escalar o mapa"
L["Scarlet Halls"] = "Salões Escarlates"
L["Scarlet Monastery"] = "Monastério Escarlate"
L["Scholomance"] = "Scolomântia"
L["Searing Gorge"] = "Garganta Abrasadora"
L["Seat of the Naaru"] = "Trono dos Naarus"
L["Seat of the Triumvirate"] = "Trono do Triunvirato"
L["Sentinel Hill"] = "Morro da Sentinela"
L["Sepulcher of the First Ones"] = "Sepulcro dos Primeiros"
L["Serpentshrine Cavern"] = "Caverna do Serpentário"
L["Set map opacity"] = "Opacidade do mapa"
L["Set map opacity while stationary and while moving."] = "Defina a opacidade do mapa enquanto estiver parado e em movimento."
L["Set the group icon size."] = "Defina o tamanho do ícone do grupo."
L["Set the maximum zoom scale."] = "Defina a escala máxima de zoom."
L["Set the player arrow size."] = "Defina o tamanho da seta do jogador."
L["Sethekk Halls"] = "Salões dos Sethekk"
L["Settings"] = "Configurações"
L["Sewers"] = "Esgotos"
L["Shado-Pan Monastery"] = "Mosteiro dos Shado-Pan"
L["Shadow Labyrinth"] = "Labirinto Soturno"
L["Shadowfang Keep"] = "Bastilha da Presa Negra"
L["Shadowlands"] = "Terras Sombrias"
L["Shadowmoon Burial Grounds"] = "Cemitério da Lua Negra"
L["Shadowmoon Valley"] = "Vale da Lua Negra"
L["Shadowmoon Village"] = "Aldeia Lua Negra"
L["Shadowprey Village"] = "Aldeia Pescassombra"
L["Shal'Aran"] = "Shal'Aran"
L["Shatter Point"] = "Ponto de Estilhaçamento"
L["Shattrath"] = "Shattrath"
L["Shattrath City"] = "Cidade de Shattrath"
L["Sholazar Basin"] = "Bacia Sholazar"
L["Show background"] = "Exibir fundo"
L["Show boats, zeppelins and trams"] = "Exibir barcos, zepelins e metrô"
L["Show coordinates"] = "Coordenadas"
L["Show digsites"] = "Exibir sítios arqueológicos"
L["Show dungeons and raids"] = "Exibir masmorras e raides"
L["Show minimap button"] = "Botão minimapa"
L["Show minimum fishing skill levels"] = "Exibir níveis mínimos de habilidade de pesca"
L["Show objectives"] = "Exibir objetivos"
L["Show points of interest"] = "Pontos de interesse"
L["Show scale handle"] = "Exibir alça de escala"
L["Show spirit healers"] = "Exibir Anjo da Cura"
L["Show travel points for opposing faction"] = "Exibir pontos de viagem para facção adversária"
L["Show travel points for same faction"] = "Exibir pontos de viagem para a mesma facção"
L["Show unexplored areas"] = "Áreas inexploradas"
L["Show zone crossings"] = "Exibir cruzamentos de zona"
L["Show zone levels"] = "Níveis da zona"
L["Show zone menus"] = "Exibir menus de zona"
L["Shrine of the Storm"] = "Santuário da Tempestade"
L["Siege of Boralus"] = "Cerco de Boralus"
L["Siege of Niuzao Temple"] = "Cerco ao Templo de Niuzao"
L["Siege of Orgrimmar"] = "Cerco a Orgrimmar"
L["Silithus"] = "Silithus"
L["Silvermoon"] = "Luaprata"
L["Silvermoon City"] = "Luaprata"
L["Silverpine Forest"] = "Floresta de Pinhaprata"
L["Skyreach"] = "Céu da Ascensão"
L["Slave Pens"] = "Pátio dos Escravos"
L["South"] = "Sul"
L["South Gate Pass"] = "Desfiladeiro do Portão Sul"
L["Southfury River"] = "Rio Fúria do Sul"
L["Southshore"] = "Costa Sul"
L["Spinebreaker Ridge"] = "Cordilheira Quebra-Espinha"
L["Spires of Ascension"] = "Agulhas da Ascensão"
L["Spirit Healer"] = "Anjo da Cura"
L["Splintertree Post"] = "Posto Machadada"
L["Stars' Rest"] = "Repouso das Estrelas"
L["Stationary"] = "Estacionário"
L["Steamvault"] = "Câmara dos Vapores"
L["Sticky map frame"] = "Mapa pegajoso"
L["Stonard"] = "Pedregal"
L["Stonebreaker Hold"] = "Vila de Quebrapedra"
L["Stonetalon Mountains"] = "Cordilheira das Torres de Pedra"
L["Stonetalon Peak"] = "Morro das Torres de Pedra"
L["Stormstout Brewery"] = "Cervejaria Malte do Trovão"
L["Stormwind"] = "Ventobravo"
L["Stormwind City"] = "Cidade de Ventobravo"
L["Stranglethorn Vale"] = "Selva do Espinhaço"
L["Stratholme (Main Gate)"] = "Stratholme (portão principal)"
L["Stratholme (Service Gate)"] = "Stratholme (entrada de serviço)"
L["Stratholme: Crusader's Square"] = "Stratholme: Praça do Cruzado"
L["Stratholme: The Gauntlet"] = "Stratholme: O Desafio"
L["sum"] = "convocar"
L["Sun Rock Retreat"] = "Retiro Rocha do Sol"
L["Sunreaver's Command"] = "Comando dos Fendessol"
L["Sun's Reach Harbor"] = "Porto Alcance do Sol"
L["Sunwell Plateau"] = "Platô da Nascente do Sol"
L["Swamp of Sorrows"] = "Pântano das Mágoas"
L["Swamprat Post"] = "Mocó do Rato Lamacento"
L["Sylvanaar"] = "Sylvanaar"
L["Synthesis Forge"] = "Forja de Síntese"
L["System"] = "Sistema"
L["Talonbranch Glade"] = "Clareira da Galhaça"
L["Talrendis Point"] = "Campo Talrendis"
L["Tanaris"] = "Tanaris"
L["Tarren Mill"] = "Serraria Tarren"
L["Taunka'le Village"] = "Vila Taunka'le"
L["Taxi to Scholar's Den"] = "Táxi para Refúgio do Erudito"
L["Taxi to Vault of Secrets"] = "Táxi para Cofre dos Segredos"
L["Tazavesh, the Veiled Market"] = "Tazavesh, o Mercado Velado"
L["Telaar"] = "Telaar"
L["Tel'anor"] = "Tel'anor"
L["Teldrassil"] = "Teldrassil"
L["Teleport Crystal"] = "Cristal de Teleporte"
L["Telredor"] = "Telredor"
L["Tempest Keep"] = "Bastilha da Tormenta"
L["Temple of Ahn'Qiraj"] = "Templo de Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Templo de Atal'Hakkar"
L["Temple of Sethraliss"] = "Templo de Sethraliss"
L["Temple of Telhamat"] = "Templo de Telhamat"
L["Temple of the Jade Serpent"] = "Templo da Serpente de Jade"
L["Temple of the Moon"] = "Templo da Lua"
L["Terokkar Forest"] = "Mata Terokkar"
L["Terrace of Endless Spring"] = "Terraço da Primavera Eterna"
L["Thalanaar"] = "Thalanaar"
L["Thandol Span"] = "Ponte Thandol"
L["The Arcatraz"] = "Arcatraz"
L["The Arcway"] = "A Arcada"
L["The Argent Stand"] = "O Posto Argênteo"
L["The Argent Vanguard"] = "A Vanguarda Argêntea"
L["The Azure Vault"] = "O Cofre Azul"
L["The Barrens"] = "Sertões"
L["The Bastion of Twilight"] = "O Bastião do Crepúsculo"
L["The Black Morass"] = "O Pântano Negro"
L["The Blood Furnace"] = "Fornalha de Sangue"
L["The Botanica"] = "Jardim Botânico"
L["The Bulwark"] = "O Baluarte"
L["The Crossroads"] = "A Encruzilhada"
L["The Culling of Stratholme"] = "A Limpeza de Stratholme"
L["The Dark Portal"] = "Portal Negro"
L["The Deadmines"] = "Minas Mortas"
L["The Dragon Soul"] = "A Alma Dragônica"
L["The Emerald Nightmare"] = "O Pesadelo Esmeralda"
L["The Everbloom"] = "A Floretérnia"
L["The Exodar"] = "Exodar"
L["The Eye"] = "O olho"
L["The Eye of Eternity"] = "O Olho da Eternidade"
L["The Forge of Souls"] = "A Forja das Almas"
L["The Forgotten Coast"] = "Costa Esquecida"
L["The Frozen Halls"] = "Os Salões Congelados"
L["The Great Forge"] = "A Grande Forja"
L["The Great Lift"] = "O Grande Elevador"
L["The Halls of Reflection"] = "Os Salões da Reflexão"
L["The Hinterlands"] = "Terras Agrestes"
L["The Mechanar"] = "Mecanar"
L["The MOTHERLODE!!"] = "A GALERA!!"
L["The Necrotic Wake"] = "O Despertar Necrótico"
L["The Nexus"] = "O Nexus"
L["The Nighthold"] = "A Abóbada da Noite"
L["The Nokhud Offensive"] = "A Ofensiva Nokhud"
L["The Obsidian Sanctum"] = "O Santuário Obsidiano"
L["The Oculus"] = "O Oculus"
L["The Old Kingdom"] = "O Reino Antigo"
L["The Overlook Cliffs"] = "Penhascos Panorâmicos"
L["The Pit of Saron"] = "A Fossa de Saron"
L["The Ruby Sanctum"] = "O Santuário Rubi"
L["The Sepulcher"] = "O Sepulcro"
L["The Shadow Vault"] = "O Alçapão Sombrio"
L["The Shattered Halls"] = "Salões Despedaçados"
L["The Stockade"] = "O Cárcere"
L["The Stonecore"] = "A Litocâmara"
L["The Storm Peaks"] = "As Cimeiras Tempestuosas"
L["The Stormspire"] = "Pináculo da Tempestade"
L["The Talondeep Path"] = "Túnel Garracava"
L["The Underrot"] = "O Subterrâneo"
L["The Vault of Lights"] = "O Cofre das Luzes"
L["The Violet Hold"] = "O Cubo Violeta"
L["The Vortex Pinnacle"] = "A Pinnacle do Vórtice"
L["The Waning Crescent"] = "A Lua Minguante"
L["The Zoram Strand"] = "Praia de Zoram"
L["Theater of Pain"] = "Teatro da Dor"
L["Thelsamar"] = "Thelsamar"
L["Theramore Isle"] = "Ilha Theramore"
L["Thorium Point"] = "Posto de Tório"
L["Thousand Needles"] = "Mil Agulhas"
L["Thrallmar"] = "Thrallmar"
L["Throne of the Four Winds"] = "Trono dos Quatro Ventos"
L["Throne of the Tides"] = "Trono das Marés"
L["Throne of Thunder"] = "Trono do Trovão"
L["Thunder Bluff"] = "Penhasco do Trovão"
L["Thunderlord Stronghold"] = "Cidadela do Senhor do Trovão"
L["Timbermaw Hold"] = "Domínio dos Presamatos"
L["Tinker Town"] = "Beco da Gambiarra"
L["Tint unexplored areas"] = "Matizar áreas inexploradas"
L["Tiragarde Sound"] = "Estreito Tiragarde"
L["Tirisfal Glades"] = "Clareiras de Tirisfal"
L["Titan Translocator"] = "Translocador Titânico"
L["Toggle panel"] = "Alternar painel"
L["Tol Barad"] = "Tol Barad"
L["Tomb of Sargeras"] = "Tumba de Sargeras"
L["Toshley's Station"] = "Estação do Tocha"
L["Trade District"] = "Distrito Comercial"
L["Trade Quarter"] = "Centro Comercial"
L["Tram to"] = "Metrô para"
L["Tranquillien"] = "Tranquillien"
L["Transitus Shield"] = "Escudo de Transição"
L["Transparency"] = "Transparência"
L["Trial of the Champion"] = "Prova do Campeão"
L["Trial of the Crusader"] = "Prova do Cruzado"
L["Trial of Valor"] = "Prova de Valor"
L["Twilight Highlands"] = "Planalto do Crepúsculo"
L["Twilight Shore"] = "Costa do Crepúsculo"
L["Twilight Vale"] = "Vale Crepuscular"
L["Twilight Vineyards"] = "Vinícolas do Crepúsculo"
L["Uldaman"] = "Uldaman"
L["Uldaman (side entrance)"] = "Uldaman (entrada lateral)"
L["Uldaman: Legacy of Tyr"] = "Uldaman: Legado de Tyr"
L["Uldir"] = "Uldir"
L["Ulduar"] = "Ulduar"
L["Uldum"] = "Uldum"
L["Underbog"] = "Brejo Oculto"
L["Undercity"] = "Cidade Baixa"
L["Un'Goro Crater"] = "Cratera Un'Goro"
L["Unlock battlefield map"] = "Desbloquear mapa do campo de batalha"
L["Unlock map frame"] = "Desbloquear mapa"
L["Unu'pe"] = "Unu'pe"
L["Upper Blackrock Spire"] = "Pico da Rocha Negra Superior"
L["Use default map"] = "Mapa padrão"
L["Use large font"] = "Usar fonte grande"
L["Use stationary opacity while pointing at map"] = "Use opacidade estacionária enquanto aponta para o mapa"
L["Utgarde Keep"] = "Bastilha Utgarde"
L["Utgarde Pinnacle"] = "Pináculo Utgarde"
L["Valaar's Berth"] = "Atracadouro de Valaar"
L["Valdrakken Portals"] = "Portais de Valdrakken"
L["Valgarde"] = "Valgarde"
L["Valgarde Port"] = "Porto Valgarde"
L["Valiance Keep"] = "Fortaleza da Bravura"
L["Valiance Landing Camp"] = "Campo de Pouso da Bravura"
L["Valley of Strength"] = "Vale da Força"
L["Valormok"] = "Valormok"
L["Vashj'ir"] = "Vashj'ir"
L["Vault of Archavon"] = "Câmara de Archavon"
L["Vault of the Incarnates"] = "Cofre dos Incarnados"
L["Vault of the Wardens"] = "Cofre das Celadoras"
L["Vengeance Landing"] = "Campo Vingança"
L["Venomspite"] = "Esporâmpia"
L["Version"] = "Versão"
L["Vol'mar"] = "Vol'mar"
L["Wailing Caverns"] = "Caverna Ululante"
L["Warsong Camp"] = "Campo Cantonegro"
L["Warsong Hold"] = "Fortaleza Cantonegro"
L["Waycrest Manor"] = "Solar de Ulfar"
L["Well of Eternity"] = "Pozzo dell'Eternità"
L["Western Earthshrine"] = "Santuário da Terra Ocidental"
L["Western Plaguelands"] = "Terras Pestilentas Ocidentais"
L["Westfall"] = "Cerro Oeste"
L["Westfall Brigade"] = "Brigada do Oeste"
L["Westguard Keep"] = "Fortaleza Guarda Ocidental"
L["Wetlands"] = "Pantanal"
L["Wildhammer Stronghold"] = "Fortaleza Martelo Feroz"
L["Windowed"] = "Janela"
L["Windrunner's Overlook"] = "Mirante de Correventos"
L["Wintergarde Keep"] = "Fortaleza Invernáutica"
L["Wintergrasp"] = "Razões do Inverno"
L["Winterspring"] = "Hibérnia"
L["World of Warcraft Classic"] = "World of Warcraft Clássico"
L["Wrath of the Lich King Classic"] = "Clássico: Wrath of the Lich King"
L["Wyrmrest Temple"] = "Templo do Repouso do Dragão"
L["You cannot do that in combat."] = "Você não pode fazer isso em combate."
L["You will die!"] = "Você vai morrer!"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Sua interface do usuário precisa ser recarregada para que algumas alterações entrem em vigor.|n|nVocê não precisa clicar no botão recarregar imediatamente, mas precisa clicar nele quando concluir as alterações e desejar que as alterações entrem em vigor."
L["Your UI needs to be reloaded."] = "Sua interface do usuário precisa ser recarregada."
L["Zabra'jin"] = "Zabra'jin"
L["Zangarmarsh"] = "Pântano Zíngaro"
L["Zeb'Sora"] = "Zeb'Sora"
L["Zeppelin to"] = "Zepelin para"
L["Zim'Torga"] = "Zim'Torga"
L["Zone Map"] = "Mapa da Zona"
L["Zoom"] = "Zoom"
L["Zoram'gar Outpost"] = "Assentamento Zoram'gar"
L["Zul'Aman"] = "Zul'Aman"
L["Zuldazar"] = "Zuldazar"
L["Zul'Drak"] = "Zul'Drak"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"

end
