--------------------------------------------------------------------------
-- GTFO_Fail_TWW.lua 
--------------------------------------------------------------------------
--[[
GTFO Fail List - The War Within
]]--

if (GTFO.RetailMode) then

--- ************************
--- *  Khaz Algar (World)  *
--- ************************

GTFO.SpellID["446807"] = {
  --desc = "Explosion (Bomb, Dalaran intro)";
  sound = 3;
};

GTFO.SpellID["445935"] = {
  --desc = "Heartbane Poison (Bomb, Dalaran intro)";
  applicationOnly = true;
  sound = 3;
  trivialLevel = 80;
};

GTFO.SpellID["445974"] = {
  --desc = "Bloodchill Toxin (Bomb, Dalaran intro)";
  sound = 3;
  trivialLevel = 80;
};

GTFO.SpellID["441738"] = {
  --desc = "EZ-Mine Dynamite (Dislodged Dynamite)";
  sound = 3;
};

GTFO.SpellID["433796"] = {
  --desc = "Erratic Energy (Bomb, Post Dalaran)";
  sound = 3;
};

GTFO.SpellID["448547"] = {
  --desc = "Impale (Queensguard Zirix)";
  sound = 3;
};

GTFO.SpellID["456047"] = {
  --desc = "Storm Surge (Kereke)";
  sound = 3;
  applicationOnly = true;
  trivialLevel = 90;
};

GTFO.SpellID["459022"] = {
  --desc = "Plaguestomp (Rotfist)";
  sound = 3;
};

GTFO.SpellID["450183"] = {
  --desc = "Seismic Slam (Kronolith, Might of the Mountain)";
  sound = 3;
};

GTFO.SpellID["390927"] = {
  --desc = "Throw Dynamite (Sparklit Bomber)";
  sound = 3;
};

GTFO.SpellID["457526"] = {
  --desc = "Molten Barrage (Cogchewer)";
  sound = 3;
};

GTFO.SpellID["454675"] = {
  --desc = "Earth Nova (Angry Rocks)";
  sound = 3;
};

GTFO.SpellID["456091"] = {
  --desc = "Shard Shower (Reconstructed Skardyn)";
  sound = 3;
};

GTFO.SpellID["452289"] = {
  --desc = "Cave In (Kol Bruncrag)";
  sound = 3;
};

GTFO.SpellID["417620"] = {
  --desc = "Firestorm (Broken Machinery)";
  sound = 3;
};

GTFO.SpellID["438447"] = {
  --desc = "Inferno Blast";
  applicationOnly = true;
  trivialLevel = 90;
  sound = 3;
};

GTFO.SpellID["435469"] = {
  --desc = "Rain of Bombs (Machinist Protector)";
  sound = 3;
};

GTFO.SpellID["440102"] = {
  --desc = "Earthen Rain (Iron-Runed Protector)";
  sound = 3;
};

GTFO.SpellID["440000"] = {
  --desc = "Flaming Rain (Earthen-Ward Sentinel)";
  sound = 3;
};

GTFO.SpellID["452252"] = {
  --desc = "Lava Blast (Master Machinist Dunstan)";
  sound = 3;
};

GTFO.SpellID["447918"] = {
  --desc = "Molten Mortar (Master Machinist Dunstan)";
  sound = 3;
};

GTFO.SpellID["457869"] = {
  --desc = "Lurking Impale (Deepfiend Azellix)";
  sound = 3;
};

GTFO.SpellID["457461"] = {
  --desc = "Burrowing Strike (Siegelord Xerosh)";
  sound = 3;
};

GTFO.SpellID["455877"] = {
  --desc = "Massive Stomp (Deepwater Abomination)";
  sound = 3;
};

GTFO.SpellID["445255"] = {
  --desc = "Necrotic End (Heartfang)";
  sound = 3;
};

GTFO.SpellID["433409"] = {
  --desc = "Web Mine";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["443190"] = {
  --desc = "Pheromones Revealed";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["445807"] = {
  --desc = "Fanged Leap (Heelripper)";
  sound = 3;
};

GTFO.SpellID["443036"] = {
  --desc = "Ironweave Tornado";
  sound = 3;
};

GTFO.SpellID["440694"] = {
  --desc = "Alchemical Bombardment";
  sound = 3;
};

GTFO.SpellID["449663"] = {
  --desc = "Siegefire Bomb (Maddened Siegebomber)";
  sound = 3;
};

GTFO.SpellID["454736"] = {
  --desc = "Zoomies (Tka'ktath)";
  sound = 3;
};

GTFO.SpellID["454765"] = {
  --desc = "Shake (Tka'ktath)";
  sound = 3;
};

GTFO.SpellID["455343"] = {
  --desc = "Uppies! (Tka'ktath)";
  sound = 3;
};

GTFO.SpellID["446535"] = {
  --desc = "Goring Charge (Warphorn)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["449368"] = {
  --desc = "Clear the Deck! (Wanderer Ida)";
  sound = 3;
};

GTFO.SpellID["449388"] = {
  --desc = "Cast the Nets! (Wanderer Ida)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["448173"] = {
  --desc = "Strangling Seaweed (Enormous Kelp-Snaggler)";
  sound = 3;
};

GTFO.SpellID["397095"] = {
  --desc = "Kelp's Clutches (Seaborne Colossus)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["435409"] = {
  --desc = "Mineshroom Detonation (Explosive Mineshroom)";
  sound = 3;
};

GTFO.SpellID["435310"] = {
  --desc = "Vine Snare (Murmuring Trapcap)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["446325"] = {
  --desc = "Feather Storm (Infected Peafowl)";
  sound = 3;
};

GTFO.SpellID["435453"] = {
  --desc = "Mycopsychosis (Frightfilled Mineshroom)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["451284"] = {
  --desc = "Rotting Charge (Rotbark the Unfelled)";
  sound = 3;
};

GTFO.SpellID["456940"] = {
  --desc = "Sacred Wave (Manifested Protocol)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["446006"] = {
  --desc = "Burrow (Deeps Larva)";
  sound = 3;
};

GTFO.SpellID["462826"] = {
  --desc = "Self Destruct (Explosive Bomberbot)";
  sound = 3;
};

GTFO.SpellID["463094"] = {
  --desc = "Earthshaking Charge (Awakened Phalanx)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["463065"] = {
  --desc = "Cave In (Awakened Phalanx)";
  sound = 3;
};

GTFO.SpellID["455231"] = {
  --desc = "Deathbud (Lashroom Ambusher)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["446646"] = {
  --desc = "Double Impact (Surek'Tak the Sundered)";
  sound = 3;
};

GTFO.SpellID["452204"] = {
  --desc = "Light Burst (Ravenous Glowmite)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["458086"] = {
  --desc = "Bounding Slam (Croakit)";
  sound = 3;
};

GTFO.SpellID["458066"] = {
  --desc = "Gluttonous Upheaval (Croakit)";
  sound = 3;
};

GTFO.SpellID["452105"] = {
  --desc = "Cave In (Obstorn)";
  sound = 3;
};

GTFO.SpellID["453553"] = {
  --desc = "Flamethrower (Charmonger)";
  sound = 3;
};

GTFO.SpellID["459942"] = {
  --desc = "Impale (Palace Guardian)";
  sound = 3;
};

GTFO.SpellID["452210"] = {
  --desc = "Crystalline Barrage (Aggregation of Horrors)";
  sound = 3;
};

GTFO.SpellID["454945"] = {
  --desc = "Bellowing Gust (Pterrordaxus)";
  sound = 3;
};

GTFO.SpellID["453192"] = {
  --desc = "Fracturing Crags (Cragmund)";
  sound = 3;
};

GTFO.SpellID["450863"] = {
  --desc = "Rupturing Runes (Orta)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["450407"] = {
  --desc = "Colossal Slam (Orta)";
  sound = 3;
};

GTFO.SpellID["455878"] = {
  --desc = "Reformation Nova (The Oozekhan)";
  sound = 3;
};

GTFO.SpellID["456329"] = {
  --desc = "Grimweave Bombardment (Harvester Qixt)";
  sound = 3;
};

GTFO.SpellID["448351"] = {
  --desc = "Stomp! (Wicktwister Kobold)";
  sound = 3;
};

GTFO.SpellID["442725"] = {
  --desc = "Furnace Blast";
  sound = 3;
};

GTFO.SpellID["458433"] = {
  --desc = "Arcane Bombardment (Kordac)";
  sound = 3;
};

GTFO.SpellID["458220"] = {
  --desc = "Overcharged Lasers (Kordac)";
  sound = 3;
};

GTFO.SpellID["440378"] = {
  --desc = "Sporefused Explosion";
  sound = 3;
};

GTFO.SpellID["464508"] = {
  --desc = "Shadow Fissure (Kel'Thuzad)";
  sound = 3;
};

GTFO.SpellID["465368"] = {
  --desc = "War Stomp (Ossirian the Unscarred)";
  sound = 3;
};

GTFO.SpellID["465658"] = {
  --desc = "Harsh Winds (Ossirian the Unscarred)";
  sound = 3;
};

GTFO.SpellID["465373"] = {
  --desc = "Curse of Locusts (Ossirian the Unscarred)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["465369"] = {
  --desc = "Curse of Locusts (Ossirian the Unscarred)";
  applicationOnly = true;
  sound = 1;
};

GTFO.SpellID["466187"] = {
  --desc = "Curse of Boils (Ossirian the Unscarred)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["455925"] = {
  --desc = "Precision Impale (Deepcrawler Tx'kesh)";
  sound = 3;
};

GTFO.SpellID["450675"] = {
  --desc = "Grimweave Burst (Sureki Priestess)";
  sound = 3;
};

GTFO.SpellID["468745"] = {
  --desc = "Crystalline Force (Faded Construct)";
  sound = 3;
};

GTFO.SpellID["466692"] = {
  --desc = "Stomp (Ikir the Flotsurge)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["469167"] = {
  --desc = "Tail Thrash (Nerathor)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["464719"] = {
  --desc = "Cave In (Stalagnarok)";
  sound = 3;
};

GTFO.SpellID["468974"] = {
  --desc = "Boulder Throw (Stalagnarok)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["468832"] = {
  --desc = "Colossal Slam (Stalagnarok)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["460967"] = {
  --desc = "Flash! (Blinding Glowmite)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["471846"] = {
  --desc = "Violent Percolation (Wreckwater)";
  sound = 3;
};

GTFO.SpellID["471862"] = {
  --desc = "Tidal Surge (Wreckwater)";
  sound = 3;
};

GTFO.SpellID["471863"] = {
  --desc = "Tidal Surge (Wreckwater)";
  sound = 3;
};

GTFO.SpellID["469184"] = {
  --desc = "Dark Wings (Nerathor)";
  sound = 3;
};

GTFO.SpellID["471333"] = {
  --desc = "Lightning Ball (Shadowtide Watcher)";
  sound = 3;
};

GTFO.SpellID["425999"] = {
  --desc = "Unstable Explosives (Candlelit Boomer)";
  sound = 3;
};

GTFO.SpellID["469992"] = {
  --desc = "Explode (Wildlife Removal Unit)";
  sound = 3;
};

GTFO.SpellID["472845"] = {
  --desc = "Incendiary Bombardment (Swigs Farsight)";
  sound = 3;
};

GTFO.SpellID["470978"] = {
  --desc = "Rocket Barrage (Nikki the Fixer)";
  sound = 3;
};

GTFO.SpellID["1215618"] = {
  --desc = "Explosive Present (Fusetwister Trish)";
  sound = 3;
};

GTFO.SpellID["1216467"] = {
  --desc = "Lacerated";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["1216577"] = {
  --desc = "Bomb Voyage (The Gobfather)";
  sound = 3;
};

GTFO.SpellID["1216687"] = {
  --desc = "Flaming Flames (The Gobfather)";
  sound = 3;
};

GTFO.SpellID["1216747"] = {
  --desc = "Death From Above (The Gobfather)";
  sound = 3;
};

GTFO.SpellID["470847"] = {
  --desc = "Slobber Volley (Ahn'tak)";
  sound = 3;
};

GTFO.SpellID["454875"] = {
  --desc = "Earthshaking Crash (Kiji the Stomper)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["454634"] = {
  --desc = "Leaping Thrash (Clawmother Tengi)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["456256"] = {
  --desc = "Earthshatter (Earthfury Cragshar)";
  sound = 3;
};

GTFO.SpellID["455152"] = {
  --desc = "Blast Wave (Crateron)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["455894"] = {
  --desc = "Burning Charge (Oremex Flamebreaker)";
  sound = 3;
};

GTFO.SpellID["455913"] = {
  --desc = "Scalding Breath (Oremex Flamebreaker)";
  sound = 3;
};

GTFO.SpellID["1218056"] = {
  --desc = "Demolish (Massive Kaja'mental)";
  sound = 3;
};

GTFO.SpellID["1214690"] = {
  --desc = "Overhead Smash (Deep-King Grobosh)";
  sound = 3;
};

GTFO.SpellID["1232621"] = {
  --desc = "Void Rush (Shadowguard Infiltrator)";
  sound = 3;
};

GTFO.SpellID["1234524"] = {
  --desc = "Dark Sweep (Shadowlord Al'zar)";
  sound = 3;
};

GTFO.SpellID["1240565"] = {
  --desc = "Corrosive Spittle (Grubber)";
  sound = 3;
};

GTFO.SpellID["1239791"] = {
  --desc = "Gluttonous Eruption (Engorged Siltfeaster)";
  sound = 3;
};

GTFO.SpellID["1231445"] = {
  --desc = "Umbral Stomp (Void Terror)";
  sound = 3;
};

GTFO.SpellID["1227789"] = {
  --desc = "Burrowing Eruption (Void Creeper)";
  sound = 3;
};

GTFO.SpellID["1226398"] = {
  --desc = "Errant Zap (Reshanor)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["1226441"] = {
  --desc = "Null Rupture (Reshanor)";
  sound = 3;
};

GTFO.SpellID["1237718"] = {
  --desc = "Overcharged Mana";
  sound = 3;
};

GTFO.SpellID["1216012"] = {
  --desc = "Gorging Smash (Devourer Gorger)";
  sound = 3;
};

GTFO.SpellID["1240114"] = {
  --desc = "Rampaging Charge (Miasmawrath)";
  sound = 3;
};

GTFO.SpellID["1236933"] = {
  --desc = "Unstable Ejection (Miasmawrath)";
  sound = 3;
};

GTFO.SpellID["1242834"] = {
  --desc = "Tripwire";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["1252578"] = {
  --desc = "Unstable Void Rift";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["1242832"] = {
  --desc = "Void Beam";
  sound = 3;
};

--- ****************************
--- * Ara-Kara, City of Echoes *
--- ****************************

GTFO.SpellID["436401"] = {
  --desc = "AUGH! (Spider Eggs)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["434824"] = {
  --desc = "Web Spray (Ixin)";
  sound = 3;
};

GTFO.SpellID["438623"] = {
  --desc = "Toxic Rupture (Engorged Crawler)";
  sound = 3;
};

GTFO.SpellID["438832"] = {
  --desc = "Poisonous Cloud (Atik - Impact)";
  sound = 3;
  test = true; -- Verification
};

GTFO.SpellID["433443"] = {
  --desc = "Impale (Anub'zekt)";
  sound = 3;
};

GTFO.SpellID["453160"] = {
  --desc = "Impale (Hulking Bloodguard)";
  sound = 3;
};

GTFO.SpellID["433843"] = {
  --desc = "Erupting Webs (Blood Overseer)";
  sound = 3;
};

GTFO.SpellID["433662"] = {
  --desc = "Grasping Blood (Black Blood)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["432132"] = {
  --desc = "Erupting Webs (Ki'katal the Harvester)";
  sound = 3;
};

GTFO.SpellID["432031"] = {
  --desc = "Grasping Blood (Ki'katal the Harvester - Black Blood)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["432119"] = {
  --desc = "Faded (Ki'katal the Harvester)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["453767"] = {
  --desc = "Aerial Defense Orbs (Colossal Titan Construct)";
  sound = 3;
};

GTFO.SpellID["461507"] = {
  --desc = "Cultivated Poisons (Ki'katal the Harvester)";
  sound = 3;
};

GTFO.SpellID["456320"] = {
  --desc = "Tide Whirl (Zaniga the Tracker)";
  sound = 3;
};

GTFO.SpellID["456280"] = {
  --desc = "Waterfall (Zaniga the Tracker)";
  sound = 3;
};

GTFO.SpellID["455838"] = {
  --desc = "Umbral Breath (S'toth the Insatiable)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["457277"] = {
  --desc = "Azeroth's Rage";
  sound = 3;
};



--- **********************
--- * Cinderbrew Meadery *
--- **********************

GTFO.SpellID["435000"] = {
  --desc = "High Steaks (Chef Chewie)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["434707"] = {
  --desc = "Cinderbrew Toss (Tasting Room Attendant)";
  sound = 3;
};

GTFO.SpellID["432198"] = {
  --desc = "Blazing Belch (Brew Master Aldryr)";
  sound = 3;
};

GTFO.SpellID["445180"] = {
  --desc = "Crawling Brawl (Brew Master Aldryr)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["439991"] = {
  --desc = "Spouting Stout (I'pa - Swirl)";
  sound = 3;
};

GTFO.SpellID["442589"] = {
  --desc = "Beeswax (Venture Co. Honey Harvester)";
  sound = 3;
};

GTFO.SpellID["440887"] = {
  --desc = "Rain of Honey (Royal Jelly Purveyor)";
  sound = 3;
};

GTFO.SpellID["441344"] = {
  --desc = "Bee-Zooka (Bee Wrangler)";
  -- sound = 4;
  -- Private aura, will need to track SPELL_CAST_SUCCESS to determine for failure, but I'm not sure the extra overhead is worth it 
  -- SPELL_CAST_SUCCESS,Creature-0-2085-2661-15405-210264-000165FCCC,"Bee Wrangler",0xa48,0x0,Player-4184-005C2C54,"TestPlayerNameHere-TheseGoToEleven",0x511,0x0,441119,"Bee-Zooka",0x1,Creature-0-2085-2661-15405-210264-000165FCCC,0000000000000000,7748325,7846710,0,0,108569,0,1,0,0,0,2516.85,-4935.88,2335,0.2229,80
};

GTFO.SpellID["439468"] = {
  --desc = "Downward Trend (Yes Man)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["436592"] = {
  --desc = "Cash Cannon (Goldie Baronbottom)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["435788"] = {
  --desc = "Cinder-BOOM! (Goldie Baronbottom)";
  sound = 3;
};

GTFO.SpellID["448920"] = {
  --desc = "Reckless Delivery (Careless Hopgoblin)";
  sound = 3;
};

--- *******************
--- * City of Threads *
--- *******************

-- TODO: Slime Propagation (Orator Krix'vizk) - Mythic
-- TODO: Gutburst (Izo - Ravenous Scarab) - Mythic


GTFO.SpellID["443438"] = {
  --desc = "Doubt (Herald of Ansurek)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["448561"] = {
  --desc = "Shadows of Doubt (Orator Krix'vizk)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["450783"] = {
  --desc = "Perfume Toss (Xeph'itik)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["451426"] = {
  --desc = "Gossamer Barrage (Xeph'itik)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["443500"] = {
  --desc = "Earthshatter (Royal Swarmguard)";
  sound = 3;
};

GTFO.SpellID["434710"] = {
  --desc = "Chains of Oppression (Orator Krix'vizk - Pulled in)";
  sound = 3;
};

GTFO.SpellID["434779"] = {
  --desc = "Terrorize (Orator Krix'vizk)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["451543"] = {
  --desc = "Null Slam (Eye of the Queen)";
  sound = 3;
};

GTFO.SpellID["448047"] = {
  --desc = "Web Wrap (Pale Priest)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["440049"] = {
  --desc = "Synergic Step (Nx)";
  sound = 3;
};

GTFO.SpellID["439696"] = {
  --desc = "Duskbringer (Nx)";
  sound = 3;
};

GTFO.SpellID["439687"] = {
  --desc = "Shade Slash (Nx)";
  sound = 3;
};

GTFO.SpellID["439686"] = {
  --desc = "Shade Slash (Nx)";
  sound = 3;
};

GTFO.SpellID["434133"] = {
  --desc = "Venomous Spray (Royal Venomshell)";
  sound = 3;
};

GTFO.SpellID["445838"] = {
  --desc = "Dark Barrage (Unstable Test Subject)";
  sound = 3;
};

GTFO.SpellID["447271"] = {
  --desc = "Tremor Slam (Hulking Warshell)";
  sound = 0;
  test = true; -- Need to determine appropriate minimum, doesn't use 2 spell IDs for proximity
};

GTFO.SpellID["437700"] = {
  --desc = "Tremor Slam (Izo, the Grand Splicer)";
  sound = 0;
  test = true; -- Need to determine appropriate minimum, doesn't use 2 spell IDs for proximity
};

GTFO.SpellID["439481"] = {
  --desc = "Shifting Anomalies (Izo, the Grand Splicer)";
  sound = 3;
};

--- *******************
--- * Darkflame Cleft *
--- *******************

-- TODO: Extinguishing Gust (Blazikon) - Mythic
-- TODO: Eternal Darkness (The Darkness) - Mythic

GTFO.SpellID["423501"] = {
  --desc = "Wild Wallop (Rank Overseer)";
  sound = 3;
};

GTFO.SpellID["422274"] = {
  --desc = "Cave-In (Ol' Waxbeard)";
  sound = 3;
};

GTFO.SpellID["422125"] = {
  --desc = "Reckless Charge (Ol' Waxbeard)";
  sound = 3;
};

GTFO.SpellID["424821"] = {
  --desc = "High Speed Collision (Ol' Waxbeard - Creaky Mine Cart)";
  sound = 3;
};

GTFO.SpellID["426779"] = {
  --desc = "Explosive Flame (Blazing Fiend)";
  sound = 3;
};

GTFO.SpellID["426883"] = {
  --desc = "Bonk! (Kobold Taskworker)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["443969"] = {
  --desc = "Enkindling Inferno (Blazikon)";
  sound = 3;
};

GTFO.SpellID["428650"] = {
  --desc = "Burning Backlash (Wandering Candle)";
  sound = 3;
};

GTFO.SpellID["440652"] = {
  --desc = "Surging Wax (Wandering Candle)";
  sound = 3;
};

GTFO.SpellID["421653"] = {
  --desc = "Cursed Wax (The Candle King)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["421282"] = {
  --desc = "Darkflame Pickaxe (The Candle King)";
  sound = 3;
};

GTFO.SpellID["421146"] = {
  --desc = "Throw Darkflame (The Candle King)";
  soundFunction = function() -- Warn only if you get hit more than once 
	if (GTFO_FindEvent("DarkflameCandleKing")) then
		return 3;
	end
	GTFO_AddEvent("DarkflameCandleKing", 3);
	return 0;
  end
};

GTFO.SpellID["422393"] = {
  --desc = "Suffocating Darkness (Skittering Darkness)";
  sound = 3;
};

GTFO.SpellID["427011"] = {
  --desc = "Shadowblast (The Darkness - Application)";
  applicationOnly = true;
  soundFunction = function() 
	GTFO_AddEvent("Shadowblast", 9);
	return 0;
  end;
};

GTFO.SpellID["427011"] = {
  --desc = "Shadowblast (The Darkness - Explosion)";
  negatingDebuffSpellID = 427015; -- Shadowblast
  ignoreEvent = "Shadowblast";
  sound = 4;
};

GTFO.SpellID["427100"] = {
  --desc = "Umbral Slash (The Darkness)";
  sound = 3;
};

GTFO.SpellID["422414"] = {
  --desc = "Shadow Smash (Shuffling Horror)";
  sound = 3;
};

GTFO.SpellID["1217603"] = {
  --desc = "Earthsplitter (The Stone)";
  sound = 3;
};

GTFO.SpellID["471929"] = {
  --desc = "Back Off (Warehouse Muscle)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["470333"] = {
  --desc = "Back Off (Stationed Labguard)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["470035"] = {
  --desc = "Detonate (Volatile Blastbot)";
  sound = 3;
};

GTFO.SpellID["464682"] = {
  --desc = "Explosion!";
  sound = 3;
};

--- ******************************
--- * Priory of the Scared Flame *
--- ******************************

GTFO.SpellID["453461"] = {
  --desc = "Caltrops (Fervent Sharpshooter)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["427472"] = {
  --desc = "Flamestrike (Fanatical Mage - Impact)";
  sound = 3;
};

GTFO.SpellID["424621"] = {
  --desc = "Brutal Smash (Sergeant Shaynemail)";
  sound = 3;
};

GTFO.SpellID["427601"] = {
  --desc = "Burst of Light (Lightspawn)";
  sound = 3;
};

GTFO.SpellID["424460"] = {
  --desc = "Ember Storm (Taener Duelmal)";
  sound = 3;
};

GTFO.SpellID["423076"] = {
  --desc = "Hammer of Purity (Baron Braunpyke - Impact)";
  sound = 3;
};

GTFO.SpellID["423121"] = {
  --desc = "Hammer of Purity (Baron Braunpyke - Flying Hammer)";
  sound = 3;
};

GTFO.SpellID["446657"] = {
  --desc = "Burning Light (Baron Braunpyke)";
  sound = 3;
  test = true; -- Verification, need more info about this one
};

GTFO.SpellID["451818"] = {
  --desc = "Crushing Leap (Sir Braunpyke)";
  sound = 3;
  test = true; -- Verification
};

GTFO.SpellID["451606"] = {
  --desc = "Holy Flame (Prioress Murrpray)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["423019"] = {
  --desc = "Castigator's Detonation (Baron Braunpyke)";
  sound = 3;
};

GTFO.SpellID["428170"] = {
  --desc = "Blinding Light (Prioress Murrpray)";
  applicationOnly = true;
  sound = 3;
};

--- *******************
--- * The Dawnbreaker *
--- *******************

-- TODO: Stygian Seed (Nightfall Ritualist)
-- TODO: Obsidian Beam (Shadowcrown) - Mythic
-- TODO: Collapsing Night (Shadowcrown) - Mythic

GTFO.SpellID["430655"] = {
  --desc = "Arathi Airship Cannon";
  sound = 3;
};

GTFO.SpellID["451093"] = {
  --desc = "Arathi Bomb";
  sound = 3;
};

GTFO.SpellID["451104"] = {
  --desc = "Bursting Cocoon (Sureki Webmage)";
  sound = 4;
  applicationOnly = true; -- Friendly Fire applies a debuff, cocoon target doesn't get one
  trivialLevel = 90;
};

GTFO.SpellID["426715"] = {
  --desc = "Collapsing Darkness (Speaker Shadowcrown)";
  sound = 3;
};

GTFO.SpellID["449335"] = {
  --desc = "Encroaching Shadows";
  sound = 3;
};

GTFO.SpellID["451032"] = {
  --desc = "Darkness Comes (Speaker Shadowcrown)";
  sound = 3;
};

GTFO.SpellID["451098"] = {
  --desc = "Tacky Nova (Sureki Militant)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["432606"] = {
  --desc = "Black Hail (Manifested Shadow)";
  sound = 3;
};

GTFO.SpellID["431494"] = {
  --desc = "Black Edge (Nightfall Tactician)";
  sound = 3;
  trivialLevel = 90;
};

GTFO.SpellID["460135"] = {
  --desc = "Dark Scars (Deathscreamer Iken'tak)";
  applicationOnly = true;
  sound = 3;
  trivialLevel = 90;
};

GTFO.SpellID["451115"] = {
  --desc = "Terrifying Slam (Ixkreten the Unbreakable)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["427007"] = {
  --desc = "Terrifying Slam (Anub'ikkaj)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["427378"] = {
  --desc = "Dark Scars (Anub'ikkaj)";
  applicationOnly = true;
  sound = 3;
  trivialLevel = 90;
};

GTFO.SpellID["434441"] = {
  --desc = "Rolling Acid (Rasha'nan)";
  applicationOnly = true;
  negatingDebuffSpellID = 434576; -- Acidic Stupor
  sound = 3;
};

GTFO.SpellID["448215"] = {
  --desc = "Expel Webs (Rasha'nan)";
  sound = 3;
  test = true; -- Verify
};

--- ***************
--- * The Rookery *
--- ***************

-- TODO: Thunderbolt (Kyrioss) - Mythic
-- TODO: Void Chunks (Voidstone Monstrosity) - Mythic, Avoidable?

GTFO.SpellID["420679"] = {
  --desc = "Tornado Winds";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["444411"] = {
  --desc = "Stormheart (Kyrioss)";
  sound = 3;
};

GTFO.SpellID["427331"] = {
  --desc = "Charged Bombardment (Cursed Stormrider)";
  sound = 3;
};

GTFO.SpellID["432605"] = {
  --desc = "Charged Bombardment (Cursed Stormrider - Impact)";
  sound = 3;
};

GTFO.SpellID["434950"] = {
  --desc = "Void Orb";
  sound = 3;
};

GTFO.SpellID["433078"] = {
  -- Hidden aura, DBM detects this via SPELL_CAST_START 423979 on target, but only seems to cast on the tank
  --desc = "Implosion (Void Cursed Crusher - Initial circle)";
  sound = 4;
  tankSound = 0;
  test = true; -- Not sure why this isn't working
};

GTFO.SpellID["423981"] = {
  --desc = "Implosion (Void Cursed Crusher - Post-pull explosion)";
  sound = 3;
};

GTFO.SpellID["426968"] = {
  --desc = "Bounding Void (Quartermaster Koratite)";
  sound = 3;
};

GTFO.SpellID["430013"] = {
  --desc = "Thunderstrike (Unruly Stormrook)";
  sound = 3;
  test = true; -- Verification
};

GTFO.SpellID["419871"] = {
  --desc = "Lightning Dash (Kyrioss)";
  sound = 3;
};

GTFO.SpellID["420739"] = {
  --desc = "Unstable Charge (Kyrioss)";
  applicationOnly = true;
  soundFunction = function() 
	GTFO_AddEvent("UnstableCharge", 9);
	return 0;
  end;
  test = true; -- Verification
};

GTFO.SpellID["424195"] = {
  --desc = "Unstable Blast (Kyrioss)";
  sound = 4;
  ignoreEvent = "UnstableCharge";
  test = true; -- Verification
};

GTFO.SpellID["444250"] = {
  --desc = "Lightning Torrent (Kyrioss)";
  sound = 3;
  applicationOnly = true;
  trivialLevel = 90;
};

GTFO.SpellID["452932"] = {
  --desc = "Attracting Shadows (Corrupted Thunderer)";
  sound = 3;
};

GTFO.SpellID["430186"] = {
  --desc = "Seeping Corruption (Cursed Rookgruard - Explosion)";
  sound = 3;
};

GTFO.SpellID["443847"] = {
  --desc = "Instability (Inflicted Civilian)";
  sound = 3;
};

GTFO.SpellID["425113"] = {
  --desc = "Crush Reality (Stormguard Gorren)";
  sound = 3;
  test = true; -- This isn't working anymore in Season 2 - figure out why
};

GTFO.SpellID["426136"] = {
  --desc = "Reality Tear (Stormguard Gorren)";
  sound = 3;
};

GTFO.SpellID["425052"] = {
  --desc = "Dark Gravity (Stormguard Gorren)";
  sound = 3;
};

GTFO.SpellID["424739"] = {
  --desc = "Chaotic Corruption (Stormguard Gorren)";
  applicationOnly = true;
  soundFunction = function() 
	GTFO_AddEvent("ChaoticCorruption", 6.5);
	if (GTFO_HasDebuff("player", 424797)) then -- Chaotic Vulnerability
		return 3;
	end
	return 0;
  end;
};

GTFO.SpellID["426171"] = {
  --desc = "Chaotic Explosion (Stormguard Gorren)";
  sound = 4;
  ignoreEvent = "ChaoticCorruption";
};

GTFO.SpellID["442192"] = {
  --desc = "Oppressive Void (Void Mass)";
  sound = 3;
};

GTFO.SpellID["438848"] = {
  --desc = "Embrace the Void (Radiating Voidstone)";
  sound = 3;
};

GTFO.SpellID["430c"] = {
  --desc = "Crushing Darkness (Void Fragment)";
  sound = 3;
};

GTFO.SpellID["445537"] = {
  --desc = "Oblivion Wave (Voidstone Monstrosity)";
  sound = 3;
};

GTFO.SpellID["423356"] = {
  --desc = "Null Upheaval (Voidstone Monstrosity)";
  sound = 3;
};

GTFO.SpellID["429493"] = {
  --desc = "Unleash Corruption (Voidstone Monstrosity)";
  applicationOnly = true;
  soundFunction = function() 
	GTFO_AddEvent("UnleashCorruption", 8);
	return 0;
  end;
};

GTFO.SpellID["429521"] = {
  --desc = "Unleash Corruption (Voidstone Monstrosity)";
  soundFunction = function() -- Warn if you get hit more than once if you had a circle or if you didn't have a circle and got hit
	if (GTFO_FindEvent("UnleashCorruption")) then
		if (GTFO_FindEvent("UnleashCorruptionDouble")) then
			return 3;
		end
		GTFO_AddEvent("UnleashCorruptionDouble", 3);
		return 0;
	end
	return 3;
  end;
};

GTFO.SpellID["474017"] = {
  --desc = "Wild Lightning (Voidrider)";
  sound = 3;
};

GTFO.SpellID["1214318"] = {
  --desc = "Grounding Bolt (Kyrioss)";
  sound = 3;
};

GTFO.SpellID["1214326"] = {
  --desc = "Crashing Thunder (Kyrioss)";
  sound = 3;
  test = true; -- only alert when hit more than once in 2 seconds
};

GTFO.SpellID["1214645"] = {
  --desc = "Erupting Darkness (Consuming Voidstone)";
  sound = 3;
};

GTFO.SpellID["1214550"] = {
  --desc = "Umbral Wave (Void Ascendant)";
  sound = 3;
};


--- ******************
--- * The Stonevault *
--- ******************

GTFO.SpellID["425027"] = {
  --desc = "Seismic Wave (Earth Infused Golem)";
  sound = 3;
};

GTFO.SpellID["447145"] = {
  --desc = "Pulverizing Pounce (Repurposed Loaderbot)";
  sound = 3;
};

GTFO.SpellID["449129"] = {
  --desc = "Lava Cannon (Forge Loader)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["428547"] = {
  --desc = "Scrap Cube (Speaker Brokk)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["449169"] = {
  --desc = "Lava Cannon (Speaker Dorlita)";
  sound = 3;
  applicationOnly = true;
  trivialLevel = 90;
};

GTFO.SpellID["464392"] = {
  --desc = "Blazing Shrapnel (Speaker Dorlita)";
  sound = 3;
  applicationOnly = true;
  trivialLevel = 90;
};

GTFO.SpellID["449070"] = {
  --desc = "Crystal Salvo (Void Touched Elemental)";
  sound = 3;
};

GTFO.SpellID["422261"] = {
  --desc = "Crystal Shard (Skarmorak)";
  sound = 3;
};

GTFO.SpellID["423538"] = {
  --desc = "Unstable Crash (Skarmorak)";
  sound = 3;
};

GTFO.SpellID["443405"] = {
  --desc = "Unstable Fragments (Skarmorak)";
  sound = 3;
};

GTFO.SpellID["448975"] = {
  --desc = "Shield Stampede (Cursedforge Honor Guard)";
  sound = 3;
};

GTFO.SpellID["428709"] = {
  --desc = "Granite Eruption (Rock Smasher)";
  sound = 3;
};

GTFO.SpellID["427869"] = {
  --desc = "Unbridled Void (High Speaker Eirich)";
  sound = 3;
};

GTFO.SpellID["427854"] = {
  --desc = "Entropic Reckoning (Void Speaker Eirich)";
  soundFunction = function() -- Warn only if you get hit more than once 
	if (GTFO_FindEvent("EntropicReckoning")) then
		return 3;
	end
	GTFO_AddEvent("EntropicReckoning", 3);
	return 0;
  end
};


--- ***************
--- * TWW Delves  *
--- ***************

GTFO.SpellID["433410"] = {
  --desc = "Fearful Shriek (Chittering Fearmonger)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["450509"] = {
  --desc = "Wide Swipe (Nerubian Captain)";
  sound = 3;
};

GTFO.SpellID["448412"] = {
  --desc = "Burning Cart (Web General Ab'enar)";
  sound = 3;
};

GTFO.SpellID["448529"] = {
  --desc = "BOOM! (Spitfire Fusetender)";
  sound = 3;
};

GTFO.SpellID["427710"] = {
  --desc = "Sporesplosion (Sporbit)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["424738"] = {
  --desc = "Infectious Spores (Fungarian Flinger)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["424798"] = {
  --desc = "Bloated Eruption (Infected Beast)";
  sound = 3;
};

GTFO.SpellID["425319"] = {
  --desc = "Fungsplosion (Spinshroom)";
  sound = 3;
};

GTFO.SpellID["450131"] = {
  --desc = "Noxious Gas (Waxface - Swirl)";
  sound = 3;
};

GTFO.SpellID["450714"] = {
  --desc = "Jagged Barbs (Nerubian Lord)";
  sound = 3;
};

GTFO.SpellID["450710"] = {
  --desc = "Jagged Barbs (Nerubian Lord)";
  sound = 3;
};

GTFO.SpellID["448638"] = {
  --desc = "Impale (Under-Lord Vik'tis)";
  sound = 3;
};

GTFO.SpellID["439840"] = {
  --desc = "Cold Retort (Ice Block)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["447133"] = {
  --desc = "Poison Glob (Researcher Ven'kex)";
  sound = 3;
};

GTFO.SpellID["447187"] = {
  --desc = "Rend Void (Researcher Ven'kex)";
  sound = 3;
};

GTFO.SpellID["440679"] = {
  --desc = "Forbidden Ritual (Nerubian Ritualist - Swirl)";
  sound = 3;
};

GTFO.SpellID["442253"] = {
  --desc = "Forbidden Ritual (Nerubian Ritualist - Purple orb)";
  sound = 3;
};

GTFO.SpellID["440801"] = {
  --desc = "Dark Abatement (Nerl'athekk the Skulking)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["440806"] = {
  --desc = "Darkrift Smash (Nerl'athekk the Skulking - Impact)";
  sound = 3;
};

GTFO.SpellID["441129"] = {
  --desc = "Spotted! (Dark Bombardier)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["443292"] = {
  --desc = "Umbral Slam (Devouring Shade)";
  sound = 3;
};

GTFO.SpellID["453335"] = {
  --desc = "Erratic Energies";
  sound = 3;
};

GTFO.SpellID["443837"] = {
  --desc = "Shadow Sweep (Speaker Halven)";
  sound = 3;
};

GTFO.SpellID["444446"] = {
  --desc = "Speaker's Wrath (Speaker Davenruth)";
  sound = 3;
};

GTFO.SpellID["457448"] = {
  --desc = "Shadow Eruption (Slippery Syphoner)";
  sound = 3;
};

GTFO.SpellID["424891"] = {
  --desc = "Vine Spear (Fungal Speartender)";
  sound = 3;
};

GTFO.SpellID["454205"] = {
  --desc = "Muck Charge (Bogpiper)";
  sound = 3;
};

GTFO.SpellID["449061"] = {
  --desc = "Impaling Spikes (Overseer Kaskel)";
  sound = 3;
};

GTFO.SpellID["445038"] = {
  --desc = "Cleave (Kobyss Trickster)";
  sound = 3;
  tankSound = 0;
  test = true; -- Avoidable in single-player?
};

GTFO.SpellID["446406"] = {
  --desc = "Fungal Infection (Undersea Abomination)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["446321"] = {
  --desc = "Deepsea Polyps (Undersea Abomination)";
  sound = 3;
};

GTFO.SpellID["445781"] = {
  --desc = "Lava Blast (Stolen Loader)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["415253"] = {
  --desc = "Fungal Breath (Invasive Sporecap)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["415356"] = {
  --desc = "Fungal Explosion (Invasive Sporecap)";
  sound = 3;
};

GTFO.SpellID["434299"] = {
  --desc = "Echo of Renilash (Weeping Shade)";
  sound = 3;
};

GTFO.SpellID["462686"] = {
  --desc = "Skull Cracker (Reno Jackson)";
  sound = 3;
};

GTFO.SpellID["440768"] = {
  --desc = "Explosion (Black Blood Container)";
  sound = 3;
};

GTFO.SpellID["463418"] = {
  --desc = "Frost Glob (Researcher Ven'kex)";
  sound = 3;
};

GTFO.SpellID["458875"] = {
  --desc = "Shadow Wave (Speaker Xanventh)";
  applicationOnly = true;
  sound = 3;
  trivialLevel = 90;
};

GTFO.SpellID["445492"] = {
  --desc = "Serrated Cleave (Wandering Gutter)";
  sound = 3;
};

GTFO.SpellID["390957"] = {
  --desc = "Electric Cataclysm (Cragpie)";
  sound = 3;
};

GTFO.SpellID["423689"] = {
  --desc = "Void Essence";
  sound = 3;
};

GTFO.SpellID["453513"] = {
  --desc = "Decay Slam";
  sound = 3;
};

GTFO.SpellID["462690"] = {
  --desc = "Spontaneous Explosion (Darkened Husk)";
  sound = 3;
};

GTFO.SpellID["445776"] = {
  --desc = "Bubble Surge (Deepwater Makura)";
  sound = 3;
};

GTFO.SpellID["470590"] = {
  --desc = "Bubble Surge (Deepwater Makura)";
  sound = 3;
};

GTFO.SpellID["449319"] = {
  --desc = "Strife (Nerubian Darkcaster)";
  sound = 3;
};

GTFO.SpellID["450544"] = {
  --desc = "Angler's Web (Zekvir)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["450451"] = {
  --desc = "Claw Smash (Zekvir)";
  sound = 3;
};

GTFO.SpellID["451790"] = {
  --desc = "Infinite Horror (Zekvir)";
  sound = 3;
};

GTFO.SpellID["473343"] = {
  --desc = "Viscous Muck";
  sound = 3;
};

GTFO.SpellID["472768"] = {
  --desc = "Slimy Splatter (Profit M.A.X.-Miner 9000)";
  sound = 3;
};

GTFO.SpellID["1217514"] = {
  --desc = "Party Crashing Rocket (Party Rocket)";
  sound = 3;
};

GTFO.SpellID["1217326"] = {
  --desc = "Take a Selfie! (Underpin's Adoring Fan)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["1217369"] = {
  --desc = "Worthless Adorations (Underpin's Adoring Fan)";
  sound = 3;
};

GTFO.SpellID["1216806"] = {
  --desc = "There's the Door (Malfunctioning Pummeler)";
  sound = 3;
};

GTFO.SpellID["1215909"] = {
  --desc = "Carnage Cannon (Geargrave)";
  sound = 3;
};

GTFO.SpellID["473699"] = {
  --desc = "Molotov Cocktail (Flinging Flicker)";
  sound = 3;
};

GTFO.SpellID["473556"] = {
  --desc = "Rocket Barrage (Aerial Support Bot)";
  sound = 3;
};

GTFO.SpellID["474004"] = {
  --desc = "Drill Quake (Drill Sergeant)";
  sound = 3;
};

GTFO.SpellID["1214889"] = {
  --desc = "Chilled Steps";
  ignoreApplication = true;
  sound = 3;
};

GTFO.SpellID["473995"] = {
  --desc = "Bloodbath (Masked Freelancer)";
  sound = 3;
};

GTFO.SpellID["1217303"] = {
  --desc = "Heedless Charge (Aggressively Lost Hobgoblin)";
  sound = 3;
};

GTFO.SpellID["474229"] = {
  --desc = "Shadow Blast (Silent Slitherer - Impact)";
  sound = 3;
};

GTFO.SpellID["472850"] = {
  --desc = "Destroy (Bomb Bot)";
  sound = 3;
};

GTFO.SpellID["474314"] = {
  --desc = "Abyssal Grasp (Abyssal Tentacle)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["1216275"] = {
  --desc = "Molten Cannon (Crony)";
  sound = 3;
};

GTFO.SpellID["1216937"] = {
  --desc = "Underpin's Grand Entrance (The Underpin)";
  sound = 3;
};

GTFO.SpellID["1214130"] = {
  --desc = "Timed Explosion (Puntable Time Bomb)";
  sound = 3;
};

GTFO.SpellID["1217371"] = {
  --desc = "Flamethrower (The Underpin)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["1213853"] = {
  --desc = "Crush (The Underpin)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["1224387"] = {
  --desc = "Electric Sapper";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["1239731"] = {
  --desc = "Golem Smash (Awakened Defensive Construct)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["1220664"] = {
  --desc = "Overcharged Slam (Overcharged Bot)";
  sound = 3;
};

GTFO.SpellID["1228512"] = {
  --desc = "Titanic Storm Shot (Titanic Storm Crystal)";
  sound = 3;
};

GTFO.SpellID["1244108"] = {
  --desc = "Terrifying Screech (Pactsworn Sandreaver)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["1236778"] = {
  --desc = "Arcane Geyser (Shadowguard Steelsoul)";
  sound = 3;
};

GTFO.SpellID["1245242"] = {
  --desc = "Nexus Daggers (Nexus-Princess Ky'veza)";
  sound = 3;
};

GTFO.SpellID["1245171"] = {
  --desc = "Dark Massacre (Nexus-Princess Ky'veza)";
  sound = 3;
};

GTFO.SpellID["1244599"] = {
  --desc = "Shadow Eruption (Nexus-Princess Ky'veza)";
  sound = 3;
};

GTFO.SpellID["1245594"] = {
  --desc = "Nether Rift (Nexus-Princess Ky'veza)";
  sound = 3;
};


--- *******************
--- * Nerub-ar Palace *
--- *******************

GTFO.SpellID["444000"] = {
  --desc = "Gossamer Weave (Woven Threadmancer)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["436745"] = {
  --desc = "Ravaging Spikes (Scarab Captain Vul'akan)";
  sound = 3;
};

GTFO.SpellID["451412"] = {
  --desc = "Swallowing Darkness (Ulgrax the Devourer)";
  sound = 3;
};

GTFO.SpellID["439502"] = {
  --desc = "Stalker's Webbing (Ulgrax the Devourer)";
  sound = 3;
};

GTFO.SpellID["439419"] = {
  --desc = "Stalker's Netting (Ulgrax the Devourer)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["436217"] = {
  --desc = "Juggernaut Charge (Ulgrax the Devourer)";
  sound = 3;
};

GTFO.SpellID["435152"] = {
  --desc = "Digestive Acid (Ulgrax the Devourer)";
  sound = 4;
  test = true; -- Verify if you're not the acid target
};

GTFO.SpellID["464621"] = {
  --desc = "Consuming Mass (Congealed Mass)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["442987"] = {
  --desc = "Spewing Hemorrhage (The Bloodbound Horror)";
  sound = 3;
};

GTFO.SpellID["450132"] = {
  --desc = "Slime Wave (Slime Wave - Gauntlet)";
  sound = 3;
  alwaysAlert = true;
};

GTFO.SpellID["453066"] = {
  --desc = "Volatile Eruption (Slime Wave)";
  sound = 3;
};

GTFO.SpellID["453069"] = {
  --desc = "Slime Wave (Slime Wave)";
  sound = 3;
};

GTFO.SpellID["443061"] = {
  --desc = "Grasp From Beyond (The Bloodbound Horror)";
  sound = 3;
};

GTFO.SpellID["455027"] = {
  --desc = "Wicked Dive (Caustic Skyrazor)";
  sound = 3;
};

GTFO.SpellID["459504"] = {
  --desc = "Caustic Bomb";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["432353"] = {
  --desc = "Rain of Arrows (Sikran)";
  sound = 3;
};

GTFO.SpellID["441200"] = {
  --desc = "Acidic Hail (Venommaster Nezarox)";
  sound = 3;
};

GTFO.SpellID["459925"] = {
  --desc = "Reaping Claws (Palace Guardian)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["440184"] = {
  --desc = "Black Cleave (Chitin Knight)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["444023"] = {
  --desc = "Unstable Explosion (Unstable Experiment)";
  sound = 3;
};

GTFO.SpellID["441612"] = {
  --desc = "Vile Discharge (Broodtwister Ovi'nax)";
  sound = 3;
};

GTFO.SpellID["451016"] = {
  --desc = "Shatter Existence (Skeinspinner Takazj)";
  sound = 3;
};

GTFO.SpellID["441782"] = {
  --desc = "Strands of Reality (Skeinspinner Takazj)";
  sound = 3;
};

GTFO.SpellID["444094"] = {
  --desc = "Caustic Hail (Rasha'nan)";
  sound = 3;
};

GTFO.SpellID["449857"] = {
  --desc = "Impaled (Anub'arash)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["449696"] = {
  --desc = "Devastating Dreadwave (Queen's Guard Ge'zah)";
  sound = 3;
};

GTFO.SpellID["439536"] = {
  --desc = "Web Blades (Queen Ansurek)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["438481"] = {
  --desc = "Toxic Waves (Queen Ansurek)";
  sound = 3;
};

GTFO.SpellID["438804"] = {
  --desc = "Venom Nova (Queen Ansurek)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["464640"] = {
  --desc = "Concentrated Toxin (Queen Ansurek)";
  sound = 3;
  negatingDebuffSpellID = 451278; -- Concentrated Toxin
  ignoreEvent = "ConcentratedToxin";
};

GTFO.SpellID["464736"] = {
  --desc = "Concentrated Toxin (Queen Ansurek)";
  soundFunction = function() 
	GTFO_AddEvent("ConcentratedToxin", 9);
	return 0;
  end;
};

GTFO.SpellID["447240"] = {
  --desc = "Devour (Queen Ansurek)";
  sound = 3;
};

GTFO.SpellID["441084"] = {
  --desc = "Acid Explosion (Queen Ansurek)";
  sound = 3;
};

GTFO.SpellID["451600"] = {
  --desc = "Expulsion Beam (Chamber Expeller)";
  sound = 3;
};

GTFO.SpellID["451607"] = {
  --desc = "Paralyzing Waves (Queen Ansurek)";
  sound = 3;
};

GTFO.SpellID["439786"] = {
  --desc = "Rolling Acid (Rasha'nan)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["444030"] = {
  --desc = "Gossamer Weave (Web Cocoon)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["461408"] = {
  --desc = "Consume (Queen Ansurek)";
  sound = 3;
};

GTFO.SpellID["450031"] = {
  --desc = "Land (Queen Ansurek)";
  sound = 3;
};

GTFO.SpellID["450034"] = {
  --desc = "Land (Queen Ansurek)";
  sound = 3;
};

GTFO.SpellID["471445"] = {
  --desc = "Expulsion Beam (Chamber Expeller)";
  sound = 3;
};

GTFO.SpellID["453264"] = {
  --desc = "Rain of Arrows (Sikran)";
  sound = 3;
};

GTFO.SpellID["446351"] = {
  --desc = "Web Eruption (Broodtwister Ovi'nax)";
  sound = 4;
  applicationOnly = true;
};

GTFO.SpellID["442257"] = {
  --desc = "Infest (Blood Parasite)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["439408"] = {
  --desc = "Dark Viscera (Nexus-Princess Ky'veza)";
  sound = 3;
};

GTFO.SpellID["442495"] = {
  --desc = "Eclipse (Nexus-Princess Ky'veza)";
  sound = 3;
};

GTFO.SpellID["448176"] = {
  --desc = "Gloom Orbs (Ascended Voidspeaker)";
  sound = 3;
};

--- ***************************
--- * Blackrock Depths (Raid) *
--- ***************************

-- TODO: Magma Infusion (Ambassador Flamelash) - Frontal cone, avoidable by tanks?
-- TODO: Call Imperial Guard (Emperor Dagran Thaurissan) - Knockback from spawning mole machine

GTFO.SpellID["462838"] = {
  --desc = "Eruption (Lord Roccor)";
  sound = 3;
};

GTFO.SpellID["469032"] = {
  --desc = "Gaze of Terror (High Interrogator Gerstahn)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["463891"] = {
  --desc = "Crumbling Ceiling (Bael'Gar)";
  sound = 3;
};

GTFO.SpellID["462969"] = {
  --desc = "Molten Furnace (Bael'Gar)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["462974"] = {
  --desc = "Giant Strike (Bael'Gar)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["463470"] = {
  --desc = "Summon Flame Geyser (Lord Incendius)";
  sound = 3;
};

GTFO.SpellID["468580"] = {
  --desc = "Double Smash (Chiseled War Construct)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["468579"] = {
  --desc = "Double Smash (Chiseled War Construct)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["468569"] = {
  --desc = "Ironfel Strike (Fineous Darkvire)";
  sound = 3;
  tankSound = 0;
  test = true; -- Tank avoidable?
};

GTFO.SpellID["468820"] = {
  --desc = "Designed Disaster (Fineous Darkvire)";
  sound = 3;
};

GTFO.SpellID["463831"] = {
  --desc = "Chemical Pool (Prototype Toxic Golem)";
  sound = 3;
};

GTFO.SpellID["469711"] = {
  --desc = "Terrify (Vile'rel)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["467427"] = {
  --desc = "Artillery Barrage (Anvilrage Artillerist)";
  sound = 3;
};

GTFO.SpellID["467463"] = {
  --desc = "Rings of Fire (Shadowforge Flame Keeper)";
  sound = 3;
};

GTFO.SpellID["467503"] = {
  --desc = "Mortar (Anvilrage Artillerist)";
  sound = 3;
};

GTFO.SpellID["466663"] = {
  --desc = "Firing Line (Anvilrage Dragoon)";
  sound = 3;
};

GTFO.SpellID["464427"] = {
  --desc = "Detonate (Anvilrage Sapper)";
  sound = 3;
};

GTFO.SpellID["466262"] = {
  --desc = "Dark Iron Bomb (General Angerforge)";
  sound = 3;
};

GTFO.SpellID["464394"] = {
  --desc = "Fireburst Grenade (General Angerforge)";
  sound = 3;
  damageMinimum = 1000000; -- Weak in LFR, adding this to make it ignorable
};

GTFO.SpellID["467756"] = {
  --desc = "Deploy Mole Machine (General Angerforge)";
  sound = 3;
};

GTFO.SpellID["464382"] = {
  --desc = "Explosive Impact (Firestarter)";
  sound = 3;
  test = true; -- Not sure what triggers this?
};

GTFO.SpellID["408509"] = {
  --desc = "Superheat (Flamewalker)";
  sound = 3;
  damageMinimum = 2000000;
};

GTFO.SpellID["464379"] = {
  --desc = "Magma Sweep (Flamewalker)";
  sound = 3;
  tankSound = 0;  -- Tank avoidable?
};

GTFO.SpellID["410865"] = {
  --desc = "Spitfire (Spitfire Totem)";
  sound = 3;
};

GTFO.SpellID["470610"] = {
  --desc = "Mind Shattering Scream (Moira Bronzebeard)";
  sound = 3;
  test = true;
};

GTFO.SpellID["465074"] = {
  --desc = "Magma Shower (Magma Clap)";
  sound = 3;
  test = true;
};

GTFO.SpellID["468796"] = {
  --desc = "Dark Iron Dynamite (Doomforge Mechanic)";
  sound = 3;
};

GTFO.SpellID["466492"] = {
  --desc = "Molten Hand (Emperor Dagran Thaurissan)";
  sound = 3;
};

GTFO.SpellID["465068"] = {
  --desc = "Magma Clap (Emperor Dagran Thaurissan)";
  sound = 3;
  test = true;
};

--- ************************
--- * Operation: Floodgate *
--- ************************

GTFO.SpellID["464471"] = {
  --desc = "Out of Bounds Missile";
  sound = 3;
};

GTFO.SpellID["473473"] = {
  --desc = "Explosion (Mine Field)";
  sound = 3;
};

GTFO.SpellID["464294"] = {
  --desc = "Weapons Stockpile Explosion (Weapons Stockpile)";
  sound = 3;
};

GTFO.SpellID["1215089"] = {
  --desc = "Electrified Water (Electrified Water)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["461793"] = {
  --desc = "R.P.G.G. (Darkfuse Demolitionist)";
  sound = 3;
};

GTFO.SpellID["472454"] = {
  --desc = "Doom Storm (Darkfuse Mechadrone)";
  sound = 3;
  test = true;
};

GTFO.SpellID["465682"] = {
  --desc = "Surprise Inspection (Darkfuse Inspector)";
  sound = 3;
};

GTFO.SpellID["468727"] = {
  --desc = "Seaforium Charge (Venture Co. Diver)";
  sound = 3;
};

GTFO.SpellID["1217751"] = {
  --desc = "B.B.B.F.G. (Keeza Quickfuse)";
  sound = 3;
};

GTFO.SpellID["473526"] = {
  --desc = "Big Bada Boom (Keeza Quickfuse)";
  sound = 3;
};

GTFO.SpellID["460965"] = {
  --desc = "Barreling Charge (Bront)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["1214341"] = {
  --desc = "Bomb Pile Explosion (Bomb Pile)";
  sound = 3;
};

GTFO.SpellID["473126"] = {
  --desc = "Mudslide (Swampface)";
  sound = 3;
};

GTFO.SpellID["469819"] = {
  --desc = "Bubble (Bubbles)";
  sound = 3;
};

GTFO.SpellID["1217496"] = {
  --desc = "Splish Splash (Bubbles)";
  sound = 3;
};

GTFO.SpellID["465487"] = {
  --desc = "Bubbles Smash (Bubbles)";
  sound = 3;
};

GTFO.SpellID["465604"] = {
  --desc = "Battery Bolt (Darkfuse Jumpstarter)";
  sound = 3;
};

GTFO.SpellID["465982"] = {
  --desc = "Turbo Bolt (Geezle Gigazap)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["468604"] = {
  --desc = "Dam Rubble (Geezle Gigazap)";
  sound = 3;
};

GTFO.SpellID["468647"] = {
  --desc = "Leaping Spark (Leaping Spark)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["257371"] = {
  --desc = "Tear Gas (Mechanized Peacekeeper)";
  applicationOnly = true;
  sound = 3;
};

--- ***************************
--- * Liberation of Undermine *
--- ***************************

GTFO.SpellID["469794"] = {
  --desc = "Red Asphalt (The Geargrinder)";
  sound = 3;
};

GTFO.SpellID["468872"] = {
  --desc = "Red Asphalt (The Geargrinder)";
  sound = 3;
};

GTFO.SpellID["460625"] = {
  --desc = "Burning Shrapnel (The Geargrinder)";
  sound = 3;
};

GTFO.SpellID["1217939"] = {
  --desc = "Hot Wheels (Geargrinder Biker)";
  sound = 3;
};

GTFO.SpellID["460021"] = {
  --desc = "Hot Wheels (Geargrinder Biker)";
  sound = 3;
};

GTFO.SpellID["471477"] = {
  --desc = "Ankle Snapper (Darkfuse Houndmaster)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["468229"] = {
  --desc = "Slashing Prices (Shifty Scalper)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["467174"] = {
  --desc = "Bone Thumper Barrage (Professor Boomspark)";
  sound = 3;
};

GTFO.SpellID["474453"] = {
  --desc = "Mega Blast (Mechanized Peacekeeper)";
  sound = 3;
};

GTFO.SpellID["465466"] = {
  --desc = "Fiery Wave (Flarendo)";
  sound = 3;
};

GTFO.SpellID["473983"] = {
  --desc = "Static Discharge (Torq)";
  sound = 3;
};

GTFO.SpellID["463803"] = {
  --desc = "Zapbolt (Torq)";
  sound = 3;
};

GTFO.SpellID["474322"] = {
  --desc = "Thunderdrum Salvo (Torq)";
  sound = 3;
};

GTFO.SpellID["472242"] = {
  --desc = "Blastburn Roarcannon (Flarendo)";
  ignoreApplication = true;
  sound = 3;
};

GTFO.SpellID["1219199"] = {
  --desc = "Sonic Burst (Imperious Blaster)";
  sound = 3;
  test = true;
};

GTFO.SpellID["465102"] = {
  --desc = "Sundering Bash (Stagehand)";
  sound = 3;
  applicationOnly = true;
  tankSound = 0;
};

GTFO.SpellID["465715"] = {
  --desc = "Stunning Burst (Darkfuse Stunner)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["467564"] = {
  --desc = "Sonic Crush (Skiggy Muckheimer) - Target debuff";
  applicationOnly = true;
  soundFunction = function() 
	GTFO_AddEvent("SonicCrush", 10);
	return 0;
  end;
};

GTFO.SpellID["467565"] = {
  --desc = "Sonic Crush (Skiggy Muckheimer) - Actual hit";
  sound = 3;
  ignoreEvent = "SonicCrush";
};

GTFO.SpellID["466364"] = {
  --desc = "Amplification! (Rik Reverb)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["468119"] = {
  --desc = "Resonant Echoes (Rik Reverb)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["469380"] = {
  --desc = "Sound Cannon (Rik Reverb) - Target debuff";
  applicationOnly = true;
  soundFunction = function() 
	GTFO_AddEvent("SoundCannon", 6.5);
	return 0;
  end;
};

GTFO.SpellID["467615"] = {
  --desc = "Sound Cannon (Rik Reverb) - Actual blast";
  sound = 3;
  ignoreEvent = "SoundCannon";
  soundMythic = 0;
};

GTFO.SpellID["467991"] = {
  --desc = "Blaring Drop (Rik Reverb)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["464487"] = {
  --desc = "Sonic Blast (Rik Reverb)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["1214688"] = {
  --desc = "Pyrotechnics (Rik Reverb)";
  sound = 3;
};

GTFO.SpellID["472297"] = {
  --desc = "Sparkblast Ignition (Pyrotechnics)";
  sound = 3;
};

GTFO.SpellID["462797"] = {
  --desc = "Hit and Run (Road Pizza)";
  sound = 3;
};

GTFO.SpellID["470504"] = {
  --desc = "Dispense Bomblets (Goblin Sapper Bot)";
  sound = 3;
};

GTFO.SpellID["465611"] = {
  --desc = "Rolled! (Stix Bunkjunker)";
  sound = 3;
};

GTFO.SpellID["474406"] = {
  --desc = "Gear Grinder (Sprocketmonger Lockenstock)";
  sound = 3;
};

GTFO.SpellID["1217261"] = {
  --desc = "Screwed! (Sprocketmonger Lockenstock)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["473921"] = {
  --desc = "Lob Glob (Globlin)";
  sound = 3;
};

GTFO.SpellID["473958"] = {
  --desc = "Fire Laser (Flame Laser)";
  sound = 3;
};

GTFO.SpellID["467135"] = {
  --desc = "Trash Compactor (Stix Bunkjunker)";
  sound = 3;
  damageMinimum = 10000000;
};

GTFO.SpellID["466743"] = {
  --desc = "Dumpster Dive (Scrapmaster)";
  sound = 3;
};

GTFO.SpellID["463796"] = {
  --desc = "Concussion Charge (Darkfuse Gunner)";
  sound = 3;
};

GTFO.SpellID["1214267"] = {
  --desc = "Black Bloodsplatter (Sprocketmonger Lockenstock)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["1216661"] = {
  --desc = "Rocket Barrage (Rocket Launcher)";
  sound = 3;
};

GTFO.SpellID["465979"] = {
  --desc = "Scatter Shot (Darkfuse Skyfire)";
  sound = 3;
};

GTFO.SpellID["471308"] = {
  --desc = "Blisterizer Mk. II (Fire Trap)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["1216661"] = {
  --desc = "Rocket Barrage (Sprocketmonger Lockenstock)";
  sound = 3;
};

GTFO.SpellID["1219418"] = {
  --desc = "Brutal Club (Gallagio Security)";
  sound = 3;
};

GTFO.SpellID["473973"] = {
  --desc = "Card Shark (Gallagio Dealer)";
  sound = 3;
};

GTFO.SpellID["1214621"] = {
  --desc = "Pool Bomb";
  sound = 3;
};

GTFO.SpellID["1223999"] = {
  --desc = "Traveling Flames (One-Armed Bandit)";
  sound = 3;
};

GTFO.SpellID["460430"] = {
  --desc = "Crushed! (One-Armed Bandit)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["1218356"] = {
  --desc = "Crowd Divider (Melbo the Magnificent)";
  sound = 3;
};

GTFO.SpellID["1213696"] = {
  --desc = "Searing Slam (Princeguard Demolisher)";
  sound = 3;
};

GTFO.SpellID["466517"] = {
  --desc = "Stormfury Cloud (Mug'Zee)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["467225"] = {
  --desc = "Solid Gold (Mug'Zee)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["467201"] = {
  --desc = "Molten Gold Knuckles (Mug'Zee)";
  applicationOnly = true;
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["472659"] = {
  --desc = "Shakedown (Gallagio Goon)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["1218124"] = {
  --desc = "Incinerate (The Junkmaker)";
  sound = 3;
};

GTFO.SpellID["1218140"] = {
  --desc = "Junksaws (The Junkmaker)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["469326"] = {
  --desc = "Giga Blast (Chrome King Gallywix)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["1214226"] = {
  --desc = "Cratering (Chrome King Gallywix)";
  sound = 3;
  test = true; -- Distance check
};

GTFO.SpellID["465938"] = {
  --desc = "Big Bad Buncha Bombs (Chrome King Gallywix)";
  sound = 3;
};

GTFO.SpellID["466153"] = {
  --desc = "Bad Belated Boom (Chrome King Gallywix)";
  sound = 3;
};

GTFO.SpellID["467184"] = {
  --desc = "Suppression (Chrome King Gallywix)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["1223126"] = {
  --desc = "Party Crashing Rocket (Party Rocket)";
  sound = 3;
};

GTFO.SpellID["1214611"] = {
  --desc = "Bigger Badder Bomb Blast (Chrome King Gallywix)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["1215643"] = {
  --desc = "Door!";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["474180"] = {
  --desc = "Acid Rain (Darkfuse Wretch)";
  sound = 3;
};

GTFO.SpellID["1219528"] = {
  --desc = "Seek and Destroy (Crawler Mine)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["1214998"] = {
  --desc = "Vermincide (Bomb Tail)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["470695"] = {
  --desc = "Mech-a-Zoomies (Mechano Wolf)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["1218342"] = {
  --desc = "Unstable Shrapnel (Sprocketmonger Lockenstock)";
  affirmingDebuffSpellID = 1218342; -- Unstable Shrapnel
  sound = 3;
  test = true;
};

--- ********************
--- * Eco-Dome Al'dani *
--- ********************

GTFO.SpellID["1221174"] = {
  --desc = "Gorging Smash (Voracious Gorger)";
  sound = 3;
};

GTFO.SpellID["1217439"] = {
  --desc = "Toxic Regurgitation (Azhiccar)";
  applicationOnly = true;
  sound = 3;
  test = true; -- Avoidable?
};

GTFO.SpellID["1231224"] = {
  --desc = "Arcane Slash (Overcharged Sentinel)";
  sound = 3;
  tankSound = 0;
  applicationOnly = true;
};

GTFO.SpellID["1222356"] = {
  --desc = "Warp (Tamed Ruinstalker)";
  sound = 3;
};

GTFO.SpellID["1237199"] = {
  --desc = "Burrow Charge (Burrowing Creeper)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["1215850"] = {
  --desc = "Earthcrusher (Burrowing Creeper)";
  sound = 3;
};

GTFO.SpellID["1223008"] = {
  --desc = "Burrowing Eruption (Wastes Creeper)";
  sound = 3;
};

GTFO.SpellID["1236910"] = {
  --desc = "Eternal Weave (Soul-Scribe)";
  sound = 3;
};


--- *******************
--- * Manaforge Omega *
--- *******************

GTFO.SpellID["1245618"] = {
  --desc = "Mana Salvo (Influx Warden)";
  sound = 3;
};

GTFO.SpellID["1219223"] = {
  --desc = "Atomize (Arcanomatrix Atomizer)";
  sound = 3;
  damageMinimum = 2000000; -- Someone forgot to cloak
};

GTFO.SpellID["1218625"] = {
  --desc = "Displacement Matrix (Plexus Sentinel)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["1219471"] = {
  --desc = "Expulsion Zone (Expulsion Zone)";
  sound = 3;
};

GTFO.SpellID["1215904"] = {
  --desc = "Volatile Mana (Volatile Mana)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["1226877"] = {
  --desc = "Primal Spellstorm (Loom'ithar)";
  sound = 3;
};

GTFO.SpellID["1226394"] = {
  --desc = "Overinfusion Burst (Loom'ithar)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["1237307"] = {
  --desc = "Lair Weaving (Loom'ithar)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["1227140"] = {
  --desc = "Writhing Wave (Loom'ithar)";
  affirmingDebuffSpellID = 1227163; -- Writhing Wave, alert only when already debuffed
  sound = 3;
};

GTFO.SpellID["1227277"] = {
  --desc = "Soulfray Annihilation (Soulbinder Naazindhri)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["1226827"] = {
  --desc = "Soulrend Orb (Soulbinder Naazindhri)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["1223883"] = {
  --desc = "Eye Barrage (Watcher Gaz'Kreth)";
  sound = 3;
};

GTFO.SpellID["1225167"] = {
  --desc = "Anomalous Discharge (Unstable Mana)";
  sound = 3;
};

GTFO.SpellID["1234324"] = {
  applicationOnly = true;
  --desc = "Photon Blast (Arcane Collector)";
  sound = 3;
};

GTFO.SpellID["1225167"] = {
  --desc = "Anomalous Discharge (Unstable Mana)";
  sound = 3;
};

GTFO.SpellID["1237322"] = {
  --desc = "Prime Sequence (Arcane Collector)";
  sound = 3;
};

GTFO.SpellID["1224765"] = {
  --desc = "Arcane Flurries (Forge Sentinel)";
  sound = 3;
};

GTFO.SpellID["1228168"] = {
  --desc = "Silencing Tempest (Forgeweaver Araz)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["1250600"] = {
  --desc = "Void Lightning";
  sound = 3;
};

GTFO.SpellID["1227340"] = {
  --desc = "Infernal Strike (Ilyssa Darksorrow)";
  sound = 3;
};

GTFO.SpellID["1232130"] = {
  --desc = "Nexus Shrapnel (Fractillus)";
  sound = 3;
};

GTFO.SpellID["1238844"] = {
  --desc = "Echo Barrage (Enforcer Jak'tull)";
  sound = 3;
  ignoreApplication = true;
};

GTFO.SpellID["1232403"] = {
  --desc = "Dread Mortar (Manaforged Titan)";
  sound = 3;
};

GTFO.SpellID["1227897"] = {
  --desc = "Coalesce Voidwing (Nexus-King Salhadaar)";
  sound = 3;
};

GTFO.SpellID["1225645"] = {
  --desc = "Twilight Spikes (Nexus-King Salhadaar)";
  sound = 3;
};

GTFO.SpellID["1238763"] = {
  --desc = "Siphon Discharge (Crystalline Golem)";
  sound = 3;
};

GTFO.SpellID["1238369"] = {
  --desc = "Arcane Overload";
  sound = 3;
};

GTFO.SpellID["1238773"] = {
  --desc = "Extinction (Dimensius)";
  sound = 3;
};

GTFO.SpellID["1229325"] = {
  --desc = "Oblivion (Dimensius)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["1237080"] = {
  --desc = "Broken World (Dimensius)";
  sound = 3;
};

GTFO.SpellID["1239270"] = {
  --desc = "Voidwarding (Voidwarden)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["1233292"] = {
  --desc = "Accretion Disk (Dimensius)";
  sound = 3;
};

GTFO.SpellID["1234052"] = {
  --desc = "Darkened Sky (Dimensius)";
  sound = 3;
};

GTFO.SpellID["1243055"] = {
  --desc = "Fists of the Voidlord (Dimensius)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["1227665"] = {
  --desc = "Fists of the Voidlord (Dimensius)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["1243694"] = {
  --desc = "Shattered Space (Dimensius)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["1230674"] = {
  --desc = "Spaghettification (Dimensius)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["1234054"] = {
  --desc = "Shadowquake (Dimensius)";
  sound = 3;
  applicationOnly = true;
  minimumStacks = 1;
};

GTFO.SpellID["1234266"] = {
  --desc = "Cosmic Fragility (Dimensius)";
  applicationOnly = true;
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["1252456"] = {
  --desc = "Accretion Disk (Dimensius)";
  sound = 3;
};

GTFO.SpellID["1237695"] = {
  --desc = "Stardust Nova (Pargoth)";
  sound = 3;
};

GTFO.SpellID["1237694"] = {
  --desc = "Mass Ejection (Artoshion)";
  sound = 3;
};

GTFO.SpellID["1237098"] = {
  --desc = "Astrophysical Jet (Dimensius)";
  sound = 3;
};

GTFO.SpellID["1230999"] = {
	--desc = "Dark Matter (Dimensius)";
	soundFunction = function() -- Warn only if you get hit more than once
		if (GTFO_FindEvent("DMDarkMatter")) then
			return 3;
		end
		GTFO_AddEvent("DMDarkMatter", 2);
		return 0;
	end;
};



end

