--------------------------------------------------------------------------
-- GTFO_Fail_LGN.lua 
--------------------------------------------------------------------------
--[[
GTFO Fail List - Legion
]]--

if (GTFO.RetailMode) then

--- ********************
--- * The Broken Isles *
--- ********************

GTFO.SpellID["209862"] = {
  --desc = "Volcanic Plume (Mythic+ Keystone)";
  sound = 3;
};

GTFO.SpellID["225574"] = {
  --desc = "Trespasser!";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["225512"] = {
  --desc = "Trespasser!";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["203118"] = {
  --desc = "Edge of Twilight (Borgoth the Master Reaver)";
  sound = 3;
};

GTFO.SpellID["75902"] = {
  --desc = "Shadow Crash (Faceless Guardian)";
  sound = 3;
};

GTFO.SpellID["193059"] = {
  --desc = "The Jailer's Prison (Niskaran Executioner)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["182709"] = {
  --desc = "Depth Charge (Yorg Murkmouth)";
  sound = 3;
};

GTFO.SpellID["181535"] = {
  --desc = "Tide Crush (Sea Skrog)";
  sound = 3;
};

GTFO.SpellID["212096"] = {
  --desc = "Captive Tides (Athissa)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["217704"] = {
  --desc = "Extra Homework (Elya Azuremoon)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["184842"] = {
  --desc = "Plagued Spit (Forsaken Dreadwing)";
  sound = 3;
};

GTFO.SpellID["183155"] = {
  --desc = "Plagued Spit (Riding Bat)";
  sound = 3;
};

GTFO.SpellID["187406"] = {
  --desc = "Bull Rush (Thane Irglov the Merciless)";
  sound = 3;
};

GTFO.SpellID["182560"] = {
  --desc = "Squall";
  sound = 3;
  alwaysAlert = true;
};

GTFO.SpellID["187093"] = {
  --desc = "Lightning Strike (Bladesquall)";
  sound = 3;
};

GTFO.SpellID["200819"] = {
  --desc = "Chaos Bomb";
  sound = 3;
};

GTFO.SpellID["196808"] = {
  --desc = "Mo'arg Smash (Felsoul Berserker)";
  sound = 3;
};

GTFO.SpellID["194211"] = {
  --desc = "Fel Spikes (Fel Commander Igrius)";
  sound = 3;
};

GTFO.SpellID["210131"] = {
  --desc = "Trampling Charge (Mordvigbjorn)";
  sound = 3;
};

GTFO.SpellID["195464"] = {
  --desc = "Runic Prison (Rythas the Oracle)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["182877"] = {
  --desc = "Smash (Geir)";
  sound = 3;
};

GTFO.SpellID["205811"] = {
  --desc = "Felsoul Cleave (Huk'roth the Huntmaster)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["185495"] = {
  --desc = "Arcing Smash (Huk'roth the Huntmaster)";
  sound = 3;
};

GTFO.SpellID["185515"] = {
  --desc = "Demonic Leap (Huk'roth the Huntmaster)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["223165"] = {
  --desc = "Gift of Argus (Fel Annihilator)";
  sound = 3;
};

GTFO.SpellID["212742"] = {
  --desc = "Dark Charge (Gorebeak)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["213632"] = {
  --desc = "Star Shower (Lyrath Moonfeather)";
  sound = 3;
};

GTFO.SpellID["192998"] = {
  --desc = "Lightning Strike (Ysera)";
  sound = 3;
};

GTFO.SpellID["191530"] = {
  --desc = "Rock Lob (Hill Ettin)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["208724"] = {
  --desc = "Crushing Thrash (Arch-Desecrator Malithar)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["211901"] = {
  --desc = "Fusion Press (Mimiron)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["211488"] = {
  --desc = "Thundershot (Storm Cannon)";
  sound = 3;
};

GTFO.SpellID["221701"] = {
  --desc = "Ring of Frost (Eternal Groom)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["182832"] = {
  --desc = "Petrified (Stoneblood Elderwitch)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["189157"] = {
  --desc = "Death Wail (Theryssia)";
  sound = 3;
};

GTFO.SpellID["189187"] = {
  --desc = "Shadow Pounce (Darkshade)";
  sound = 3;
};

GTFO.SpellID["203323"] = {
  --desc = "Club Smash (Gornoth the Lost)";
  sound = 3;
};

GTFO.SpellID["213144"] = {
  --desc = "Squish 'Em (Gurbog da Basher)";
  sound = 3;
};

GTFO.SpellID["213208"] = {
  --desc = "Bash n Smash (Gurbog da Basher)";
  sound = 3;
};

GTFO.SpellID["188574"] = {
  --desc = "Explosive Blight (Forsaken Dreadwing)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["197499"] = {
  --desc = "Mana Surge (Ael'Yith)";
  sound = 3;
};

GTFO.SpellID["225358"] = {
  --desc = "Threatening Roar (Bahagar)";
  sound = 3;
};

GTFO.SpellID["216779"] = {
  --desc = "Energy Expulsion (Orbyth)";
  sound = 3;
};

GTFO.SpellID["183001"] = {
  --desc = "Massive Crush (Queen Kraklaa)";
  sound = 3;
};

GTFO.SpellID["199340"] = {
  --desc = "Bear Trap (Huntress Estrid)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["225258"] = {
  --desc = "Fel Eruption (Archimonde)";
  sound = 3;
};

GTFO.SpellID["222482"] = {
  --desc = "Sea Quake (Sea King Tidross)";
  sound = 3;
};

GTFO.SpellID["215741"] = {
  --desc = "Maul (Arru)";
  sound = 3;
};

GTFO.SpellID["225385"] = {
  --desc = "Spit Blood (Bahagar)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["202773"] = {
  --desc = "Stone Toss (Stonefist Brawler)";
	sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["214500"] = {
  --desc = "Hellfire and Brimstone (Vorthax)";
  sound = 3;
};

GTFO.SpellID["199823"] = {
  --desc = "Runic Lightning (Runic Wardstone)";
  sound = 3;
};

GTFO.SpellID["217553"] = {
  --desc = "Volatile Font";
  sound = 3;
};

GTFO.SpellID["222091"] = {
  --desc = "Steam Vent";
  sound = 3;
};

GTFO.SpellID["223708"] = {
  --desc = "Nightshifted Bolts (Withered J'im)";
  sound = 3;
};

GTFO.SpellID["204659"] = {
  --desc = "Bloodreap (Ariden)";
  sound = 3;
};

GTFO.SpellID["222528"] = {
  --desc = "Explosive Geyser (Torrentius)";
  sound = 3;
};

GTFO.SpellID["214302"] = {
  --desc = "Erupting Shadow (Thondrax)";
  sound = 3;
};

GTFO.SpellID["215806"] = {
  --desc = "Tail Lash (Shar'thos)";
  sound = 3;
};

GTFO.SpellID["229588"] = {
  --desc = "Triggered Explosion (Proximity Mine)";
  sound = 3;
};

GTFO.SpellID["231029"] = {
  --desc = "Freezing Strike (Thoramir)";
  sound = 3;
};

GTFO.SpellID["230329"] = {
  --desc = "Negative Energy";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["204042"] = {
  --desc = "Obliterate (Mo'arg Crusher)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["235085"] = {
  --desc = "Fel Bombardment";
  sound = 3;
};

GTFO.SpellID["237716"] = {
  --desc = "Fel Imp-losion (Fel Imp)";
  sound = 3;
};

GTFO.SpellID["238005"] = {
  --desc = "Cataclysmic Force Nova (Xeritas)";
  sound = 3;
};

GTFO.SpellID["233228"] = {
  --desc = "Scorching Swipe (Xeritas)";
  sound = 3;
};

GTFO.SpellID["239164"] = {
  --desc = "War Stomp (Fel Commander Erixtol)";
  sound = 3;
};

GTFO.SpellID["199036"] = {
  --desc = "Fel Meteor";
  sound = 3;
};

GTFO.SpellID["223425"] = {
  --desc = "Chaotic Felburst (Felbringer Xar'thok)";
  sound = 3;
};

GTFO.SpellID["234686"] = {
  --desc = "Dark Wave (Wrath-Lord Akrazar)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["234394"] = {
  --desc = "Rupture (Brutallus)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["233519"] = {
  --desc = "Crashing Embers (Brutallus)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["223435"] = {
  --desc = "Blazing Leap (Lord Vazuun)";
  sound = 3;
};

GTFO.SpellID["220324"] = {
  --desc = "Fel Energy Barrier";
  sound = 3;
};

GTFO.SpellID["241523"] = {
  --desc = "Felfire Boulder";
  sound = 3;
};

GTFO.SpellID["242880"] = {
  --desc = "Agatha's Fury (Agatha)";
  sound = 3;
};

GTFO.SpellID["241666"] = {
  --desc = "Fel Rupture (Tugar Bloodtotem)";
  sound = 3;
};

GTFO.SpellID["241719"] = {
  --desc = "Jormog's Fury (Jormog the Behemoth)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["242472"] = {
  --desc = "Spit Bile (Bile Spitter)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["238027"] = {
  --desc = "Stalactite (Tugar Bloodtotem)";
  sound = 3;
};

GTFO.SpellID["286002"] = {
  --desc = "Explode (Bomb Bot)";
  sound = 3;
  vehicle = true;
};

-- *******************
-- * Brawler's Guild *
-- *******************

GTFO.SpellID["229420"] = {
  --desc = "Devour (Hippo)";
  sound = 3;
};

GTFO.SpellID["229926"] = {
  --desc = "Path of Despair";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["228988"] = {
  --desc = "Burning Ground";
  sound = 3;
};

GTFO.SpellID["229126"] = {
  --desc = "Peck (Slippy)";
  sound = 3;
};

-- **********
-- * Mardum *
-- **********

GTFO.SpellID["193507"] = {
	--desc = "Fel Bombardment (Legion Command Center)";
	sound = 3;
};

GTFO.SpellID["192142"] = {
	--desc = "Infernal Smash (Colossal Infernal)";
	sound = 3;
};

GTFO.SpellID["191667"] = {
	--desc = "Devastator Bombardment (Legion Devastator)";
	sound = 3;
};

GTFO.SpellID["197750"] = {
	--desc = "Fel Breath (General Volroth)";
	sound = 3;
};

GTFO.SpellID["197222"] = {
  --desc = "Fel Explosion (Prolifica)";
  sound = 3;
};

GTFO.SpellID["197599"] = {
  --desc = "Chaos Slam (Kor'vas Bloodthorn)";
  sound = 3;
};

GTFO.SpellID["247673"] = {
  --desc = "Molten Crash (Charredbone Goliath)";
  sound = 3;
};

GTFO.SpellID["246942"] = {
  --desc = "Carrion Swarm (Zorathides)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["248642"] = {
  --desc = "Dark Eruption (Thalas Vylethorn)";
  sound = 3;
};

GTFO.SpellID["247378"] = {
  --desc = "Static Blast (Roobi Skizzelvolt)";
  sound = 3;
};

GTFO.SpellID["52080"] = {
  --desc = "Bone Crack (Bonesunder)";
  sound = 3;
};

GTFO.SpellID["248716"] = {
  --desc = "Infernal Strike (Zorathides)";
  sound = 3;
};

GTFO.SpellID["247186"] = {
  --desc = "Brutish Charge (Bloodfeast)";
  sound = 3;
};

GTFO.SpellID["202323"] = {
  --desc = "Goliath's Bane (Sigurd the Giantslayer)";
  sound = 3;
};

GTFO.SpellID["197362"] = {
  --desc = "Wandering Keg (Chen Stormstout)";
  sound = 3;
};

-- ********************
-- * The Broken Shore *
-- ********************

GTFO.SpellID["218620"] = {
  --desc = "Fel Smash (Fel Lord Razzar)";
  sound = 3;
};

GTFO.SpellID["218621"] = {
  --desc = "Fel Eruption (Fel Lord Kurrz)";
  sound = 3;
};

GTFO.SpellID["224907"] = {
  --desc = "Fel Crack (Fel Commander Azgalor)";
  sound = 3;
};

GTFO.SpellID["185597"] = {
  --desc = "Hellfire Cannons (Command Ship)";
  sound = 3;
};

GTFO.SpellID["218683"] = {
  --desc = "Felspike Eruption (Mo'arg Painbringer)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["217017"] = {
  --desc = "Slumber (Slumber Fog)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["183499"] = {
  --desc = "Orb of Destruction (Krosus)";
  sound = 3;
};

GTFO.SpellID["221090"] = {
  --desc = "Fel Beam (Krosus)";
  sound = 3;
};

GTFO.SpellID["184044"] = {
  --desc = "Summon Felblaze Infernal (Dread Commander Arganoth)";
  sound = 3;
};

GTFO.SpellID["200465"] = {
  --desc = "Fel Crack (Dread Commander Arganoth)";
  sound = 3;
};

GTFO.SpellID["181559"] = {
  --desc = "Gaze of Sargeras (Gul'dan)";
  sound = 3;
};

GTFO.SpellID["199062"] = {
  --desc = "Shatter (Fel Spike)";
  sound = 3;
};


-- ************************
-- * Vault of the Wardens *
-- ************************

GTFO.SpellID["199645"] = {
  --desc = "Face Kick (Crusher)";
  sound = 3;
};

GTFO.SpellID["192519"] = {
  --desc = "Lava (Ash'golm)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["214893"] = {
  --desc = "Pulse (Glazer)";
  sound = 3;
};

GTFO.SpellID["199828"] = {
  --desc = "Chaos Nova (Immolanth)";
  sound = 3;
};

GTFO.SpellID["199773"] = {
  --desc = "Burning Fel (Immolanth)";
  sound = 3;
};

GTFO.SpellID["201041"] = {
  --desc = "Madness (Inquisitor)";
  sound = 3;
};


-- ********************
-- * The Broken Shore *
-- ********************

GTFO.SpellID["205706"] = {
  --desc = "Haunted Shadows (Subjugator Valith)";
  sound = 3;
};

GTFO.SpellID["215732"] = {
  --desc = "Shadow Trap (Eredar Shadow-Trapper)";
  sound = 3;
};

GTFO.SpellID["215701"] = {
  --desc = "Impending Doom (Doomherald Ak'vesh)";
  sound = 3;
};

GTFO.SpellID["215925"] = {
  --desc = "Fel Cleave (Gorgonnash)";
  sound = 3;
};



-- *******************
-- * The Violet Hold *
-- *******************

GTFO.SpellID["205101"] = {
  --desc = "Soul Eruption (Eredar Shadow Mender)";
  sound = 3;
};

GTFO.SpellID["204498"] = {
  --desc = "Soul Explosion (Portal Guardian)";
  sound = 3;
};

GTFO.SpellID["202037"] = {
  --desc = "Frozen (Shivermaw)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["201355"] = {
  --desc = "Wing Buffet (Shivermaw)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["201852"] = {
  --desc = "Relentless Storm (Shivermaw)";
  sound = 3;
};

GTFO.SpellID["201598"] = {
  --desc = "Congealing Vomit (Festerface)";
  sound = 3;
};

GTFO.SpellID["202364"] = {
  --desc = "Execution (Fel Lord Betrug)";
  sound = 1;
};

-- *********************
-- * Darkheart Thicket *
-- *********************

GTFO.SpellID["204402"] = {
  --desc = "Star Shower (Dreadsoul Ruiner)";
  sound = 3;
};

GTFO.SpellID["201123"] = {
  --desc = "Root Burst (Vilethorn Blossom)";
  sound = 3;
};

GTFO.SpellID["199063"] = {
  --desc = "Strangling Roots (Oakheart)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["201273"] = {
  --desc = "Blood Bomb (Bloodtainted Fury)";
  sound = 3;
};

GTFO.SpellID["200111"] = {
  --desc = "Apocalyptic Fire (Shade of Xavius)";
  sound = 3;
};

GTFO.SpellID["198916"] = {
  --desc = "Vile Burst (Vile Mushroom)";
  sound = 3;
};

GTFO.SpellID["198386"] = {
  --desc = "Primal Rampage (Archdruid Glaidalis)";
  sound = 3;
};


-- ******************
-- * Eye of Azshara *
-- ******************

GTFO.SpellID["195217"] = {
  --desc = "Aqua Spout (Hatecoil Arcanist)";
  sound = 3;
};


GTFO.SpellID["193597"] = {
  --desc = "Static Nova (Lady Hatecoil)";
  sound = 3;
};

GTFO.SpellID["196610"] = {
  --desc = "Monsoon (Lady Hatecoil)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["191847"] = {
  --desc = "Poison Spit (Serpentrix)";
  sound = 3;
};

GTFO.SpellID["196299"] = {
  --desc = "Roiling Storm (Stormwake Hydra)";
  sound = 3;
};

GTFO.SpellID["196294"] = {
  --desc = "Chaotic Tempest (Stormwake Hydra)";
  sound = 3;
};

GTFO.SpellID["196293"] = {
  --desc = "Chaotic Tempest (Stormwake Hydra)";
  sound = 3;
};

GTFO.SpellID["193088"] = {
  --desc = "Ground Slam (King Deepbeard)";
  sound = 3;
};

GTFO.SpellID["192794"] = {
  --desc = "Lightning Strike (Wrath of Azshara)";
  sound = 3;
};

GTFO.SpellID["192675"] = {
  --desc = "Mystic Tornado (Wrath of Azshara)";
  sound = 3;
};

GTFO.SpellID["192619"] = {
  --desc = "Massive Deluge (Wrath of Azshara)";
  sound = 3;
};

GTFO.SpellID["192801"] = {
  --desc = "Tidal Wave (Wrath of Azshara)";
  sound = 3;
};

GTFO.SpellID["192708"] = {
  --desc = "Arcane Bomb (Wrath of Azshara)";
  sound = 3;
};

-- *********************
-- * Neltharion's Lair *
-- *********************

GTFO.SpellID["188169"] = {
  --desc = "Razor Shards (Rokmora)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["202089"] = {
  --desc = "Scorch (Burning Geode)";
  sound = 3;
};

GTFO.SpellID["200338"] = {
  --desc = "Crystal Wall (Dargrul)";
  sound = 3;
};

GTFO.SpellID["198475"] = {
  --desc = "Strike of the Mountain (Ularogg Cragshaper)";
  sound = 3;
};

GTFO.SpellID["226406"] = {
  --desc = "Ember Swipe (Emberhusk Dominator)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["183100"] = {
  --desc = "Avalanche (Mightstone Breaker)";
  sound = 3;
};

GTFO.SpellID["226296"] = {
  --desc = "Piercing Shards (Vileshard Hulk)";
  applicationOnly = true;
  sound = 3;
  tankSound = 0;
};


-- *************
-- * The Nexus *
-- *************

GTFO.SpellID["209852"] = {
  --desc = "Arcane Orb (Scion of Magic)";
  sound = 3;
};

GTFO.SpellID["206750"] = {
  --desc = "Breaching Flames (nil)";
  sound = 3;
};

GTFO.SpellID["209871"] = {
  --desc = "Gravity Bomb (Nexus-Prince Bilaal)";
  sound = 3;
};

GTFO.SpellID["209867"] = {
  --desc = "Crosswind";
  sound = 3;
};

-- ******************
-- * Halls of Valor *
-- ******************

GTFO.SpellID["198605"] = {
  --desc = "Thunderstrike (Valarjar Thundercaller)";
  sound = 3;
  negatingDebuffSpellID = 198599; 
  negatingIgnoreTime = 1;
};

GTFO.SpellID["198412"] = {
  --desc = "Feedback (Odyn)";
  sound = 3;
};

GTFO.SpellID["193260"] = {
  --desc = "Static Field (Hymdall)";
  sound = 3;
};

GTFO.SpellID["192206"] = {
  --desc = "Sanctify (Olmyr the Enlightened)";
  sound = 3;
};

GTFO.SpellID["198088"] = {
  --desc = "Glowing Fragment (Odyn)";
  applicationOnly = true;
  sound = 3;
};

-- **************
-- * The Arcway *
-- **************

-- TODO: Volatile Magic (Ivanyr) FF fail Alert?
-- TODO: Cleansing Force (Corstilax) - Fail on explosion
-- TODO: Shadow Slash (General Xakal) 
-- TODO: Force Bomb (Advisor Vandros)
-- TODO: Time Split (Advisor Vandros) - shard explosion

GTFO.SpellID["197788"] = {
  --desc = "Bombardment (General Xakal)";
  sound = 3;
};

GTFO.SpellID["197579"] = {
  --desc = "Fel Eruption (General Xakal)";
  sound = 3;
};


-- ****************
-- * Maw of Souls *
-- ****************

-- TODO: Arise, Fallen (Ymiron)

GTFO.SpellID["195038"] = {
  --desc = "Defiant Strike - Final hit (Seacursed Soulkeeper)";
  sound = 3;
};

GTFO.SpellID["193513"] = {
  --desc = "Bane (Ymiron, the Fallen King)";
  sound = 3;
};

GTFO.SpellID["193364"] = {
  --desc = "Screams of the Dead (Ymiron, the Fallen King)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["194099"] = {
  --desc = "Bile Breath (The Grimewalker)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["194218"] = {
  --desc = "Cosmic Scythe (Harbaron)";
  sound = 3;
};

GTFO.SpellID["197117"] = {
  --desc = "Piercing Tentacle (Helya)";
  sound = 3;
};

GTFO.SpellID["195309"] = {
  --desc = "Swirling Water (Helya)";
  sound = 3;
};

GTFO.SpellID["197858"] = {
  --desc = "Turbulent Waters (Helya)";
  sound = 3;
};

GTFO.SpellID["202472"] = {
  --desc = "Tainted Essence (Helya)";
  sound = 3;
};

-- ******************
-- * Court of Stars *
-- ******************

-- TODO: Blade Surge (Advisor Melandrus) - Fail when hit more than once

GTFO.SpellID["209027"] = {
  --desc = "Quelling Strike (Duskwatch Guard)";
  sound = 3;
};

GTFO.SpellID["209477"] = {
  --desc = "Wild Detonation (Mana Wyrm)";
  sound = 3;
};

GTFO.SpellID["209404"] = {
  --desc = "Seal Magic (Duskwatch Arcanist)";
  sound = 3;
};

GTFO.SpellID["206574"] = {
  --desc = "Resonant Slash (Patrol Captain Gerdo)";
  sound = 3;
};

GTFO.SpellID["219498"] = {
  --desc = "Streetsweeper (Patrol Captain Gerdo)";
  sound = 3;
};

GTFO.SpellID["224333"] = {
  --desc = "Fel Detonation (Felbound Enforcer)";
  applicationOnly = true;
  sound = 3;
  tankSound = 0;
  test = true;
};

GTFO.SpellID["209378"] = {
  --desc = "Whirling Blades (Imacu'tya)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["207979"] = {
  --desc = "Shockwave (Jazshariu)";
  sound = 3;
};

GTFO.SpellID["207887"] = {
  --desc = "Infernal Eruption (Talixae Flamewreath)";
  sound = 3;
};

GTFO.SpellID["211457"] = {
  --desc = "Infernal Eruption (Talixae Flamewreath)";
  sound = 3;
};

GTFO.SpellID["224333"] = {
  --desc = "Enveloping Winds (Advisor Melandrus)";
  sound = 3;
};

GTFO.SpellID["209630"] = {
  --desc = "Piercing Gale (Advisor Melandrus)";
  sound = 3;
};

GTFO.SpellID["209628"] = {
  --desc = "Piercing Gale (Advisor Melandrus)";
  sound = 3;
};



-- ************************
-- * Vault of the Wardens *
-- ************************

-- TODO: Fel Chain (Tirathon Saltheril)
-- TODO: Corrupted Touch (Lingering Corruption) - FF fail
-- TODO: Fissure (Ash'golm)
-- TODO: Volcano (Ash'golm)
-- TODO: Pulse (Glazer)
-- TODO: Detonating Moonglaive (Cordana Felsong)

GTFO.SpellID["193610"] = {
  --desc = "Fel Detonation (Glayvianna Soulrender)";
  sound = 3;
};

GTFO.SpellID["191684"] = {
  --desc = "Burning Pitch (Viletongue Belcher)";
  sound = 3;
};

GTFO.SpellID["194037"] = {
  --desc = "Mortar (Foul Mother)";
  sound = 3;
};

GTFO.SpellID["199918"] = {
  --desc = "Shadow Crash (Faceless Voidcaster)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["200202"] = {
  --desc = "Chilled to the Bone (Ash'golm)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["193969"] = {
  --desc = "Razors (Aranasi Broodmother)";
  applicationOnly = true;
  sound = 3;
  test = true;
};

GTFO.SpellID["197334"] = {
  --desc = "Fel Glaive (Cordana Felsong)";
  sound = 3;
};

-- *******************
-- * Black Rook Hold *
-- *******************

GTFO.SpellID["196517"] = {
  --desc = "Swirling Scythe (Amalgam of Souls)";
  sound = 3;
};

GTFO.SpellID["194956"] = {
  --desc = "Reap Soul (Amalgam of Souls)";
  sound = 3;
};

GTFO.SpellID["194960"] = {
  --desc = "Soul Echoes (Amalgam of Souls)";
  sound = 3;
};

GTFO.SpellID["200256"] = {
  --desc = "Phased Explosion (Arcane Minion)";
  sound = 3;
};

GTFO.SpellID["200261"] = {
  --desc = "Bonebreaking Strike (Soul-Torn Champion)";
  sound = 3;
};

GTFO.SpellID["197974"] = {
  --desc = "Bonecrushing Strike (Soul-Torn Vanguard)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["222397"] = {
  --desc = "Boulder Crush";
  sound = 3;
};

GTFO.SpellID["222417"] = {
  --desc = "Boulder Crush";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["214002"] = {
  --desc = "Raven's Dive (Risen Lancer)";
  sound = 3;
};

GTFO.SpellID["199567"] = {
  --desc = "Dark Obliteration (Latosius)";
  sound = 3;
};

GTFO.SpellID["198820"] = {
  --desc = "Dark Blast (Latosius)";
  sound = 3;
};

GTFO.SpellID["199097"] = {
  --desc = "Cloud of Hypnosis (Latosius)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["221688"] = {
  --desc = "Overwhelming Detonation (Braxas the Fleshcarver)";
  sound = 3;
};

GTFO.SpellID["224188"] = {
  --desc = "Hateful Charge (Smashspite the Hateful)";
  applicationOnly = true;
  sound = 3;
  minimumStacks = 1;
};

GTFO.SpellID["221838"] = {
  --desc = "Disorienting Gas (Kelorn Nightblade)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["198781"] = {
  --desc = "Whirling Blade (Kur'talos Ravencrest)";
  sound = 3;
};

GTFO.SpellID["200914"] = {
  --desc = "Indigestion (Wyrmtongue Scavenger)";
  sound = 3;
  tankSound = 0;
}


-- *************************
-- * The Emerald Nightmare *
-- *************************


GTFO.SpellID["221029"] = {
  --desc = "Unstable Decay";
  sound = 4;
  test = true; -- FF?  Negating?
};

GTFO.SpellID["214348"] = {
  --desc = "Vile Ambush (Elerethe Renferal)";
  sound = 0;
  test = true; -- possible damage threshold
};

GTFO.SpellID["212853"] = {
  --desc = "Razor Wing (Elerethe Renferal)";
  sound = 3;
};

GTFO.SpellID["210850"] = {
  --desc = "Twisting Shadows (Elerethe Renferal)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["210850"] = {
  --desc = "Twisting Shadows (Elerethe Renferal)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["213790"] = {
  --desc = "Venomous Pool (Elerethe Renferal)";
  sound = 3;
};

GTFO.SpellID["215503"] = {
  --desc = "Violent Rupture (Elerethe Renferal)";
  sound = 3;
};

GTFO.SpellID["225329"] = {
  --desc = "Drake's Wrath (Drake's Fury)";
  sound = 3;
};

GTFO.SpellID["210781"] = {
  --desc = "Dark Reconstitution (Il'gynoth)";
  sound = 3;
};

GTFO.SpellID["209471"] = {
  --desc = "Nightmare Explosion (Nightmare Ichor - Il'gynoth)";
  sound = 3;
  negatingDebuffSpellID = 209471; -- Nightmare Explosion
};

GTFO.SpellID["215143"] = {
  --desc = "Cursed Blood (Il'gynoth)";
  sound = 4;
  negatingDebuffSpellID = 215128; -- Cursed Blood
  negatingIgnoreTime = 1;
  ignoreSelfInflicted = true;
};

GTFO.SpellID["210984"] = {
  --desc = "Eye of Fate (Nightmare Horror - Il'gynoth)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["223029"] = {
  --desc = "Wretched Ambush (Nightmother)";
  sound = 3;
  test = true; -- possible damage threshold
};

GTFO.SpellID["210315"] = {
  --desc = "Nightmare Brambles (Cenarius)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["222043"] = {
  --desc = "Crushing Darkness (Creature in the Shadows)";
  sound = 3;
};

GTFO.SpellID["205595"] = {
  --desc = "Tormenting Swipe (Corruption Horror)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["207859"] = {
  --desc = "Darkened Discharge (Xavius)";
  sound = 3;
  negatingDebuffSpellID = 206651;
  negatingIgnoreTime = 1;
  tankSound = 0;
};

GTFO.SpellID["225249"] = {
  --desc = "Devastating Stomp (Deathroot Ancient)";
  applicationOnly = true;
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["225296"] = {
  --desc = "Rotting Grasp (Deathroot Ancient)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["198108"] = {
  --desc = "Momentum (Ursoc)";
  applicationOnly = true;
  minimumStacks = 1;
  sound = 3;
};

GTFO.SpellID["225356"] = {
  --desc = "Seeping Fog (Seeping Fog)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["205870"] = {
  --desc = "Gloom (Lethon)";
  sound = 3;
};

GTFO.SpellID["223201"] = {
  --desc = "Gloom (Rothos)";
  sound = 3;
};

GTFO.SpellID["203028"] = {
  --desc = "Corrupted Breath (Ysondre)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["204767"] = {
  --desc = "Corrupted Breath (Shade of Taerar)";
  sound = 3;
  tankSound = 0;
};


GTFO.SpellID["203110"] = {
  --desc = "Slumbering Nightmare (Ysondre)";
  applicationOnly = true;
  sound = 3;
};


-- *************
-- * Nighthold *
-- *************

-- TODO: Volatile Resonance (Skorpyron)
-- TODO: Arcane Slash (Trilliax) -- non-tank fail
-- TODO: Burning Soul (Tichondrius) -- FF Fail
-- TODO: Felburst (Krosus)
-- TODO: Toxic Spores (High Botanist Tel'arn)
-- TODO: Shatter (Star Augur Etaeus) -- FF fail
-- TODO: Fel Ember (Star Augur Etaeus)
-- TODO: World-Devouring Force (Star Augur Etaeus)
-- TODO: Delphuric Beam (Grand Magistrix Elisande)
-- TODO: Epocheric Orb (Grand Magistrix Elisande) -- when debuffed with Epocheric Vulnerability

GTFO.SpellID["204483"] = {
  --desc = "Focused Blast (Skorpyron)";
  sound = 3;
};

GTFO.SpellID["204275"] = {
  --desc = "Arcanoslash (Skorpyron)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["221153"] = {
  --desc = "Beam (Pulsauron)";
  sound = 3;
};

GTFO.SpellID["230438"] = {
  --desc = "Devastating Strike (Torm the Brute)";
  sound = 3;
};

GTFO.SpellID["221164"] = {
  --desc = "Fulminate (Fulminant)";
  sound = 3;
};

GTFO.SpellID["206612"] = {
  --desc = "Burst of Time (Chronomatic Anomaly)";
  sound = 3;
};

GTFO.SpellID["206792"] = {
  --desc = "Toxic Slice (Trilliax)";
  sound = 3;
};

GTFO.SpellID["207631"] = {
  --desc = "Annihilation (Trilliax)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["224510"] = {
  --desc = "Crackling Slice (Duskwatch Battle-Magus)";
  sound = 3;
  tankSound = 0;
  test = true;
};

GTFO.SpellID["213621"] = {
  --desc = "Entombed in Ice (Spellblade Aluriel)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["205391"] = {
  --desc = "Fel Beam (Krosus)";
  sound = 3;
};

GTFO.SpellID["205863"] = {
  --desc = "Slam (Krosus)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["215988"] = {
  --desc = "Carrion Nightmare (Carrion Nightmare)";
  sound = 3;
};

GTFO.SpellID["206474"] = {
  --desc = "Seeker Swarm (Tichondrius)";
  sound = 3;
  negatingDebuffSpellID = 206480; -- Carrion Plague 
  test = true; -- Not working because plague is getting applied first
};

GTFO.SpellID["218155"] = {
  --desc = "Solar Collapse (High Botanist Tel'arn)";
  sound = 3;
};

GTFO.SpellID["219235"] = {
  --desc = "Toxic Spores (Naturalist Tel'arn)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["225807"] = {
  --desc = "Pillars of Night (Duskwatch Weaver)";
  sound = 3;
};

GTFO.SpellID["219950"] = {
  --desc = "Controlled Chaos (High Botanist Tel'arn)";
  sound = 0;
  test = true; -- DPS amount check
};

GTFO.SpellID["224484"] = {
  --desc = "Falling Star";
  sound = 3;
};

GTFO.SpellID["207720"] = {
  --desc = "Witness the Void (Thing That Should Not Be)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["221490"] = {
  --desc = "Starfall (Astral Farseer)";
  sound = 3;
};

GTFO.SpellID["206603"] = {
  --desc = "Frozen Solid (Star Augur Etraeus)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["206577"] = {
  --desc = "Comet Impact (Star Augur Etraeus)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["206433"] = {
  --desc = "Fel Impact (Star Augur Etraeus)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["207813"] = {
  --desc = "Void Impact (Star Augur Etraeus)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["208865"] = {
  --desc = "Leave the Nightwell (Elisande)";
  sound = 3;
};

GTFO.SpellID["231005"] = {
  --desc = "Arcane Emanations (Kar'zun)";
  sound = 3;
};

GTFO.SpellID["212262"] = {
  --desc = "Hand of Gul'dan (Gul'dan)";
  sound = 3;
};

GTFO.SpellID["167819"] = {
  --desc = "Storm of the Destroyer (Gul'dan)";
  sound = 3;
};

GTFO.SpellID["167935"] = {
  --desc = "Storm of the Destroyer (Gul'dan)";
  sound = 3;
};

GTFO.SpellID["177380"] = {
  --desc = "Storm of the Destroyer (Gul'dan)";
  sound = 3;
};

GTFO.SpellID["152987"] = {
  --desc = "Storm of the Destroyer (Gul'dan)";
  sound = 3;
};

GTFO.SpellID["224440"] = {
  --desc = "Crushing Stomp (Gilded Guardian)";
  sound = 3;
};

GTFO.SpellID["231006"] = {
  --desc = "Carve (Flightmaster Volnath)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["229948"] = {
  --desc = "Fel Obelisk (Gul'dan)";
  sound = 3;
};

GTFO.SpellID["208546"] = {
  --desc = "Anguished Spirits (Gul'dan)";
  sound = 3;
};

--- ******************
--- * Trial of Valor *
--- ******************

GTFO.SpellID["228874"] = {
  --desc = "Horn of Valor (Odyn)";
  sound = 4;
  ignoreSelfInflicted = true;
};

GTFO.SpellID["227781"] = {
  --desc = "Glowing Fragment (Odyn)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["227712"] = {
  --desc = "Spear of Light (Odyn)";
  sound = 3;
};

GTFO.SpellID["227811"] = {
  --desc = "Raging Tempest (Odyn)";
  sound = 3;
};

GTFO.SpellID["227843"] = {
  --desc = "Trample (Guarm)";
  sound = 3;
};

GTFO.SpellID["227514"] = {
  --desc = "Flashing Fangs (Guarm)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["227642"] = {
  --desc = "Multi-Headed (Guarm)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["227735"] = {
  --desc = "Mixed Elements (Guarm)";
  sound = 3;
};

GTFO.SpellID["227721"] = {
  --desc = "Mixed Elements (Guarm)";
  sound = 3;
};

GTFO.SpellID["227720"] = {
  --desc = "Mixed Elements (Guarm)";
  sound = 3;
};

GTFO.SpellID["228051"] = {
  --desc = "Tainted Essence (Helya)";
  sound = 3;
};

GTFO.SpellID["228631"] = {
  --desc = "Give No Quarter (Night Watch Mariner)";
  sound = 3;
};

GTFO.SpellID["228390"] = {
  --desc = "Sludge Nova (Grimelord)";
  sound = 3;
};

GTFO.SpellID["228519"] = {
  --desc = "Anchor Slam (Grimelord)";
  sound = 3;
  tankSound = 0;
};

-- TODO: Expel Light (Odyn)
-- TODO: Storm of Justice (Odyn)
-- TODO: Unerring Blast (Odyn) - Mythic, without Protected debuff
-- TODO: Echo of Radiance (Odyn) - Mythic, wrong rune combo
-- TODO: Flame Lick (Guarm) -- If not original target
-- TODO: Frost Lick (Guarm) -- If not original target
-- TODO: Shadow Lick (Guarm) -- If not original target
-- TODO: Corrupted Slicer (Helya) -- Mythic
-- TODO: Bilewater Breath (Helya) -- Non-tank fail
-- TODO: Turbulent Waters/Orbs of Muck (Helya) -- Mythic
-- TODO: Fetid Rot (Helya) -- Dispel fail
-- TODO: Anchor Slam (Helya) -- Non-tank/swap fail?
-- TODO: Corrosive Slicer (Helya) -- Mythic


--- **********************
--- * Return to Karazhan *
--- **********************

-- TODO: Thunder Ritual (Mrrgria) -- If you're not the target
-- TODO: Wash Away (Mrrgria)
-- TODO: Bubble Blast (Shoreline Tidespeaker)
-- TODO: Severe Dusting (Babblet)
-- TODO: Will Breaker (Lord Crispin Ference) -- Non-tank fail
-- TODO: Flame Wreath (Shade of Medivh) -- (If you cause it)
-- TODO: Shadow Phlegm (Viz'aduum the Watcher) -- Avoidable?

GTFO.SpellID["227568"] = {
  --desc = "Burning Leg Sweep (Toe Knee)";
  sound = 3;
};

GTFO.SpellID["227416"] = {
  --desc = "Wondrous Radiance (Galindre)";
  sound = 3;
};

GTFO.SpellID["227776"] = {
  --desc = "Magic Magnificent (Galindre)";
  sound = 3;
};

GTFO.SpellID["227917"] = {
  --desc = "Poetry Slam (Ghostly Understudy)";
  sound = 3;
};

GTFO.SpellID["227925"] = {
  --desc = "Final Curtain (Ghostly Understudy)";
  sound = 3;
};

GTFO.SpellID["227977"] = {
  --desc = "Flashlight (Skeletal Usher)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["227493"] = {
  --desc = "Mortal Strike (Attumen the Huntsman)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["227339"] = {
  --desc = "Mezair - Fire (Midnight)";
  sound = 3;
};

GTFO.SpellID["254644"] = {
  --desc = "Mezair - Physical (Midnight)";
  sound = 3;
};

GTFO.SpellID["227645"] = {
  --desc = "Spectral Charge (Midnight)";
  sound = 3;
};

GTFO.SpellID["228603"] = {
  --desc = "Charge (Spectral Charger)";
  sound = 3;
};

GTFO.SpellID["227532"] = {
  --desc = "Unstable Energy (Damaged Golem)";
  sound = 3;
};

GTFO.SpellID["230044"] = {
  --desc = "Cleave (Wrathguard Flamebringer)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["229988"] = {
  --desc = "Burning Tile (Burning Tiles)";
  sound = 3;
};

GTFO.SpellID["229597"] = {
  --desc = "Fel Mortar (Fel Bat)";
  sound = 3;
};

GTFO.SpellID["229696"] = {
  --desc = "Stampede (Rat)";
  sound = 3;
};

GTFO.SpellID["227620"] = {
  --desc = "Arcane Bomb (Mana Devourer)";
  sound = 3;
};

GTFO.SpellID["229384"] = {
  --desc = "Queen Move (Queen)";
  sound = 3;
};

GTFO.SpellID["229563"] = {
  --desc = "Knight  Move (Knight)";
  sound = 3;
};

GTFO.SpellID["229427"] = {
  --desc = "Royal Slash (King)";
  sound = 3;
};

GTFO.SpellID["229545"] = {
  --desc = "Bishop Move (Bishop)";
  sound = 3;
};

GTFO.SpellID["229559"] = {
  --desc = "Bishop Move (Bishop)";
  sound = 3;
};

GTFO.SpellID["229285"] = {
  --desc = "Bombardment (Viz'aduum the Watcher)";
  sound = 3;
};

GTFO.SpellID["229161"] = {
  --desc = "Explosive Shadows (Viz'aduum the Watcher)";
  sound = 3;
};

GTFO.SpellID["229151"] = {
  --desc = "Disintegrate (Viz'aduum the Watcher)";
  sound = 3;
};

GTFO.SpellID["227434"] = {
  --desc = "Bubble Blast (Shoreline Tidespeaker)";
  sound = 3;
};

GTFO.SpellID["227799"] = {
  --desc = "Wash Away (Mrrgria)";
  sound = 3;
};

GTFO.SpellID["227780"] = {
  --desc = "Thunder Ritual (Mrrgria)";
	soundFunction = function() -- Warn only if you get hit more than once
		if (GTFO_FindEvent("ThunderRitual")) then
			return 3;
		end
		GTFO_AddEvent("ThunderRitual", 2);
		return 0;
	end
};

-- **************************
-- * Cathedral of the Night *
-- **************************

GTFO.SpellID["239558"] = {
  --desc = "Shadow Swipe (Dreadwing)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["237599"] = {
  --desc = "Devastating Swipe (Helblaze Felbringer)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["239201"] = {
  --desc = "Fel Glare (Gazerax)";
  sound = 3;
};

GTFO.SpellID["239217"] = {
  --desc = "Blinding Glare (Gazerax)";
  sound = 3;
};

GTFO.SpellID["237276"] = {
  --desc = "Pulverizing Cudgel (Thrashbite the Scornful)";
  sound = 3;
  damageMinimum = 1500000;
};

GTFO.SpellID["238469"] = {
  --desc = "Scornful Charge (Thrashbite the Scornful)";
  sound = 3;
};

GTFO.SpellID["236543"] = {
  --desc = "Felsoul Cleave (Domatrax)";
  sound = 3;
};

GTFO.SpellID["243152"] = {
  --desc = "Demonic Upheaval (Mephistroth)";
  sound = 3;
  test = true;
};

GTFO.SpellID["238583"] = {
  --desc = "Devour Magic (Felblight Stalker)";
  applicationOnly = true;
  sound = 3;
};

-- ********************
-- * Tomb of Sargeras *
-- ********************

GTFO.SpellID["242909"] = {
  --desc = "Massive Eruption (Infernal Chaosbringer)";
  sound = 3;
};

GTFO.SpellID["234264"] = {
  --desc = "Melted Armor (Goroth)";
  applicationOnly = true;
  sound = 3;
  ignoreEvent = "BurningArmor";
};

GTFO.SpellID["231363"] = {
  --desc = "Burning Armor (Goroth)";
  soundFunction = function() 
		GTFO_AddEvent("BurningArmor", 8);
		return 0;
	end;
};

GTFO.SpellID["233062"] = {
  --desc = "Infernal Burning (Goroth)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["241312"] = {
  --desc = "Lob Lightning (Razorjaw Acolyte)";
  sound = 3;
};

GTFO.SpellID["241179"] = {
  --desc = "Grand Cleave (Tidescale Legionnaire)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["240169"] = {
  --desc = "Electric Shock (Undersea Custodian)";
  sound = 3;
};

GTFO.SpellID["230362"] = {
  --desc = "Thundering Shock (Mistress Sassz'ine)";
  sound = 3;
  test = true; -- Negate if the player has a murloc on them
};

GTFO.SpellID["232732"] = {
  --desc = "Slicing Tornado (Mistress Sassz'ine)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["232754"] = {
  --desc = "Hydra Acid (Mistress Sassz'ine)";
  applicationOnly = true;
  sound = 3;
  minimumStacks = 1;
};

GTFO.SpellID["232827"] = {
  --desc = "Crashing Wave (Mistress Sassz'ine)";
  sound = 3;
};

GTFO.SpellID["232885"] = {
  --desc = "Devour Whole (Mistress Sassz'ine)";
  sound = 3;
};

GTFO.SpellID["236011"] = {
  --desc = "Tormented Cries (Engine of Souls)";
  sound = 3;
  affirmingDebuffSpellID = 209166; -- Tormented Cries  
  test = true;
};

GTFO.SpellID["233426"] = {
  --desc = "Scythe Sweep (Atrigan)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["241173"] = {
  --desc = "Umbra Cleave (Umbral Guard)";
  sound = 3;
	tankSound = 0;
};

GTFO.SpellID["236480"] = {
  --desc = "Glaive Storm (Sisters of the Moon)";
  sound = 3;
};

GTFO.SpellID["239810"] = {
  --desc = "Sever Soul (Eternal Soulguard)";
  sound = 3;
};

GTFO.SpellID["239739"] = {
  --desc = "Dark Mark - Debuff (Fallen Avatar)";
	soundFunction = function() 
		GTFO_AddEvent("DarkMark", 8);
		return 0;
	end;
};

GTFO.SpellID["239742"] = {
  --desc = "Dark Mark - Explosion (Fallen Avatar)";
  sound = 4;
  ignoreEvent = "DarkMark";
};

GTFO.SpellID["240970"] = {
  --desc = "Shadowy Blades (Fallen Avatar)";
  sound = 3;
  test = true;  -- Don't sound if you have the debuff
};

GTFO.SpellID["240209"] = {
  --desc = "Unstable Soul (Maiden of Vigiliance)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["235138"] = {
  --desc = "Unstable Soul";
  applicationOnly = true;
  sound = 3;
  test = true;
};

GTFO.SpellID["235125"] = {
  --desc = "Unstable Soul (Maiden of Vigiliance)";
  sound = 4;
  test = true;
};

GTFO.SpellID["239486"] = {
  --desc = "Chaotic Eruption (Volatile Corruption)";
  sound = 3;
};

GTFO.SpellID["235956"] = {
  --desc = "Rupturing Slam (Reanimated Templar)";
  sound = 3;
};

GTFO.SpellID["240706"] = {
  --desc = "Arcane Ward";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["239144"] = {
  --desc = "Tormented Eruption (Tormented Soul)";
  sound = 3;
};

GTFO.SpellID["239852"] = {
  --desc = "Demonic Obelisk (Demonic Obelisk)";
  sound = 3;
};

GTFO.SpellID["242924"] = {
  --desc = "Impact";
  sound = 3;
};

GTFO.SpellID["233431"] = {
  --desc = "Calcified Quills (Atrigan)";
	applicationOnly = true;
	soundFunction = function() 
		-- Calcified Quills
		GTFO_AddEvent("CalcifiedQuills", 8);
		return 0;
	end
};

GTFO.SpellID["233435"] = {
  --desc = "Calcified Quills (Atrigan)";
  sound = 3;
	ignoreEvent = "CalcifiedQuills";
};

GTFO.SpellID["244974"] = {
  --desc = "Shadow Crash (Unsettling Despair)";
  sound = 3;
};

GTFO.SpellID["233021"] = {
  --desc = "Infernal Spike (Goroth)";
  sound = 3;
};

GTFO.SpellID["238037"] = {
  --desc = "Light Echoes (Maiden of Vigiliance)";
  sound = 3;
};

GTFO.SpellID["238420"] = {
  --desc = "Fel Echoes (Maiden of Vigiliance)";
  sound = 3;
};



--- *********
--- * Argus *
--- *********

GTFO.SpellID["251100"] = {
  --desc = "Erupting Crack (Kar'aaz)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["244623"] = {
  --desc = "Glaive Blast (Xeth'tal)";
  sound = 3;
};

GTFO.SpellID["252138"] = {
  --desc = "Arcane Discharge (Trap Rune)";
  sound = 3;
};

GTFO.SpellID["246775"] = {
  --desc = "Orb of Deflection";
  sound = 3;
};

GTFO.SpellID["251378"] = {
  --desc = "Dark Spores (Fel Enraged Shambler)";
  sound = 3;
};

GTFO.SpellID["251388"] = {
  --desc = "Baleful Beam (Fel Enraged Shambler)";
  sound = 3;
};

GTFO.SpellID["249406"] = {
  --desc = "Blast Waves (Vel'thrak the Punisher)";
  sound = 3;
};

GTFO.SpellID["249407"] = {
  --desc = "Blast Waves (Vel'thrak the Punisher)";
  sound = 3;
};

GTFO.SpellID["249408"] = {
  --desc = "Blast Waves (Vel'thrak the Punisher)";
  sound = 3;
};

GTFO.SpellID["248651"] = {
  --desc = "Fragment of Argus (Dread Knight Zak'gal)";
  sound = 3;
};

GTFO.SpellID["248652"] = {
  --desc = "Flames of Argus (Fragment of Argus)";
  sound = 3;
};

GTFO.SpellID["248665"] = {
  --desc = "Chaos Wave";
  sound = 3;
};

GTFO.SpellID["252093"] = {
  --desc = "Sacred Vines";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["218969"] = {
  --desc = "Fel Meteor (Invasive Gazer)";
  applicationOnly = true;
  sound = 3;
  test = true;
};

GTFO.SpellID["240364"] = {
  --desc = "Molten Fel";
  sound = 3;
};

GTFO.SpellID["252575"] = {
  --desc = "Fiery Release (Bursting Elemental)";
  sound = 3;
};

GTFO.SpellID["247389"] = {
  --desc = "Slumbering Gasp (Matron Folnuna)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["247411"] = {
  --desc = "Scorching Presence (Felblaze Maniac)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["247499"] = {
  --desc = "Grotesque Spawn (Matron Folnuna)";
  sound = 3;
};

GTFO.SpellID["254201"] = {
  --desc = "Wake of Destruction (Sotanathor)";
  sound = 3;
};

GTFO.SpellID["251735"] = {
  --desc = "Swarming Insects";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["249238"] = {
  --desc = "Slumber (Slumber Fog)";
  applicationOnly = true;
  sound = 1;
};


--- ***************************
--- * Seat of the Triumvirate *
--- ***************************

GTFO.SpellID["248130"] = {
  --desc = "Darkened Ramnant (Rift Warden)";
  sound = 3;
};

GTFO.SpellID["246026"] = {
  --desc = "Void Trap (Saprish)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["250188"] = {
  --desc = "Void Fragment";
  sound = 3;
};

GTFO.SpellID["248067"] = {
  --desc = "Grand Swing (Umbral War-Adept)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["246900"] = {
  --desc = "Dark Outbreak (Void Discharge)";
  sound = 3;
  applicationOnly = true;
};


-- *******************************
-- * Antorus, the Burning Throne *
-- *******************************

GTFO.SpellID["252112"] = {
  --desc = "Talon Strike (Legion Talon)";
  sound = 3;
};

GTFO.SpellID["244532"] = {
  --desc = "Fel Bombardment (Garothi Worldbreaker)";
  sound = 3;
};

GTFO.SpellID["253543"] = {
  --desc = "Infernal Bombardment (Legion Devastator)";
  sound = 3;
};

GTFO.SpellID["254760"] = {
  --desc = "Corrupting Maw (Shatug)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["254502"] = {
  --desc = "Fearsome Leap (Imperator Deconix)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["245121"] = {
  --desc = "Entropic Blast (Entropic Mine)";
  sound = 3;
};

GTFO.SpellID["244892"] = {
  --desc = "Exploit Weakness (Admiral Svirax)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["243984"] = {
  --desc = "Collapsing World (Portal Keeper Hasabel)";
	soundFunction = function() -- Warn only if you get hit more than once
		if (GTFO_FindEvent("CollapsingWorld")) then
			return 3;
		end
		GTFO_AddEvent("CollapsingWorld", 1);
		return 0;
	end
};

GTFO.SpellID["244001"] = {
  --desc = "Felstorm Barrage (Portal Keeper Hasabel)";
  sound = 3;
};

GTFO.SpellID["249671"] = {
  --desc = "Bombardment";
  sound = 3;
};

GTFO.SpellID["247388"] = {
  --desc = "Pulse Grenade (Imonar the Soulhunter)";
  sound = 3;
};

GTFO.SpellID["247681"] = {
  --desc = "Pulse Grenade (Imonar the Soulhunter)";
  sound = 3;
};

GTFO.SpellID["247641"] = {
  --desc = "Stasis Trap (Imonar the Soulhunter)";
  applicationOnly = true;  
  sound = 3;
};

GTFO.SpellID["247962"] = {
  --desc = "Blastwire (Imonar the Soulhunter)";
  sound = 3;
};

GTFO.SpellID["247716"] = {
  --desc = "Charged Blasts (Imonar the Soulhunter)";
  applicationOnly = true;  
  sound = 3;
  test = true;
};

GTFO.SpellID["254919"] = {
  --desc = "Forging Strike (Kin'garoth)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["246634"] = {
  --desc = "Apocalypse Blast (Kin'garoth)";
  sound = 3;
};

GTFO.SpellID["257644"] = {
  --desc = "Shadow Strike (Varimathras)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["244006"] = {
  --desc = "Dark Eruption (Varimathras)";
  sound = 3;
};

GTFO.SpellID["246374"] = {
  --desc = "Shadow Blades (Asara, Mother of Night)";
  sound = 3;
};

GTFO.SpellID["246209"] = {
  --desc = "Punishing Flame (Dark Keeper Aedis)";
  applicationOnly = true;  
  sound = 3;
};

GTFO.SpellID["254022"] = {
  --desc = "Corrupt Aegis (Aggramar)";
  sound = 3;
};

GTFO.SpellID["246014"] = {
  --desc = "Searing Tempest (Aggramar)";
  sound = 3;
  applicationOnly = true;  
};

GTFO.SpellID["244291"] = {
  --desc = "Foe Breaker (Aggramar)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["244736"] = {
  --desc = "Wake of Flame (Aggramar)";
  sound = 3;
  applicationOnly = true;  
};

GTFO.SpellID["245391"] = {
  --desc = "Flare (Aggramar)";
  sound = 3;
};

GTFO.SpellID["244686"] = {
  --desc = "Meteor Swarm (Aggramar)";
  sound = 3;
};

GTFO.SpellID["251815"] = {
  --desc = "Edge of Obliteration (Argus the Unmaker)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["248499"] = {
  --desc = "Sweeping Scythe (Argus the Unmaker)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["257299"] = {
  --desc = "Ember of Rage (Argus the Unmaker)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["244601"] = {
  --desc = "Supernova (Vulcanar)";
  sound = 3;
};

GTFO.SpellID["244163"] = {
  --desc = "Molten Flare (F'harg)";
  sound = 3;
};

GTFO.SpellID["244071"] = {
  --desc = "Weight of Darkness (Shatug)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["250701"] = {
  --desc = "Fel Swipe (Fel-Powered Purifier)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["248321"] = {
  --desc = "Conflagration (Imonar)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["250191"] = {
  --desc = "Conflagration (Imonar)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["247932"] = {
  --desc = "Shrapnel Blast (Imonar)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["244899"] = {
  --desc = "Fiery Strike (Noura, Mother of Flames)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["245629"] = {
  --desc = "Whirling Saber (Noura, Mother of Flames)";
  sound = 3;
};

GTFO.SpellID["253588"] = {
  --desc = "Fulminating Burst (Noura, Mother of Flames)";
  sound = 3;
  ignoreEvent = "Fulminating";
};

GTFO.SpellID["246663"] = {
  --desc = "Surging Fel (Garothi Worldbreaker)";
  sound = 3;
};

GTFO.SpellID["250007"] = {
  --desc = "Empowered Pulse Grenade (Imonar)";
  sound = 4;
  test = true;
};

end
