if not BG.IsVanilla_Sod then return end

local _, ns = ...

local LibBG = ns.LibBG
local L = ns.L

local Size = ns.Size
local ClassQuest = ns.ClassQuest
local RR = ns.RR
local NN = ns.NN
local RN = ns.RN

local pt = print

local LibRecipes = LibStub("LibRecipes-3.0")

local _, classFilename, classID = UnitClass("player")
--[[
1	Warrior	WARRIOR	
2	Paladin	PALADIN	
3	Hunter	HUNTER	
4	Rogue	ROGUE	
5	Priest	PRIEST	
6	Death Knight	DEATHKNIGHT
7	Shaman	SHAMAN	
8	Mage	MAGE	
9	Warlock	WARLOCK	
10	Monk	MONK
11	Druid	DRUID	
]]

-- 副本掉落
do
    -- P1
    do
        local FB = "BD"

        -- BD黑暗深渊
        do
            BG.Loot[FB].N.boss1 = { 209676, 209828, 209423, 204804, 211852, 209421, 209825, 209422, 209677, 204807, 209590, }
            BG.Loot[FB].N.boss2 = { 209678, 209824, 209418, 209675, 209524, 209432, 209523, 209436, 209424, 209830, }
            BG.Loot[FB].N.boss3 = { 211843, 211789, 211842, 209679, 209527, 209566, 209680, 209823, 209565, 209564, 209525, 209822, 209563, }
            BG.Loot[FB].N.boss4 = { 209572, 209568, 209569, 209670, 209820, 209821, 211505, 211510, 211507, 209683, 211504, 211512, 211509, 209671, 211506, 211508, 211511, 209669, 209573, 209559, 209567, 209570, 209571, 209681, 211491 }
            BG.Loot[FB].N.boss5 = { 209682, 209578, 209581, 211505, 211510, 211507, 209683, 211504, 211512, 211509, 209671, 211506, 211508, 211511, 209669, 209577, 209560, 209818, 209579, 209574, 209576, 209575 }
            BG.Loot[FB].N.boss6 = { 211455, 209672, 211457, 209667, 209668, 209673, 209686, 209817, 211505, 211507, 211510, 211504, 211512, 211506, 211511, 209694, 211458, 209674, 209816, 209561, 211492 }
            BG.Loot[FB].N.boss7 = { 209690, 209692, 209687, 209685, 209684, 209689, 211505, 211510, 209669, 211508, 211511, 209580, 211456, 209688, 209691, 209562, 209534 }
            BG.Loot[FB].N.boss8 = { 1486, 3416, 1491, 3414, 1454, 1481, 2567, 3413, 3417, 3415, 2271, }
            BG.Loot[FB].N.boss7other = { 211451, 211450, 211449 }

            if BG.IsAlliance then -- BL
                tinsert(BG.Loot.BD.N.boss7, 1, 209693)
            else
                tinsert(BG.Loot.BD.N.boss7, 1, 211452)
            end

            -- 兑换物
            if BG.IsAlliance then
                BG.Loot[FB].ExchangeItems[209693] = { 211451, 211450, 211449, }
            else
                BG.Loot[FB].ExchangeItems[211452] = { 211451, 211450, 211449, }
            end


            -- 团本任务奖励
            BG.Loot[FB].N.Quest[BG.STC_y1(QUESTS_LABEL)] = { 211461, 211460, }
            if BG.IsAlliance then
                BG.Loot[FB].N.Quest[BG.STC_y1(FACTION_ALLIANCE .. QUESTS_LABEL)] =
                { 211462, 211465, 211466, 211463, 211464, }
            end
            if BG.IsHorde then
                BG.Loot[FB].N.Quest[BG.STC_y1(FACTION_HORDE .. QUESTS_LABEL)] =
                { 211467, 211468, 16886, 16887 }
            end
        end

        -- 死亡矿井
        do
            local FB_5 = GetRealZoneText(36)
            BG.Loot.BD.Team[FB_5] = {
                [L["矿工约翰森"]] = { 5443, },
                [L["斯尼德"]] = { 5194, },
                [L["基尔尼格"]] = { 1156, },
                [L["重锤先生"]] = { 7230, },
                [L["绿皮队长"]] = { 5201, },
                [L["艾德温・范克里夫"]] = { 5193, 5202, 10399, 5191, },
                [L["曲奇"]] = { 5198, },
            }
            if BG.IsAlliance then
                BG.Loot.BD.Team[FB_5][BG.STC_y1(FACTION_ALLIANCE .. QUESTS_LABEL)] = { 6087, 2041, 2042 }
            end
        end
        -- 哀嚎洞穴
        do
            local FB_5 = GetRealZoneText(43)
            BG.Loot.BD.Team[FB_5] = {
                [L["考布莱恩"]] = { 6460, 10410, },
                [L["克雷什"]] = { 13245, },
                [L["皮萨斯"]] = { 6472, },
                [L["斯卡姆"]] = { 6449, },
                [L["瑟芬迪斯"]] = { 6469, },
                [L["永生者沃尔丹"]] = { 6630, 6631, },
                [L["吞噬者穆坦努斯"]] = { 6461, 6627, 6463, },
                [L["变异精灵龙"]] = { 5243, },
            }
            if BG.IsHorde then
                BG.Loot.BD.Team[FB_5][BG.STC_y1(FACTION_HORDE .. QUESTS_LABEL)] = { 6506, 6504 }
            end
        end
        -- 影牙城堡
        do
            local FB_5 = GetRealZoneText(33)
            BG.Loot.BD.Team[FB_5] = {
                [L["屠夫拉佐克劳"]] = { 1292, },
                [L["席瓦莱恩男爵"]] = { 6321, },
                [L["指挥官"]] = { 6320, },
                [L["盲眼守卫奥杜"]] = { 6318, },
                [L["幻影之甲"]] = { 6642, },
                [L["狼王南杜斯"]] = { 3748, },
                [L["大法师阿鲁高"]] = { 6324, 6392, 6220, },
                [L["小怪"]] = { 2292, 1489, 1974, 2807, 1482, 1935, 1483, 1318, 3194, 2205, 1484, },
            }
            if BG.IsAlliance then
                BG.Loot.BD.Team[FB_5][ClassQuest(2)] = { 6953 }
            end
            if BG.IsHorde then
                BG.Loot.BD.Team[FB_5][BG.STC_y1(FACTION_HORDE .. QUESTS_LABEL)] = { 6414 }
            end
        end
        -- 监狱
        do
            local FB_5 = GetRealZoneText(34)
            BG.Loot.BD.Team[FB_5] = {
                [L["布鲁高・铁拳"]] = { 3228, 2941, 2942, },
            }
            if BG.IsAlliance then
                BG.Loot.BD.Team[FB_5][BG.STC_y1(FACTION_ALLIANCE .. QUESTS_LABEL)] = { 2933 }
            end
        end
        -- 剃刀沼泽
        do
            local FB_5 = GetRealZoneText(47)
            BG.Loot.BD.Team[FB_5] = {
                [L["小怪"]] = { 2264, 4438, 1978, 2039, 1727, 1976, 1975, 2549, },
            }
            if BG.IsAlliance then
                BG.Loot[FB].Team[FB_5][BG.STC_y1(ClassQuest(1))] = {
                    6972,
                }
            end
            if BG.IsHorde then
                BG.Loot[FB].Team[FB_5][BG.STC_y1(ClassQuest(1))] = {
                    7133,
                }
            end
        end
        -- 血色
        do
            local FB_5 = GetRealZoneText(189)
            BG.Loot.BD.Team[FB_5] = {
                [L["小怪"]] = { 7754, 7786, },
            }
        end
    end

    -- P2
    do
        local FB = "Gno"

        -- Gno诺莫瑞根
        do
            BG.Loot.Gno.N.boss1 = { 213294, 213288, 213304, 213322, 213321, 213323, 213327, 213324, 213326, 213351, 213542, 216490, 215435, 215436, 215437, }
            BG.Loot.Gno.N.boss2 = { 213307, 213290, 213299, 213302, 213301, 213413, 213285, 213289, 213352, 213355, 213291, 213353, }
            BG.Loot.Gno.N.boss3 = { 213340, 213278, 213305, 213317, 213415, 213292, 210741, 213408, 213295, 213442, 213419, 213412, 215449, }
            BG.Loot.Gno.N.boss4 = { 217009, 217007, 217008, 215377, 215379, 215378, 213309, 213298, 213287, 213319, 213300, 213279, 213414, 213418, 213354, 213560, 213559, 213293, 216494, 213286, }
            BG.Loot.Gno.N.boss5 = { 217009, 217007, 217008, 215377, 215379, 215378, 213306, 213308, 213320, 213280, 213417, 213303, 213325, 213318, 213296, 213297, 213411, 215380, 213410, }
            BG.Loot.Gno.N.boss6 = { 13325, 217009, 217007, 217008, 215377, 215379, 215378, 213281, 213349, 213348, 215461, 213347, 213350, 216608, 213283, 213284, 213282, 213416, 213409, 213356, }
            BG.Loot.Gno.N.boss7 = { 213427 }
            BG.Loot.Gno.N.boss4other = { 213310, 213311, 213328, 213329, 213336, 213337, 213312, 213313, 213331, 213332, 213341, 213342, 213314, 213315, 213333, 213334, 213338, 213339, 213316, 216485, 213330, 216486, 216484, 213335, }
            BG.Loot.Gno.N.boss5other = { 213310, 213311, 213328, 213329, 213336, 213337, 213312, 213313, 213331, 213332, 213341, 213342, 213314, 213315, 213333, 213334, 213338, 213339, 213316, 216485, 213330, 216486, 216484, 213335, }
            BG.Loot.Gno.N.boss6other = { 213343, 213344, 213345, 213346, 213310, 213311, 213328, 213329, 213336, 213337, 213312, 213313, 213331, 213332, 213341, 213342, 213314, 213315, 213333, 213334, 213338, 213339, 213316, 216485, 213330, 216486, 216484, 213335, }

            if BG.IsAlliance then
                tinsert(BG.Loot.Gno.N.boss6, 1, 217350)
            else
                tinsert(BG.Loot.Gno.N.boss6, 1, 217351)
            end

            -- 兑换物
            BG.Loot[FB].ExchangeItems = {
                [217008] = { 213310, 213311, 213312, 213313, 213314, 213315, 213316, 216485, },
                [217009] = { 213328, 213329, 213331, 213332, 213333, 213334, 213330, 216486, },
                [217007] = { 213336, 213337, 213341, 213342, 213338, 213339, 216484, 213335, },
                [217496] = { 217497, }, -- 法师 纳帕斯之剑
            }
            if BG.IsAlliance then
                BG.Loot[FB].ExchangeItems[217350] = { 213343, 213344, 213345, 213346, }
            else
                BG.Loot[FB].ExchangeItems[217351] = { 213343, 213344, 213345, 213346, }
            end


            -- 团本任务奖励
            BG.Loot[FB].N.Quest[BG.STC_y1(QUESTS_LABEL)] = { 216675, 216676, 216678 }
            if BG.IsAlliance then
                BG.Loot[FB].N.Quest[BG.STC_y1(FACTION_ALLIANCE .. QUESTS_LABEL)] =
                { 216680, 216679, 217005, 217006, 216673 }
            end
            if BG.IsHorde then
                BG.Loot[FB].N.Quest[BG.STC_y1(FACTION_HORDE .. QUESTS_LABEL)] =
                { 216674 }
            end
        end

        -- 剃刀沼泽
        do
            local FB_5 = GetRealZoneText(47)
            BG.Loot[FB].Team[FB_5] = {
                [L["亡语者贾格巴"]] = { 2816, 6685, 6682, },
                [L["主宰拉姆塔斯"]] = { 6687, 6686, },
                [L["刺鬃守卫"]] = { 6679, },
                [L["暴怒的阿迦赛罗斯"]] = { 6691, 6690, },
                [L["盲眼猎手"]] = { 6695, 6697, 6696, },
                [L["卡尔加・刺肋"]] = { 6693, 6694, 6692, },
                [L["唤地者哈穆加"]] = { 6689, 6688, },
                [L["小怪"]] = { 2264, 1488, 4438, 1978, 2039, 1727, 776, 1976, 1975, 2549, },
                [BG.STC_y1(QUESTS_LABEL)] = { 4197, 6725, 6742 },
            }
            if BG.IsAlliance then
                BG.Loot[FB].Team[FB_5][BG.STC_y1(ClassQuest(1))] = {
                    6972,
                }
            end
            if BG.IsHorde then
                BG.Loot[FB].Team[FB_5][BG.STC_y1(ClassQuest(1))] = {
                    7133,
                }
            end
        end
        -- 血色
        do
            local FB_5 = GetRealZoneText(189)
            BG.Loot[FB].Team[FB_5] = {
                [L["审讯员韦沙斯"]] = { 7682, },
                [L["永醒的艾希尔"]] = { 7709, 217295, 217296, },
                [L["死灵勇士"]] = { 217294, 7690, 7689, },
                [L["铁脊死灵"]] = { 7688, 7687, 7686, },
                [L["血法师萨尔诺斯"]] = { 7685, 7684, },
                [L["驯犬者洛克希"]] = { 7710, 7756, 3456, },
                [L["奥法师杜安"]] = { 7714, 217299, 217298, 217297, },
                [L["赫洛德"]] = { 7719, 7718, 10330, 7717, },
                [L["法尔班克斯"]] = { 19507, 19508, 19509, },
                [L["莫格莱尼"]] = { 7724, 10330, 7726, 217302, },
                [L["怀特迈恩"]] = { 217300, 217301, 7721, },
                [L["小怪"]] = { 5819, 7755, 7727, 7728, 7759, 7760, 7754, 10332, 1992, 2262, 7787,
                    7729, 7761, 7752, 8226, 7786, 5756, 7736, 8225, 7753, 7730, 7758, 7757, 10328,
                    10331, 10329, 10333, },
            }

            if BG.IsAlliance then
                BG.Loot[FB].Team[FB_5][BG.STC_y1(FACTION_ALLIANCE .. QUESTS_LABEL)] = {
                    6830, 6829, 6831, 11262,
                }
            end
            if BG.IsHorde then
                BG.Loot[FB].Team[FB_5][BG.STC_y1(FACTION_HORDE .. QUESTS_LABEL)] = {
                    6802, 6803, 10711,
                }
            end
        end
        -- 剃刀高地
        do
            local FB_5 = GetRealZoneText(129)
            BG.Loot[FB].Team[FB_5] = {
                [L["图特卡什"]] = { 217293, 10775, 10777, },
                [L["火眼莫德雷斯"]] = { 217290, 217292, 217291, },
                [L["暴食者"]] = { 10774, 10772, },
                [L["拉戈斯诺特"]] = { 10768, 10767, 10758, },
                [L["寒冰之王亚门纳尔"]] = { 10763, 217288, 217289, 10761, 10765, },
                [L["腐烂的普雷莫尔"]] = { 10766, 10760, },
                [L["小怪"]] = { 10574, 10581, 10583, 10584, 10578, 10582, 10572, 10567, 10571, 10570, 10573, },
                [BG.STC_y1(QUESTS_LABEL)] = { 10823, 10824, 10710 },
            }
        end
        -- 奥达曼
        do
            local FB_5 = GetRealZoneText(70)
            BG.Loot[FB].Team[FB_5] = {
                [L["鲁维罗什"]] = { 217304, 217307, 217305, 217306 },
                [L["艾隆纳亚"]] = { 9409, 217303, 217704, },
                [L["石头看守者"]] = { 9410, 9411, },
                [L["小怪"]] = { 9431, 9429, 9420, 9430, 9397, 9406, 9428, 223537, 9396, 9393, 9381, 9426, 9422,
                    9465, 9384, 9386, 9427, 9392, 9424, 9383, 9425, 9423, 9391, },
                [ClassQuest(8)] = { 9517, 7515 },
            }
            if BG.IsHorde then
                BG.Loot[FB].Team[FB_5][L["埃瑞克"]] = { 9394, 9398, }
                BG.Loot[FB].Team[FB_5][L["巴尔洛戈"]] = { 9401, }
                BG.Loot[FB].Team[FB_5][L["奥拉夫"]] = { 9404, }
            end
        end
    end

    -- P3
    do
        local FB = "Temple"
        -- 神庙
        do
            BG.Loot[FB].N.boss1 = { 220637, 220636, 220537, 220539, 220554, 220527, 220529, 220511, 220561, 220615, 220567, 220580, 220602, 220568, 220635, }
            BG.Loot[FB].N.boss2 = { 220637, 220636, 221281, 220538, 220550, 220552, 220518, 220542, 220546, 220540, 220545, 220541, 220565, 220569, 220571, 221484, }
            BG.Loot[FB].N.boss3 = { 220637, 220636, 220555, 220528, 220532, 220558, 220560, 220516, 220522, 220548, 220611, 220533, 220591, 220674, 220572, 220638, }
            BG.Loot[FB].N.boss4 = { 220637, 220636, 221298, 220536, 220551, 220549, 220519, 220521, 220544, 220609, 220566, 220594, 220587, 220581, 220584, }
            BG.Loot[FB].N.boss5 = { 220637, 220636, 220625, 220623, 220624, 220556, 220515, 220547, 220535, 220576, 220583, 220575, 220578, 220601, 220605, 220586, }
            BG.Loot[FB].N.boss6 = { 220637, 220636, 221298, 220553, 220559, 220512, 220514, 220543, 220563, 220965, 220598, 220599, 220597, 220607, 220606, 220596, 220589, }
            BG.Loot[FB].N.boss7 = { 221475, 220637, 220636, 221298, 220622, 220523, 220564, 220574, 220600, 220604, 220603, 220595, 220579, 220585, 220582, 220573, }
            BG.Loot[FB].N.boss8 = { 220637, 220636, 220557, 220562, 220608, 220530, 220577, 220534, 220590, 220686, 220588, 220634, 220632, 220633, 220620, }
            BG.Loot[FB].N.boss9 = { 220637, 220636, 221021, 221312, }
            BG.Loot[FB].N.boss10 = {}
            BG.Loot[FB].N.boss6other = { 224409 }
            BG.Loot[FB].N.boss8other = { 220626, 220630, 220628, 220627, 220629, }
            BG.Loot[FB].N.boss10other = { 220783, 220683, 220680, 220784, 220685, 220681, 220781, 220684, 220679, 220669, 220672, 220779, 220670, 220675, 220780, 220671, 220673, 220778, 220676, 220677, 220678, 220666, 220665, 220660, 220657, 220668, 220664, 220662, 220659, 220658, 220661, 220663, 220667, 220653, 220650, 220642, 220648, 220652, 220656, 220643, 220651, 220654, }

            if BG.IsAlliance then
                tinsert(BG.Loot[FB].N.boss8, 1, 221346)
            else
                tinsert(BG.Loot[FB].N.boss8, 1, 221363)
            end

            -- 兑换物
            BG.Loot[FB].ExchangeItems = {
                -- MS/FS/SS/XD
                [220637] = { 220783, 220683, 220680, 220784, 220685, 220681, 220781, 220684, 220679, 220669, 220672, 220779, 220670, 220675, 220780, 220671, 220673, 220778, },
                -- ZS/QS/SM/LR/DZ
                [220636] = { 220676, 220677, 220678, 220666, 220665, 220660, 220657, 220668, 220664, 220662, 220659, 220658, 220661, 220663, 220667, 220653, 220650, 220642, 220648, 220652, 220656, 220643, 220651, 220654, },
                [220589] = { 224409 }
            }
            if BG.IsAlliance then
                BG.Loot[FB].ExchangeItems[221346] = { 220626, 220630, 220628, 220627, 220629, }
            else
                BG.Loot[FB].ExchangeItems[221363] = { 220626, 220630, 220628, 220627, 220629, }
            end


            if classID == 1 then
                BG.Loot[FB].N.Quest[ClassQuest(1)] = { 20521, 20130, 20517, }
            elseif classID == 2 then
                BG.Loot[FB].N.Quest[ClassQuest(2)] = { 20504, 20512, 20505, }
            elseif classID == 3 then
                BG.Loot[FB].N.Quest[ClassQuest(3)] = { 20083, 19991, 19992, }
            elseif classID == 4 then
                BG.Loot[FB].N.Quest[ClassQuest(4)] = { 19984, 20255, 19982, }
            elseif classID == 5 then
                BG.Loot[FB].N.Quest[ClassQuest(5)] = { 19990, 20082, 20006, }
            elseif classID == 7 then
                BG.Loot[FB].N.Quest[ClassQuest(7)] = { 20369, 20556, 20503, }
            elseif classID == 8 then
                BG.Loot[FB].N.Quest[ClassQuest(8)] = { 20035, 20037, 20036, }
            elseif classID == 9 then
                BG.Loot[FB].N.Quest[ClassQuest(9)] = { 20536, 20534, 20530, }
            elseif classID == 11 then
                BG.Loot[FB].N.Quest[ClassQuest(11)] = { 22274, 22272, 22458, }
            end

            -- 团本任务
            BG.Loot[FB].N.Quest[BG.STC_y1(QUESTS_LABEL)] = { 1490, 223325, 223326, 223327, 221781, 223329, 223324, 221782, 221474, }
        end

        -- 奥达曼
        do
            local FB_5 = GetRealZoneText(70)
            BG.Loot[FB].Team[FB_5] = {
                [L["鲁维罗什"]] = { 217304, 217307, 217305, 217306 },
                [L["艾隆纳亚"]] = { 9409, 217303, 217704, },
                [L["石头看守者"]] = { 9410, 9411, },
                [L["加加恩・火锤"]] = { 11310, 9412, 11311, 9419, },
                [L["格瑞姆洛克"]] = { 223535, 223536, 9414, },
                [L["阿扎达斯"]] = { 11118, 9413, 9418, },
                [L["小怪"]] = { 9431, 9429, 9420, 9430, 9397, 9406, 9428, 223537, 9396, 9393, 9381, 9426, 9422,
                    9465, 9384, 9386, 9427, 9392, 9424, 9383, 9425, 9423, 9391, },
                [ClassQuest(8)] = { 9517, 7515 },
                [BG.STC_y1(QUESTS_LABEL)] = { 4746, 9522, 10358, 10359 },
            }
            if BG.IsHorde then
                BG.Loot[FB].Team[FB_5][L["埃瑞克"]] = { 9394, 9398, }
                BG.Loot[FB].Team[FB_5][L["巴尔洛戈"]] = { 9401, }
                BG.Loot[FB].Team[FB_5][L["奥拉夫"]] = { 9404, }
            end

            if BG.IsAlliance then
                BG.Loot[FB].Team[FB_5][BG.STC_y1(FACTION_ALLIANCE .. QUESTS_LABEL)] = {
                    4980, 9626, 9627, 6723, 7673,
                }
            end
            if BG.IsHorde then
                BG.Loot[FB].Team[FB_5][BG.STC_y1(FACTION_HORDE .. QUESTS_LABEL)] = {
                    7888,
                }
            end
        end
        -- 祖尔法拉克
        do
            local FB_5 = GetRealZoneText(209)
            BG.Loot[FB].Team[FB_5] = {
                [L["安图苏尔"]] = { 9640, 223532, 9639, 9379, 223526, },
                [L["巫医祖穆拉恩"]] = { 223534, 18082, },
                [L["暗影祭司塞瑟斯"]] = { 9470, 223529, 223530, 9475, },
                [L["灰尘怨灵"]] = { 223533, },
                [L["加兹瑞拉"]] = { 223528, 223527, },
                [L["乌克兹・沙顶"]] = { 9479, 223531, 9478, 9477, 11086, 223526, },
                [L["泽雷利斯"]] = { 223962, },
                [L["小怪"]] = { 9512, 9484, 862, 6440, 9483, 2040, 5616, 9511, 9481, 9480, 9482, },
                [BG.STC_y1(QUESTS_LABEL)] = { 11122, 9527, 9531, 9533, 9534 },
            }
        end
        -- 玛拉顿
        do
            local FB_5 = GetRealZoneText(349)
            BG.Loot[FB].Team[FB_5] = {
                [L["诺克赛恩"]] = { 17746, 17744, 17745, },
                [L["锐刺鞭笞者"]] = { 17749, 223543, 17750, 17751, },
                [L["维利塔恩"]] = { 17755, 17754, 17752, },
                [L["收割者麦什洛克"]] = { 17767, 17741, 17742, },
                [L["被诅咒的塞雷布拉斯"]] = { 223525, 17739, 17738, },
                [L["兰斯利德"]] = { 223522, 17736, 223523, 223524, },
                [L["工匠吉兹洛克"]] = { 223545, 223542, 223520, },
                [L["洛特格里普"]] = { 223521, 17728, 17730, },
                [L["瑟莱德丝公主"]] = { 223964, 223519, 223541, 17714, 17711, 17713, 223518, 221780, },
                [L["小怪"]] = {},
                [BG.STC_y1(QUESTS_LABEL)] = { 17743, 17705, 17753, 17775, 17770, 17779, 17774, 17773,
                    17777, 17778, 17776, 17768, 17772, },
            }
        end
        -- 黑石深渊
        do
            local FB_5 = GetRealZoneText(230)
            BG.Loot[FB].Team[FB_5] = {
                [L["洛考尔"]] = { 22234, 11632, 11631, },
                [L["审讯官格斯塔恩"]] = { 11626, 11624, 22240, 223539, },
                [L["驯犬者格雷尔玛尔"]] = { 11623, 11627, 223540, 223982, },
                [L["竞技场-修行者高罗什"]] = {},
                [L["竞技场-格里兹尔"]] = { 223544, 11703, 22270, 11702, },
                [L["竞技场-剜眼者"]] = { 223987, 11679, 11686, },
                [L["竞技场-破坏者奥科索尔"]] = { 11665, 11662, 223985, },
                [L["竞技场-阿努希尔"]] = { 11678, 223986, 11675, },
                [L["竞技场-爬行者赫杜姆"]] = { 11633, 223984, 11635, },
                [L["控火师罗格雷恩"]] = { 223981, 223980, 11748, 223538, },
                -- [L["黑色宝库"]] = {},
                [L["典狱官斯迪尔基斯"]] = { 223983, },
                -- [L["维雷克"]] = {},
                -- [L["卫兵杜格瑞普"]] = {},
                [L["弗诺斯・达克维尔"]] = { 11839, 22223, 11842, 11841, },
                -- [L["伊森迪奥斯"]] = {},
                -- [L["贝尔加"]] = {},
                -- [L["安格弗将军"]] = {},
                -- [L["傀儡统帅阿格曼奇"]] = {},
                -- [L["黑铁酒吧-霍尔雷・黑须"]] = {},
                -- [L["黑铁酒吧-普拉格"]] = {},
                -- [L["黑铁酒吧-方阵"]] = {},
                -- [L["弗莱拉斯大使"]] = {},
                -- [L["无敌的潘佐尔"]] = {},
                -- [L["七贤"]] = {},
                -- [L["玛格姆斯"]] = {},
                -- [L["铁炉堡公主茉艾拉・铜须"]] = {},
                -- [L["达格兰・索瑞森大帝"]] = {},
                [L["小怪"]] = { 12549, 12552, 12542, 12546, 12550, 12555, 12527, 12531, 12535, 12528, },
                [BG.STC_y1(QUESTS_LABEL)] = { 12113, 12114, 12112, 12115, 11865, 11963, 12049, 11962,
                    11866, 11964, 12000, },
            }

            if BG.IsAlliance then
                BG.Loot[FB].Team[FB_5][BG.STC_y1(FACTION_ALLIANCE .. QUESTS_LABEL)] = {
                    12018, 12021, 12041, 12061, 12062, 12065,
                }
            end
            if BG.IsHorde then
                BG.Loot[FB].Team[FB_5][BG.STC_y1(FACTION_HORDE .. QUESTS_LABEL)] = {

                }
            end
        end
    end

    -- P4
    do
        local FB = "MCsod"
        do
            BG.Loot[FB].N.boss1 = { 227533, 227759, 227756, 228285, 228247, 228239, 228246, 228244, 228245, 228240, 228242, 228243, 228262, 228263, 228127, 16665, }
            BG.Loot[FB].N.boss2 = { 227763, 227534, 227754, 228146, 228101, 228249, 228258, 228257, 228260, 228256, 228240, 228253, 228254, 228261, 228255, 228259, 228252, 228248, 228229, }
            BG.Loot[FB].N.boss3 = { 227765, 227757, 227533, 228350, 228285, 228239, 228246, 228244, 228245, 228240, 228242, 228243, 228262, 228263, 228127, }
            BG.Loot[FB].N.boss4 = { 18564, 227532, 227764, 227755, 228139, 228142, 228160, 228258, 228257, 228260, 228256, 228240, 228253, 228254, 228261, 228255, 228259, 228266, 228267, 228264, 228265, 228229, }
            BG.Loot[FB].N.boss5 = { 227531, 227760, 227750, 228286, 228285, 228239, 228246, 228244, 228245, 228240, 228242, 228243, 228262, 228263, 228127, 228253, }
            BG.Loot[FB].N.boss6 = { 18563, 227530, 227761, 227751, 228258, 228257, 228260, 228256, 228240, 228253, 228254, 228261, 228268, 228255, 228259, 228229, 228139, 228142, 228160, }
            BG.Loot[FB].N.boss7 = { 17203, 18870, 228239, 228246, 228244, 228245, 228240, 228242, 228243, 228262, 228263, 228272, 228127, 228128, 228260, 228292, 228295, 227535, 227766, 227758, 227537, 227752, 227762, 227533, 227756, 227759, 227531, 227750, 227760, 227530, 227751, 227761, 227534, 227754, 227763, 227536, 227757, 227765, 227532, 227764, 227755, }
            BG.Loot[FB].N.boss8 = { 17203, 228137, 228147, 228258, 228257, 228260, 228256, 228240, 228253, 228254, 228261, 228255, 228259, 228270, 228269, 228229, 228271, 228290, 228289, 227535, 227766, 227758, 227537, 227752, 227762, 227533, 227756, 227759, 227531, 227750, 227760, 227530, 227751, 227761, 227534, 227754, 227763, 227536, 227757, 227765, 227532, 227764, 227755, }
            BG.Loot[FB].N.boss9 = { 17203, 228279, 228283, 228280, 228281, 228282, 228284, 228275, 228274, 228102, 228277, 228278, 18703, 18646, 228129, 228461, 228296, 227535, 227766, 227758, 227537, 227752, 227762, 227533, 227756, 227759, 227531, 227750, 227760, 227530, 227751, 227761, 227534, 227754, 227763, 227536, 227757, 227765, 227532, 227764, 227755, }
            BG.Loot[FB].N.boss10 = { 227728, 17203, 228100, 228289, 228297, 228291, 228290, 228292, 228295, 228286, 228287, 228266, 228294, 228293, 228296, 228299, 228288, 227535, 227766, 227758, 227537, 227752, 227762, 227533, 227756, 227759, 227531, 227750, 227760, 227530, 227751, 227761, 227534, 227754, 227763, 227536, 227757, 227765, 227532, 227764, 227755, }
            BG.Loot[FB].N.boss11 = { 227728, 18563, 18564, 228286, 228287, 228296, 228288, 228299, 227535, 227766, 227758, 227537, 227752, 227762, 227532, 227764, 227755, 227533, 227756, 227759, 227531, 227750, 227760, 227530, 227751, 227761, 227534, 227754, 227763, 227536, 227757, 227765, }
            BG.Loot[FB].N.boss12 = { 17203, 17011, 17010, 11382, 18264, 18292, 18291, 18290, 18259, 18260, 18252, 18265, 21371, 18257, }
            BG.Loot[FB].N.boss1other = { 226556, 226569, 226552, 216921, 226572, 226585, 226591, 226600, 226615, 226608, 226629, 226637, 226621, 226528, 226540, 226648, 226654, 226441, 226664, 226669, 226475, 226486, 226497, }
            BG.Loot[FB].N.boss2other = { 226646, 226651, 226445, 226666, 226671, 226479, 226490, 226493, 226594, 226598, 226614, 226606, 226631, 226639, 226623, 226532, 226537, 226561, 226565, 226547, 216923, 226574, 226583, }
            BG.Loot[FB].N.boss3other = { 226645, 226652, 226443, 226663, 226673, 226477, 226487, 226496, 226593, 226601, 226613, 226609, 226628, 226636, 226620, 226531, 226538, 226557, 226568, 226554, 216918, 226571, 226586, }
            BG.Loot[FB].N.boss4other = { 19019, 226562, 226564, 226549, 216922, 226573, 226584, 226647, 226658, 226446, 226659, 226670, 226480, 226488, 226495, 226590, 226599, 226612, 226630, 226638, 226622, 226533, 226536, }
            BG.Loot[FB].N.boss5other = { 226655, 226662, 226442, 226668, 226649, 226476, 226484, 226499, 226589, 226596, 226618, 226603, 226634, 226642, 226626, 226530, 226541, 226558, 226567, 226553, 216920, 226578, 226579, }
            BG.Loot[FB].N.boss6other = { 19019, 226555, 226570, 226551, 216919, 226577, 226580, 226592, 226597, 226616, 226604, 226633, 226641, 226625, 226529, 226542, 226657, 226660, 226440, 226667, 226650, 226474, 226485, 226498, }
            BG.Loot[FB].N.boss7other = { 226559, 226563, 226575, 226582, 226548, 216924, 221785, 226656, 226447, 226661, 226675, 226473, 226489, 226494, 226610, 226602, 226617, 226595, 226627, 226635, 226619, 226534, 226535, 226560, 226566, 226550, 216925, 226576, 226581, 226588, 221783, 226611, 226605, 226632, 226640, 226624, 226527, 226543, 226644, 226653, 226444, 226665, 226674, 226478, 226491, 226492, 226556, 226569, 226552, 216921, 226572, 226585, 226591, 226600, 226615, 226608, 226629, 226637, 226621, 226528, 226540, 226648, 226654, 226441, 226664, 226669, 226475, 226486, 226497, 226646, 226651, 226445, 226666, 226671, 226479, 226490, 226493, 226594, 226598, 226614, 226606, 226631, 226639, 226623, 226532, 226537, 226561, 226565, 226547, 216923, 226574, 226583, 226645, 226652, 226443, 226663, 226673, 226477, 226487, 226496, 226593, 226601, 226613, 226609, 226628, 226636, 226620, 226531, 226538, 226557, 226568, 226554, 216918, 226571, 226586, 226562, 226564, 226549, 216922, 226573, 226584, 226647, 226658, 226446, 226659, 226670, 226480, 226488, 226495, 226590, 226599, 226612, 226630, 226638, 226622, 226533, 226536, 226655, 226662, 226442, 226668, 226649, 226476, 226484, 226499, 226589, 226596, 226618, 226603, 226634, 226642, 226626, 226530, 226541, 226558, 226567, 226553, 216920, 226578, 226579, 226555, 226570, 226551, 216919, 226577, 226580, 226592, 226597, 226616, 226604, 226633, 226641, 226625, 226529, 226542, 226657, 226660, 226440, 226667, 226650, 226474, 226485, 226498, }
            BG.Loot[FB].N.boss8other = { 226559, 226563, 226575, 226582, 226548, 216924, 221785, 226656, 226447, 226661, 226675, 226473, 226489, 226494, 226610, 226602, 226617, 226595, 226627, 226635, 226619, 226534, 226535, 226560, 226566, 226550, 216925, 226576, 226581, 226588, 221783, 226611, 226605, 226632, 226640, 226624, 226527, 226543, 226644, 226653, 226444, 226665, 226674, 226478, 226491, 226492, 226556, 226569, 226552, 216921, 226572, 226585, 226591, 226600, 226615, 226608, 226629, 226637, 226621, 226528, 226540, 226648, 226654, 226441, 226664, 226669, 226475, 226486, 226497, 226646, 226651, 226445, 226666, 226671, 226479, 226490, 226493, 226594, 226598, 226614, 226606, 226631, 226639, 226623, 226532, 226537, 226561, 226565, 226547, 216923, 226574, 226583, 226645, 226652, 226443, 226663, 226673, 226477, 226487, 226496, 226593, 226601, 226613, 226609, 226628, 226636, 226620, 226531, 226538, 226557, 226568, 226554, 216918, 226571, 226586, 226562, 226564, 226549, 216922, 226573, 226584, 226647, 226658, 226446, 226659, 226670, 226480, 226488, 226495, 226590, 226599, 226612, 226630, 226638, 226622, 226533, 226536, 226655, 226662, 226442, 226668, 226649, 226476, 226484, 226499, 226589, 226596, 226618, 226603, 226634, 226642, 226626, 226530, 226541, 226558, 226567, 226553, 216920, 226578, 226579, 226555, 226570, 226551, 216919, 226577, 226580, 226592, 226597, 226616, 226604, 226633, 226641, 226625, 226529, 226542, 226657, 226660, 226440, 226667, 226650, 226474, 226485, 226498, }
            BG.Loot[FB].N.boss9other = { 228335, 228336, 228334, 228332, 228143, 226559, 226563, 226575, 226582, 226548, 216924, 221785, 226656, 226447, 226661, 226675, 226473, 226489, 226494, 226610, 226602, 226617, 226595, 226627, 226635, 226619, 226534, 226535, 226560, 226566, 226550, 216925, 226576, 226581, 226588, 221783, 226611, 226605, 226632, 226640, 226624, 226527, 226543, 226644, 226653, 226444, 226665, 226674, 226478, 226491, 226492, 226556, 226569, 226552, 216921, 226572, 226585, 226591, 226600, 226615, 226608, 226629, 226637, 226621, 226528, 226540, 226648, 226654, 226441, 226664, 226669, 226475, 226486, 226497, 226646, 226651, 226445, 226666, 226671, 226479, 226490, 226493, 226594, 226598, 226614, 226606, 226631, 226639, 226623, 226532, 226537, 226561, 226565, 226547, 216923, 226574, 226583, 226645, 226652, 226443, 226663, 226673, 226477, 226487, 226496, 226593, 226601, 226613, 226609, 226628, 226636, 226620, 226531, 226538, 226557, 226568, 226554, 216918, 226571, 226586, 226562, 226564, 226549, 216922, 226573, 226584, 226647, 226658, 226446, 226659, 226670, 226480, 226488, 226495, 226590, 226599, 226612, 226630, 226638, 226622, 226533, 226536, 226655, 226662, 226442, 226668, 226649, 226476, 226484, 226499, 226589, 226596, 226618, 226603, 226634, 226642, 226626, 226530, 226541, 226558, 226567, 226553, 216920, 226578, 226579, 226555, 226570, 226551, 216919, 226577, 226580, 226592, 226597, 226616, 226604, 226633, 226641, 226625, 226529, 226542, 226657, 226660, 226440, 226667, 226650, 226474, 226485, 226498, }
            BG.Loot[FB].N.boss10other = { 227683, 226559, 226563, 226575, 226582, 226548, 216924, 221785, 226656, 226447, 226661, 226675, 226473, 226489, 226494, 226610, 226602, 226617, 226595, 226627, 226635, 226619, 226534, 226535, 226560, 226566, 226550, 216925, 226576, 226581, 226588, 221783, 226611, 226605, 226632, 226640, 226624, 226527, 226543, 226644, 226653, 226444, 226665, 226674, 226478, 226491, 226492, 226556, 226569, 226552, 216921, 226572, 226585, 226591, 226600, 226615, 226608, 226629, 226637, 226621, 226528, 226540, 226648, 226654, 226441, 226664, 226669, 226475, 226486, 226497, 226646, 226651, 226445, 226666, 226671, 226479, 226490, 226493, 226594, 226598, 226614, 226606, 226631, 226639, 226623, 226532, 226537, 226561, 226565, 226547, 216923, 226574, 226583, 226645, 226652, 226443, 226663, 226673, 226477, 226487, 226496, 226593, 226601, 226613, 226609, 226628, 226636, 226620, 226531, 226538, 226557, 226568, 226554, 216918, 226571, 226586, 226562, 226564, 226549, 216922, 226573, 226584, 226647, 226658, 226446, 226659, 226670, 226480, 226488, 226495, 226590, 226599, 226612, 226630, 226638, 226622, 226533, 226536, 226655, 226662, 226442, 226668, 226649, 226476, 226484, 226499, 226589, 226596, 226618, 226603, 226634, 226642, 226626, 226530, 226541, 226558, 226567, 226553, 216920, 226578, 226579, 226555, 226570, 226551, 216919, 226577, 226580, 226592, 226597, 226616, 226604, 226633, 226641, 226625, 226529, 226542, 226657, 226660, 226440, 226667, 226650, 226474, 226485, 226498, }
            BG.Loot[FB].N.boss11other = { 19019, 227683, 226559, 226563, 226575, 226582, 226548, 216924, 221785, 226656, 226447, 226661, 226675, 226473, 226489, 226494, 226610, 226602, 226617, 226595, 226627, 226635, 226619, 226534, 226535, 226560, 226566, 226550, 216925, 226576, 226581, 226588, 221783, 226611, 226605, 226632, 226640, 226624, 226527, 226543, 226644, 226653, 226444, 226665, 226674, 226478, 226491, 226492, 226556, 226569, 226552, 216921, 226572, 226585, 226591, 226600, 226615, 226608, 226629, 226637, 226621, 226528, 226540, 226648, 226654, 226441, 226664, 226669, 226475, 226486, 226497, 226646, 226651, 226445, 226666, 226671, 226479, 226490, 226493, 226594, 226598, 226614, 226606, 226631, 226639, 226623, 226532, 226537, 226561, 226565, 226547, 216923, 226574, 226583, 226645, 226652, 226443, 226663, 226673, 226477, 226487, 226496, 226593, 226601, 226613, 226609, 226628, 226636, 226620, 226531, 226538, 226557, 226568, 226554, 216918, 226571, 226586, 226562, 226564, 226549, 216922, 226573, 226584, 226647, 226658, 226446, 226659, 226670, 226480, 226488, 226495, 226590, 226599, 226612, 226630, 226638, 226622, 226533, 226536, 226655, 226662, 226442, 226668, 226649, 226476, 226484, 226499, 226589, 226596, 226618, 226603, 226634, 226642, 226626, 226530, 226541, 226558, 226567, 226553, 216920, 226578, 226579, 226555, 226570, 226551, 216919, 226577, 226580, 226592, 226597, 226616, 226604, 226633, 226641, 226625, 226529, 226542, 226657, 226660, 226440, 226667, 226650, 226474, 226485, 226498, }

            -- 兑换物
            BG.Loot[FB].ExchangeItems = {
                [18564] = { 19019, },          -- 脸
                [18563] = { 19019, },          -- 脸
                [18646] = { 228335, 228336, }, -- 神圣之眼
                [18665] = { 228335, 228336, }, -- 暗影之眼
                [18703] = { 228334, 228332 },  -- 叶子
                [18704] = { 228334, 228332 },  -- 肌腱
                [228129] = { 228143 },         -- 盗贼职业任务
                [17204] = { 227683, },         -- 橙锤

                -- T1 胸
                [227535] = { 226559, 226563, 226575, 226582, 226548, 216924, },
                [227766] = { 221785, 226656, 226447, 226661, 226675, 226473, 226489, 226494, },
                [227758] = { 226610, 226602, 226617, 226595, 226627, 226635, 226619, 226534, 226535, },

                -- T1肩膀
                [227537] = { 226560, 226566, 226550, 216925, 226576, 226581, },
                [227752] = { 226588, 221783, 226611, 226605, 226632, 226640, 226624, 226527, 226543, },
                [227762] = { 226644, 226653, 226444, 226665, 226674, 226478, 226491, 226492, },

                -- T1手
                [227533] = { 226556, 226569, 226552, 216921, 226572, 226585, },
                [227756] = { 226591, 226600, 226615, 226608, 226629, 226637, 226621, 226528, 226540, },
                [227759] = { 226648, 226654, 226441, 226664, 226669, 226475, 226486, 226497, },

                -- T1护腕
                [227531] = { 226558, 226567, 226553, 216920, 226578, 226579, },
                [227750] = { 226589, 226596, 226618, 226603, 226634, 226642, 226626, 226530, 226541, },
                [227760] = { 226655, 226662, 226442, 226668, 226649, 226476, 226484, 226499, },

                -- T1腰带
                [227530] = { 226555, 226570, 226551, 216919, 226577, 226580, },
                [227751] = { 226592, 226597, 226616, 226604, 226633, 226641, 226625, 226529, 226542, },
                [227761] = { 226657, 226660, 226440, 226667, 226650, 226474, 226485, 226498, },

                -- T1腿
                [227534] = { 226561, 226565, 226547, 216923, 226574, 226583, },
                [227754] = { 226594, 226598, 226614, 226606, 226631, 226639, 226623, 226532, 226537, },
                [227763] = { 226646, 226651, 226445, 226666, 226671, 226479, 226490, 226493, },

                -- T1鞋
                [227536] = { 226557, 226568, 226554, 216918, 226571, 226586, },
                [227757] = { 226593, 226601, 226613, 226609, 226628, 226636, 226620, 226531, 226538, },
                [227765] = { 226645, 226652, 226443, 226663, 226673, 226477, 226487, 226496, },

                -- T1头
                [227532] = { 226562, 226564, 226549, 216922, 226573, 226584, },
                [227764] = { 226647, 226658, 226446, 226659, 226670, 226480, 226488, 226495, },
                [227755] = { 226590, 226599, 226612, 226630, 226638, 226622, 226533, 226536, },
            }
        end
        -- 屠魔峡谷
        do
            local FB_5 = GetRealZoneText(2784)
            BG.Loot[FB].Team[FB_5] = {
                [L["晦根"]] = { 228080, 228081, 228079, 228082, 228083, },
                [L["搜寻者迪亚索鲁斯"]] = { 228106, 228107, 228094, 228104, 228103, },
                [L["毁灭者的幻影"]] = { 228074, 228075, 228077, 228078, 228076, },
                [L["吉尔巴格布"]] = { 228086, 228088, 228087, 228084, 228085, },
                [L["派拉尼斯"]] = { 228091, 228093, 228090, 228092, 228089, },
                [L["地狱咆哮的幻灵"]] = { 228112, 228113, 228111, 228109, 228108, 228410, },
                [L["阿兹加洛斯"]] = { 231911, 231910, 231913, 231460, 231912, },
            }
        end

        -- 黑上
        do
            local FB_5 = GetRealZoneText(229) .. L["上层"]
            BG.Loot[FB].Team[FB_5] = {
                [L["烈焰卫士"]] = { 226748, 228584, 228583, 12905, 12926 },
                [L["索拉卡・火冠"]] = { 226741, 12609, 12603, 228578, 228579, 18657 },
                [BG.rareIcon .. L["杰德"]] = { 228566, 12930, 12605 },
                [L["古拉鲁克"]] = { 228672, 13498, 228602, 18048, 12834, 12837, 18779 },
                [L["雷德・黑手"]] = { 228757, 12871, 226768, 226753, 228604, 228605, 228651, 228676, 228650, 18102, 22247, 18103, 228653, 228652, 228603, 22225, 12960, 12953, 12952, 13522 },
                [L["比斯巨兽"]] = { 12731, 226735, 228663, 228664, 228662, 12965, 228660, 228661, 228597, 12709, 228666, 19227 },
                [L["达基萨斯将军"]] = { 228606, 226745, 226729, 226757, 226700, 226715, 226723, 226749, 226734, 226770, 228677, 228669, 22269, 228670, 228667, 228678, 22253, 12602, 15730, 13519 },
                [L["瓦塔拉克公爵"]] = { 228681, 228684, 22337, 22343, 22342, 228683, 22336, 228682 },
                [L["小怪"]] = { 226744, 226725, 226759, 226701, 226717, 226718, 226754, 226766, 228593, 16247 },
                [BG.STC_y1(QUESTS_LABEL)] = { 13966, 13968, 13965, 15861, 15860, 226500, },
            }
        end
        -- 黑下
        do
            local FB_5 = GetRealZoneText(229) .. L["下层"]
            BG.Loot[FB].Team[FB_5] = {
                [BG.rareIcon .. L["燃烧地狱卫士"]] = { 228554, 228555, },
                [BG.rareIcon .. L["尖石屠夫"]] = { 228556, 13286, },
                [L["欧莫克大王"]] = { 226752, 13166, 228571, 13170, 13169, 228570, },
                [BG.rareIcon .. L["尖石统帅"]] = { 228557, 13285, },
                [BG.rareIcon .. L["尖石首席法师"]] = { 228564, 228565, 228563, },
                [L["暗影猎手沃什加斯"]] = { 226702, 228562, 228558, 228561, 12653, 228559, 12654, },
                [L["指挥官沃恩"]] = { 226721, 228574, 228572, 228594, 13173, 12582, },
                [BG.rareIcon .. L["班诺克・巨斧"]] = { 228568, 228567, 12621, 12838, },
                [L["烟网蛛后"]] = { 226713, 228577, 228576, 228573, },
                [BG.rareIcon .. L["水晶之牙"]] = { 228590, 13184, 228592, },
                [L["乌洛克"]] = { 13258, 228595, 13259, 13178, 18784, },
                [L["军需官兹格雷斯"]] = { 13253, 13252, 12835, },
                [L["哈雷肯"]] = { 13212, 228598, 228575, 13210, },
                [L["奴役者基兹鲁尔"]] = { 226710, 13208, 13206, 228591, },
                [BG.rareIcon .. L["霍克・巴什古德"]] = { 13203, 13198, 13204, },
                [L["维姆萨拉克"]] = { 228585, 226716, 228588, 228589, 22321, 228601, 228586, 228587, },
                [L["莫尔・灰蹄"]] = { 228596, 22325, 22319, 22398, 228600, },
                [L["小怪"]] = { 226744, 226724, 226725, 226759, 226701, 226712, 226718, 226754, 226765, 226766, },
                [BG.STC_y1(QUESTS_LABEL)] = { 20218, 20219, 15873, 15824, 15825, 15827, 15867, 12631, }
            }
            if BG.IsAlliance then
                BG.Loot[FB].Team[FB_5][BG.STC_y1(FACTION_ALLIANCE .. QUESTS_LABEL)] = {
                    13958, 13959, 13961, 13962, 13963,
                }
            else
                BG.Loot[FB].Team[FB_5][BG.STC_y1(FACTION_HORDE .. QUESTS_LABEL)] = {
                    13958, 13959, 13958, 13959, 13961, 13962, 13963,
                }
            end
        end
        -- 斯坦索姆
        do
            local FB_5 = GetRealZoneText(329)
            BG.Loot[FB].Team[FB_5] = {
                [BG.rareIcon .. L["斯库尔"]] = { 13395, 13394, 13396, },
                [BG.rareIcon .. L["弗雷斯特恩"]] = { 226730, 228501, 228504, 228503, 13379, },
                [L["不可宽恕者"]] = { 226711, 228500, 13405, 13409, 13408, },
                [L["邮差马龙"]] = { 228528, 228525, 228527, 228529, 228524, 13393, },
                [L["悲惨的提米"]] = { 226737, 228513, 228515, 228514, 13401, },
                [L["红衣铸锤师"]] = { 18781, },
                [L["炮手威利"]] = { 226706, 22407, 228533, 22405, 18721, 13381, 228523, 228522, 13377, 22404, 22406, 12839, },
                [L["档案管理员加尔福特"]] = { 226740, 13386, 13387, 18716, 13385, 22897, },
                [L["巴纳扎尔"]] = { 228539, 14512, 226738, 228540, 228545, 228536, 228546, 13358, 13369, 228541, 228544, 22334, 13348, 13520, },
                [L["巴瑟拉斯镇长"]] = { 18727, 228505, 228518, 18722, 23198, 228516, },
                [BG.rareIcon .. L["石脊"]] = { 13397, 13954, 13399, },
                [L["安娜丝塔丽男爵夫人"]] = { 226763, 18728, 228521, 18729, 13534, 13538, 13535, 13537, 13539, 13514, },
                [L["黑衣守卫铸剑师"]] = { 18783, },
                [L["奈鲁布恩坎"]] = { 226722, 228531, 228530, 18738, 13529, 13533, 13532, 13531, 13530, 13508, },
                [L["苍白的玛勒基"]] = { 226743, 18734, 18735, 13524, 228535, 13528, 13525, 13526, 13527, 13509, 12833, },
                [L["吞咽者拉姆斯登"]] = { 226771, 18723, 228520, 13373, 13515, 13375, 13372, },
                [L["瑞文戴尔男爵"]] = { 13335, 228543, 228553, 22412, 13340, 13346, 228551, 228537, 228552, 228538, 22408, 13368, 13349, 228542, 226747, 226727, 226760, 226705, 226709, 226719, 226750, 226736, 226767, },
                [L["巴尔萨冯"]] = { 23126, 23125, 23124, },
                [L["索托斯和亚雷恩的遗物"]] = { 22327, 228547, 22328, 22334, 228548, },
                [L["小怪"]] = { 226742, 226724, 226761, 226704, 226714, 226717, 226751, 226732, 226765, 18742, 18743, 17061, 228532, 18744, 18745, 228534, },
                [BG.STC_y1(QUESTS_LABEL)] = { 13209, 19812, 13216, 13217, 13171, 13315, 17044, 17045, 13243, 13249, 13246, }
            }
            if BG.IsHorde then
                BG.Loot[FB].Team[FB_5][BG.STC_y1(FACTION_HORDE .. QUESTS_LABEL)] = {
                    18659, 17001,
                }
            end
        end
        -- 通灵学院
        do
            local FB_5 = GetRealZoneText(289)
            BG.Loot[FB].Team[FB_5] = {
                [L["传令官基尔图诺斯"]] = { 226764, 228019, 228001, 13969, 228007, 228005, 228004, 228015, 228029, },
                [L["詹迪斯・巴罗夫"]] = { 226756, 14548, 18689, 228031, 228040, 228041, 227997, 22394, },
                [L["血骨傀儡"]] = { 226703, 228032, 14538, 18686, 14537, 228037, 227994, 18782, 13873, },
                [L["死亡骑士达克雷尔"]] = { 228045, 18761, 18758, 228030, },
                [L["马杜克・布莱克波尔"]] = { 227992, 227993, },
                [L["维克图斯"]] = { 18691, 228017, },
                [L["莱斯・霜语"]] = { 228023, 226726, 228036, 14340, 228034, 14525, 14502, 228044, 18694, 228039, 18696, 228027, 14487, 13521, },
                [L["讲师玛丽希亚"]] = { 226704, 18681, 228010, 228013, 14637, 228012, 228000, 228011, 14640, 228020, 228006, 14636, 228014, 228002, 228018, 14638, 18682, 228003, 228008, 228009, 14641, 227998, 227999, 228016, 23201, 23200, 227996, 18683, },
                [L["瑟尔林・卡斯迪诺夫教授"]] = { 226731, 14617, 18681, 228010, 228013, 14637, 228012, 228000, 228011, 14640, 228020, 228006, 14636, 228014, 228002, 228018, 14638, 18682, 228003, 228008, 228009, 14641, 227998, 227999, 228016, 23201, 23200, 227996, 18683, },
                [L["博学者普克尔特"]] = { 226758, 18681, 228010, 228013, 14637, 228012, 228000, 228011, 14640, 228020, 228006, 14636, 228014, 228002, 228018, 14638, 18682, 228003, 228008, 228009, 14641, 227998, 227999, 228016, 23201, 23200, 227996, 18683, },
                [L["拉文尼亚"]] = { 226712, 18681, 228010, 228013, 14637, 228012, 228000, 228011, 14640, 228020, 228006, 14636, 228014, 228002, 228018, 14638, 18682, 228003, 228008, 228009, 14641, 227998, 227999, 228016, 23201, 23200, 227996, 18683, },
                [L["阿雷克斯・巴罗夫"]] = { 226739, 18681, 228010, 228013, 14637, 228012, 228000, 228011, 14640, 228020, 228006, 14636, 228014, 228002, 228018, 14638, 18682, 228003, 228008, 228009, 14641, 227998, 227999, 228016, 23201, 23200, 227996, 18683, },
                [L["伊露希亚・巴罗夫"]] = { 18681, 228010, 228013, 14637, 228012, 228000, 228011, 14640, 228020, 228006, 14636, 228014, 228002, 228018, 14638, 18682, 228003, 228008, 228009, 14641, 227998, 227999, 228016, 23201, 23200, 227996, 18683, },
                [L["黑暗院长加丁"]] = { 228022, 14514, 226746, 226728, 226762, 226707, 226708, 226720, 226755, 226733, 226769, 228025, 13951, 228042, 13398, 228046, 13938, 13953, 228021, 19276, 13501, },
                [L["布莱克伍德公爵"]] = { 228026, 23156, 23139, },
                [L["库尔莫克"]] = { 228038, 228047, 22331, 228028, 228033, },
                [L["小怪"]] = { 226724, 226761, 226704, 226714, 226712, 226751, 226739, 228704, 18699, 14536, 18700, 18702, 228703, 18701, },
                [BG.STC_y1(QUESTS_LABEL)] = { 13544, 15805, 15806, 14002, 13982, 13986, 13984, 14023, 15853, 15854, }
            }
            if BG.IsHorde then
                BG.Loot[FB].Team[FB_5][ClassQuest(2)] = {
                    20134,
                }
            end
        end
        -- 厄运
        do
            local FB_5 = GetRealZoneText(429) .. L["东"]
            BG.Loot[FB].Team[FB_5] = {
                [L["瑟雷姆・刺蹄"]] = { 228053, 18313, 228050, 18308, 18306, },
                [L["海多斯博恩"]] = { 228054, 18322, 228052, 19268, 18305, 18307, },
                [L["蕾瑟塔蒂丝"]] = { 18325, 228051, 18301, 18302, },
                [L["奥兹恩"]] = { 18328, 228055, 18309, 18326, 18327, 18318, 18321, 228056, 228699, 228057, },
                [L["伊萨利恩"]] = { 228066, 22472, 22401, 22345, 22315, 22314, },
                [L["小怪"]] = { 18289, 18296, 18298, 18295, 18333, 18334, 18332, 18255, 18297, },
            }
            BG.Loot[FB].Team[FB_5][BG.STC_y1(QUESTS_LABEL)] = {
                18411, 18410, 18491, 18535, 18536,
            }
            local FB_5 = GetRealZoneText(429) .. L["西"]
            BG.Loot[FB].Team[FB_5] = {
                [L["特迪斯・扭木"]] = { 228063, 228468, 18352, 18353, },
                [L["伊琳娜 ・ 暗木"]] = { 18383, 18386, 18349, 18347, },
                [L["卡雷迪斯镇长"]] = { 18374, 228067, 18371, 18350, 18351, 22309, },
                [L["苏斯"]] = { 228061, 18346, 18345, },
                [L["伊莫塔尔"]] = { 18381, 18384, 18389, 18385, 18394, 18377, 18391, 18379, 18370, 18372, },
                [L["托塞德林王子"]] = { 18382, 18373, 18375, 228470, 228069, 18395, 228471, 18396, 18376, 228472, },
                [L["报复"]] = { 23127, 23129, 23128, },
                [L["赫尔努拉斯"]] = { 228475, 18754, 18755, 18756, },
                [L["小怪"]] = { 18340, 18344, 18338, 18333, 18334, 18332, },
            }
            BG.Loot[FB].Team[FB_5][BG.STC_y1(QUESTS_LABEL)] = {
                18424, 18421, 18420,
            }
            local FB_5 = GetRealZoneText(429) .. L["北"]
            BG.Loot[FB].Team[FB_5] = {
                [L["卫兵摩尔达"]] = { 228059, 228058, 228060, 18497, 18498, 18450, 18458, 18459, 18451, 18462, 18463, 18464, 18460, 18250, 18268, },
                [L["践踏者克雷格"]] = { 18425, },
                [L["卫兵芬古斯"]] = { 18450, 18458, 18459, 18451, 18462, 18463, 18464, 18460, 18250, 18266, },
                [L["卫兵斯里基克"]] = { 228059, 228058, 228060, 18497, 18498, 18450, 18458, 18459, 18451, 18462, 18463, 18464, 18460, 18250, },
                [L["克罗卡斯"]] = { 18503, 228068, 18507, 18502, },
                [L["观察者克鲁什"]] = { 228062, 18483, 228064, 18484, },
                [L["戈多克大王"]] = { 228480, 18525, 18527, 228479, 18521, 18522, 18523, 228478, 19258, 18780, },
                [L["戈多克贡品"]] = { 228486, 228065, 18495, 228474, 228070, 18533, 18529, 228469, 18537, 18499, 228473, 228484, 18479, 18480, 18478, 18475, 18477, 18476, 18482, 18481, 18655, },
                [L["书籍"]] = { 18469, 228466, 18467, 228464, 18470, 18473, 18471, 228467, 228465, },
            }
            BG.Loot[FB].Team[FB_5][BG.STC_y1(QUESTS_LABEL)] = {
                18369, 18368, 18367, 18366,
            }
            BG.Loot[FB].ExchangeItems[18362] = { 18469, }
            BG.Loot[FB].ExchangeItems[18358] = { 228466, }
            BG.Loot[FB].ExchangeItems[18360] = { 18467, }
            BG.Loot[FB].ExchangeItems[18356] = { 228464, }
            BG.Loot[FB].ExchangeItems[18364] = { 18470, }
            BG.Loot[FB].ExchangeItems[18361] = { 18473, }
            BG.Loot[FB].ExchangeItems[18363] = { 18471, }
            BG.Loot[FB].ExchangeItems[18359] = { 228467, }
            BG.Loot[FB].ExchangeItems[18357] = { 228465, }
        end
        -- 黑石深渊
        do
            local FB_5 = GetRealZoneText(230)
            BG.Loot[FB].Team[FB_5] = {
                [L["洛考尔"]] = { 22234, 11632, 11631, 22397, },
                [L["审讯官格斯塔恩"]] = { 11626, 11624, 22240, 223539, },
                [L["驯犬者格雷尔玛尔"]] = { 11623, 11627, 223540, 223982, },
                [L["竞技场-修行者高罗什"]] = { 11726, 22271, 22257, 22266, },
                [L["竞技场-格里兹尔"]] = { 223544, 11703, 22270, 11702, },
                [L["竞技场-剜眼者"]] = { 223987, 11679, 11686, 11730, },
                [L["竞技场-破坏者奥科索尔"]] = { 11665, 11662, 223985, 11728, },
                [L["竞技场-阿努希尔"]] = { 11678, 223986, 11675, 11731, },
                [L["竞技场-爬行者赫杜姆"]] = { 11633, 223984, 11635, 11729, },
                [L["控火师罗格雷恩"]] = { 223981, 223980, 11748, 223538, },
                [L["黑色宝库"]] = { 22256, 22205, 22255, 22254, 11923, },
                [L["典狱官斯迪尔基斯"]] = { 223983, 11782, 22241, 11783, },
                [L["维雷克"]] = { 11755, 22242, },
                [L["卫兵杜格瑞普"]] = { 22205, 22255, 22256, 22254, },
                [L["弗诺斯・达克维尔"]] = { 11839, 22223, 11842, 11841, },
                [L["伊森迪奥斯"]] = { 11766, 11764, 11765, 11767, 19268, 11768, },
                [L["贝尔加"]] = { 11807, 11802, 11805, 11803, },
                [L["安格弗将军"]] = { 11820, 11821, 11810, 227940, 227948, 11841, },
                [L["傀儡统帅阿格曼奇"]] = { 227964, 227965, 11669, 227967, },
                [L["黑铁酒吧-霍尔雷・黑须"]] = { 11735, 18043, 22275, 18044, },
                [L["黑铁酒吧-普拉格"]] = { 12793, 12791, },
                [L["黑铁酒吧-方阵"]] = { 22212, 11745, 11744, 11743, },
                [L["弗莱拉斯大使"]] = { 227973, 227970, 227971, 227972, 227934, },
                [BG.rareIcon .. L["无敌的潘佐尔"]] = { 22245, 11787, 11785, 11786, },
                [L["七贤"]] = { 227958, 227956, 11929, 227959, 227941, 11923, 227963, 227960, },
                [L["玛格姆斯"]] = { 11746, 227978, 22395, 22400, 227974, },
                [L["铁炉堡公主茉艾拉・铜须"]] = { 12557, 12554, 12556, 12553, },
                [L["达格兰・索瑞森大帝"]] = { 227991, 227988, 227985, 227980, 227986, 227987, 11934, 228722, 227984, 227981, 227982, },
                [L["小怪"]] = { 12549, 12552, 12551, 12542, 12546, 12550, 12547, 12555, 12527, 12531, 12535, 12528, 12532, },
                [BG.STC_y1(QUESTS_LABEL)] = { 12113, 12114, 12112, 12115, 11865, 11963, 12049, 11962, 11866,
                    11964, 12000, 12066, 12082, 12083, },
            }

            if BG.IsAlliance then
                BG.Loot[FB].Team[FB_5][BG.STC_y1(FACTION_ALLIANCE .. QUESTS_LABEL)] = {
                    12018, 12021, 12041, 12061, 12062, 12065, 12548, 12543,
                }
            else
                BG.Loot[FB].Team[FB_5][BG.STC_y1(FACTION_HORDE .. QUESTS_LABEL)] = {
                    12544, 12545, 12038, 12059, 12109, 12110, 12108, 12111,
                }
            end
        end
    end

    -- P5
    do
        local FB = "ZUGsod"
        do
            BG.Loot[FB].N.boss1 = { 19721, 19724, 19723, 19722, 19717, 19716, 19718, 19719, 19720, 230911, 230913, 230912, 230916, 230914, 230915, 232299, 230854, 230855, 230862, 230857, 230858, 230860, 230859, 230861, 230856, 230863, }
            BG.Loot[FB].N.boss2 = { 19721, 19724, 19723, 19722, 19717, 19716, 19718, 19719, 19720, 230864, 230865, 232311, 230866, 230867, 230868, 230854, 230855, 230862, 230857, 230858, 230860, 230859, 230861, 230856, 230863, }
            BG.Loot[FB].N.boss3 = { 19721, 19724, 19723, 19722, 19717, 19716, 19718, 19719, 19720, 230917, 230918, 230922, 230919, 230921, 230920, 230854, 230855, 230862, 230857, 230858, 230860, 230859, 230861, 230856, 230863, }
            BG.Loot[FB].N.boss4 = { 231512, 19721, 19724, 19723, 19722, 19717, 19716, 19718, 19719, 19720, 19872, 230993, 230989, 230992, 230991, 230996, 230998, 230995, 230997, 230994, 230999, 231000, 231001, }
            BG.Loot[FB].N.boss5 = { 231274, 231273, 19939, 231276, 231275, 19942, 232309, 231277, 19940, 231278, 231279, 19941, }
            BG.Loot[FB].N.boss6 = { 231014, 231016, 231271, 231272, 22739, }
            BG.Loot[FB].N.boss7 = { 19721, 19724, 19723, 19722, 19717, 19716, 19718, 19719, 19720, 19902, 230923, 230925, 230927, 230928, 230926, 230929, 230930, 230854, 230855, 230862, 230857, 230858, 230860, 230859, 230861, 230856, 230863, }
            BG.Loot[FB].N.boss8 = { 19721, 19724, 19723, 19722, 19717, 19716, 19718, 19719, 19720, 230934, 230939, 230942, 230943, 230941, 19914, 230854, 230855, 230862, 230857, 230858, 230860, 230859, 230861, 230856, 230863, }
            BG.Loot[FB].N.boss9 = { 231512, 19721, 19724, 19723, 19722, 19717, 19716, 19718, 19719, 19720, 231003, 231005, 231002, 231004, 231013, 231007, 231012, 231011, 231010, 231009, 231008, 231006, }
            BG.Loot[FB].N.boss10 = { 231512, 231300, 231305, 231303, 231299, 231306, 231307, 19802, 231308, 231302, 231289, 231296, 231309, 230992, 231293, 231301, 231315, }
            BG.Loot[FB].N.boss11 = { 20263, 20259, 20261, 19921, 19908, 20258, 19726, 19774, 19767, 19768, }
            BG.Loot[FB].N.boss1other = { 231319, 231317, 231318, 231323, 231321, 231322, 231327, 231326, 231325, 231329, 231331, 231330, 231335, 231333, 231334, 231339, 231337, 231338, 231343, 231341, 231342, 231349, 231347, 231348, 231353, 231351, 231352, }
            BG.Loot[FB].N.boss2other = { 231319, 231317, 231318, 231323, 231321, 231322, 231327, 231326, 231325, 231329, 231331, 231330, 231335, 231333, 231334, 231339, 231337, 231338, 231343, 231341, 231342, 231349, 231347, 231348, 231353, 231351, 231352, }
            BG.Loot[FB].N.boss3other = { 231319, 231317, 231318, 231323, 231321, 231322, 231327, 231326, 231325, 231329, 231331, 231330, 231335, 231333, 231334, 231339, 231337, 231338, 231343, 231341, 231342, 231349, 231347, 231348, 231353, 231351, 231352, }
            BG.Loot[FB].N.boss4other = { 231319, 231317, 231318, 231323, 231321, 231322, 231327, 231326, 231325, 231329, 231331, 231330, 231335, 231333, 231334, 231339, 231337, 231338, 231343, 231341, 231342, 231349, 231347, 231348, 231353, 231351, 231352, }
            BG.Loot[FB].N.boss5other = { 231284, 231283, 231282, 231287, 231280, 231288, 231281, 231286, 231285, }
            BG.Loot[FB].N.boss7other = { 231319, 231317, 231318, 231323, 231321, 231322, 231327, 231326, 231325, 231329, 231331, 231330, 231335, 231333, 231334, 231339, 231337, 231338, 231343, 231341, 231342, 231349, 231347, 231348, 231353, 231351, 231352, }
            BG.Loot[FB].N.boss8other = { 231319, 231317, 231318, 231323, 231321, 231322, 231327, 231326, 231325, 231329, 231331, 231330, 231335, 231333, 231334, 231339, 231337, 231338, 231343, 231341, 231342, 231349, 231347, 231348, 231353, 231351, 231352, }
            BG.Loot[FB].N.boss9other = { 231319, 231317, 231318, 231323, 231321, 231322, 231327, 231326, 231325, 231329, 231331, 231330, 231335, 231333, 231334, 231339, 231337, 231338, 231343, 231341, 231342, 231349, 231347, 231348, 231353, 231351, 231352, }
            BG.Loot[FB].N.boss10other = { 19950, 19949, 19948, }
            -- 兑换物
            BG.Loot[FB].ExchangeItems = {
                [19802] = { 19950, 19949, 19948, },
                -- []={},
                -- 祖格套装
                [19721] = { 231330, 231322, 231325, },
                [19724] = { 231321, 231337, 231333, },
                [19723] = { 231353, 231327, 231348, },
                [19722] = { 231329, 231341, 231317, },
                [19717] = { 231351, 231339, 231343, },
                [19716] = { 231331, 231323, 231326, },
                [19718] = { 231335, 231347, 231319, },
                [19719] = { 231352, 231338, 231342, },
                [19720] = { 231335, 231349, 231318, },
            }
        end

        local FB = "BWLsod"
        do
            BG.Loot[FB].N.boss1 = { 231729, 231720, 231712, 231722, 229352, 230237, 230238, 230240, 230239, 230241, 230242, }
            BG.Loot[FB].N.boss2 = { 231727, 231718, 231710, 230243, 230904, 231378, 230244, 230246, 230245, 230248, 230247, 230848, 230843, 230849, 230846, 230845, 232357, }
            BG.Loot[FB].N.boss3 = { 231730, 231721, 231713, 231452, 231882, 231995, 230249, 230250, 230251, 230252, 230253, 230254, 20383, }
            BG.Loot[FB].N.boss4 = { 231727, 231718, 231710, 230273, 230272, 230282, 230847, 230844, 230276, 230270, 230256, 230277, 230274, 230275, 230255, 230279, 230278, 230842, 230257, 230269, }
            BG.Loot[FB].N.boss5 = { 231728, 231719, 231711, 230280, 230269, 230256, 19407, 230255, 230725, 230726, 230271, 230270, 230281, 230257, 230269, 230736, 230282, 230256, 230733, 230255, 230735, 230842, 230734, 230257, 230737, 230738, 230844, 230847, 230270, }
            BG.Loot[FB].N.boss6 = { 231726, 231717, 231709, 231814, 229906, 230740, 230744, 230742, 230739, 230800, 230745, 230746, 230743, 230741, 230801, 230802, 230794, 230747, }
            BG.Loot[FB].N.boss7 = { 19003, 230838, 230837, 230818, 230813, 230812, 231803, 230804, 230806, 230805, 230808, 230811, 230810, 11938, 231726, 231717, 231709, 231731, 231723, 231714, 231727, 231718, 231710, 231724, 231715, 231707, 231729, 231720, 231712, 231730, 231721, 231713, 231725, 231716, 231708, 231728, 231719, 231711, }
            BG.Loot[FB].N.boss8 = { 230842, 230848, 230843, 230849, 230846, 230847, 230845, 232357, 230844, 18562, }
            BG.Loot[FB].N.boss1other = { 229910, 224122, 231222, 231060, 231069, 231206, 231179, 231198, 231214, 231188, 231195, 231028, 231042, 231050, 231248, 231036, 231232, 231240, 231256, 231091, 231102, 231110, 231166, 231073, 231156, }
            BG.Loot[FB].N.boss2other = { 229909, 229971, 229972, 224280, 231226, 231058, 231067, 231210, 231177, 231202, 231218, 231185, 231193, 231026, 231044, 231052, 231250, 231034, 231234, 231242, 231258, 231093, 231104, 231112, 231168, 231075, 231158, }
            BG.Loot[FB].N.boss3other = { 229749, 229806, 231754, 231755, 224279, 231890, 231228, 231061, 231070, 231212, 231180, 231204, 231220, 231189, 231196, 231029, 231041, 231049, 231247, 231037, 231231, 231239, 231255, 231090, 231101, 231109, 231165, 231072, 231155, }
            BG.Loot[FB].N.boss4other = { 231226, 231058, 231067, 231210, 231177, 231202, 231218, 231185, 231193, 231026, 231044, 231052, 231250, 231034, 231234, 231242, 231258, 231093, 231104, 231112, 231168, 231075, 231158, }
            BG.Loot[FB].N.boss5other = { 231227, 231059, 231068, 231211, 231178, 231203, 231219, 231186, 231194, 231027, 231043, 231051, 231249, 231035, 231233, 231241, 231257, 231092, 231103, 231111, 231167, 231074, 231157, }
            BG.Loot[FB].N.boss6other = { 224281, 224282, 231509, 231225, 231057, 231066, 231209, 231176, 231201, 231217, 231184, 231192, 231025, 231039, 231047, 231251, 231033, 231235, 231243, 231259, 231096, 231106, 231114, 231170, 231077, 231160, }
            BG.Loot[FB].N.boss7other = { 230840, 230839, 230841, 231213, 231221, 231181, 231205, 231229, 231187, 231197, 231062, 231071, 231038, 231246, 231030, 231230, 231238, 231254, 231040, 231048, 231076, 231169, 231095, 231159, 231105, 231113, 231207, 231215, 231174, 231199, 231223, 231182, 231190, 231055, 231063, 231031, 231253, 231023, 231237, 231245, 231261, 231046, 231054, 231079, 231172, 231098, 231162, 231107, 231115, 231208, 231216, 231175, 231200, 231224, 231183, 231191, 231056, 231065, 231032, 231252, 231024, 231236, 231244, 231260, 231045, 231053, 231078, 231171, 231097, 231161, 231100, 231108, 231222, 231060, 231069, 231206, 231179, 231198, 231214, 231188, 231195, 231028, 231042, 231050, 231248, 231036, 231232, 231240, 231256, 231091, 231102, 231110, 231166, 231073, 231156, 231226, 231058, 231067, 231210, 231177, 231202, 231218, 231185, 231193, 231026, 231044, 231052, 231250, 231034, 231234, 231242, 231258, 231093, 231104, 231112, 231168, 231075, 231158, 231228, 231061, 231070, 231212, 231180, 231204, 231220, 231189, 231196, 231029, 231041, 231049, 231247, 231037, 231231, 231239, 231255, 231090, 231101, 231109, 231165, 231072, 231155, 231227, 231059, 231068, 231211, 231178, 231203, 231219, 231186, 231194, 231027, 231043, 231051, 231249, 231035, 231233, 231241, 231257, 231092, 231103, 231111, 231167, 231074, 231157, 231225, 231057, 231066, 231209, 231176, 231201, 231217, 231184, 231192, 231025, 231039, 231047, 231251, 231033, 231235, 231243, 231259, 231096, 231106, 231114, 231170, 231077, 231160, }
            -- 兑换物
            BG.Loot[FB].ExchangeItems = {
                -- 职业任务
                [231722] = { 229910, },
                [229352] = { 224122, },
                [230904] = { 229909, 229971, 229972, },
                [231378] = { 224280, },
                [231452] = { 229749, 229806, },
                [231882] = { 231754, 231755, },
                [231995] = { 224279, 231890, },
                [231814] = { 224281, 224282, },
                [229906] = { 231509, },

                -- 奈法头
                [19003] = { 230840, 230839, 230841, },
                -- [ ]={ },
                -- [ ]={ },

                -- T2手
                [231729] = { 231222, 231060, 231069, 231206, 231179, 231198, 231214, 231188, 231195, },
                [231720] = { 231028, 231042, 231050, 231248, 231036, 231232, 231240, 231256, },
                [231712] = { 231091, 231102, 231110, 231166, 231073, 231156, },

                -- T2腿
                [231727] = { 231226, 231058, 231067, 231210, 231177, 231202, 231218, 231185, 231193, },
                [231718] = { 231026, 231044, 231052, 231250, 231034, 231234, 231242, 231258, },
                [231710] = { 231093, 231104, 231112, 231168, 231075, 231158, },

                -- T2鞋
                [231730] = { 231228, 231061, 231070, 231212, 231180, 231204, 231220, 231189, 231196, },
                [231721] = { 231029, 231041, 231049, 231247, 231037, 231231, 231239, 231255, },
                [231713] = { 231090, 231101, 231109, 231165, 231072, 231155, },

                -- T2头
                [231728] = { 231227, 231059, 231068, 231211, 231178, 231203, 231219, 231186, 231194, },
                [231719] = { 231027, 231043, 231051, 231249, 231035, 231233, 231241, 231257, },
                [231711] = { 231092, 231103, 231111, 231167, 231074, 231157, },

                -- T2肩
                [231726] = { 231225, 231057, 231066, 231209, 231176, 231201, 231217, 231184, 231192, },
                [231717] = { 231025, 231039, 231047, 231251, 231033, 231235, 231243, 231259, },
                [231709] = { 231096, 231106, 231114, 231170, 231077, 231160, },

                -- T2胸
                [231731] = { 231213, 231221, 231181, 231205, 231229, 231187, 231197, 231062, 231071, },
                [231723] = { 231038, 231246, 231030, 231230, 231238, 231254, 231040, 231048, },
                [231714] = { 231076, 231169, 231095, 231159, 231105, 231113, },

                -- T2手腕
                [231724] = { 231207, 231215, 231174, 231199, 231223, 231182, 231190, 231055, 231063, },
                [231715] = { 231031, 231253, 231023, 231237, 231245, 231261, 231046, 231054, },
                [231707] = { 231079, 231172, 231098, 231162, 231107, 231115, },

                -- T2腰带
                [231725] = { 231208, 231216, 231175, 231200, 231224, 231183, 231191, 231056, 231065, },
                [231716] = { 231032, 231252, 231024, 231236, 231244, 231260, 231045, 231053, },
                [231708] = { 231078, 231171, 231097, 231161, 231100, 231108, },
            }
        end
    end

    -- 世界boss
    do
        local FB = "Worldsod"
        do
            BG.Loot[FB].N.boss1 = { 18423, 18705, 228759, 17078, 18813, 228298, 228955, 17068, 17075, 228166, 228162, 228165, 228163, 228188, 228992, 15410, 11938, 227532, 227755, 227764, 227537, 227752, 227762, 227535, 227758, 227766, 227533, 227756, 227759, 227531, 227750, 227760, 227530, 227751, 227761, 227534, 227754, 227763, 227536, 227757, 227765, }
            BG.Loot[FB].N.boss2 = { 228385, 228389, 228383, 228340, 228345, 228384, 228381, 228382, 228349, 228347, 18704, 11938, }
            BG.Loot[FB].N.boss3 = { 228353, 228354, 228360, 228357, 228351, 228355, 228352, 228359, 228397, 228356, 18665, 11938, }
            BG.Loot[FB].N.boss4 = { 231725, 231716, 231708, 19018, 231782, 231783, 231785, 231815, 231784, 231753, 231777, 231387, 231781, 231823, 231817, 231779, }
            BG.Loot[FB].N.boss1other = { 228685, 228687, 228686, 226559, 226563, 226575, 226582, 226548, 216924, 221785, 226656, 226447, 226661, 226675, 226473, 226489, 226494, 226610, 226602, 226617, 226595, 226627, 226635, 226619, 226534, 226535, 226560, 226566, 226550, 216925, 226576, 226581, 226588, 221783, 226611, 226605, 226632, 226640, 226624, 226527, 226543, 226644, 226653, 226444, 226665, 226674, 226478, 226491, 226492, 226556, 226569, 226552, 216921, 226572, 226585, 226591, 226600, 226615, 226608, 226629, 226637, 226621, 226528, 226540, 226648, 226654, 226441, 226664, 226669, 226475, 226486, 226497, 226646, 226651, 226445, 226666, 226671, 226479, 226490, 226493, 226594, 226598, 226614, 226606, 226631, 226639, 226623, 226532, 226537, 226561, 226565, 226547, 216923, 226574, 226583, 226645, 226652, 226443, 226663, 226673, 226477, 226487, 226496, 226593, 226601, 226613, 226609, 226628, 226636, 226620, 226531, 226538, 226557, 226568, 226554, 216918, 226571, 226586, 226562, 226564, 226549, 216922, 226573, 226584, 226647, 226658, 226446, 226659, 226670, 226480, 226488, 226495, 226590, 226599, 226612, 226630, 226638, 226622, 226533, 226536, 226655, 226662, 226442, 226668, 226649, 226476, 226484, 226499, 226589, 226596, 226618, 226603, 226634, 226642, 226626, 226530, 226541, 226558, 226567, 226553, 216920, 226578, 226579, 226555, 226570, 226551, 216919, 226577, 226580, 226592, 226597, 226616, 226604, 226633, 226641, 226625, 226529, 226542, 226657, 226660, 226440, 226667, 226650, 226474, 226485, 226498, }
            BG.Loot[FB].N.boss4other = { 231208, 231216, 231175, 231200, 231224, 231183, 231191, 231056, 231065, 231032, 231252, 231024, 231236, 231244, 231260, 231045, 231053, 231078, 231171, 231097, 231161, 231100, 231108, }

            -- 兑换物
            BG.Loot[FB].ExchangeItems = {
                [18423] = { 228685, 228687, 228686, }, -- 黑龙

                -- T2腰带
                [231725] = { 231208, 231216, 231175, 231200, 231224, 231183, 231191, 231056, 231065, },
                [231716] = { 231032, 231252, 231024, 231236, 231244, 231260, 231045, 231053, },
                [231708] = { 231078, 231171, 231097, 231161, 231100, 231108, },

                -- T1 胸
                [227535] = { 226559, 226563, 226575, 226582, 226548, 216924, },
                [227766] = { 221785, 226656, 226447, 226661, 226675, 226473, 226489, 226494, },
                [227758] = { 226610, 226602, 226617, 226595, 226627, 226635, 226619, 226534, 226535, },

                -- T1肩膀
                [227537] = { 226560, 226566, 226550, 216925, 226576, 226581, },
                [227752] = { 226588, 221783, 226611, 226605, 226632, 226640, 226624, 226527, 226543, },
                [227762] = { 226644, 226653, 226444, 226665, 226674, 226478, 226491, 226492, },

                -- T1手
                [227533] = { 226556, 226569, 226552, 216921, 226572, 226585, },
                [227756] = { 226591, 226600, 226615, 226608, 226629, 226637, 226621, 226528, 226540, },
                [227759] = { 226648, 226654, 226441, 226664, 226669, 226475, 226486, 226497, },

                -- T1护腕
                [227531] = { 226558, 226567, 226553, 216920, 226578, 226579, },
                [227750] = { 226589, 226596, 226618, 226603, 226634, 226642, 226626, 226530, 226541, },
                [227760] = { 226655, 226662, 226442, 226668, 226649, 226476, 226484, 226499, },

                -- T1腰带
                [227530] = { 226555, 226570, 226551, 216919, 226577, 226580, },
                [227751] = { 226592, 226597, 226616, 226604, 226633, 226641, 226625, 226529, 226542, },
                [227761] = { 226657, 226660, 226440, 226667, 226650, 226474, 226485, 226498, },

                -- T1腿
                [227534] = { 226561, 226565, 226547, 216923, 226574, 226583, },
                [227754] = { 226594, 226598, 226614, 226606, 226631, 226639, 226623, 226532, 226537, },
                [227763] = { 226646, 226651, 226445, 226666, 226671, 226479, 226490, 226493, },

                -- T1鞋
                [227536] = { 226557, 226568, 226554, 216918, 226571, 226586, },
                [227757] = { 226593, 226601, 226613, 226609, 226628, 226636, 226620, 226531, 226538, },
                [227765] = { 226645, 226652, 226443, 226663, 226673, 226477, 226487, 226496, },

                -- T1头
                [227532] = { 226562, 226564, 226549, 216922, 226573, 226584, },
                [227764] = { 226647, 226658, 226446, 226659, 226670, 226480, 226488, 226495, },
                [227755] = { 226590, 226599, 226612, 226630, 226638, 226622, 226533, 226536, },
            }
        end
    end
end

-- 声望装备
do
    -- P1
    do
        local FB = "BD"
        if BG.IsAlliance then
            -- 战歌
            BG.Loot[FB].Faction = {
                ["890:2"] = { 21568, 21566, },
                ["890:3"] = { 20444, 20428, 20431, 20439, },
                ["890:4"] = { 212580, 212581, 212582, 212583, },
            }
        end
        if BG.IsHorde then
            -- 战歌
            BG.Loot[FB].Faction = {
                ["889:2"] = { 21568, 21566, },
                ["889:3"] = { 20442, 20427, 20426, 20429, },
                ["889:4"] = { 212584, 212585, 212586, 212587, },
            }
        end
    end
    -- P2
    do
        local FB = "Gno"
        if BG.IsAlliance then
            BG.Loot[FB].Faction = {
                -- 战歌
                ["890:2"] = { 21567, 21565, },
                ["890:3"] = { 19541, 19533, 19525, 19517, 19540, 19532, 19524, 19515, },
                ["890:4"] = { 19564, 19548, 19556, 19572, },
                ["890:5"] = { 19597, 19590, 19584, 19581, },

                -- 阿拉希
                ["509:2"] = { 21119, 21118, },
                ["509:3"] = { 20099, 20117, 20105, 20090, 20108, 20126, 20098, 20116, 20104, 20089, 20107, 20125, },
                ["509:4"] = { 20096, 20114, 20102, 20093, 20111, 20129, 20095, 20113, 20101, 20092, 20110, 20128, },
            }
        end
        if BG.IsHorde then
            -- 阿拉希
            BG.Loot[FB].Faction = {
                -- 战歌
                ["889:2"] = { 21567, 21565, },
                ["889:3"] = { 19537, 19529, 19521, 19513, 19536, 19528, 19520, 19512, },
                ["889:4"] = { 19560, 19544, 19552, 19568, },
                ["889:5"] = { 19597, 19590, 19584, 19581, },

                -- 阿拉希
                ["510:2"] = { 21120, 21116, },
                ["510:3"] = { 20164, 20191, 20172, 20152, 20197, 20207, 20166, 20192, 20173, 20153, 20198, 20206, },
                ["510:4"] = { 20162, 20188, 20169, 20157, 20201, 20210, 20161, 20187, 20168, 20156, 20200, 20209, },
            }
        end
    end
    -- P3
    do
        local FB = "Temple"
        if BG.IsAlliance then
            BG.Loot[FB].Faction = {
                -- 战歌
                ["890:2"] = {},
                ["890:3"] = { 19539, 19531, 19523, 19516, },
                ["890:4"] = { 19563, 19547, 19555, 19571, },
                ["890:5"] = { 19596, 19589, 19583, 19580, },

                -- 阿拉希
                ["509:2"] = { 21117, },
                ["509:3"] = { 20097, 20115, 20103, 20088, 20106, 20124, 20089, 20107, 20125, },
                ["509:4"] = { 20094, 20112, 20100, 20091, 20109, 20127, 20092, 20110, 20128, },
            }
        end
        if BG.IsHorde then
            -- 阿拉希
            BG.Loot[FB].Faction = {
                -- 战歌
                ["889:2"] = {},
                ["889:3"] = { 19535, 19527, 19519, 19511, },
                ["889:4"] = { 19559, 19543, 19551, 19567, },
                ["889:5"] = { 19596, 19589, 19583, 19580, },

                -- 阿拉希
                ["510:2"] = { 21115, },
                ["510:3"] = { 20165, 20193, 20174, 20151, 20196, 20205, 20153, 20198, 20206, },
                ["510:4"] = { 20160, 20189, 20170, 20155, 20202, 20211, 20156, 20200, 20209, },
            }
        end

        local factionID = 2641
        BG.Loot[FB].Faction[factionID .. ":2"] = { 224004, 224005, 224006, 221362, 221381, 221411, 221392, 221431, 223648, 221386, 221369, 221378, 221432, 221400, 221407, 221374, 221424, 221379, 221416, 221427, 221399, 221393, 221383, 221389, 221394, 221387, 221436, 221409, 221426, 221405, 221403, 221412, 221396, 221421, 221415, 221438, 221420 }
        BG.Loot[FB].Faction[factionID .. ":3"] = { 213407, 221376, 221391, 221408, 221193, 221380, 221425, 221430, 221377, 221406, 221384, 221434, 221390, 221413, 221437, 221382, 221402, 221422, 221410, 221388, 221419, 221385, 221397, 221401, 221417, 221395, 221429, 221423, 221404, 221414, 221398, 221435 }
        BG.Loot[FB].Faction[factionID .. ":4"] = { 221441, 220649, 221439 }
        BG.Loot[FB].Faction[factionID .. ":5"] = { 220621, 221442, 221440, 221443 }
    end
    -- P4
    do
        local FB = "MCsod"
        if BG.IsAlliance then
            BG.Loot[FB].Faction = {
                -- 战歌
                ["890:5"] = { 19595, 19587, 19582, 19578, },

                -- 阿拉希
                ["509:5"] = { 20061, 20060, 20059, 20055, 20058, 20057, 20073, 20070, 20069, },

                -- 奥山
                ["730:2"] = {},
                ["730:3"] = { 19098, 19097, 19086, 19084, 19094, 19093, 19092, 19091, },
                ["730:4"] = { 19100, 19104, 19102, },
                ["730:5"] = { 19312, 19315, 19308, 19311, 19309, 19310, 19325, 21563, 19321, 19324, 19323, },
            }
        end
        if BG.IsHorde then
            -- 阿拉希
            BG.Loot[FB].Faction = {
                -- 战歌
                ["889:5"] = { 19595, 19587, 19582, 19578, 22747, 22740, 22741, 22673, 22676, 22651, },

                -- 阿拉希
                ["510:5"] = { 20176, 20175, 20194, 20158, 20203, 20212, 20068, 20214, 20220, },

                -- 奥山
                ["729:2"] = {},
                ["729:3"] = { 19096, 19095, 19085, 19083, 19090, 19089, 19088, 19087, },
                ["729:4"] = { 19099, 19103, 19101, },
                ["729:5"] = { 19312, 19315, 19308, 19311, 19309, 19310, 19325, 21563, 19321, 19324, 19323, },
            }
        end
        -- 木喉要塞
        local factionID = 576
        BG.Loot[FB].Faction[factionID .. ":2"] = { 227804, 227803, }
        BG.Loot[FB].Faction[factionID .. ":3"] = { 227807, 227805, 228190, }
        BG.Loot[FB].Faction[factionID .. ":4"] = { 227808, 227809, 227810, }
        BG.Loot[FB].Faction[factionID .. ":5"] = { 21326, }
        -- 银色黎明
        local factionID = 529
        BG.Loot[FB].Faction[factionID .. ":3"] = { 227816, 227815, 227814, }
        BG.Loot[FB].Faction[factionID .. ":4"] = { 227888, 227818, 227817, }
        -- 瑟银兄弟会
        local factionID = 59
        BG.Loot[FB].Faction[factionID .. ":2"] = { 227823, 227821, 227822, 227820, }
        BG.Loot[FB].Faction[factionID .. ":3"] = { 227830, 227831, 227828, 227827, 227829, 227824, 227826, 227825, }
        BG.Loot[FB].Faction[factionID .. ":4"] = { 227839, 227837, 227834, 227838, 227835, 227836, 227832, 227833, }
        BG.Loot[FB].Faction[factionID .. ":5"] = { 227842, 227840, 227843, 228929, 228924, 228927, 228926, 228925, 228928, }
        -- 海达希亚水元素
        local factionID = 749
        BG.Loot[FB].Faction[factionID .. ":5"] = { 227915, }

        --                 -- 银色黎明
        -- local factionID = 529
        -- BG.Loot[FB].Faction[factionID .. ":2"] = {}
        -- BG.Loot[FB].Faction[factionID .. ":3"] = {}
        -- BG.Loot[FB].Faction[factionID .. ":4"] = {}
        -- BG.Loot[FB].Faction[factionID .. ":5"] = {}
    end
end

-- PVP
do
    -- P1
    do
        local FB = "BD"
        if BG.IsAlliance then
            BG.Loot[FB].PVP = {
                ["Alliance:2"] = { 18854, 18856, 18857, 18858, 18862, 18863, 18864, 18859 }, -- 徽记
                ["Alliance:3"] = { 213087 },                                                 -- 中士的披风
            }
        end
        if BG.IsHorde then
            BG.Loot[FB].PVP = {
                ["Horde:2"] = { 18834, 18846, 18849, 18852, 18851, 18853, 18845, 18850 }, -- 徽记
                ["Horde:3"] = { 213088 },                                                 -- 中士的披风
            }
        end
    end

    -- P2
    do
        local FB = "Gno"
        if BG.IsAlliance then
            BG.Loot[FB].PVP = {
                ["Alliance:2"] = { 18854, 18856, 18857, 18858, 18862, 18863, 18864, 18859 }, -- 徽记
                ["Alliance:3"] = { 213087, 18440 },                                          -- 中士的披风
                ["Alliance:4"] = { 18442 },                                                  -- 军士长的徽记
                ["Alliance:5"] = { 216938, 216701, 216702, 216698, 216699, 216700, },        -- 新徽记、士官长护腕
            }
        end
        if BG.IsHorde then
            BG.Loot[FB].PVP = {
                ["Horde:2"] = { 18834, 18846, 18849, 18852, 18851, 18853, 18845, 18850 },
                ["Horde:3"] = { 213088, 18427 },
                ["Horde:4"] = { 15200 },
                ["Horde:5"] = { 216939, 216703, 216704, 216705, 216706, 216707 },
            }
        end
    end

    -- P3
    do
        local FB = "Temple"
        if BG.IsAlliance then
            BG.Loot[FB].PVP = {
                ["Alliance:2"] = { 18854, 18856, 18857, 18858, 18862, 18863, 18864, 18859 }, -- 徽记
                ["Alliance:3"] = { 18441, },                                                 -- 中士的披风
                ["Alliance:4"] = { 18444, },                                                 -- 军士长的徽记
                ["Alliance:5"] = { 216938, 216701, 216702, 216698, 216699, 216700,           -- 新徽记、士官长护腕
                    220806, 220799, 220812, 220811, 220817, 220814, 223076, 223077, 220829, 220837, 220856, 220860, 220880, 220884, 220866, 220862, 220890, 220891, 220897, 220895, },
                ["Alliance:6"] = { 220892, 220893, 220886, 220888, 220868, 220864, 220878, 220882, 220854, 220858, 220828, 220832, 223078, 223074, 220815, 220816, 220813, 220809, 220794, 220797, },
                ["Alliance:7"] = { 220896, 220894, 220889, 220887, 220872, 220870, 220874, 220876, 220850, 220852, 220822, 220825, 223075, 223073, 220819, 220818, 220810, 220808, 220804, 220795, },
            }
        end
        if BG.IsHorde then
            BG.Loot[FB].PVP = {
                ["Horde:2"] = { 18834, 18846, 18849, 18852, 18851, 18853, 18845, 18850 },
                ["Horde:3"] = { 16341, },
                ["Horde:4"] = { 18428, },
                ["Horde:5"] = { 216939, 216703, 216704, 216705, 216706, 216707,
                    220898, 220900, 220908, 220909, 220881, 220885, 220867, 220863, 220857, 220861, 220830, 220836, 220831, 220835, 220845, 220846, 220843, 220840, 220807, 220800, },
                ["Horde:6"] = { 220903, 220902, 220904, 220906, 220879, 220883, 220869, 220865, 220855, 220859, 220827, 220833, 220826, 220834, 220844, 220847, 220838, 220839, 220801, 220798, },
                ["Horde:7"] = { 220899, 220901, 220907, 220905, 220875, 220877, 220873, 220871, 220851, 220853, 220821, 220824, 220820, 220823, 220848, 220849, 220842, 220841, 220803, 220796, },
            }
        end
    end
end

-- 专业制造
do
    -- P1
    local FB = "BD"
    BG.Loot[FB].Profession = {
        ["锻造"] = { 2870, 210794, 210773, },
        ["制皮"] = { 6468, 4253, 211423, 211502, },
        ["裁缝"] = { 4320, 210795, 210781, 215366, 215365 },
    }
    -- P2
    local FB = "Gno"
    BG.Loot[FB].Profession = {
        ["锻造"] = { 215161, 215167, 217273, 217275, 217277, 217279, 217281, 217283, 217285, 3836, 3840, 3842, 3844, 3846, 3849, 3850, 3851, 3852, 3854, 3855, 3856, 7913, 7914, 7915, 7916, 7917, 7918, 7919, 7920, 7921, 7924, 7941, 7942, 7943, 7963, 10423, 12259, 12260, 17704, },
        ["制皮"] = { 215114, 215166, 215381, 215382, 217259, 217261, 217263, 217265, 217267, 217268, 217270, 4255, 4256, 4257, 4259, 4262, 4264, 4455, 4456, 5782, 5783, 5963, 5964, 5965, 7373, 7374, 7375, 7377, 7378, 7386, 7387, 7390, 7391, 8174, 8175, 8176, 8192, 8198, 8203, 8204, 8205, 17721, 18238, 18948, },
        ["裁缝"] = { 215111, 215365, 215366, 217245, 217246, 217247, 217248, 217250, 217252, 217253, 217255, 217256, 217257, 4323, 4327, 4328, 4329, 7052, 7053, 7054, 7056, 7057, 7060, 7064, 7065, 10001, 10002, 10003, 10004, 10007, 10008, 10009, 10018, 10019, 10021, 10023, 10042, },
        ["工程"] = { 213390, 215115, 4393, 10499, 10500, 10501, 10502, 10508, 10510, 10518, },
        ["附魔"] = { 217287, },
    }
    -- P3
    local FB = "Temple"
    BG.Loot[FB].Profession = {
        ["锻造"] = { 220738, 220740, 220739, 8708, 10418, 7947, 12774, 12773, 7946, 7954, 7945, 11608, 7961, 7944, 7960, 7959, 7931, 7932, 12624, 12415, 7929, 12416, 7937, 7934, 12428, 7928, 12405, 7939, 7935, 7930, 7936, 7933, 7938, 7927, 7926, 12424, 12406, 12425, 12408, },
        ["制皮"] = { 220747, 220742, 220744, 220748, 220745, 220743, 15045, 15046, 8367, 8347, 8215, 8216, 15064, 8349, 8211, 15073, 15071, 8213, 8197, 15091, 15074, 15083, 8346, 8348, 8345, 8214, 15057, 15054, 8212, 8202, 8193, 15061, 15067, 8210, 15092, 15084, },
        ["裁缝"] = { 220749, 220751, 220750, 14141, 14100, 14042, 13857, 13858, 13868, 13869, 14103, 14134, 13860, 10041, 10025, 10033, 10030, 10024, 10029, 10028, 10027, 10044, 10031, 10026, 13863, 14101, 14142, 14043, 13870, 14107, 14132, 14143, 13856, },
        ["工程"] = { 221025, 221027, 221026, 10721, 7189, 10724, 15999, 10504, 10588, 10726, 10503, 10506, 10545, 10542, 10543, 18637, 18634, 10576, 10727, 10645, 10725, 10587, 10720, 10716, 16004, 15995, },
        ["附魔"] = { 11811 },
    }
    -- P4
    local FB = "MCsod"
    BG.Loot[FB].Profession = {
        ["锻造"] = { 19210, 19211, 19212, 20040, 16988, 19164, 17013, 19166, 19167, 16989, 19148, 17015, 17016, 17014, 19057, 19051, 19048, 19043, 227884, 12798, 19169, 227845, 11607, 12775, 227886, 22384, 12792, 227881, 227684, 227858, 227880, 227850, 227887, 12777, 228125, 227857, 227872, 12417, 22191, 227876, 11606, 12419, 227870, 12418, 12420, 22195, 20551, 12620, 12640, 12612, 12633, 12427, 12410, 19695, 12610, 11605, 227859, 22669, 19693, 20550, 12618, 12613, 12422, 227871, 12628, 227841, 12426, 12409, 22670, 20549, 227885, 12631, 19694, 12619, 12614, 12429, 12414, 22764, 22197, 22671, },
        ["制皮"] = { 19163, 19162, 19157, 19149, 16984, 16983, 16982, 19058, 19052, 19049, 15065, 19044, 18510, 227854, 227869, 15138, 15090, 15068, 15085, 15059, 15066, 15075, 227868, 15056, 18506, 21278, 15070, 227848, 15094, 15086, 227847, 15095, 15087, 15069, 15060, 15072, 15096, 227866, 15058, 227882, 15088, 15093, 15047, 227851, 227875, 227878, 15080, 227852, 227874, 15079, 15081, 227853, 227873, 15082, 227883, },
        ["裁缝"] = { 19165, 16980, 19156, 16979, 19059, 19056, 19050, 19047, 18413, 227863, 14130, 13866, 14111, 14112, 13867, 14139, 14152, 14154, 14153, 227861, 14106, 14128, 227860, 14136, 20537, 14108, 227862, 13864, 18409, 18407, 18408, 14146, 20538, 227864, 14104, 14144, 13865, 13871, 14045, 20539, 228476, 18263, },
        ["工程"] = { 18168, 16009, 16008, 16022, 18639, 18638, 227849, 16007, },
        ["附魔"] = {},
    }
    -- P5
    local FB = "BWLsod"
    BG.Loot[FB].Profession = {
        ["锻造"] = { 19690, 19693, 19691, 19694, 19692, 19695, },
        ["制皮"] = { 19685, 19688, 19686, 19689, 19687, },
        ["裁缝"] = { 19682, 19683, 19684, },
        ["工程"] = { 19999, 19998, },
        ["附魔"] = {},
    }
    BG.Loot.ZUGsod.Profession = BG.Loot.BWLsod.Profession
end

-- 野外任务
do
    -- P1
    do
        local FB = "BD"
        -- 专业
        BG.Loot[FB].Quest.Profession1 = {
            FBname = L["锻造/制皮/裁缝"],
            color = BG.y1,
        }
        BG.Loot[FB].Quest.Profession1.itemID = { 211420 }
    end
    -- P2
    do
        local FB = "Gno"
        BG.Loot[FB].Quest.FS = {
            FBname = "",
            color = BG.y1,
            classID = 8,
            itemID = { 7514, 7513, 11263, }
        }
        if classFilename == "MAGE" then
            tinsert(BG.Loot[FB].Quest.FS.itemID, 217497)
        end
        BG.Loot[FB].Quest.ZS = {
            FBname = "",
            color = BG.y1,
            classID = 1,
            itemID = { 6975, 6977, 6976 }
        }
        BG.Loot[FB].Quest.SS = {
            FBname = "",
            color = BG.y1,
            classID = 9,
            itemID = { 6900, 15108, 15107 }
        }
        if BG.IsHorde then
            BG.Loot[FB].Quest.horde = {
                FBname = "",
                color = BG.y1,
                faction = 2,
                itemID = { 18585, 18586, }
            }
        end
    end
    -- P3
    do
        local FB = "Temple"
        if classFilename == "MAGE" then
            BG.Loot[FB].Quest[classFilename] = {
                FBname = "",
                color = BG.y1,
                classID = classID,
                itemID = { 221344, }
            }
        elseif classFilename == "DRUID" then
            BG.Loot[FB].Quest[classFilename] = {
                FBname = "",
                color = BG.y1,
                classID = classID,
                itemID = { 219326, }
            }
        elseif classFilename == "WARRIOR" then
            BG.Loot[FB].Quest[classFilename] = {
                FBname = "",
                color = BG.y1,
                classID = classID,
                itemID = { 219223, }
            }
        elseif classFilename == "PALADIN" then
            BG.Loot[FB].Quest[classFilename] = {
                FBname = "",
                color = BG.y1,
                classID = classID,
                itemID = { 221518, }
            }
        elseif classFilename == "HUNTER" then
            BG.Loot[FB].Quest[classFilename] = {
                FBname = "",
                color = BG.y1,
                classID = classID,
                itemID = { 219345, }
            }
        elseif classFilename == "ROGUE" then
            BG.Loot[FB].Quest[classFilename] = {
                FBname = "",
                color = BG.y1,
                classID = classID,
                itemID = { 219343, }
            }
        elseif classFilename == "WARLOCK" then
            BG.Loot[FB].Quest[classFilename] = {
                FBname = L["小鬼探险"],
                color = BG.y1,
                classID = classID,
                itemID = { 221518, 223214, 223218 }
            }
        end

        BG.Loot[FB].Quest.Profession1 = {
            FBname = "",
            color = BG.y1,
        }
        BG.Loot[FB].Quest.Profession1.itemID = { 220689 }
    end
end

-- 世界掉落
do
    -- P1
    local FB = "BD"
    BG.Loot[FB].World = { 12978, 12977, 5183, 12982, 12979, 12988, 12987, 12985, 6332, 2879, 12996, 12994,
        2911, 12997, 2059, 1121, 12999, 12998, 13010, 2800, 13012, 13011, 13031, 13005, 720, 13131, 13099,
        13097, 13114, 13094, 13079, 1717, 12976, 12975, 5423, 935, 13136, 12984, 12983, 12989, 12992, 12990,
        2256, 890, 3021, 2236, 2194, 13041, 13016, 4454, 4446, 2011, 13062, 13032, 2098, 1493, 13057, 3203,
        13024, 2878 }
    -- P2
    local FB = "Gno"
    BG.Loot[FB].World = {
        -- 武器
        873, 2825, 2164, 1982, 870, 869, 868,
        6327, 13026, 13138, 9359, 13064, 13034, 13038, 8223, 1602, 13045, 1722, 2912,
        2815, 2299, 937, 934, 13020, 12974, 1265, 13051, 8006, 13137, 13033, 6331, 9378, 13037, 13042,
        13049, 936, 13063, 7753, 9385, 13054, 13048, 13019, 13017, 791, 13058, 2877,
        13025, 1726,
        -- 护甲
        867, 1980, 1204, 14549, 1981,
        5257, 1718, 1716, 2278, 2721, 9375, 13095, 13117, 2951, 13108, 2276, 13071, 2802, 13110, 13068,
        13129, 13084, 2277, 1713, 13029, 13087, 9434, 13100, 13132, 13115, 1678, 13145, 13127,
        13081, 13121, 1714, 13093, 13088, 2565, 3020, 13199, 9435, 13103, 13106, 1715, 9395,
        9405, 13119, 13124, 13105,
    }
    -- P3
    local FB = "Temple"
    BG.Loot[FB].World = {
        -- 史诗
        14551, 871, 2291, 942, 943, 2100, 809, 2163, 2824, 812, 2915, 810, 940, 3075, 1979, 1315, 14552,
        1169, 1447, 17007,
        -- 精良
        13018, 13102, 8190, 7734, 11302, 13052, 13022, 6660, 4091, 13014, 13030, 13039, 13067, 13066,
        13089, 13074, 13125, 13043, 754, 13139, 1607, 13122, 4090, 13008, 10623, 10627, 13073, 13120,
        1203, 13027, 13134, 9433, 13009, 13059, 13055, 1720, 13046, 13065, 13112, 2564, 13076, 13035,
        10634, 13021, 13128, 13144, 13082, 13109, 13126, 5266, 1721, 13111, 13085,
        223256, 223262, 223263, 223249, 223251, 223250, 223248,
    }
end

-- 货币
do
    -- 赛季服货币/牌子
    local function AddDB(FB, get, itemID, count, coin, color, type)
        if type then
            GetItemInfo(count)
        end

        get = get or ""
        count = count or ""
        coin = coin or ""
        type = type or ""

        tinsert(BG.Loot[FB].Sod_Currency, {
            [itemID] = get .. "-" .. count .. "-" .. coin .. "-" .. color .. "-" .. type
        })
    end
    -- 血月
    do
        -- P2
        local FB = "Gno"
        local get = L["荆棘谷 血月活动"]
        local coin = 133786
        local color = "FF6347"
        AddDB(FB, get, 216621, 2, coin, color)
        AddDB(FB, get, 216620, 2, coin, color)
        AddDB(FB, get, 216623, 2, coin, color)
        AddDB(FB, get, 216622, 2, coin, color)
        AddDB(FB, get, 216495, 15, coin, color)
        AddDB(FB, get, 216496, 10, coin, color)
        AddDB(FB, get, 216497, 15, coin, color)
        AddDB(FB, get, 216498, 5, coin, color)
        AddDB(FB, get, 216499, 15, coin, color)
        AddDB(FB, get, 216500, 5, coin, color)
        AddDB(FB, get, 216501, 5, coin, color)
        AddDB(FB, get, 216502, 15, coin, color)
        AddDB(FB, get, 216503, 5, coin, color)
        AddDB(FB, get, 216615, 5, coin, color)
        AddDB(FB, get, 216504, 15, coin, color)
        AddDB(FB, get, 216505, 5, coin, color)
        AddDB(FB, get, 216506, 15, coin, color)
        AddDB(FB, get, 216607, 5, coin, color)
        AddDB(FB, get, 216507, 5, coin, color)
        AddDB(FB, get, 216508, 5, coin, color)
        AddDB(FB, get, 216509, 5, coin, color)
        AddDB(FB, get, 216510, 5, coin, color)
        AddDB(FB, get, 216511, 5, coin, color)
        AddDB(FB, get, 216512, 5, coin, color)
        AddDB(FB, get, 216513, 5, coin, color)
        AddDB(FB, get, 216516, 5, coin, color)
        AddDB(FB, get, 216517, 5, coin, color)
        AddDB(FB, get, 216518, 5, coin, color)
        AddDB(FB, get, 216519, 5, coin, color)
        AddDB(FB, get, 216520, 10, coin, color)
        AddDB(FB, get, 216521, 5, coin, color)
        AddDB(FB, get, 216522, 5, coin, color)

        -- P3
        local FB = "Temple"
        local get = L["荆棘谷 血月活动"]
        local coin = 237282
        local color = "FF6347"
        AddDB(FB, get, 221447, 15, coin, color)
        AddDB(FB, get, 221446, 25, coin, color)
        AddDB(FB, get, 221448, 15, coin, color)
        AddDB(FB, get, 221450, 25, coin, color)
        AddDB(FB, get, 221451, 25, coin, color)
        AddDB(FB, get, 221452, 15, coin, color)
        AddDB(FB, get, 221453, 15, coin, color)
        AddDB(FB, get, 221454, 15, coin, color)
        AddDB(FB, get, 221457, 15, coin, color)
        AddDB(FB, get, 221455, 15, coin, color)
        AddDB(FB, get, 221456, 25, coin, color)
        AddDB(FB, get, 220173, 25, coin, color)
        AddDB(FB, get, 221459, 15, coin, color)
        AddDB(FB, get, 221458, 15, coin, color)
        AddDB(FB, get, 221460, 25, coin, color)
        AddDB(FB, get, 221462, 25, coin, color)
        AddDB(FB, get, 221465, 25, coin, color)
        AddDB(FB, get, 221464, 15, coin, color)
        AddDB(FB, get, 221463, 15, coin, color)
        AddDB(FB, get, 221466, 15, coin, color)
        AddDB(FB, get, 221467, 15, coin, color)
        AddDB(FB, get, 221469, 25, coin, color)
        AddDB(FB, get, 221468, 15, coin, color)
    end
    -- 荒野祭品
    do
        local FB = "Temple"
        local get = L["费伍德 影牙使者"]
        local coin = 132119
        local color = "98FB98"
        AddDB(FB, get, 223192, 15, coin, color)
        AddDB(FB, get, 223193, 15, coin, color)
        AddDB(FB, get, 223194, 12, coin, color)
        AddDB(FB, get, 223195, 12, coin, color)
        AddDB(FB, get, 223196, 15, coin, color)
        AddDB(FB, get, 223197, 12, coin, color)
    end
    -- 马戏团
    do
        -- P3
        local FB = "Temple"
        local get = L["暗月马戏团"]
        local coin = 132119
        local color = "7B68EE"
        AddDB(FB, get, 221309, 221289, nil, color, 1)
        AddDB(FB, get, 221307, 221280, nil, color, 1)
        AddDB(FB, get, 221308, 221272, nil, color, 1)
        AddDB(FB, get, 221310, 221299, nil, color, 1)
    end
    -- 褪色的安德麦雷亚尔
    do
        local FB = "MCsod"
        local get = L["褪色的安德麦雷亚尔"]
        local coin = 133799
        local color = "98FB98"
        AddDB(FB, get, 231996, 50, coin, color)
        AddDB(FB, get, 232454, 5, coin, color)
        AddDB(FB, get, 232455, 5, coin, color)
        AddDB(FB, get, 232456, 5, coin, color)
        AddDB(FB, get, 232457, 5, coin, color)
        AddDB(FB, get, 232390, 25, coin, color)
        AddDB(FB, get, 232391, 25, coin, color)
        AddDB(FB, get, 232423, 25, coin, color)
        AddDB(FB, get, 232424, 25, coin, color)
        AddDB(FB, get, 231811, 25, coin, color)
        AddDB(FB, get, 232389, 25, coin, color)
        AddDB(FB, get, 232420, 25, coin, color)
        AddDB(FB, get, 232421, 25, coin, color)
        AddDB(FB, get, 232392, 25, coin, color)
        AddDB(FB, get, 232409, 25, coin, color)
        AddDB(FB, get, 232416, 25, coin, color)
        AddDB(FB, get, 232419, 25, coin, color)
        AddDB(FB, get, 226405, 5, coin, color)
        AddDB(FB, get, 227284, 50, coin, color)
        AddDB(FB, get, 227279, 50, coin, color)
        AddDB(FB, get, 227280, 50, coin, color)
        AddDB(FB, get, 227282, 50, coin, color)
        AddDB(FB, get, 228432, 50, coin, color)
        AddDB(FB, get, 228168, 50, coin, color)
        AddDB(FB, get, 228169, 50, coin, color)
        AddDB(FB, get, 228170, 50, coin, color)
        AddDB(FB, get, 228185, 50, coin, color)
        AddDB(FB, get, 228184, 25, coin, color)
        AddDB(FB, get, 228186, 25, coin, color)
        AddDB(FB, get, 228187, 50, coin, color)
        AddDB(FB, get, 228189, 25, coin, color)
        AddDB(FB, get, 228173, 15, coin, color)
        AddDB(FB, get, 228174, 15, coin, color)
        AddDB(FB, get, 228175, 15, coin, color)
        AddDB(FB, get, 228176, 15, coin, color)
        AddDB(FB, get, 228177, 15, coin, color)
        AddDB(FB, get, 228178, 15, coin, color)
        AddDB(FB, get, 228179, 15, coin, color)
        AddDB(FB, get, 228180, 15, coin, color)
        AddDB(FB, get, 228181, 15, coin, color)
        AddDB(FB, get, 228182, 15, coin, color)
        AddDB(FB, get, 228183, 15, coin, color)
        AddDB(FB, get, 227990, 50, coin, color)
        AddDB(FB, get, 228171, 25, coin, color)
        AddDB(FB, get, 228121, 50, coin, color)
        AddDB(FB, get, 13518, 50, coin, color)
        AddDB(FB, get, 13519, 50, coin, color)
        AddDB(FB, get, 13520, 50, coin, color)
        AddDB(FB, get, 13521, 50, coin, color)
        AddDB(FB, get, 13522, 50, coin, color)
        AddDB(FB, get, 17011, 15, coin, color)
        AddDB(FB, get, 17010, 15, coin, color)
        AddDB(FB, get, 17012, 10, coin, color)
        AddDB(FB, get, 220597, 50, coin, color)
        AddDB(FB, get, 220598, 50, coin, color)
        AddDB(FB, get, 220599, 50, coin, color)
        -- AddDB(FB, get,  , coin, color)
        -- AddDB(FB, get,  , coin, color)

        local FB = "BWLsod"
        local get = L["褪色的安德麦雷亚尔"]
        local coin = 133799
        local color = "98FB98"
        AddDB(FB, get, 231207, 125, coin, color)
        AddDB(FB, get, 231215, 125, coin, color)
        AddDB(FB, get, 231174, 125, coin, color)
        AddDB(FB, get, 231199, 125, coin, color)
        AddDB(FB, get, 231223, 125, coin, color)
        AddDB(FB, get, 231182, 125, coin, color)
        AddDB(FB, get, 231190, 125, coin, color)
        AddDB(FB, get, 231055, 125, coin, color)
        AddDB(FB, get, 231063, 125, coin, color)
        AddDB(FB, get, 231031, 125, coin, color)
        AddDB(FB, get, 231253, 125, coin, color)
        AddDB(FB, get, 231023, 125, coin, color)
        AddDB(FB, get, 231237, 125, coin, color)
        AddDB(FB, get, 231245, 125, coin, color)
        AddDB(FB, get, 231261, 125, coin, color)
        AddDB(FB, get, 231046, 125, coin, color)
        AddDB(FB, get, 231054, 125, coin, color)
        AddDB(FB, get, 231079, 125, coin, color)
        AddDB(FB, get, 231172, 125, coin, color)
        AddDB(FB, get, 231098, 125, coin, color)
        AddDB(FB, get, 231162, 125, coin, color)
        AddDB(FB, get, 231107, 125, coin, color)
        AddDB(FB, get, 231115, 125, coin, color)
    end
end


function BG.SortLootItem(items)
    print("原来：" .. #items)
    local sortItems = {}
    local qualityTbl = {
        quality2 = {},
        quality3 = {},
        quality4 = {},
        quality5 = {},
    }
    for i = #items, 1, -1 do
        local item = items[i]
        local name, link, quality, level, _, _, _, _, EquipLoc, Texture, _, typeID, subclassID = GetItemInfo(item)
        if EquipLoc == "INVTYPE_NON_EQUIP_IGNORE" then
            tinsert(sortItems, item)
            tremove(items, i)
        end
    end
    for ii = 2, 5 do
        for i = #items, 1, -1 do
            local item = items[i]
            local name, link, quality, level, _, _, _, _, EquipLoc, Texture, _, typeID, subclassID = GetItemInfo(item)
            if quality == ii then
                tinsert(qualityTbl["quality" .. ii], item)
                tremove(items, i)
            end
        end

        sort(qualityTbl["quality" .. ii], function(a, b)
            local name, link, quality, level, _, _, _, _, a_EquipLoc, Texture, _, typeID, subclassID = GetItemInfo(a)
            local name, link, quality, level, _, _, _, _, b_EquipLoc, Texture, _, typeID, subclassID = GetItemInfo(b)
            return a_EquipLoc > b_EquipLoc
        end)

        for i = 1, #qualityTbl["quality" .. ii] do
            local item = qualityTbl["quality" .. ii][i]
            tinsert(sortItems, item)
        end
    end
    local text = ""
    for i, item in ipairs(sortItems) do
        text = text .. item .. ","
    end
    print("现在：" .. #sortItems)
    print(text)
    BG.After(0.1, function()
        ChatFrame1EditBox:Show()
        ChatFrame1EditBox:SetText(text)
        ChatFrame1EditBox:HighlightText()
        ChatFrame1EditBox:SetFocus()
    end)


    --[[     for ii = 2, 5 do
        for i = 1, #qualityTbl["quality"..ii] do

            for i = #qualityTbl["quality"..ii], 1, -1 do
                local item = qualityTbl["quality"..ii][i]
                local name, link, quality, level, _, _, _, _, EquipLoc, Texture, _, typeID, subclassID = GetItemInfo(item)
                if EquipLoc == "INVTYPE_HEAD" then
                    tinsert(sortItems, item)
                    tremove(qualityTbl["quality"..ii], i)
                -- elseif EquipLoc == "INVTYPE_HEAD" then

                end
            end
        end
    end ]]
end

-- 模板
--[[
    local FB = "BWLsod"
    do
        BG.Loot[FB].N.boss1 = { }
        BG.Loot[FB].N.boss2 = { }
        BG.Loot[FB].N.boss3 = { }
        BG.Loot[FB].N.boss4 = { }
        BG.Loot[FB].N.boss5 = { }
        BG.Loot[FB].N.boss6 = { }
        BG.Loot[FB].N.boss7 = { }
        BG.Loot[FB].N.boss8 = { }
        BG.Loot[FB].N.boss9 = { }
        BG.Loot[FB].N.boss10 = { }
        BG.Loot[FB].N.boss1other = { }
        BG.Loot[FB].N.boss2other = { }
        BG.Loot[FB].N.boss3other = { }
        BG.Loot[FB].N.boss4other = { }
        BG.Loot[FB].N.boss5other = { }
        BG.Loot[FB].N.boss6other = { }
        BG.Loot[FB].N.boss7other = { }
        BG.Loot[FB].N.boss8other = { }
        BG.Loot[FB].N.boss9other = { }
        BG.Loot[FB].N.boss10other = { }
        -- 兑换物
        BG.Loot[FB].ExchangeItems = {
            -- [ ] = {  },
            -- [ ] = {  },
            -- [ ] = {  },
        }

    end
]]

--[[
--世界BOSS和黑龙
17113,
228356,
19135,
228357,
17111,
228354,
18204,
228360,
19134,
228355,
18546,
228353,
18543,
228359,
18202,
228349,
17070,
228382,
18545,
228345,
18541,
228383,
18542,
228347,
18205,
228759,
17064,
228298,
18403,
228687,
18406,
228686,
18404,
228685,

MC
17077,
228262,
18879,
228242,
18870,
228285,
18872,
228244,
19147,
228243,
19145,
228239,
18878,
228263,
19146,
228246,
18861,
228240,
18823,
228257,
18829,
228258,
19142,
228259,
19143,
228260,
18824,
228254,
19136,
228256,
18822,
228229,
18821,
228261,
19144,
228253,
18820,
228255,
17109,
228247,
17073,
228248,
18203,
228350,
17065,
228249,
17069,
228252,
17105,
228264,
18832,
228265,
17066,
228266,
17071,
228267,
17110,
228268,
17103,
228269,
17072,
228270,
18842,
228271,
17074,
228272,
18806,
228275,
18805,
228277,
19140,
228274,
19139,
228279,
18811,
228280,
18808,
228281,
18803,
228278,
18809,
228282,
18810,
228283,
18812,
228284,
17063,
228286,
19138,
228287,
17076,
228288,
17102,
228290,
18817,
228291,
17107,
228292,
18815,
228293,
17106,
228294,
19137,
228295,
18816,
228296,
17082,
228297,
17104,
228299,


for _,v in ipairs(t) do
    for ii,id in ipairs(v) do
        for i=1,#tbl,2 do
            if tbl[i] and id==tbl[i] then
                v[ii]=tbl[i+1]
            end
        end
    end
end

local text="\n"
for _,v in ipairs(t) do
    local text2="{"
    for i,id in ipairs(v) do
        text2=text2..id..","
    end
    text2=text2.."}\n"
    text=text..text2
end
print(text)
]]
--[[
tbl=
{
12936,
228651,
12583,
228603,
12592,
228606,
12966,
228662,
12963,
228660,
12967,
228663,
13142,
228670,
12588,
228605,
12606,
228579,
12940,
228653,
12939,
228652,
22268,
228678,
12589,
228578,
12929,
228584,
12587,
228604,
12590,
228757,
18104,
228676,
18047,
228602,
12968,
228664,
13502,
228672,
22311,
228597,
22302,
228681,
22335,
228682,
13098,
228667,
22340,
228684,
22339,
228683,
12969,
228666,
22267,
228677,
12605,
227942,
12604,
228566,
13141,
228669,
12927,
228583,
12964,
228661,
12935,
228650,
13260,
228593,
12637,
228568,
12651,
228559,
13179,
228572,
12608,
228556,
13148,
228586,
12634,
228567,
13257,
228562,
13181,
228554,
13218,
228592,
13167,
228570,
12626,
228558,
13244,
228577,
13261,
228563,
13164,
228589,
22313,
228598,
22306,
228596,
22231,
228594,
13283,
228565,
13143,
228585,
22232,
228595,
13282,
228564,
13182,
228555,
13168,
228571,
13162,
228588,
13163,
228601,
13205,
228591,
13211,
228575,
13213,
228576,
13185,
228590,
13284,
228557,
13177,
228574,
22322,
228600,
13161,
228587,
13255,
228561,
13183,
228573,
13314,
228023,
22326,
228047,
18680,
227996,
14541,
227997,
22332,
228028,
14539,
228032,
13956,
228005,
18697,
228703,
14543,
228031,
18692,
227992,
14503,
228036,
13950,
228042,
18684,
228016,
22433,
228046,
14576,
227993,
14024,
228015,
14531,
227994,
13957,
228007,
14545,
228040,
13983,
228029,
22333,
228033,
13937,
228022,
13960,
228019,
13952,
228027,
22303,
228038,
23132,
228026,
14522,
228044,
18759,
228030,
18760,
228045,
14528,
228037,
18693,
228034,
14577,
228017,
18695,
228039,
13955,
228001,
18698,
228704,
13944,
228025,
13967,
228004,
13964,
228021,
18690,
228041,
14614,
228014,
14616,
227998,
14615,
228020,
14611,
228012,
14612,
228003,
14624,
228000,
14622,
228006,
14620,
228002,
14623,
228008,
14621,
227999,
14631,
228009,
14629,
228011,
14632,
228018,
14633,
228010,
14626,
228013,
11816,
227948,
11922,
227963,
11832,
227972,
11812,
227970,
11808,
227973,
11926,
227956,
11931,
227981,
11809,
227934,
11925,
227958,
11932,
227982,
11815,
228722,
11933,
227988,
11921,
227960,
11684,
227991,
22305,
228700,
22208,
227974,
11927,
227959,
11823,
227964,
11817,
227940,
11814,
227971,
11935,
227978,
11822,
227965,
11924,
227980,
22207,
227987,
11819,
227967,
11928,
227984,
11930,
227985,
11920,
227941,
22204,
227986,
18387,
228061,
18757,
228475,
18392,
228472,
18397,
228067,
18380,
228069,
18378,
228470,
18388,
228471,
18390,
228468,
18393,
228063,
18312,
228055,
18319,
228053,
18310,
228056,
22304,
228066,
18311,
228051,
18314,
228699,
18315,
228057,
18323,
228050,
18317,
228054,
18324,
228052,
18520,
228478,
18493,
228058,
18526,
228480,
18528,
228065,
18494,
228059,
18496,
228060,
18490,
228062,
18524,
228479,
18532,
228474,
18505,
228068,
18485,
228064,
18530,
228070,
18534,
228484,
18500,
228469,
18538,
228486,
18531,
228473,
18472,
228467,
18468,
228466,
18466,
228465,
18465,
228464,
18737,
228535,
13353,
228539,
13382,
228523,
18739,
228530,
13359,
228540,
13344,
228537,
22410,
228552,
13360,
228541,
18718,
228545,
13403,
228515,
18717,
228544,
22411,
228553,
22301,
228547,
18726,
228518,
13404,
228500,
18741,
228532,
22403,
228533,
18725,
228516,
18736,
228534,
13384,
228504,
13376,
228505,
13505,
228543,
22329,
228548,
13345,
228538,
18730,
228521,
18720,
228546,
13361,
228542,
13378,
228501,
13374,
228520,
12103,
228536,
13390,
228528,
13392,
228524,
13391,
228529,
13389,
228527,
13388,
228525,
18740,
228531,
13402,
228514,
22409,
228551,
13400,
228513,
13380,
228522,
13383,
228503,
16706,
226715,
16715,
226713,
16717,
226711,
16720,
226708,
16719,
226709,
16718,
226710,
16716,
226712,
16714,
226714,
16674,
226723,
16675,
226722,
16676,
226721,
16677,
226720,
16678,
226719,
16679,
226716,
16680,
226718,
16681,
226717,
16688,
226729,
16682,
226730,
16684,
226731,
16686,
226728,
16687,
226727,
16689,
226726,
16685,
226724,
16683,
226725,
16726,
226734,
16725,
226738,
16724,
226737,
16727,
226733,
16728,
226736,
16729,
226735,
16723,
226732,
16722,
226739,
16690,
226745,
16691,
226743,
16692,
226740,
16693,
226746,
16694,
226747,
16695,
226741,
16696,
226744,
16697,
226742,
16721,
226700,
16711,
226703,
16712,
226702,
16707,
226707,
16709,
226705,
16708,
226706,
16713,
226701,
16710,
226704,
16666,
226749,
16670,
226752,
16672,
226748,
16667,
226755,
16668,
226750,
16669,
226753,
16673,
226754,
16671,
226751,
16700,
226757,
16704,
226763,
16705,
226758,
16698,
226762,
16699,
226760,
16701,
226756,
16702,
226761,
16703,
226759,
16730,
226770,
16734,
226764,
16737,
226771,
16731,
226769,
16732,
226767,
16733,
226768,
16736,
226765,
16735,
226766,
}

t={
{ 13181, 13182, },
{ 12608, 13286, },
{ 16670, 13166, 13168, 13170, 13169, 13167, },
{ 13284, 13285, },
{ 13282, 13283, 13261, },
{ 16712, 13257, 12626, 13255, 12653, 12651, 12654, },
{ 16676, 13177, 13179, 22231, 13173, 12582, },
{ 12637, 12634, 12621, 12838, },
{ 16715, 13244, 13213, 13183, },
{ 13185, 13184, 13218, },
{ 13258, 22232, 13259, 13178, 18784, },
{ 13253, 13252, 12835, },
{ 13212, 22313, 13211, 13210, },
{ 16718, 13208, 13206, 13205, },
{ 13203, 13198, 13204, },
{ 13143, 16679, 13162, 13164, 22321, 13163, 13148, 13161, },
{ 22306, 22325, 22319, 22398, 22322, },
{ 16696, 16685, 16683, 16703, 16713, 16716, 16680, 16673, 16736, 16735, },
}

for _,v in ipairs(t) do
    for ii,id in ipairs(v) do
        for i=1,#tbl,2 do
            if tbl[i] and id==tbl[i] then
                v[ii]=tbl[i+1]
            end
        end
    end
end

local text="\n"
for _,v in ipairs(t) do
    local text2="{"
    for i,id in ipairs(v) do
        text2=text2..id..","
    end
    text2=text2.."},\n"
    text=text..text2
end
print(text)
 ]]

-- 专业
--[[
11604,
227871,
17013,
227836,
20039,
227841,
19164,
227835,
16988,
227834,
16989,
227827,
19148,
227824,
17014,
227820,
12632,
227870,
12636,
227872,
12641,
227876,
12639,
227885,
19059,
227888,
12625,
227859,
19057,
227817,
19051,
227814,
19048,
227810,
19043,
227807,
17193,
227684,
12776,
227880,
12781,
227881,
12783,
227884,
12794,
227886,
12797,
227887,
12790,
228125,
12796,
227858,
12782,
227857,
22383,
227850,
19170,
227842,
19168,
227840,
19166,
227832,
17015,
227826,
17016,
227825,
12784,
227845,
18282,
227849,
18509,
227869,
15049,
227873,
20295,
227874,
15048,
227875,
15046,
227877,
20296,
227878,
15045,
227879,
18504,
227882,
18508,
227883,
19047,
228190,
18511,
227854,
15052,
227852,
15063,
227848,
15062,
227847,
19157,
227838,
19058,
227818,
19052,
227815,
19049,
227809,
19044,
227805,
15065,
227804,
15064,
227803,
15055,
227866,
15054,
227867,
15053,
227868,
15051,
227853,
15050,
227851,
19162,
227837,
16984,
227829,
19149,
227828,
16982,
227822,
16983,
227821,
14138,
227860,
18486,
227861,
15802,
227862,
14140,
227863,
14137,
227864,
18405,
228476,
19165,
227839,
19156,
227831,
16980,
227830,
16979,
227823,
19056,
227816,
19050,
227808,
 ]]
