local _, ADDONSELF = ...
local L = ADDONSELF.L
local RegEvent = ADDONSELF.regevent


ADDONSELF.Print = function(msg)
    DEFAULT_CHAT_FRAME:AddMessage("|CFFFF0000<|r|CFFFFD100BattleInfo|r|CFFFF0000>|r"..(msg or "nil"))
end

ADDONSELF.CLASS_LOC = {}
FillLocalizedClassList(ADDONSELF.CLASS_LOC)

local BattleZoneHelper = {}
ADDONSELF.BattleZoneHelper = BattleZoneHelper

BattleZoneHelper.IsBCC = (_G.WOW_PROJECT_ID == _G.WOW_PROJECT_BURNING_CRUSADE_CLASSIC)

local function GetMapInfoSafe (id)
    local info = C_Map.GetMapInfo(id)
    if info then
        return info.name
    end
    
    return ""
end

BattleZoneHelper.MAPID_ALTERAC = 1459
BattleZoneHelper.MAPNAME_ALTERAC = GetMapInfoSafe(BattleZoneHelper.MAPID_ALTERAC)

BattleZoneHelper.MAPID_WARSONG = 1460
BattleZoneHelper.MAPNAME_WARSONG = GetMapInfoSafe(BattleZoneHelper.MAPID_WARSONG)

BattleZoneHelper.MAPID_ARATHI = 1461
BattleZoneHelper.MAPNAME_ARATHI = GetMapInfoSafe(BattleZoneHelper.MAPID_ARATHI)

BattleZoneHelper.MAPID_STORM = 1956
BattleZoneHelper.MAPNAME_STORM = GetMapInfoSafe(BattleZoneHelper.MAPID_STORM)

BattleZoneHelper.MAPID_STRAND = 128
BattleZoneHelper.MAPNAME_STRAND = GetMapInfoSafe(BattleZoneHelper.MAPID_STRAND)

BattleZoneHelper.MAPID_CONQUEST = 169
BattleZoneHelper.MAPNAME_CONQUEST = GetMapInfoSafe(BattleZoneHelper.MAPID_CONQUEST)

-- ( 1 for Alterac Valley, 2 for Warsong Gulch, 3 for Arathi Basin, 4 for Eye of the Storm, 5 for Strand of the Ancients, 6 for Isle of Conquest
BattleZoneHelper.BGID_ALTERAC = 1
BattleZoneHelper.BGID_WARSONG = 2
BattleZoneHelper.BGID_ARATHI = 3
BattleZoneHelper.BGID_STORM = 4
BattleZoneHelper.BGID_STRAND = 5
BattleZoneHelper.BGID_CONQUEST = 6

BattleZoneHelper.BGID_MAPNAME_MAP = {
    [BattleZoneHelper.BGID_ALTERAC] = BattleZoneHelper.MAPNAME_ALTERAC,
    [BattleZoneHelper.BGID_WARSONG] = BattleZoneHelper.MAPNAME_WARSONG, 
    [BattleZoneHelper.BGID_ARATHI]  = BattleZoneHelper.MAPNAME_ARATHI,
    [BattleZoneHelper.BGID_STORM] = BattleZoneHelper.MAPNAME_STORM,
    [BattleZoneHelper.BGID_STRAND] = BattleZoneHelper.MAPNAME_STRAND,
    [BattleZoneHelper.BGID_CONQUEST] = BattleZoneHelper.MAPNAME_CONQUEST,
}

BattleZoneHelper.MAPNAME_BGID_MAP = {
    [BattleZoneHelper.MAPNAME_ALTERAC] = BattleZoneHelper.BGID_ALTERAC,
    [BattleZoneHelper.MAPNAME_WARSONG] = BattleZoneHelper.BGID_WARSONG,
    [BattleZoneHelper.MAPNAME_ARATHI]  = BattleZoneHelper.BGID_ARATHI,
    [BattleZoneHelper.MAPNAME_STORM] = BattleZoneHelper.BGID_STORM,
    [BattleZoneHelper.MAPNAME_STRAND] = BattleZoneHelper.BGID_STRAND,
    [BattleZoneHelper.MAPNAME_CONQUEST] = BattleZoneHelper.BGID_CONQUEST,
}



ADDONSELF.InBattleground = function()
    -- return true
    return BattleZoneHelper.MAPNAME_BGID_MAP[GetRealZoneText()]
end

-- Alliance Tower 10
-- Alliance Tower Half 8
-- Alliance Graveyard 14
-- Alliance Graveyard Half 3

-- Horde Tower 9
-- Horde Tower Half 11
-- Horde Graveyard 12
-- Horde Graveyard Half 13
-- BattleZoneHelper.POI_ALLIANCE_TOWER = 10
-- BattleZoneHelper.POI_ALLIANCE_TOWER_HALF = 8
-- BattleZoneHelper.POI_ALLIANCE_GRAVEYARD = 14
-- BattleZoneHelper.POI_ALLIANCE_GRAVEYARD_HALF = 3

-- BattleZoneHelper.POI_HORDE_TOWER = 9
-- BattleZoneHelper.POI_HORDE_TOWER_HALF = 11
-- BattleZoneHelper.POI_HORDE_GRAVEYARD = 12
-- BattleZoneHelper.POI_HORDE_GRAVEYARD_HALF = 13


function BattleZoneHelper:IsInAlterac()
    return GetRealZoneText() == self.MAPNAME_ALTERAC
end

function BattleZoneHelper:IsInWarsong()
    return GetRealZoneText() == self.MAPNAME_WARSONG
end

function BattleZoneHelper:GetCurrentBG()

    for i=1, MAX_BATTLEFIELD_QUEUES do
        local status, mapName, instanceID = GetBattlefieldStatus(i);

        if status == "active" then
            return self.MAPNAME_BGID_MAP[mapName], instanceID
        end
    end
end

-- function BattleZoneHelper:GetAlteracPOI()
--     local data = {}

--     local areaPOIs = C_AreaPoiInfo.GetAreaPOIForMap(BattleZoneHelper.MAPID_ALTERAC)
--     local textures = C_Map.GetMapArtLayerTextures(BattleZoneHelper.MAPID_ALTERAC, 1) -- 1 for layer id, should be a const value

-- 	for _, areaPoiID in ipairs(areaPOIs) do
-- 		local poiInfo = C_AreaPoiInfo.GetAreaPOIInfo(BattleZoneHelper.MAPID_ALTERAC, areaPoiID)
--         if poiInfo then
--             local t = poiInfo.textureIndex

--             if not data[t] then
--                 data[t] = 0
--             end

--             data[t] = data[t] + 1
-- 		end
--     end

--     return data
-- end

-- RegEvent("ADDON_LOADED", function()
    -- ADDONSELF.Print(L["BattleInfo Loaded"])
-- end)
